/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.web.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.directory.api.util.Strings;
import org.apache.directory.fortress.core.ReviewMgr;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.model.OrgUnit;
import org.apache.directory.fortress.core.model.PermObj;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.web.model.SerializableList;
import org.apache.wicket.injection.Injector;
import org.apache.wicket.model.Model;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectListModel
extends Model<SerializableList<PermObj>> {
    private static final long serialVersionUID = 1L;
    @SpringBean
    private ReviewMgr reviewMgr;
    private static final Logger LOG = LoggerFactory.getLogger((String)ObjectListModel.class.getName());
    private PermObj permObj;
    private SerializableList<PermObj> permObjs = null;
    private boolean isAdmin;

    public ObjectListModel(boolean isAdmin, Session session) {
        Injector.get().inject((Object)this);
        this.isAdmin = isAdmin;
        if (Config.getInstance().getBoolean("is.arbac02")) {
            this.reviewMgr.setAdmin(session);
        }
    }

    public ObjectListModel(PermObj permObj, boolean isAdmin, Session session) {
        Injector.get().inject((Object)this);
        this.permObj = permObj;
        this.isAdmin = isAdmin;
        if (Config.getInstance().getBoolean("is.arbac02")) {
            this.reviewMgr.setAdmin(session);
        }
    }

    public SerializableList<PermObj> getObject() {
        if (this.permObjs != null) {
            LOG.debug(".getObject count: " + this.permObjs.size());
            return this.permObjs;
        }
        if (this.permObj == null) {
            LOG.debug(".getObject null");
            this.permObjs = new SerializableList(new ArrayList());
        } else {
            LOG.debug(".getObject userId: " + this.permObj.getObjName());
            this.permObjs = new SerializableList(this.getList(this.permObj));
        }
        return this.permObjs;
    }

    public void setObject(SerializableList<PermObj> object) {
        LOG.debug(".setObject count: " + object.size());
        this.permObjs = object;
    }

    public void detach() {
        this.permObjs = null;
        this.permObj = null;
    }

    public List<PermObj> getList(PermObj permObj) {
        List permObjList = null;
        try {
            LOG.debug(".getList permObjectName:" + permObj.getObjName());
            String ou = permObj.getOu();
            if (Strings.isEmpty((String)ou)) {
                if (this.isAdmin) {
                    permObj.setAdmin(true);
                }
                permObjList = this.reviewMgr.findPermObjs(permObj);
            } else {
                permObjList = this.reviewMgr.findPermObjs(new OrgUnit(ou));
            }
            if (CollectionUtils.isNotEmpty((Collection)permObjList)) {
                Collections.sort(permObjList, new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        catch (SecurityException se) {
            String error = ".getList caught SecurityException=" + se;
            throw new RuntimeException(error, se);
        }
        return permObjList;
    }
}

