/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.web.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.directory.fortress.core.AuditMgr;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.model.Bind;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.core.model.UserAudit;
import org.apache.directory.fortress.core.util.Config;
import org.apache.directory.fortress.web.model.SerializableList;
import org.apache.wicket.injection.Injector;
import org.apache.wicket.model.Model;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditBindListModel
extends Model<SerializableList<Bind>> {
    private static final long serialVersionUID = 1L;
    @SpringBean
    private AuditMgr auditMgr;
    private static final Logger LOG = LoggerFactory.getLogger((String)AuditBindListModel.class.getName());
    private UserAudit userAudit;
    private SerializableList<Bind> binds = null;

    public AuditBindListModel(Session session) {
        Injector.get().inject((Object)this);
        if (Config.getInstance().getBoolean("is.arbac02")) {
            this.auditMgr.setAdmin(session);
        }
    }

    public AuditBindListModel(UserAudit userAudit, Session session) {
        Injector.get().inject((Object)this);
        this.userAudit = userAudit;
        if (Config.getInstance().getBoolean("is.arbac02")) {
            this.auditMgr.setAdmin(session);
        }
    }

    public SerializableList<Bind> getObject() {
        if (this.binds != null) {
            LOG.debug(".getObject count: " + this.binds.size());
            return this.binds;
        }
        if (this.userAudit == null || !StringUtils.isNotEmpty((String)this.userAudit.getUserId()) && this.userAudit.getBeginDate() == null && this.userAudit.getEndDate() == null) {
            LOG.debug(".getObject null");
            this.binds = new SerializableList(new ArrayList());
        } else {
            this.binds = new SerializableList(this.getList(this.userAudit));
        }
        return this.binds;
    }

    public void setObject(SerializableList<Bind> object) {
        LOG.debug(".setObject count: " + object.size());
        this.binds = object;
    }

    public void detach() {
        this.binds = null;
        this.userAudit = null;
    }

    private List<Bind> getList(UserAudit userAudit) {
        List bindList = null;
        try {
            bindList = this.auditMgr.searchBinds(userAudit);
        }
        catch (SecurityException se) {
            String error = ".getList caught SecurityException=" + se;
            throw new RuntimeException(error, se);
        }
        return bindList;
    }
}

