/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.web;

import com.googlecode.wicket.kendo.ui.widget.splitter.IBorderLayout;
import com.googlecode.wicket.kendo.ui.widget.splitter.ISplitterListener;
import com.googlecode.wicket.kendo.ui.widget.splitter.SplitterAdapter;
import com.googlecode.wicket.kendo.ui.widget.splitter.SplitterBehavior;
import org.apache.directory.fortress.core.util.Config;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;

public class FourWaySplitter
implements IBorderLayout {
    private String listPercentage;
    private String detailPercentage;

    public FourWaySplitter() {
        this.init("64", "36");
    }

    public FourWaySplitter(String listPercentage, String detailPercentage) {
        this.init(listPercentage, detailPercentage);
    }

    private void init(String listPercentage, String detailPercentage) {
        this.listPercentage = listPercentage;
        this.detailPercentage = detailPercentage;
    }

    public void addBorderLayout(MarkupContainer container) {
        SplitterBehavior vertical = new SplitterBehavior("#vertical", (ISplitterListener)new SplitterAdapter());
        vertical.setOption("panes", (Object)this.getVerticalPanes()).setOption("orientation", (Object)"'vertical'");
        container.add(new Behavior[]{vertical});
        SplitterBehavior horizontal = new SplitterBehavior("#horizontal", (ISplitterListener)new SplitterAdapter());
        horizontal.setOption("panes", (Object)this.getHorizontalPanes());
        container.add(new Behavior[]{horizontal});
    }

    public String getVerticalPanes() {
        return "[ { collapsible: true, size: '80%' }, { collapsible: true, size: '5%'} ]";
    }

    public String getHorizontalPanes() {
        String szValue = "[ { collapsible: true, resizable: false, size: '85px', min: '85x', max: '85px', collapsed: true }, { collapsible: true, size: '" + this.listPercentage + "%' }, { collapsible: true, size: '" + this.detailPercentage + "%'} ]";
        if (Config.getInstance().getProperty("enable.nav.panel") != null && Config.getInstance().getProperty("enable.nav.panel").equalsIgnoreCase("true")) {
            szValue = "[ { collapsible: true, resizable: false, size: '85px', min: '85x', max: '85px' }, { collapsible: true, size: '" + this.listPercentage + "%' }, { collapsible: true, size: '" + this.detailPercentage + "%'} ]";
        }
        return szValue;
    }
}

