/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.rest;

import java.util.List;
import org.apache.directory.fortress.core.PwPolicyMgr;
import org.apache.directory.fortress.core.PwPolicyMgrFactory;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.model.FortEntity;
import org.apache.directory.fortress.core.model.FortRequest;
import org.apache.directory.fortress.core.model.FortResponse;
import org.apache.directory.fortress.core.model.PwPolicy;
import org.apache.directory.fortress.rest.AbstractMgrImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PswdPolicyMgrImpl
extends AbstractMgrImpl {
    private static final Logger LOG = LoggerFactory.getLogger((String)PswdPolicyMgrImpl.class.getName());

    PswdPolicyMgrImpl() {
    }

    FortResponse addPolicy(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            PwPolicy inPolicy = (PwPolicy)request.getEntity();
            PwPolicyMgr policyMgr = PwPolicyMgrFactory.createInstance((String)request.getContextId());
            policyMgr.setAdmin(request.getSession());
            policyMgr.add(inPolicy);
            response.setEntity((FortEntity)inPolicy);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse updatePolicy(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            PwPolicy inPolicy = (PwPolicy)request.getEntity();
            PwPolicyMgr policyMgr = PwPolicyMgrFactory.createInstance((String)request.getContextId());
            policyMgr.setAdmin(request.getSession());
            policyMgr.update(inPolicy);
            response.setEntity((FortEntity)inPolicy);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse deletePolicy(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            PwPolicy inPolicy = (PwPolicy)request.getEntity();
            PwPolicyMgr policyMgr = PwPolicyMgrFactory.createInstance((String)request.getContextId());
            policyMgr.setAdmin(request.getSession());
            policyMgr.delete(inPolicy);
            response.setEntity((FortEntity)inPolicy);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse readPolicy(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            PwPolicy inPolicy = (PwPolicy)request.getEntity();
            PwPolicyMgr policyMgr = PwPolicyMgrFactory.createInstance((String)request.getContextId());
            policyMgr.setAdmin(request.getSession());
            PwPolicy outPolicy = policyMgr.read(inPolicy.getName());
            response.setEntity((FortEntity)outPolicy);
        }
        catch (SecurityException se) {
            response.setErrorCode(se.getErrorId());
            response.setErrorMessage(se.getMessage());
        }
        return response;
    }

    FortResponse searchPolicy(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            PwPolicy inPolicy = (PwPolicy)request.getEntity();
            PwPolicyMgr policyMgr = PwPolicyMgrFactory.createInstance((String)request.getContextId());
            policyMgr.setAdmin(request.getSession());
            List policyList = policyMgr.search(inPolicy.getName());
            response.setEntities(policyList);
        }
        catch (SecurityException se) {
            response.setErrorCode(se.getErrorId());
            response.setErrorMessage(se.getMessage());
        }
        return response;
    }

    FortResponse updateUserPolicy(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            PwPolicy inPolicy = (PwPolicy)request.getEntity();
            PwPolicyMgr policyMgr = PwPolicyMgrFactory.createInstance((String)request.getContextId());
            policyMgr.setAdmin(request.getSession());
            String userId = request.getValue();
            policyMgr.updateUserPolicy(userId, inPolicy.getName());
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }

    FortResponse deleteUserPolicy(FortRequest request) {
        FortResponse response = this.createResponse();
        try {
            PwPolicyMgr policyMgr = PwPolicyMgrFactory.createInstance((String)request.getContextId());
            policyMgr.setAdmin(request.getSession());
            String userId = request.getValue();
            policyMgr.deletePasswordPolicy(userId);
        }
        catch (SecurityException se) {
            this.createError(response, LOG, se);
        }
        return response;
    }
}

