/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.util.time;

import org.apache.directory.fortress.core.model.Constraint;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.core.util.VUtil;
import org.apache.directory.fortress.core.util.time.Time;
import org.apache.directory.fortress.core.util.time.Validator;

public class Timeout
implements Validator {
    @Override
    public int validate(Session session, Constraint constraint, Time time, VUtil.ConstraintType type) {
        int rc = 2053;
        long lastTime = session.getLastAccess();
        if (lastTime == 0L) {
            rc = 0;
        } else {
            long timeLimit;
            long elapsedTime = System.currentTimeMillis() - lastTime;
            if (elapsedTime < (timeLimit = (long)constraint.getTimeout().intValue() * 60000L) || constraint.getTimeout() == 0) {
                rc = 0;
            }
        }
        return rc;
    }
}

