/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.impl.RoleUtil;
import org.apache.directory.fortress.core.impl.SDUtil;
import org.apache.directory.fortress.core.model.Constraint;
import org.apache.directory.fortress.core.model.ObjectFactory;
import org.apache.directory.fortress.core.model.SDSet;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.core.model.UserRole;
import org.apache.directory.fortress.core.model.Warning;
import org.apache.directory.fortress.core.util.VUtil;
import org.apache.directory.fortress.core.util.time.Time;
import org.apache.directory.fortress.core.util.time.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSDChecker
implements Validator {
    private static final String CLS_NM = DSDChecker.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLS_NM);

    @Override
    public int validate(Session session, Constraint constraint, Time time, VUtil.ConstraintType type) throws SecurityException {
        Set<SDSet> dsdSets;
        int rc = 0;
        List<UserRole> activeRoleList = session.getRoles();
        if (activeRoleList == null || activeRoleList.size() == 0) {
            return rc;
        }
        String contextId = session.isGroupSession() ? session.getGroup().getContextId() : session.getUser().getContextId();
        String entityId = session.isGroupSession() ? session.getGroupName() : session.getUserId();
        String entityType = session.isGroupSession() ? "groupName" : "userId";
        Set<String> authorizedRoleSet = RoleUtil.getInstance().getInheritedRoles(activeRoleList, contextId);
        if (authorizedRoleSet != null && authorizedRoleSet.size() > 1 && (dsdSets = SDUtil.getInstance().getDsdCache(authorizedRoleSet, contextId)) != null && dsdSets.size() > 0) {
            for (SDSet dsd : dsdSets) {
                Iterator<UserRole> activatedRoles = activeRoleList.iterator();
                int matchCount = 0;
                Set<String> map = dsd.getMembers();
                block1: while (activatedRoles.hasNext()) {
                    UserRole activatedRole = activatedRoles.next();
                    if (map.contains(activatedRole.getName())) {
                        if (++matchCount < dsd.getCardinality()) continue;
                        activatedRoles.remove();
                        String warning = "validate " + entityType + " [" + entityId + "] failed activation of assignedRole [" + activatedRole.getName() + "] validates DSD Set Name:" + dsd.getName() + " Cardinality:" + dsd.getCardinality();
                        LOG.warn(warning);
                        rc = 2055;
                        session.setWarning(new ObjectFactory().createWarning(rc, warning, Warning.Type.ROLE, activatedRole.getName()));
                        continue;
                    }
                    Set<String> parentSet = RoleUtil.getInstance().getAscendants(activatedRole.getName(), contextId);
                    for (String parentRole : parentSet) {
                        if (!map.contains(parentRole) || ++matchCount < dsd.getCardinality()) continue;
                        String warning = "validate " + entityType + " [" + entityId + "] assignedRole [" + activatedRole.getName() + "] parentRole [" + parentRole + "] validates DSD Set Name:" + dsd.getName() + " Cardinality:" + dsd.getCardinality();
                        rc = 2055;
                        activatedRoles.remove();
                        session.setWarning(new ObjectFactory().createWarning(rc, warning, Warning.Type.ROLE, activatedRole.getName()));
                        LOG.warn(warning);
                        continue block1;
                    }
                }
            }
        }
        return rc;
    }
}

