/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.controls;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.util.Oid;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ControlFactory;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.Message;
import org.apache.directory.api.ldap.model.message.Request;
import org.apache.directory.api.ldap.model.message.controls.OpaqueControl;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreControlName
extends GrammarAction<LdapMessageContainer<Message>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreControlName.class);

    public StoreControlName() {
        super("Add a new control");
    }

    public void action(LdapMessageContainer<Message> container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            String msg = I18n.err((I18n)I18n.ERR_08214_NULL_OID, (Object[])new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        byte[] value = tlv.getValue().getData();
        String oidValue = Strings.asciiBytesToString((byte[])value);
        if (!Oid.isOid((String)oidValue)) {
            String msg = I18n.err((I18n)I18n.ERR_08215_INVALID_CONTROL_OID, (Object[])new Object[]{oidValue});
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        Message message = container.getMessage();
        LdapApiService codec = container.getLdapCodecService();
        ControlFactory<? extends Control> controlFactory = message instanceof Request ? codec.getRequestControlFactories().get(oidValue) : codec.getResponseControlFactories().get(oidValue);
        Object control = controlFactory == null ? new OpaqueControl(oidValue) : controlFactory.newControl();
        container.setControlFactory(controlFactory);
        message.addControl(control);
        container.setCurrentControl((Control)control);
        container.setGrammarEndAllowed(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_08201_CONTROL_OID, (Object[])new Object[]{oidValue}));
        }
    }
}

