/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.modifyDnRequest;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.BooleanDecoder;
import org.apache.directory.api.asn1.ber.tlv.BooleanDecoderException;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.ModifyDnRequestDecorator;
import org.apache.directory.api.ldap.model.message.ModifyDnRequest;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreModifyDnRequestDeleteOldRdn
extends GrammarAction<LdapMessageContainer<ModifyDnRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreModifyDnRequestDeleteOldRdn.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreModifyDnRequestDeleteOldRdn() {
        super("Store ModifyDN request deleteOldRdn flag");
    }

    public void action(LdapMessageContainer<ModifyDnRequestDecorator> container) throws DecoderException {
        ModifyDnRequest modifyDnRequest = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        BerValue value = tlv.getValue();
        try {
            modifyDnRequest.setDeleteOldRdn(BooleanDecoder.parse((BerValue)value));
        }
        catch (BooleanDecoderException bde) {
            LOG.error(I18n.err((I18n)I18n.ERR_04091, (Object[])new Object[]{Strings.dumpBytes((byte[])value.getData()), bde.getMessage()}));
            throw new DecoderException(bde.getMessage(), (Throwable)bde);
        }
        container.setGrammarEndAllowed(true);
        if (IS_DEBUG) {
            if (modifyDnRequest.getDeleteOldRdn()) {
                LOG.debug(" Old Rdn attributes will be deleted");
            } else {
                LOG.debug(" Old Rdn attributes will be retained");
            }
        }
    }
}

