/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.source.stream;

import java.io.IOException;
import org.apache.torque.generator.configuration.source.EntityReferences;
import org.apache.torque.generator.source.SourceElement;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlSourceSaxHandler
extends DefaultHandler {
    private static final String SCHEMA_INSTANCE_NAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";
    private SourceElement element;
    private SourceElement root;
    private final EntityReferences entityReferences;

    public XmlSourceSaxHandler(EntityReferences entityReferences) {
        if (entityReferences == null) {
            throw new NullPointerException("entityReferences must not be null");
        }
        this.entityReferences = entityReferences;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        SourceElement current = new SourceElement(qName);
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (SCHEMA_INSTANCE_NAMESPACE.equals(attributes.getURI(i))) continue;
            current.setAttribute(attributes.getQName(i), (Object)attributes.getValue(i));
        }
        if (this.element != null) {
            this.element.getChildren().add(current);
        } else {
            this.root = current;
        }
        this.element = current;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.element = this.element.getParent();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String characterData = new String(ch, start, length);
        if (this.isWhitespace(characterData)) {
            return;
        }
        Object textContent = (String)this.element.getAttribute((String)null);
        textContent = textContent != null ? (String)textContent + characterData : characterData;
        this.element.setAttribute((String)null, textContent);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        return this.entityReferences.resolveEntity(publicId, systemId);
    }

    public SourceElement getRoot() {
        return this.root;
    }

    private boolean isWhitespace(String toCheck) {
        for (int i = 0; i < toCheck.length(); ++i) {
            char ch = toCheck.charAt(i);
            if (ch == ' ' || ch == '\r' || ch == '\n' || ch == '\t') continue;
            return false;
        }
        return true;
    }

    @Override
    public void error(SAXParseException exception) throws SAXParseException {
        throw exception;
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXParseException {
        throw exception;
    }

    @Override
    public void warning(SAXParseException exception) throws SAXParseException {
        throw exception;
    }
}

