/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revplot;

import java.text.MessageFormat;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeSet;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.revplot.PlotCommit;
import org.eclipse.jgit.revplot.PlotLane;
import org.eclipse.jgit.revplot.PlotWalk;
import org.eclipse.jgit.revwalk.RevCommitList;
import org.eclipse.jgit.revwalk.RevWalk;

public class PlotCommitList<L extends PlotLane>
extends RevCommitList<PlotCommit<L>> {
    static final int MAX_LENGTH = 25;
    private int positionsAllocated;
    private final TreeSet<Integer> freePositions = new TreeSet();
    private final HashSet<PlotLane> activeLanes = new HashSet(32);
    private final HashMap<PlotLane, Integer> laneLength = new HashMap(32);

    @Override
    public void clear() {
        super.clear();
        this.positionsAllocated = 0;
        this.freePositions.clear();
        this.activeLanes.clear();
        this.laneLength.clear();
    }

    @Override
    public void source(RevWalk w) {
        if (!(w instanceof PlotWalk)) {
            throw new ClassCastException(MessageFormat.format(JGitText.get().classCastNotA, PlotWalk.class.getName()));
        }
        super.source(w);
    }

    public void findPassingThrough(PlotCommit<L> currCommit, Collection<L> result) {
        PlotLane[] plotLaneArray = currCommit.passingLanes;
        int n = currCommit.passingLanes.length;
        int n2 = 0;
        while (n2 < n) {
            PlotLane p = plotLaneArray[n2];
            result.add(p);
            ++n2;
        }
    }

    @Override
    protected void enter(int index, PlotCommit<L> currCommit) {
        this.setupChildren(currCommit);
        int nChildren = currCommit.getChildCount();
        if (nChildren == 0) {
            currCommit.lane = this.nextFreeLane();
        } else if (nChildren == 1 && currCommit.children[0].getParentCount() < 2) {
            PlotCommit c = currCommit.children[0];
            currCommit.lane = c.lane;
            Integer len = this.laneLength.get(currCommit.lane);
            len = len + 1;
            this.laneLength.put(currCommit.lane, len);
        } else {
            PlotCommit c;
            PlotLane reservedLane = null;
            PlotCommit childOnReservedLane = null;
            int lengthOfReservedLane = -1;
            int i = 0;
            while (i < nChildren) {
                Integer len;
                c = currCommit.children[i];
                if (c.getParent(0) == currCommit && (len = this.laneLength.get(c.lane)) > lengthOfReservedLane) {
                    reservedLane = c.lane;
                    childOnReservedLane = c;
                    lengthOfReservedLane = len;
                }
                ++i;
            }
            if (reservedLane != null) {
                currCommit.lane = reservedLane;
                this.laneLength.put(reservedLane, lengthOfReservedLane + 1);
                this.handleBlockedLanes(index, currCommit, childOnReservedLane);
            } else {
                currCommit.lane = this.nextFreeLane();
                this.handleBlockedLanes(index, currCommit, null);
            }
            i = 0;
            while (i < nChildren) {
                c = currCommit.children[i];
                PlotCommit firstParent = (PlotCommit)c.getParent(0);
                if (firstParent.lane != null && firstParent.lane != c.lane) {
                    this.closeLane(c.lane);
                }
                ++i;
            }
        }
        this.continueActiveLanes(currCommit);
        if (currCommit.getParentCount() == 0) {
            this.closeLane(currCommit.lane);
        }
    }

    private void continueActiveLanes(PlotCommit currCommit) {
        for (PlotLane lane : this.activeLanes) {
            if (lane == currCommit.lane) continue;
            currCommit.addPassingLane(lane);
        }
    }

    private void handleBlockedLanes(int index, PlotCommit currCommit, PlotCommit childOnLane) {
        PlotCommit[] plotCommitArray = currCommit.children;
        int n = currCommit.children.length;
        int n2 = 0;
        while (n2 < n) {
            PlotCommit child = plotCommitArray[n2];
            if (child != childOnLane) {
                PlotLane laneToUse;
                boolean childIsMerge;
                boolean bl = childIsMerge = child.getParent(0) != currCommit;
                if (childIsMerge) {
                    laneToUse = currCommit.lane;
                    laneToUse = this.handleMerge(index, currCommit, childOnLane, child, laneToUse);
                    child.addMergingLane(laneToUse);
                } else {
                    laneToUse = child.lane;
                    currCommit.addForkingOffLane(laneToUse);
                }
            }
            ++n2;
        }
    }

    private PlotLane handleMerge(int index, PlotCommit currCommit, PlotCommit childOnLane, PlotCommit child, PlotLane laneToUse) {
        int childIndex = index;
        BitSet blockedPositions = new BitSet();
        int r = index - 1;
        while (r >= 0) {
            PlotCommit rObj = (PlotCommit)this.get(r);
            if (rObj == child) {
                childIndex = r;
                break;
            }
            PlotCommitList.addBlockedPosition(blockedPositions, rObj);
            --r;
        }
        if (blockedPositions.get(laneToUse.getPosition())) {
            boolean needDetour = false;
            if (childOnLane != null) {
                int r2 = index - 1;
                while (r2 > childIndex) {
                    PlotCommit rObj = (PlotCommit)this.get(r2);
                    if (rObj == childOnLane) {
                        needDetour = true;
                        break;
                    }
                    --r2;
                }
            }
            if (needDetour) {
                laneToUse = this.nextFreeLane(blockedPositions);
                currCommit.addForkingOffLane(laneToUse);
                this.closeLane(laneToUse);
            } else {
                int newPos = this.getFreePosition(blockedPositions);
                this.freePositions.add(laneToUse.getPosition());
                laneToUse.position = newPos;
            }
        }
        this.drawLaneToChild(index, child, laneToUse);
        return laneToUse;
    }

    private void drawLaneToChild(int commitIndex, PlotCommit child, PlotLane laneToContinue) {
        int r = commitIndex - 1;
        while (r >= 0) {
            PlotCommit rObj = (PlotCommit)this.get(r);
            if (rObj == child) break;
            if (rObj != null) {
                rObj.addPassingLane(laneToContinue);
            }
            --r;
        }
    }

    private static void addBlockedPosition(BitSet blockedPositions, PlotCommit rObj) {
        if (rObj != null) {
            PlotLane l;
            Object lane = rObj.getLane();
            if (lane != null) {
                blockedPositions.set(((PlotLane)lane).getPosition());
            }
            PlotLane[] plotLaneArray = rObj.forkingOffLanes;
            int n = rObj.forkingOffLanes.length;
            int n2 = 0;
            while (n2 < n) {
                l = plotLaneArray[n2];
                blockedPositions.set(l.getPosition());
                ++n2;
            }
            plotLaneArray = rObj.mergingLanes;
            n = rObj.mergingLanes.length;
            n2 = 0;
            while (n2 < n) {
                l = plotLaneArray[n2];
                blockedPositions.set(l.getPosition());
                ++n2;
            }
        }
    }

    private void closeLane(PlotLane lane) {
        if (this.activeLanes.remove(lane)) {
            this.recycleLane(lane);
            this.laneLength.remove(lane);
            this.freePositions.add(lane.getPosition());
        }
    }

    private void setupChildren(PlotCommit<L> currCommit) {
        int nParents = currCommit.getParentCount();
        int i = 0;
        while (i < nParents) {
            ((PlotCommit)currCommit.getParent(i)).addChild(currCommit);
            ++i;
        }
    }

    private PlotLane nextFreeLane() {
        return this.nextFreeLane(null);
    }

    private PlotLane nextFreeLane(BitSet blockedPositions) {
        L p = this.createLane();
        ((PlotLane)p).position = this.getFreePosition(blockedPositions);
        this.activeLanes.add((PlotLane)p);
        this.laneLength.put((PlotLane)p, 1);
        return p;
    }

    private int getFreePosition(BitSet blockedPositions) {
        if (this.freePositions.isEmpty()) {
            return this.positionsAllocated++;
        }
        if (blockedPositions != null) {
            for (Integer pos : this.freePositions) {
                if (blockedPositions.get(pos)) continue;
                this.freePositions.remove(pos);
                return pos;
            }
            return this.positionsAllocated++;
        }
        Integer min = this.freePositions.first();
        this.freePositions.remove(min);
        return min;
    }

    protected L createLane() {
        return (L)new PlotLane();
    }

    protected void recycleLane(L lane) {
    }
}

