/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.filters.bloomfilter;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import org.apache.datasketches.common.MemorySegmentStatus;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.SketchesReadOnlyException;
import org.apache.datasketches.filters.bloomfilter.BitArray;

public class DirectBitArrayR
extends BitArray {
    protected static final long NUM_BITS_OFFSET = 8L;
    protected static final long DATA_OFFSET = 16L;
    protected final int dataLength_;
    protected final MemorySegment wseg_;
    protected long numBitsSet_;

    protected DirectBitArrayR(int dataLength, long storedNumBitsSet, MemorySegment seg) {
        this.dataLength_ = dataLength;
        this.wseg_ = seg;
        if (storedNumBitsSet == -1L) {
            this.numBitsSet_ = 0L;
            for (int i = 0; i < this.dataLength_; ++i) {
                this.numBitsSet_ += (long)Long.bitCount(this.wseg_.get(ValueLayout.JAVA_LONG_UNALIGNED, 16L + (long)(i << 3)));
            }
        } else {
            this.numBitsSet_ = storedNumBitsSet;
        }
    }

    static DirectBitArrayR wrap(MemorySegment seg, boolean isEmpty) {
        long storedNumBitsSet;
        int arrayLength = seg.get(ValueLayout.JAVA_INT_UNALIGNED, 0L);
        long l = storedNumBitsSet = isEmpty ? 0L : seg.get(ValueLayout.JAVA_LONG_UNALIGNED, 8L);
        if (arrayLength < 0) {
            throw new SketchesArgumentException("Possible corruption: Serialized image indicates non-positive array length");
        }
        if (storedNumBitsSet != 0L && seg.byteSize() < (long)(arrayLength + 2)) {
            throw new SketchesArgumentException("MemorySegment capacity is insufficient for Bloom Filter. Needs: " + (arrayLength + 2) + " , found: " + seg.byteSize());
        }
        return new DirectBitArrayR(arrayLength, storedNumBitsSet, seg);
    }

    @Override
    long getCapacity() {
        return (long)this.dataLength_ * 64L;
    }

    @Override
    long getNumBitsSet() {
        return this.numBitsSet_;
    }

    @Override
    protected boolean isDirty() {
        return false;
    }

    @Override
    int getArrayLength() {
        return this.dataLength_;
    }

    @Override
    boolean getBit(long index) {
        if (this.isEmpty()) {
            return false;
        }
        return (this.wseg_.get(ValueLayout.JAVA_BYTE, 16L + (long)((int)index >>> 3)) & 1 << (int)(index & 7L)) != 0;
    }

    @Override
    protected long getLong(int arrayIndex) {
        if (this.isEmpty()) {
            return 0L;
        }
        return this.wseg_.get(ValueLayout.JAVA_LONG_UNALIGNED, 16L + (long)(arrayIndex << 3));
    }

    @Override
    public boolean hasMemorySegment() {
        return this.wseg_ != null;
    }

    @Override
    public boolean isOffHeap() {
        return this.hasMemorySegment() && this.wseg_.isNative();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean isSameResource(MemorySegment that) {
        return MemorySegmentStatus.isSameResource(this.wseg_, that);
    }

    @Override
    void reset() {
        throw new SketchesReadOnlyException("Attempt to call reset() on read-only MemorySegment");
    }

    @Override
    void setBit(long index) {
        throw new SketchesReadOnlyException("Attempt to call setBit() on read-only MemorySegment");
    }

    @Override
    boolean getAndSetBit(long index) {
        throw new SketchesReadOnlyException("Attempt to call getAndSetBit() on read-only MemorySegment");
    }

    @Override
    void intersect(BitArray other) {
        throw new SketchesReadOnlyException("Attempt to call intersect() on read-only MemorySegment");
    }

    @Override
    void union(BitArray other) {
        throw new SketchesReadOnlyException("Attempt to call union() on read-only MemorySegment");
    }

    @Override
    void invert() {
        throw new SketchesReadOnlyException("Attempt to call invert() on read-only MemorySegment");
    }

    @Override
    protected void setLong(int arrayIndex, long value) {
        throw new SketchesReadOnlyException("Attempt to call setLong() on read-only MemorySegment");
    }
}

