/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.concurrent.AbstractConcurrentInitializerCloseAndExceptionsTest;
import org.apache.commons.lang3.concurrent.AtomicSafeInitializer;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.ConcurrentInitializer;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableSupplier;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class AtomicSafeInitializerSupplierTest
extends AbstractConcurrentInitializerCloseAndExceptionsTest<Object> {
    private AtomicInteger initCounter = new AtomicInteger();

    AtomicSafeInitializerSupplierTest() {
    }

    @Override
    protected ConcurrentInitializer<Object> createInitializer() {
        return ((AtomicSafeInitializer.Builder)AtomicSafeInitializer.builder().setInitializer(this::incAndMakeObject)).get();
    }

    @Override
    protected ConcurrentInitializer<AbstractConcurrentInitializerCloseAndExceptionsTest.CloseableObject> createInitializerThatThrowsException(FailableSupplier<AbstractConcurrentInitializerCloseAndExceptionsTest.CloseableObject, ? extends Exception> supplier, FailableConsumer<AbstractConcurrentInitializerCloseAndExceptionsTest.CloseableObject, ? extends Exception> closer) {
        return ((AtomicSafeInitializer.Builder)((AtomicSafeInitializer.Builder)AtomicSafeInitializer.builder().setInitializer(supplier)).setCloser(closer)).get();
    }

    private Object incAndMakeObject() {
        this.initCounter.incrementAndGet();
        return new Object();
    }

    @BeforeEach
    public void setUp() {
        this.initCounter = new AtomicInteger();
    }

    @Test
    void testGetThatReturnsNullFirstTime() throws ConcurrentException {
        AtomicSafeInitializer<Object> initializer = new AtomicSafeInitializer<Object>(){
            final AtomicBoolean firstRun = new AtomicBoolean(true);

            protected Object initialize() {
                if (this.firstRun.getAndSet(false)) {
                    return null;
                }
                return new Object();
            }
        };
        Assertions.assertNull((Object)initializer.get());
        Assertions.assertNull((Object)initializer.get());
    }

    @Test
    void testNumberOfInitializeInvocations() throws ConcurrentException, InterruptedException {
        this.testGetConcurrent();
        Assertions.assertEquals((int)1, (int)this.initCounter.get(), (String)"Wrong number of invocations");
    }
}

