/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.scripting;

import java.io.StringWriter;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.commons.jexl3.scripting.JexlScriptEngineFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JexlScriptEngineOptionalTest {
    private final JexlScriptEngineFactory factory = new JexlScriptEngineFactory();
    private final ScriptEngineManager manager = new ScriptEngineManager();
    private final ScriptEngine engine = this.manager.getEngineByName("jexl");

    @Test
    public void testCompilable() throws Exception {
        Assertions.assertInstanceOf(Compilable.class, (Object)this.engine, (String)"Engine should implement Compilable");
        Compilable cengine = (Compilable)((Object)this.engine);
        CompiledScript script = cengine.compile("40 + 2");
        Assertions.assertEquals((Object)42, (Object)script.eval());
        Assertions.assertEquals((Object)42, (Object)script.eval());
    }

    @Test
    public void testError() throws Exception {
        String error = "JEXL.err.print('ERROR')";
        StringWriter outContent = new StringWriter();
        this.engine.getContext().setErrorWriter(outContent);
        this.engine.eval("JEXL.err.print('ERROR')");
        Assertions.assertEquals((Object)"ERROR", (Object)outContent.toString());
    }

    @Test
    public void testOutput() throws Exception {
        String output = this.factory.getOutputStatement("foo\u00a9bar");
        Assertions.assertEquals((Object)"JEXL.out.print('foo\\u00a9bar')", (Object)output);
        StringWriter outContent = new StringWriter();
        this.engine.getContext().setWriter(outContent);
        this.engine.eval(output);
        Assertions.assertEquals((Object)"foo\u00a9bar", (Object)outContent.toString());
    }
}

