/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlEvalContext;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlFeatures;
import org.apache.commons.jexl3.JexlInfo;
import org.apache.commons.jexl3.JexlOptions;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.JxltEngine;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.lang3.ThreadUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PragmaTest
extends JexlTestCase {
    public PragmaTest() {
        super("PragmaTest");
    }

    void runPragmaModule(ModuleContext ctxt, CachingModuleContext cmCtxt) {
        ctxt.script("module0", this.JEXL.createScript("function f42(x) { 42 + x; } function f43(x) { 43 + x; }; { 'f42' : f42, 'f43' : f43 }"));
        ConcurrentHashMap modules = new ConcurrentHashMap();
        JexlScript script = this.JEXL.createScript("#pragma jexl.module.m0 \"script('module0')\"\n m0:f42(10);");
        Object result = script.execute((JexlContext)ctxt);
        Assertions.assertEquals((Object)52, (Object)result);
        if (cmCtxt != null) {
            Assertions.assertEquals((int)1, (int)cmCtxt.getCountCompute());
        }
        result = script.execute((JexlContext)ctxt);
        Assertions.assertEquals((Object)52, (Object)result);
        if (cmCtxt != null) {
            Assertions.assertEquals((int)1, (int)cmCtxt.getCountCompute());
        }
        script = this.JEXL.createScript("#pragma jexl.module.m0 \"script('module0')\"\n m0:f43(10);");
        result = script.execute((JexlContext)ctxt);
        Assertions.assertEquals((Object)53, (Object)result);
        if (cmCtxt != null) {
            Assertions.assertEquals((int)1, (int)cmCtxt.getCountCompute());
        }
        JexlScript script1 = this.JEXL.createScript("#pragma jexl.module.m0 ''\n#pragma jexl.module.m0 \"fubar('module0')\"\n m0:f43(10);");
        JexlException.Method xmethod = (JexlException.Method)Assertions.assertThrows(JexlException.Method.class, () -> script1.execute((JexlContext)ctxt));
        Assertions.assertEquals((Object)"fubar", (Object)xmethod.getMethod());
    }

    @Test
    public void test354() {
        TreeMap<String, Number> values = new TreeMap<String, Number>();
        values.put("1", 1);
        values.put("+1", 1);
        values.put("-1", -1);
        values.put("1l", 1L);
        values.put("+1l", 1L);
        values.put("-1l", -1L);
        values.put("10h", BigInteger.valueOf(10L));
        values.put("-11h", BigInteger.valueOf(-11L));
        values.put("+12h", BigInteger.valueOf(12L));
        values.put("0xa", 10);
        values.put("+0xa", 10);
        values.put("-0xa", -10);
        values.put("0xacl", 172L);
        values.put("+0xadl", 173L);
        values.put("-0xafl", -175L);
        values.put("1d", 1.0);
        values.put("-1d", -1.0);
        values.put("+1d", 1.0);
        values.put("1f", Float.valueOf(1.0f));
        values.put("-1f", Float.valueOf(-1.0f));
        values.put("+1f", Float.valueOf(1.0f));
        values.put("1B", new BigDecimal(1));
        values.put("-1B", new BigDecimal(-1));
        values.put("+1B", new BigDecimal(1));
        values.put("-42424242424242424242424242424242", new BigInteger("-42424242424242424242424242424242"));
        values.put("+42424242424242424242424242424242", new BigInteger("+42424242424242424242424242424242"));
        values.put("42424242424242424242424242424242", new BigInteger("42424242424242424242424242424242"));
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        for (Map.Entry e : values.entrySet()) {
            String text = "#pragma number " + (String)e.getKey();
            JexlScript script = jexl.createScript(text);
            Assertions.assertNotNull((Object)script);
            Map pragmas = script.getPragmas();
            Assertions.assertNotNull((Object)pragmas);
            Assertions.assertEquals(e.getValue(), pragmas.get("number"), e::getKey);
        }
    }

    @Test
    public void testImportPragmaDisabled() {
        String src = "#pragma jexl.import java.util\n#pragma jexl.import java.io\n#pragma jexl.import java.net\n42";
        JexlFeatures features = new JexlFeatures();
        features.importPragma(false);
        JexlEngine jexl = new JexlBuilder().features(features).create();
        JexlException.Parsing xparse = (JexlException.Parsing)Assertions.assertThrows(JexlException.Parsing.class, () -> jexl.createScript("#pragma jexl.import java.util\n#pragma jexl.import java.io\n#pragma jexl.import java.net\n42"));
        Assertions.assertTrue((boolean)xparse.getMessage().contains("import pragma"));
    }

    @Test
    public void testImportPragmaValueSet() {
        String src = "#pragma jexl.import java.util\n#pragma jexl.import java.io\n#pragma jexl.import java.net\n42";
        JexlScript script = this.JEXL.createScript("#pragma jexl.import java.util\n#pragma jexl.import java.io\n#pragma jexl.import java.net\n42");
        Map pragmas = script.getPragmas();
        Object importz = pragmas.get("jexl.import");
        Assertions.assertInstanceOf(Set.class, importz);
        Set importzz = (Set)importz;
        Assertions.assertTrue((boolean)importzz.contains("java.util"));
        Assertions.assertTrue((boolean)importzz.contains("java.io"));
        Assertions.assertTrue((boolean)importzz.contains("java.net"));
        Assertions.assertEquals((int)3, (int)importzz.size());
        String parsed = script.getParsedText();
        Assertions.assertEquals((Object)"#pragma jexl.import java.util\n#pragma jexl.import java.io\n#pragma jexl.import java.net\n42", (Object)parsed);
    }

    @Test
    public void testIssue416() {
        JexlEngine jexl = new JexlBuilder().create();
        JexlScript script = jexl.createScript("#pragma myNull null\n");
        Map pragmas = script.getPragmas();
        Assertions.assertTrue((boolean)pragmas.containsKey("myNull"), (String)"pragma key present?");
        Assertions.assertNull(pragmas.get("myNull"), (String)"expected null value");
    }

    @Test
    public void testJxltPragmas() {
        JxltEngine engine = new JexlBuilder().create().createJxltEngine();
        JxltEngine.Template tscript = engine.createTemplate("$$ #pragma one 1\n$$ #pragma the.very.hard 'truth'\n2;");
        Assertions.assertNotNull((Object)tscript);
        Map pragmas = tscript.getPragmas();
        Assertions.assertEquals((int)2, (int)pragmas.size());
        Assertions.assertEquals((Object)1, pragmas.get("one"));
        Assertions.assertEquals((Object)"truth", pragmas.get("the.very.hard"));
    }

    @Test
    public void testNamespacePragma() {
        SafeContext jc = new SafeContext();
        String src = "#pragma jexl.namespace.sleeper " + Sleeper.class.getName() + "\nsleeper:sleep(100);\n42;\n";
        JexlScript script = this.JEXL.createScript(src);
        Object result = script.execute((JexlContext)jc);
        Assertions.assertEquals((Object)42, (Object)result);
        String parsed = script.getParsedText();
        Assertions.assertEquals((Object)src, (Object)parsed);
    }

    @Test
    public void testNamespacePragmaCtl() {
        Map<String, String> ns = Collections.singletonMap("sleeper", Sleeper.class.getName());
        JexlEngine jexl = new JexlBuilder().namespaces(ns).create();
        SafeContext jc = new SafeContext();
        JexlScript script = jexl.createScript("sleeper:sleep(100);42");
        Object result = script.execute((JexlContext)jc);
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testNamespacePragmaDisabled() {
        JexlFeatures features = new JexlFeatures();
        features.namespacePragma(false);
        JexlEngine jexl = new JexlBuilder().features(features).create();
        JexlException.Parsing xparse = (JexlException.Parsing)Assertions.assertThrows(JexlException.Parsing.class, () -> jexl.createScript("#pragma jexl.namespace.sleeper " + StaticSleeper.class.getName() + "\nsleeper:sleep(100);42"));
        Assertions.assertTrue((boolean)xparse.getMessage().contains("namespace pragma"));
    }

    @Test
    public void testPragmaModuleCache() {
        CachingModuleContext ctxt = new CachingModuleContext();
        this.runPragmaModule(ctxt, ctxt);
    }

    @Test
    public void testPragmaModuleNoCache() {
        ModuleContext ctxt = new ModuleContext();
        this.runPragmaModule(ctxt, null);
    }

    @Test
    public void testPragmaOptions1() {
        String str = "i; #pragma jexl.options '-strict'\n";
        JexlEngine jexl = new JexlBuilder().features(new JexlFeatures().pragmaAnywhere(false)).strict(true).create();
        Assertions.assertThrows(JexlException.class, () -> jexl.createScript("i; #pragma jexl.options '-strict'\n"), (String)"i should not be resolved");
    }

    @Test
    public void testPragmas() {
        JexlScript script = this.JEXL.createScript("#pragma one 1\n#pragma the.very.hard 'truth'\n2;");
        Assertions.assertNotNull((Object)script);
        Map pragmas = script.getPragmas();
        Assertions.assertEquals((int)2, (int)pragmas.size());
        Assertions.assertEquals((Object)1, pragmas.get("one"));
        Assertions.assertEquals((Object)"truth", pragmas.get("the.very.hard"));
    }

    @Test
    public void testSafePragma() {
        SafeContext jc = new SafeContext();
        jc.set("foo", null);
        JexlScript script = this.JEXL.createScript("#pragma jexl.safe true\nfoo.bar;");
        Assertions.assertNotNull((Object)script);
        jc.processPragmas(script.getPragmas());
        Object result = script.execute((JexlContext)jc);
        Assertions.assertNull((Object)result);
        SafeContext jc1 = new SafeContext();
        jc1.set("foo", null);
        Assertions.assertThrows(JexlException.class, () -> script.execute((JexlContext)jc1));
    }

    @Test
    public void testStaticNamespacePragma() {
        SafeContext jc = new SafeContext();
        JexlScript script = this.JEXL.createScript("#pragma jexl.namespace.sleeper " + StaticSleeper.class.getName() + "\nsleeper:sleep(100);42");
        Object result = script.execute((JexlContext)jc);
        Assertions.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void testStatictNamespacePragmaCtl() {
        Map<String, String> ns = Collections.singletonMap("sleeper", StaticSleeper.class.getName());
        JexlEngine jexl = new JexlBuilder().namespaces(ns).create();
        SafeContext jc = new SafeContext();
        JexlScript script = jexl.createScript("sleeper:sleep(100);42");
        Object result = script.execute((JexlContext)jc);
        Assertions.assertEquals((Object)42, (Object)result);
    }

    public static class ModuleContext
    extends MapContext {
        protected final Map<String, JexlScript> sources = new TreeMap<String, JexlScript>();

        ModuleContext() {
        }

        public Object script(String name) {
            return this.sources.get(name);
        }

        void script(String name, JexlScript script) {
            this.sources.put(name, script);
        }
    }

    public static class CachingModuleContext
    extends ModuleContext
    implements JexlContext.ModuleProcessor {
        private final ConcurrentMap<String, Object> modules = new ConcurrentHashMap<String, Object>();
        private final AtomicInteger count = new AtomicInteger();

        CachingModuleContext() {
        }

        public int getCountCompute() {
            return this.count.get();
        }

        public Object processModule(JexlEngine engine, JexlInfo info, String name, String body) {
            if (body.isEmpty()) {
                this.modules.remove(name);
                return null;
            }
            return this.modules.computeIfAbsent(name, n -> {
                Object module = engine.createExpression(info, body).evaluate((JexlContext)this);
                if (module instanceof JexlScript) {
                    module = ((JexlScript)module).execute((JexlContext)this);
                }
                this.count.incrementAndGet();
                return module;
            });
        }
    }

    public static class SafeContext
    extends JexlEvalContext {
        public void processPragmas(Map<String, Object> pragmas) {
            if (pragmas != null && !pragmas.isEmpty()) {
                JexlOptions options = this.getEngineOptions();
                for (Map.Entry<String, Object> pragma : pragmas.entrySet()) {
                    String key = pragma.getKey();
                    Object value = pragma.getValue();
                    if ("jexl.safe".equals(key) && value instanceof Boolean) {
                        options.setSafe(((Boolean)value).booleanValue());
                        continue;
                    }
                    if ("jexl.strict".equals(key) && value instanceof Boolean) {
                        options.setStrict(((Boolean)value).booleanValue());
                        continue;
                    }
                    if (!"jexl.silent".equals(key) || !(value instanceof Boolean)) continue;
                    options.setSilent(((Boolean)value).booleanValue());
                }
            }
        }

        public void sleep(long ms) {
            ThreadUtils.sleepQuietly((Duration)Duration.ofMillis(ms));
        }
    }

    public static class Sleeper {
        public void sleep(long ms) {
            ThreadUtils.sleepQuietly((Duration)Duration.ofMillis(ms));
        }
    }

    public static class StaticSleeper {
        public static void sleep(long ms) {
            ThreadUtils.sleepQuietly((Duration)Duration.ofMillis(ms));
        }

        private StaticSleeper() {
        }
    }
}

