/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BlockTest
extends JexlTestCase {
    public BlockTest() {
        super("BlockTest");
    }

    @Test
    public void testBlockExecutesAll() throws Exception {
        JexlScript e = this.JEXL.createScript("if (true) { x = 'Hello'; y = 'World';}");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)"Hello", (Object)jc.get("x"), (String)"First result is wrong");
        Assertions.assertEquals((Object)"World", (Object)jc.get("y"), (String)"Second result is wrong");
        Assertions.assertEquals((Object)"World", (Object)o, (String)"Block result is wrong");
    }

    @Test
    public void testBlockLastExecuted01() throws Exception {
        JexlScript e = this.JEXL.createScript("if (true) { x = 1; } else { x = 2; }");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)1, (Object)o, (String)"Block result is wrong");
    }

    @Test
    public void testBlockLastExecuted02() throws Exception {
        JexlScript e = this.JEXL.createScript("if (false) { x = 1; } else { x = 2; }");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)2, (Object)o, (String)"Block result is wrong");
    }

    @Test
    public void testBlockSimple() throws Exception {
        JexlScript e = this.JEXL.createScript("if (true) { 'hello'; }");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)"hello", (Object)o, (String)"Result is wrong");
    }

    @Test
    public void testEmptyBlock() throws Exception {
        JexlScript e = this.JEXL.createScript("if (true) { }");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assertions.assertNull((Object)o, (String)"Result is wrong");
    }

    @Test
    public void testNestedBlock() throws Exception {
        JexlScript e = this.JEXL.createScript("if (true) { x = 'hello'; y = 'world'; if (true) { x; } y; }");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assertions.assertEquals((Object)"world", (Object)o, (String)"Block result is wrong");
    }
}

