/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.tree;

import java.io.File;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.XMLConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.NodeCombiner;
import org.apache.commons.configuration2.tree.NodeStructureHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class AbstractCombinerTest {
    private static final File CONF1 = ConfigurationAssert.getTestFile("testcombine1.xml");
    private static final File CONF2 = ConfigurationAssert.getTestFile("testcombine2.xml");
    protected NodeCombiner combiner;

    protected BaseHierarchicalConfiguration createCombinedConfiguration() throws ConfigurationException {
        XMLConfiguration conf1 = new XMLConfiguration();
        new FileHandler((FileBased)conf1).load(CONF1);
        XMLConfiguration conf2 = new XMLConfiguration();
        new FileHandler((FileBased)conf2).load(CONF2);
        ImmutableNode cn = this.combiner.combine((ImmutableNode)conf1.getNodeModel().getNodeHandler().getRootNode(), (ImmutableNode)conf2.getNodeModel().getNodeHandler().getRootNode());
        BaseHierarchicalConfiguration result = new BaseHierarchicalConfiguration();
        result.getNodeModel().setRootNode(cn);
        return result;
    }

    protected abstract NodeCombiner createCombiner();

    @BeforeEach
    public void setUp() throws Exception {
        this.combiner = this.createCombiner();
    }

    @Test
    void testInit() {
        Assertions.assertTrue((boolean)this.combiner.getListNodes().isEmpty());
        Assertions.assertFalse((boolean)this.combiner.isListNode(NodeStructureHelper.createNode("test", null)));
    }
}

