/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2.event;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.configuration2.event.Event;
import org.apache.commons.configuration2.event.EventListener;
import org.apache.commons.configuration2.event.EventType;
import org.junit.jupiter.api.Assertions;

public abstract class AbstractEventListenerTestImpl<T extends Event>
implements EventListener<T> {
    private final Object expectedSource;
    private final List<T> events;

    protected AbstractEventListenerTestImpl(Object source) {
        this.expectedSource = source;
        this.events = new LinkedList<T>();
    }

    public void checkEventCount(int minEvents) {
        Assertions.assertTrue((this.events.size() >= minEvents ? 1 : 0) != 0);
    }

    public void done() {
        Assertions.assertTrue((boolean)this.events.isEmpty());
    }

    public T nextEvent(EventType<?> expectedType) {
        Assertions.assertFalse((boolean)this.events.isEmpty());
        Event e = (Event)this.events.remove(0);
        if (this.expectedSource != null) {
            Assertions.assertEquals((Object)this.expectedSource, (Object)e.getSource());
        }
        Assertions.assertEquals(expectedType, (Object)e.getEventType());
        return (T)e;
    }

    public void onEvent(T event) {
        this.events.add(event);
    }

    public void skipToLast(EventType<?> type) {
        while (this.events.size() > 1) {
            Event e = (Event)this.events.remove(0);
            Assertions.assertNotSame(type, (Object)e.getEventType());
        }
    }
}

