/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.configuration2.AbstractConfiguration;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ImmutableConfiguration;
import org.apache.commons.configuration2.ImmutableHierarchicalConfiguration;
import org.apache.commons.configuration2.InterpolationTestHelper;
import org.apache.commons.configuration2.convert.DefaultListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.ex.ConfigurationRuntimeException;
import org.apache.commons.configuration2.tree.DefaultConfigurationKey;
import org.apache.commons.configuration2.tree.DefaultExpressionEngine;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.configuration2.tree.NodeStructureHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestHierarchicalConfiguration {
    private static final String NEW_NAME = "alteredName";
    private BaseHierarchicalConfiguration config;

    private static DefaultConfigurationKey createConfigurationKey() {
        return new DefaultConfigurationKey(DefaultExpressionEngine.INSTANCE);
    }

    private void checkChildConfigurationsAtWithUpdates(boolean withUpdates, String expectedName) {
        String key = "tables.table(0)";
        List children = withUpdates ? this.config.childConfigurationsAt("tables.table(0)", true) : this.config.childConfigurationsAt("tables.table(0)");
        Assertions.assertEquals((int)2, (int)children.size());
        HierarchicalConfiguration sub = (HierarchicalConfiguration)children.get(0);
        sub.setProperty(null, (Object)NEW_NAME);
        Assertions.assertEquals((Object)expectedName, (Object)this.config.getString("tables.table(0).name"));
    }

    private void checkConfigurationAtAttributeNode(boolean withUpdates) {
        String key = "tables.table(0)[@type]";
        this.config.addProperty("tables.table(0)[@type]", (Object)"system");
        Assertions.assertThrows(ConfigurationRuntimeException.class, () -> this.config.configurationAt("tables.table(0)[@type]", withUpdates));
    }

    private void checkConfigurationsAtWithUpdate(boolean withUpdates, String expName) {
        String key = "tables.table(1).fields.field";
        List lstFlds = withUpdates ? this.config.configurationsAt("tables.table(1).fields.field", true) : this.config.configurationsAt("tables.table(1).fields.field");
        this.checkSubConfigurations(lstFlds);
        ((HierarchicalConfiguration)lstFlds.get(0)).setProperty("name", (Object)NEW_NAME);
        Assertions.assertEquals((Object)expName, (Object)this.config.getString("tables.table(1).fields.field(0).name"));
    }

    private void checkContent(Configuration c) {
        for (int i = 0; i < NodeStructureHelper.tablesLength(); ++i) {
            Assertions.assertEquals((Object)NodeStructureHelper.table(i), (Object)c.getString("tables.table(" + i + ").name"));
            for (int j = 0; j < NodeStructureHelper.fieldsLength(i); ++j) {
                Assertions.assertEquals((Object)NodeStructureHelper.field(i, j), (Object)c.getString("tables.table(" + i + ").fields.field(" + j + ").name"));
            }
        }
    }

    private void checkSubConfigurations(List<? extends ImmutableConfiguration> lstFlds) {
        Assertions.assertEquals((int)NodeStructureHelper.fieldsLength(1), (int)lstFlds.size());
        for (int i = 0; i < NodeStructureHelper.fieldsLength(1); ++i) {
            ImmutableConfiguration sub = lstFlds.get(i);
            Assertions.assertEquals((Object)NodeStructureHelper.field(1, i), (Object)sub.getString("name"), (String)("Wrong field at position " + i));
        }
    }

    @BeforeEach
    public void setUp() throws Exception {
        ImmutableNode root = new ImmutableNode.Builder(1).addChild(NodeStructureHelper.ROOT_TABLES_TREE).create();
        this.config = new BaseHierarchicalConfiguration();
        this.config.getNodeModel().setRootNode(root);
    }

    @Test
    void testChildConfigurationsAtNotFound() {
        Assertions.assertTrue((boolean)this.config.childConfigurationsAt("not.existing.key").isEmpty());
    }

    @Test
    void testChildConfigurationsAtNoUniqueKey() {
        Assertions.assertTrue((boolean)this.config.childConfigurationsAt("tables.table").isEmpty());
    }

    @Test
    void testChildConfigurationsAtNoUpdates() {
        this.checkChildConfigurationsAtWithUpdates(false, NodeStructureHelper.table(0));
    }

    @Test
    void testChildConfigurationsAtWithUpdates() {
        this.checkChildConfigurationsAtWithUpdates(true, NEW_NAME);
    }

    @Test
    void testClone() {
        Configuration copy = (Configuration)this.config.clone();
        Assertions.assertInstanceOf(BaseHierarchicalConfiguration.class, (Object)copy);
        this.config.setProperty("tables.table(0).name", (Object)"changed table name");
        this.checkContent(copy);
    }

    @Test
    void testConfigurationAtAttributeNode() {
        this.checkConfigurationAtAttributeNode(false);
    }

    @Test
    void testConfigurationAtAttributeNodeWithUpdates() {
        this.checkConfigurationAtAttributeNode(true);
    }

    @Test
    void testConfigurationAtClearAndDetach() {
        this.config.addProperty("test.sub.test", (Object)"success");
        this.config.addProperty("test.other", (Object)"check");
        HierarchicalConfiguration sub = this.config.configurationAt("test.sub", true);
        sub.clear();
        Assertions.assertTrue((boolean)sub.isEmpty());
        Assertions.assertNull((Object)this.config.getString("test.sub.test"));
        sub.setProperty("test", (Object)"failure!");
        Assertions.assertNull((Object)this.config.getString("test.sub.test"));
    }

    @Test
    void testConfigurationAtMultipleNodes() {
        Assertions.assertThrows(ConfigurationRuntimeException.class, () -> this.config.configurationAt("tables.table.name"));
    }

    @Test
    void testConfigurationAtMultipleNodesWithUpdates() {
        Assertions.assertThrows(ConfigurationRuntimeException.class, () -> this.config.configurationAt("tables.table.name", true));
    }

    @Test
    void testConfigurationAtReadAccess() {
        HierarchicalConfiguration subConfig = this.config.configurationAt("tables.table(1)");
        Assertions.assertEquals((Object)NodeStructureHelper.table(1), (Object)subConfig.getString("name"));
        List lstFlds = subConfig.getList("fields.field.name");
        ArrayList<String> expected = new ArrayList<String>();
        for (int i = 0; i < NodeStructureHelper.fieldsLength(1); ++i) {
            expected.add(NodeStructureHelper.field(1, i));
        }
        Assertions.assertEquals(expected, (Object)lstFlds);
    }

    @Test
    void testConfigurationAtUnknownSubTree() {
        Assertions.assertThrows(ConfigurationRuntimeException.class, () -> this.config.configurationAt("non.existing.key"));
    }

    @Test
    void testConfigurationAtUnknownSubTreeWithUpdates() {
        Assertions.assertThrows(ConfigurationRuntimeException.class, () -> this.config.configurationAt("non.existing.key", true));
    }

    @Test
    void testConfigurationAtUpdateParentConnected() {
        HierarchicalConfiguration subConfig = this.config.configurationAt("tables.table(1)", true);
        this.config.setProperty("tables.table(1).fields.field(2).name", (Object)"testField");
        Assertions.assertEquals((Object)"testField", (Object)subConfig.getString("fields.field(2).name"));
    }

    @Test
    void testConfigurationAtUpdateParentIndependent() {
        HierarchicalConfiguration subConfig = this.config.configurationAt("tables.table(1)");
        this.config.setProperty("tables.table(1).fields.field(2).name", (Object)"testField");
        Assertions.assertEquals((Object)NodeStructureHelper.field(1, 2), (Object)subConfig.getString("fields.field(2).name"));
    }

    @Test
    void testConfigurationAtUpdateSubConfigConnected() {
        HierarchicalConfiguration subConfig = this.config.configurationAt("tables.table(1)", true);
        subConfig.setProperty("name", (Object)"testTable");
        Assertions.assertEquals((Object)"testTable", (Object)this.config.getString("tables.table(1).name"));
    }

    @Test
    void testConfigurationAtUpdateSubConfigIndependent() {
        HierarchicalConfiguration subConfig = this.config.configurationAt("tables.table(1)");
        subConfig.setProperty("name", (Object)"testTable");
        Assertions.assertEquals((Object)"testTable", (Object)subConfig.getString("name"));
        Assertions.assertEquals((Object)NodeStructureHelper.table(1), (Object)this.config.getString("tables.table(1).name"));
    }

    @Test
    void testConfigurationAtWithUpdateInitialized() {
        String key = "tables.table";
        this.config.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(';'));
        this.config.setThrowExceptionOnMissing(true);
        List subs = this.config.configurationsAt("tables.table", true);
        BaseHierarchicalConfiguration sub = (BaseHierarchicalConfiguration)subs.get(0);
        Assertions.assertEquals((Object)this.config.getListDelimiterHandler(), (Object)sub.getListDelimiterHandler());
        Assertions.assertTrue((boolean)sub.isThrowExceptionOnMissing());
    }

    @Test
    void testConfigurationsAtAttributeKey() {
        String attrKey = "tables.table(0)[@type]";
        this.config.addProperty("tables.table(0)[@type]", (Object)"user");
        Assertions.assertTrue((boolean)this.config.configurationsAt("tables.table(0)[@type]").isEmpty());
    }

    @Test
    void testConfigurationsAtEmpty() {
        Assertions.assertTrue((boolean)this.config.configurationsAt("unknown.key").isEmpty());
    }

    @Test
    void testConfigurationsAtNoUpdate() {
        this.checkConfigurationsAtWithUpdate(false, NodeStructureHelper.field(1, 0));
    }

    @Test
    void testConfigurationsAtWithUpdates() {
        this.checkConfigurationsAtWithUpdate(true, NEW_NAME);
    }

    @Test
    void testImmutableChildConfigurationsAt() {
        List children = this.config.immutableChildConfigurationsAt("tables.table(0)");
        Assertions.assertEquals((int)2, (int)children.size());
        ImmutableHierarchicalConfiguration c1 = (ImmutableHierarchicalConfiguration)children.get(0);
        Assertions.assertEquals((Object)"name", (Object)c1.getRootElementName());
        Assertions.assertEquals((Object)NodeStructureHelper.table(0), (Object)c1.getString(null));
        ImmutableHierarchicalConfiguration c2 = (ImmutableHierarchicalConfiguration)children.get(1);
        Assertions.assertEquals((Object)"fields", (Object)c2.getRootElementName());
        Assertions.assertEquals((Object)NodeStructureHelper.field(0, 0), (Object)c2.getString("field(0).name"));
    }

    @Test
    void testImmutableConfigurationAt() {
        ImmutableHierarchicalConfiguration subConfig = this.config.immutableConfigurationAt("tables.table(1)");
        Assertions.assertEquals((Object)NodeStructureHelper.table(1), (Object)subConfig.getString("name"));
        List lstFlds = subConfig.getList("fields.field.name");
        ArrayList<String> expected = new ArrayList<String>();
        for (int i = 0; i < NodeStructureHelper.fieldsLength(1); ++i) {
            expected.add(NodeStructureHelper.field(1, i));
        }
        Assertions.assertEquals(expected, (Object)lstFlds);
    }

    @Test
    void testImmutableConfigurationAtSupportUpdates() {
        String newTableName = NodeStructureHelper.table(1) + "_other";
        ImmutableHierarchicalConfiguration subConfig = this.config.immutableConfigurationAt("tables.table(1)", true);
        this.config.addProperty("tables.table(-1).name", (Object)newTableName);
        this.config.clearTree("tables.table(1)");
        Assertions.assertEquals((Object)newTableName, (Object)subConfig.getString("name"));
    }

    @Test
    void testImmutableConfigurationsAt() {
        List lstFlds = this.config.immutableConfigurationsAt("tables.table(1).fields.field");
        this.checkSubConfigurations(lstFlds);
    }

    @Test
    void testInitCopy() {
        BaseHierarchicalConfiguration copy = new BaseHierarchicalConfiguration((HierarchicalConfiguration)this.config);
        this.checkContent((Configuration)copy);
    }

    @Test
    void testInitCopyNull() {
        BaseHierarchicalConfiguration copy = new BaseHierarchicalConfiguration((HierarchicalConfiguration)null);
        Assertions.assertTrue((boolean)copy.isEmpty());
    }

    @Test
    void testInitCopyUpdate() {
        BaseHierarchicalConfiguration copy = new BaseHierarchicalConfiguration((HierarchicalConfiguration)this.config);
        this.config.setProperty("tables.table(0).name", (Object)"NewTable");
        this.checkContent((Configuration)copy);
    }

    @Test
    void testInterpolatedConfiguration() {
        this.config.setListDelimiterHandler((ListDelimiterHandler)new DefaultListDelimiterHandler(','));
        BaseHierarchicalConfiguration c = (BaseHierarchicalConfiguration)InterpolationTestHelper.testInterpolatedConfiguration((AbstractConfiguration)this.config);
        this.checkContent((Configuration)c);
    }

    @Test
    void testInterpolatedConfigurationEmpty() {
        this.config = new BaseHierarchicalConfiguration();
        Assertions.assertTrue((boolean)this.config.interpolatedConfiguration().isEmpty());
    }

    @Test
    void testInterpolationSubset() {
        InterpolationTestHelper.testInterpolationSubset((Configuration)this.config);
    }

    @Test
    void testInterpolationSubsetMultipleLayers() {
        this.config.clear();
        this.config.addProperty("var", (Object)"value");
        this.config.addProperty("prop2.prop[@attr]", (Object)"${var}");
        Configuration sub1 = this.config.subset("prop2");
        Configuration sub2 = sub1.subset("prop");
        Assertions.assertEquals((Object)"value", (Object)sub2.getString("[@attr]"));
    }

    @Test
    void testSubset() {
        Configuration subset = this.config.subset("tables.table(0)");
        Assertions.assertEquals((Object)NodeStructureHelper.table(0), (Object)subset.getProperty("name"));
        Object prop = subset.getProperty("fields.field.name");
        Collection collection = (Collection)Assertions.assertInstanceOf(Collection.class, (Object)prop);
        Assertions.assertEquals((int)5, (int)collection.size());
        for (int i = 0; i < NodeStructureHelper.fieldsLength(0); ++i) {
            DefaultConfigurationKey key = TestHierarchicalConfiguration.createConfigurationKey();
            key.append("fields").append("field").appendIndex(i);
            key.append("name");
            Assertions.assertEquals((Object)NodeStructureHelper.field(0, i), (Object)subset.getProperty(key.toString()));
        }
        Assertions.assertTrue((boolean)this.config.subset("tables.table(2)").isEmpty());
        subset = this.config.subset("tables.table.fields.field");
        prop = subset.getProperty("name");
        collection = (Collection)Assertions.assertInstanceOf(Collection.class, (Object)prop);
        int expectedFieldCount = 0;
        for (int i = 0; i < NodeStructureHelper.tablesLength(); ++i) {
            expectedFieldCount += NodeStructureHelper.fieldsLength(i);
        }
        Assertions.assertEquals((int)expectedFieldCount, (int)collection.size());
        Assertions.assertEquals((Object)NodeStructureHelper.field(0, 0), (Object)subset.getProperty("name(0)"));
        subset = this.config.subset("tables.table.fields.field.name");
        Assertions.assertTrue((boolean)subset.isEmpty());
    }

    @Test
    void testSubsetAttributeResult() {
        String key = "tables.table(0)[@type]";
        this.config.addProperty("tables.table(0)[@type]", (Object)"system");
        BaseHierarchicalConfiguration subset = (BaseHierarchicalConfiguration)this.config.subset("tables.table(0)[@type]");
        Assertions.assertTrue((boolean)((ImmutableNode)subset.getModel().getNodeHandler().getRootNode()).getChildren().isEmpty());
        Assertions.assertEquals((Object)"system", (Object)subset.getString("[@type]"));
    }

    @Test
    void testSubsetMultipleNodesWithValues() {
        this.config.setProperty("tables.table(0).fields", (Object)"My fields");
        Configuration subset = this.config.subset("tables.table.fields");
        Assertions.assertEquals((Object)"My fields", (Object)subset.getString(""));
        this.config.setProperty("tables.table(1).fields", (Object)"My other fields");
        subset = this.config.subset("tables.table.fields");
        Assertions.assertNull((Object)subset.getString(""));
    }

    @Test
    void testSubsetNodeWithValue() {
        this.config.setProperty("tables.table(0).fields", (Object)"My fields");
        Configuration subset = this.config.subset("tables.table(0).fields");
        Assertions.assertEquals((Object)NodeStructureHelper.field(0, 0), (Object)subset.getString("field(0).name"));
        Assertions.assertEquals((Object)"My fields", (Object)subset.getString(""));
    }
}

