/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationspec.template.spec.volumes;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.generator.annotation.Required;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import org.apache.camel.v1.integrationspec.template.spec.volumes.AzureDiskBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"cachingMode", "diskName", "diskURI", "fsType", "kind", "readOnly"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class AzureDisk
implements Editable<AzureDiskBuilder>,
KubernetesResource {
    @JsonProperty(value="cachingMode")
    @JsonPropertyDescription(value="cachingMode is the Host Caching mode: None, Read Only, Read Write.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String cachingMode;
    @JsonProperty(value="diskName")
    @Required
    @JsonPropertyDescription(value="diskName is the Name of the data disk in the blob storage")
    @JsonSetter(nulls=Nulls.SKIP)
    private String diskName;
    @JsonProperty(value="diskURI")
    @Required
    @JsonPropertyDescription(value="diskURI is the URI of data disk in the blob storage")
    @JsonSetter(nulls=Nulls.SKIP)
    private String diskURI;
    @JsonProperty(value="fsType")
    @JsonPropertyDescription(value="fsType is Filesystem type to mount.\nMust be a filesystem type supported by the host operating system.\nEx. \"ext4\", \"xfs\", \"ntfs\". Implicitly inferred to be \"ext4\" if unspecified.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String fsType;
    @JsonProperty(value="kind")
    @JsonPropertyDescription(value="kind expected values are Shared: multiple blob disks per storage account  Dedicated: single blob disk per storage account  Managed: azure managed data disk (only in managed availability set). defaults to shared")
    @JsonSetter(nulls=Nulls.SKIP)
    private String kind;
    @JsonProperty(value="readOnly")
    @JsonPropertyDescription(value="readOnly Defaults to false (read/write). ReadOnly here will force\nthe ReadOnly setting in VolumeMounts.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean readOnly;

    public AzureDiskBuilder edit() {
        return new AzureDiskBuilder(this);
    }

    public String getCachingMode() {
        return this.cachingMode;
    }

    public void setCachingMode(String cachingMode) {
        this.cachingMode = cachingMode;
    }

    public String getDiskName() {
        return this.diskName;
    }

    public void setDiskName(String diskName) {
        this.diskName = diskName;
    }

    public String getDiskURI() {
        return this.diskURI;
    }

    public void setDiskURI(String diskURI) {
        this.diskURI = diskURI;
    }

    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String toString() {
        return "AzureDisk(cachingMode=" + this.getCachingMode() + ", diskName=" + this.getDiskName() + ", diskURI=" + this.getDiskURI() + ", fsType=" + this.getFsType() + ", kind=" + this.getKind() + ", readOnly=" + this.getReadOnly() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AzureDisk)) {
            return false;
        }
        AzureDisk other = (AzureDisk)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$readOnly = this.getReadOnly();
        Boolean other$readOnly = other.getReadOnly();
        if (this$readOnly == null ? other$readOnly != null : !((Object)this$readOnly).equals(other$readOnly)) {
            return false;
        }
        String this$cachingMode = this.getCachingMode();
        String other$cachingMode = other.getCachingMode();
        if (this$cachingMode == null ? other$cachingMode != null : !this$cachingMode.equals(other$cachingMode)) {
            return false;
        }
        String this$diskName = this.getDiskName();
        String other$diskName = other.getDiskName();
        if (this$diskName == null ? other$diskName != null : !this$diskName.equals(other$diskName)) {
            return false;
        }
        String this$diskURI = this.getDiskURI();
        String other$diskURI = other.getDiskURI();
        if (this$diskURI == null ? other$diskURI != null : !this$diskURI.equals(other$diskURI)) {
            return false;
        }
        String this$fsType = this.getFsType();
        String other$fsType = other.getFsType();
        if (this$fsType == null ? other$fsType != null : !this$fsType.equals(other$fsType)) {
            return false;
        }
        String this$kind = this.getKind();
        String other$kind = other.getKind();
        return !(this$kind == null ? other$kind != null : !this$kind.equals(other$kind));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AzureDisk;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $readOnly = this.getReadOnly();
        result = result * 59 + ($readOnly == null ? 43 : ((Object)$readOnly).hashCode());
        String $cachingMode = this.getCachingMode();
        result = result * 59 + ($cachingMode == null ? 43 : $cachingMode.hashCode());
        String $diskName = this.getDiskName();
        result = result * 59 + ($diskName == null ? 43 : $diskName.hashCode());
        String $diskURI = this.getDiskURI();
        result = result * 59 + ($diskURI == null ? 43 : $diskURI.hashCode());
        String $fsType = this.getFsType();
        result = result * 59 + ($fsType == null ? 43 : $fsType.hashCode());
        String $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : $kind.hashCode());
        return result;
    }
}

