/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationprofilespec.traits;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.camel.v1.integrationprofilespec.traits.Container;
import org.apache.camel.v1.integrationprofilespec.traits.container.Configuration;
import org.apache.camel.v1.integrationprofilespec.traits.container.ConfigurationBuilder;
import org.apache.camel.v1.integrationprofilespec.traits.container.ConfigurationFluent;

public class ContainerFluent<A extends ContainerFluent<A>>
extends BaseFluent<A> {
    private Boolean allowPrivilegeEscalation;
    private Boolean auto;
    private List<String> capabilitiesAdd;
    private List<String> capabilitiesDrop;
    private ConfigurationBuilder configuration;
    private Boolean enabled;
    private Boolean expose;
    private String image;
    private Container.ImagePullPolicy imagePullPolicy;
    private String limitCPU;
    private String limitMemory;
    private String name;
    private Long port;
    private String portName;
    private String requestCPU;
    private String requestMemory;
    private Boolean runAsNonRoot;
    private Long runAsUser;
    private Container.SeccompProfileType seccompProfileType;
    private Long servicePort;
    private String servicePortName;

    public ContainerFluent() {
    }

    public ContainerFluent(Container instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Container instance) {
        Container container = instance = instance != null ? instance : new Container();
        if (instance != null) {
            this.withAllowPrivilegeEscalation(instance.getAllowPrivilegeEscalation());
            this.withAuto(instance.getAuto());
            this.withCapabilitiesAdd(instance.getCapabilitiesAdd());
            this.withCapabilitiesDrop(instance.getCapabilitiesDrop());
            this.withConfiguration(instance.getConfiguration());
            this.withEnabled(instance.getEnabled());
            this.withExpose(instance.getExpose());
            this.withImage(instance.getImage());
            this.withImagePullPolicy(instance.getImagePullPolicy());
            this.withLimitCPU(instance.getLimitCPU());
            this.withLimitMemory(instance.getLimitMemory());
            this.withName(instance.getName());
            this.withPort(instance.getPort());
            this.withPortName(instance.getPortName());
            this.withRequestCPU(instance.getRequestCPU());
            this.withRequestMemory(instance.getRequestMemory());
            this.withRunAsNonRoot(instance.getRunAsNonRoot());
            this.withRunAsUser(instance.getRunAsUser());
            this.withSeccompProfileType(instance.getSeccompProfileType());
            this.withServicePort(instance.getServicePort());
            this.withServicePortName(instance.getServicePortName());
        }
    }

    public Boolean getAllowPrivilegeEscalation() {
        return this.allowPrivilegeEscalation;
    }

    public A withAllowPrivilegeEscalation(Boolean allowPrivilegeEscalation) {
        this.allowPrivilegeEscalation = allowPrivilegeEscalation;
        return (A)((Object)this);
    }

    public boolean hasAllowPrivilegeEscalation() {
        return this.allowPrivilegeEscalation != null;
    }

    public Boolean getAuto() {
        return this.auto;
    }

    public A withAuto(Boolean auto) {
        this.auto = auto;
        return (A)((Object)this);
    }

    public boolean hasAuto() {
        return this.auto != null;
    }

    public A addToCapabilitiesAdd(int index, String item) {
        if (this.capabilitiesAdd == null) {
            this.capabilitiesAdd = new ArrayList<String>();
        }
        this.capabilitiesAdd.add(index, item);
        return (A)((Object)this);
    }

    public A setToCapabilitiesAdd(int index, String item) {
        if (this.capabilitiesAdd == null) {
            this.capabilitiesAdd = new ArrayList<String>();
        }
        this.capabilitiesAdd.set(index, item);
        return (A)((Object)this);
    }

    public A addToCapabilitiesAdd(String ... items) {
        if (this.capabilitiesAdd == null) {
            this.capabilitiesAdd = new ArrayList<String>();
        }
        for (String item : items) {
            this.capabilitiesAdd.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToCapabilitiesAdd(Collection<String> items) {
        if (this.capabilitiesAdd == null) {
            this.capabilitiesAdd = new ArrayList<String>();
        }
        for (String item : items) {
            this.capabilitiesAdd.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromCapabilitiesAdd(String ... items) {
        if (this.capabilitiesAdd == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.capabilitiesAdd.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromCapabilitiesAdd(Collection<String> items) {
        if (this.capabilitiesAdd == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.capabilitiesAdd.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getCapabilitiesAdd() {
        return this.capabilitiesAdd;
    }

    public String getCapabilitiesAdd(int index) {
        return this.capabilitiesAdd.get(index);
    }

    public String getFirstCapabilitiesAdd() {
        return this.capabilitiesAdd.get(0);
    }

    public String getLastCapabilitiesAdd() {
        return this.capabilitiesAdd.get(this.capabilitiesAdd.size() - 1);
    }

    public String getMatchingCapabilitiesAdd(Predicate<String> predicate) {
        for (String item : this.capabilitiesAdd) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCapabilitiesAdd(Predicate<String> predicate) {
        for (String item : this.capabilitiesAdd) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCapabilitiesAdd(List<String> capabilitiesAdd) {
        if (capabilitiesAdd != null) {
            this.capabilitiesAdd = new ArrayList<String>();
            for (String item : capabilitiesAdd) {
                this.addToCapabilitiesAdd(item);
            }
        } else {
            this.capabilitiesAdd = null;
        }
        return (A)((Object)this);
    }

    public A withCapabilitiesAdd(String ... capabilitiesAdd) {
        if (this.capabilitiesAdd != null) {
            this.capabilitiesAdd.clear();
            this._visitables.remove((Object)"capabilitiesAdd");
        }
        if (capabilitiesAdd != null) {
            for (String item : capabilitiesAdd) {
                this.addToCapabilitiesAdd(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasCapabilitiesAdd() {
        return this.capabilitiesAdd != null && !this.capabilitiesAdd.isEmpty();
    }

    public A addToCapabilitiesDrop(int index, String item) {
        if (this.capabilitiesDrop == null) {
            this.capabilitiesDrop = new ArrayList<String>();
        }
        this.capabilitiesDrop.add(index, item);
        return (A)((Object)this);
    }

    public A setToCapabilitiesDrop(int index, String item) {
        if (this.capabilitiesDrop == null) {
            this.capabilitiesDrop = new ArrayList<String>();
        }
        this.capabilitiesDrop.set(index, item);
        return (A)((Object)this);
    }

    public A addToCapabilitiesDrop(String ... items) {
        if (this.capabilitiesDrop == null) {
            this.capabilitiesDrop = new ArrayList<String>();
        }
        for (String item : items) {
            this.capabilitiesDrop.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToCapabilitiesDrop(Collection<String> items) {
        if (this.capabilitiesDrop == null) {
            this.capabilitiesDrop = new ArrayList<String>();
        }
        for (String item : items) {
            this.capabilitiesDrop.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromCapabilitiesDrop(String ... items) {
        if (this.capabilitiesDrop == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.capabilitiesDrop.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromCapabilitiesDrop(Collection<String> items) {
        if (this.capabilitiesDrop == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.capabilitiesDrop.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getCapabilitiesDrop() {
        return this.capabilitiesDrop;
    }

    public String getCapabilitiesDrop(int index) {
        return this.capabilitiesDrop.get(index);
    }

    public String getFirstCapabilitiesDrop() {
        return this.capabilitiesDrop.get(0);
    }

    public String getLastCapabilitiesDrop() {
        return this.capabilitiesDrop.get(this.capabilitiesDrop.size() - 1);
    }

    public String getMatchingCapabilitiesDrop(Predicate<String> predicate) {
        for (String item : this.capabilitiesDrop) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCapabilitiesDrop(Predicate<String> predicate) {
        for (String item : this.capabilitiesDrop) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCapabilitiesDrop(List<String> capabilitiesDrop) {
        if (capabilitiesDrop != null) {
            this.capabilitiesDrop = new ArrayList<String>();
            for (String item : capabilitiesDrop) {
                this.addToCapabilitiesDrop(item);
            }
        } else {
            this.capabilitiesDrop = null;
        }
        return (A)((Object)this);
    }

    public A withCapabilitiesDrop(String ... capabilitiesDrop) {
        if (this.capabilitiesDrop != null) {
            this.capabilitiesDrop.clear();
            this._visitables.remove((Object)"capabilitiesDrop");
        }
        if (capabilitiesDrop != null) {
            for (String item : capabilitiesDrop) {
                this.addToCapabilitiesDrop(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasCapabilitiesDrop() {
        return this.capabilitiesDrop != null && !this.capabilitiesDrop.isEmpty();
    }

    public Configuration buildConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    public A withConfiguration(Configuration configuration) {
        this._visitables.remove((Object)"configuration");
        if (configuration != null) {
            this.configuration = new ConfigurationBuilder(configuration);
            this._visitables.get((Object)"configuration").add(this.configuration);
        } else {
            this.configuration = null;
            this._visitables.get((Object)"configuration").remove((Object)this.configuration);
        }
        return (A)((Object)this);
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public ConfigurationNested<A> withNewConfiguration() {
        return new ConfigurationNested(null);
    }

    public ConfigurationNested<A> withNewConfigurationLike(Configuration item) {
        return new ConfigurationNested(item);
    }

    public ConfigurationNested<A> editConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(null));
    }

    public ConfigurationNested<A> editOrNewConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(new ConfigurationBuilder().build()));
    }

    public ConfigurationNested<A> editOrNewConfigurationLike(Configuration item) {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(item));
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)((Object)this);
    }

    public boolean hasEnabled() {
        return this.enabled != null;
    }

    public Boolean getExpose() {
        return this.expose;
    }

    public A withExpose(Boolean expose) {
        this.expose = expose;
        return (A)((Object)this);
    }

    public boolean hasExpose() {
        return this.expose != null;
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image = image;
        return (A)((Object)this);
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public Container.ImagePullPolicy getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public A withImagePullPolicy(Container.ImagePullPolicy imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
        return (A)((Object)this);
    }

    public boolean hasImagePullPolicy() {
        return this.imagePullPolicy != null;
    }

    public String getLimitCPU() {
        return this.limitCPU;
    }

    public A withLimitCPU(String limitCPU) {
        this.limitCPU = limitCPU;
        return (A)((Object)this);
    }

    public boolean hasLimitCPU() {
        return this.limitCPU != null;
    }

    public String getLimitMemory() {
        return this.limitMemory;
    }

    public A withLimitMemory(String limitMemory) {
        this.limitMemory = limitMemory;
        return (A)((Object)this);
    }

    public boolean hasLimitMemory() {
        return this.limitMemory != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public Long getPort() {
        return this.port;
    }

    public A withPort(Long port) {
        this.port = port;
        return (A)((Object)this);
    }

    public boolean hasPort() {
        return this.port != null;
    }

    public String getPortName() {
        return this.portName;
    }

    public A withPortName(String portName) {
        this.portName = portName;
        return (A)((Object)this);
    }

    public boolean hasPortName() {
        return this.portName != null;
    }

    public String getRequestCPU() {
        return this.requestCPU;
    }

    public A withRequestCPU(String requestCPU) {
        this.requestCPU = requestCPU;
        return (A)((Object)this);
    }

    public boolean hasRequestCPU() {
        return this.requestCPU != null;
    }

    public String getRequestMemory() {
        return this.requestMemory;
    }

    public A withRequestMemory(String requestMemory) {
        this.requestMemory = requestMemory;
        return (A)((Object)this);
    }

    public boolean hasRequestMemory() {
        return this.requestMemory != null;
    }

    public Boolean getRunAsNonRoot() {
        return this.runAsNonRoot;
    }

    public A withRunAsNonRoot(Boolean runAsNonRoot) {
        this.runAsNonRoot = runAsNonRoot;
        return (A)((Object)this);
    }

    public boolean hasRunAsNonRoot() {
        return this.runAsNonRoot != null;
    }

    public Long getRunAsUser() {
        return this.runAsUser;
    }

    public A withRunAsUser(Long runAsUser) {
        this.runAsUser = runAsUser;
        return (A)((Object)this);
    }

    public boolean hasRunAsUser() {
        return this.runAsUser != null;
    }

    public Container.SeccompProfileType getSeccompProfileType() {
        return this.seccompProfileType;
    }

    public A withSeccompProfileType(Container.SeccompProfileType seccompProfileType) {
        this.seccompProfileType = seccompProfileType;
        return (A)((Object)this);
    }

    public boolean hasSeccompProfileType() {
        return this.seccompProfileType != null;
    }

    public Long getServicePort() {
        return this.servicePort;
    }

    public A withServicePort(Long servicePort) {
        this.servicePort = servicePort;
        return (A)((Object)this);
    }

    public boolean hasServicePort() {
        return this.servicePort != null;
    }

    public String getServicePortName() {
        return this.servicePortName;
    }

    public A withServicePortName(String servicePortName) {
        this.servicePortName = servicePortName;
        return (A)((Object)this);
    }

    public boolean hasServicePortName() {
        return this.servicePortName != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerFluent that = (ContainerFluent)((Object)o);
        if (!Objects.equals(this.allowPrivilegeEscalation, that.allowPrivilegeEscalation)) {
            return false;
        }
        if (!Objects.equals(this.auto, that.auto)) {
            return false;
        }
        if (!Objects.equals(this.capabilitiesAdd, that.capabilitiesAdd)) {
            return false;
        }
        if (!Objects.equals(this.capabilitiesDrop, that.capabilitiesDrop)) {
            return false;
        }
        if (!Objects.equals((Object)this.configuration, (Object)that.configuration)) {
            return false;
        }
        if (!Objects.equals(this.enabled, that.enabled)) {
            return false;
        }
        if (!Objects.equals(this.expose, that.expose)) {
            return false;
        }
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals((Object)this.imagePullPolicy, (Object)that.imagePullPolicy)) {
            return false;
        }
        if (!Objects.equals(this.limitCPU, that.limitCPU)) {
            return false;
        }
        if (!Objects.equals(this.limitMemory, that.limitMemory)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.port, that.port)) {
            return false;
        }
        if (!Objects.equals(this.portName, that.portName)) {
            return false;
        }
        if (!Objects.equals(this.requestCPU, that.requestCPU)) {
            return false;
        }
        if (!Objects.equals(this.requestMemory, that.requestMemory)) {
            return false;
        }
        if (!Objects.equals(this.runAsNonRoot, that.runAsNonRoot)) {
            return false;
        }
        if (!Objects.equals(this.runAsUser, that.runAsUser)) {
            return false;
        }
        if (!Objects.equals((Object)this.seccompProfileType, (Object)that.seccompProfileType)) {
            return false;
        }
        if (!Objects.equals(this.servicePort, that.servicePort)) {
            return false;
        }
        return Objects.equals(this.servicePortName, that.servicePortName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.allowPrivilegeEscalation, this.auto, this.capabilitiesAdd, this.capabilitiesDrop, this.configuration, this.enabled, this.expose, this.image, this.imagePullPolicy, this.limitCPU, this.limitMemory, this.name, this.port, this.portName, this.requestCPU, this.requestMemory, this.runAsNonRoot, this.runAsUser, this.seccompProfileType, this.servicePort, this.servicePortName, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allowPrivilegeEscalation != null) {
            sb.append("allowPrivilegeEscalation:");
            sb.append(this.allowPrivilegeEscalation + ",");
        }
        if (this.auto != null) {
            sb.append("auto:");
            sb.append(this.auto + ",");
        }
        if (this.capabilitiesAdd != null && !this.capabilitiesAdd.isEmpty()) {
            sb.append("capabilitiesAdd:");
            sb.append(this.capabilitiesAdd + ",");
        }
        if (this.capabilitiesDrop != null && !this.capabilitiesDrop.isEmpty()) {
            sb.append("capabilitiesDrop:");
            sb.append(this.capabilitiesDrop + ",");
        }
        if (this.configuration != null) {
            sb.append("configuration:");
            sb.append(this.configuration + ",");
        }
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled + ",");
        }
        if (this.expose != null) {
            sb.append("expose:");
            sb.append(this.expose + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.imagePullPolicy != null) {
            sb.append("imagePullPolicy:");
            sb.append(this.imagePullPolicy + ",");
        }
        if (this.limitCPU != null) {
            sb.append("limitCPU:");
            sb.append(this.limitCPU + ",");
        }
        if (this.limitMemory != null) {
            sb.append("limitMemory:");
            sb.append(this.limitMemory + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append(this.port + ",");
        }
        if (this.portName != null) {
            sb.append("portName:");
            sb.append(this.portName + ",");
        }
        if (this.requestCPU != null) {
            sb.append("requestCPU:");
            sb.append(this.requestCPU + ",");
        }
        if (this.requestMemory != null) {
            sb.append("requestMemory:");
            sb.append(this.requestMemory + ",");
        }
        if (this.runAsNonRoot != null) {
            sb.append("runAsNonRoot:");
            sb.append(this.runAsNonRoot + ",");
        }
        if (this.runAsUser != null) {
            sb.append("runAsUser:");
            sb.append(this.runAsUser + ",");
        }
        if (this.seccompProfileType != null) {
            sb.append("seccompProfileType:");
            sb.append(this.seccompProfileType + ",");
        }
        if (this.servicePort != null) {
            sb.append("servicePort:");
            sb.append(this.servicePort + ",");
        }
        if (this.servicePortName != null) {
            sb.append("servicePortName:");
            sb.append(this.servicePortName);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAllowPrivilegeEscalation() {
        return this.withAllowPrivilegeEscalation(true);
    }

    public A withAuto() {
        return this.withAuto(true);
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }

    public A withExpose() {
        return this.withExpose(true);
    }

    public A withRunAsNonRoot() {
        return this.withRunAsNonRoot(true);
    }

    public class ConfigurationNested<N>
    extends ConfigurationFluent<ConfigurationNested<N>>
    implements Nested<N> {
        ConfigurationBuilder builder;

        ConfigurationNested(Configuration item) {
            this.builder = new ConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)ContainerFluent.this.withConfiguration(this.builder.build());
        }

        public N endConfiguration() {
            return this.and();
        }
    }
}

