/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.camelcatalogspec.artifacts.schemes.producer;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.camel.v1.camelcatalogspec.artifacts.schemes.producer.Dependencies;
import org.apache.camel.v1.camelcatalogspec.artifacts.schemes.producer.dependencies.Exclusions;
import org.apache.camel.v1.camelcatalogspec.artifacts.schemes.producer.dependencies.ExclusionsBuilder;
import org.apache.camel.v1.camelcatalogspec.artifacts.schemes.producer.dependencies.ExclusionsFluent;

public class DependenciesFluent<A extends DependenciesFluent<A>>
extends BaseFluent<A> {
    private String artifactId;
    private String classifier;
    private ArrayList<ExclusionsBuilder> exclusions;
    private String groupId;
    private String type;
    private String version;

    public DependenciesFluent() {
    }

    public DependenciesFluent(Dependencies instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Dependencies instance) {
        Dependencies dependencies = instance = instance != null ? instance : new Dependencies();
        if (instance != null) {
            this.withArtifactId(instance.getArtifactId());
            this.withClassifier(instance.getClassifier());
            this.withExclusions(instance.getExclusions());
            this.withGroupId(instance.getGroupId());
            this.withType(instance.getType());
            this.withVersion(instance.getVersion());
        }
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public A withArtifactId(String artifactId) {
        this.artifactId = artifactId;
        return (A)((Object)this);
    }

    public boolean hasArtifactId() {
        return this.artifactId != null;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public A withClassifier(String classifier) {
        this.classifier = classifier;
        return (A)((Object)this);
    }

    public boolean hasClassifier() {
        return this.classifier != null;
    }

    public A addToExclusions(int index, Exclusions item) {
        if (this.exclusions == null) {
            this.exclusions = new ArrayList();
        }
        ExclusionsBuilder builder = new ExclusionsBuilder(item);
        if (index < 0 || index >= this.exclusions.size()) {
            this._visitables.get((Object)"exclusions").add(builder);
            this.exclusions.add(builder);
        } else {
            this._visitables.get((Object)"exclusions").add(index, builder);
            this.exclusions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToExclusions(int index, Exclusions item) {
        if (this.exclusions == null) {
            this.exclusions = new ArrayList();
        }
        ExclusionsBuilder builder = new ExclusionsBuilder(item);
        if (index < 0 || index >= this.exclusions.size()) {
            this._visitables.get((Object)"exclusions").add(builder);
            this.exclusions.add(builder);
        } else {
            this._visitables.get((Object)"exclusions").set(index, builder);
            this.exclusions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToExclusions(Exclusions ... items) {
        if (this.exclusions == null) {
            this.exclusions = new ArrayList();
        }
        for (Exclusions item : items) {
            ExclusionsBuilder builder = new ExclusionsBuilder(item);
            this._visitables.get((Object)"exclusions").add(builder);
            this.exclusions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToDependenciesExclusions(Collection<Exclusions> items) {
        if (this.exclusions == null) {
            this.exclusions = new ArrayList();
        }
        for (Exclusions item : items) {
            ExclusionsBuilder builder = new ExclusionsBuilder(item);
            this._visitables.get((Object)"exclusions").add(builder);
            this.exclusions.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromExclusions(Exclusions ... items) {
        if (this.exclusions == null) {
            return (A)((Object)this);
        }
        for (Exclusions item : items) {
            ExclusionsBuilder builder = new ExclusionsBuilder(item);
            this._visitables.get((Object)"exclusions").remove((Object)builder);
            this.exclusions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromDependenciesExclusions(Collection<Exclusions> items) {
        if (this.exclusions == null) {
            return (A)((Object)this);
        }
        for (Exclusions item : items) {
            ExclusionsBuilder builder = new ExclusionsBuilder(item);
            this._visitables.get((Object)"exclusions").remove((Object)builder);
            this.exclusions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromDependenciesExclusions(Predicate<ExclusionsBuilder> predicate) {
        if (this.exclusions == null) {
            return (A)((Object)this);
        }
        Iterator<ExclusionsBuilder> each = this.exclusions.iterator();
        List visitables = this._visitables.get((Object)"exclusions");
        while (each.hasNext()) {
            ExclusionsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Exclusions> buildExclusions() {
        return this.exclusions != null ? DependenciesFluent.build(this.exclusions) : null;
    }

    public Exclusions buildExclusion(int index) {
        return this.exclusions.get(index).build();
    }

    public Exclusions buildFirstExclusion() {
        return this.exclusions.get(0).build();
    }

    public Exclusions buildLastExclusion() {
        return this.exclusions.get(this.exclusions.size() - 1).build();
    }

    public Exclusions buildMatchingExclusion(Predicate<ExclusionsBuilder> predicate) {
        for (ExclusionsBuilder item : this.exclusions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingExclusion(Predicate<ExclusionsBuilder> predicate) {
        for (ExclusionsBuilder item : this.exclusions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withExclusions(List<Exclusions> exclusions) {
        if (this.exclusions != null) {
            this._visitables.get((Object)"exclusions").clear();
        }
        if (exclusions != null) {
            this.exclusions = new ArrayList();
            for (Exclusions item : exclusions) {
                this.addToExclusions(item);
            }
        } else {
            this.exclusions = null;
        }
        return (A)((Object)this);
    }

    public A withExclusions(Exclusions ... exclusions) {
        if (this.exclusions != null) {
            this.exclusions.clear();
            this._visitables.remove((Object)"exclusions");
        }
        if (exclusions != null) {
            for (Exclusions item : exclusions) {
                this.addToExclusions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasExclusions() {
        return this.exclusions != null && !this.exclusions.isEmpty();
    }

    public ExclusionsNested<A> addNewExclusion() {
        return new ExclusionsNested(-1, null);
    }

    public ExclusionsNested<A> addNewExclusionLike(Exclusions item) {
        return new ExclusionsNested(-1, item);
    }

    public ExclusionsNested<A> setNewExclusionLike(int index, Exclusions item) {
        return new ExclusionsNested(index, item);
    }

    public ExclusionsNested<A> editExclusion(int index) {
        if (this.exclusions.size() <= index) {
            throw new RuntimeException("Can't edit exclusions. Index exceeds size.");
        }
        return this.setNewExclusionLike(index, this.buildExclusion(index));
    }

    public ExclusionsNested<A> editFirstExclusion() {
        if (this.exclusions.size() == 0) {
            throw new RuntimeException("Can't edit first exclusions. The list is empty.");
        }
        return this.setNewExclusionLike(0, this.buildExclusion(0));
    }

    public ExclusionsNested<A> editLastExclusion() {
        int index = this.exclusions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last exclusions. The list is empty.");
        }
        return this.setNewExclusionLike(index, this.buildExclusion(index));
    }

    public ExclusionsNested<A> editMatchingExclusion(Predicate<ExclusionsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.exclusions.size(); ++i) {
            if (!predicate.test(this.exclusions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching exclusions. No match found.");
        }
        return this.setNewExclusionLike(index, this.buildExclusion(index));
    }

    public String getGroupId() {
        return this.groupId;
    }

    public A withGroupId(String groupId) {
        this.groupId = groupId;
        return (A)((Object)this);
    }

    public boolean hasGroupId() {
        return this.groupId != null;
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type = type;
        return (A)((Object)this);
    }

    public boolean hasType() {
        return this.type != null;
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version = version;
        return (A)((Object)this);
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DependenciesFluent that = (DependenciesFluent)((Object)o);
        if (!Objects.equals(this.artifactId, that.artifactId)) {
            return false;
        }
        if (!Objects.equals(this.classifier, that.classifier)) {
            return false;
        }
        if (!Objects.equals(this.exclusions, that.exclusions)) {
            return false;
        }
        if (!Objects.equals(this.groupId, that.groupId)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        return Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.artifactId, this.classifier, this.exclusions, this.groupId, this.type, this.version, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.artifactId != null) {
            sb.append("artifactId:");
            sb.append(this.artifactId + ",");
        }
        if (this.classifier != null) {
            sb.append("classifier:");
            sb.append(this.classifier + ",");
        }
        if (this.exclusions != null && !this.exclusions.isEmpty()) {
            sb.append("exclusions:");
            sb.append(this.exclusions + ",");
        }
        if (this.groupId != null) {
            sb.append("groupId:");
            sb.append(this.groupId + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ExclusionsNested<N>
    extends ExclusionsFluent<ExclusionsNested<N>>
    implements Nested<N> {
        ExclusionsBuilder builder;
        int index;

        ExclusionsNested(int index, Exclusions item) {
            this.index = index;
            this.builder = new ExclusionsBuilder(this, item);
        }

        public N and() {
            return (N)DependenciesFluent.this.setToExclusions(this.index, this.builder.build());
        }

        public N endDependenciesExclusion() {
            return this.and();
        }
    }
}

