/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds.networking;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.List;
import org.apache.brooklyn.api.effector.Effector;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.effector.EffectorBody;
import org.apache.brooklyn.core.effector.Effectors;
import org.apache.brooklyn.core.location.Locations;
import org.apache.brooklyn.location.jclouds.JcloudsLocation;
import org.apache.brooklyn.location.jclouds.JcloudsMachineLocation;
import org.apache.brooklyn.location.jclouds.networking.SharedLocationSecurityGroupCustomizer;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.jclouds.compute.domain.SecurityGroup;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;

public class NetworkingEffectors {
    public static final ConfigKey<List<String>> INBOUND_PORTS_LIST = ConfigKeys.newConfigKey((TypeToken)new TypeToken<List<String>>(){}, (String)"inbound.ports.list", (String)"Ports to open from the effector", (Object)ImmutableList.of());
    public static final ConfigKey<IpProtocol> INBOUND_PORTS_LIST_PROTOCOL = ConfigKeys.newConfigKey((TypeToken)new TypeToken<IpProtocol>(){}, (String)"inbound.ports.list.protocol", (String)"Protocol for ports to open. Possible values: TCP, UDP, ICMP.", (Object)IpProtocol.TCP);
    public static final ConfigKey<JcloudsMachineLocation> JCLOUDS_MACHINE_LOCATIN = ConfigKeys.newConfigKey(JcloudsMachineLocation.class, (String)"jcloudsMachineLocation");
    @Beta
    public static final Effector<Iterable<IpPermission>> OPEN_INBOUND_PORTS_IN_SECURITY_GROUP_EFFECTOR = Effectors.effector(Iterable.class, (String)"openPortsInSecurityGroup").parameter(INBOUND_PORTS_LIST).parameter(INBOUND_PORTS_LIST_PROTOCOL).description("Open ports in Cloud Security Group. If called before machine location is provisioned, it will fail.").impl((EffectorBody)new OpenPortsInSecurityGroupBody()).build();

    private static class OpenPortsInSecurityGroupBody
    extends EffectorBody<Iterable> {
        private OpenPortsInSecurityGroupBody() {
        }

        public Collection<SecurityGroup> call(ConfigBag parameters) {
            List rawPortRules = (List)parameters.get(INBOUND_PORTS_LIST);
            IpProtocol ipProtocol = (IpProtocol)parameters.get(INBOUND_PORTS_LIST_PROTOCOL);
            Preconditions.checkNotNull((Object)ipProtocol, (Object)(INBOUND_PORTS_LIST_PROTOCOL.getName() + " cannot be null"));
            Preconditions.checkNotNull((Object)rawPortRules, (Object)(INBOUND_PORTS_LIST.getName() + " cannot be null"));
            SharedLocationSecurityGroupCustomizer locationSecurityGroupCustomizer = new SharedLocationSecurityGroupCustomizer();
            if (IpProtocol.TCP.equals((Object)ipProtocol)) {
                locationSecurityGroupCustomizer.setTcpPortRanges(rawPortRules);
            } else if (IpProtocol.UDP.equals((Object)ipProtocol)) {
                locationSecurityGroupCustomizer.setUdpPortRanges(rawPortRules);
            } else if (IpProtocol.ICMP.equals((Object)ipProtocol)) {
                locationSecurityGroupCustomizer.setOpenIcmp(true);
            }
            Optional jcloudsMachineLocationOptional = Iterables.tryFind((Iterable)Locations.getLocationsCheckingAncestors(null, (Entity)this.entity()), (Predicate)Predicates.instanceOf(JcloudsMachineLocation.class));
            if (!jcloudsMachineLocationOptional.isPresent()) {
                throw new IllegalArgumentException("Tried to execute open ports effector on an entity with no JcloudsMachineLocation");
            }
            JcloudsLocation jcloudsLocation = ((JcloudsMachineLocation)jcloudsMachineLocationOptional.get()).getParent();
            return locationSecurityGroupCustomizer.applySecurityGroupCustomizations(jcloudsLocation, jcloudsLocation.getComputeService(), (JcloudsMachineLocation)jcloudsMachineLocationOptional.get());
        }
    }
}

