/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.domain;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.net.URI;
import java.util.Map;
import org.jclouds.scriptbuilder.domain.InterpretableStatement;

public class SaveHttpResponseTo
extends InterpretableStatement {
    public static final String CURL = "curl -q -s -S -L --connect-timeout 10 --max-time 600 --retry 20";

    public SaveHttpResponseTo(String dir, String file, String method, URI endpoint, Multimap<String, String> headers) {
        super(String.format("({md} %s && {cd} %s && [ ! -f %s ] && %s -C - -X %s %s %s >%s)\n", dir, dir, file, CURL, method, Joiner.on((char)' ').join(Iterables.transform((Iterable)headers.entries(), (Function)new Function<Map.Entry<String, String>, String>(){

            public String apply(Map.Entry<String, String> from) {
                return String.format("-H \"%s: %s\"", from.getKey(), from.getValue());
            }
        })), endpoint.toASCIIString(), file));
    }
}

