/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.policy.followthesun;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.location.Location;
import org.apache.brooklyn.api.location.MachineProvisioningLocation;
import org.apache.brooklyn.api.sensor.AttributeSensor;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEvent;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.policy.AbstractPolicy;
import org.apache.brooklyn.policy.followthesun.FollowTheSunModel;
import org.apache.brooklyn.policy.followthesun.FollowTheSunParameters;
import org.apache.brooklyn.policy.followthesun.FollowTheSunPool;
import org.apache.brooklyn.policy.followthesun.FollowTheSunStrategy;
import org.apache.brooklyn.policy.loadbalancing.Movable;
import org.apache.brooklyn.util.JavaGroovyEquivalents;
import org.apache.brooklyn.util.collections.MutableMap;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FollowTheSunPolicy
extends AbstractPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(FollowTheSunPolicy.class);
    public static final String NAME = "Follow the Sun (Inter-Geography Latency Optimization)";
    @SetFromFlag(defaultVal="100")
    private long minPeriodBetweenExecs;
    @SetFromFlag
    private Function<Entity, Location> locationFinder;
    private final AttributeSensor<Map<? extends Movable, Double>> itemUsageMetric;
    private final FollowTheSunModel<Entity, Movable> model;
    private final FollowTheSunStrategy<Entity, Movable> strategy;
    private final FollowTheSunParameters parameters;
    private FollowTheSunPool poolEntity;
    private volatile ScheduledExecutorService executor;
    private final AtomicBoolean executorQueued = new AtomicBoolean(false);
    private volatile long executorTime = 0L;
    private boolean loggedConstraintsIgnored = false;
    private final Function<Entity, Location> defaultLocationFinder = new Function<Entity, Location>(){

        public Location apply(Entity e) {
            Collection locs = e.getLocations();
            if (locs.isEmpty()) {
                return null;
            }
            Location contender = (Location)Iterables.get((Iterable)locs, (int)0);
            while (contender.getParent() != null && !(contender instanceof MachineProvisioningLocation)) {
                contender = contender.getParent();
            }
            return contender;
        }
    };
    private final SensorEventListener<Object> eventHandler = new SensorEventListener<Object>(){

        public void onEvent(SensorEvent<Object> event) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("{} received event {}", (Object)FollowTheSunPolicy.this, event);
            }
            Entity source = event.getSource();
            Object value = event.getValue();
            Sensor sensor = event.getSensor();
            if (sensor.equals(FollowTheSunPolicy.this.itemUsageMetric)) {
                FollowTheSunPolicy.this.onItemMetricUpdated((Movable)source, (Map)value, true);
            } else if (sensor.equals(Attributes.LOCATION_CHANGED)) {
                FollowTheSunPolicy.this.onContainerLocationUpdated(source, true);
            } else if (sensor.equals(FollowTheSunPool.CONTAINER_ADDED)) {
                FollowTheSunPolicy.this.onContainerAdded((Entity)value, true);
            } else if (sensor.equals(FollowTheSunPool.CONTAINER_REMOVED)) {
                FollowTheSunPolicy.this.onContainerRemoved((Entity)value, true);
            } else if (sensor.equals(FollowTheSunPool.ITEM_ADDED)) {
                FollowTheSunPolicy.this.onItemAdded((Movable)value, true);
            } else if (sensor.equals(FollowTheSunPool.ITEM_REMOVED)) {
                FollowTheSunPolicy.this.onItemRemoved((Movable)value, true);
            } else if (sensor.equals(FollowTheSunPool.ITEM_MOVED)) {
                FollowTheSunPool.ContainerItemPair pair = (FollowTheSunPool.ContainerItemPair)value;
                FollowTheSunPolicy.this.onItemMoved((Movable)pair.item, pair.container, true);
            }
        }
    };

    public FollowTheSunPolicy(AttributeSensor itemUsageMetric, FollowTheSunModel<Entity, Movable> model, FollowTheSunParameters parameters) {
        this((Map)MutableMap.of(), itemUsageMetric, model, parameters);
    }

    public FollowTheSunPolicy(Map props, AttributeSensor itemUsageMetric, FollowTheSunModel<Entity, Movable> model, FollowTheSunParameters parameters) {
        super(props);
        this.itemUsageMetric = itemUsageMetric;
        this.model = model;
        this.parameters = parameters;
        this.strategy = new FollowTheSunStrategy<Entity, Movable>(model, parameters);
        this.locationFinder = (Function)JavaGroovyEquivalents.elvis(this.locationFinder, this.defaultLocationFinder);
        this.executor = Executors.newSingleThreadScheduledExecutor(this.newThreadFactory());
    }

    public void setEntity(EntityLocal entity) {
        Preconditions.checkArgument((boolean)(entity instanceof FollowTheSunPool), (Object)"Provided entity must be a FollowTheSunPool");
        super.setEntity(entity);
        this.poolEntity = (FollowTheSunPool)entity;
        this.subscriptions().subscribe((Entity)this.poolEntity, FollowTheSunPool.CONTAINER_ADDED, this.eventHandler);
        this.subscriptions().subscribe((Entity)this.poolEntity, FollowTheSunPool.CONTAINER_REMOVED, this.eventHandler);
        this.subscriptions().subscribe((Entity)this.poolEntity, FollowTheSunPool.ITEM_ADDED, this.eventHandler);
        this.subscriptions().subscribe((Entity)this.poolEntity, FollowTheSunPool.ITEM_REMOVED, this.eventHandler);
        this.subscriptions().subscribe((Entity)this.poolEntity, FollowTheSunPool.ITEM_MOVED, this.eventHandler);
        for (Entity container : this.poolEntity.getContainerGroup().getMembers()) {
            this.onContainerAdded(container, false);
        }
        for (Entity item : this.poolEntity.getItemGroup().getMembers()) {
            this.onItemAdded((Movable)item, false);
        }
        this.scheduleLatencyReductionJig();
    }

    public void suspend() {
        super.suspend();
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        this.executorQueued.set(false);
    }

    public void resume() {
        super.resume();
        this.executor = Executors.newSingleThreadScheduledExecutor(this.newThreadFactory());
        this.executorTime = 0L;
        this.executorQueued.set(false);
    }

    private ThreadFactory newThreadFactory() {
        return new ThreadFactoryBuilder().setNameFormat("brooklyn-followthesunpolicy-%d").build();
    }

    private void scheduleLatencyReductionJig() {
        if (this.isRunning() && this.executorQueued.compareAndSet(false, true)) {
            long now = System.currentTimeMillis();
            long delay = Math.max(0L, this.executorTime + this.minPeriodBetweenExecs - now);
            this.executor.schedule(new Runnable(){

                @Override
                public void run() {
                    try {
                        FollowTheSunPolicy.this.executorTime = System.currentTimeMillis();
                        FollowTheSunPolicy.this.executorQueued.set(false);
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("{} executing follow-the-sun migration-strategy", (Object)this);
                        }
                        FollowTheSunPolicy.this.strategy.rebalance();
                    }
                    catch (RuntimeException e) {
                        if (FollowTheSunPolicy.this.isRunning()) {
                            LOG.error("Error during latency-reduction-jig", (Throwable)e);
                        }
                        LOG.debug("Error during latency-reduction-jig, but no longer running", (Throwable)e);
                    }
                }
            }, delay, TimeUnit.MILLISECONDS);
        }
    }

    private void onContainerAdded(Entity container, boolean rebalanceNow) {
        this.subscriptions().subscribe(container, (Sensor)Attributes.LOCATION_CHANGED, this.eventHandler);
        Location location = (Location)this.locationFinder.apply((Object)container);
        if (LOG.isTraceEnabled()) {
            LOG.trace("{} recording addition of container {} in location {}", new Object[]{this, container, location});
        }
        this.model.onContainerAdded(container, location);
        if (rebalanceNow) {
            this.scheduleLatencyReductionJig();
        }
    }

    private void onContainerRemoved(Entity container, boolean rebalanceNow) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("{} recording removal of container {}", (Object)this, (Object)container);
        }
        this.model.onContainerRemoved(container);
        if (rebalanceNow) {
            this.scheduleLatencyReductionJig();
        }
    }

    private void onItemAdded(Movable item, boolean rebalanceNow) {
        Entity parentContainer = (Entity)item.getAttribute((AttributeSensor)Movable.CONTAINER);
        if (LOG.isTraceEnabled()) {
            LOG.trace("{} recording addition of item {} in container {}", new Object[]{this, item, parentContainer});
        }
        this.subscriptions().subscribe((Entity)item, this.itemUsageMetric, this.eventHandler);
        Map currentValue = (Map)item.getAttribute(this.itemUsageMetric);
        boolean immovable = (Boolean)JavaGroovyEquivalents.elvis((Object)item.getConfig(Movable.IMMOVABLE), (Object)false);
        this.model.onItemAdded(item, parentContainer, immovable);
        if (currentValue != null) {
            this.model.onItemUsageUpdated(item, currentValue);
        }
        if (rebalanceNow) {
            this.scheduleLatencyReductionJig();
        }
    }

    private void onItemRemoved(Movable item, boolean rebalanceNow) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("{} recording removal of item {}", (Object)this, (Object)item);
        }
        this.subscriptions().unsubscribe((Entity)item);
        this.model.onItemRemoved(item);
        if (rebalanceNow) {
            this.scheduleLatencyReductionJig();
        }
    }

    private void onItemMoved(Movable item, Entity parentContainer, boolean rebalanceNow) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("{} recording moving of item {} to {}", new Object[]{this, item, parentContainer});
        }
        this.model.onItemMoved(item, parentContainer);
        if (rebalanceNow) {
            this.scheduleLatencyReductionJig();
        }
    }

    private void onContainerLocationUpdated(Entity container, boolean rebalanceNow) {
        Location location = (Location)this.locationFinder.apply((Object)container);
        if (LOG.isTraceEnabled()) {
            LOG.trace("{} recording location for container {}, new value {}", new Object[]{this, container, location});
        }
        this.model.onContainerLocationUpdated(container, location);
        if (rebalanceNow) {
            this.scheduleLatencyReductionJig();
        }
    }

    private void onItemMetricUpdated(Movable item, Map<? extends Movable, Double> newValues, boolean rebalanceNow) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("{} recording usage update for item {}, new value {}", new Object[]{this, item, newValues});
        }
        this.model.onItemUsageUpdated(item, newValues);
        if (rebalanceNow) {
            this.scheduleLatencyReductionJig();
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + (JavaGroovyEquivalents.groovyTruth((String)this.name) ? "(" + this.name + ")" : "");
    }
}

