/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.features;

import com.google.common.base.Function;
import java.net.URI;
import java.util.Iterator;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.Fallbacks;
import org.jclouds.googlecloud.domain.ListPage;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.domain.TargetHttpProxy;
import org.jclouds.googlecomputeengine.internal.BaseToIteratorOfListPage;
import org.jclouds.googlecomputeengine.options.ListOptions;
import org.jclouds.googlecomputeengine.options.TargetHttpProxyOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.binders.BindToJsonPayload;

@SkipEncoding(value={47, 61})
@Consumes(value={"application/json"})
@RequestFilters(value={OAuthFilter.class})
public interface TargetHttpProxyApi {
    @Named(value="TargetHttpProxys:get")
    @GET
    @Path(value="/global/targetHttpProxies/{targetHttpProxy}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public TargetHttpProxy get(@PathParam(value="targetHttpProxy") String var1);

    @Named(value="TargetHttpProxys:insert")
    @POST
    @Produces(value={"application/json"})
    @Path(value="/global/targetHttpProxies")
    public Operation create(@BinderParam(value=BindToJsonPayload.class) TargetHttpProxyOptions var1);

    @Named(value="TargetHttpProxys:insert")
    @POST
    @Produces(value={"application/json"})
    @Path(value="/global/targetHttpProxies")
    @MapBinder(value=BindToJsonPayload.class)
    public Operation create(@PayloadParam(value="name") String var1, @PayloadParam(value="urlMap") URI var2);

    @Named(value="TargetHttpProxys:setUrlMap")
    @POST
    @Produces(value={"application/json"})
    @Path(value="targetHttpProxies/{targetHttpProxy}/setUrlMap")
    @MapBinder(value=BindToJsonPayload.class)
    public Operation setUrlMap(@PathParam(value="targetHttpProxy") String var1, @PayloadParam(value="urlMap") URI var2);

    @Named(value="TargetHttpProxys:delete")
    @DELETE
    @Path(value="/global/targetHttpProxies/{targetHttpProxy}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Operation delete(@PathParam(value="targetHttpProxy") String var1);

    @Named(value="TargetHttpProxys:list")
    @GET
    @Path(value="/global/targetHttpProxies")
    public ListPage<TargetHttpProxy> listPage(@Nullable @QueryParam(value="pageToken") String var1, ListOptions var2);

    @Named(value="TargetHttpProxys:list")
    @GET
    @Path(value="/global/targetHttpProxies")
    @Transform(value=TargetHttpProxyPages.class)
    public Iterator<ListPage<TargetHttpProxy>> list();

    @Named(value="TargetHttpProxys:list")
    @GET
    @Path(value="/global/targetHttpProxies")
    @Transform(value=TargetHttpProxyPages.class)
    public Iterator<ListPage<TargetHttpProxy>> list(ListOptions var1);

    public static final class TargetHttpProxyPages
    extends BaseToIteratorOfListPage<TargetHttpProxy, TargetHttpProxyPages> {
        private final GoogleComputeEngineApi api;

        @Inject
        TargetHttpProxyPages(GoogleComputeEngineApi api) {
            this.api = api;
        }

        protected Function<String, ListPage<TargetHttpProxy>> fetchNextPage(final ListOptions options) {
            return new Function<String, ListPage<TargetHttpProxy>>(){

                public ListPage<TargetHttpProxy> apply(String pageToken) {
                    return api.targetHttpProxies().listPage(pageToken, options);
                }
            };
        }
    }
}

