/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.vfs;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarFile;
import org.osgi.framework.FrameworkUtil;
import org.reflections.ReflectionsException;
import org.reflections.util.Utils;
import org.reflections.vfs.SystemDir;
import org.reflections.vfs.ZipDir;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Vfs {
    private static List<UrlType> defaultUrlTypes = Lists.newArrayList((Object[])DefaultUrlTypes.values());

    public static List<UrlType> getDefaultUrlTypes() {
        return defaultUrlTypes;
    }

    public static void setDefaultURLTypes(List<UrlType> urlTypes) {
        defaultUrlTypes = urlTypes;
    }

    public static void addDefaultURLTypes(UrlType urlType) {
        defaultUrlTypes.add(urlType);
    }

    public static Dir fromURL(URL url) {
        return Vfs.fromURL(url, defaultUrlTypes);
    }

    public static Dir fromURL(URL url, List<UrlType> urlTypes) {
        for (UrlType type : urlTypes) {
            try {
                Dir dir;
                if (!type.matches(url) || (dir = type.createDir(url)) == null) continue;
                return dir;
            }
            catch (Throwable e) {
            }
        }
        throw new ReflectionsException("could not create Vfs.Dir from url, no matching UrlType was found [" + url.toExternalForm() + "]\n" + "either use fromURL(final URL url, final List<UrlType> urlTypes) or " + "use the static setDefaultURLTypes(final List<UrlType> urlTypes) or addDefaultURLTypes(UrlType urlType) " + "with your specialized UrlType.");
    }

    public static Dir fromURL(URL url, UrlType ... urlTypes) {
        return Vfs.fromURL(url, Lists.newArrayList((Object[])urlTypes));
    }

    public static Iterable<File> findFiles(Collection<URL> inUrls, final String packagePrefix, final Predicate<String> nameFilter) {
        Predicate<File> fileNamePredicate = new Predicate<File>(){

            public boolean apply(File file) {
                String path = file.getRelativePath();
                if (path.startsWith(packagePrefix)) {
                    String filename = path.substring(path.indexOf(packagePrefix) + packagePrefix.length());
                    return !Utils.isEmpty(filename) && nameFilter.apply((Object)filename.substring(1));
                }
                return false;
            }
        };
        return Vfs.findFiles(inUrls, fileNamePredicate);
    }

    public static Iterable<File> findFiles(Collection<URL> inUrls, Predicate<File> filePredicate) {
        Iterable<File> result = new ArrayList<File>();
        for (final URL url : inUrls) {
            try {
                result = Iterables.concat(result, (Iterable)Iterables.filter((Iterable)new Iterable<File>(){

                    @Override
                    public Iterator<File> iterator() {
                        return Vfs.fromURL(url).getFiles().iterator();
                    }
                }, filePredicate));
            }
            catch (Throwable e) {}
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static java.io.File getFile(URL url) {
        java.io.File file;
        String path;
        try {
            path = url.toURI().getSchemeSpecificPart();
            file = new java.io.File(path);
            if (file.exists()) {
                return file;
            }
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        try {
            path = URLDecoder.decode(url.getPath(), "UTF-8");
            if (path.contains(".jar!")) {
                path = path.substring(0, path.lastIndexOf(".jar!") + ".jar".length());
            }
            if ((file = new java.io.File(path)).exists()) {
                return file;
            }
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        try {
            path = url.toExternalForm();
            if (path.startsWith("jar:")) {
                path = path.substring("jar:".length());
            }
            if (path.startsWith("file:")) {
                path = path.substring("file:".length());
            }
            if (path.contains(".jar!")) {
                path = path.substring(0, path.indexOf(".jar!") + ".jar".length());
            }
            if ((file = new java.io.File(path)).exists()) {
                return file;
            }
            file = new java.io.File(path = path.replace("%20", " "));
            if (file.exists()) {
                return file;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            byte[] buffer = new byte[8192];
            InputStream input = url.openStream();
            java.io.File tmpFile = Vfs.createTempFile("reflections", ".jar");
            try {
                FileOutputStream output = new FileOutputStream(tmpFile);
                try {
                    int bytesRead;
                    while ((bytesRead = input.read(buffer)) != -1) {
                        ((OutputStream)output).write(buffer, 0, bytesRead);
                    }
                }
                finally {
                    ((OutputStream)output).close();
                }
            }
            finally {
                input.close();
            }
            return tmpFile;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static java.io.File createTempFile(String prefix, String suffix) throws IOException {
        java.io.File result = null;
        java.io.File parent = Vfs.createTmpDir();
        if (suffix == null) {
            suffix = ".tmp";
        }
        if (prefix == null) {
            prefix = "reflections";
        } else if (prefix.length() < 3) {
            prefix = prefix + "reflections";
        }
        result = java.io.File.createTempFile(prefix, suffix, parent);
        return result;
    }

    private static java.io.File createTmpDir() {
        int x = (int)(Math.random() * 1000000.0);
        String s = System.getProperty("java.io.tmpdir");
        java.io.File checkExists = new java.io.File(s);
        if (!checkExists.exists() || !checkExists.isDirectory()) {
            throw new RuntimeException("The directory " + checkExists.getAbsolutePath() + " does not exist, please set java.io.tempdir" + " to an existing directory");
        }
        if (!checkExists.canWrite()) {
            throw new RuntimeException("The directory " + checkExists.getAbsolutePath() + " is now writable, please set java.io.tempdir" + " to an writable directory");
        }
        java.io.File f = new java.io.File(s, "reflections-" + x);
        while (!f.mkdir()) {
            x = (int)(Math.random() * 1000000.0);
            f = new java.io.File(s, "reflections-" + x);
        }
        java.io.File newTmpDir = f;
        return newTmpDir;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DefaultUrlTypes implements UrlType
    {
        jarFile{

            public boolean matches(URL url) {
                return url.getProtocol().equals("file") && url.toExternalForm().contains(".jar");
            }

            public Dir createDir(URL url) throws Exception {
                return new ZipDir(new JarFile(Vfs.getFile(url)));
            }
        }
        ,
        jarUrl{

            public boolean matches(URL url) {
                return "jar".equals(url.getProtocol());
            }

            public Dir createDir(URL url) throws Exception {
                URLConnection urlConnection = url.openConnection();
                return urlConnection instanceof JarURLConnection ? new ZipDir(((JarURLConnection)urlConnection).getJarFile()) : null;
            }
        }
        ,
        directory{

            public boolean matches(URL url) {
                return url.getProtocol().equals("file") && !url.toExternalForm().contains(".jar");
            }

            public Dir createDir(URL url) throws Exception {
                return new SystemDir(Vfs.getFile(url));
            }
        }
        ,
        bundleUrl{

            public boolean matches(URL url) {
                return url.getProtocol().equals("bundle");
            }

            public Dir createDir(URL url) throws Exception {
                try {
                    return new ZipDir(new JarFile(Vfs.getFile(new URL(FrameworkUtil.getBundle(Vfs.class).getBundleContext().getBundle(this.getBundleIdforResourceScan(url.toExternalForm())).getLocation()))));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
            }

            private long getBundleIdforResourceScan(String bundleUrl) {
                int startIdx = bundleUrl.indexOf("://");
                int endIdx = bundleUrl.indexOf(".");
                String retStr = bundleUrl.substring(startIdx + 3, endIdx);
                return Long.valueOf(retStr);
            }
        };

    }

    public static interface UrlType {
        public boolean matches(URL var1) throws Exception;

        public Dir createDir(URL var1) throws Exception;
    }

    public static interface File {
        public String getName();

        public String getRelativePath();

        public InputStream openInputStream() throws IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Dir {
        public String getPath();

        public Iterable<File> getFiles();

        public void close();
    }
}

