/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow.steps.appmodel;

import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.sensor.Sensors;
import org.apache.brooklyn.core.workflow.WorkflowExpressionResolution;
import org.apache.brooklyn.core.workflow.WorkflowStepDefinition;
import org.apache.brooklyn.core.workflow.WorkflowStepInstanceExecutionContext;
import org.apache.brooklyn.core.workflow.steps.appmodel.EntityValueToSet;
import org.apache.brooklyn.core.workflow.steps.appmodel.SetSensorWorkflowStep;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.Strings;

public class ClearSensorWorkflowStep
extends WorkflowStepDefinition {
    public static final String SHORTHAND = "[ ${sensor.type} ] ${sensor.name}";
    public static final ConfigKey<EntityValueToSet> SENSOR = ConfigKeys.newConfigKey(EntityValueToSet.class, "sensor");

    @Override
    public void populateFromShorthand(String expression) {
        this.populateFromShorthandTemplate(SHORTHAND, expression);
    }

    @Override
    protected Object doTaskBody(WorkflowStepInstanceExecutionContext context) {
        EntityValueToSet sensor = context.getInput(SENSOR);
        if (sensor == null) {
            throw new IllegalArgumentException("Sensor name is required");
        }
        String sensorNameFull = context.resolve(WorkflowExpressionResolution.WorkflowExpressionStage.STEP_INPUT, (Object)sensor.name, String.class);
        if (Strings.isBlank((CharSequence)sensorNameFull)) {
            throw new IllegalArgumentException("Sensor name is required");
        }
        MutableList sensorNameIndexes = MutableList.of();
        String sensorNameBase = SetSensorWorkflowStep.extractSensorNameBaseAndPopulateIndices(sensorNameFull, (List<Object>)sensorNameIndexes);
        TypeToken<?> type = context.lookupType(sensor.type, () -> TypeToken.of(Object.class));
        Entity entity = sensor.entity;
        if (entity == null) {
            entity = context.getEntity();
        }
        if (sensorNameIndexes.isEmpty()) {
            ((EntityInternal)entity).sensors().remove(Sensors.newSensor(Object.class, sensorNameFull));
        } else {
            ((EntityInternal)entity).sensors().modify(Sensors.newSensor(Object.class, sensorNameBase), arg_0 -> ClearSensorWorkflowStep.lambda$doTaskBody$1((List)sensorNameIndexes, arg_0));
        }
        return context.getPreviousStepOutput();
    }

    @Override
    protected Boolean isDefaultIdempotent() {
        return true;
    }

    private static /* synthetic */ Maybe lambda$doTaskBody$1(List sensorNameIndexes, Object old) {
        Object newTarget;
        boolean setLast = false;
        Object target = newTarget = SetSensorWorkflowStep.makeMutable(old, sensorNameIndexes);
        MutableList indexes = MutableList.copyOf((Iterable)sensorNameIndexes);
        while (!indexes.isEmpty()) {
            Object nextTarget;
            Object i = indexes.remove(0);
            boolean isLast = indexes.isEmpty();
            if (target == null) break;
            if (target instanceof Map) {
                if (isLast) {
                    setLast = true;
                    ((Map)target).remove(i);
                    nextTarget = null;
                } else {
                    nextTarget = ((Map)target).get(i);
                    if (nextTarget == null) break;
                    ((Map)target).put(i, SetSensorWorkflowStep.makeMutable(nextTarget, (List<Object>)indexes));
                }
            } else if (target instanceof Iterable && i instanceof Integer) {
                boolean outOfBounds;
                int ii = (Integer)i;
                int size = Iterables.size((Iterable)((Iterable)target));
                if (ii == -1) {
                    ii = size - 1;
                }
                boolean bl = outOfBounds = ii < 0 || ii >= size;
                if (outOfBounds) {
                    nextTarget = null;
                    break;
                }
                if (isLast) {
                    setLast = true;
                    if (target instanceof List) {
                        ((List)target).remove(ii);
                    } else {
                        Iterator ti = ((Iterable)target).iterator();
                        for (int j = 0; j < ii; ++j) {
                            ti.next();
                        }
                        ti.remove();
                    }
                    nextTarget = null;
                    break;
                }
                Object t0 = Iterables.get((Iterable)((Iterable)target), (int)ii);
                if (t0 != (nextTarget = SetSensorWorkflowStep.makeMutable(t0, (List<Object>)indexes))) {
                    if (!(target instanceof List)) {
                        throw new IllegalStateException("Cannot set numerical position index in a non-list collection (and was not otherwise known as mutable; e.g. use MutableSet): " + target);
                    }
                    ((List)target).set(ii, nextTarget);
                }
            } else {
                throw new IllegalArgumentException("Cannot find argument '" + i + "' in " + target);
            }
            target = nextTarget;
        }
        if (setLast) {
            return Maybe.of((Object)newTarget);
        }
        return Maybe.ofDisallowingNull((Object)old);
    }
}

