/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.objs;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.EntityLocal;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.api.mgmt.ExecutionContext;
import org.apache.brooklyn.api.mgmt.ManagementContext;
import org.apache.brooklyn.api.mgmt.SubscriptionHandle;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.api.objs.Configurable;
import org.apache.brooklyn.api.objs.EntityAdjunct;
import org.apache.brooklyn.api.objs.HighlightTuple;
import org.apache.brooklyn.api.sensor.Sensor;
import org.apache.brooklyn.api.sensor.SensorEventListener;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.config.internal.AbstractConfigMapImpl;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.entity.internal.ConfigUtilsInternal;
import org.apache.brooklyn.core.mgmt.internal.SubscriptionTracker;
import org.apache.brooklyn.core.objs.AbstractBrooklynObject;
import org.apache.brooklyn.core.objs.AbstractConfigurationSupportInternal;
import org.apache.brooklyn.core.objs.AdjunctConfigMap;
import org.apache.brooklyn.core.objs.AdjunctType;
import org.apache.brooklyn.core.objs.BrooklynObjectInternal;
import org.apache.brooklyn.core.objs.proxy.EntityAdjunctProxyImpl;
import org.apache.brooklyn.util.JavaGroovyEquivalents;
import org.apache.brooklyn.util.collections.MutableSet;
import org.apache.brooklyn.util.core.config.ConfigBag;
import org.apache.brooklyn.util.core.flags.FlagUtils;
import org.apache.brooklyn.util.core.flags.SetFromFlag;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEntityAdjunct
extends AbstractBrooklynObject
implements BrooklynObjectInternal,
EntityAdjunct,
Configurable {
    private static final Logger log = LoggerFactory.getLogger(AbstractEntityAdjunct.class);
    private boolean _legacyNoConstructionInit;
    @Deprecated
    protected Map<String, Object> leftoverProperties = Maps.newLinkedHashMap();
    @Deprecated
    protected transient ExecutionContext execution;
    private final BasicConfigurationSupport config = new BasicConfigurationSupport();
    private final BasicSubscriptionSupport subscriptions = new BasicSubscriptionSupport();
    private final AdjunctConfigMap configsInternal = new AdjunctConfigMap(this);
    private final AdjunctType adjunctType = new AdjunctType(this);
    @SetFromFlag
    protected String name;
    protected transient EntityLocal entity;
    protected transient SubscriptionTracker _subscriptionTracker;
    private AtomicBoolean destroyed = new AtomicBoolean(false);
    @SetFromFlag(value="uniqueTag")
    protected String uniqueTag;
    private Map<String, HighlightTuple> highlights = new ConcurrentHashMap<String, HighlightTuple>();
    public static final String HIGHLIGHT_NAME_LAST_ACTION = "lastAction";
    public static final String HIGHLIGHT_NAME_LAST_CONFIRMATION = "lastConfirmation";
    public static final String HIGHLIGHT_NAME_LAST_VIOLATION = "lastViolation";
    public static final String HIGHLIGHT_NAME_TRIGGERS = "triggers";

    public AbstractEntityAdjunct() {
        this(Collections.emptyMap());
    }

    public AbstractEntityAdjunct(Map properties) {
        super(properties);
        boolean bl = this._legacyNoConstructionInit = properties != null && Boolean.TRUE.equals(properties.get("noConstructionInit"));
        if (this.isLegacyConstruction()) {
            boolean deferConstructionChecks;
            AbstractEntityAdjunct checkWeGetThis = this.configure(properties);
            assert (this.equals(checkWeGetThis)) : this + " configure method does not return itself; returns " + checkWeGetThis + " instead of " + this;
            boolean bl2 = deferConstructionChecks = properties.containsKey("deferConstructionChecks") && TypeCoercions.coerce(properties.get("deferConstructionChecks"), Boolean.class) != false;
            if (!deferConstructionChecks) {
                FlagUtils.checkRequiredFields(this);
            }
        }
    }

    @Deprecated
    public AbstractEntityAdjunct configure(Map flags) {
        boolean isFirstTime = true;
        Iterator iter = flags.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!(entry.getKey() instanceof ConfigKey)) continue;
            ConfigKey key = (ConfigKey)entry.getKey();
            if (this.adjunctType.getConfigKeys().contains(key)) {
                this.config().set(key, entry.getValue());
                continue;
            }
            log.warn("Unknown configuration key {} for policy {}; ignoring", (Object)key, (Object)this);
            iter.remove();
        }
        flags = ConfigUtilsInternal.setAllConfigKeys(flags, this.getAdjunctType().getConfigKeys(), this);
        ConfigBag bag = new ConfigBag().putAll(flags);
        FlagUtils.setFieldsFromFlags(this, bag, isFirstTime);
        FlagUtils.setAllConfigKeys(this, bag, false);
        this.leftoverProperties.putAll(bag.getUnusedConfig());
        if (!JavaGroovyEquivalents.groovyTruth((String)this.name) && this.leftoverProperties.containsKey("displayName")) {
            Preconditions.checkArgument((boolean)(this.leftoverProperties.get("displayName") instanceof CharSequence), (Object)"'displayName' property should be a string");
            this.setDisplayName(this.leftoverProperties.remove("displayName").toString());
        }
        for (String flag : this.leftoverProperties.keySet()) {
            ConfigKey<Object> key = ConfigKeys.newConfigKey(Object.class, Strings.toString((Object)flag));
            if (this.config().getRaw(key).isPresent()) {
                log.warn("Config '" + flag + "' on " + this + " conflicts with key already set; ignoring");
                continue;
            }
            this.config().set(key, this.leftoverProperties.get(flag));
        }
        return this;
    }

    @Beta
    protected boolean isLegacyNoConstructionInit() {
        return this._legacyNoConstructionInit;
    }

    @Beta
    public ExecutionContext getExecutionContext() {
        return this.execution;
    }

    @Override
    public BrooklynObjectInternal.ConfigurationSupportInternal config() {
        return this.config;
    }

    @Override
    public BasicSubscriptionSupport subscriptions() {
        return this.subscriptions;
    }

    public <T> T getConfig(ConfigKey<T> key) {
        return (T)this.config().get(key);
    }

    protected <K> K getRequiredConfig(ConfigKey<K> key) {
        Object result = this.config().get(key);
        if (result == null) {
            throw new NullPointerException("Value required for '" + key.getName() + "' in " + this);
        }
        return (K)result;
    }

    protected <T> void doReconfigureConfig(ConfigKey<T> key, T val) {
        throw new UnsupportedOperationException("reconfiguring " + key + " unsupported for " + this);
    }

    @Override
    protected void onTagsChanged() {
        this.onChanged();
    }

    protected abstract void onChanged();

    public AdjunctType getAdjunctType() {
        return this.adjunctType;
    }

    public String getDisplayName() {
        if (this.name != null && this.name.length() > 0) {
            return this.name;
        }
        return this.getDefaultDisplayName();
    }

    @JsonIgnore
    protected String getDefaultDisplayName() {
        return this.getClass().getCanonicalName();
    }

    @Override
    public void setDisplayName(String name) {
        this.name = name;
    }

    @Override
    public ManagementContext getManagementContext() {
        ManagementContext result = super.getManagementContext();
        if (result != null) {
            return result;
        }
        if (this.entity != null) {
            return ((EntityInternal)this.entity).getManagementContext();
        }
        return null;
    }

    public void setEntity(EntityLocal entity) {
        if (this.destroyed.get()) {
            throw new IllegalStateException("Cannot set entity on a destroyed entity adjunct");
        }
        this.entity = entity;
        this.execution = this.getManagementContext().getExecutionContext((Entity)entity, (EntityAdjunct)this);
        if (entity != null && this.getCatalogItemId() == null) {
            this.setCatalogItemIdAndSearchPath(entity.getCatalogItemId(), entity.getCatalogItemIdSearchPath());
        }
    }

    public Entity getEntity() {
        return this.entity;
    }

    private synchronized SubscriptionTracker getSubscriptionTracker() {
        if (this._subscriptionTracker != null) {
            return this._subscriptionTracker;
        }
        if (this.entity == null) {
            return null;
        }
        this._subscriptionTracker = new SubscriptionTracker(((EntityInternal)this.entity).subscriptions().getSubscriptionContext());
        return this._subscriptionTracker;
    }

    public void destroy() {
        this.destroyed.set(true);
        SubscriptionTracker tracker = this.getSubscriptionTracker();
        if (tracker != null) {
            tracker.unsubscribeAll();
        }
        this.getManagementContext().getRebindManager().getChangeListener().onUnmanaged((BrooklynObject)this);
    }

    public boolean isDestroyed() {
        return this.destroyed.get();
    }

    public boolean isRunning() {
        return !this.isDestroyed();
    }

    public String getUniqueTag() {
        return this.uniqueTag;
    }

    @Override
    public BrooklynObject.TagSupport tags() {
        return new AdjunctTagSupport();
    }

    public Map<String, HighlightTuple> getHighlights() {
        HashMap<String, HighlightTuple> highlightsToReturn = new HashMap<String, HighlightTuple>();
        highlightsToReturn.putAll(this.highlights);
        return highlightsToReturn;
    }

    protected void setHighlight(String name, HighlightTuple tuple) {
        log.debug("Highlight on " + this + ": " + name + ": " + tuple);
        this.highlights.put(name, tuple);
    }

    public void highlightOngoing(String name, String description) {
        this.setHighlight(name, new HighlightTuple(description, 0L, null));
    }

    public void highlightNow(String name, String description) {
        this.setHighlight(name, new HighlightTuple(description, System.currentTimeMillis(), null));
    }

    public void highlight(String name, String description, @Nullable Task<?> t) {
        this.setHighlight(name, new HighlightTuple(description, System.currentTimeMillis(), t != null ? t.getId() : null));
    }

    public void highlightTriggers(String description) {
        this.highlightOngoing(HIGHLIGHT_NAME_TRIGGERS, description);
    }

    public <T> void highlightTriggers(Sensor<?> s, Object source) {
        this.highlightTriggers(Collections.singleton(s), Collections.singleton(source));
    }

    public <T> void highlightTriggers(Iterable<? extends Sensor<? extends T>> s, Object source) {
        this.highlightTriggers(s, source instanceof Iterable ? (Set<Object>)source : Collections.singleton(source));
    }

    public <U> void highlightTriggers(Sensor<?> s, Iterable<U> sources) {
        this.highlightTriggers(Collections.singleton(s), sources);
    }

    public <T, U> void highlightTriggers(Iterable<? extends Sensor<? extends T>> sensors, Iterable<U> sources) {
        String sourcesText;
        StringBuilder msg = new StringBuilder("Listening for ");
        if (sensors == null || Iterables.isEmpty(sensors)) {
            msg.append("<nothing>");
        } else {
            String sensorsText = MutableSet.copyOf(sensors).stream().filter(s -> s != null).map(s -> s instanceof Sensor ? ((Sensor)s).getName() : s.toString()).collect(Collectors.joining(", "));
            msg.append(sensorsText);
        }
        if (sources != null && !Iterables.isEmpty(sources) && !"self".equals(sourcesText = MutableSet.copyOf(sources).stream().filter(s -> s != null).map(s -> s.equals(this.getEntity()) ? "self" : s.toString()).collect(Collectors.joining(", ")))) {
            msg.append(" on ").append(sourcesText);
        }
        this.highlightTriggers(msg.toString());
    }

    public void highlightConfirmation(String description) {
        this.highlightNow(HIGHLIGHT_NAME_LAST_CONFIRMATION, description);
    }

    public void highlightAction(String description, Task<?> t) {
        this.highlight(HIGHLIGHT_NAME_LAST_ACTION, description, t);
    }

    public void highlightActionPublishSensor(Sensor<?> s, Object v) {
        this.highlightActionPublishSensor("Publish " + s.getName() + " " + v);
    }

    public void highlightActionPublishSensor(String description) {
        this.highlight(HIGHLIGHT_NAME_LAST_ACTION, description, null);
    }

    public void highlightViolation(String description) {
        this.highlightNow(HIGHLIGHT_NAME_LAST_VIOLATION, description);
    }

    public void setHighlights(Map<String, HighlightTuple> highlights) {
        if (highlights != null) {
            this.highlights.putAll(highlights);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("name", (Object)this.name).add("uniqueTag", (Object)this.uniqueTag).add("running", this.isRunning()).add("entity", (Object)this.entity).add("id", (Object)this.getId()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (Proxy.isProxyClass(o.getClass())) {
            InvocationHandler ph = Proxy.getInvocationHandler(o);
            if (ph != null && ph instanceof EntityAdjunctProxyImpl) {
                return ((EntityAdjunctProxyImpl)ph).equals(this);
            }
            return false;
        }
        return super.equals(o);
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public class AdjunctTagSupport
    extends AbstractBrooklynObject.BasicTagSupport {
        @Override
        public Set<Object> getTags() {
            ImmutableSet.Builder rb = ImmutableSet.builder().addAll(super.getTags());
            if (this.getUniqueTag() != null) {
                rb.add((Object)this.getUniqueTag());
            }
            return rb.build();
        }

        public String getUniqueTag() {
            return AbstractEntityAdjunct.this.getUniqueTag();
        }

        public void setUniqueTag(String uniqueTag) {
            AbstractEntityAdjunct.this.uniqueTag = uniqueTag;
        }
    }

    private class BasicConfigurationSupport
    extends AbstractConfigurationSupportInternal {
        private BasicConfigurationSupport() {
        }

        @Override
        protected <T> void onConfigChanging(ConfigKey<T> key, Object val) {
            if (AbstractEntityAdjunct.this.entity != null && AbstractEntityAdjunct.this.isRunning()) {
                AbstractEntityAdjunct.this.doReconfigureConfig(key, val);
            }
        }

        @Override
        protected <T> void onConfigChanged(ConfigKey<T> key, Object val) {
            AbstractEntityAdjunct.this.onChanged();
        }

        @Override
        public void refreshInheritedConfig() {
        }

        @Override
        public void refreshInheritedConfigOfChildren() {
        }

        @Override
        protected ExecutionContext getContext() {
            return AbstractEntityAdjunct.this.getExecutionContext();
        }

        protected AbstractConfigMapImpl<?> getConfigsInternal() {
            return AbstractEntityAdjunct.this.configsInternal;
        }

        @Override
        protected BrooklynObject getContainer() {
            return AbstractEntityAdjunct.this;
        }
    }

    public class BasicSubscriptionSupport
    implements BrooklynObjectInternal.SubscriptionSupportInternal {
        public <T> SubscriptionHandle subscribe(Entity producer, Sensor<T> sensor, SensorEventListener<? super T> listener) {
            if (!this.checkCanSubscribe()) {
                return null;
            }
            return this.getSubscriptionTracker().subscribe(producer, sensor, listener);
        }

        public <T> SubscriptionHandle subscribe(Map<String, ?> flags, Entity producer, Sensor<T> sensor, SensorEventListener<? super T> listener) {
            if (!this.checkCanSubscribe()) {
                return null;
            }
            return this.getSubscriptionTracker().subscribe(flags, producer, sensor, listener);
        }

        public <T> SubscriptionHandle subscribeToMembers(Group producerGroup, Sensor<T> sensor, SensorEventListener<? super T> listener) {
            if (!this.checkCanSubscribe((Entity)producerGroup)) {
                return null;
            }
            return this.getSubscriptionTracker().subscribeToMembers(producerGroup, sensor, listener);
        }

        public <T> SubscriptionHandle subscribeToChildren(Entity producerParent, Sensor<T> sensor, SensorEventListener<? super T> listener) {
            if (!this.checkCanSubscribe(producerParent)) {
                return null;
            }
            return this.getSubscriptionTracker().subscribeToChildren(producerParent, sensor, listener);
        }

        public boolean unsubscribe(Entity producer) {
            if (AbstractEntityAdjunct.this.destroyed.get()) {
                return false;
            }
            return this.getSubscriptionTracker().unsubscribe(producer);
        }

        public boolean unsubscribe(Entity producer, SubscriptionHandle handle) {
            if (AbstractEntityAdjunct.this.destroyed.get()) {
                return false;
            }
            return this.getSubscriptionTracker().unsubscribe(producer, handle);
        }

        public boolean unsubscribe(SubscriptionHandle handle) {
            if (AbstractEntityAdjunct.this.destroyed.get()) {
                return false;
            }
            return this.getSubscriptionTracker().unsubscribe(handle);
        }

        @Override
        public void unsubscribeAll() {
            if (AbstractEntityAdjunct.this.destroyed.get()) {
                return;
            }
            this.getSubscriptionTracker().unsubscribeAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected SubscriptionTracker getSubscriptionTracker() {
            AbstractEntityAdjunct abstractEntityAdjunct = AbstractEntityAdjunct.this;
            synchronized (abstractEntityAdjunct) {
                if (AbstractEntityAdjunct.this._subscriptionTracker != null) {
                    return AbstractEntityAdjunct.this._subscriptionTracker;
                }
                if (AbstractEntityAdjunct.this.entity == null) {
                    return null;
                }
                AbstractEntityAdjunct.this._subscriptionTracker = new SubscriptionTracker(AbstractEntityAdjunct.this.getManagementContext().getSubscriptionContext((Entity)AbstractEntityAdjunct.this.entity, (EntityAdjunct)AbstractEntityAdjunct.this));
                return AbstractEntityAdjunct.this._subscriptionTracker;
            }
        }

        protected boolean checkCanSubscribe(Entity producer) {
            if (AbstractEntityAdjunct.this.destroyed.get()) {
                return false;
            }
            if (producer == null) {
                throw new IllegalStateException(this + " given a null target for subscription");
            }
            if (AbstractEntityAdjunct.this.entity == null) {
                throw new IllegalStateException(this + " cannot subscribe to " + producer + " because it is not associated to an entity");
            }
            if (((EntityInternal)AbstractEntityAdjunct.this.entity).getManagementSupport().isNoLongerManaged()) {
                throw new IllegalStateException(this + " cannot subscribe to " + producer + " because the associated entity " + AbstractEntityAdjunct.this.entity + " is no longer managed");
            }
            return true;
        }

        protected boolean checkCanSubscribe() {
            if (AbstractEntityAdjunct.this.destroyed.get()) {
                return false;
            }
            if (AbstractEntityAdjunct.this.entity == null) {
                throw new IllegalStateException(this + " cannot subscribe because it is not associated to an entity");
            }
            if (((EntityInternal)AbstractEntityAdjunct.this.entity).getManagementSupport().isNoLongerManaged()) {
                throw new IllegalStateException(this + " cannot subscribe because the associated entity " + AbstractEntityAdjunct.this.entity + " is no longer managed");
            }
            return true;
        }

        protected Collection<SubscriptionHandle> getAllSubscriptions() {
            SubscriptionTracker tracker = this.getSubscriptionTracker();
            return tracker != null ? tracker.getAllSubscriptions() : Collections.emptyList();
        }
    }
}

