// @generated by protobuf-ts 2.1.0 with parameter client_grpc1,generate_dependencies
// @generated from protobuf file "org/apache/beam/model/pipeline/v1/standard_window_fns.proto" (package "org.apache.beam.model.pipeline.v1", syntax proto3)
// tslint:disable
//
//
// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
//
//
// Protocol Buffers describing the Runner API, which is the runner-independent,
// SDK-independent definition of the Beam model.
//
import { WireType } from "@protobuf-ts/runtime";
import type { BinaryWriteOptions } from "@protobuf-ts/runtime";
import type { IBinaryWriter } from "@protobuf-ts/runtime";
import { UnknownFieldHandler } from "@protobuf-ts/runtime";
import type { BinaryReadOptions } from "@protobuf-ts/runtime";
import type { IBinaryReader } from "@protobuf-ts/runtime";
import type { PartialMessage } from "@protobuf-ts/runtime";
import { reflectionMergePartial } from "@protobuf-ts/runtime";
import { MESSAGE_TYPE } from "@protobuf-ts/runtime";
import { MessageType } from "@protobuf-ts/runtime";
import { Timestamp } from "../../../../../../google/protobuf/timestamp";
import { Duration } from "../../../../../../google/protobuf/duration";
/**
 * By default, all data in a PCollection is assigned to the single global
 * window. See BeamConstants for the time span this window encompasses.
 *
 * See https://beam.apache.org/documentation/programming-guide/#single-global-window
 * for additional details.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.GlobalWindowsPayload
 */
export interface GlobalWindowsPayload {
}
/**
 * @generated from protobuf enum org.apache.beam.model.pipeline.v1.GlobalWindowsPayload.Enum
 */
export enum GlobalWindowsPayload_Enum {
    /**
     * @generated from protobuf enum value: PROPERTIES = 0;
     */
    PROPERTIES = 0
}
/**
 * A fixed time window represents a consistent duration size, non overlapping
 * time interval in the data stream.
 *
 * See https://beam.apache.org/documentation/programming-guide/#fixed-time-windows
 * for additional details.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.FixedWindowsPayload
 */
export interface FixedWindowsPayload {
    /**
     * (Required) Represents the size of the window.
     *
     * @generated from protobuf field: google.protobuf.Duration size = 1;
     */
    size?: Duration;
    /**
     * (Required) Represents the timestamp of when the first window begins.
     * Window N will start at offset + N * size.
     *
     * @generated from protobuf field: google.protobuf.Timestamp offset = 2;
     */
    offset?: Timestamp;
}
/**
 * @generated from protobuf enum org.apache.beam.model.pipeline.v1.FixedWindowsPayload.Enum
 */
export enum FixedWindowsPayload_Enum {
    /**
     * @generated from protobuf enum value: PROPERTIES = 0;
     */
    PROPERTIES = 0
}
/**
 * A sliding time window represents time intervals in the data stream that can
 * overlap. For example, each window might capture 60 seconds worth of data, but
 * a new window starts every 30 seconds. The frequency with which sliding
 * windows begin is called the period. Therefore, our example would have a
 * window size of 60 seconds and a period of 30 seconds.
 *
 * Because multiple windows overlap, most elements in a data set will belong to
 * more than one window. This kind of windowing is useful for taking running
 * averages of data; using sliding time windows, you can compute a running
 * average of the past 60 seconds’ worth of data, updated every 30 seconds, in
 * our example.
 *
 * See https://beam.apache.org/documentation/programming-guide/#sliding-time-windows
 * for additional details.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.SlidingWindowsPayload
 */
export interface SlidingWindowsPayload {
    /**
     * (Required) Represents the size of the window.
     *
     * @generated from protobuf field: google.protobuf.Duration size = 1;
     */
    size?: Duration;
    /**
     * (Required) Represents the timestamp of when the first window begins.
     * Window N will start at offset + N * period.
     *
     * @generated from protobuf field: google.protobuf.Timestamp offset = 2;
     */
    offset?: Timestamp;
    /**
     * (Required) Represents the amount of time between each start of a window.
     *
     * @generated from protobuf field: google.protobuf.Duration period = 3;
     */
    period?: Duration;
}
/**
 * @generated from protobuf enum org.apache.beam.model.pipeline.v1.SlidingWindowsPayload.Enum
 */
export enum SlidingWindowsPayload_Enum {
    /**
     * @generated from protobuf enum value: PROPERTIES = 0;
     */
    PROPERTIES = 0
}
/**
 * A session window function defines windows that contain elements that are
 * within a certain gap size of another element. Session windowing applies
 * on a per-key basis and is useful for data that is irregularly distributed
 * with respect to time. For example, a data stream representing user mouse
 * activity may have long periods of idle time interspersed with high
 * concentrations of clicks. If data arrives after the minimum specified gap
 * size duration, this initiates the start of a new window.
 *
 * See https://beam.apache.org/documentation/programming-guide/#session-windows
 * for additional details.
 *
 * @generated from protobuf message org.apache.beam.model.pipeline.v1.SessionWindowsPayload
 */
export interface SessionWindowsPayload {
    /**
     * (Required) Minimum duration of gaps between sessions.
     *
     * @generated from protobuf field: google.protobuf.Duration gap_size = 1;
     */
    gapSize?: Duration;
}
/**
 * @generated from protobuf enum org.apache.beam.model.pipeline.v1.SessionWindowsPayload.Enum
 */
export enum SessionWindowsPayload_Enum {
    /**
     * @generated from protobuf enum value: PROPERTIES = 0;
     */
    PROPERTIES = 0
}
// @generated message type with reflection information, may provide speed optimized methods
class GlobalWindowsPayload$Type extends MessageType<GlobalWindowsPayload> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.GlobalWindowsPayload", []);
    }
    create(value?: PartialMessage<GlobalWindowsPayload>): GlobalWindowsPayload {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<GlobalWindowsPayload>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: GlobalWindowsPayload): GlobalWindowsPayload {
        return target ?? this.create();
    }
    internalBinaryWrite(message: GlobalWindowsPayload, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.GlobalWindowsPayload
 */
export const GlobalWindowsPayload = new GlobalWindowsPayload$Type();
// @generated message type with reflection information, may provide speed optimized methods
class FixedWindowsPayload$Type extends MessageType<FixedWindowsPayload> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.FixedWindowsPayload", [
            { no: 1, name: "size", kind: "message", T: () => Duration },
            { no: 2, name: "offset", kind: "message", T: () => Timestamp }
        ]);
    }
    create(value?: PartialMessage<FixedWindowsPayload>): FixedWindowsPayload {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<FixedWindowsPayload>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: FixedWindowsPayload): FixedWindowsPayload {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* google.protobuf.Duration size */ 1:
                    message.size = Duration.internalBinaryRead(reader, reader.uint32(), options, message.size);
                    break;
                case /* google.protobuf.Timestamp offset */ 2:
                    message.offset = Timestamp.internalBinaryRead(reader, reader.uint32(), options, message.offset);
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: FixedWindowsPayload, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* google.protobuf.Duration size = 1; */
        if (message.size)
            Duration.internalBinaryWrite(message.size, writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        /* google.protobuf.Timestamp offset = 2; */
        if (message.offset)
            Timestamp.internalBinaryWrite(message.offset, writer.tag(2, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.FixedWindowsPayload
 */
export const FixedWindowsPayload = new FixedWindowsPayload$Type();
// @generated message type with reflection information, may provide speed optimized methods
class SlidingWindowsPayload$Type extends MessageType<SlidingWindowsPayload> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.SlidingWindowsPayload", [
            { no: 1, name: "size", kind: "message", T: () => Duration },
            { no: 2, name: "offset", kind: "message", T: () => Timestamp },
            { no: 3, name: "period", kind: "message", T: () => Duration }
        ]);
    }
    create(value?: PartialMessage<SlidingWindowsPayload>): SlidingWindowsPayload {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<SlidingWindowsPayload>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: SlidingWindowsPayload): SlidingWindowsPayload {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* google.protobuf.Duration size */ 1:
                    message.size = Duration.internalBinaryRead(reader, reader.uint32(), options, message.size);
                    break;
                case /* google.protobuf.Timestamp offset */ 2:
                    message.offset = Timestamp.internalBinaryRead(reader, reader.uint32(), options, message.offset);
                    break;
                case /* google.protobuf.Duration period */ 3:
                    message.period = Duration.internalBinaryRead(reader, reader.uint32(), options, message.period);
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: SlidingWindowsPayload, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* google.protobuf.Duration size = 1; */
        if (message.size)
            Duration.internalBinaryWrite(message.size, writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        /* google.protobuf.Timestamp offset = 2; */
        if (message.offset)
            Timestamp.internalBinaryWrite(message.offset, writer.tag(2, WireType.LengthDelimited).fork(), options).join();
        /* google.protobuf.Duration period = 3; */
        if (message.period)
            Duration.internalBinaryWrite(message.period, writer.tag(3, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.SlidingWindowsPayload
 */
export const SlidingWindowsPayload = new SlidingWindowsPayload$Type();
// @generated message type with reflection information, may provide speed optimized methods
class SessionWindowsPayload$Type extends MessageType<SessionWindowsPayload> {
    constructor() {
        super("org.apache.beam.model.pipeline.v1.SessionWindowsPayload", [
            { no: 1, name: "gap_size", kind: "message", T: () => Duration }
        ]);
    }
    create(value?: PartialMessage<SessionWindowsPayload>): SessionWindowsPayload {
        const message = {};
        globalThis.Object.defineProperty(message, MESSAGE_TYPE, { enumerable: false, value: this });
        if (value !== undefined)
            reflectionMergePartial<SessionWindowsPayload>(this, message, value);
        return message;
    }
    internalBinaryRead(reader: IBinaryReader, length: number, options: BinaryReadOptions, target?: SessionWindowsPayload): SessionWindowsPayload {
        let message = target ?? this.create(), end = reader.pos + length;
        while (reader.pos < end) {
            let [fieldNo, wireType] = reader.tag();
            switch (fieldNo) {
                case /* google.protobuf.Duration gap_size */ 1:
                    message.gapSize = Duration.internalBinaryRead(reader, reader.uint32(), options, message.gapSize);
                    break;
                default:
                    let u = options.readUnknownField;
                    if (u === "throw")
                        throw new globalThis.Error(`Unknown field ${fieldNo} (wire type ${wireType}) for ${this.typeName}`);
                    let d = reader.skip(wireType);
                    if (u !== false)
                        (u === true ? UnknownFieldHandler.onRead : u)(this.typeName, message, fieldNo, wireType, d);
            }
        }
        return message;
    }
    internalBinaryWrite(message: SessionWindowsPayload, writer: IBinaryWriter, options: BinaryWriteOptions): IBinaryWriter {
        /* google.protobuf.Duration gap_size = 1; */
        if (message.gapSize)
            Duration.internalBinaryWrite(message.gapSize, writer.tag(1, WireType.LengthDelimited).fork(), options).join();
        let u = options.writeUnknownFields;
        if (u !== false)
            (u == true ? UnknownFieldHandler.onWrite : u)(this.typeName, message, writer);
        return writer;
    }
}
/**
 * @generated MessageType for protobuf message org.apache.beam.model.pipeline.v1.SessionWindowsPayload
 */
export const SessionWindowsPayload = new SessionWindowsPayload$Type();
