/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.admin.kadmin.remote.request;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.kerby.KOptions;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.admin.kadmin.remote.request.AdminRequest;
import org.apache.kerby.kerberos.kerb.admin.message.AddPrincipalReq;
import org.apache.kerby.kerberos.kerb.admin.message.AdminMessageCode;
import org.apache.kerby.kerberos.kerb.admin.message.AdminMessageType;
import org.apache.kerby.xdr.XdrDataType;
import org.apache.kerby.xdr.XdrFieldInfo;

public class AddPrincipalRequest
extends AdminRequest {
    private KOptions kOptions;
    private String password;

    public AddPrincipalRequest(String principal) {
        super(principal);
    }

    public AddPrincipalRequest(String principal, KOptions kOptions) {
        super(principal);
        this.kOptions = kOptions;
    }

    public AddPrincipalRequest(String principal, String password) {
        super(principal);
        this.password = password;
    }

    public AddPrincipalRequest(String princial, KOptions kOptions, String password) {
        super(princial);
        this.kOptions = kOptions;
        this.password = password;
    }

    @Override
    public void process() throws KrbException {
        byte[] encodeBytes;
        super.process();
        AddPrincipalReq addPrincipalReq = new AddPrincipalReq();
        int paramNum = this.getParamNum();
        XdrFieldInfo[] xdrFieldInfos = new XdrFieldInfo[paramNum + 2];
        xdrFieldInfos[0] = new XdrFieldInfo(0, XdrDataType.ENUM, AdminMessageType.ADD_PRINCIPAL_REQ);
        xdrFieldInfos[1] = new XdrFieldInfo(1, XdrDataType.INTEGER, paramNum);
        xdrFieldInfos[2] = new XdrFieldInfo(2, XdrDataType.STRING, this.getPrincipal());
        if (paramNum == 2 && this.kOptions != null) {
            xdrFieldInfos[3] = new XdrFieldInfo(3, XdrDataType.STRUCT, this.kOptions);
        } else if (paramNum == 2 && this.password != null) {
            xdrFieldInfos[3] = new XdrFieldInfo(3, XdrDataType.STRING, this.password);
        } else if (paramNum == 3) {
            xdrFieldInfos[3] = new XdrFieldInfo(3, XdrDataType.STRUCT, this.kOptions);
            xdrFieldInfos[4] = new XdrFieldInfo(4, XdrDataType.STRING, this.password);
        }
        AdminMessageCode value = new AdminMessageCode(xdrFieldInfos);
        try {
            encodeBytes = value.encode();
        }
        catch (IOException e) {
            throw new KrbException("Xdr encode error when generate add principal request.", (Throwable)e);
        }
        ByteBuffer messageBuffer = ByteBuffer.wrap(encodeBytes);
        addPrincipalReq.setMessageBuffer(messageBuffer);
        this.setAdminReq(addPrincipalReq);
    }

    public int getParamNum() {
        int paramNum = 0;
        if (this.getPrincipal() == null) {
            throw new RuntimeException("Principal name missing.");
        }
        paramNum = this.kOptions == null && this.password == null ? 1 : (this.kOptions == null || this.password == null ? 2 : 3);
        return paramNum;
    }
}

