/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.ByteVector;
import gnu.lists.IntSequence;

public class S8Vector
extends ByteVector<Byte> {
    public S8Vector() {
        this.data = empty;
    }

    public S8Vector(int size, byte value) {
        byte[] array = new byte[size];
        this.data = array;
        if (value != 0) {
            while (--size >= 0) {
                array[size] = value;
            }
        }
    }

    public S8Vector(int size) {
        this(new byte[size]);
    }

    public S8Vector(byte[] data) {
        this.data = data;
    }

    public S8Vector(byte[] data, IntSequence indexes) {
        this.data = data;
        this.indexes = indexes;
    }

    public S8Vector(byte[] values, int offset, int length) {
        this(length);
        System.arraycopy(values, offset, this.data, 0, length);
    }

    @Override
    public final int intAtBuffer(int index) {
        return this.data[index];
    }

    @Override
    public final Byte get(int index) {
        if (this.indexes != null) {
            index = this.indexes.intAt(index);
        }
        return this.data[index];
    }

    @Override
    public final Byte getBuffer(int index) {
        return this.data[index];
    }

    @Override
    public final void setBuffer(int index, Byte value) {
        this.data[index] = value;
    }

    protected S8Vector withIndexes(IntSequence ind) {
        return new S8Vector(this.data, ind);
    }

    @Override
    public S8Vector subList(int fromIx, int toIx) {
        return new S8Vector(this.data, this.indexesSubList(fromIx, toIx));
    }

    public int getElementKind() {
        return 18;
    }

    @Override
    public String getTag() {
        return "s8";
    }

    public int compareTo(Object obj) {
        return S8Vector.compareToInt(this, (S8Vector)obj);
    }
}

