/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.util.Objects;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.AbstractTerminal;
import org.jline.utils.InputStreamReader;
import org.jline.utils.NonBlockingReader;

public class LineDisciplineTerminal
extends AbstractTerminal {
    private static final int PIPE_SIZE = 1024;
    protected final OutputStream masterOutput;
    protected final OutputStream slaveInputPipe;
    protected final InputStream slaveInput;
    protected final NonBlockingReader slaveReader;
    protected final PrintWriter slaveWriter;
    protected final OutputStream slaveOutput;
    protected final Attributes attributes;
    protected final Size size;

    public LineDisciplineTerminal(String name, String type, OutputStream masterOutput, String encoding) throws IOException {
        super(name, type);
        PipedInputStream input = new PipedInputStream(1024);
        this.slaveInputPipe = new PipedOutputStream(input);
        this.slaveInput = new FilterInputStream(input){};
        this.slaveReader = new NonBlockingReader(this.getName(), new InputStreamReader(this.slaveInput, encoding));
        this.slaveOutput = new FilteringOutputStream();
        this.slaveWriter = new PrintWriter(new OutputStreamWriter(this.slaveOutput, encoding));
        this.masterOutput = masterOutput;
        this.attributes = new Attributes();
        this.size = new Size(160, 50);
        this.parseInfoCmp();
    }

    @Override
    public NonBlockingReader reader() {
        return this.slaveReader;
    }

    @Override
    public PrintWriter writer() {
        return this.slaveWriter;
    }

    @Override
    public InputStream input() {
        return this.slaveInput;
    }

    @Override
    public OutputStream output() {
        return this.slaveOutput;
    }

    @Override
    public Attributes getAttributes() {
        Attributes attr = new Attributes();
        attr.copy(this.attributes);
        return attr;
    }

    @Override
    public void setAttributes(Attributes attr) {
        this.attributes.copy(attr);
    }

    @Override
    public Size getSize() {
        Size sz = new Size();
        sz.copy(this.size);
        return sz;
    }

    @Override
    public void setSize(Size sz) {
        this.size.copy(sz);
    }

    @Override
    public void raise(Terminal.Signal signal) {
        Objects.requireNonNull(signal);
        this.echoSignal(signal);
        super.raise(signal);
    }

    public void processInputByte(int c) throws IOException {
        if (this.attributes.getLocalFlag(Attributes.LocalFlag.ISIG)) {
            if (c == this.attributes.getControlChar(Attributes.ControlChar.VINTR)) {
                this.raise(Terminal.Signal.INT);
                return;
            }
            if (c == this.attributes.getControlChar(Attributes.ControlChar.VQUIT)) {
                this.raise(Terminal.Signal.QUIT);
                return;
            }
            if (c == this.attributes.getControlChar(Attributes.ControlChar.VSUSP)) {
                this.raise(Terminal.Signal.TSTP);
                return;
            }
            if (c == this.attributes.getControlChar(Attributes.ControlChar.VSTATUS)) {
                this.raise(Terminal.Signal.INFO);
            }
        }
        if (c == 13) {
            if (this.attributes.getInputFlag(Attributes.InputFlag.IGNCR)) {
                return;
            }
            if (this.attributes.getInputFlag(Attributes.InputFlag.ICRNL)) {
                c = 10;
            }
        } else if (c == 10 && this.attributes.getInputFlag(Attributes.InputFlag.INLCR)) {
            c = 13;
        }
        if (this.attributes.getLocalFlag(Attributes.LocalFlag.ECHO)) {
            this.processOutputByte(c);
            this.masterOutput.flush();
        }
        this.slaveInputPipe.write(c);
        this.slaveInputPipe.flush();
    }

    protected void processOutputByte(int c) throws IOException {
        if (this.attributes.getOutputFlag(Attributes.OutputFlag.OPOST) && c == 10 && this.attributes.getOutputFlag(Attributes.OutputFlag.ONLCR)) {
            this.masterOutput.write(13);
            this.masterOutput.write(10);
            return;
        }
        this.masterOutput.write(c);
    }

    @Override
    public void close() throws IOException {
        try {
            this.slaveReader.close();
        }
        finally {
            try {
                this.slaveInputPipe.close();
            }
            finally {
                this.slaveWriter.close();
            }
        }
    }

    private class FilteringOutputStream
    extends OutputStream {
        private FilteringOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            LineDisciplineTerminal.this.processOutputByte(b);
        }

        @Override
        public void flush() throws IOException {
            LineDisciplineTerminal.this.masterOutput.flush();
        }

        @Override
        public void close() throws IOException {
            LineDisciplineTerminal.this.masterOutput.close();
        }
    }
}

