/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.acl2.modsext;

import com.sun.electric.tool.simulation.acl2.mods.Assign;
import com.sun.electric.tool.simulation.acl2.mods.Driver;
import com.sun.electric.tool.simulation.acl2.mods.IndexName;
import com.sun.electric.tool.simulation.acl2.mods.Lhatom;
import com.sun.electric.tool.simulation.acl2.mods.Lhrange;
import com.sun.electric.tool.simulation.acl2.mods.Lhs;
import com.sun.electric.tool.simulation.acl2.mods.Util;
import com.sun.electric.tool.simulation.acl2.svex.Svar;
import com.sun.electric.tool.simulation.acl2.svex.SvarName;
import com.sun.electric.tool.simulation.acl2.svex.Svex;
import com.sun.electric.tool.simulation.acl2.svex.SvexCall;
import com.sun.electric.tool.simulation.acl2.svex.SvexManager;
import com.sun.electric.tool.simulation.acl2.svex.SvexQuote;
import com.sun.electric.tool.simulation.acl2.svex.SvexVar;
import com.sun.electric.tool.simulation.acl2.svex.funs.Vec4Res;
import com.sun.electric.util.acl2.ACL2;
import com.sun.electric.util.acl2.ACL2Backed;
import com.sun.electric.util.acl2.ACL2Object;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Compile<N extends SvarName> {
    private final List<Lhs<N>> aliases;
    private final SvexManager<N> sm;
    public final Svex<N>[] svexarr;
    public final List<Assign<N>> normAssigns;
    public final Map<Svar<N>, List<Driver<N>>> netAssigns;
    public final Map<Svar<N>, Svex<N>> resAssigns;
    public final Map<Svar<N>, Svar<N>> resDelays;

    Compile(List<Lhs<N>> aliases, List<Assign<IndexName>> assigns, SvexManager<N> sm) {
        this.aliases = aliases;
        this.sm = sm;
        this.svexarr = Svex.newSvexArray(aliases.size());
        for (int i = 0; i < aliases.size(); ++i) {
            this.svexarr[i] = aliases.get(i).toSvex(sm);
        }
        HashMap<SvexCall<IndexName>, Svex<N>> memoize = new HashMap<SvexCall<IndexName>, Svex<N>>();
        this.normAssigns = this.assignsSubst(assigns, memoize);
        this.netAssigns = this.assignsToNetassigns(this.normAssigns);
        this.resAssigns = this.netassignsResolves(this.netAssigns);
        this.resDelays = Compile.collectDelays(Svex.collectVarsRev(this.resAssigns.values()), sm);
    }

    Lhs<N> aliasNorm(Lhs<IndexName> x) {
        Lhs.Decomp<IndexName> decomp = x.decomp();
        if (decomp.first == null) {
            return new Lhs(Collections.emptyList());
        }
        Lhrange first = decomp.first;
        Svar svar = first.getVar();
        if (svar == null) {
            Lhrange newFirst = new Lhrange(first.getWidth(), Lhatom.Z());
            return this.aliasNorm(decomp.rest).cons(newFirst);
        }
        int idx = ((IndexName)svar.getName()).getIndex();
        Lhs<N> low = this.aliases.get(idx).rsh(first.getRsh());
        Lhs<N> high = this.aliasNorm(decomp.rest);
        return low.concat(first.getWidth(), high);
    }

    private Svex<N> svexSubstFromSvexarr(Svex<IndexName> x, Map<SvexCall<IndexName>, Svex<N>> memoize) {
        if (x instanceof SvexVar) {
            SvexVar sv = (SvexVar)x;
            Svex<N> svex = this.svexarr[((IndexName)sv.svar.getName()).getIndex()];
            HashMap addDelayCache = new HashMap();
            return svex.addDelay(sv.svar.getDelay(), this.sm, addDelayCache);
        }
        if (x instanceof SvexQuote) {
            return SvexQuote.valueOf(((SvexQuote)x).val);
        }
        SvexCall sc = (SvexCall)x;
        Svex<N> newX = memoize.get(sc);
        if (newX == null) {
            Svex<N>[] args = sc.getArgs();
            Svex<N>[] newArgs = Svex.newSvexArray(args.length);
            for (int i = 0; i < args.length; ++i) {
                newArgs[i] = this.svexSubstFromSvexarr(args[i], memoize);
            }
            newX = sc.fun.callStar(this.sm, newArgs);
            memoize.put(sc, newX);
        }
        return newX;
    }

    private List<Assign<N>> assignsSubst(Collection<Assign<IndexName>> assigns, Map<SvexCall<IndexName>, Svex<N>> memoize) {
        ArrayList<Assign<N>> newAssigns = new ArrayList<Assign<N>>();
        for (Assign<IndexName> assign : assigns) {
            Lhs<IndexName> lhs = assign.lhs;
            Driver drv = assign.driver;
            Lhs<N> newLhs = this.aliasNorm(lhs);
            Svex<N> val = this.svexSubstFromSvexarr(drv.svex, memoize);
            Driver<N> newDrv = new Driver<N>(val, drv.strength);
            Assign<N> newAssign = new Assign<N>(newLhs, newDrv);
            newAssigns.add(newAssign);
        }
        assert (newAssigns.size() == assigns.size());
        return newAssigns;
    }

    private Map<Svar<N>, List<Driver<N>>> assignsToNetassigns(List<Assign<N>> assigns) {
        Svex<N> Z2 = SvexQuote.Z();
        LinkedHashMap netassignsRev = new LinkedHashMap();
        for (int i = assigns.size() - 1; i >= 0; --i) {
            Assign<N> assign = assigns.get(i);
            Lhs lhs = assign.lhs;
            Driver drv = assign.driver;
            assert (lhs.isNormp());
            int offset = lhs.width();
            for (int j = lhs.ranges.size() - 1; j >= 0; --j) {
                Lhrange range = lhs.ranges.get(j);
                offset -= range.getWidth();
                Svar svar = range.getVar();
                if (svar == null) continue;
                Svex<N> svex = drv.svex.rsh(this.sm, offset);
                svex = svex.concat(this.sm, range.getWidth(), Z2);
                svex = Z2.concat(this.sm, range.getRsh(), svex);
                Driver newDrv = new Driver(svex, drv.strength);
                LinkedList drivers = (LinkedList)netassignsRev.get(svar);
                if (drivers == null) {
                    drivers = new LinkedList();
                    netassignsRev.put(svar, drivers);
                }
                drivers.add(newDrv);
            }
        }
        ArrayList netassignsEntries = new ArrayList();
        netassignsEntries.addAll(netassignsRev.entrySet());
        LinkedHashMap<Svar<N>, List<Driver<N>>> netassigns = new LinkedHashMap<Svar<N>, List<Driver<N>>>();
        for (int i = netassignsEntries.size() - 1; i >= 0; --i) {
            Map.Entry e = (Map.Entry)netassignsEntries.get(i);
            netassigns.put((Svar)e.getKey(), (List)e.getValue());
        }
        return netassigns;
    }

    private Map<Svar<N>, Svex<N>> netassignsResolves(Map<Svar<N>, List<Driver<N>>> netassigns) {
        SvexQuote.Z();
        LinkedHashMap<Svar<N>, Svex<N>> resolves = new LinkedHashMap<Svar<N>, Svex<N>>();
        for (Map.Entry<Svar<N>, List<Driver<N>>> e : netassigns.entrySet()) {
            Svar<N> svar = e.getKey();
            List<Driver<N>> drivers = e.getValue();
            Util.check(svar.getDelay() == 0);
            assert (!drivers.isEmpty());
            Svex svex = drivers.get((int)(drivers.size() - 1)).svex;
            for (int i = drivers.size() - 2; i >= 0; --i) {
                svex = this.sm.newCall(Vec4Res.FUNCTION, drivers.get((int)i).svex, svex);
            }
            resolves.put(svar, svex);
        }
        return resolves;
    }

    public static <N extends SvarName> Map<Svar<N>, Svar<N>> collectDelays(Collection<Svar<N>> svarsRev, SvexManager<N> sm) {
        LinkedHashMap<Svar<N>, Svar<N>> result = new LinkedHashMap<Svar<N>, Svar<N>>();
        ArrayList<Svar<N>> svarsList = new ArrayList<Svar<N>>(svarsRev);
        for (int i = svarsList.size() - 1; i >= 0; --i) {
            Svar<N> svar = (Svar<N>)svarsList.get(i);
            while (svar.getDelay() > 0) {
                Svar<N> sv = sm.getVar(svar.getName(), svar.getDelay() - 1, false);
                result.put(svar, sv);
                svar = sv;
            }
        }
        return result;
    }

    public ACL2Object svexarrAsACL2Object() {
        ACL2Object result = ACL2.NIL;
        for (int i = this.svexarr.length - 1; i >= 0; --i) {
            result = ACL2.cons(this.svexarr[i].getACL2Object(), result);
        }
        return result;
    }

    public ACL2Object normAssignsAsACL2Object() {
        HashMap<ACL2Backed, ACL2Object> backedCache = new HashMap<ACL2Backed, ACL2Object>();
        ACL2Object result = ACL2.NIL;
        for (Assign<N> assign : this.normAssigns) {
            Lhs lhs = assign.lhs;
            Driver drv = assign.driver;
            result = ACL2.cons(ACL2.cons(lhs.getACL2Object(backedCache), drv.getACL2Object(backedCache)), result);
        }
        return Util.revList(result);
    }

    public ACL2Object netAssignsAsACL2Object() {
        HashMap<ACL2Backed, ACL2Object> backedCache = new HashMap<ACL2Backed, ACL2Object>();
        ACL2Object result = ACL2.NIL;
        for (Map.Entry<Svar<N>, List<Driver<N>>> e : this.netAssigns.entrySet()) {
            Svar<N> svar = e.getKey();
            List<Driver<N>> drivers = e.getValue();
            ACL2Object acl2Drivers = ACL2.NIL;
            for (int i = drivers.size() - 1; i >= 0; --i) {
                Driver<N> drv = drivers.get(i);
                acl2Drivers = ACL2.cons(drv.getACL2Object(backedCache), acl2Drivers);
            }
            result = ACL2.cons(ACL2.cons(svar.getACL2Object(backedCache), acl2Drivers), result);
        }
        return Util.revList(result);
    }

    public ACL2Object resAssignsAsACL2Object() {
        HashMap<ACL2Backed, ACL2Object> backedCache = new HashMap<ACL2Backed, ACL2Object>();
        ACL2Object result = ACL2.NIL;
        for (Map.Entry<Svar<N>, Svex<N>> e : this.resAssigns.entrySet()) {
            Svar<N> svar = e.getKey();
            Svex<N> svex = e.getValue();
            result = ACL2.cons(ACL2.cons(svar.getACL2Object(backedCache), svex.getACL2Object(backedCache)), result);
        }
        return Util.revList(result);
    }

    public ACL2Object resDelaysAsACL2Object() {
        HashMap<ACL2Backed, ACL2Object> backedCache = new HashMap<ACL2Backed, ACL2Object>();
        ACL2Object result = ACL2.NIL;
        for (Map.Entry<Svar<N>, Svar<N>> e : this.resDelays.entrySet()) {
            Svar<N> svarDelayed = e.getKey();
            Svar<N> svar = e.getValue();
            result = ACL2.cons(ACL2.cons(svarDelayed.getACL2Object(backedCache), svar.getACL2Object(backedCache)), result);
        }
        return Util.revList(result);
    }
}

