/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation;

import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.tool.simulation.DigitalSample;
import com.sun.electric.tool.simulation.RangeSample;
import com.sun.electric.tool.simulation.Sample;
import com.sun.electric.tool.simulation.Signal;
import com.sun.electric.tool.simulation.SignalCollection;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.tool.user.waveform.Panel;
import com.sun.electric.tool.user.waveform.WaveSignal;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

public class BusSample<S extends Sample>
implements Sample {
    private final Sample[] vals;

    public BusSample(Sample[] vals) {
        int numValids = 0;
        for (int i = 0; i < vals.length; ++i) {
            if (vals[i] == null) continue;
            ++numValids;
        }
        this.vals = new Sample[numValids];
        int fill = 0;
        for (int i = 0; i < vals.length; ++i) {
            if (vals[i] == null) continue;
            this.vals[fill++] = vals[i];
        }
    }

    public int getWidth() {
        return this.vals.length;
    }

    public S getTrace(int i) {
        return (S)this.vals[i];
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof BusSample)) {
            return false;
        }
        BusSample bo = (BusSample)o;
        if (bo.vals.length != this.vals.length) {
            return false;
        }
        for (int i = 0; i < this.vals.length; ++i) {
            if (this.vals[i].equals(bo.vals[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int ret = 0;
        for (int i = 0; i < this.vals.length; ++i) {
            ret ^= this.vals[i].hashCode();
        }
        return ret;
    }

    @Override
    public boolean isLogicX() {
        for (Sample s : this.vals) {
            if (s.isLogicX()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isLogicZ() {
        for (Sample s : this.vals) {
            if (s.isLogicZ()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Sample lub(Sample s) {
        if (!(s instanceof BusSample)) {
            throw new RuntimeException("tried to call BusSample.lub(" + s.getClass().getName() + ")");
        }
        BusSample ds = (BusSample)s;
        if (ds.vals.length != this.vals.length) {
            throw new RuntimeException("tried to call lub() on BusSamples of different width");
        }
        Sample[] ret = new Sample[this.vals.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.vals[i].lub(ds.vals[i]);
        }
        return new BusSample<S>(ret);
    }

    @Override
    public Sample glb(Sample s) {
        if (!(s instanceof BusSample)) {
            throw new RuntimeException("tried to call BusSample.glb(" + s.getClass().getName() + ")");
        }
        BusSample ds = (BusSample)s;
        if (ds.vals.length != this.vals.length) {
            throw new RuntimeException("tried to call glb() on BusSamples of different width");
        }
        Sample[] ret = new Sample[this.vals.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.vals[i].glb(ds.vals[i]);
        }
        return new BusSample<S>(ret);
    }

    @Override
    public double getMinValue() {
        double min = Double.MAX_VALUE;
        for (int i = 0; i < this.vals.length; ++i) {
            min = Math.min(min, this.vals[i].getMinValue());
        }
        return min;
    }

    @Override
    public double getMaxValue() {
        double max = -1.7976931348623157E308;
        for (int i = 0; i < this.vals.length; ++i) {
            max = Math.max(max, this.vals[i].getMaxValue());
        }
        return max;
    }

    public static <SS extends Sample> Signal<BusSample<SS>> createSignal(SignalCollection sc, Stimuli sd, String signalName, String signalContext, int width) {
        throw new RuntimeException("not implemented");
    }

    public static <SS extends Sample> Signal<BusSample<SS>> createSignal(SignalCollection sc, Stimuli sd, String signalName, String signalContext, boolean digital, final Signal<SS>[] subsignals) {
        return new Signal<BusSample<SS>>(sc, sd, signalName, signalContext, digital){

            @Override
            public boolean isEmpty() {
                for (Signal sig : subsignals) {
                    if (sig.isEmpty()) continue;
                    return false;
                }
                return true;
            }

            @Override
            public Signal<?>[] getBusMembers() {
                return subsignals;
            }

            @Override
            public Signal.View<RangeSample<BusSample<SS>>> getRasterView(double t0, double t1, int numPixels) {
                Signal.View[] subviews = new Signal.View[subsignals.length];
                for (int i = 0; i < subviews.length; ++i) {
                    subviews[i] = subsignals[i].getRasterView(t0, t1, numPixels);
                }
                TreeMap<Double, HashSet<Integer>> tm = new TreeMap<Double, HashSet<Integer>>();
                for (int i = 0; i < subviews.length; ++i) {
                    Signal.View view = subviews[i];
                    for (int j = 0; j < view.getNumEvents(); ++j) {
                        Double t = view.getTime(j);
                        HashSet<Integer> hs = (HashSet<Integer>)tm.get(t);
                        if (hs == null) {
                            hs = new HashSet<Integer>();
                            tm.put(t, hs);
                        }
                        hs.add(i);
                    }
                }
                final double[] times = new double[tm.size()];
                final RangeSample[] vals = new RangeSample[tm.size()];
                int i = 0;
                int[] event = new int[subviews.length];
                Sample[] minvals = new Sample[subviews.length];
                Sample[] maxvals = new Sample[subviews.length];
                for (Double t : tm.keySet()) {
                    times[i] = t;
                    HashSet hs = (HashSet)tm.get(t);
                    Iterator iterator = hs.iterator();
                    while (iterator.hasNext()) {
                        int v = (Integer)iterator.next();
                        if (subviews[v].getTime(event[v]) != t.doubleValue()) continue;
                        RangeSample rs = (RangeSample)subviews[v].getSample(event[v]);
                        if (rs != null) {
                            minvals[v] = rs.getMin();
                            maxvals[v] = rs.getMax();
                        }
                        int n = v;
                        event[n] = event[n] + 1;
                    }
                    vals[i] = new RangeSample(new BusSample(minvals), new BusSample(maxvals));
                    ++i;
                }
                return new Signal.View<RangeSample<BusSample<SS>>>(){

                    @Override
                    public int getNumEvents() {
                        return times.length;
                    }

                    @Override
                    public double getTime(int event) {
                        return times[event];
                    }

                    @Override
                    public RangeSample<BusSample<SS>> getSample(int event) {
                        return vals[event];
                    }
                };
            }

            @Override
            public Signal.View<BusSample<SS>> getExactView() {
                Signal.View[] subviews = new Signal.View[subsignals.length];
                for (int i = 0; i < subviews.length; ++i) {
                    subviews[i] = subsignals[i].getExactView();
                }
                TreeMap<Double, HashSet<Integer>> tm = new TreeMap<Double, HashSet<Integer>>();
                for (int i = 0; i < subviews.length; ++i) {
                    Signal.View view = subviews[i];
                    for (int j = 0; j < view.getNumEvents(); ++j) {
                        Double t = view.getTime(j);
                        HashSet<Integer> hs = (HashSet<Integer>)tm.get(t);
                        if (hs == null) {
                            hs = new HashSet<Integer>();
                            tm.put(t, hs);
                        }
                        hs.add(i);
                    }
                }
                final double[] times = new double[tm.size()];
                final BusSample[] vals = new BusSample[tm.size()];
                int i = 0;
                int[] event = new int[subviews.length];
                Sample[] sampleVals = new Sample[subviews.length];
                for (Double t : tm.keySet()) {
                    times[i] = t;
                    HashSet hs = (HashSet)tm.get(t);
                    Iterator iterator = hs.iterator();
                    while (iterator.hasNext()) {
                        int v = (Integer)iterator.next();
                        assert (subviews[v].getTime(event[v]) == t.doubleValue());
                        Object rs = subviews[v].getSample(event[v]);
                        if (rs != null) {
                            sampleVals[v] = rs;
                        }
                        int n = v;
                        event[n] = event[n] + 1;
                    }
                    vals[i] = new BusSample(sampleVals);
                    ++i;
                }
                return new Signal.View<BusSample<SS>>(){

                    @Override
                    public int getNumEvents() {
                        return times.length;
                    }

                    @Override
                    public double getTime(int event) {
                        return times[event];
                    }

                    @Override
                    public BusSample<SS> getSample(int event) {
                        return vals[event];
                    }
                };
            }

            @Override
            public double getMinTime() {
                double min = Double.MAX_VALUE;
                for (Signal sig : subsignals) {
                    min = Math.min(min, sig.getMinTime());
                }
                return min;
            }

            @Override
            public double getMaxTime() {
                double max = -1.7976931348623157E308;
                for (Signal sig : subsignals) {
                    max = Math.max(max, sig.getMaxTime());
                }
                return max;
            }

            @Override
            public double getMinValue() {
                double min = Double.MAX_VALUE;
                for (Signal sig : subsignals) {
                    min = Math.min(min, sig.getMinValue());
                }
                return min;
            }

            @Override
            public double getMaxValue() {
                double max = -1.7976931348623157E308;
                for (Signal sig : subsignals) {
                    max = Math.max(max, sig.getMaxValue());
                }
                return max;
            }

            @Override
            public void plot(Panel panel, Graphics g, WaveSignal ws, Color light, List<PolyBase> forPs, Rectangle2D bounds, List<Panel.WaveSelection> selectedObjects, Signal<?> xAxisSignal) {
                Dimension sz = panel.getSize();
                int hei = sz.height;
                Signal<?> ds = ws.getSignal();
                Signal.View<RangeSample<?>> view = ds.getRasterView(panel.convertXScreenToData(0), panel.convertXScreenToData(sz.width), sz.width);
                int lastX = 0;
                int trueLen = (subsignals.length + 3) / 4 * 4;
                int[] values = new int[trueLen];
                for (int i = 0; i < view.getNumEvents(); ++i) {
                    double xValue = view.getTime(i);
                    RangeSample<?> rs = view.getSample(i);
                    BusSample bs = (BusSample)rs.getMin();
                    int invert = trueLen - 1;
                    for (int j = 0; j < bs.getWidth(); ++j) {
                        switch (DigitalSample.getState((DigitalSample)bs.getTrace(j)) & 3) {
                            case 0: {
                                values[invert] = 0;
                                break;
                            }
                            case 2: {
                                values[invert] = 1;
                                break;
                            }
                            case 1: {
                                values[invert] = 2;
                                break;
                            }
                            case 3: {
                                values[invert] = 3;
                                break;
                            }
                            default: {
                                values[invert] = 4;
                            }
                        }
                        --invert;
                    }
                    int x = panel.convertXDataToScreen(xValue);
                    if (x >= panel.getVertAxisPos()) {
                        int j;
                        if (x < panel.getVertAxisPos() + 5) {
                            if (panel.processALine(g, x, hei / 2, x + 5, hei - 5, bounds, forPs, selectedObjects, ws, -1)) {
                                return;
                            }
                            if (panel.processALine(g, x, hei / 2, x + 5, 5, bounds, forPs, selectedObjects, ws, -1)) {
                                return;
                            }
                        } else {
                            if (panel.processALine(g, x - 5, 5, x + 5, hei - 5, bounds, forPs, selectedObjects, ws, -1)) {
                                return;
                            }
                            if (panel.processALine(g, x + 5, 5, x - 5, hei - 5, bounds, forPs, selectedObjects, ws, -1)) {
                                return;
                            }
                        }
                        if (lastX + 5 < x - 5) {
                            if (panel.processALine(g, lastX + 5, 5, x - 5, 5, bounds, forPs, selectedObjects, ws, -1)) {
                                return;
                            }
                            if (panel.processALine(g, lastX + 5, hei - 5, x - 5, hei - 5, bounds, forPs, selectedObjects, ws, -1)) {
                                return;
                            }
                        }
                        Object valString = "0x";
                        for (j = 0; j < trueLen; ++j) {
                            if (values[j] == 4) {
                                valString = "?";
                                break;
                            }
                            if (values[j] == 3) {
                                valString = "Z";
                                break;
                            }
                            if (values[j] != 2) continue;
                            valString = "X";
                            break;
                        }
                        if (((String)valString).length() > 1) {
                            for (j = 0; j < trueLen; j += 4) {
                                int hexDigit = 0;
                                if (values[j] == 1) {
                                    hexDigit += 8;
                                }
                                if (values[j + 1] == 1) {
                                    hexDigit += 4;
                                }
                                if (values[j + 2] == 1) {
                                    hexDigit += 2;
                                }
                                if (values[j + 3] == 1) {
                                    ++hexDigit;
                                }
                                valString = hexDigit < 10 ? (String)valString + (char)(48 + hexDigit) : (String)valString + (char)(65 + hexDigit - 10);
                            }
                        }
                        if (g != null) {
                            g.setFont(panel.getWaveWindow().getFont());
                            GlyphVector gv = panel.getWaveWindow().getFont().createGlyphVector(panel.getWaveWindow().getFontRenderContext(), (String)valString);
                            Rectangle2D glyphBounds = gv.getLogicalBounds();
                            int textHei = (int)glyphBounds.getHeight();
                            g.drawString((String)valString, x + 2, hei / 2 + textHei / 2);
                        }
                        if (forPs != null) {
                            Poly poly = new Poly(Poly.fromLambda(x + 2, hei / 2));
                            poly.setStyle(Poly.Type.TEXTLEFT);
                            poly.setTextDescriptor(TextDescriptor.EMPTY.withAbsSize(8));
                            poly.setString((String)valString);
                            forPs.add(poly);
                        }
                    }
                    lastX = x;
                }
                int wid = sz.width;
                if (lastX + 5 < wid) {
                    if (panel.processALine(g, lastX + 5, 5, wid, 5, bounds, forPs, selectedObjects, ws, -1)) {
                        return;
                    }
                    if (panel.processALine(g, lastX + 5, hei - 5, wid, hei - 5, bounds, forPs, selectedObjects, ws, -1)) {
                        return;
                    }
                }
            }
        };
    }
}

