/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.experimentalAStar2.algorithm;

import com.sun.electric.tool.routing.experimentalAStar2.algorithm.AStarClosedListBase;
import com.sun.electric.tool.routing.experimentalAStar2.algorithm.AStarGoalBase;
import com.sun.electric.tool.routing.experimentalAStar2.algorithm.AStarMapBase;
import com.sun.electric.tool.routing.experimentalAStar2.algorithm.AStarMapVisitorBase;
import com.sun.electric.tool.routing.experimentalAStar2.algorithm.AStarNodeBase;
import com.sun.electric.tool.routing.experimentalAStar2.algorithm.AStarOpenListBase;
import com.sun.electric.tool.routing.experimentalAStar2.memorymanager.ObjectPool;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public abstract class AStar {
    public static <T extends AStarNodeBase<T>> List<T> findPath(AStarOpenListBase<T> openList, AStarClosedListBase<T> closedList, AStarMapBase<T> map, AStarGoalBase<T> goal, ObjectPool<T> nodePool, AStarMapVisitorBase<T> usedVisitor) {
        T currentNode;
        int currentRevolutions = 0;
        while ((currentNode = openList.removeCheapestOpenNode()) != null && !goal.isPathFinished(currentNode)) {
            map.visitNeighboursOf(currentNode, usedVisitor);
            if (goal.shouldGiveUp(++currentRevolutions)) break;
            closedList.addNodeToClosedList(currentNode);
        }
        List<T> path = null;
        if (currentNode != null && goal.distanceToGoal(((AStarNodeBase)currentNode).getX(), ((AStarNodeBase)currentNode).getY(), ((AStarNodeBase)currentNode).getZ()) == 0) {
            path = AStar.traceBackPath(currentNode);
            currentNode = null;
        }
        openList.clearOpenList();
        closedList.clearClosedList();
        return path;
    }

    private static <T extends AStarNodeBase<T>> List<T> traceBackPath(T goalNode) {
        LinkedList<T> path = new LinkedList<T>();
        Object currentNode = goalNode;
        path.add((T)currentNode);
        while (currentNode.origin != null) {
            currentNode = (AStarNodeBase)currentNode.origin;
            path.add((T)currentNode);
        }
        Collections.reverse(path);
        return path;
    }
}

