/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.flag.hornFunnel2;

import java.util.List;

public class Node {
    private static int nodeCounter = 1;
    private final int id = nodeCounter++;
    private final int height;
    private final Node leftChild;
    private final Node rightChild;
    private final Node parent;
    private int slot;

    public Node(Node parent, int height, int slot, List<Node> slots) {
        this.parent = parent;
        this.height = height;
        this.slot = slot;
        slots.set(slot, this);
        if (height == 1) {
            this.rightChild = null;
            this.leftChild = null;
        } else {
            int childHeight = height - 1;
            int childNbSlots = (int)(Math.pow(2.0, childHeight) - 1.0);
            int halfChildSlots = (childNbSlots + 1) / 2;
            this.leftChild = new Node(this, childHeight, slot - halfChildSlots, slots);
            this.rightChild = new Node(this, childHeight, slot + halfChildSlots, slots);
        }
    }

    public Node getLeftChild() {
        return this.leftChild;
    }

    public Node getRightChild() {
        return this.rightChild;
    }

    public Node getParent() {
        return this.parent;
    }

    public int getSlot() {
        return this.slot;
    }

    public void setSlot(int s) {
        this.slot = s;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isLeaf() {
        return this.leftChild == null;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public int getMinChildWireSlot() {
        int s = this.getSlot();
        if (this.isLeaf()) {
            return s;
        }
        s = Math.min(s, this.getLeftChild().getSlot());
        s = Math.min(s, this.getRightChild().getSlot());
        return s;
    }

    public int getMaxChildWireSlot() {
        int s = this.getSlot();
        if (this.isLeaf()) {
            return s;
        }
        s = Math.max(s, this.getLeftChild().getSlot());
        s = Math.max(s, this.getRightChild().getSlot());
        return s;
    }

    public int getChildWireLength() {
        return this.getMaxChildWireSlot() - this.getMinChildWireSlot();
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        return "Node id=" + this.id + " height=" + this.height + " slot=" + this.slot + " childWireLen=" + this.getChildWireLength();
    }

    public static void resetIds() {
        nodeCounter = 1;
    }
}

