/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tests;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.technology.TechPool;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.LibraryFiles;
import com.sun.electric.tool.io.input.SimulationData;
import com.sun.electric.tool.io.output.PNG;
import com.sun.electric.tool.simulation.Engine;
import com.sun.electric.tool.simulation.ScalarSample;
import com.sun.electric.tool.simulation.Signal;
import com.sun.electric.tool.simulation.SignalCollection;
import com.sun.electric.tool.simulation.SimulationTool;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.tool.simulation.SweptSample;
import com.sun.electric.tool.simulation.als.ALS;
import com.sun.electric.tool.simulation.irsim.IRSIM;
import com.sun.electric.tool.user.MessagesStream;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.tests.AbstractGUITest;
import com.sun.electric.tool.user.tests.AbstractTest;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.tool.user.waveform.Panel;
import com.sun.electric.tool.user.waveform.WaveSignal;
import com.sun.electric.tool.user.waveform.WaveformWindow;
import com.sun.electric.util.ClientOS;
import com.sun.electric.util.TextUtils;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class WaveformTest
extends AbstractGUITest {
    private final String testName;
    private final String cellName;
    private final String stimuliExtension;
    private final String cmdFileExtension;
    private final int engine;
    private final PanelSpec[] panelSpecs;
    private final boolean locked;
    private transient Panel[] panels;

    public WaveformTest(String commandName, String testName, String cellName, String stimuliExtension, boolean locked, int engine, String cmdFileExtension, PanelSpec spec1) {
        this(commandName, testName, cellName, stimuliExtension, locked, engine, cmdFileExtension, new PanelSpec[]{spec1});
    }

    public WaveformTest(String commandName, String testName, String cellName, String stimuliExtension, boolean locked, int engine, String cmdFileExtension, PanelSpec spec1, PanelSpec spec2) {
        this(commandName, testName, cellName, stimuliExtension, locked, engine, cmdFileExtension, new PanelSpec[]{spec1, spec2});
    }

    public WaveformTest(String commandName, String testName, String cellName, String stimuliExtension, boolean locked, int engine, String cmdFileExtension, PanelSpec spec1, PanelSpec spec2, PanelSpec spec3) {
        this(commandName, testName, cellName, stimuliExtension, locked, engine, cmdFileExtension, new PanelSpec[]{spec1, spec2, spec3});
    }

    public WaveformTest(String commandName, String testName, String cellName, String stimuliExtension, boolean locked, int engine, String cmdFileExtension, PanelSpec spec1, PanelSpec spec2, PanelSpec spec3, PanelSpec spec4) {
        this(commandName, testName, cellName, stimuliExtension, locked, engine, cmdFileExtension, new PanelSpec[]{spec1, spec2, spec3, spec4});
    }

    public WaveformTest(String commandName, String testName, String cellName, String stimuliExtension, boolean locked, int engine, String cmdFileExtension, PanelSpec ... panelSpecs) {
        super(commandName);
        this.testName = testName;
        this.cellName = cellName;
        this.stimuliExtension = stimuliExtension;
        this.locked = locked;
        this.engine = engine;
        this.cmdFileExtension = cmdFileExtension;
        this.panelSpecs = panelSpecs;
    }

    public static List<AbstractTest> getTests() {
        ArrayList<AbstractTest> list = new ArrayList<AbstractTest>();
        list.add(new WaveformTest("ALS1", "ALS-1", "ALS-1{sch}", null, true, 0, ".vec", new PanelSpec(null, "a"), new PanelSpec(null, "b"), new PanelSpec(null, "c")));
        if (IRSIM.hasIRSIM()) {
            list.add(new WaveformTest("IRSIM1", "IRSIM-1", "IRSIM-1{lay}", null, true, 1, ".cmd", new PanelSpec[0]));
            list.add(new WaveformTest("IRSIM2", "IRSIM-2", "IRSIM-2{lay}", null, true, 1, ".cmd", new PanelSpec[0]));
            list.add(new WaveformTest("IRSIM3", "IRSIM-3", "IRSIM-3{lay}", ".sim", true, 1, ".cmd", new PanelSpec[0]));
        }
        list.add(new WaveformTest("Spice2", "Spice2-1", "Spice2-1{sch}", ".spo", true, -1, null, new PanelSpec(null, "signal 1", "signal 2")));
        list.add(new WaveformTest("HSpice1", "SpiceH-1", "SpiceH-1{sch}", ".tr0", true, -1, null, new PanelSpec(null, "5:net_16_"), new PanelSpec(null, "1:net_198_", "3:net_198_")));
        list.add(new WaveformTest("HSpice2", "SpiceH-2", "SpiceH-2{sch}", ".tr0", true, -1, null, new PanelSpec("MEASUREMENTS", "n10d0", "n10d150")));
        list.add(new WaveformTest("HSpice3", "SpiceH-3", "SpiceH-3{sch}", ".tr0", false, -1, null, new PanelSpec("DC SIGNALS", "a5.rp1.rrp_sub@1.v(1,39:3_"), new PanelSpec("DC SIGNALS", "rshortc"), new PanelSpec("TRANS SIGNALS", "v(c1,ref")));
        list.add(new WaveformTest("HSpice4", "SpiceH-4", "SpiceH-4{sch}", ".tr0", false, -1, null, new PanelSpec("TRANS SIGNALS", "aa", "bb"), new PanelSpec("DC SIGNALS", "cat"), new PanelSpec("MEASUREMENTS", "temper")));
        list.add(new WaveformTest("HSpice5", "SpiceH-5", "SpiceH-5{sch}", ".tr0", true, -1, null, new PanelSpec(null, "net@4", "net@3"), new PanelSpec(null, "i(vpulse@0", "i(vvdd")));
        list.add(new WaveformTest("HSpice6", "SpiceH-6", "SpiceH-6{sch}", ".tr0", true, -1, null, new PanelSpec(null, "txclk", "clk_path_test.invclk[3]_out_"), new PanelSpec(null, "i(vvdd", "i(vclk")));
        list.add(new WaveformTest("HSpice7", "SpiceH-7", "SpiceH-7{lay}", ".tr0", false, -1, null, new PanelSpec("TRANS SIGNALS", "in0", "out"), new PanelSpec("MEASUREMENTS", "inbufstr", "index", "outloadstr")));
        list.add(new WaveformTest("HSpice8", "SpiceH-8", "SpiceH-8{sch}", ".tr0", false, -1, null, new PanelSpec("TRANS SIGNALS", "v(inn"), new PanelSpec("AC SIGNALS", "gain1"), new PanelSpec("MEASUREMENTS", "index", "alter")));
        list.add(new WaveformTest("HSpice9", "SpiceH-9", "SpiceH-9{sch}", ".tr0", false, -1, null, new PanelSpec("TRANS SIGNALS", "1"), new PanelSpec("AC SIGNALS", "1", "i(v2")));
        list.add(new WaveformTest("HSpice10", "SpiceH-10", "SpiceH-10{sch}", ".tr0", false, -1, null, new PanelSpec("TRANS SIGNALS", "1"), new PanelSpec("AC SIGNALS", "1", "i(v2")));
        list.add(new WaveformTest("HSpice11", "SpiceH-11", "SpiceH-11{sch}", ".tr0", false, -1, null, new PanelSpec("TRANS SIGNALS", "out"), new PanelSpec("AC SIGNALS", "net@5", "out")));
        list.add(new WaveformTest("HSpice12", "SpiceH-12", "SpiceH-12{sch}", ".tr0", false, -1, null, new PanelSpec("TRANS SIGNALS", "a_b_", "a_bn_", "an_b_", "an_bn_")));
        list.add(new WaveformTest("HSpice13", "SpiceH-13", "SpiceH-13{sch}", ".tr0", false, -1, null, new PanelSpec("TRANS SIGNALS", "1", "2")));
        list.add(new WaveformTest("EpicSpice1", "SpiceEpic-1", "SpiceEpic-1{sch}", ".out", true, -1, null, new PanelSpec(null, "in", "out")));
        list.add(new WaveformTest("EpicSpice2", "SpiceEpic-2", "SpiceEpic-2{sch}", ".out", true, -1, null, new PanelSpec(null, "1", "2")));
        list.add(new WaveformTest("LTSpice1", "SpiceLT-1", "SpiceLT-1{sch}", ".raw", true, -1, null, new PanelSpec(null, "net@1", "net@23"), new PanelSpec(null, "i(vvsd)")));
        list.add(new WaveformTest("PSpice1", "SpiceP-1", "SpiceP-1{lay}", ".txt", true, -1, null, new PanelSpec(null, "i(c1)", "ib(q3)", "ic(q3)"), new PanelSpec(null, "w(rc1)", "w(rc2)")));
        list.add(new WaveformTest("SmartSpice1", "SpiceSmart-1", "SpiceSmart-1{lay}", ".raw", true, -1, null, new PanelSpec(null, "in", "out"), new PanelSpec(null, "m:node3:node13#internal#source")));
        list.add(new WaveformTest("SpiceOpus1", "SpiceOpus-1", "SpiceOpus-1{sch}", ".raw", true, -1, null, new PanelSpec(null, "vin", "vout")));
        list.add(new WaveformTest("SpiceOpus2", "SpiceOpus-2", "SpiceOpus-2{sch}", ".raw", true, -1, null, new PanelSpec(null, "lind0#branch", "vout")));
        list.add(new WaveformTest("SpiceOpus3", "SpiceOpus-3", "SpiceOpus-3{sch}", ".raw", true, -1, null, new PanelSpec(null, "mm1#body", "mm1#dbody"), new PanelSpec(null, "mm1#gate", "sweep"), new PanelSpec(null, "vgnd#branch", "vds#branch")));
        list.add(new WaveformTest("Verilog-1", "Verilog-1", "Verilog-1{sch}", ".dump", true, -1, null, new PanelSpec(null, "test_bench.extest_"), new PanelSpec(null, "test_bench.tdi_"), new PanelSpec(null, "test_bench.instruction[0:7]_"), new PanelSpec(null, "test_bench.j.tms_")));
        return list;
    }

    public static String getOutputDirectory() {
        String rootPath = User.getRegressionPath();
        if (rootPath == null) {
            return null;
        }
        return rootPath + "/tools/Waveform/output/";
    }

    @Override
    protected Collection<URL> getRequiredLibraries(String regressionPath) {
        if (Library.findLibrary(this.testName) != null) {
            return super.getRequiredLibraries(regressionPath);
        }
        String trueRootPath = regressionPath;
        String libPath = trueRootPath + "data/libs/";
        String libFileName = libPath + this.testName + ".jelib";
        URL libFileURL = TextUtils.makeURLToFile(libFileName);
        return Collections.singleton(libFileURL);
    }

    @Override
    protected boolean phase1() {
        if (this.engine == 0) {
            Library lib = Library.findLibrary(this.testName);
            if (lib == null) {
                System.out.println("Error reading library '" + this.testName + "'");
                return false;
            }
            Cell cell = lib.findNodeProto(this.cellName);
            SimulationTool.startSimulation(this.engine, null, cell, null, true);
        }
        return true;
    }

    @Override
    protected boolean phase2() {
        WindowFrame wf2;
        Iterator<WindowFrame> it;
        String trueRootPath = this.workingDir();
        String libPath = trueRootPath + "data/libs/";
        User.setWaveformDigitalPanelHeight(100);
        User.setWaveformAnalogPanelHeight(100);
        Library lib = Library.findLibrary(this.testName);
        if (lib == null) {
            System.out.println("Error reading library '" + this.testName + "'");
            return false;
        }
        Cell cell = lib.findNodeProto(this.cellName);
        if (this.engine == 0) {
            Cell nlCell = cell.otherView(View.NETLISTALS);
            ALS.simulateNetlist(nlCell, cell, new Stimuli());
        } else {
            ArrayList<WindowFrame> openWWs = new ArrayList<WindowFrame>();
            it = WindowFrame.getWindows();
            while (it.hasNext()) {
                wf2 = it.next();
                if (!(wf2.getContent() instanceof WaveformWindow)) continue;
                openWWs.add(wf2);
            }
            for (WindowFrame wf2 : openWWs) {
                wf2.finished();
            }
            if (this.engine < 0) {
                String waveFile = libPath + this.testName + this.stimuliExtension;
                URL url = TextUtils.makeURLToFile(waveFile);
                String netDelimeter = SimulationTool.getSpiceExtractedNetDelimiter();
                Stimuli stimuli = SimulationData.processInput(cell, url, netDelimeter);
                WaveformWindow.showSimulationDataInNewWindow(stimuli);
            } else {
                Job.getUserInterface().displayCell(cell);
                String stimFile = null;
                if (this.stimuliExtension != null) {
                    stimFile = libPath + this.testName + this.stimuliExtension;
                }
                SimulationTool.startSimulation(this.engine, stimFile, null, null, true);
            }
        }
        WindowFrame waveFrame = null;
        it = WindowFrame.getWindows();
        while (it.hasNext()) {
            wf2 = it.next();
            if (!(wf2.getContent() instanceof WaveformWindow)) continue;
            waveFrame = wf2;
            break;
        }
        if (waveFrame == null) {
            System.out.println("ERROR: No waveform window was created");
            return false;
        }
        WaveformWindow ww = (WaveformWindow)waveFrame.getContent();
        Rectangle waveLoc = new Rectangle(20, 20, 1000, 500);
        waveFrame.setWindowSize(waveLoc);
        ww.clearAllPanels();
        if (!this.locked) {
            ww.togglePanelXAxisLock();
        }
        this.panels = new Panel[this.panelSpecs.length];
        for (int p = 0; p < this.panelSpecs.length; ++p) {
            Panel wp;
            String collectionName = this.panelSpecs[p].collectionName;
            SignalCollection sc = null;
            Iterator<SignalCollection> it2 = ww.getSimData().getSignalCollections();
            while (it2.hasNext()) {
                SignalCollection oneSC = it2.next();
                if (collectionName != null && !collectionName.equals(oneSC.getName())) continue;
                sc = oneSC;
                break;
            }
            if (sc == null) {
                System.out.println("Could not find SignalCollection in waveform data");
                return false;
            }
            this.panels[p] = wp = ww.makeNewPanel(100);
            String[] signals = this.panelSpecs[p].signalNames;
            for (int i = 0; i < signals.length; ++i) {
                Signal<?> sig = sc.findSignal(signals[i]);
                if (sig == null) {
                    System.out.println("Could not find Signal '" + signals[i] + "' in waveform data");
                    return false;
                }
                if (sig == null) continue;
                new WaveSignal(wp, sig);
            }
            ww.fillScreen();
        }
        if (this.cmdFileExtension != null) {
            Engine e = ww.getSimData().getEngine();
            String stimFile = libPath + this.testName + this.cmdFileExtension;
            try {
                e.restoreStimuli(TextUtils.makeURLToFile(stimFile));
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return false;
            }
            ww.fillScreen();
        }
        return true;
    }

    @Override
    protected boolean phase3() {
        String trueRootPath = this.workingDir();
        String outputPath = trueRootPath + "output/";
        String expectedPath = trueRootPath + "data/expected/";
        String osPrefix = ClientOS.getOSPrefix();
        if (osPrefix.equals("Win")) {
            double version = ClientOS.getOSVersion();
            if (version == 7.0) {
                osPrefix = osPrefix + "7";
            } else if (version > 7.0) {
                osPrefix = osPrefix + "8";
            }
        }
        boolean passed = true;
        try {
            for (int p = 0; p < this.panels.length; ++p) {
                Panel wp = this.panels[p];
                char suffix = (char)(97 + p);
                String testPanelName = this.testName + suffix;
                String csvFileName = outputPath + testPanelName + ".csv";
                PrintWriter pw = new PrintWriter(new OutputStreamWriter(new FileOutputStream(csvFileName)));
                wp.dumpDataCSV(pw);
                pw.close();
                String expectedCSVFileName = expectedPath + testPanelName + ".csv";
                boolean same = WaveformTest.compareResults(csvFileName, expectedCSVFileName);
                if (!same) {
                    passed = false;
                    continue;
                }
                String imageFileName = outputPath + testPanelName + ".png";
                Image img = wp.getWaveImage();
                int wid = img.getWidth(null);
                int hei = img.getHeight(null);
                int leftEdge = Math.max(0, wp.getVertAxisPos() - 10);
                BufferedImage bi = new BufferedImage(wid - leftEdge, hei, 1);
                Graphics2D g = bi.createGraphics();
                g.drawImage(img, 0, 0, wid - leftEdge, hei, leftEdge, 0, wid, hei, null);
                PNG.writeImage(bi, imageFileName);
                String expectedImageFileName = expectedPath + testPanelName + osPrefix + ".png";
                same = WaveformTest.compareImages(p + 1, imageFileName, expectedImageFileName);
                if (same) continue;
                passed = false;
            }
        }
        catch (Exception e) {
            System.out.println("Exception: " + e);
            e.printStackTrace();
            passed = false;
        }
        return passed;
    }

    public boolean runWaveformTestBatch() {
        String trueRootPath = this.workingDir();
        String libPath = trueRootPath + "data/libs/";
        String outputPath = trueRootPath + "output/";
        String expectedPath = trueRootPath + "data/expected/";
        boolean passed = true;
        try {
            WaveformTest.ensureOutputDirectory(outputPath);
            MessagesStream.getMessagesStream().save(outputPath + this.testName + ".log");
            String libFileName = libPath + this.testName + ".jelib";
            URL libFileURL = TextUtils.makeURLToFile(libFileName);
            Library lib = Library.findLibrary(this.testName);
            EditingPreferences ep = new EditingPreferences(true, TechPool.getThreadTechPool());
            if (lib == null) {
                lib = LibraryFiles.readLibrary(ep, libFileURL, null, FileType.JELIB, false);
            }
            if (lib == null) {
                System.out.println("WaveformTest.runWaveformTest can't open '" + libFileURL.getFile() + "'");
                return false;
            }
            Cell cell = lib.findNodeProto(this.cellName);
            String waveFile = libPath + this.testName + this.stimuliExtension;
            URL url = TextUtils.makeURLToFile(waveFile);
            String netDelimeter = SimulationTool.getFactorySpiceExtractedNetDelimiter();
            Stimuli stimuli = SimulationData.processInput(cell, url, netDelimeter);
            for (int p = 0; p < this.panelSpecs.length; ++p) {
                String collectionName = this.panelSpecs[p].collectionName;
                SignalCollection sc = null;
                Iterator<SignalCollection> it = stimuli.getSignalCollections();
                while (it.hasNext()) {
                    SignalCollection oneSC = it.next();
                    if (collectionName != null && !collectionName.equals(oneSC.getName())) continue;
                    sc = oneSC;
                    break;
                }
                if (sc == null) {
                    System.out.println("Could not find SignalCollection in waveform data");
                    return false;
                }
                String[] signals = this.panelSpecs[p].signalNames;
                char suffix = (char)(97 + p);
                String testPanelName = this.testName + suffix;
                String csvFileName = outputPath + testPanelName + ".csv";
                PrintWriter pw = new PrintWriter(new OutputStreamWriter(new FileOutputStream(csvFileName)));
                for (int k = 0; k < signals.length; ++k) {
                    Signal<?> as = sc.findSignal(signals[k]);
                    if (as == null) {
                        System.out.println("Could not find Signal '" + signals[k] + "' in waveform data");
                        pw.close();
                        return false;
                    }
                    Signal.View<?> waveform = as.getExactView();
                    int numEvents = waveform.getNumEvents();
                    for (int i = 0; i < numEvents; ++i) {
                        Object samp = waveform.getSample(i);
                        double time = waveform.getTime(i);
                        if (samp instanceof SweptSample) {
                            SweptSample sws = (SweptSample)samp;
                            for (int s2 = 0; s2 < sws.getWidth(); ++s2) {
                                Object ss = sws.getSweep(s2);
                                pw.println("\"" + time + "\",\"" + s2 + "\",\"" + ((ScalarSample)ss).getValue() + "\"");
                            }
                            continue;
                        }
                        ScalarSample ss = (ScalarSample)samp;
                        pw.println("\"" + time + "\",\"" + ss.getValue() + "\"");
                    }
                    pw.println();
                }
                pw.close();
                String expectedCSVFileName = expectedPath + testPanelName + ".csv";
                boolean same = WaveformTest.compareResults(csvFileName, expectedCSVFileName);
                if (same) continue;
                passed = false;
            }
        }
        catch (Exception e) {
            System.out.println("Exception: " + e);
            e.printStackTrace();
            passed = false;
        }
        return passed;
    }

    public static class PanelSpec
    implements Serializable {
        private String[] signalNames;
        private String collectionName;

        public PanelSpec(String colName, String sig1) {
            this.collectionName = colName;
            this.signalNames = new String[]{sig1};
        }

        public PanelSpec(String colName, String sig1, String sig2) {
            this.collectionName = colName;
            this.signalNames = new String[]{sig1, sig2};
        }

        public PanelSpec(String colName, String sig1, String sig2, String sig3) {
            this.collectionName = colName;
            this.signalNames = new String[]{sig1, sig2, sig3};
        }

        public PanelSpec(String colName, String sig1, String sig2, String sig3, String sig4) {
            this.collectionName = colName;
            this.signalNames = new String[]{sig1, sig2, sig3, sig4};
        }
    }
}

