/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.tool.routing.RouteElement;
import com.sun.electric.tool.routing.RouteElementArc;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.util.math.EDimension;
import com.sun.electric.util.math.Orientation;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RouteElementPort
extends RouteElement {
    private NodeProto np;
    private PortProto portProto;
    private EPoint location;
    private Orientation orient;
    private double width;
    private double height;
    private boolean isBisectArcPin;
    private List<RouteElementArc> newArcs;
    private transient Poly portInstSite;
    private RouteElementPort otherREP;
    private NodeInst nodeInst;
    private PortInst portInst;

    private RouteElementPort(RouteElement.RouteElementAction action, Cell cell) {
        super(action, cell);
    }

    public static RouteElementPort newNode(Cell cell, NodeProto np, PortProto newNodePort, Point2D location, double width, double height, Orientation orient, EditingPreferences ep) {
        RouteElementPort e = new RouteElementPort(RouteElement.RouteElementAction.newNode, cell);
        e.np = np;
        e.portProto = newNodePort;
        e.location = EPoint.snap(location);
        e.orient = orient;
        e.isBisectArcPin = false;
        e.newArcs = new ArrayList<RouteElementArc>();
        e.setNodeSize(new EDimension(width, height), ep);
        e.nodeInst = null;
        e.portInst = null;
        e.portInstSite = new Poly(Poly.from(location));
        return e;
    }

    public static RouteElementPort newNodeOtherPort(Cell cell, RouteElementPort rep, PortProto newNodePort, EditingPreferences ep) {
        RouteElementPort e = new RouteElementPort(RouteElement.RouteElementAction.newNode, cell);
        e.np = rep.np;
        e.portProto = newNodePort;
        e.location = EPoint.snap(rep.location);
        e.orient = rep.orient;
        e.isBisectArcPin = false;
        e.newArcs = new ArrayList<RouteElementArc>();
        e.setNodeSize(rep.getNodeSize(), ep);
        e.nodeInst = null;
        e.portInst = null;
        e.portInstSite = new Poly(Poly.from(rep.location));
        e.otherREP = rep;
        rep.otherREP = e;
        return e;
    }

    public static RouteElementPort deleteNode(NodeInst nodeInstToDelete, EditingPreferences ep) {
        RouteElementPort e = new RouteElementPort(RouteElement.RouteElementAction.deleteNode, nodeInstToDelete.getParent());
        e.np = nodeInstToDelete.getProto();
        e.portProto = null;
        e.location = EPoint.snap(nodeInstToDelete.getTrueCenter());
        e.orient = Orientation.IDENT;
        e.isBisectArcPin = false;
        e.newArcs = new ArrayList<RouteElementArc>();
        e.setNodeSize(new EDimension(nodeInstToDelete.getXSizeWithoutOffset(), nodeInstToDelete.getYSizeWithoutOffset()), ep);
        e.nodeInst = nodeInstToDelete;
        e.portInst = null;
        e.portInstSite = null;
        return e;
    }

    public static RouteElementPort existingPortInst(PortInst existingPortInst, EPoint portInstSite, EditingPreferences ep) {
        Poly poly = new Poly(portInstSite);
        return RouteElementPort.existingPortInst(existingPortInst, poly, ep);
    }

    public static RouteElementPort existingPortInst(PortInst existingPortInst, Poly portInstSite, EditingPreferences ep) {
        RouteElementPort e = new RouteElementPort(RouteElement.RouteElementAction.existingPortInst, existingPortInst.getNodeInst().getParent());
        NodeInst nodeInst = existingPortInst.getNodeInst();
        e.np = nodeInst.getProto();
        e.portProto = existingPortInst.getPortProto();
        e.location = EPoint.snap(nodeInst.getTrueCenter());
        e.orient = nodeInst.getOrient();
        e.isBisectArcPin = false;
        e.newArcs = new ArrayList<RouteElementArc>();
        e.setNodeSize(new EDimension(nodeInst.getXSizeWithoutOffset(), nodeInst.getYSizeWithoutOffset()), ep);
        e.nodeInst = nodeInst;
        e.portInst = existingPortInst;
        e.portInstSite = portInstSite;
        return e;
    }

    public NodeProto getNodeProto() {
        return this.np;
    }

    public PortProto getPortProto() {
        return this.portProto;
    }

    public PortInst getPortInst() {
        return this.portInst;
    }

    public NodeInst getNodeInst() {
        return this.nodeInst;
    }

    public Point2D getLocation() {
        return this.location;
    }

    public void setBisectArcPin(boolean state) {
        this.isBisectArcPin = state;
    }

    public boolean isBisectArcPin() {
        return this.isBisectArcPin;
    }

    public void addConnectingNewArc(RouteElementArc re) {
        if (re.getAction() != RouteElement.RouteElementAction.newArc) {
            return;
        }
        this.newArcs.add(re);
    }

    public void removeConnectingNewArc(RouteElementArc re) {
        if (re.getAction() != RouteElement.RouteElementAction.newArc) {
            return;
        }
        this.newArcs.remove(re);
    }

    public double getWidestConnectingArc(ArcProto ap) {
        double width = -1.0;
        if (this.getAction() == RouteElement.RouteElementAction.existingPortInst) {
            Iterator<Connection> it = this.portInst.getConnections();
            while (it.hasNext()) {
                double newWidth;
                Connection conn = it.next();
                ArcInst arc = conn.getArc();
                if (arc.getProto() != ap || !((newWidth = arc.getLambdaBaseWidth()) > width)) continue;
                width = newWidth;
            }
        }
        if (this.getAction() == RouteElement.RouteElementAction.newNode) {
            if (this.newArcs == null) {
                return -1.0;
            }
            for (RouteElementArc re : this.newArcs) {
                if (re.getArcProto() != ap || !(re.getArcBaseWidth() > width)) continue;
                width = re.getArcBaseWidth();
            }
        }
        return width;
    }

    public double getWidestConnectingArc(ArcProto ap, int arcAngle) {
        double width = -1.0;
        if (this.getAction() == RouteElement.RouteElementAction.existingPortInst) {
            Iterator<Connection> it = this.portInst.getConnections();
            while (it.hasNext()) {
                double newWidth;
                Connection conn = it.next();
                ArcInst arc = conn.getArc();
                if (arc.getAngle() != arcAngle || arc.getProto() != ap || !((newWidth = arc.getLambdaBaseWidth()) > width)) continue;
                width = newWidth;
            }
        }
        if (this.getAction() == RouteElement.RouteElementAction.newNode) {
            if (this.newArcs == null) {
                return -1.0;
            }
            for (RouteElementArc re : this.newArcs) {
                if (re.getArcProto() != ap || !(re.getArcBaseWidth() > width)) continue;
                width = re.getArcBaseWidth();
            }
        }
        return width;
    }

    public int getConnectingArcAngle(ArcProto ap) {
        int angle = 0;
        double width = -1.0;
        if (this.getAction() == RouteElement.RouteElementAction.existingPortInst) {
            Iterator<Connection> it = this.portInst.getConnections();
            while (it.hasNext()) {
                double newWidth;
                Connection conn = it.next();
                ArcInst arc = conn.getArc();
                if (arc.getProto() != ap || !((newWidth = arc.getLambdaBaseWidth()) > width)) continue;
                width = newWidth;
                angle = arc.getDefinedAngle() % 1800;
            }
        }
        if (this.getAction() == RouteElement.RouteElementAction.newNode) {
            if (this.newArcs == null) {
                return -1;
            }
            for (RouteElementArc re : this.newArcs) {
                if (re.getArcProto() != ap || !(re.getArcBaseWidth() > width)) continue;
                width = re.getArcBaseWidth();
                if (re.isArcVertical()) {
                    angle = 900;
                }
                if (!re.isArcHorizontal()) continue;
                angle = 0;
            }
        }
        return angle;
    }

    public Iterator<RouteElement> getNewArcs() {
        ArrayList<RouteElementArc> list = new ArrayList<RouteElementArc>();
        list.addAll(this.newArcs);
        return list.iterator();
    }

    public EDimension getNodeSize() {
        return new EDimension(this.width, this.height);
    }

    public void setNodeSize(EDimension size2, EditingPreferences ep) {
        SizeOffset so = this.np.getProtoSizeOffset();
        double widthoffset = so.getLowXOffset() + so.getHighXOffset();
        double heightoffset = so.getLowYOffset() + so.getHighYOffset();
        double defWidth = this.np.getDefWidth(ep) - widthoffset;
        double defHeight = this.np.getDefHeight(ep) - heightoffset;
        this.width = size2.getWidth() > defWidth ? size2.getWidth() : defWidth;
        this.height = size2.getHeight() > defHeight ? size2.getHeight() : defHeight;
    }

    public Poly getConnectingSite() {
        return this.portInstSite;
    }

    public void setConnectingSite(Poly p) {
        this.portInstSite = p;
    }

    @Override
    public ElectricObject doAction(EditingPreferences ep) {
        EDatabase.serverDatabase().checkChanging();
        if (this.isDone()) {
            return null;
        }
        NodeInst returnObj = null;
        if (this.getAction() == RouteElement.RouteElementAction.newNode) {
            if (this.nodeInst == null) {
                SizeOffset so = this.np.getProtoSizeOffset();
                double widthso = this.width + so.getLowXOffset() + so.getHighXOffset();
                double heightso = this.height + so.getLowYOffset() + so.getHighYOffset();
                Point2D.Double loc = new Point2D.Double(this.location.getX(), this.location.getY());
                this.nodeInst = NodeInst.makeInstance(this.np, ep, loc, widthso, heightso, this.getCell(), this.orient, null);
                if (this.nodeInst == null) {
                    return null;
                }
                if (this.otherREP != null) {
                    this.otherREP.nodeInst = this.nodeInst;
                    this.otherREP.portInst = this.nodeInst.findPortInstFromEquivalentProto(this.otherREP.getPortProto());
                }
                this.portInst = this.nodeInst.findPortInstFromEquivalentProto(this.portProto);
            }
            returnObj = this.nodeInst;
        }
        if (this.getAction() == RouteElement.RouteElementAction.deleteNode) {
            this.nodeInst.kill();
        }
        this.setDone();
        return returnObj;
    }

    @Override
    public void addHighlightArea(Highlighter highlighter) {
        if (!this.isShowHighlight()) {
            return;
        }
        if (this.getAction() == RouteElement.RouteElementAction.newNode) {
            PrimitiveNode pnp;
            if (this.np instanceof PrimitiveNode && (pnp = (PrimitiveNode)this.np).isCurvedPin()) {
                EditingPreferences ep = EditingPreferences.getInstance();
                NodeInst ni = NodeInst.makeDummyInstance(pnp, ep, this.location, this.width, this.height, this.orient);
                Poly[] polys = pnp.getTechnology().getShapeOfNode(ni);
                Poly poly = polys[0];
                poly.setStyle(Poly.Type.CLOSED);
                poly.transform(ni.rotateOut());
                highlighter.addPoly(poly, this.getCell(), null);
                return;
            }
            Rectangle2D.Double bounds = new Rectangle2D.Double(this.location.getX() - 0.5 * this.width, this.location.getY() - 0.5 * this.height, this.width, this.height);
            highlighter.addArea(bounds, this.getCell());
        }
        if (this.getAction() == RouteElement.RouteElementAction.existingPortInst) {
            highlighter.addElectricObject(this.portInst, this.getCell());
        }
    }

    @Override
    public String toString() {
        if (this.getAction() == RouteElement.RouteElementAction.newNode) {
            return "RouteElementPort newNode " + (this.otherREP != null ? "(multiple ports) " : "") + this.np + " size " + this.width + "," + this.height + " at " + this.location;
        }
        if (this.getAction() == RouteElement.RouteElementAction.deleteNode) {
            return "RouteElementPort deleteNode " + this.nodeInst + " at (" + this.nodeInst.getAnchorCenterX() + "," + this.nodeInst.getAnchorCenterY() + ")";
        }
        if (this.getAction() == RouteElement.RouteElementAction.existingPortInst) {
            return "RouteElementPort existingPortInst " + this.portInst;
        }
        return "RouteElement bad action";
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        if (this.portInstSite != null) {
            PolyBase.Point[] points = this.portInstSite.getPoints();
            s2.writeInt(points.length);
            for (int i = 0; i < points.length; ++i) {
                s2.writeDouble(((Point2D)points[i]).getX());
                s2.writeDouble(((Point2D)points[i]).getY());
            }
        } else {
            s2.writeInt(-1);
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        int len = s2.readInt();
        if (len >= 0) {
            Point2D[] points = new Point2D[len];
            for (int i = 0; i < len; ++i) {
                double x = s2.readDouble();
                double y = s2.readDouble();
                points[i] = new Point2D.Double(x, y);
            }
        }
    }
}

