/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.GDSLayers;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.output.Geometry;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.tool.ncc.basic.NccCellAnnotations;
import com.sun.electric.tool.user.ui.LayerVisibility;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.FixpRectangle;
import com.sun.electric.util.math.FixpTransform;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class GDS
extends Geometry {
    private static final boolean NEWUNITS = true;
    public static final Variable.Key GDS_TEXT_HV_KEY = Variable.newKey("ATTR_GDS_text_HV");
    public static final Variable.Key GDS_TEXT_KEY = Variable.newKey("ATTR_GDS_text");
    public static final Variable.Key OLD_HIGH_VOLTAGE_KEY = Variable.newKey("ATTR_high_voltage");
    public static final Variable.Key OLD_GDS_TEXT_KEY = Variable.newKey("GDS_text");
    private static final int GDSVERSION = 3;
    private static final int BYTEMASK = 255;
    private static final int DSIZE = 512;
    private static final int EXPORTPRESENTATION = 0;
    private static final int STRANS_REFLX = 32768;
    private static final int DTYP_NONE = 0;
    private static final short HDR_HEADER = 2;
    private static final short HDR_BGNLIB = 258;
    private static final short HDR_LIBNAME = 518;
    private static final short HDR_UNITS = 773;
    private static final short HDR_ENDLIB = 1024;
    private static final short HDR_BGNSTR = 1282;
    private static final short HDR_STRNAME = 1542;
    private static final short HDR_ENDSTR = 1792;
    private static final short HDR_BOUNDARY = 2048;
    private static final short HDR_PATH = 2304;
    private static final short HDR_SREF = 2560;
    private static final short HDR_TEXT = 3072;
    private static final short HDR_LAYER = 3330;
    private static final short HDR_DATATYPE = 3586;
    private static final short HDR_XY = 4099;
    private static final short HDR_ENDEL = 4352;
    private static final short HDR_SNAME = 4614;
    private static final short HDR_TEXTTYPE = 5634;
    private static final short HDR_PRESENTATION = 5889;
    private static final short HDR_STRING = 6406;
    private static final short HDR_STRANS = 6657;
    private static final short HDR_MAG = 6917;
    private static final short HDR_ANGLE = 7173;
    private static final short HDR_PROPATTR = 11010;
    private static final short HDR_PROPVALUE = 11270;
    private static final short HDR_N_BGNLIB = 28;
    private static final short HDR_N_UNITS = 20;
    private static final short HDR_N_ANGLE = 12;
    private static final short HDR_N_MAG = 12;
    private static final int HDR_M_ASCII = 256;
    private static byte[] dataBufferGDS = new byte[512];
    private static byte[] emptyBuffer = new byte[512];
    private static GDSLayers currentLayerNumbers;
    private static int bufferPosition;
    private static int blockCount;
    private double scaleFactor;
    private int inaccurate;
    private Map<Cell, String> cellNames;
    private Set<Cell> writtenCells;
    private Set<String> writtenCellNames;
    private Map<Layer, GDSLayers> layerNumbers;
    public static final String concatStr = ".";
    private Map<String, Set<String>> nameRemapping;
    private GDSPreferences localPrefs;

    private GDS(GDSPreferences gp) {
        this.localPrefs = gp;
    }

    @Override
    protected void start() {
        this.initOutput();
        this.outputBeginLibrary(this.topCell);
    }

    @Override
    protected void done() {
        if (this.inaccurate > 0) {
            String msg = "WARNING: GDS Export encountered problems because of small feature sizes and coarse accuracy settings.";
            msg = msg + " It is recommended that the 'Units/meter' GDS preference be increased by a factor of " + this.inaccurate;
            Job.getUserInterface().showInformationMessage(msg, "Potential GDS Export Problem");
        }
    }

    @Override
    protected void writeCellGeom(Geometry.CellGeom cellGeom) {
        NodeInst ni;
        Iterator<Object> it;
        boolean colapseGndVddNames;
        Variable var;
        Cell cell = cellGeom.cell;
        if (cell.getView() == View.LAYOUTSKEL && (var = cell.getVar(com.sun.electric.tool.io.input.GDS.SKELETON_ORIGIN)) != null) {
            String fileName = (String)var.getObject();
            File fullGDSFile = new File(fileName);
            if (fullGDSFile.exists()) {
                this.emitFullGDS(cell, fileName);
                return;
            }
            System.out.println("Warning: Original GDS for cell " + cell.describe(false) + " (file " + fileName + ") is missing...using cell contents");
        }
        this.writtenCells.add(cell);
        if (this.outputBeginStruct(cell)) {
            return;
        }
        boolean renamePins = cell == this.topCell && this.localPrefs.convertNCCExportsConnectedByParentPins;
        boolean bl = colapseGndVddNames = cell == this.topCell && this.localPrefs.collapseVddGndPinNames;
        if (renamePins) {
            NccCellAnnotations annotations = NccCellAnnotations.getAnnotations(cell);
            if (annotations == null) {
                renamePins = false;
            } else {
                this.nameRemapping = this.createExportNameMap(annotations, cell);
            }
        }
        Set<Layer> layers = cellGeom.polyMap.keySet();
        for (Layer layer : layers) {
            if (this.skipLayer(layer, false)) continue;
            if (!this.selectLayer(layer)) {
                System.out.println("Skipping " + layer + " in GDS output");
                continue;
            }
            List<Object> polyList = cellGeom.polyMap.get(layer);
            for (Object obj : polyList) {
                PolyBase poly = (PolyBase)obj;
                int layerNum = currentLayerNumbers.getLayerNumber(GDSLayers.GDSLayerType.DRAWING);
                int layerType = currentLayerNumbers.getLayerType(GDSLayers.GDSLayerType.DRAWING);
                this.writePoly(poly, layerNum, layerType);
            }
        }
        for (Nodable no : cellGeom.nodables) {
            this.writeNodable(no);
        }
        if (this.localPrefs.outDefaultTextLayer >= 0 && this.localPrefs.writeExportPins) {
            it = cell.getPorts();
            while (it.hasNext()) {
                String tmp;
                Set<String> nameSet;
                Export pp = (Export)it.next();
                Poly portPoly = pp.getPoly();
                String portName = pp.getName();
                if (renamePins && (nameSet = this.nameRemapping.get(portName)) != null) {
                    portName = nameSet.iterator().next();
                    portName = portName + ":" + portName;
                }
                if (this.localPrefs.convertBracketsInExports) {
                    portName = portName.replaceAll("[\\[\\]]", "_");
                }
                if (colapseGndVddNames && ((tmp = portName.toLowerCase()).startsWith("vdd_") || tmp.startsWith("gnd_")) && TextUtils.isANumber(tmp.substring(4))) {
                    portName = portName.substring(0, portName.indexOf("_"));
                }
                for (ArcProto ap : pp.getBasePort().getConnections()) {
                    for (Technology.ArcLayer al : ap.getArcLayers()) {
                        Layer layer = al.getLayer();
                        if (this.skipLayer(layer, false)) continue;
                        this.selectLayer(layer);
                        this.writeExport(pp, portName, portPoly.getCenterX(), portPoly.getCenterY());
                    }
                }
            }
        }
        if (this.localPrefs.includeText) {
            it = cell.getNodes();
            while (it.hasNext()) {
                PrimitiveNode pNp;
                Technology.NodeLayer[] nLay;
                Layer layer;
                ni = (NodeInst)it.next();
                if (!this.isTextNode(ni) || this.skipLayer(layer = (nLay = (pNp = (PrimitiveNode)ni.getProto()).getNodeLayers())[0].getLayer(), true)) continue;
                int layerNum = -1;
                int layerType = -1;
                if (!this.selectLayer(layer)) {
                    if (this.localPrefs.outDefaultTextLayer == 0) {
                        System.out.println("Skipping " + layer + " in GDS output");
                        continue;
                    }
                    layerNum = this.localPrefs.outDefaultTextLayer;
                    layerType = 0;
                } else if (currentLayerNumbers.hasLayerType(GDSLayers.GDSLayerType.TEXT)) {
                    layerNum = currentLayerNumbers.getLayerNumber(GDSLayers.GDSLayerType.TEXT);
                    layerType = currentLayerNumbers.getLayerType(GDSLayers.GDSLayerType.TEXT);
                    System.out.println("Using real text type! for layer '" + layer.getName() + "'");
                } else {
                    layerNum = currentLayerNumbers.getLayerNumber(GDSLayers.GDSLayerType.DRAWING);
                    layerType = currentLayerNumbers.getLayerType(GDSLayers.GDSLayerType.DRAWING);
                }
                Variable var2 = ni.getVar(Artwork.ART_MESSAGE);
                String name = ni.getName();
                if (var2 != null) {
                    Object obj = var2.getObject();
                    name = obj.toString();
                }
                this.writeTextOnLayer(name, layerNum, layerType, ni.getAnchorCenterX(), ni.getAnchorCenterY(), renamePins, colapseGndVddNames);
            }
        }
        it = cell.getNodes();
        while (it.hasNext()) {
            ni = (NodeInst)it.next();
            this.writeSpecialText(ni, ni.getAnchorCenterX(), ni.getAnchorCenterY(), GDS_TEXT_HV_KEY, OLD_HIGH_VOLTAGE_KEY, GDSLayers.GDSLayerType.HIGHVOLTAGE);
            this.writeSpecialText(ni, ni.getAnchorCenterX(), ni.getAnchorCenterY(), GDS_TEXT_KEY, OLD_GDS_TEXT_KEY, GDSLayers.GDSLayerType.TEXT);
        }
        it = cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            this.writeSpecialText(ai, ai.getTrueCenterX(), ai.getTrueCenterY(), GDS_TEXT_HV_KEY, OLD_HIGH_VOLTAGE_KEY, GDSLayers.GDSLayerType.HIGHVOLTAGE);
            this.writeSpecialText(ai, ai.getTrueCenterX(), ai.getTrueCenterY(), GDS_TEXT_KEY, OLD_GDS_TEXT_KEY, GDSLayers.GDSLayerType.TEXT);
        }
        this.outputHeader((short)1792, 0);
    }

    private void writeSpecialText(Geometric geom, double x, double y, Variable.Key key, Variable.Key keyOld, GDSLayers.GDSLayerType type) {
        Variable var = geom.getVar(key);
        if (var == null) {
            var = geom.getVar(keyOld);
        }
        if (var != null) {
            Object[] nLay;
            ArrayList<Layer> layers = new ArrayList<Layer>();
            if (geom instanceof NodeInst) {
                PrimitiveNode pNp = (PrimitiveNode)((NodeInst)geom).getProto();
                for (Object nl : nLay = pNp.getNodeLayers()) {
                    layers.add(((Technology.NodeLayer)nl).getLayer());
                }
            } else {
                ArcProto ap = ((ArcInst)geom).getProto();
                for (Object nl : nLay = ap.getArcLayers()) {
                    layers.add(((Technology.ArcLayer)nl).getLayer());
                }
            }
            for (Layer layer : layers) {
                if (this.skipLayer(layer, false)) continue;
                if (!this.selectLayer(layer)) {
                    System.out.println("Skipping " + layer + " in GDS output");
                    continue;
                }
                int layerNum = -1;
                int layerType = -1;
                if (!currentLayerNumbers.hasLayerType(type)) {
                    System.out.println("Skipping voltage variable " + layer + " in GDS output");
                    continue;
                }
                layerNum = currentLayerNumbers.getLayerNumber(type);
                layerType = currentLayerNumbers.getLayerType(type);
                this.writeTextOnLayer(var.getPureValue(0), layerNum, layerType, x, y, false, false);
            }
        }
    }

    private void writeRecursively(Cell cell, FixpTransform trans, Set<String> exportsUsed) {
        Iterator<Geometric> it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            FixpTransform subRot = ni.rotateOut();
            subRot.preConcatenate(trans);
            if (ni.isCellInstance()) {
                Cell subCell = (Cell)ni.getProto();
                FixpTransform subTrans = ni.translateOut();
                subTrans.preConcatenate(subRot);
                this.writeRecursively(subCell, subTrans, exportsUsed);
                continue;
            }
            Technology tech = ni.getProto().getTechnology();
            Poly[] polys = tech.getShapeOfNode(ni);
            for (int i = 0; i < polys.length; ++i) {
                Poly poly = polys[i];
                poly.transform(subRot);
                Layer layer = poly.getLayer();
                if (this.skipLayer(layer, false) || !this.selectLayer(layer)) continue;
                int layerNum = currentLayerNumbers.getLayerNumber(GDSLayers.GDSLayerType.DRAWING);
                int layerType = currentLayerNumbers.getLayerType(GDSLayers.GDSLayerType.DRAWING);
                this.writePoly(poly, layerNum, layerType);
            }
            Point2D.Double pt = new Point2D.Double(0.0, 0.0);
            trans.transform(ni.getAnchorCenter(), pt);
            this.writeSpecialText(ni, ((Point2D)pt).getX(), ((Point2D)pt).getY(), GDS_TEXT_HV_KEY, OLD_HIGH_VOLTAGE_KEY, GDSLayers.GDSLayerType.HIGHVOLTAGE);
            this.writeSpecialText(ni, ((Point2D)pt).getX(), ((Point2D)pt).getY(), GDS_TEXT_KEY, OLD_GDS_TEXT_KEY, GDSLayers.GDSLayerType.TEXT);
        }
        it = cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            Technology tech = ai.getProto().getTechnology();
            Poly[] polys = tech.getShapeOfArc(ai);
            for (int i = 0; i < polys.length; ++i) {
                Poly poly = polys[i];
                poly.transform(trans);
                Layer layer = poly.getLayer();
                if (this.skipLayer(layer, false) || !this.selectLayer(layer)) continue;
                int layerNum = currentLayerNumbers.getLayerNumber(GDSLayers.GDSLayerType.DRAWING);
                int layerType = currentLayerNumbers.getLayerType(GDSLayers.GDSLayerType.DRAWING);
                this.writePoly(poly, layerNum, layerType);
            }
            Point2D.Double pt = new Point2D.Double(0.0, 0.0);
            trans.transform(ai.getTrueCenter(), pt);
            this.writeSpecialText(ai, ((Point2D)pt).getX(), ((Point2D)pt).getY(), GDS_TEXT_HV_KEY, OLD_HIGH_VOLTAGE_KEY, GDSLayers.GDSLayerType.HIGHVOLTAGE);
            this.writeSpecialText(ai, ((Point2D)pt).getX(), ((Point2D)pt).getY(), GDS_TEXT_KEY, OLD_GDS_TEXT_KEY, GDSLayers.GDSLayerType.TEXT);
        }
        if (this.localPrefs.outDefaultTextLayer >= 0 && this.localPrefs.writeExportPins) {
            Iterator<Export> eIt = cell.getExports();
            while (eIt.hasNext()) {
                Export pp = eIt.next();
                Poly portPoly = pp.getPoly();
                portPoly.transform(trans);
                String portName = pp.getName();
                if (this.localPrefs.convertBracketsInExports) {
                    portName = portName.replaceAll("[\\[\\]]", "_");
                }
                int suffixNumber = 0;
                String fullPortName = portName;
                while (true) {
                    if (suffixNumber != 0) {
                        fullPortName = portName + "_" + suffixNumber;
                    }
                    if (!exportsUsed.contains(fullPortName)) break;
                    ++suffixNumber;
                }
                exportsUsed.add(fullPortName);
                for (ArcProto ap : pp.getBasePort().getConnections()) {
                    for (Technology.ArcLayer al : ap.getArcLayers()) {
                        Layer layer = al.getLayer();
                        if (this.skipLayer(layer, false)) continue;
                        this.selectLayer(layer);
                        this.writeExport(pp, fullPortName, portPoly.getCenterX(), portPoly.getCenterY());
                    }
                }
            }
        }
    }

    private boolean skipLayer(Layer layer, boolean allowGeneric) {
        if (layer == null || layer.getTechnology() == null || layer.getTechnology() == Generic.tech() && !allowGeneric || layer.getTechnology() == Artwork.tech()) {
            return true;
        }
        if (!this.localPrefs.onlyVisibleLayers || this.localPrefs.visibility == null) {
            return false;
        }
        return !this.localPrefs.visibility[layer.getIndex()];
    }

    /*
     * Exception decompiling
     */
    private void emitFullGDS(Cell cell, String fullGDSFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[UNCONDITIONALDOLOOP]], but top level block is 10[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isTextNode(NodeInst ni) {
        if (!(ni.getProto() instanceof PrimitiveNode)) {
            return false;
        }
        if (ni.getXSize() != 0.0 || ni.getYSize() != 0.0) {
            return false;
        }
        if (!ni.getNameKey().isTempname()) {
            return false;
        }
        return ni.getProto() == Generic.tech().invisiblePinNode;
    }

    private Map<String, Set<String>> createExportNameMap(NccCellAnnotations ann, Cell cell) {
        HashMap<String, Set<String>> nameMap = new HashMap<String, Set<String>>();
        Iterator<List<NccCellAnnotations.NamePattern>> it2 = ann.getExportsConnected();
        while (it2.hasNext()) {
            List<NccCellAnnotations.NamePattern> list = it2.next();
            TreeSet<String> connectedExports = new TreeSet<String>(new StringComparator());
            for (NccCellAnnotations.NamePattern pat : list) {
                String name;
                Iterator<Object> it = cell.getPorts();
                while (it.hasNext()) {
                    Export e = (Export)it.next();
                    name = e.getName();
                    if (!pat.matches(name)) continue;
                    connectedExports.add(name);
                    nameMap.put(name, connectedExports);
                }
                it = cell.getNodes();
                while (it.hasNext()) {
                    NodeInst ni = (NodeInst)it.next();
                    if (!this.isTextNode(ni) || !pat.matches(name = ni.getName())) continue;
                    connectedExports.add(name);
                    nameMap.put(name, connectedExports);
                }
            }
        }
        return nameMap;
    }

    private void writeExport(Export pp, String portName, double x, double y) {
        int layer = this.localPrefs.outDefaultTextLayer;
        int type = 0;
        if (currentLayerNumbers.hasLayerType(GDSLayers.GDSLayerType.PIN)) {
            layer = currentLayerNumbers.getLayerNumber(GDSLayers.GDSLayerType.PIN);
            type = currentLayerNumbers.getLayerType(GDSLayers.GDSLayerType.PIN);
        }
        this.outputHeader((short)3072, 0);
        this.outputHeader((short)3330, layer);
        this.outputHeader((short)5634, type);
        this.outputHeader((short)5889, 0);
        NodeInst ni = pp.getOriginalPort().getNodeInst();
        int transValue = 0;
        int angle = ni.getAngle();
        if (ni.isXMirrored() != ni.isYMirrored()) {
            transValue |= 0x8000;
        }
        if (ni.isYMirrored()) {
            angle = (3600 - angle) % 3600;
        }
        if (ni.isXMirrored()) {
            angle = (1800 - angle + 3600) % 3600;
        }
        this.outputHeader((short)6657, transValue);
        this.outputMag(0.5);
        this.outputAngle(angle);
        this.outputShort((short)12);
        this.outputShort((short)4099);
        this.outputInt(this.scaleDBUnit(x));
        this.outputInt(this.scaleDBUnit(y));
        this.outputString(portName, (short)6406);
        this.outputHeader((short)4352, 0);
        if (this.localPrefs.writeExportCharacteristics) {
            this.outputHeader((short)11010, 1);
            String charString = "TBLR " + portName + " " + portName + " ";
            charString = pp.getCharacteristic() == PortCharacteristic.IN ? charString + "input" : (pp.getCharacteristic() == PortCharacteristic.OUT ? charString + "output" : (pp.getCharacteristic() == PortCharacteristic.BIDIR ? charString + "inputOutput" : charString + "unknown"));
            this.outputString(charString, (short)11270);
            this.outputHeader((short)4352, 0);
        }
    }

    private void writeTextOnLayer(String str, int layer, int type, double x, double y, boolean remapNames, boolean colapseGndVddNames) {
        String tmp;
        Set<String> nameSet;
        this.outputHeader((short)3072, 0);
        this.outputHeader((short)3330, layer);
        this.outputHeader((short)5634, type);
        this.outputHeader((short)5889, 0);
        int transValue = 0;
        this.outputHeader((short)6657, transValue);
        this.outputMag(0.5);
        this.outputAngle(0);
        this.outputShort((short)12);
        this.outputShort((short)4099);
        this.outputInt(this.scaleDBUnit(x));
        this.outputInt(this.scaleDBUnit(y));
        if (remapNames && (nameSet = this.nameRemapping.get(str)) != null) {
            str = nameSet.iterator().next();
            str = str + ":" + str;
        }
        if (this.localPrefs.convertBracketsInExports) {
            str = str.replaceAll("[\\[\\]]", "_");
        }
        if (colapseGndVddNames && ((tmp = str.toLowerCase()).startsWith("vdd_") || tmp.startsWith("gnd_")) && TextUtils.isANumber(tmp.substring(4))) {
            str = str.substring(0, str.indexOf("_"));
        }
        this.outputString(str, (short)6406);
        this.outputHeader((short)4352, 0);
    }

    @Override
    protected boolean mergeGeom(int hierLevelsFromBottom) {
        return this.localPrefs.outMergesBoxes;
    }

    @Override
    protected boolean includeGeometric() {
        return false;
    }

    private boolean selectLayer(Layer layer) {
        GDSLayers numbers = this.layerNumbers.get(layer);
        if (numbers == null) {
            Technology tech = layer.getTechnology();
            Iterator<Layer> it = tech.getLayers();
            while (it.hasNext()) {
                Layer l = it.next();
                this.layerNumbers.put(l, GDSLayers.EMPTY);
            }
            for (Map.Entry<Layer, String> e : tech.getGDSLayers().entrySet()) {
                Layer l = e.getKey();
                String gdsLayer = e.getValue();
                this.layerNumbers.put(l, GDSLayers.parseLayerString(gdsLayer));
            }
            numbers = this.layerNumbers.get(layer);
        }
        if (numbers == null) {
            numbers = GDSLayers.EMPTY;
        }
        currentLayerNumbers = numbers;
        return numbers.hasLayerType(GDSLayers.GDSLayerType.DRAWING);
    }

    protected void writePoly(PolyBase poly, int layerNumber, int layerType) {
        if (layerNumber < 0) {
            return;
        }
        PolyBase.Point[] points = poly.getPoints();
        if (poly.getStyle() == Poly.Type.DISC) {
            double r = ((Point2D)points[0]).distance(points[1]);
            if (r <= 0.0) {
                return;
            }
            Poly newPoly = new Poly(((Point2D)points[0]).getX(), ((Point2D)points[0]).getY(), r * 2.0, r * 2.0);
            this.outputBoundary(newPoly, layerNumber, layerType);
            return;
        }
        FixpRectangle polyBounds = poly.getBox();
        if (polyBounds != null) {
            if (((RectangularShape)polyBounds).getWidth() == 0.0 || ((RectangularShape)polyBounds).getHeight() == 0.0) {
                return;
            }
            this.outputBoundary(poly, layerNumber, layerType);
            return;
        }
        if (points.length == 1) {
            this.reportWarning("WARNING: Single point cannot be written in GDS-II");
            return;
        }
        if (points.length > 200) {
            this.reportWarning("WARNING: GDS-II Polygons may not have more than 200 points (this has " + points.length + ")");
            return;
        }
        if (points.length == 2) {
            this.outputPath(poly, layerNumber, layerType);
        } else {
            this.outputBoundary(poly, layerNumber, layerType);
        }
    }

    protected void writeNodable(Nodable no) {
        String name;
        NodeInst ni = (NodeInst)no;
        Cell subCell = (Cell)ni.getProto();
        int transValue = 0;
        int angle = ni.getAngle();
        if (ni.isXMirrored() != ni.isYMirrored()) {
            transValue |= 0x8000;
        }
        if (ni.isYMirrored()) {
            angle = (3600 - angle) % 3600;
        }
        if (ni.isXMirrored()) {
            angle = (1800 - angle + 3600) % 3600;
        }
        if ((name = this.cellNames.get(subCell)) == null && subCell.getView() == View.LAYOUTSKEL) {
            name = subCell.getName();
        }
        if (name == null) {
            return;
        }
        this.outputHeader((short)2560, 0);
        this.outputName((short)4614, name, this.localPrefs.cellNameLenMax);
        this.outputHeader((short)6657, transValue);
        this.outputAngle(angle);
        this.outputShort((short)12);
        this.outputShort((short)4099);
        this.outputInt(this.scaleDBUnit(ni.getAnchorCenterX()));
        this.outputInt(this.scaleDBUnit(ni.getAnchorCenterY()));
        this.outputHeader((short)4352, 0);
    }

    private BloatVisitor makeBloatVisitor(int maxDepth) {
        BloatVisitor visitor = new BloatVisitor((Geometry)this, maxDepth);
        return visitor;
    }

    private void initOutput() {
        blockCount = 0;
        bufferPosition = 0;
        for (int i = 0; i < 512; ++i) {
            GDS.emptyBuffer[i] = 0;
        }
        Technology tech = this.topCell.getTechnology();
        this.scaleFactor = tech.getScale() * this.localPrefs.unitsPerMeter / 1.0E9;
        this.inaccurate = 0;
        this.layerNumbers = new HashMap<Layer, GDSLayers>();
        this.nameRemapping = new HashMap<String, Set<String>>();
        boolean foundValid = false;
        Iterator<Comparable> it = tech.getLayers();
        while (it.hasNext()) {
            Layer layer = it.next();
            if (!this.selectLayer(layer)) continue;
            foundValid = true;
        }
        if (!foundValid) {
            this.reportWarning("Warning: there are no GDS II layers defined for the " + tech.getTechName() + " technology");
        }
        this.cellNames = new HashMap<Cell, String>();
        GDS.buildUniqueNames(this.topCell, this.cellNames, this.localPrefs.cellNameLenMax, this.localPrefs.outUpperCase);
        if (this.localPrefs.writeAllCells) {
            it = this.topCell.getLibrary().getCells();
            while (it.hasNext()) {
                Cell c = (Cell)it.next();
                if (c.getView() == View.ICON || c.getView() == View.SCHEMATIC || c.getView().isTextView() || this.cellNames.containsKey(c)) continue;
                GDS.buildUniqueNames(c, this.cellNames, this.localPrefs.cellNameLenMax, this.localPrefs.outUpperCase);
            }
        }
    }

    public static void buildUniqueNames(Cell cell, Map<Cell, String> cellNames, int maxLen, boolean upperCase) {
        if (!cellNames.containsKey(cell)) {
            cellNames.put(cell, GDS.makeUniqueName(cell, cellNames, maxLen, upperCase));
        }
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            if (!ni.isCellInstance()) continue;
            Cell c = (Cell)ni.getProto();
            Cell cproto = c.contentsView();
            if (cproto == null) {
                cproto = c;
            }
            if (!cellNames.containsKey(cproto)) {
                cellNames.put(cproto, GDS.makeUniqueName(cproto, cellNames, maxLen, upperCase));
            }
            if (ni.isIconOfParent()) continue;
            GDS.buildUniqueNames(cproto, cellNames, maxLen, upperCase);
        }
    }

    public static String makeUniqueName(Cell cell, Map<Cell, String> cellNames, int maxLen, boolean upperCase) {
        int liblen;
        String name = GDS.makeGDSName(cell.getName(), maxLen, upperCase);
        if (cell.getNewestVersion() != cell) {
            name = name + "_" + cell.getVersion();
        }
        String baseName = name;
        Collection<String> existing = cellNames.values();
        if (existing.contains(name) && (liblen = maxLen - (name.length() + concatStr.length())) > 0) {
            String lib;
            String libname = lib.substring(0, liblen = liblen > (lib = cell.getLibrary().getName()).length() ? lib.length() : liblen) + concatStr + name;
            if (!existing.contains(libname)) {
                System.out.println("Warning: GDSII out renaming cell " + cell.describe(false) + " to " + libname);
                return libname;
            }
            baseName = libname;
        }
        int index = 1;
        while (existing.contains(name)) {
            name = baseName + "_" + index;
            int extra = name.length() - maxLen;
            if (extra > 0) {
                name = baseName.substring(0, baseName.length() - extra);
                name = name + "_" + index;
            }
            ++index;
        }
        if (!name.equals(cell.getName())) {
            System.out.println("Warning: GDSII out renaming cell " + cell.describe(false) + " to " + name);
        }
        return name;
    }

    private static String makeGDSName(String str, int maxLen, boolean upperCase) {
        StringBuffer ret = new StringBuffer();
        int max2 = str.length();
        if (max2 > maxLen - 3) {
            max2 = maxLen - 3;
        }
        for (int k = 0; k < max2; ++k) {
            int ch = str.charAt(k);
            if (upperCase) {
                ch = Character.toUpperCase((char)ch);
            }
            if (ch != 36 && !TextUtils.isDigit((char)ch) && ch != 63 && !Character.isLetter((char)ch)) {
                ch = 95;
            }
            ret.append((char)ch);
        }
        return ret.toString();
    }

    public Map<Cell, String> getCellNames() {
        return this.cellNames;
    }

    private void doneWritingOutput() {
        try {
            if (bufferPosition > 0) {
                for (int i = bufferPosition; i < 512; ++i) {
                    GDS.dataBufferGDS[i] = 0;
                }
                this.dataOutputStream.write(dataBufferGDS, 0, 512);
                ++blockCount;
            }
            while (blockCount % 4 != 0) {
                this.dataOutputStream.write(emptyBuffer, 0, 512);
                ++blockCount;
            }
        }
        catch (IOException e) {
            this.reportError("End of file reached while finishing GDS");
        }
    }

    private void outputBeginLibrary(Cell cell) {
        this.outputHeader((short)2, 3);
        this.outputHeader((short)258, 0);
        this.outputDate(cell.getCreationDate());
        this.outputDate(cell.getRevisionDate());
        this.outputName((short)518, GDS.makeGDSName(cell.getName(), 256, this.localPrefs.outUpperCase), 256);
        this.outputShort((short)20);
        this.outputShort((short)773);
        double userUnitsPerDBUnit = 1.0 / this.localPrefs.precision;
        double dbUnitsInMeters = 1.0 / this.localPrefs.unitsPerMeter;
        this.outputDouble(userUnitsPerDBUnit);
        this.outputDouble(dbUnitsInMeters);
    }

    boolean outputBeginStruct(Cell cell) {
        String name = this.cellNames.get(cell);
        if (name == null) {
            this.reportWarning("Warning, sub" + cell + " in hierarchy is not the same view" + " as top level cell");
            name = GDS.makeUniqueName(cell, this.cellNames, this.localPrefs.cellNameLenMax, this.localPrefs.outUpperCase);
            this.cellNames.put(cell, name);
        }
        if (this.writtenCellNames.contains(name)) {
            System.out.println("Ignoring cell " + cell.describe(false) + " because it is already included in GDS file");
            return true;
        }
        this.writtenCellNames.add(name);
        this.outputHeader((short)1282, 0);
        this.outputDate(cell.getCreationDate());
        this.outputDate(cell.getRevisionDate());
        this.outputName((short)1542, name, this.localPrefs.cellNameLenMax);
        return false;
    }

    private void outputDate(Date val) {
        short[] date = new short[6];
        Calendar cal = Calendar.getInstance();
        cal.setTime(val);
        int year = cal.get(1) - 1900;
        date[0] = (short)year;
        date[1] = (short)cal.get(2);
        date[2] = (short)cal.get(5);
        date[3] = (short)cal.get(10);
        date[4] = (short)cal.get(12);
        date[5] = (short)cal.get(13);
        this.outputShortArray(date, 6);
    }

    private void outputHeader(short header, int p1) {
        int type = header & 0xFF;
        int count2 = 4;
        if (type != 0) {
            switch (header) {
                case 2: 
                case 3330: 
                case 3586: 
                case 5634: 
                case 5889: 
                case 6657: 
                case 11010: {
                    count2 = 6;
                    break;
                }
                case 258: 
                case 1282: {
                    count2 = 28;
                    break;
                }
                case 773: {
                    count2 = 20;
                    break;
                }
                default: {
                    this.reportError("No entry for header " + header);
                    return;
                }
            }
        }
        this.outputShort((short)count2);
        this.outputShort(header);
        if (type == 0) {
            return;
        }
        if (count2 == 6) {
            this.outputShort((short)p1);
        }
        if (count2 == 8) {
            this.outputInt(p1);
        }
    }

    private void outputName(short header, String p1, int max2) {
        this.outputString(p1, header, max2);
    }

    private void outputAngle(int ang) {
        double gdfloat = (double)ang / 10.0;
        this.outputShort((short)12);
        this.outputShort((short)7173);
        this.outputDouble(gdfloat);
    }

    private void outputMag(double scale) {
        this.outputShort((short)12);
        this.outputShort((short)6917);
        this.outputDouble(scale);
    }

    private List<Point> reducePolygon(PolyBase poly) {
        ArrayList<Point> pts = new ArrayList<Point>();
        PolyBase.Point[] points = poly.getPoints();
        int lastX = this.scaleDBUnit(((Point2D)points[0]).getX());
        int lastY = this.scaleDBUnit(((Point2D)points[0]).getY());
        int firstX = lastX;
        int firstY = lastY;
        pts.add(new Point(lastX, lastY));
        for (int i = 1; i < points.length; ++i) {
            int x = this.scaleDBUnit(((Point2D)points[i]).getX());
            int y = this.scaleDBUnit(((Point2D)points[i]).getY());
            if (x == lastX && y == lastY) continue;
            lastX = x;
            lastY = y;
            pts.add(new Point(lastX, lastY));
        }
        if (pts.size() > 2) {
            Point endPoint = (Point)pts.get(pts.size() - 1);
            if (firstX == endPoint.x && firstY == endPoint.y) {
                pts.remove(pts.size() - 1);
            }
        }
        return pts;
    }

    private void outputBoundary(PolyBase poly, int layerNumber, int layerType) {
        List<Point> reducedPoints = this.reducePolygon(poly);
        int count2 = reducedPoints.size();
        if (count2 <= 2) {
            return;
        }
        int start = 0;
        HashMap<String, ArrayList<Integer>> polyMap = new HashMap<String, ArrayList<Integer>>();
        for (int i = 0; i < count2; ++i) {
            Point pt = reducedPoints.get(i);
            String polyKey = pt.x + "x" + pt.y;
            ArrayList<Integer> coordIndices = (ArrayList<Integer>)polyMap.get(polyKey);
            if (coordIndices == null) {
                coordIndices = new ArrayList<Integer>();
                polyMap.put(polyKey, coordIndices);
            }
            coordIndices.add(i);
        }
        List firstPair = null;
        List secondPair = null;
        for (String polyKey : polyMap.keySet()) {
            List pairs = (List)polyMap.get(polyKey);
            if (pairs.size() < 2) continue;
            if (pairs.size() > 2) {
                secondPair = null;
                firstPair = null;
                break;
            }
            if (pairs.contains(0) && pairs.contains(count2 - 1)) continue;
            if (firstPair == null) {
                firstPair = pairs;
                continue;
            }
            if (secondPair == null) {
                secondPair = pairs;
                continue;
            }
            secondPair = null;
            firstPair = null;
            break;
        }
        boolean polyWithHole = false;
        if (firstPair != null && secondPair != null) {
            int index1A = (Integer)firstPair.get(0);
            int index1B = (Integer)firstPair.get(1);
            int index2A = (Integer)secondPair.get(0);
            int index2B = (Integer)secondPair.get(1);
            if (this.nextTo(index1A, index2A, count2) && this.nextTo(index1B, index2B, count2)) {
                polyWithHole = true;
            } else if (this.nextTo(index1A, index2B, count2) && this.nextTo(index1B, index2A, count2)) {
                polyWithHole = true;
            }
        }
        while (true) {
            int sofar;
            if (polyWithHole) {
                sofar = count2;
            } else {
                for (sofar = start + 1; sofar < count2 && (reducedPoints.get((int)sofar).x != reducedPoints.get((int)start).x || reducedPoints.get((int)sofar).y != reducedPoints.get((int)start).y); ++sofar) {
                }
            }
            this.outputHeader((short)2048, 0);
            this.outputHeader((short)3330, layerNumber);
            this.outputHeader((short)3586, layerType);
            this.outputShort((short)(8 * (sofar - start + 1) + 4));
            this.outputShort((short)4099);
            for (int i = start; i <= sofar; ++i) {
                int j = i;
                if (i == sofar) {
                    j = start;
                }
                this.outputInt(reducedPoints.get((int)j).x);
                this.outputInt(reducedPoints.get((int)j).y);
            }
            this.outputHeader((short)4352, 0);
            if (sofar >= count2) break;
            start = sofar;
        }
    }

    private boolean nextTo(int a, int b, int total) {
        return (a + 1) % total == b || (b + 1) % total == a;
    }

    private void outputPath(PolyBase poly, int layerNumber, int layerType) {
        List<Point> reducedPoints = this.reducePolygon(poly);
        int numPoints = reducedPoints.size();
        if (numPoints <= 2) {
            return;
        }
        this.outputHeader((short)2304, 0);
        this.outputHeader((short)3330, layerNumber);
        this.outputHeader((short)3586, layerType);
        int count2 = 8 * numPoints + 4;
        this.outputShort((short)count2);
        this.outputShort((short)4099);
        for (int i = 0; i < numPoints; ++i) {
            this.outputInt(reducedPoints.get((int)i).x);
            this.outputInt(reducedPoints.get((int)i).y);
        }
        this.outputHeader((short)4352, 0);
    }

    private void outputByte(byte val) {
        GDS.dataBufferGDS[GDS.bufferPosition++] = val;
        if (bufferPosition >= 512) {
            try {
                this.dataOutputStream.write(dataBufferGDS, 0, 512);
            }
            catch (IOException e) {
                this.reportError("End of file reached while writing GDS");
            }
            ++blockCount;
            bufferPosition = 0;
        }
    }

    private int scaleDBUnit(double dbunit) {
        double scaled = this.scaleFactor * dbunit;
        int unit = (int)Math.round(scaled);
        if ((double)unit != scaled) {
            double scaledScale;
            long scaledUnit;
            int accurateScale = 10;
            for (int i = 0; i < 10 && (double)(scaledUnit = Math.round(scaledScale = scaled * (double)accurateScale)) != scaledScale; ++i) {
                accurateScale *= 10;
            }
            if (accurateScale > this.inaccurate) {
                this.inaccurate = accurateScale;
            }
        }
        return unit;
    }

    private void outputShort(short val) {
        this.outputByte((byte)(val >> 8 & 0xFF));
        this.outputByte((byte)(val & 0xFF));
    }

    private void outputInt(int val) {
        this.outputShort((short)(val >> 16));
        this.outputShort((short)val);
    }

    private void outputShortArray(short[] ptr, int n) {
        for (int i = 0; i < n; ++i) {
            this.outputShort(ptr[i]);
        }
    }

    private void outputString(String str, short header) {
        this.outputString(str, header, 512);
    }

    private void outputString(String str, short header, int max2) {
        int i;
        int j;
        int charsToUse = str.length();
        if (charsToUse > max2) {
            charsToUse = max2;
        }
        if ((j = charsToUse) % 2 != 0) {
            j = j / 2 * 2 + 2;
        }
        assert (j % 2 == 0);
        this.outputShort((short)(4 + j));
        this.outputShort(header);
        if (this.localPrefs.outUpperCase) {
            for (i = 0; i < charsToUse; ++i) {
                this.outputByte((byte)Character.toUpperCase(str.charAt(i)));
            }
        } else {
            while (i < charsToUse) {
                this.outputByte((byte)str.charAt(i));
                ++i;
            }
        }
        while (i < j) {
            this.outputByte((byte)0);
            ++i;
        }
    }

    public void outputDouble(double data) {
        int exponent;
        if (data == 0.0) {
            for (int i = 0; i < 8; ++i) {
                this.outputByte((byte)0);
            }
            return;
        }
        BigDecimal reg = new BigDecimal(data).setScale(64, 6);
        boolean negSign = false;
        if (reg.doubleValue() < 0.0) {
            negSign = true;
            reg = reg.negate();
        }
        for (exponent = 64; reg.doubleValue() < 0.0625 && exponent > 0; --exponent) {
            reg = reg.multiply(new BigDecimal(16.0));
        }
        if (exponent == 0) {
            System.out.println("Exponent underflow");
        }
        while (reg.doubleValue() >= 1.0 && exponent < 128) {
            reg = reg.divide(new BigDecimal(16.0), 6);
            ++exponent;
        }
        if (exponent > 127) {
            System.out.println("Exponent overflow");
        }
        if (negSign) {
            exponent |= 0x80;
        }
        BigDecimal f_mantissa = reg.subtract(new BigDecimal(reg.intValue()));
        for (int i = 0; i < 56; ++i) {
            f_mantissa = f_mantissa.multiply(new BigDecimal(2.0));
        }
        long mantissa = f_mantissa.longValue();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(exponent);
        for (int i = 6; i >= 0; --i) {
            baos.write((int)(mantissa >> i * 8 & 0xFFL));
        }
        byte[] result2 = baos.toByteArray();
        for (int i = 0; i < 8; ++i) {
            this.outputByte(result2[i]);
        }
    }

    private class BloatVisitor
    extends Geometry.Visitor {
        BloatVisitor(Geometry outGeom, int maxHierDepth) {
            super(GDS.this, outGeom, maxHierDepth);
        }

        @Override
        public void addNodeInst(NodeInst ni, FixpTransform trans) {
            PrimitiveNode prim = (PrimitiveNode)ni.getProto();
            if (prim.isPin()) {
                return;
            }
            Technology tech = prim.getTechnology();
            Poly[] polys = tech.getShapeOfNode(ni);
            Layer firstLayer = null;
            for (int i = 0; i < polys.length; ++i) {
                Poly poly = polys[i];
                Layer thisLayer = poly.getLayer();
                if (thisLayer != null && firstLayer == null) {
                    firstLayer = thisLayer;
                }
                if (poly.getStyle().isText()) {
                    GDS.this.outputHeader((short)3072, 0);
                    if (firstLayer != null) {
                        GDS.this.selectLayer(firstLayer);
                    }
                    int layerNum = currentLayerNumbers.getLayerNumber(GDSLayers.GDSLayerType.DRAWING);
                    int layerType = currentLayerNumbers.getLayerType(GDSLayers.GDSLayerType.DRAWING);
                    GDS.this.outputHeader((short)3330, layerNum);
                    GDS.this.outputHeader((short)5634, layerType);
                    GDS.this.outputHeader((short)5889, 0);
                    int transValue = 0;
                    int angle = ni.getAngle();
                    if (ni.isXMirrored() != ni.isYMirrored()) {
                        transValue |= 0x8000;
                    }
                    if (ni.isYMirrored()) {
                        angle = (3600 - angle) % 3600;
                    }
                    if (ni.isXMirrored()) {
                        angle = (1800 - angle + 3600) % 3600;
                    }
                    GDS.this.outputHeader((short)6657, transValue);
                    GDS.this.outputAngle(angle);
                    GDS.this.outputShort((short)12);
                    GDS.this.outputShort((short)4099);
                    PolyBase.Point[] points = poly.getPoints();
                    GDS.this.outputInt(GDS.this.scaleDBUnit(((Point2D)points[0]).getX()));
                    GDS.this.outputInt(GDS.this.scaleDBUnit(((Point2D)points[0]).getY()));
                    String str = poly.getString();
                    GDS.this.outputString(str, (short)6406);
                    GDS.this.outputHeader((short)4352, 0);
                }
                poly.transform(trans);
            }
            this.cellGeom.addPolys(polys, ni);
        }

        @Override
        public void addArcInst(ArcInst ai) {
            ArcProto ap = ai.getProto();
            Technology tech = ap.getTechnology();
            Poly[] polys = tech.getShapeOfArc(ai);
            this.cellGeom.addPolys(polys, ai);
        }
    }

    private static class StringComparator
    implements Comparator<String> {
        private StringComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            return s1.compareTo(s2);
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }
    }

    public static class GDSPreferences
    extends Output.OutputPreferences {
        public boolean writeExportPins = IOTool.isGDSOutWritesExportPins();
        public boolean convertBracketsInExports = IOTool.getGDSOutputConvertsBracketsInExports();
        public boolean collapseVddGndPinNames = IOTool.isGDSOutColapseVddGndPinNames();
        public boolean writeExportCharacteristics = IOTool.isGDSOutWriteExportCharacteristicsSetting();
        int outDefaultTextLayer = IOTool.getGDSDefaultTextLayer();
        boolean outMergesBoxes = IOTool.isGDSOutMergesBoxes();
        public int cellNameLenMax = IOTool.getGDSCellNameLenMax();
        public boolean outUpperCase = IOTool.isGDSOutUpperCase();
        boolean includeText;
        boolean convertNCCExportsConnectedByParentPins;
        boolean writeAllCells;
        public boolean flatDesign;
        boolean onlyVisibleLayers;
        boolean[] visibility;
        double precision;
        double unitsPerMeter;

        public GDSPreferences(boolean factory, Cell cell) {
            super(factory);
            if (factory) {
                this.writeAllCells = IOTool.isFactoryGDSWritesEntireLibrary();
                this.flatDesign = IOTool.isFactoryGDSFlatDesign();
                this.includeText = IOTool.isFactoryGDSIncludesText();
                this.precision = IOTool.getFactoryGDSOutputPrecision();
                this.unitsPerMeter = IOTool.getFactoryGDSOutputUnitsPerMeter();
                this.convertNCCExportsConnectedByParentPins = IOTool.getFactoryGDSConvertNCCExportsConnectedByParentPins();
                this.onlyVisibleLayers = IOTool.isFactoryGDSOnlyInvisibleLayers();
            } else {
                this.writeAllCells = IOTool.isGDSWritesEntireLibrary();
                this.flatDesign = IOTool.isGDSFlatDesign();
                this.includeText = IOTool.isGDSIncludesText();
                this.precision = IOTool.getGDSOutputPrecision();
                this.unitsPerMeter = IOTool.getGDSOutputUnitsPerMeter();
                this.convertNCCExportsConnectedByParentPins = IOTool.getGDSConvertNCCExportsConnectedByParentPins();
                this.onlyVisibleLayers = IOTool.isGDSOnlyInvisibleLayers();
            }
            if (this.onlyVisibleLayers && cell != null) {
                this.visibility = LayerVisibility.getLayerVisibility().getTechDataArray()[cell.getTechnology().getId().techIndex];
            }
        }

        @Override
        public Output doOutput(Cell cell, VarContext context, String filePath) {
            if (cell.getView() != View.LAYOUT && cell.getView() != View.LAYOUTSKEL && cell.getView() != View.LAYOUTCOMP) {
                System.out.println("Can only write GDS for layout cells");
                return null;
            }
            GDS out = new GDS(this);
            if (out.openBinaryOutputStream(filePath)) {
                return null;
            }
            out.writtenCells = new HashSet();
            out.writtenCellNames = new HashSet();
            if (this.flatDesign) {
                out.topCell = cell;
                out.start();
                out.writtenCells.add(cell);
                out.outputBeginStruct(cell);
                HashSet exportsUsed = new HashSet();
                out.writeRecursively(cell, DBMath.MATID, exportsUsed);
                out.outputHeader((short)1792, 0);
            } else {
                BloatVisitor visitor = out.makeBloatVisitor(Geometry.getMaxHierDepth(cell));
                if (out.writeCell(cell, context, visitor)) {
                    return null;
                }
                if (this.writeAllCells) {
                    Iterator<Cell> it = cell.getLibrary().getCells();
                    while (it.hasNext()) {
                        Cell c = it.next();
                        if (c.getView() == View.ICON || c.getView() == View.SCHEMATIC || c.getView().isTextView() || out.writtenCells.contains(c)) continue;
                        Geometry.CellGeom cellGeom = new Geometry.CellGeom(c, null);
                        cellGeom.addNodesAndArcs();
                        out.writeCellGeom(cellGeom);
                    }
                }
            }
            out.outputHeader((short)1024, 0);
            out.doneWritingOutput();
            if (out.closeBinaryOutputStream()) {
                return null;
            }
            System.out.println(filePath + " written");
            String topCellName = cell.getName();
            String mangledTopCellName = GDS.makeGDSName(topCellName, 256, this.outUpperCase);
            if (!topCellName.equals(mangledTopCellName)) {
                out.reportWarning("Warning: library name in this file is " + mangledTopCellName + " (special characters were changed)");
            }
            return out.finishWrite();
        }
    }
}

