/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing.seaOfGates;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.Environment;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.geometry.PolyMerge;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.id.ArcProtoId;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.NodeProtoId;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.RTBounds;
import com.sun.electric.database.topology.RTNode;
import com.sun.electric.database.topology.SteinerTree;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.routing.SeaOfGates;
import com.sun.electric.tool.routing.seaOfGates.SoGWireQualityMetric;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.ui.RoutingDebug;
import com.sun.electric.util.ElapseTimer;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.FixpCoord;
import com.sun.electric.util.math.FixpRectangle;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.GenMath;
import com.sun.electric.util.math.MutableBoolean;
import com.sun.electric.util.math.MutableDouble;
import com.sun.electric.util.math.MutableInteger;
import com.sun.electric.util.math.Orientation;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class SeaOfGatesEngine {
    private static final boolean CHECKBOTHDIRECTIONS = false;
    private static final boolean MINAREACHECK = true;
    private static final boolean NEWVIACALC = true;
    private static final boolean NOGRIDPENALTYATSOURCE = true;
    private static final boolean ANYPOINTONDESTINATION = true;
    private static final double GRAINSIZE = 1.0;
    private static final double SPINERATIO = 50.0;
    private static final int COSTALTERNATINGMETAL = 20;
    private static final int COSTLAYERCHANGE = 8;
    private static final int COSTWRONGDIRECTION = 15;
    private static final int COSTUNFAVORED = 10;
    private static final int COSTTURNING = 1;
    private static final int COSTOFFGRID = 15;
    private static final int BLOCKAGEFAKEENDPOINT = 1;
    private static final int BLOCKAGEENDA = 2;
    private static final int BLOCKAGEENDB = 4;
    private static final int BLOCKAGEFAKEUSERSUPPLIED = 8;
    private static final int SHIFTBLOCKBITS = 4;
    public static SearchVertex svAborted = new SearchVertex(0.0, 0.0, 0, 0, 0, null, null, 0, null, 0);
    public static SearchVertex svExhausted = new SearchVertex(0.0, 0.0, 0, 0, 0, null, null, 0, null, 0);
    public static SearchVertex svLimited = new SearchVertex(0.0, 0.0, 0, 0, 0, null, null, 0, null, 0);
    public static SearchVertex svAbandoned = new SearchVertex(0.0, 0.0, 0, 0, 0, null, null, 0, null, 0);
    private static int numMetalLayers;
    private Environment env;
    private Cell cell;
    private boolean parallelDij;
    private ErrorLogger errorLogger;
    private Rectangle2D cellBounds;
    private ERectangle routingBoundsLimit;
    private Technology tech;
    private Layer[][] metalLayers;
    private Layer[] primaryMetalLayer;
    private Layer[] viaLayers;
    private Map<Layer, Layer> removeLayers;
    private ArcProto[][] metalArcs;
    private PrimitiveNode[][] metalPureLayerNodes;
    private ArcProto[] primaryMetalArc;
    private double[] maxDefArcWidth;
    private double[] minimumArea;
    private double minResolution;
    private double[] size2X;
    private double[] taperLength;
    private boolean[] favorArcs;
    private boolean[] preventArcs;
    private boolean[] taperOnlyArcs;
    private MetalVias[] metalVias;
    private MetalVias[] metalVias2X;
    private SeaOfGates.SeaOfGatesTrack[][] metalGrid;
    private double[] metalGridRange;
    private double[] metalSurroundX;
    private double[] metalSurroundY;
    private double[] viaSurround;
    private double[] viaSize;
    private BlockageTrees rTrees;
    private Map<Network, Integer> netIDs;
    private SeaOfGates.SeaOfGatesOptions prefs;
    private Handler handler;
    private EditingPreferences ep;
    private SeaOfGates.SeaOfGatesCellParameters sogp;
    private List<NeededRoute> tapRoutes;
    private boolean messagesQuiet;
    private int totalBlockages;
    private int blockagesFound;
    private Map<Double, Map<Double, double[]>>[] layerSurround;
    private SoGWireQualityMetric sogQual;
    Map<Integer, List<MutableInteger>> netIDsByValue = new HashMap<Integer, List<MutableInteger>>();
    Map<Layer, List<Rectangle2D>> removeGeometry;

    public void routeIt(Handler handler, Cell cell, boolean quiet) {
        this.routeIt(handler, cell, quiet, null);
    }

    public void routeIt(Handler handler, Cell cell, boolean quiet, List<ArcInst> arcsToRoute) {
        this.routeIt(handler, cell, quiet, arcsToRoute, new SeaOfGates.SeaOfGatesCellParameters(cell));
    }

    public void routeIt(Handler handler, Cell cell, boolean quiet, List<ArcInst> arcsToRoute, SeaOfGates.SeaOfGatesCellParameters sogp) {
        String whichRoute;
        this.messagesQuiet = quiet;
        this.handler = handler;
        this.ep = handler.getEditingPreferences();
        this.env = cell.getDatabase().getEnvironment();
        this.sogp = sogp;
        this.tapRoutes = new ArrayList<NeededRoute>();
        this.cell = cell;
        this.cellBounds = cell.getBounds();
        this.tech = cell.getTechnology();
        this.routingBoundsLimit = null;
        String routingBoundsLayerName = sogp.getRoutingBoundsLayerName();
        if (routingBoundsLayerName != null) {
            Layer boundsLayer = this.tech.findLayer(routingBoundsLayerName);
            if (boundsLayer == null) {
                System.out.println("WARNING: Routing bounds layer '" + routingBoundsLayerName + "' not found in technology " + this.tech.getTechName());
            } else {
                ArrayList<NodeInst> boundsLayerNodes = new ArrayList<NodeInst>();
                Iterator<NodeInst> it = cell.getNodes();
                block0: while (it.hasNext()) {
                    NodeInst ni = it.next();
                    if (ni.isCellInstance() || ni.getFunction() != PrimitiveNode.Function.NODE) continue;
                    PrimitiveNode pNp = (PrimitiveNode)ni.getProto();
                    Technology.NodeLayer[] nodeLayers = pNp.getNodeLayers();
                    for (int i = 0; i < nodeLayers.length; ++i) {
                        if (nodeLayers[i].getLayer() != boundsLayer) continue;
                        boundsLayerNodes.add(ni);
                        continue block0;
                    }
                }
                if (boundsLayerNodes.size() == 0) {
                    System.out.println("WARNING: No nodes found with the routing bounds layer '" + routingBoundsLayerName + "'");
                } else if (boundsLayerNodes.size() > 1) {
                    System.out.println("WARNING: Found " + boundsLayerNodes.size() + " nodes with the routing bounds layer, must have only 1.");
                } else {
                    NodeInst ni = (NodeInst)boundsLayerNodes.get(0);
                    this.routingBoundsLimit = ni.getBounds();
                    System.out.println("NOTE: No routes will extend beyond " + TextUtils.formatDistance(this.routingBoundsLimit.getMinX()) + "<=X<=" + TextUtils.formatDistance(this.routingBoundsLimit.getMaxX()) + " AND " + TextUtils.formatDistance(this.routingBoundsLimit.getMinY()) + "<=Y<=" + TextUtils.formatDistance(this.routingBoundsLimit.getMaxY()));
                }
            }
        }
        if (this.initializeDesignRules()) {
            return;
        }
        this.initializeGrids();
        this.netIDs = new HashMap<Network, Integer>();
        this.errorLogger = ErrorLogger.newInstance("Routing (Sea of gates) " + cell.describe(false));
        this.prefs.theTimer = ElapseTimer.createInstance().start();
        Netlist netList = cell.getNetlist();
        List<String> netsToRoute = sogp.getNetsToRoute();
        if (netsToRoute != null && netsToRoute.size() > 0) {
            boolean allSelected = true;
            if (arcsToRoute != null) {
                Iterator<ArcInst> it = cell.getArcs();
                while (it.hasNext()) {
                    ArcInst ai = it.next();
                    if (ai.getProto() != Generic.tech().unrouted_arc || arcsToRoute.contains(ai)) continue;
                    allSelected = false;
                    break;
                }
            }
            if (allSelected) {
                arcsToRoute = new ArrayList<ArcInst>();
                for (String netName : netsToRoute) {
                    ArcInst ai = cell.findArc(netName);
                    if (ai == null) {
                        System.out.println("WARNING: Could not find network '" + netName + "' which was requested by the Sea-of-Gates Cell Properties");
                        continue;
                    }
                    Network net = netList.getNetwork(ai, 0);
                    if (net == null) continue;
                    Iterator<ArcInst> it = net.getArcs();
                    while (it.hasNext()) {
                        ai = it.next();
                        if (ai.getProto() != Generic.tech().unrouted_arc) continue;
                        arcsToRoute.add(ai);
                    }
                }
                System.out.println("Routing " + arcsToRoute.size() + " arcs from the list given in the Sea-of-Gates Cell Properties");
            }
        }
        if (arcsToRoute == null) {
            arcsToRoute = new ArrayList<ArcInst>();
            Iterator<ArcInst> it = cell.getArcs();
            while (it.hasNext()) {
                ArcInst ai = it.next();
                if (ai.getProto() != Generic.tech().unrouted_arc) continue;
                arcsToRoute.add(ai);
            }
        }
        if (arcsToRoute.isEmpty()) {
            return;
        }
        this.setProgressNote("Make list of routes...");
        if (!RoutingDebug.isActive()) {
            handler.startProgressDialog("Routing " + arcsToRoute.size() + " nets in cell " + cell.describe(false));
        }
        List<EPoint> linesInNonMahnattan = new ArrayList<EPoint>();
        RouteBatch[] routeBatches = this.makeListOfRoutes(netList, arcsToRoute, linesInNonMahnattan);
        MutableBoolean hadNonmanhattan = new MutableBoolean(linesInNonMahnattan.size() > 0);
        if (routeBatches.length == 0) {
            return;
        }
        if (RoutingDebug.isRewireNetworks()) {
            this.rewireNetworks(routeBatches);
            return;
        }
        ArrayList<NeededRoute> allRoutes = new ArrayList<NeededRoute>();
        for (int b = 0; b < routeBatches.length; ++b) {
            for (NeededRoute nr : routeBatches[b].routesInBatch) {
                allRoutes.add(nr);
            }
        }
        this.info("");
        this.info("Sea-of-gates router finding " + allRoutes.size() + " paths on " + routeBatches.length + " networks in cell " + cell.describe(false));
        if (hadNonmanhattan.booleanValue()) {
            String info = "Found nonmanhattan geometry (" + linesInNonMahnattan.size() + " points). This may cause larger rectangular blockages, which may block too much.";
            if (linesInNonMahnattan.size() > 100) {
                linesInNonMahnattan = linesInNonMahnattan.subList(0, 100);
                info = info + ". Displaying only the first 100";
            }
            this.warn(info, cell, linesInNonMahnattan, null);
        }
        if (this.prefs.useGlobalRouter || RoutingDebug.isTestGlobalRouting()) {
            this.setProgressNote("Do Global Routing...");
            this.info("Doing Global Routing...");
            RouteBatch[] fakeRBs = null;
            if (RoutingDebug.isActive()) {
                HashMap<Network, RouteBatch> additionalRBs = new HashMap<Network, RouteBatch>();
                HashSet<ArcInst> arcsInCell = new HashSet<ArcInst>();
                for (ArcInst ai : arcsToRoute) {
                    arcsInCell.add(ai);
                }
                Iterator<ArcInst> it = cell.getArcs();
                while (it.hasNext()) {
                    ArcProto bArc;
                    ArcInst ai;
                    ai = it.next();
                    if (ai.getProto() != Generic.tech().unrouted_arc || arcsInCell.contains(ai)) continue;
                    Network net = netList.getNetwork(ai, 0);
                    RouteBatch rb = (RouteBatch)additionalRBs.get(net);
                    if (rb == null) {
                        rb = new RouteBatch(net.getName());
                        additionalRBs.put(net, rb);
                    }
                    PortInst aPi = ai.getHeadPortInst();
                    PortInst bPi = ai.getTailPortInst();
                    ArcProto aArc = this.getMetalArcOnPort(aPi);
                    if (aArc == null || (bArc = this.getMetalArcOnPort(bPi)) == null) continue;
                    NeededRoute nr = new NeededRoute(net.getName(), aPi, bPi, aArc, bArc, null, 0.0);
                    rb.addRoute(nr);
                }
                fakeRBs = new RouteBatch[additionalRBs.size()];
                int i = 0;
                for (Network net : additionalRBs.keySet()) {
                    fakeRBs[i++] = (RouteBatch)additionalRBs.get(net);
                }
            }
            double wirePitch = Math.max(this.metalSurroundX[0], this.metalSurroundY[0]) + this.maxDefArcWidth[0];
            GlobalRouter gr = this.doGlobalRouting(cell, routeBatches, fakeRBs, wirePitch);
            ArrayList<NeededRoute> withGR = new ArrayList<NeededRoute>();
            ArrayList<NeededRoute> withoutGR = new ArrayList<NeededRoute>();
            for (NeededRoute nr : allRoutes) {
                if (nr.buckets != null) {
                    withGR.add(nr);
                    continue;
                }
                withoutGR.add(nr);
            }
            this.info("Global Routing planned " + withGR.size() + " paths in " + gr.getXBuckets() + "x" + gr.getYBuckets() + " buckets (" + withoutGR.size() + " paths are too short to route globally)");
            if (RoutingDebug.isActive()) {
                RoutingDebug.setGlobalRouting(gr);
            }
            if (RoutingDebug.isTestGlobalRouting()) {
                RoutingDebug.showGlobalRouting();
                return;
            }
            this.setProgressNote("Detail Route " + allRoutes.size() + " paths...");
            this.info("Detail Routing " + allRoutes.size() + " paths...");
        } else {
            this.setProgressNote("Route " + allRoutes.size() + " paths...");
            this.info("Routing " + allRoutes.size() + " paths...");
        }
        for (NeededRoute nr : allRoutes) {
            nr.checkGridValidity();
        }
        if (RoutingDebug.isActive() && allRoutes.size() > 0 && (whichRoute = RoutingDebug.getDesiredRouteToDebug()) != null) {
            NeededRoute nr = (NeededRoute)allRoutes.get(0);
            for (NeededRoute nrTest : allRoutes) {
                if (!nrTest.routeName.equalsIgnoreCase(whichRoute)) continue;
                nr = nrTest;
                break;
            }
            nr.setDebugging(RoutingDebug.isEndADebugging());
        }
        boolean parallel = this.prefs.useParallelRoutes;
        this.parallelDij = this.prefs.useParallelFromToRoutes;
        int numberOfProcessors = Runtime.getRuntime().availableProcessors();
        if (numberOfProcessors <= 1) {
            this.parallelDij = false;
        }
        int numberOfThreads = numberOfProcessors;
        if (this.prefs.forcedNumberOfThreads > 0) {
            this.info("Forcing use of " + this.prefs.forcedNumberOfThreads + " threads");
            numberOfThreads = this.prefs.forcedNumberOfThreads;
        }
        if (!parallel) {
            numberOfThreads = 1;
        }
        if (numberOfThreads == 1) {
            parallel = false;
            this.parallelDij = false;
        }
        if (parallel) {
            String message = "NOTE: System has " + numberOfProcessors + " processors so";
            if (this.parallelDij) {
                message = message + " routing " + numberOfThreads / 2 + " paths in parallel";
                message = message + " and routing both directions of each path in parallel";
            } else {
                message = message + " routing " + numberOfThreads + " paths in parallel";
            }
            this.info(message);
        }
        if (numberOfThreads > 1) {
            this.doRoutingParallel(numberOfThreads, allRoutes);
        } else {
            this.doRouting(allRoutes);
        }
        if (!RoutingDebug.isActive()) {
            handler.flush(true);
            if (this.tapRoutes.size() > 0) {
                this.setProgressNote("Adding taps to spine routes...");
                this.info("------------------ Adding taps to spine routes...");
                if (numberOfThreads > 1) {
                    this.doRoutingParallel(numberOfThreads, this.tapRoutes);
                } else {
                    this.doRouting(this.tapRoutes);
                }
                handler.flush(true);
            }
            ArrayList<NeededRoute> redoRoutes = new ArrayList<NeededRoute>();
            for (int b = 0; b < routeBatches.length; ++b) {
                for (NeededRoute nr : routeBatches[b].routesInBatch) {
                    if (nr.routedSuccess) continue;
                    redoRoutes.add(nr);
                    NeededRoute.access$002(nr, null);
                    nr.errorMessage = null;
                    nr.complexityLimit = this.prefs.rerunComplexityLimit;
                    nr.makeWavefronts();
                }
            }
            if (this.prefs.reRunFailedRoutes && redoRoutes.size() > 0) {
                this.setProgressNote("Re-Route " + redoRoutes.size() + " paths...");
                this.info("------------------ Re-Route " + redoRoutes.size() + " paths...");
                for (NeededRoute nr : redoRoutes) {
                    nr.reroute = true;
                    if (nr.loggedMessage == null) continue;
                    ArrayList<ErrorLogger.MessageLog> oldMessage = new ArrayList<ErrorLogger.MessageLog>();
                    oldMessage.add(nr.loggedMessage);
                    this.errorLogger.deleteMessages(oldMessage);
                }
                if (numberOfThreads > 1) {
                    this.doRoutingParallel(numberOfThreads, redoRoutes);
                } else {
                    this.doRouting(redoRoutes);
                }
                handler.flush(true);
            }
            RouteResolution resolution = new RouteResolution(cell.getId());
            for (int b = 0; b < routeBatches.length; ++b) {
                for (NeededRoute nr : routeBatches[b].routesInBatch) {
                    if (nr.routedSuccess) continue;
                    resolution.addUnrouted(nr.aPi, nr.bPi, nr.getName());
                }
            }
            handler.instantiate(resolution);
            handler.flush(true);
            this.summarize(routeBatches, allRoutes);
        }
        handler.termLogging(this.errorLogger);
        handler.stopProgressDialog();
    }

    public RTNode<SOGBound> getMetalTree(Layer lay) {
        return this.rTrees.getMetalTree(lay).getRoot();
    }

    public Iterator<SOGBound> searchMetalTree(Layer lay, Rectangle2D bound) {
        return this.rTrees.getMetalTree(lay).search(bound);
    }

    private void rewireNetworks(RouteBatch[] routeBatches) {
        for (int b = 0; b < routeBatches.length; ++b) {
            RouteBatch rb = routeBatches[b];
            RouteResolution res = rb.resolution;
            for (ArcInst aiKill : rb.unroutedArcs) {
                res.killArc(aiKill);
            }
            for (NodeInst niKill : rb.unroutedNodes) {
                res.killNode(niKill);
            }
            for (NeededRoute nr : rb.routesInBatch) {
                res.addUnrouted(nr.aPi, nr.bPi, nr.getName());
            }
            this.handler.instantiate(res);
        }
        this.handler.flush(true);
        this.sogp.setSteinerDone(true);
        this.sogp.saveParameters(this.ep);
    }

    private void summarize(RouteBatch[] routeBatches, List<NeededRoute> allRoutes) {
        this.sogQual = new SoGWireQualityMetric("SoG");
        this.sogQual.setOutput(this.prefs.qualityPrintStream);
        for (int b = 0; b < routeBatches.length; ++b) {
            this.sogQual.calculate(routeBatches[b]);
        }
        this.prefs.theTimer.end();
        this.info("Cell " + this.cell.describe(false) + " routed " + this.sogQual.numRoutedSegments + " out of " + allRoutes.size() + " segments" + " (took " + this.prefs.theTimer + ")");
        if (this.sogQual.numFailedSegments > 0) {
            this.info("NOTE: " + this.sogQual.numFailedSegments + " segments on " + this.sogQual.numFailedBatches + " nets were not routed");
        }
        this.info(this.sogQual.printAverageResults());
    }

    public String getRoutedNetRatio() {
        String value = "";
        if (this.sogQual != null) {
            int total = this.sogQual.numFailedSegments + this.sogQual.numRoutedSegments;
            value = "" + this.sogQual.numRoutedSegments + "/" + total;
        }
        return value;
    }

    public void setPrefs(SeaOfGates.SeaOfGatesOptions p) {
        this.prefs = p;
    }

    public SeaOfGates.SeaOfGatesOptions getPrefs() {
        return this.prefs;
    }

    public Technology getTech() {
        return this.tech;
    }

    public int getNumMetals() {
        return numMetalLayers;
    }

    public Layer getPrimaryMetalLayer(int layNum) {
        return this.primaryMetalLayer[layNum];
    }

    private boolean isOnMetalArc(int layNum, ArcProto ap) {
        for (int c = 0; c < this.metalArcs[layNum].length; ++c) {
            if (this.metalArcs[layNum][c] != ap) continue;
            return true;
        }
        return false;
    }

    public Layer getViaLayer(int layNum) {
        return this.viaLayers[layNum];
    }

    protected String describe(NodeInst ni) {
        NodeProto np = ni.getProto();
        boolean libDescribe = np instanceof Cell ? ((Cell)np).getLibrary() != this.cell.getLibrary() : ((PrimitiveNode)np).getTechnology() != this.tech;
        return libDescribe ? ni.libDescribe() : ni.noLibDescribe();
    }

    protected String describe(ArcInst ai) {
        ArcProto ap = ai.getProto();
        boolean libDescribe = ap.getTechnology() != this.tech;
        return libDescribe ? ai.libDescribe() : ai.noLibDescribe();
    }

    protected String describe(NodeProto np) {
        boolean libDescribe = np instanceof Cell ? ((Cell)np).getLibrary() != this.cell.getLibrary() : ((PrimitiveNode)np).getTechnology() != this.tech;
        return libDescribe ? np.libDescribe() : np.noLibDescribe();
    }

    protected String describe(ArcProto ap) {
        boolean libDescribe = ap.getTechnology() != this.tech;
        return libDescribe ? ap.getFullName() : ap.getName();
    }

    protected Environment getEnvironment() {
        return this.env;
    }

    protected boolean checkAbort() {
        return this.handler.checkAbort();
    }

    protected void trace(String msg) {
        this.handler.trace(msg);
    }

    protected void debug(String msg) {
        this.handler.debug(msg);
    }

    protected void info(String msg) {
        this.handler.info(msg);
    }

    protected void warn(String msg) {
        this.handler.warn(msg);
    }

    protected void warn(String msg, Cell cell, List<EPoint> linesToShow, List<PolyBase> polysToShow) {
        this.warn(msg);
        if (polysToShow != null) {
            this.errorLogger.logMessage(msg, null, polysToShow, cell, 0, false);
            return;
        }
        this.errorLogger.logMessageWithLines(msg, linesToShow, linesToShow, cell, 0, false);
    }

    protected void error(String msg) {
        this.handler.error(msg);
    }

    protected void setProgressNote(String message) {
        if (!RoutingDebug.isActive()) {
            this.handler.setProgressNote(message);
        }
    }

    protected void setProgressValue(int done, int total) {
        if (!RoutingDebug.isActive()) {
            this.handler.setProgressValue(done, total);
        }
    }

    void flush() {
        this.handler.flush(false);
    }

    protected abstract void doRoutingParallel(int var1, List<NeededRoute> var2);

    private void doRouting(List<NeededRoute> allRoutes) {
        int totalRoutes = allRoutes.size();
        for (int r = 0; r < totalRoutes; ++r) {
            Runnable[] runnables;
            if (this.checkAbort()) {
                this.info("Sea-of-gates routing aborted");
                break;
            }
            NeededRoute nr = allRoutes.get(r);
            this.setProgressValue(r, totalRoutes);
            String progMsg = "Routing network " + nr.routeName + "...";
            this.setProgressNote(progMsg);
            if (!this.messagesQuiet && !Job.getDebug()) {
                this.trace(progMsg);
            }
            if (nr.alreadyRouted) {
                ArrayList<PolyBase> polysInConnection = new ArrayList<PolyBase>();
                PolyBase.Point[] points = new PolyBase.Point[]{PolyBase.fromLambda(nr.aX, nr.aY), PolyBase.fromLambda(nr.bX, nr.bY)};
                polysInConnection.add(new PolyBase(points));
                for (int i = 0; i < numMetalLayers; ++i) {
                    RTNode root = this.rTrees.metalTrees[i].getRoot();
                    if (root == null) continue;
                    this.addNetsToList(root, nr.netID, polysInConnection);
                }
                if (this.prefs.runOnConnectedRoutes) {
                    this.warn("Network " + nr.getName() + " is already routed in the circuit, running router on it anyway", this.cell, null, polysInConnection);
                } else {
                    this.warn("Not routing network " + nr.getName() + " because it is already routed in the circuit", this.cell, null, polysInConnection);
                    continue;
                }
            }
            if ((runnables = this.findPath(nr)) != null) {
                for (Runnable runnable : runnables) {
                    runnable.run();
                }
            }
            if (nr.debuggingRouteFromA == null) continue;
            RoutingDebug.debugRoute(nr);
            break;
        }
    }

    private void addNetsToList(RTNode<SOGBound> node, MutableInteger net, List<PolyBase> polysInConnection) {
        for (int i = 0; i < node.getTotal(); ++i) {
            if (node.getFlag()) {
                SOGBound b = (SOGBound)node.getChild(i);
                if (b.getNetID() == null || b.getNetID().intValue() != net.intValue()) continue;
                ERectangle rect = b.bound;
                polysInConnection.add(new PolyBase(rect));
                continue;
            }
            RTNode subNode = (RTNode)node.getChild(i);
            this.addNetsToList(subNode, net, polysInConnection);
        }
    }

    public ErrorLogger getErrorLgger() {
        return this.errorLogger;
    }

    private boolean initializeDesignRules() {
        int i;
        int i2;
        int i3;
        int metNum;
        numMetalLayers = 0;
        Iterator<Comparable> it = this.tech.getLayers();
        while (it.hasNext()) {
            Layer lay = it.next();
            if (!lay.getFunction().isMetal()) continue;
            metNum = lay.getFunction().getLevel();
            numMetalLayers = Math.max(metNum, numMetalLayers);
        }
        it = this.tech.getArcs();
        while (it.hasNext()) {
            ArcProto ap = (ArcProto)it.next();
            if (!ap.getFunction().isMetal()) continue;
            metNum = ap.getFunction().getLevel();
            numMetalLayers = Math.max(metNum, numMetalLayers);
        }
        this.metalLayers = new Layer[numMetalLayers][];
        this.primaryMetalLayer = new Layer[numMetalLayers];
        List[] tempLayerList = new List[numMetalLayers];
        for (int i4 = 0; i4 < numMetalLayers; ++i4) {
            tempLayerList[i4] = new ArrayList();
        }
        Iterator<Layer> it2 = this.tech.getLayers();
        while (it2.hasNext()) {
            Layer lay = it2.next();
            if (!lay.getFunction().isMetal()) continue;
            int metNum2 = lay.getFunction().getLevel() - 1;
            tempLayerList[metNum2].add(lay);
        }
        for (int i5 = 0; i5 < numMetalLayers; ++i5) {
            Layer first;
            int colorNum;
            this.primaryMetalLayer[i5] = null;
            Collections.sort(tempLayerList[i5], new SortLayersByMaskNumber());
            if (tempLayerList[i5].size() > 1 && (colorNum = (first = (Layer)tempLayerList[i5].get(0)).getFunction().getMaskColor()) == 0) {
                this.primaryMetalLayer[i5] = (Layer)tempLayerList[i5].get(0);
                tempLayerList[i5].remove(0);
            }
            this.metalLayers[i5] = new Layer[tempLayerList[i5].size()];
            for (int c = 0; c < tempLayerList[i5].size(); ++c) {
                this.metalLayers[i5][c] = (Layer)tempLayerList[i5].get(c);
            }
            if (this.primaryMetalLayer[i5] != null) continue;
            this.primaryMetalLayer[i5] = this.metalLayers[i5][0];
        }
        this.metalArcs = new ArcProto[numMetalLayers][];
        this.metalPureLayerNodes = new PrimitiveNode[numMetalLayers][];
        this.primaryMetalArc = new ArcProto[numMetalLayers];
        this.size2X = new double[numMetalLayers];
        this.taperLength = new double[numMetalLayers];
        boolean hasFavorites = false;
        this.favorArcs = new boolean[numMetalLayers];
        this.preventArcs = new boolean[numMetalLayers];
        this.taperOnlyArcs = new boolean[numMetalLayers];
        for (int i6 = 0; i6 < numMetalLayers; ++i6) {
            this.taperOnlyArcs[i6] = false;
            this.preventArcs[i6] = false;
            this.favorArcs[i6] = false;
        }
        List[] tempArcList = new List[numMetalLayers];
        for (int i7 = 0; i7 < numMetalLayers; ++i7) {
            tempArcList[i7] = new ArrayList();
        }
        Iterator<ArcProto> it3 = this.tech.getArcs();
        while (it3.hasNext()) {
            ArcProto ap = it3.next();
            if (!ap.getFunction().isMetal()) continue;
            int metNum3 = ap.getFunction().getLevel() - 1;
            tempArcList[metNum3].add(ap);
        }
        for (i3 = 0; i3 < numMetalLayers; ++i3) {
            Double d;
            ArcProto first;
            int colorNum;
            this.primaryMetalArc[i3] = null;
            Collections.sort(tempArcList[i3], new SortArcsByMaskNumber());
            if (tempArcList[i3].size() > 1 && (colorNum = (first = (ArcProto)tempArcList[i3].get(0)).getMaskLayer()) == 0) {
                this.primaryMetalArc[i3] = (ArcProto)tempArcList[i3].get(0);
                tempArcList[i3].remove(0);
            }
            this.metalArcs[i3] = new ArcProto[tempArcList[i3].size()];
            this.metalPureLayerNodes[i3] = new PrimitiveNode[tempArcList[i3].size()];
            for (int c = 0; c < tempArcList[i3].size(); ++c) {
                ArcProto ap = (ArcProto)tempArcList[i3].get(c);
                int metNum4 = ap.getFunction().getLevel() - 1;
                this.metalArcs[i3][c] = ap;
                Iterator<PrimitiveNode> it4 = this.tech.getNodes();
                while (it4.hasNext()) {
                    PrimitiveNode pNp = it4.next();
                    if (pNp.getFunction() != PrimitiveNode.Function.NODE) continue;
                    Iterator<Layer> lIt = pNp.getLayerIterator();
                    while (lIt.hasNext()) {
                        Layer lay = lIt.next();
                        if (!lay.getFunction().isMetal() || lay.getFunction().getLevel() - 1 != metNum4 || lay.getFunction().getMaskColor() != ap.getMaskLayer()) continue;
                        this.metalPureLayerNodes[i3][c] = pNp;
                        break;
                    }
                    if (this.metalPureLayerNodes[i3][c] == null) continue;
                    break;
                }
                if (this.sogp.isFavored(ap)) {
                    this.favorArcs[metNum4] = true;
                    hasFavorites = true;
                }
                if (this.sogp.isPrevented(ap)) {
                    this.preventArcs[metNum4] = true;
                }
                if (!this.sogp.isTaperOnly(ap)) continue;
                this.taperOnlyArcs[metNum4] = true;
            }
            if (this.primaryMetalArc[i3] == null) {
                this.primaryMetalArc[i3] = this.metalArcs[i3][0];
            }
            this.size2X[i3] = (d = this.sogp.get2XWidth(this.primaryMetalArc[i3])) == null ? 0.0 : d;
            d = this.sogp.getTaperLength(this.primaryMetalArc[i3]);
            this.taperLength[i3] = d == null ? -1.0 : d;
        }
        if (!hasFavorites) {
            for (i3 = 0; i3 < numMetalLayers; ++i3) {
                this.favorArcs[i3] = true;
            }
        }
        boolean failure = false;
        for (i2 = 0; i2 < numMetalLayers; ++i2) {
            int c;
            if (this.metalLayers[i2].length == 0) {
                this.error("Cannot find layer for Metal " + (i2 + 1) + " in technology " + this.tech.getTechName());
                failure = true;
            }
            if (this.metalArcs[i2].length == 0) {
                this.error("Cannot find arc for Metal " + (i2 + 1) + " in technology " + this.tech.getTechName());
                failure = true;
            }
            for (int c2 = 0; c2 < this.metalPureLayerNodes[i2].length; ++c2) {
                if (this.metalPureLayerNodes[i2][c2] != null) continue;
                this.error("Cannot find pure-layer node for Metal " + (i2 + 1) + " color " + (c2 + 1) + " in technology " + this.tech.getTechName());
                failure = true;
            }
            if (this.metalLayers[i2].length != this.metalArcs[i2].length) {
                String layMsg = "";
                for (int c3 = 0; c3 < this.metalLayers[i2].length; ++c3) {
                    if (layMsg.length() > 0) {
                        layMsg = layMsg + ", ";
                    }
                    layMsg = layMsg + this.metalLayers[i2][c3].getName();
                }
                String arcMsg = "";
                for (int c4 = 0; c4 < this.metalArcs[i2].length; ++c4) {
                    if (arcMsg.length() > 0) {
                        arcMsg = arcMsg + ", ";
                    }
                    arcMsg = arcMsg + this.metalArcs[i2][c4].getName();
                }
                this.warn("Metal " + (i2 + 1) + " in technology " + this.tech.getTechName() + " has " + this.metalLayers[i2].length + " mask layers (" + layMsg + ") but " + this.metalArcs[i2].length + " mask arcs (" + arcMsg + "). Making them equal length.");
                if (this.metalLayers[i2].length > this.metalArcs[i2].length) {
                    Layer[] newMetalLayers = new Layer[this.metalArcs[i2].length];
                    for (c = 0; c < newMetalLayers.length; ++c) {
                        newMetalLayers[c] = this.metalLayers[i2][c];
                    }
                    this.metalLayers[i2] = newMetalLayers;
                } else {
                    ArcProto[] newMetalArcs = new ArcProto[this.metalLayers[i2].length];
                    for (c = 0; c < newMetalArcs.length; ++c) {
                        newMetalArcs[c] = this.metalArcs[i2][c];
                    }
                    this.metalArcs[i2] = newMetalArcs;
                }
            }
            if (this.metalLayers[i2].length != this.metalArcs[i2].length) continue;
            boolean badOrder = false;
            String layMsg = "";
            String arcMsg = "";
            for (c = 0; c < this.metalLayers[i2].length; ++c) {
                int layMask = this.metalLayers[i2][c].getFunction().getMaskColor();
                int arcMask = this.metalArcs[i2][c].getMaskLayer();
                if (layMsg.length() > 0) {
                    layMsg = layMsg + ", ";
                }
                layMsg = layMsg + layMask;
                if (arcMsg.length() > 0) {
                    arcMsg = arcMsg + ", ";
                }
                arcMsg = arcMsg + arcMask;
                if (layMask == arcMask) continue;
                badOrder = true;
            }
            if (!badOrder) continue;
            this.error("Metal " + (i2 + 1) + " in technology " + this.tech.getTechName() + " has layer masks " + layMsg + " but arc masks " + arcMsg);
            failure = true;
        }
        if (failure) {
            return true;
        }
        this.removeLayers = new HashMap<Layer, Layer>();
        for (i2 = 0; i2 < numMetalLayers; ++i2) {
            for (int j = 0; j < this.metalLayers[i2].length; ++j) {
                Layer metLay = this.metalLayers[i2][j];
                ArcProto metAp = this.metalArcs[i2][j];
                String removeLayerName = this.sogp.getRemoveLayer(metAp);
                if (removeLayerName == null) continue;
                Layer removeLay = this.tech.findLayer(removeLayerName);
                if (removeLay == null) {
                    System.out.println("WARNING: Unknown removal layer: " + removeLayerName);
                    continue;
                }
                this.removeLayers.put(removeLay, metLay);
            }
        }
        this.viaLayers = new Layer[numMetalLayers - 1];
        this.metalVias = new MetalVias[numMetalLayers - 1];
        for (i2 = 0; i2 < numMetalLayers - 1; ++i2) {
            this.metalVias[i2] = new MetalVias();
        }
        this.metalVias2X = new MetalVias[numMetalLayers - 1];
        for (i2 = 0; i2 < numMetalLayers - 1; ++i2) {
            this.metalVias2X[i2] = new MetalVias();
        }
        String ignorePattern = this.sogp.getIgnorePrimitives();
        String accept1XPattern = this.sogp.getAcceptOnly1XPrimitives();
        String accept2XPattern = this.sogp.getAcceptOnly2XPrimitives();
        boolean contactsCanRotate = this.sogp.isContactsRotate();
        Pattern ignorePat = ignorePattern != null ? Pattern.compile(ignorePattern) : null;
        Pattern acceptPat1X = accept1XPattern != null ? Pattern.compile(accept1XPattern) : null;
        Pattern acceptPat2X = accept2XPattern != null ? Pattern.compile(accept2XPattern) : null;
        Iterator<PrimitiveNode> it5 = this.tech.getNodes();
        block25: while (it5.hasNext()) {
            Matcher matcher;
            Matcher matcher2;
            PrimitiveNode np = it5.next();
            if (np.isNotUsed() || !np.getFunction().isContact() || ignorePat != null && (matcher2 = ignorePat.matcher(np.getName())).find()) continue;
            boolean is1XContact = false;
            boolean is2XContact = false;
            if (acceptPat1X == null) {
                is1XContact = true;
            } else {
                matcher = acceptPat1X.matcher(np.getName());
                is1XContact = matcher.find();
            }
            if (acceptPat2X == null) {
                is2XContact = true;
            } else {
                matcher = acceptPat2X.matcher(np.getName());
                is2XContact = matcher.find();
            }
            if (!is1XContact && !is2XContact) continue;
            MetalVias[] whichOnes = is1XContact ? this.metalVias : this.metalVias2X;
            ArcProto[] conns = np.getPort(0).getConnections();
            for (int i8 = 0; i8 < numMetalLayers - 1; ++i8) {
                if ((!this.isOnMetalArc(i8, conns[0]) || !this.isOnMetalArc(i8 + 1, conns[1])) && (!this.isOnMetalArc(i8, conns[1]) || !this.isOnMetalArc(i8 + 1, conns[0]))) continue;
                boolean square = true;
                boolean offCenter = false;
                NodeInst dummyNi = NodeInst.makeDummyInstance((NodeProto)np, this.ep);
                Poly[] conPolys = this.tech.getShapeOfNode(dummyNi);
                int horMet = -1;
                int verMet = -1;
                double horMetInset = 0.0;
                double verMetInset = 0.0;
                int horMetColor = 0;
                int verMetColor = 0;
                for (int p = 0; p < conPolys.length; ++p) {
                    Poly conPoly = conPolys[p];
                    Layer conLayer = conPoly.getLayer();
                    Layer.Function lFun = conLayer.getFunction();
                    if (lFun.isMetal()) {
                        FixpRectangle conRect = conPoly.getBounds2D();
                        if (((RectangularShape)conRect).getWidth() != ((RectangularShape)conRect).getHeight()) {
                            square = false;
                            if (((RectangularShape)conRect).getWidth() > ((RectangularShape)conRect).getHeight()) {
                                horMet = lFun.getLevel() - 1;
                                horMetColor = lFun.getMaskColor();
                                horMetInset = dummyNi.getYSize() - ((RectangularShape)conRect).getHeight();
                            } else {
                                verMet = lFun.getLevel() - 1;
                                verMetColor = lFun.getMaskColor();
                                verMetInset = dummyNi.getXSize() - ((RectangularShape)conRect).getWidth();
                            }
                        }
                        if (((RectangularShape)conRect).getCenterX() == 0.0 && ((RectangularShape)conRect).getCenterY() == 0.0) continue;
                        offCenter = true;
                        continue;
                    }
                    if (!lFun.isContact()) continue;
                    this.viaLayers[i8] = conLayer;
                }
                if (square || offCenter) {
                    verMet = -1;
                    horMet = -1;
                } else if (horMet < 0 || verMet < 0) {
                    verMet = -1;
                    horMet = -1;
                }
                whichOnes[i8].addVia(np, 0, horMet, horMetColor, horMetInset, verMet, verMetColor, verMetInset);
                if (!contactsCanRotate) continue block25;
                if (offCenter) {
                    whichOnes[i8].addVia(np, 90, horMet, horMetColor, horMetInset, verMet, verMetColor, verMetInset);
                    whichOnes[i8].addVia(np, 180, horMet, horMetColor, horMetInset, verMet, verMetColor, verMetInset);
                    whichOnes[i8].addVia(np, 270, horMet, horMetColor, horMetInset, verMet, verMetColor, verMetInset);
                    continue block25;
                }
                if (square) continue block25;
                whichOnes[i8].addVia(np, 90, verMet, verMetColor, verMetInset, horMet, horMetColor, horMetInset);
                continue block25;
            }
        }
        for (int i9 = 0; i9 < numMetalLayers - 1; ++i9) {
            if (this.metalArcs[i9].length > 1 || this.metalArcs[i9 + 1].length > 1) {
                boolean[][] masks = new boolean[this.metalArcs[i9].length][this.metalArcs[i9 + 1].length];
                for (int c1 = 0; c1 < this.metalArcs[i9].length; ++c1) {
                    for (int c2 = 0; c2 < this.metalArcs[i9 + 1].length; ++c2) {
                        masks[c1][c2] = false;
                    }
                }
                ArrayList<MetalVia> allContacts = new ArrayList<MetalVia>();
                for (MetalVia mv : this.metalVias[i9].getVias()) {
                    allContacts.add(mv);
                }
                for (MetalVia mv : this.metalVias2X[i9].getVias()) {
                    allContacts.add(mv);
                }
                for (MetalVia mv : allContacts) {
                    int met1 = -1;
                    int met1c = -1;
                    int met2 = -1;
                    int met2c = -1;
                    for (Technology.NodeLayer nl : mv.via.getNodeLayers()) {
                        Layer layer = nl.getLayer();
                        if (!layer.getFunction().isMetal()) continue;
                        if (met1 < 0) {
                            met1 = layer.getFunction().getLevel();
                            met1c = layer.getFunction().getMaskColor();
                            continue;
                        }
                        met2 = layer.getFunction().getLevel();
                        met2c = layer.getFunction().getMaskColor();
                    }
                    if (met1 < 0 || met2 < 0) continue;
                    if (met1 != i9 + 1 || met2 != i9 + 2) {
                        this.warn("Contact " + mv.via.getName() + " in technology " + this.tech.getTechName() + " bridges metals " + (i9 + 1) + " and " + (i9 + 2) + " but mentions different metals in its name");
                        continue;
                    }
                    if (met1c == 0) {
                        if (this.metalArcs[i9].length > 1) {
                            this.warn("Contact " + mv.via.getName() + " in technology " + this.tech.getTechName() + " does not specify mask for metal " + (i9 + 1));
                        }
                        met1c = 1;
                    }
                    if (met2c == 0) {
                        if (this.metalArcs[i9 + 1].length > 1) {
                            this.warn("Contact " + mv.via.getName() + " in technology " + this.tech.getTechName() + " does not specify mask for metal " + (i9 + 2));
                        }
                        met2c = 1;
                    }
                    masks[met1c - 1][met2c - 1] = true;
                }
                for (int c1 = 0; c1 < this.metalArcs[i9].length; ++c1) {
                    for (int c2 = 0; c2 < this.metalArcs[i9 + 1].length; ++c2) {
                        if (masks[c1][c2]) continue;
                        this.warn("No metal-" + (i9 + 1) + " to metal-" + (i9 + 2) + " contact in technology " + this.tech.getTechName() + " that bridges metal-" + (i9 + 1) + "/mask-" + (c1 + 1) + " and metal-" + (i9 + 2) + "/mask-" + (c2 + 1));
                    }
                }
            }
            boolean noContact = false;
            if (this.metalVias[i9].getVias().size() == 0) {
                this.warn("Cannot find contact node between Metal " + (i9 + 1) + " and Metal " + (i9 + 2) + " in technology " + this.tech.getTechName() + ". Ignoring Metal layers " + (i9 + 2) + " and higher.");
                noContact = true;
            } else if (this.viaLayers[i9] == null) {
                this.warn("Cannot find contact layer between Metal " + (i9 + 1) + " and Metal " + (i9 + 2) + " in technology " + this.tech.getTechName() + ". Ignoring Metal layers " + (i9 + 2) + " and higher.");
                noContact = true;
            }
            if (!noContact) continue;
            for (int j = i9 + 1; j < numMetalLayers; ++j) {
                this.preventArcs[j] = true;
            }
            break;
        }
        DRC.DRCPreferences dp = new DRC.DRCPreferences(false);
        this.minResolution = dp.getResolution(this.tech).getLambda();
        this.layerSurround = new Map[numMetalLayers];
        for (int i10 = 0; i10 < numMetalLayers; ++i10) {
            this.layerSurround[i10] = new HashMap<Double, Map<Double, double[]>>();
        }
        this.metalSurroundX = new double[numMetalLayers];
        this.metalSurroundY = new double[numMetalLayers];
        this.maxDefArcWidth = new double[numMetalLayers];
        this.minimumArea = new double[numMetalLayers];
        MutableDouble mutableDist = new MutableDouble(0.0);
        for (i = 0; i < numMetalLayers; ++i) {
            if (this.metalLayers[i] == null) continue;
            this.minimumArea[i] = 0.0;
            DRCTemplate minAreaRule = DRC.getMinValue(this.primaryMetalLayer[i], DRCTemplate.DRCRuleType.MINAREA);
            if (minAreaRule != null) {
                this.minimumArea[i] = minAreaRule.getValue(0);
            }
            this.maxDefArcWidth[i] = 0.0;
            this.metalSurroundY[i] = 0.0;
            this.metalSurroundX[i] = 0.0;
            for (int c = 0; c < this.metalArcs[i].length; ++c) {
                this.maxDefArcWidth[i] = Math.max(this.maxDefArcWidth[i], this.metalArcs[i][c].getDefaultLambdaBaseWidth(this.ep));
                DRCTemplate rule = DRC.getSpacingRule(this.metalLayers[i][c], null, this.metalLayers[i][c], null, false, -1, this.metalArcs[i][c].getDefaultLambdaBaseWidth(this.ep), 50.0);
                if (rule != null) {
                    this.metalSurroundX[i] = Math.max(this.metalSurroundX[i], rule.getValue(0));
                    this.metalSurroundY[i] = rule.getNumValues() > 1 ? Math.max(this.metalSurroundY[i], rule.getValue(1)) : this.metalSurroundX[i];
                }
                if (!DRC.getMaxSurround(this.metalLayers[i][c], Double.MAX_VALUE, mutableDist)) continue;
                this.metalSurroundX[i] = Math.max(this.metalSurroundX[i], mutableDist.doubleValue());
                if (this.metalSurroundY[i] == mutableDist.doubleValue()) continue;
                this.metalSurroundY[i] = Math.max(this.metalSurroundY[i], mutableDist.doubleValue());
            }
        }
        this.viaSurround = new double[numMetalLayers - 1];
        this.viaSize = new double[numMetalLayers - 1];
        for (i = 0; i < numMetalLayers - 1; ++i) {
            Layer lay = this.viaLayers[i];
            if (lay == null) continue;
            double spacing = 2.0;
            DRCTemplate ruleSpacing = DRC.getSpacingRule(lay, null, lay, null, false, -1, this.maxDefArcWidth[i], 50.0);
            if (ruleSpacing != null) {
                spacing = ruleSpacing.getValue(0);
            }
            double width = 0.0;
            DRCTemplate ruleWidth = DRC.getMinValue(lay, DRCTemplate.DRCRuleType.NODSIZ);
            if (ruleWidth != null) {
                width = ruleWidth.getValue(0);
            }
            ArrayList<MetalVia> nps = new ArrayList<MetalVia>();
            for (MetalVia mv : this.metalVias[i].getVias()) {
                nps.add(mv);
            }
            for (MetalVia mv : this.metalVias2X[i].getVias()) {
                nps.add(mv);
            }
            for (MetalVia mv : nps) {
                NodeInst dummyNi = NodeInst.makeDummyInstance((NodeProto)mv.via, this.ep);
                Poly[] conPolys = this.tech.getShapeOfNode(dummyNi);
                for (int p = 0; p < conPolys.length; ++p) {
                    Poly conPoly = conPolys[p];
                    if (!conPoly.getLayer().getFunction().isContact()) continue;
                    FixpRectangle bounds = conPoly.getBounds2D();
                    width = Math.max(width, ((RectangularShape)bounds).getWidth());
                    width = Math.max(width, ((RectangularShape)bounds).getHeight());
                }
            }
            this.viaSurround[i] = spacing;
            this.viaSize[i] = width;
        }
        return false;
    }

    private void initializeGrids() {
        this.metalGrid = new SeaOfGates.SeaOfGatesTrack[numMetalLayers][];
        this.metalGridRange = new double[numMetalLayers];
        for (int i = 0; i < numMetalLayers; ++i) {
            int j;
            ArcProto ap = this.primaryMetalArc[i];
            String arcGrid = this.sogp.getGrid(ap);
            if (arcGrid == null) {
                this.metalGrid[i] = null;
                this.metalGridRange[i] = 0.0;
                continue;
            }
            ArrayList<SeaOfGates.SeaOfGatesTrack> found = new ArrayList<SeaOfGates.SeaOfGatesTrack>();
            String[] parts = arcGrid.split(",");
            for (j = 0; j < parts.length; ++j) {
                String part = parts[j].trim();
                if (part.length() == 0) continue;
                int trackColor = SeaOfGates.SeaOfGatesTrack.getSpecificMaskNumber(part);
                if (!Character.isDigit(part.charAt(part.length() - 1))) {
                    part = part.substring(0, part.length() - 1);
                }
                double val = TextUtils.atof(part);
                found.add(new SeaOfGates.SeaOfGatesTrack(val, trackColor));
            }
            Collections.sort(found);
            this.metalGrid[i] = new SeaOfGates.SeaOfGatesTrack[found.size()];
            for (j = 0; j < found.size(); ++j) {
                this.metalGrid[i][j] = (SeaOfGates.SeaOfGatesTrack)found.get(j);
            }
            this.metalGridRange[i] = this.metalGrid[i][found.size() - 1].getCoordinate() - this.metalGrid[i][0].getCoordinate();
        }
    }

    private RouteBatch[] makeListOfRoutes(Netlist netList, List<ArcInst> arcsToRoute, List<EPoint> linesInNonMahnattan) {
        HashMap seen = new HashMap();
        for (int b = 0; b < arcsToRoute.size(); ++b) {
            ArcInst ai = arcsToRoute.get(b);
            Network net = netList.getNetwork(ai, 0);
            if (net == null) {
                this.warn("Arc " + this.describe(ai) + " has no network!");
                continue;
            }
            ArrayList<ArcInst> arcsOnNet = (ArrayList<ArcInst>)seen.get(net);
            if (arcsOnNet == null) {
                arcsOnNet = new ArrayList<ArcInst>();
                seen.put(net, arcsOnNet);
            }
            boolean exists2 = false;
            for (ArcInst oldAI : arcsOnNet) {
                if (oldAI.getHeadPortInst().getPortProto() == ai.getHeadPortInst().getPortProto() && oldAI.getHeadPortInst().getNodeInst() == ai.getHeadPortInst().getNodeInst() && oldAI.getTailPortInst().getPortProto() == ai.getTailPortInst().getPortProto() && oldAI.getTailPortInst().getNodeInst() == ai.getTailPortInst().getNodeInst()) {
                    exists2 = true;
                    break;
                }
                if (oldAI.getHeadPortInst().getPortProto() != ai.getTailPortInst().getPortProto() || oldAI.getHeadPortInst().getNodeInst() != ai.getTailPortInst().getNodeInst() || oldAI.getTailPortInst().getPortProto() != ai.getHeadPortInst().getPortProto() || oldAI.getTailPortInst().getNodeInst() != ai.getHeadPortInst().getNodeInst()) continue;
                exists2 = true;
                break;
            }
            if (exists2) {
                String warnMsg = "Arc from (" + TextUtils.formatDistance(ai.getHeadLocation().getX()) + "," + TextUtils.formatDistance(ai.getHeadLocation().getY()) + ") to (" + TextUtils.formatDistance(ai.getTailLocation().getX()) + "," + TextUtils.formatDistance(ai.getTailLocation().getY()) + ") is redundant";
                ArrayList<EPoint> linesToShow = new ArrayList<EPoint>();
                linesToShow.add(EPoint.fromLambda(ai.getHeadLocation().getX(), ai.getHeadLocation().getY()));
                linesToShow.add(EPoint.fromLambda(ai.getTailLocation().getX(), ai.getTailLocation().getY()));
                this.warn(warnMsg, netList.getCell(), linesToShow, null);
                continue;
            }
            arcsOnNet.add(ai);
        }
        ArrayList<RoutesOnNetwork> allRoutes = new ArrayList<RoutesOnNetwork>();
        ArrayList<Network> allNets = new ArrayList<Network>();
        for (Network net : seen.keySet()) {
            allNets.add(net);
        }
        Collections.sort(allNets);
        for (Network net : allNets) {
            RoutesOnNetwork ron = new RoutesOnNetwork(net.getName());
            allRoutes.add(ron);
            List arcsOnNet = (List)seen.get(net);
            for (ArcInst ai : arcsOnNet) {
                ron.unroutedArcs.add(ai);
                if (ron.addUnorderedPort(ai.getHeadPortInst())) {
                    this.warn("Arc " + this.describe(ai) + " has an unconnectable end (on " + ai.getHeadPortInst().getNodeInst().describe(false) + ")");
                }
                if (!ron.addUnorderedPort(ai.getTailPortInst())) continue;
                this.warn("Arc " + this.describe(ai) + " has an unconnectable end (on " + ai.getTailPortInst().getNodeInst().describe(false) + ")");
            }
            if (this.sogp.isSteinerDone()) {
                for (ArcInst ai : arcsOnNet) {
                    ron.pairs.add(new SteinerTree.SteinerTreePortPair(ai.getHeadPortInst(), ai.getTailPortInst()));
                }
                continue;
            }
            if (this.prefs.enableSpineRouting && ron.setupSpineInfo()) continue;
            ArrayList<SteinerTree.SteinerTreePort> portList = new ArrayList<SteinerTree.SteinerTreePort>();
            for (PortInst pi : ron.unorderedPorts) {
                portList.add(new PortInstShadow(pi));
            }
            SteinerTree st = new SteinerTree(portList);
            ron.pairs = st.getTreeBranches();
            if (ron.pairs != null) continue;
            String errMsg = "Arcs in " + net.getName() + " do not make valid connection: deleted";
            this.error(errMsg);
            ArrayList<EPoint> lineList = new ArrayList<EPoint>();
            for (ArcInst delAi : ron.unroutedArcs) {
                lineList.add(delAi.getHeadLocation());
                lineList.add(delAi.getTailLocation());
            }
            this.errorLogger.logMessageWithLines(errMsg, null, lineList, this.cell, 0, true);
        }
        if (this.buildRTrees(netList, arcsToRoute, linesInNonMahnattan)) {
            this.info("Non-Manhattan geometry found");
        }
        this.totalBlockages = this.getNumBlockages();
        this.blockagesFound = 0;
        this.setProgressNote("Extract connectivity (" + this.totalBlockages + " blockages)");
        this.setProgressValue(0, 100);
        for (RoutesOnNetwork ron : allRoutes) {
            double minWidth = this.getMinWidth(ron.unorderedPorts);
            for (int i = 0; i < ron.pairs.size(); ++i) {
                ArcProto bArc;
                SteinerTree.SteinerTreePort obj2;
                SteinerTree.SteinerTreePort obj1 = ron.pairs.get(i).getPort1();
                if (obj1 instanceof PortInstShadow) {
                    obj1 = ((PortInstShadow)obj1).getPortInst();
                }
                if ((obj2 = ron.pairs.get(i).getPort2()) instanceof PortInstShadow) {
                    obj2 = ((PortInstShadow)obj2).getPortInst();
                }
                PortInst aPi = (PortInst)obj1;
                PortInst bPi = (PortInst)obj2;
                ArcProto aArc = this.getMetalArcOnPort(aPi);
                if (aArc == null || (bArc = this.getMetalArcOnPort(bPi)) == null) continue;
                NeededRoute nr = new NeededRoute(ron.netName, aPi, bPi, aArc, bArc, ron.spineTapPorts, minWidth);
                Iterator<ArcInst> it = ron.unroutedArcs.iterator();
                ArcInst sampleArc = it.next();
                Network net = netList.getNetwork(sampleArc, 0);
                nr.setNetID(net);
                nr.growNetwork();
                if (nr.invalidPort(true, aPi) || nr.invalidPort(false, bPi)) continue;
                ron.neededRoutes.add(nr);
            }
        }
        this.setProgressNote("Final Prepare for Routing...");
        this.setProgressValue(0, 100);
        TreeMap<Integer, TreeSet<RoutesOnNetwork>> uniqueNets = new TreeMap<Integer, TreeSet<RoutesOnNetwork>>();
        for (RoutesOnNetwork ron : allRoutes) {
            int netNumber = -1;
            for (NeededRoute nr : ron.neededRoutes) {
                int thisNetNumber = nr.netID.intValue();
                if (netNumber < 0) {
                    netNumber = thisNetNumber;
                }
                if (netNumber == thisNetNumber) continue;
                this.error("Error: network " + ron.netName + " has network IDs " + netNumber + " and " + thisNetNumber);
            }
            Integer id = netNumber;
            TreeSet<RoutesOnNetwork> mergedRoutes = (TreeSet<RoutesOnNetwork>)uniqueNets.get(id);
            if (mergedRoutes == null) {
                mergedRoutes = new TreeSet<RoutesOnNetwork>();
                uniqueNets.put(id, mergedRoutes);
            }
            mergedRoutes.add(ron);
        }
        ArrayList<RouteBatch> allBatches = new ArrayList<RouteBatch>();
        for (Integer netID : uniqueNets.keySet()) {
            Set mergedRoutes = (Set)uniqueNets.get(netID);
            RouteBatch rb = null;
            for (RoutesOnNetwork ron : mergedRoutes) {
                if (rb == null) {
                    rb = new RouteBatch(ron.netName);
                    allBatches.add(rb);
                }
                for (ArcInst ai : ron.unroutedArcs) {
                    rb.unroutedArcs.add(ai);
                    if (rb.isPwrGnd) continue;
                    Network net = netList.getNetwork(ai, 0);
                    Iterator<Export> it = net.getExports();
                    while (it.hasNext()) {
                        Export e = it.next();
                        if (!e.isGround() && !e.isPower()) continue;
                        rb.isPwrGnd = true;
                        break;
                    }
                    PortProto headPort = ai.getHeadPortInst().getPortProto();
                    PortProto tailPort = ai.getTailPortInst().getPortProto();
                    if (!headPort.isGround() && !headPort.isPower() && !tailPort.isGround() && !tailPort.isPower()) continue;
                    rb.isPwrGnd = true;
                }
                for (NeededRoute nr : ron.neededRoutes) {
                    nr.setBatchInfo(rb, rb.routesInBatch.size());
                    double dX = nr.getAX() - nr.getBX();
                    double dY = nr.getAY() - nr.getBY();
                    rb.length += Math.sqrt(dX * dX + dY * dY);
                    rb.addRoute(nr);
                }
            }
        }
        for (RouteBatch rb : allBatches) {
            for (NeededRoute nr : rb.routesInBatch) {
                nr.addBlockagesAtPorts(nr.aPi);
                nr.addBlockagesAtPorts(nr.bPi);
                if (nr.spineTaps == null) continue;
                for (PortInst pi : nr.spineTaps) {
                    nr.addBlockagesAtPorts(pi);
                }
            }
        }
        Collections.sort(allBatches);
        RouteBatch[] routeBatches = new RouteBatch[allBatches.size()];
        for (int i = 0; i < allBatches.size(); ++i) {
            routeBatches[i] = (RouteBatch)allBatches.get(i);
        }
        for (RouteBatch rb : allBatches) {
            for (NeededRoute nr : rb.routesInBatch) {
                if (nr.spineTaps != null) {
                    nr.routeName = nr.routeName + " (spine)";
                    continue;
                }
                if (((NeededRoute)nr).batch.routesInBatch.size() <= 1) continue;
                nr.routeName = nr.routeName + (" (" + (nr.routeInBatch + 1) + " of " + ((NeededRoute)nr).batch.routesInBatch.size() + ")");
            }
        }
        return routeBatches;
    }

    private ArcProto getMetalArcOnPort(PortInst pi) {
        ArcProto[] arcs = this.getPossibleConnections(pi.getPortProto());
        for (int j = 0; j < arcs.length; ++j) {
            if (arcs[j].getTechnology() != this.tech || !arcs[j].getFunction().isMetal()) continue;
            return arcs[j];
        }
        String errorMsg = "Cannot connect port " + pi.getPortProto().getName() + " of node " + this.describe(pi.getNodeInst()) + " because it has no metal connection in " + this.tech.getTechName() + " technology";
        this.error(errorMsg);
        ArrayList<Poly> polyList = new ArrayList<Poly>();
        polyList.add(pi.getPoly());
        this.errorLogger.logMessage(errorMsg, polyList, this.cell, 0, true);
        return null;
    }

    Runnable[] findPath(NeededRoute nr) {
        nr.makeWavefronts();
        if (nr.checkEndSurround()) {
            return null;
        }
        Wavefront d1 = nr.dirAtoB;
        Wavefront d2 = nr.dirBtoA;
        if (DBMath.rectsIntersect(d1.fromRect, d1.toRect) && d1.toZ == d1.fromZ) {
            double xVal = (Math.max(d1.fromRect.getMinX(), d1.toRect.getMinX()) + Math.min(d1.fromRect.getMaxX(), d1.toRect.getMaxX())) / 2.0;
            double yVal = (Math.max(d1.fromRect.getMinY(), d1.toRect.getMinY()) + Math.min(d1.fromRect.getMaxY(), d1.toRect.getMaxY())) / 2.0;
            SearchVertex sv = new SearchVertex(xVal, yVal, d1.toZ, d1.toC, 0, null, null, 0, d1, 0);
            if (nr.debuggingRouteFromA != null) {
                RoutingDebug.ensureDebuggingShadow(sv, false);
            }
            nr.completeRoute(sv);
            return null;
        }
        if (this.parallelDij) {
            DijkstraParallel aToB = new DijkstraParallel(d1, d2);
            DijkstraParallel bToA = new DijkstraParallel(d2, d1);
            return new Runnable[]{aToB, bToA};
        }
        return new Runnable[]{new DijkstraTwoWay(nr, d1, d2)};
    }

    private SearchVertex tryToFindPath(Wavefront a, Wavefront b) {
        SearchVertex bestSVA = null;
        SearchVertex bestSVB = null;
        double bestDistance = Double.MAX_VALUE;
        for (int z = 0; z < a.searchVertexPlanes.length; ++z) {
            Map<Integer, Map<Integer, SearchVertex>> plane = a.searchVertexPlanes[z];
            if (plane == null) continue;
            for (Integer y : plane.keySet()) {
                Map<Integer, SearchVertex> row = plane.get(y);
                if (row == null) continue;
                double yCoord = (double)y.intValue() / 400.0;
                for (Integer x : row.keySet()) {
                    double dY;
                    double dX;
                    SearchVertex prev;
                    SearchVertex foundInA = row.get(x);
                    double xCoord = (double)x.intValue() / 400.0;
                    SearchVertex foundInB = b.getVertex(xCoord, yCoord, z);
                    if (foundInB == null) continue;
                    double total = 0.0;
                    SearchVertex sv = foundInA;
                    while (sv != null && (prev = sv.last) != null) {
                        dX = sv.getX() - prev.getX();
                        dY = sv.getY() - prev.getY();
                        total += Math.sqrt(dX * dX + dY * dY);
                        if (sv.getZ() != prev.getZ()) {
                            total += 1.0;
                        }
                        sv = sv.last;
                    }
                    sv = foundInB;
                    while (sv != null && (prev = sv.last) != null) {
                        dX = sv.getX() - prev.getX();
                        dY = sv.getY() - prev.getY();
                        total += Math.sqrt(dX * dX + dY * dY);
                        if (sv.getZ() != prev.getZ()) {
                            total += 1.0;
                        }
                        sv = sv.last;
                    }
                    boolean better = DBMath.isLessThan(total, bestDistance);
                    if (!better) continue;
                    bestDistance = total;
                    bestSVA = foundInA;
                    bestSVB = foundInB;
                }
            }
        }
        if (bestSVA != null) {
            int i;
            System.out.println("Network " + a.nr.routeName + " failed in both directions, but found a common point at (" + TextUtils.formatDistance(bestSVA.xv) + "," + TextUtils.formatDistance(bestSVA.yv) + ")");
            ArrayList<SearchVertex> halfPath = new ArrayList<SearchVertex>();
            while (bestSVB != null) {
                halfPath.add(bestSVB);
                bestSVB = bestSVB.last;
            }
            ArrayList path = new ArrayList();
            Point2D lastSize = null;
            Rectangle2D[] lastCuts = null;
            int lastCutNumber = 0;
            for (i = 0; i < halfPath.size(); ++i) {
                SearchVertex thisOne = (SearchVertex)halfPath.get(i);
                Point2D thisSize = thisOne.size;
                Rectangle2D[] thisCuts = thisOne.getCutRects();
                int thisCutNumber = thisOne.zv & 0xFF;
                thisOne.size = lastSize;
                SearchVertex.access$12802(thisOne, lastCuts);
                thisOne.zv = thisOne.zv & 0xFFFFFF00 | lastCutNumber & 0xFF;
                lastSize = thisSize;
                lastCuts = thisCuts;
                lastCutNumber = thisCutNumber;
            }
            for (i = halfPath.size() - 1; i >= 0; --i) {
                path.add(halfPath.get(i));
            }
            while (bestSVA != null) {
                path.add(bestSVA);
                bestSVA = bestSVA.last;
            }
            for (i = 0; i < path.size() - 1; ++i) {
                SearchVertex sv1 = (SearchVertex)path.get(i);
                SearchVertex sv2 = (SearchVertex)path.get(i + 1);
                sv1.last = sv2;
            }
            ((SearchVertex)path.get(path.size() - 1)).last = null;
            SearchVertex result2 = (SearchVertex)path.get(0);
            result2.wf = a;
            return result2;
        }
        return null;
    }

    private double getMinWidth(List<PortInst> orderedPorts) {
        double minWidth = 0.0;
        for (PortInst pi : orderedPorts) {
            double widestAtPort = this.getWidestMetalArcOnPort(pi);
            if (!(widestAtPort > minWidth)) continue;
            minWidth = widestAtPort;
        }
        if (minWidth > this.prefs.maxArcWidth) {
            minWidth = this.prefs.maxArcWidth;
        }
        return minWidth;
    }

    private ArcProto[] getPossibleConnections(PortProto pp) {
        Export e;
        Variable var;
        ArcProto[] poss = pp.getBasePort().getConnections();
        if (pp instanceof Export && (var = (e = (Export)pp).getVar(Export.EXPORT_PREFERRED_ARCS)) != null) {
            String[] arcNames = (String[])var.getObject();
            ArcProto[] arcs = new ArcProto[arcNames.length];
            boolean allFound = true;
            for (int j = 0; j < arcNames.length; ++j) {
                arcs[j] = ArcProto.findArcProto(arcNames[j]);
                if (arcs[j] != null) continue;
                allFound = false;
            }
            if (allFound) {
                return arcs;
            }
        }
        return poss;
    }

    private static boolean inDestGrid(FixpRectangle toRectGridded, double x, double y) {
        if (x < toRectGridded.getMinX()) {
            return false;
        }
        if (x > toRectGridded.getMaxX()) {
            return false;
        }
        if (y < toRectGridded.getMinY()) {
            return false;
        }
        return !(y > toRectGridded.getMaxY());
    }

    private double cutDistance(double cut1LX, double cut1HX, double cut1LY, double cut1HY, double cut2LX, double cut2HX, double cut2LY, double cut2HY) {
        double cut1CornerY;
        double cut2CornerY;
        double cut1CornerX;
        double cut2CornerX;
        if (cut1LX <= cut2HX && cut1HX >= cut2LX) {
            if (cut1LY <= cut2HY && cut1HY >= cut2LY) {
                return 0.0;
            }
            if ((cut1LY + cut1HY) / 2.0 > (cut2LY + cut2HY) / 2.0) {
                return cut1LY - cut2HY;
            }
            return cut2LY - cut1HY;
        }
        if (cut1LY <= cut2HY && cut1HY >= cut2LY) {
            if ((cut1LX + cut1HX) / 2.0 > (cut2LX + cut2HX) / 2.0) {
                return cut1LX - cut2HX;
            }
            return cut2LX - cut1HX;
        }
        if ((cut2LX + cut2HX) / 2.0 < (cut1LX + cut1HX) / 2.0) {
            cut2CornerX = cut2HX;
            cut1CornerX = cut1LX;
        } else {
            cut2CornerX = cut2LX;
            cut1CornerX = cut1HX;
        }
        if ((cut2LY + cut2HY) / 2.0 < (cut1LY + cut1HY) / 2.0) {
            cut2CornerY = cut2HY;
            cut1CornerY = cut1LY;
        } else {
            cut2CornerY = cut2LY;
            cut1CornerY = cut1HY;
        }
        double dX = cut2CornerX - cut1CornerX;
        double dY = cut2CornerY - cut1CornerY;
        return Math.sqrt(dX * dX + dY * dY);
    }

    private double getWidestMetalArcOnPort(PortInst pi) {
        Export export;
        PortInst exportedInst;
        double width2;
        double width = 0.0;
        Iterator<Connection> it = pi.getConnections();
        while (it.hasNext()) {
            double newWidth;
            Connection c = it.next();
            ArcInst ai = c.getArc();
            if (this.sogp.isPrevented(ai.getProto()) || !ai.getProto().getFunction().isMetal() || !((newWidth = ai.getLambdaBaseWidth()) > width)) continue;
            width = newWidth;
        }
        NodeInst ni = pi.getNodeInst();
        if (ni.isCellInstance() && (width2 = this.getWidestMetalArcOnPort(exportedInst = (export = (Export)pi.getPortProto()).getOriginalPort())) > width) {
            width = width2;
        }
        return width;
    }

    void getOptimizedList(SearchVertex initialThread, List<SearchVertex> realVertices) {
        realVertices.clear();
        SearchVertex thread = initialThread;
        if (thread != null) {
            SearchVertex lastVertex = thread;
            realVertices.add(lastVertex);
            thread = thread.last;
            while (thread != null) {
                if (lastVertex.getZ() != thread.getZ()) {
                    realVertices.add(thread);
                    lastVertex = thread;
                    thread = thread.last;
                    continue;
                }
                double dx = thread.getX() - lastVertex.getX();
                double dy = thread.getY() - lastVertex.getY();
                lastVertex = thread;
                thread = thread.last;
                while (!(thread == null || lastVertex.getZ() != thread.getZ() || dx == 0.0 && thread.getX() - lastVertex.getX() != 0.0 || dy == 0.0 && thread.getY() - lastVertex.getY() != 0.0)) {
                    lastVertex = thread;
                    thread = thread.last;
                }
                realVertices.add(lastVertex);
            }
        }
    }

    private int getNumBlockages() {
        int total = 0;
        for (int i = 0; i < numMetalLayers; ++i) {
            BlockageTree bTree = this.rTrees.getMetalTree(this.primaryMetalLayer[i]);
            if (bTree.root == null) continue;
            total += this.getNumLeafs(bTree.root);
        }
        return total;
    }

    private int getNumLeafs(RTNode<SOGBound> branch) {
        int total = 0;
        for (int i = 0; i < branch.getTotal(); ++i) {
            if (branch.getFlag()) {
                ++total;
                continue;
            }
            RTNode<SOGBound> subrt = branch.getChildTree(i);
            total += this.getNumLeafs(subrt);
        }
        return total;
    }

    private boolean buildRTrees(Netlist netList, List<ArcInst> arcsToRoute, List<EPoint> linesInNonMahnattan) {
        this.rTrees = new BlockageTrees(numMetalLayers);
        MutableInteger nextNetNumber = new MutableInteger(1);
        HashMap<Network, Integer> netNumbers = new HashMap<Network, Integer>();
        for (ArcInst ai : arcsToRoute) {
            Network net = netList.getNetwork(ai, 0);
            Integer netNumber = (Integer)netNumbers.get(net);
            if (netNumber != null) continue;
            netNumber = nextNetNumber.intValue() << 4;
            netNumbers.put(net, netNumber);
            if (RoutingDebug.isActive()) {
                RoutingDebug.setNetName(netNumber, net.getName());
            }
            nextNetNumber.increment();
            this.netIDs.put(net, netNumber);
        }
        this.setProgressNote("Find blockages...");
        this.setProgressValue(0, 100);
        this.removeGeometry = new HashMap<Layer, List<Rectangle2D>>();
        boolean retval = this.addArea(this.cell, this.cellBounds, Orientation.IDENT.pureRotate(), true, nextNetNumber, linesInNonMahnattan);
        List<SeaOfGates.SeaOfGatesExtraBlockage> list = this.sogp.getBlockages();
        for (SeaOfGates.SeaOfGatesExtraBlockage sogeb : list) {
            Rectangle2D.Double bounds = new Rectangle2D.Double(sogeb.getLX(), sogeb.getLY(), sogeb.getHX() - sogeb.getLX(), sogeb.getHY() - sogeb.getLY());
            int metNo = sogeb.getLayer().getFunction().getLevel() - 1;
            Layer layer = this.primaryMetalLayer[metNo];
            Integer nn = nextNetNumber.intValue() << 4 | 8;
            nextNetNumber.increment();
            MutableInteger netID = new MutableInteger(nn);
            this.addRectangle(bounds, layer, netID, false, false);
        }
        for (Layer metLayer : this.removeGeometry.keySet()) {
            List<Rectangle2D> removeRects = this.removeGeometry.get(metLayer);
            for (Rectangle2D rect : removeRects) {
                int metNum = metLayer.getFunction().getLevel() - 1;
                int metCol = metLayer.getFunction().getMaskColor();
                Layer primaryMetLayer = this.primaryMetalLayer[metNum];
                BlockageTree bTree = this.rTrees.getMetalTree(primaryMetLayer);
                ArrayList<SOGBound> thingsThatGetRemoved = new ArrayList<SOGBound>();
                Iterator sea = bTree.search(rect);
                while (sea.hasNext()) {
                    ERectangle bound;
                    SOGBound sBound = (SOGBound)sea.next();
                    if (sBound.maskLayer != metCol || ((RectangularShape)(bound = sBound.getBounds())).getMaxX() <= rect.getMinX() || ((RectangularShape)bound).getMinX() >= rect.getMaxX() || ((RectangularShape)bound).getMaxY() <= rect.getMinY() || ((RectangularShape)bound).getMinY() >= rect.getMaxY()) continue;
                    thingsThatGetRemoved.add(sBound);
                }
                RTNode<SOGBound> rootFixp = bTree.getRoot();
                for (SOGBound s2 : thingsThatGetRemoved) {
                    RTNode<SOGBound> newRootFixp = RTNode.unLinkGeom(null, rootFixp, s2);
                    if (newRootFixp == rootFixp) continue;
                    rootFixp = newRootFixp;
                    bTree.setRoot(rootFixp);
                }
                for (SOGBound s2 : thingsThatGetRemoved) {
                    PolyMerge merge = new PolyMerge();
                    merge.addRectangle(metLayer, s2.bound);
                    merge.subtract(metLayer, new Poly(rect));
                    List<PolyBase> remaining = merge.getMergedPoints(metLayer, true);
                    for (PolyBase pb : remaining) {
                        ERectangle reducedBound = ERectangle.fromLambda(pb.getBounds2D());
                        SOGBound sogb = new SOGBound(reducedBound, s2.getNetID(), s2.maskLayer);
                        RTNode<SOGBound> newRootFixp = RTNode.linkGeom(null, rootFixp, sogb);
                        if (newRootFixp == rootFixp) continue;
                        rootFixp = newRootFixp;
                        bTree.setRoot(rootFixp);
                    }
                }
            }
        }
        return retval;
    }

    private boolean addArea(Cell cell, Rectangle2D bounds, FixpTransform transToTop, boolean topLevel, MutableInteger nextNetNumber, List<EPoint> linesInNonMahnattan) {
        boolean hasNonmanhattan = false;
        int numCells = 0;
        Iterator<Geometric> it = cell.searchIterator(bounds);
        while (it.hasNext()) {
            Geometric geom = it.next();
            if (geom instanceof NodeInst) {
                NodeInst ni = (NodeInst)geom;
                if (ni.isCellInstance()) {
                    ++numCells;
                    continue;
                }
                PrimitiveNode pNp = (PrimitiveNode)ni.getProto();
                if (pNp.getFunction() == PrimitiveNode.Function.PIN) continue;
                FixpTransform nodeTrans = ni.rotateOut(transToTop);
                Technology tech = pNp.getTechnology();
                Poly[] nodeInstPolyList = tech.getShapeOfNode(ni, true, false, null);
                MutableInteger netNumber = null;
                List<Integer> exclusionLayers = null;
                if (pNp == Generic.tech().routeNode) {
                    Integer nn = nextNetNumber.intValue() << 4;
                    nextNetNumber.increment();
                    netNumber = new MutableInteger(nn);
                    exclusionLayers = this.parseExclusionLayers(ni);
                }
                for (int i = 0; i < nodeInstPolyList.length; ++i) {
                    Poly poly = nodeInstPolyList[i];
                    if (exclusionLayers != null) {
                        for (Integer lay : exclusionLayers) {
                            poly.setLayer(this.primaryMetalLayer[lay]);
                            if (!this.addLayer(poly, nodeTrans, netNumber, false, linesInNonMahnattan, true)) continue;
                            hasNonmanhattan = true;
                        }
                        continue;
                    }
                    if (!this.addLayer(poly, nodeTrans, netNumber, false, linesInNonMahnattan, true)) continue;
                    hasNonmanhattan = true;
                }
                continue;
            }
            ArcInst ai = (ArcInst)geom;
            if (ai.getProto() == Generic.tech().unrouted_arc) continue;
            Technology tech = ai.getProto().getTechnology();
            Poly[] polys = tech.getShapeOfArc(ai);
            for (int i = 0; i < polys.length; ++i) {
                Poly poly = polys[i];
                if (!this.addLayer(poly, transToTop, null, false, linesInNonMahnattan, true)) continue;
                hasNonmanhattan = true;
            }
        }
        int cellCount = 0;
        Iterator<Geometric> it2 = cell.searchIterator(bounds);
        while (it2.hasNext()) {
            NodeInst ni;
            Geometric geom = it2.next();
            if (!(geom instanceof NodeInst) || !(ni = (NodeInst)geom).isCellInstance()) continue;
            if (topLevel) {
                this.setProgressValue(++cellCount, numCells + 1);
            }
            Rectangle2D.Double subBounds = new Rectangle2D.Double(bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight());
            DBMath.transformRect(subBounds, ni.transformIn());
            FixpTransform transBack = ni.transformOut(transToTop);
            this.addArea((Cell)ni.getProto(), subBounds, transBack, false, nextNetNumber, linesInNonMahnattan);
        }
        return hasNonmanhattan;
    }

    private List<Integer> parseExclusionLayers(NodeInst ni) {
        ArrayList<Integer> exclusionLayers = new ArrayList<Integer>();
        String layers = "";
        Variable var = ni.getVar(Generic.ROUTING_EXCLUSION);
        if (var != null) {
            layers = var.getPureValue(-1);
        }
        layers.replaceAll(" ", "");
        if (layers.length() == 0) {
            return exclusionLayers;
        }
        if (layers.equalsIgnoreCase("all")) {
            for (int i = 0; i < this.getNumMetals(); ++i) {
                exclusionLayers.add(i);
            }
            return exclusionLayers;
        }
        int pt = 0;
        while (pt < layers.length()) {
            int layNum = TextUtils.atoi(layers.substring(pt));
            while (pt < layers.length() && Character.isDigit(layers.charAt(pt))) {
                ++pt;
            }
            if (pt >= layers.length() || layers.charAt(pt) == ',') {
                exclusionLayers.add(layNum - 1);
                if (pt >= layers.length()) continue;
                ++pt;
                continue;
            }
            if (layers.charAt(pt) != '-' || pt >= layers.length() - 1) {
                System.out.println("ERROR: Routing exclusion node " + ni.describe(false) + " has invalid exclusion description: " + layers);
                break;
            }
            int layEnd = TextUtils.atoi(layers.substring(++pt));
            while (pt < layers.length() && Character.isDigit(layers.charAt(pt))) {
                ++pt;
            }
            for (int i = layNum; i <= layEnd; ++i) {
                exclusionLayers.add(i - 1);
            }
            if (pt >= layers.length()) continue;
            if (layers.charAt(pt) != ',') {
                System.out.println("ERROR: Routing exclusion node " + ni.describe(false) + " has invalid exclusion description: " + layers);
                break;
            }
            ++pt;
        }
        return exclusionLayers;
    }

    private boolean addLayer(PolyBase poly, FixpTransform trans, MutableInteger netID, boolean lockTree, List<EPoint> linesInNonMahnattan, boolean merge) {
        boolean isNonmanhattan = false;
        Layer layer = poly.getLayer();
        Layer.Function fun = layer.getFunction();
        Layer removeAp = this.removeLayers.get(layer);
        if (removeAp != null) {
            List<Rectangle2D> geomsToRemove = this.removeGeometry.get(removeAp);
            if (geomsToRemove == null) {
                geomsToRemove = new ArrayList<Rectangle2D>();
                this.removeGeometry.put(removeAp, geomsToRemove);
            }
            poly.transform(trans);
            FixpRectangle bounds = poly.getBox();
            if (bounds == null) {
                return true;
            }
            geomsToRemove.add(bounds);
            return false;
        }
        if (fun.isMetal()) {
            if (poly.getStyle() != Poly.Type.FILLED) {
                return false;
            }
            poly.transform(trans);
            FixpRectangle bounds = poly.getBox();
            if (bounds == null) {
                this.addPolygon(poly, layer, netID, lockTree);
                PolyBase.Point[] points = poly.getPoints();
                for (int i = 1; i < points.length; ++i) {
                    if (points[i - 1].getX() == points[i].getX() || points[i - 1].getY() == points[i].getY()) continue;
                    isNonmanhattan = true;
                    linesInNonMahnattan.add(EPoint.fromLambda(points[i - 1].getX(), points[i - 1].getY()));
                    linesInNonMahnattan.add(EPoint.fromLambda(points[i].getX(), points[i].getY()));
                }
            } else {
                this.addRectangle(bounds, layer, netID, lockTree, merge);
            }
        } else if (fun.isContact()) {
            FixpRectangle bounds = poly.getBounds2D();
            DBMath.transformRect((Rectangle2D)bounds, trans);
            this.addVia(ERectangle.fromLambda(bounds), layer, netID, lockTree);
        }
        return isNonmanhattan;
    }

    public static String describeMetal(int metal, int color) {
        String ret = "M" + (metal + 1);
        if (color > 0) {
            ret = ret + (char)(97 + color - 1);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SOGBound addRectangle(Rectangle2D bounds, Layer layer, MutableInteger netID, boolean lockTree, boolean merge) {
        RTNode<Object> rootFixp;
        SOGBound sogb = null;
        BlockageTree bTree = this.rTrees.getMetalTree(layer);
        if (merge) {
            ArrayList<SOGBound> removeThese = null;
            Iterator sea = bTree.search(bounds);
            while (sea.hasNext()) {
                SOGBound sBound = (SOGBound)sea.next();
                if (sBound instanceof SOGPoly) continue;
                if (sBound.bound.getMinX() <= bounds.getMinX() && sBound.bound.getMaxX() >= bounds.getMaxX() && sBound.bound.getMinY() <= bounds.getMinY() && sBound.bound.getMaxY() >= bounds.getMaxY()) {
                    return null;
                }
                if (!(bounds.getMinX() <= sBound.bound.getMinX()) || !(bounds.getMaxX() >= sBound.bound.getMaxX()) || !(bounds.getMinY() <= sBound.bound.getMinY()) || !(bounds.getMaxY() >= sBound.bound.getMaxY())) continue;
                if (removeThese == null) {
                    removeThese = new ArrayList<SOGBound>();
                }
                removeThese.add(sBound);
            }
            if (removeThese != null) {
                if (lockTree) {
                    bTree.lock();
                }
                try {
                    rootFixp = bTree.getRoot();
                    for (SOGBound s2 : removeThese) {
                        RTNode<SOGBound> newRootFixp = RTNode.unLinkGeom(null, rootFixp, s2);
                        if (newRootFixp == rootFixp) continue;
                        rootFixp = newRootFixp;
                        bTree.setRoot(rootFixp);
                    }
                }
                finally {
                    if (lockTree) {
                        bTree.unlock();
                    }
                }
            }
        }
        if (lockTree) {
            bTree.lock();
        }
        try {
            RTNode<SOGBound> newRootFixp;
            int maskLayer = layer.getFunction().getMaskColor();
            sogb = new SOGBound(ERectangle.fromLambda(bounds), netID, maskLayer);
            rootFixp = bTree.getRoot();
            if (rootFixp == null) {
                rootFixp = RTNode.makeTopLevel();
                bTree.setRoot(rootFixp);
            }
            if ((newRootFixp = RTNode.linkGeom(null, rootFixp, sogb)) != rootFixp) {
                bTree.setRoot(newRootFixp);
            }
        }
        finally {
            if (lockTree) {
                bTree.unlock();
            }
        }
        return sogb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPolygon(PolyBase poly, Layer layer, MutableInteger netID, boolean lockTree) {
        BlockageTree bTree = this.rTrees.getMetalTree(layer);
        if (lockTree) {
            bTree.lock();
        }
        try {
            RTNode<SOGPoly> newRootFixp;
            int maskLayer = layer.getFunction().getMaskColor();
            SOGPoly sogb = new SOGPoly(ERectangle.fromLambda(poly.getBounds2D()), netID, poly, maskLayer);
            RTNode rootFixp = bTree.getRoot();
            if (rootFixp == null) {
                rootFixp = RTNode.makeTopLevel();
                bTree.setRoot(rootFixp);
            }
            if ((newRootFixp = RTNode.linkGeom(null, rootFixp, sogb)) != rootFixp) {
                bTree.setRoot(newRootFixp);
            }
        }
        finally {
            if (lockTree) {
                bTree.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addVia(ERectangle rect, Layer layer, MutableInteger netID, boolean lockTree) {
        BlockageTree bTree = this.rTrees.getViaTree(layer);
        if (lockTree) {
            bTree.lock();
        }
        try {
            RTNode<SOGVia> newRootFixp;
            SOGVia sogb = new SOGVia(rect, netID);
            RTNode rootFixp = bTree.getRoot();
            if (rootFixp == null) {
                rootFixp = RTNode.makeTopLevel();
                bTree.setRoot(rootFixp);
            }
            if ((newRootFixp = RTNode.linkGeom(null, rootFixp, sogb)) != rootFixp) {
                bTree.setRoot(newRootFixp);
            }
        }
        finally {
            if (lockTree) {
                bTree.unlock();
            }
        }
    }

    public GlobalRouter doGlobalRouting(Cell cell, RouteBatch[] routeBatches, RouteBatch[] fakeBatches, double wirePitch) {
        GlobalRouter gr = new GlobalRouter(cell, routeBatches, fakeBatches, wirePitch);
        gr.solve();
        return gr;
    }

    private static class GRWavefrontPoint
    implements Comparable<GRWavefrontPoint> {
        private GRBucket n;
        private double cost;

        public GRWavefrontPoint(GRBucket n, double c) {
            this.n = n;
            this.cost = c;
        }

        public GRBucket getBucket() {
            return this.n;
        }

        public double getCost() {
            return this.cost;
        }

        @Override
        public int compareTo(GRWavefrontPoint other) {
            if (this.cost < other.cost) {
                return -1000000000;
            }
            if (this.cost > other.cost) {
                return 1000000000;
            }
            return this.n.compareTo(other.n);
        }
    }

    private static class GRPathElement {
        private GRBucket n;
        private GREdge e;

        public GRPathElement(GRBucket n, GREdge e) {
            this.n = n;
            this.e = e;
        }

        public GRBucket getBucket() {
            return this.n;
        }

        public GREdge getEdge() {
            return this.e;
        }
    }

    private static class GREdge {
        private GRBucket n1;
        private GRBucket n2;
        private int current;
        private final int capacity;
        private final double minCost;
        private final double maxCost;

        public GREdge(GRBucket n1, GRBucket n2, int cap) {
            this.n1 = n1;
            this.n2 = n2;
            this.current = 0;
            this.minCost = 1.0;
            this.maxCost = 16.0;
            this.capacity = cap;
            n1.addEdge(this);
            n2.addEdge(this);
        }

        public void changeCurrentValue(int delta) {
            this.current += delta;
        }

        public GRBucket getOtherOne(GRBucket thisOne) {
            return thisOne == this.n1 ? this.n2 : this.n1;
        }

        double usageCost() {
            if (this.current <= 0) {
                return this.minCost;
            }
            if (this.current >= this.capacity) {
                return this.maxCost;
            }
            double ratio = (double)this.current / (double)this.capacity;
            return this.minCost + (this.maxCost - this.minCost) * ratio;
        }
    }

    public static class GRWire {
        private GRBucket n1;
        private GRBucket n2;
        private EPoint pt1;
        private EPoint pt2;
        private List<GRPathElement> path;
        private NeededRoute nr;

        public GRWire(NeededRoute nr, GRBucket n1, GRBucket n2, EPoint pt1, EPoint pt2) {
            this.nr = nr;
            this.n1 = n1;
            this.n2 = n2;
            this.pt1 = pt1;
            this.pt2 = pt2;
        }

        public void setPathOnRoute() {
            NeededRoute.access$002(this.nr, new Rectangle2D[this.path.size()]);
            for (int i = 0; i < this.path.size(); ++i) {
                ((NeededRoute)this.nr).buckets[i] = this.path.get(i).getBucket().bounds;
            }
        }

        public int getNumPathElements() {
            return this.path.size();
        }

        public GRBucket getPathBucket(int index) {
            return this.path.get(index).getBucket();
        }

        public GRBucket getBucket1() {
            return this.n1;
        }

        public GRBucket getBucket2() {
            return this.n2;
        }

        public EPoint getPoint1() {
            return this.pt1;
        }

        public EPoint getPoint2() {
            return this.pt2;
        }

        public NeededRoute getNeededRoute() {
            return this.nr;
        }

        private void addPath(int width) {
            for (GRPathElement pe : this.path) {
                if (pe.getEdge() == null) continue;
                pe.getEdge().changeCurrentValue(width);
            }
        }

        /*
         * Unable to fully structure code
         */
        private boolean setShortestPath() {
            start = this.n1;
            finish = this.n2;
            this.path = new ArrayList<GRPathElement>();
            if (start == finish) {
                return false;
            }
            h = new TreeSet<GRWavefrontPoint>();
            clean = new ArrayList<GRBucket>();
            current = start;
            h.add(new GRWavefrontPoint(current, 0.0));
            while (true) {
                if ((it = h.iterator()).hasNext()) {
                    he = (GRWavefrontPoint)it.next();
                    current = he.getBucket();
                    h.remove(he);
                    if (current.getCost() != he.getCost()) {
                        continue;
                    }
                } else {
                    current = null;
                }
                if (current == null || current == finish) break;
                i$ = current.getEdges().iterator();
                while (true) {
                    if (!i$.hasNext()) ** break;
                    e = i$.next();
                    next = e.getOtherOne(current);
                    if (next == start) continue;
                    cost = current.getCost() + e.usageCost();
                    if (next.getPrevEdge() != null && !(next.getCost() > cost)) continue;
                    next.setCost(cost);
                    h.add(new GRWavefrontPoint(next, cost));
                    if (next.getPrevEdge() == null) {
                        clean.add(next);
                    }
                    next.setPrevEdge(e);
                }
                break;
            }
            if (current == finish) {
                while (current != null) {
                    pe = new GRPathElement(current, current.getPrevEdge());
                    this.path.add(pe);
                    current = pe.getEdge() == null ? null : pe.getEdge().getOtherOne(current);
                }
            } else {
                return true;
            }
            Collections.reverse(this.path);
            for (GRBucket n : clean) {
                n.setPrevEdge(null);
                n.setCost(0.0);
            }
            return false;
        }
    }

    public static class GRNet {
        private List<GRWire> wires = new ArrayList<GRWire>();

        GRNet() {
        }

        public void addWire(GRWire w) {
            this.wires.add(w);
        }

        public List<GRWire> getWires() {
            return this.wires;
        }
    }

    public static class GRBucket
    implements Comparable<GRBucket> {
        private int id;
        private Rectangle2D bounds;
        private List<GREdge> edges;
        private double cost;
        private GREdge prev;

        public GRBucket(int id, Rectangle2D bounds) {
            this.id = id;
            this.bounds = bounds;
            this.edges = new ArrayList<GREdge>();
        }

        public Rectangle2D getBounds() {
            return this.bounds;
        }

        public double getCost() {
            return this.cost;
        }

        public void setCost(double c) {
            this.cost = c;
        }

        public GREdge getPrevEdge() {
            return this.prev;
        }

        public void setPrevEdge(GREdge e) {
            this.prev = e;
        }

        public void addEdge(GREdge e) {
            this.edges.add(e);
        }

        public List<GREdge> getEdges() {
            return this.edges;
        }

        public String toString() {
            return "BUCKET-" + this.id;
        }

        @Override
        public int compareTo(GRBucket other) {
            return this.id - other.id;
        }
    }

    public class GlobalRouter {
        private int numXBuckets;
        private int numYBuckets;
        private GRBucket[] buckets;
        private GREdge[] edges;
        private List<GRNet> nets;

        public List<GRNet> getNets() {
            return this.nets;
        }

        public int getXBuckets() {
            return this.numXBuckets;
        }

        public int getYBuckets() {
            return this.numYBuckets;
        }

        public GlobalRouter(Cell c, RouteBatch[] routeBatches, RouteBatch[] fakeBatches, double wirePitch) {
            int eid;
            int y;
            int x;
            ERectangle bounds;
            int size2;
            int total = 0;
            for (RouteBatch rb : routeBatches) {
                total += rb.routesInBatch.size();
            }
            if (fakeBatches != null) {
                for (RouteBatch rb : fakeBatches) {
                    total += rb.routesInBatch.size();
                }
            }
            if ((size2 = (int)Math.sqrt(total)) < 2) {
                size2 = 2;
            }
            if ((bounds = c.getBounds()).getWidth() > bounds.getHeight()) {
                this.numXBuckets = size2;
                this.numYBuckets = (int)Math.round((double)size2 * bounds.getHeight() / bounds.getWidth());
                if (this.numYBuckets < 2) {
                    this.numYBuckets = 2;
                }
            } else {
                this.numXBuckets = (int)Math.round((double)size2 * bounds.getWidth() / bounds.getHeight());
                if (this.numXBuckets < 2) {
                    this.numXBuckets = 2;
                }
                this.numYBuckets = size2;
            }
            double bucketWidth = bounds.getWidth() / (double)this.numXBuckets;
            double bucketHeight = bounds.getHeight() / (double)this.numYBuckets;
            int capacity = (int)Math.round(bucketWidth / wirePitch);
            if (capacity < 1) {
                capacity = 1;
            }
            this.buckets = new GRBucket[this.numXBuckets * this.numYBuckets];
            int t = 0;
            for (int y2 = 0; y2 < this.numYBuckets; ++y2) {
                for (int x2 = 0; x2 < this.numXBuckets; ++x2) {
                    double lX = bounds.getMinX() + (double)x2 * bucketWidth;
                    double hX = lX + bucketWidth;
                    double lY = bounds.getMinY() + (double)y2 * bucketHeight;
                    double hY = lY + bucketHeight;
                    this.buckets[t++] = new GRBucket(t, new Rectangle2D.Double(lX, lY, hX - lX, hY - lY));
                }
            }
            int numEdges = this.numXBuckets * (this.numYBuckets - 1) + this.numYBuckets * (this.numXBuckets - 1);
            this.edges = new GREdge[numEdges];
            int e = 0;
            for (x = 0; x < this.numXBuckets; ++x) {
                for (y = 1; y < this.numYBuckets; ++y) {
                    int sid = y * this.numXBuckets + x;
                    eid = (y - 1) * this.numXBuckets + x;
                    this.edges[e++] = new GREdge(this.buckets[sid], this.buckets[eid], capacity);
                }
            }
            for (x = 1; x < this.numXBuckets; ++x) {
                for (y = 0; y < this.numYBuckets; ++y) {
                    int sid = y * this.numXBuckets + x;
                    eid = y * this.numXBuckets + (x - 1);
                    this.edges[e++] = new GREdge(this.buckets[sid], this.buckets[eid], capacity);
                }
            }
            this.nets = new ArrayList<GRNet>();
            this.addBatches(routeBatches, bounds, bucketWidth, bucketHeight);
            if (fakeBatches != null) {
                this.addBatches(fakeBatches, bounds, bucketWidth, bucketHeight);
            }
        }

        private void addBatches(RouteBatch[] batches, ERectangle bounds, double bucketWidth, double bucketHeight) {
            for (RouteBatch rb : batches) {
                GRNet nn = null;
                for (NeededRoute nr : rb.routesInBatch) {
                    int x1 = (int)((nr.aX - bounds.getMinX()) / bucketWidth);
                    int y1 = (int)((nr.aY - bounds.getMinY()) / bucketHeight);
                    int x2 = (int)((nr.bX - bounds.getMinX()) / bucketWidth);
                    int bucket1 = y1 * this.numXBuckets + x1;
                    int y2 = (int)((nr.bY - bounds.getMinY()) / bucketHeight);
                    int bucket2 = y2 * this.numXBuckets + x2;
                    if (bucket1 == bucket2) continue;
                    if (nn == null) {
                        nn = new GRNet();
                        this.nets.add(nn);
                    }
                    GRWire w = new GRWire(nr, this.buckets[bucket1], this.buckets[bucket2], EPoint.fromLambda(nr.aX, nr.aY), EPoint.fromLambda(nr.bX, nr.bY));
                    nn.addWire(w);
                }
            }
        }

        public void solve() {
            ElapseTimer theTimer = ElapseTimer.createInstance().start();
            this.route();
            theTimer.end();
            SeaOfGatesEngine.this.info("Global routing: initialized (took " + theTimer + ")");
            int iterations = 4;
            for (int iteration = 0; iteration < iterations; ++iteration) {
                theTimer.start();
                this.ripupReroute();
                theTimer.end();
                SeaOfGatesEngine.this.info("Global routing: Rip-up and reroute pass " + iteration + " (took " + theTimer + ")");
            }
            for (GRNet net : this.nets) {
                for (GRWire wire : net.wires) {
                    wire.setPathOnRoute();
                }
            }
        }

        private void route() {
            for (GRNet net : this.nets) {
                for (GRWire w : net.getWires()) {
                    if (w.setShortestPath()) {
                        SeaOfGatesEngine.this.error("ERROR: No path from " + w.n1 + " to " + w.n2);
                    }
                    w.addPath(1);
                }
            }
        }

        private void ripupReroute() {
            for (GRNet net : this.nets) {
                for (GRWire w : net.getWires()) {
                    w.addPath(-1);
                    if (w.setShortestPath()) {
                        SeaOfGatesEngine.this.error("ERROR: No path from " + w.n1 + " to " + w.n2);
                    }
                    w.addPath(1);
                }
            }
        }
    }

    public static class SOGVia
    extends SOGBound {
        SOGVia(ERectangle rect, MutableInteger netID) {
            super(rect, netID, 0);
        }

        @Override
        public String toString() {
            return "SOGVia on net " + this.getNetID();
        }
    }

    public static class SOGPoly
    extends SOGBound {
        private PolyBase poly;

        SOGPoly(ERectangle bound, MutableInteger netID, PolyBase poly, int maskLayer) {
            super(bound, netID, maskLayer);
            this.poly = poly;
        }

        @Override
        public boolean containsPoint(double x, double y) {
            return this.poly.isInside(new Point2D.Double(x, y));
        }

        @Override
        public boolean isManhattan() {
            PolyBase.Point[] pts = this.poly.getPoints();
            for (int i = 1; i < pts.length; ++i) {
                if (pts[i].getX() == pts[i - 1].getX() || pts[i].getY() == pts[i - 1].getY()) continue;
                return false;
            }
            return true;
        }

        public PolyBase getPoly() {
            return this.poly;
        }
    }

    public static class SOGBound
    extends SOGNetID
    implements RTBounds {
        private ERectangle bound;
        private int maskLayer;

        SOGBound(ERectangle bound, MutableInteger netID, int maskLayer) {
            super(netID);
            this.bound = bound;
            this.maskLayer = maskLayer;
        }

        @Override
        public ERectangle getBounds() {
            return this.bound;
        }

        public boolean containsPoint(double x, double y) {
            return x >= this.bound.getMinX() && x <= this.bound.getMaxX() && y >= this.bound.getMinY() && y <= this.bound.getMaxY();
        }

        public boolean isManhattan() {
            return true;
        }

        public String toString() {
            return "SOGBound on net " + this.getNetID();
        }
    }

    public static class SOGNetID {
        private MutableInteger netID;

        SOGNetID(MutableInteger netID) {
            this.netID = netID;
        }

        public MutableInteger getNetID() {
            return this.netID;
        }

        public void setNetID(MutableInteger n) {
            this.netID = n;
        }

        public void updateNetID(MutableInteger n, Map<Integer, List<MutableInteger>> netIDsByValue) {
            if (this.isSameBasicNet(n)) {
                return;
            }
            List<MutableInteger> oldNetIDs = netIDsByValue.get(this.netID.intValue());
            if (oldNetIDs == null) {
                return;
            }
            List<MutableInteger> newNetIDs = netIDsByValue.get(n.intValue());
            for (MutableInteger mi : oldNetIDs) {
                mi.setValue(n.intValue());
                newNetIDs.add(mi);
            }
            oldNetIDs.clear();
        }

        public boolean isSameBasicNet(MutableInteger otherNetID) {
            int netValue = 0;
            if (this.netID != null) {
                netValue = this.netID.intValue();
            }
            return netValue >> 4 == otherNetID.intValue() >> 4;
        }

        public boolean isPseudoBlockage() {
            if (this.netID == null) {
                return false;
            }
            return (this.netID.intValue() & 1) != 0;
        }

        public boolean isUserSuppliedBlockage() {
            if (this.netID == null) {
                return false;
            }
            return (this.netID.intValue() & 8) != 0;
        }
    }

    private class BlockageTrees {
        private final BlockageTree[] metalTrees;
        private final BlockageTree[] viaTrees;

        BlockageTrees(int numMetals) {
            this.metalTrees = new BlockageTree[numMetals];
            this.viaTrees = new BlockageTree[numMetals];
            for (int i = 0; i < this.metalTrees.length; ++i) {
                this.metalTrees[i] = new BlockageTree(null);
                this.viaTrees[i] = new BlockageTree(null);
            }
        }

        private BlockageTree getMetalTree(Layer lay) {
            if (lay == null) {
                return BlockageTree.emptyTree;
            }
            return this.metalTrees[lay.getFunction().getLevel() - 1];
        }

        private BlockageTree getViaTree(Layer lay) {
            if (lay == null) {
                return BlockageTree.emptyTree;
            }
            return this.viaTrees[lay.getFunction().getLevel() - 1];
        }
    }

    private static class BlockageTree {
        private final ReentrantLock lock = new ReentrantLock();
        private RTNode<SOGBound> root;
        public static BlockageTree emptyTree = new BlockageTree(null);

        private BlockageTree(RTNode<SOGBound> root) {
            this.root = root;
        }

        private void lock() {
            this.lock.lock();
        }

        private void unlock() {
            this.lock.unlock();
        }

        private RTNode<SOGBound> getRoot() {
            return this.root;
        }

        private void setRoot(RTNode<SOGBound> root) {
            this.root = root;
        }

        private boolean isEmpty() {
            return this.root == null;
        }

        private Iterator<SOGBound> search(Rectangle2D searchArea) {
            if (this.root == null) {
                return Collections.emptyList().iterator();
            }
            RTNode.Search<SOGBound> it = new RTNode.Search<SOGBound>(searchArea, this.root, true);
            return it;
        }
    }

    private class PrimsBySize
    implements Comparator<MetalVia> {
        private PrimsBySize() {
        }

        @Override
        public int compare(MetalVia mv1, MetalVia mv2) {
            double sz2;
            PrimitiveNode pn1 = mv1.via;
            PrimitiveNode pn2 = mv2.via;
            double sz1 = pn1.getDefWidth(SeaOfGatesEngine.this.ep) * pn1.getDefHeight(SeaOfGatesEngine.this.ep);
            if (sz1 < (sz2 = pn2.getDefWidth(SeaOfGatesEngine.this.ep) * pn2.getDefHeight(SeaOfGatesEngine.this.ep))) {
                return -1;
            }
            if (sz1 > sz2) {
                return 1;
            }
            return 0;
        }
    }

    private class MetalVias {
        List<MetalVia> vias = new ArrayList<MetalVia>();

        private MetalVias() {
        }

        void addVia(PrimitiveNode pn, int o, int hm, int hmc, double hmi, int vm, int vmc, double vmi) {
            this.vias.add(new MetalVia(pn, o, hm, hmc, hmi, vm, vmc, vmi));
            Collections.sort(this.vias, new PrimsBySize());
        }

        List<MetalVia> getVias() {
            return this.vias;
        }
    }

    private static class MetalVia {
        PrimitiveNode via;
        int orientation;
        int horMetal;
        int verMetal;
        int horMetalColor;
        int verMetalColor;
        double horMetalInset;
        double verMetalInset;

        MetalVia(PrimitiveNode v, int o, int hm, int hmc, double hmi, int vm, int vmc, double vmi) {
            this.via = v;
            this.orientation = o;
            this.horMetal = hm;
            this.horMetalColor = hmc;
            this.horMetalInset = hmi;
            this.verMetal = vm;
            this.verMetalColor = vmc;
            this.verMetalInset = vmi;
        }
    }

    private static class PortInstShadow
    implements SteinerTree.SteinerTreePort {
        private PortInst pi;
        private EPoint ctr;

        PortInstShadow(PortInst pi) {
            this.pi = pi;
            this.ctr = pi.getNodeInst().getShapeOfPort(pi.getPortProto()).getCenter();
        }

        @Override
        public EPoint getCenter() {
            return this.ctr;
        }

        public PortInst getPortInst() {
            return this.pi;
        }
    }

    private class DijkstraTwoWay
    implements Runnable {
        private final NeededRoute nr;
        private final Wavefront dirAtoB;
        private final Wavefront dirBtoA;

        private DijkstraTwoWay(NeededRoute nr, Wavefront dirAtoB, Wavefront dirBtoA) {
            this.nr = nr;
            this.dirAtoB = dirAtoB;
            this.dirBtoA = dirBtoA;
        }

        @Override
        public void run() {
            Environment.setThreadEnvironment(SeaOfGatesEngine.this.env);
            SearchVertex result2 = null;
            SearchVertex resultA = null;
            SearchVertex resultB = null;
            boolean forceBothDirectionsToFinish = false;
            if (this.nr.debuggingRouteFromA != null) {
                forceBothDirectionsToFinish = true;
            }
            if (forceBothDirectionsToFinish) {
                while (result2 == null) {
                    boolean bGood;
                    if (resultA == null) {
                        resultA = this.dirAtoB.advanceWavefront();
                    }
                    if (resultB == null) {
                        resultB = this.dirBtoA.advanceWavefront();
                    }
                    if (resultA == svAborted || resultB == svAborted) {
                        this.nr.completeRoute(svAborted);
                        return;
                    }
                    if (resultA == null || resultB == null) continue;
                    if (!(resultA != svLimited && resultA != svExhausted || resultB != svLimited && resultB != svExhausted)) {
                        result2 = SeaOfGatesEngine.this.tryToFindPath(this.dirAtoB, this.dirBtoA);
                        if (result2 == null) {
                            this.nr.completeRoute(resultA);
                            return;
                        }
                        resultA = result2;
                    }
                    boolean aGood = resultA != null && resultA != svAbandoned && resultA != svLimited && resultA != svExhausted;
                    boolean bl = bGood = resultB != null && resultB != svAbandoned && resultB != svLimited && resultB != svExhausted;
                    if (aGood && bGood) {
                        ArrayList<SearchVertex> aList = new ArrayList<SearchVertex>();
                        SeaOfGatesEngine.this.getOptimizedList(resultA, aList);
                        int aVias = 0;
                        double aLength = 0.0;
                        for (int i = 1; i < aList.size(); ++i) {
                            SearchVertex svLast = (SearchVertex)aList.get(i - 1);
                            SearchVertex sv = (SearchVertex)aList.get(i);
                            if (svLast.getZ() != sv.getZ()) {
                                ++aVias;
                                continue;
                            }
                            double dX = Math.abs(svLast.getX() - sv.getX());
                            double dY = Math.abs(svLast.getY() - sv.getY());
                            aLength += Math.sqrt(dY * dY + dX * dX);
                        }
                        ArrayList<SearchVertex> bList = new ArrayList<SearchVertex>();
                        SeaOfGatesEngine.this.getOptimizedList(resultB, bList);
                        int bVias = 0;
                        double bLength = 0.0;
                        for (int i = 1; i < aList.size(); ++i) {
                            SearchVertex svLast = (SearchVertex)aList.get(i - 1);
                            SearchVertex sv = (SearchVertex)aList.get(i);
                            if (svLast.getZ() != sv.getZ()) {
                                ++aVias;
                                continue;
                            }
                            double dX = Math.abs(svLast.getX() - sv.getX());
                            double dY = Math.abs(svLast.getY() - sv.getY());
                            bLength += Math.sqrt(dY * dY + dX * dX);
                        }
                        if (aLength < bLength || aLength == bLength && aVias < bVias) {
                            resultB = null;
                        } else {
                            resultA = null;
                        }
                    }
                    if ((result2 = resultA) != null && result2 != svAbandoned && result2 != svLimited && result2 != svExhausted || resultB == svAbandoned || resultB == svLimited || resultB == svExhausted) continue;
                    result2 = resultB;
                }
            } else {
                while (result2 == null) {
                    if (resultA == null) {
                        resultA = this.dirAtoB.advanceWavefront();
                    }
                    if (resultB == null) {
                        resultB = this.dirBtoA.advanceWavefront();
                    }
                    if (resultA == null && resultB == null) continue;
                    if (resultA == svAborted || resultB == svAborted) {
                        this.nr.completeRoute(svAborted);
                        return;
                    }
                    if (!(resultA != svLimited && resultA != svExhausted || resultB != svLimited && resultB != svExhausted)) {
                        result2 = SeaOfGatesEngine.this.tryToFindPath(this.dirAtoB, this.dirBtoA);
                        if (result2 == null) {
                            this.nr.completeRoute(resultA);
                            return;
                        }
                        resultA = result2;
                    }
                    if ((result2 = resultA) != null && result2 != svAbandoned && result2 != svLimited && result2 != svExhausted || resultB == svAbandoned || resultB == svLimited || resultB == svExhausted) continue;
                    result2 = resultB;
                }
            }
            this.nr.completeRoute(result2);
        }
    }

    private class DijkstraParallel
    implements Runnable {
        private final Wavefront wf;
        private final Wavefront otherWf;

        private DijkstraParallel(Wavefront wf, Wavefront otherWf) {
            this.wf = wf;
            this.otherWf = otherWf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean success;
            Environment.setThreadEnvironment(SeaOfGatesEngine.this.env);
            SearchVertex result2 = null;
            while (result2 == null) {
                if (this.wf.abort) {
                    result2 = svAbandoned;
                    continue;
                }
                result2 = this.wf.advanceWavefront();
            }
            boolean bl = success = result2.wf != null;
            if (success) assert (result2.wf == this.wf);
            NeededRoute neededRoute = this.wf.nr;
            synchronized (neededRoute) {
                assert (!this.wf.finished);
                if (!this.otherWf.finished) {
                    this.otherWf.abort = true;
                    if (success) {
                        this.wf.nr.routedSuccess = true;
                    }
                }
                this.wf.finished = true;
            }
            this.wf.nr.completeRoute(result2);
        }
    }

    private static class RoutesOnNetwork
    implements Comparable<RoutesOnNetwork> {
        String netName;
        List<SteinerTree.SteinerTreePortPair> pairs;
        List<PortInst> spineTapPorts;
        List<ArcInst> unroutedArcs;
        List<PortInst> unorderedPorts;
        List<NeededRoute> neededRoutes;

        RoutesOnNetwork(String netName) {
            this.netName = netName;
            this.pairs = new ArrayList<SteinerTree.SteinerTreePortPair>();
            this.spineTapPorts = null;
            this.unroutedArcs = new ArrayList<ArcInst>();
            this.unorderedPorts = new ArrayList<PortInst>();
            this.neededRoutes = new ArrayList<NeededRoute>();
        }

        public boolean addUnorderedPort(PortInst pi) {
            if (pi.getNodeInst().isCellInstance() || ((PrimitiveNode)pi.getNodeInst().getProto()).getTechnology() != Generic.tech()) {
                if (!this.unorderedPorts.contains(pi)) {
                    this.unorderedPorts.add(pi);
                }
                return false;
            }
            return true;
        }

        public boolean setupSpineInfo() {
            EPoint pt;
            HashSet<PortInst> uniquePorts = new HashSet<PortInst>();
            for (PortInst pi : this.unorderedPorts) {
                uniquePorts.add(pi);
            }
            if (uniquePorts.size() < 4) {
                return false;
            }
            double lowX = 0.0;
            double highX = 0.0;
            double lowY = 0.0;
            double highY = 0.0;
            boolean first = true;
            for (PortInst pi : uniquePorts) {
                EPoint pt2 = pi.getCenter();
                if (first) {
                    lowX = highX = pt2.getX();
                    lowY = highY = pt2.getY();
                    first = false;
                    continue;
                }
                if (pt2.getX() < lowX) {
                    lowX = pt2.getX();
                }
                if (pt2.getX() > highX) {
                    highX = pt2.getX();
                }
                if (pt2.getY() < lowY) {
                    lowY = pt2.getY();
                }
                if (!(pt2.getY() > highY)) continue;
                highY = pt2.getY();
            }
            double width = highX - lowX;
            double height = highY - lowY;
            if (width * 50.0 > height && height * 50.0 > width) {
                return false;
            }
            PortInst endA = null;
            PortInst endB = null;
            if (width * 50.0 <= height) {
                double lowestY = 0.0;
                double highestY = 0.0;
                first = true;
                for (PortInst pi : uniquePorts) {
                    pt = pi.getCenter();
                    if (first) {
                        lowestY = highestY = pt.getY();
                        endA = endB = pi;
                        first = false;
                        continue;
                    }
                    if (pt.getY() < lowestY) {
                        lowestY = pt.getX();
                        endA = pi;
                    }
                    if (!(pt.getY() > highestY)) continue;
                    highestY = pt.getX();
                    endB = pi;
                }
            } else {
                double lowestX = 0.0;
                double highestX = 0.0;
                first = true;
                for (PortInst pi : uniquePorts) {
                    pt = pi.getCenter();
                    if (first) {
                        lowestX = highestX = pt.getX();
                        endA = endB = pi;
                        first = false;
                        continue;
                    }
                    if (pt.getX() < lowestX) {
                        lowestX = pt.getX();
                        endA = pi;
                    }
                    if (!(pt.getX() > highestX)) continue;
                    highestX = pt.getX();
                    endB = pi;
                }
            }
            if (endA == null || endB == null || endA == endB) {
                return false;
            }
            this.spineTapPorts = new ArrayList<PortInst>();
            for (PortInst pi : uniquePorts) {
                if (pi == endA || pi == endB) continue;
                this.spineTapPorts.add(pi);
            }
            this.pairs.add(new SteinerTree.SteinerTreePortPair(endA, endB));
            return true;
        }

        @Override
        public int compareTo(RoutesOnNetwork other) {
            return this.netName.compareTo(other.netName);
        }
    }

    private static class SortArcsByMaskNumber
    implements Comparator<ArcProto> {
        private SortArcsByMaskNumber() {
        }

        @Override
        public int compare(ArcProto a1, ArcProto a2) {
            int m1 = a1.getMaskLayer();
            int m2 = a2.getMaskLayer();
            return m1 - m2;
        }
    }

    private static class SortLayersByMaskNumber
    implements Comparator<Layer> {
        private SortLayersByMaskNumber() {
        }

        @Override
        public int compare(Layer l1, Layer l2) {
            int m1 = l1.getFunction().getMaskColor();
            int m2 = l2.getFunction().getMaskColor();
            return m1 - m2;
        }
    }

    public static class SearchVertex
    implements Comparable<SearchVertex> {
        private static final int OFFINITIALSEGMENT = 1;
        private static final int TOOFARFROMEND = 2;
        private static final int CLOSETOEND = 4;
        private final double xv;
        private final double yv;
        private int zv;
        private int cv;
        private int cost;
        private int cutLayer;
        private int autoGen;
        private int flags;
        private int globalRoutingBucket;
        private Rectangle2D[] cutRects;
        private Point2D size;
        private SearchVertex last;
        private Wavefront wf;
        private SearchVertexAddon addOn;

        SearchVertex(double x, double y, int z, int c, int whichContact, Rectangle2D[] cutRects, Point2D size2, int cl, Wavefront w, int flags) {
            this.xv = x;
            this.yv = y;
            this.zv = (z << 8) + (whichContact & 0xFF);
            this.cv = c;
            this.cutRects = cutRects;
            this.size = size2;
            this.cutLayer = cl;
            this.autoGen = -1;
            this.flags = flags;
            this.globalRoutingBucket = -1;
            this.wf = w;
            this.addOn = null;
        }

        public double getX() {
            return this.xv;
        }

        public double getY() {
            return this.yv;
        }

        public int getZ() {
            return this.zv >> 8;
        }

        public String describeMetal() {
            String ret = "M" + (this.getZ() + 1);
            if (this.cv > 0) {
                ret = ret + (char)(97 + this.cv - 1);
            }
            return ret;
        }

        public int getC() {
            return this.cv;
        }

        public SearchVertex getLast() {
            return this.last;
        }

        public int getCost() {
            return this.cost;
        }

        public SearchVertexAddon getMoreGeometry() {
            return this.addOn;
        }

        public void setMoreGeometry(SearchVertexAddon sva) {
            this.addOn = sva;
        }

        public int getGRBucket() {
            return this.globalRoutingBucket;
        }

        public Wavefront getWavefront() {
            return this.wf;
        }

        int getContactNo() {
            return this.zv & 0xFF;
        }

        Rectangle2D[] getCutRects() {
            return this.cutRects;
        }

        Point2D getSize() {
            return this.size;
        }

        int getCutLayer() {
            return this.cutLayer;
        }

        int getAutoGen() {
            return this.autoGen;
        }

        void setAutoGen(int a) {
            this.autoGen = a;
        }

        public boolean isOffInitialSegment() {
            return (this.flags & 1) != 0;
        }

        public boolean isCantCompleteRoute() {
            return (this.flags & 2) != 0;
        }

        public boolean isMustCompleteRoute() {
            return (this.flags & 4) != 0;
        }

        @Override
        public int compareTo(SearchVertex svo) {
            int diff2 = this.cost - svo.cost;
            if (diff2 != 0) {
                return diff2;
            }
            if (this.wf != null) {
                double otherDist;
                double thisDist = Math.abs(this.xv - this.wf.toX) + Math.abs(this.yv - this.wf.toY) + (double)Math.abs(this.getZ() - this.wf.toZ);
                if (thisDist < (otherDist = Math.abs(svo.xv - this.wf.toX) + Math.abs(svo.yv - this.wf.toY) + (double)Math.abs(svo.getZ() - this.wf.toZ))) {
                    return -1;
                }
                if (thisDist > otherDist) {
                    return 1;
                }
            }
            return 0;
        }

        private void generateIntermediateVertex(int lastDirection, FixpRectangle toRectGridded, Cell cell) {
            block27: {
                NeededRoute nr = this.wf.nr;
                SearchVertex prevSV = this.last;
                double dX = 0.0;
                double dY = 0.0;
                if (this.getX() > prevSV.getX()) {
                    dX = -1.0;
                } else if (this.getX() < prevSV.getX()) {
                    dX = 1.0;
                } else if (this.getY() > prevSV.getY()) {
                    dY = -1.0;
                } else if (this.getY() < prevSV.getY()) {
                    dY = 1.0;
                }
                if (dX == 0.0 && dY == 0.0) {
                    return;
                }
                int z = this.getZ();
                int c = this.getC();
                double newX = this.getX();
                double newY = this.getY();
                do {
                    if (dX < 0.0) {
                        if (nr.forceGridArcs[z]) {
                            newX = nr.getLowerXGrid(z, newX - 1.0).getCoordinate();
                        } else if (!SeaOfGatesEngine.inDestGrid(toRectGridded, newX -= 1.0, newY)) {
                            newX = nr.getLowerXGrid(z, newX).getCoordinate();
                        }
                    }
                    if (dX > 0.0) {
                        if (nr.forceGridArcs[z]) {
                            newX = nr.getUpperXGrid(z, newX + 1.0).getCoordinate();
                        } else if (!SeaOfGatesEngine.inDestGrid(toRectGridded, newX += 1.0, newY)) {
                            newX = nr.getUpperXGrid(z, newX).getCoordinate();
                        }
                    }
                    if (dY < 0.0) {
                        if (nr.forceGridArcs[z]) {
                            newY = nr.getLowerYGrid(z, newY - 1.0).getCoordinate();
                        } else if (!SeaOfGatesEngine.inDestGrid(toRectGridded, newX, newY -= 1.0)) {
                            newY = nr.getLowerYGrid(z, newY).getCoordinate();
                        }
                    }
                    if (dY > 0.0) {
                        if (nr.forceGridArcs[z]) {
                            newY = nr.getUpperYGrid(z, newY + 1.0).getCoordinate();
                        } else if (!SeaOfGatesEngine.inDestGrid(toRectGridded, newX, newY += 1.0)) {
                            newY = nr.getUpperYGrid(z, newY).getCoordinate();
                        }
                    }
                    if (dX < 0.0 && newX <= prevSV.getX() || dX > 0.0 && newX >= prevSV.getX() || dY < 0.0 && newY <= prevSV.getY() || dY > 0.0 && newY >= prevSV.getY()) break block27;
                } while (this.wf.getVertex(newX, newY, z) != null);
                SearchVertex svIntermediate = new SearchVertex(newX, newY, z, c, this.getContactNo(), this.getCutRects(), this.getSize(), z, this.wf, this.last.flags);
                if (this.wf.debuggingWavefront) {
                    RoutingDebug.ensureDebuggingShadow(svIntermediate, false);
                }
                if (this.wf.globalRoutingDelta != 0) {
                    svIntermediate.globalRoutingBucket = this.wf.getNextBucket(this, newX, newY);
                }
                svIntermediate.setAutoGen(lastDirection);
                svIntermediate.last = prevSV;
                svIntermediate.cost = this.cost + 1;
                this.wf.setVertex(newX, newY, z, svIntermediate);
                this.wf.active.add(svIntermediate);
            }
        }

        static /* synthetic */ Rectangle2D[] access$12802(SearchVertex x0, Rectangle2D[] x1) {
            x0.cutRects = x1;
            return x1;
        }
    }

    public static class SearchVertexAddon {
        private Rectangle2D addedGeometry;
        private PrimitiveNode pureLayerNode;

        public SearchVertexAddon(Rectangle2D geom, PrimitiveNode pNp) {
            this.addedGeometry = geom;
            this.pureLayerNode = pNp;
        }

        public Rectangle2D getGeometry() {
            return this.addedGeometry;
        }

        public PrimitiveNode getPureLayerNode() {
            return this.pureLayerNode;
        }
    }

    public static class OrderedSearchVertex {
        TreeMap<Integer, List<SearchVertex>> listBetter = new TreeMap();

        OrderedSearchVertex() {
        }

        public Set<SearchVertex> getSet() {
            TreeSet<SearchVertex> totalList = new TreeSet<SearchVertex>();
            for (Integer key : this.listBetter.keySet()) {
                List<SearchVertex> curList = this.listBetter.get(key);
                for (SearchVertex sv : curList) {
                    totalList.add(sv);
                }
            }
            return totalList;
        }

        public void add(SearchVertex sv) {
            Integer key = sv.cost;
            List<SearchVertex> curList = this.listBetter.get(key);
            if (curList == null) {
                curList = new ArrayList<SearchVertex>();
                this.listBetter.put(key, curList);
            }
            curList.add(sv);
        }

        public void remove(SearchVertex sv) {
            Integer key = sv.cost;
            List<SearchVertex> curList = this.listBetter.get(key);
            if (curList != null) {
                curList.remove(sv);
                if (curList.size() == 0) {
                    this.listBetter.remove(key);
                }
            } else {
                System.out.println("++++++++++ COULD NOT REMOVE SEARCH VERTEX");
            }
        }

        public boolean inList(SearchVertex sv) {
            Integer key = sv.cost;
            List<SearchVertex> curList = this.listBetter.get(key);
            if (curList == null) {
                return false;
            }
            return curList.contains(sv);
        }

        public SearchVertex getFirst() {
            if (this.listBetter.size() == 0) {
                return null;
            }
            Integer key = this.listBetter.firstKey();
            List<SearchVertex> curList = this.listBetter.get(key);
            if (curList.size() == 0) {
                System.out.println("+++++++++++++ HMMM, FIRST KEY HAS NOTHING (" + key + ")");
            }
            return curList.get(0);
        }
    }

    public class Wavefront {
        final NeededRoute nr;
        final String name;
        private final OrderedSearchVertex active;
        private final List<SearchVertex> inactive;
        List<SearchVertex> vertices;
        volatile boolean abort;
        private boolean debuggingWavefront;
        private SearchVertex solution;
        final PortInst from;
        final PortInst to;
        final double fromX;
        final double fromY;
        final FixpRectangle fromRect;
        final int fromZ;
        final int fromC;
        final double toX;
        final double toY;
        final FixpRectangle toRect;
        final FixpRectangle toRectGridded;
        final int toZ;
        final int toC;
        final double fromTaperLen;
        final double toTaperLen;
        int numStepsMade;
        Rectangle2D[] orderedBuckets;
        int[] orderedBase;
        final int fromBit;
        final int globalRoutingDelta;
        final Map<Integer, Map<Integer, SearchVertex>>[] searchVertexPlanes = new Map[SeaOfGatesEngine.access$3500()];
        private boolean finished;
        private List<SearchVertex> optimizedList = new ArrayList<SearchVertex>();
        private String[] debugString;

        Wavefront(NeededRoute nr, PortInst from2, FixpRectangle fromRect, double fromX, double fromY, int fromZ, int fromC, double fromTaperLen, int fromBit, PortInst to2, FixpRectangle toRect, FixpRectangle toRectGridded, double toX, double toY, int toZ, int toC, double toTaperLen, int globalRoutingDelta, String name, boolean debugIt) {
            this.nr = nr;
            this.from = from2;
            this.fromX = fromX;
            this.fromY = fromY;
            this.fromZ = fromZ;
            this.fromC = fromC;
            this.fromRect = fromRect;
            this.fromBit = fromBit;
            this.to = to2;
            this.toX = toX;
            this.toY = toY;
            this.toZ = toZ;
            this.toC = toC;
            this.toRect = toRect;
            this.toRectGridded = toRectGridded;
            this.fromTaperLen = fromTaperLen;
            this.toTaperLen = toTaperLen;
            if (nr.buckets == null) {
                globalRoutingDelta = 0;
            }
            this.globalRoutingDelta = globalRoutingDelta;
            this.name = name;
            this.numStepsMade = 0;
            this.active = new OrderedSearchVertex();
            this.inactive = new ArrayList<SearchVertex>();
            this.vertices = null;
            this.abort = false;
            this.debuggingWavefront = debugIt;
            SearchVertex svStart = new SearchVertex(fromX, fromY, fromZ, fromC, 0, null, null, 0, this, 0);
            if (this.debuggingWavefront) {
                RoutingDebug.ensureDebuggingShadow(svStart, true);
            }
            if (globalRoutingDelta != 0) {
                this.orderedBuckets = new Rectangle2D[nr.buckets.length];
                this.orderedBase = new int[nr.buckets.length];
                if (globalRoutingDelta > 0) {
                    svStart.globalRoutingBucket = 0;
                    for (int i = 0; i < nr.buckets.length; ++i) {
                        int lastInRun = i;
                        for (int j = i + 1; j < nr.buckets.length; ++j) {
                            if (nr.buckets[i].getMinX() == nr.buckets[j].getMinX() && nr.buckets[i].getMaxX() == nr.buckets[j].getMaxX()) {
                                lastInRun = j;
                            }
                            if (nr.buckets[i].getMinY() == nr.buckets[j].getMinY() && nr.buckets[i].getMaxY() == nr.buckets[j].getMaxY()) {
                                lastInRun = j;
                            }
                            if (lastInRun != j) break;
                        }
                        double lX = Math.min(nr.buckets[i].getMinX(), nr.buckets[lastInRun].getMinX());
                        double hX = Math.max(nr.buckets[i].getMaxX(), nr.buckets[lastInRun].getMaxX());
                        double lY = Math.min(nr.buckets[i].getMinY(), nr.buckets[lastInRun].getMinY());
                        double hY = Math.max(nr.buckets[i].getMaxY(), nr.buckets[lastInRun].getMaxY());
                        Rectangle2D.Double combinedRun = new Rectangle2D.Double(lX, lY, hX - lX, hY - lY);
                        int initially = i;
                        if (i > 0) {
                            --initially;
                        }
                        for (int pos = i; pos <= lastInRun; ++pos) {
                            this.orderedBuckets[pos] = combinedRun;
                            this.orderedBase[pos] = initially;
                            initially = i;
                        }
                        if (lastInRun != nr.buckets.length - 1) {
                            i = lastInRun - 1;
                            continue;
                        }
                        break;
                    }
                } else {
                    svStart.globalRoutingBucket = nr.buckets.length - 1;
                    for (int i = nr.buckets.length - 1; i >= 0; --i) {
                        int lastInRun = i;
                        for (int j = i - 1; j >= 0; --j) {
                            if (nr.buckets[i].getMinX() == nr.buckets[j].getMinX() && nr.buckets[i].getMaxX() == nr.buckets[j].getMaxX()) {
                                lastInRun = j;
                            }
                            if (nr.buckets[i].getMinY() == nr.buckets[j].getMinY() && nr.buckets[i].getMaxY() == nr.buckets[j].getMaxY()) {
                                lastInRun = j;
                            }
                            if (lastInRun != j) break;
                        }
                        double lX = Math.min(nr.buckets[i].getMinX(), nr.buckets[lastInRun].getMinX());
                        double hX = Math.max(nr.buckets[i].getMaxX(), nr.buckets[lastInRun].getMaxX());
                        double lY = Math.min(nr.buckets[i].getMinY(), nr.buckets[lastInRun].getMinY());
                        double hY = Math.max(nr.buckets[i].getMaxY(), nr.buckets[lastInRun].getMaxY());
                        Rectangle2D.Double combinedRun = new Rectangle2D.Double(lX, lY, hX - lX, hY - lY);
                        int initially = i;
                        if (i < nr.buckets.length - 1) {
                            ++initially;
                        }
                        for (int pos = i; pos >= lastInRun; --pos) {
                            this.orderedBuckets[pos] = combinedRun;
                            this.orderedBase[pos] = initially;
                            initially = i;
                        }
                        if (lastInRun != 0) {
                            i = lastInRun + 1;
                            continue;
                        }
                        break;
                    }
                }
            }
            svStart.cost = 0;
            this.setVertex(fromX, fromY, fromZ, svStart);
            this.active.add(svStart);
        }

        public PortInst getFromPortInst() {
            return this.from;
        }

        public PortInst getToPortInst() {
            return this.to;
        }

        public double getFromX() {
            return this.fromX;
        }

        public double getFromY() {
            return this.fromY;
        }

        public int getFromZ() {
            return this.fromZ;
        }

        public int getFromMask() {
            return this.fromC;
        }

        public double getToX() {
            return this.toX;
        }

        public double getToY() {
            return this.toY;
        }

        public int getToZ() {
            return this.toZ;
        }

        public int getToMask() {
            return this.toC;
        }

        public Set<SearchVertex> getActive() {
            return this.active.getSet();
        }

        public List<SearchVertex> getInactive() {
            return this.inactive;
        }

        public NeededRoute getNeededRoute() {
            return this.nr;
        }

        public int getGRDirection() {
            return this.globalRoutingDelta;
        }

        public Rectangle2D[] getOrderedBuckets() {
            return this.orderedBuckets;
        }

        public SearchVertex getFinalSearchVertex() {
            return this.solution;
        }

        public SearchVertex getNextSearchVertex() {
            SearchVertex sv = this.active.getFirst();
            if (sv == null) {
                return svExhausted;
            }
            return sv;
        }

        public SearchVertex getVertex(double x, double y, int z) {
            Map<Integer, Map<Integer, SearchVertex>> plane = this.searchVertexPlanes[z];
            if (plane == null) {
                return null;
            }
            Map<Integer, SearchVertex> row = plane.get(new Integer((int)Math.round(y * 400.0)));
            if (row == null) {
                return null;
            }
            SearchVertex found = row.get(new Integer((int)Math.round(x * 400.0)));
            return found;
        }

        public void setVertex(double x, double y, int z, SearchVertex sv) {
            Integer iY;
            Map<Integer, SearchVertex> row;
            Map<Integer, Map<Integer, SearchVertex>> plane = this.searchVertexPlanes[z];
            if (plane == null) {
                this.searchVertexPlanes[z] = plane = new TreeMap<Integer, Map<Integer, SearchVertex>>();
            }
            if ((row = plane.get(iY = new Integer((int)Math.round(y * 400.0)))) == null) {
                row = new TreeMap<Integer, SearchVertex>();
                plane.put(iY, row);
            }
            row.put(new Integer((int)Math.round(x * 400.0)), sv);
        }

        public Map<Integer, Map<Integer, SearchVertex>>[] getSearchVertexPlanes() {
            return this.searchVertexPlanes;
        }

        private void initDebugStrings() {
            this.debugString = new String[7];
        }

        private void setDebugStringHeader(String str) {
            this.debugString[0] = str;
        }

        private void setDebugString(int direction, String str) {
            this.debugString[direction + 1] = str;
        }

        private void addDebugString(int direction, String str) {
            int n = direction + 1;
            this.debugString[n] = this.debugString[n] + str;
        }

        private void completeDebugString(int direction, String str) {
            int n = direction + 1;
            this.debugString[n] = this.debugString[n] + str;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public SearchVertex advanceWavefront() {
            int lastDirection;
            ++this.numStepsMade;
            if (this.numStepsMade > this.nr.complexityLimit) {
                this.solution = svLimited;
                return this.solution;
            }
            SearchVertex svCurrent = this.getNextSearchVertex();
            if (svCurrent == svExhausted) {
                this.solution = svCurrent;
                return this.solution;
            }
            this.active.remove(svCurrent);
            this.inactive.add(svCurrent);
            double curX = svCurrent.getX();
            double curY = svCurrent.getY();
            int curZ = svCurrent.getZ();
            int curC = svCurrent.getC();
            if (this.debuggingWavefront) {
                this.initDebugStrings();
                String str = "At: (" + TextUtils.formatDistance(curX) + "," + TextUtils.formatDistance(curY) + "," + SeaOfGatesEngine.describeMetal(curZ, curC) + "), Cost: " + svCurrent.cost;
                str = this.globalRoutingDelta == 0 ? str + ", NO Global Routing" : str + ", Global Routing Bucket: " + svCurrent.globalRoutingBucket;
                this.setDebugStringHeader(str);
            }
            if ((lastDirection = svCurrent.getAutoGen()) >= 0) {
                svCurrent.generateIntermediateVertex(lastDirection, this.toRectGridded, SeaOfGatesEngine.this.cell);
            }
            SearchVertex destinationSV = null;
            block23: for (int i = 0; i < 6; ++i) {
                int c;
                String costExplanation;
                int newCost;
                SearchVertex svNext;
                boolean penaltyOffGridY;
                boolean penaltyOffGridX;
                SearchVertex alreadyThere;
                int nZ;
                double nY;
                double nX;
                int dz;
                double dy;
                double dx;
                block220: {
                    block218: {
                        block219: {
                            boolean foundDest;
                            SearchVertexAddon extraGeometryforMinArea;
                            Point2D.Double size2;
                            Rectangle2D[] cuts;
                            int whichContact;
                            int nC;
                            boolean closeToEnd;
                            boolean tooFarFromEnd;
                            block217: {
                                String[] failureReasons;
                                List<MetalVia> nps;
                                int highMetal;
                                int lowMetal;
                                block216: {
                                    SOGBound sb;
                                    block215: {
                                        List<MetalVia> nps2X;
                                        block209: {
                                            block212: {
                                                block213: {
                                                    block214: {
                                                        block211: {
                                                            block210: {
                                                                double distY;
                                                                double distX;
                                                                double dist;
                                                                dx = 0.0;
                                                                dy = 0.0;
                                                                dz = 0;
                                                                tooFarFromEnd = false;
                                                                closeToEnd = false;
                                                                StringBuffer jumpExplanation = null;
                                                                if (this.debuggingWavefront) {
                                                                    jumpExplanation = new StringBuffer();
                                                                }
                                                                switch (i) {
                                                                    case 0: {
                                                                        double intermediate;
                                                                        if (SeaOfGatesEngine.this.sogp.isForceHorVer() && curZ % 2 == 0 == SeaOfGatesEngine.this.sogp.isHorizontalEven()) {
                                                                            if (!this.debuggingWavefront) continue block23;
                                                                            this.setDebugString(i, "Cannot move in -X axis");
                                                                            continue block23;
                                                                        }
                                                                        dx = DBMath.areEquals(curY, this.toY) && this.toRectGridded.getMinX() < this.toRectGridded.getMaxX() && curX >= this.toRectGridded.getMinX() && curX <= this.toRectGridded.getMaxX() ? this.toX - curX : (SeaOfGatesEngine.inDestGrid(this.toRectGridded, curX - 1.0, curY) ? -1.0 : this.nr.getLowerXGrid(curZ, curX - 1.0).getCoordinate() - curX);
                                                                        if (!(this.nr.gridLocationsX[curZ] != null && this.nr.forceGridArcs[curZ] || (intermediate = this.nr.upToGrainAlways(curX + dx)) == curX + dx)) {
                                                                            dx = intermediate - curX;
                                                                        }
                                                                        if (this.toX < curX && (dx = this.getJumpSize(svCurrent, curX, curY, curZ, dx, dy, jumpExplanation)) >= 0.0) {
                                                                            dx = -1.0;
                                                                        }
                                                                        if (this.nr.gridLocationsX[curZ] == null || !this.nr.forceGridArcs[curZ] || curX + dx == this.toX && curY == this.toY && curZ == this.toZ) break;
                                                                        double gridX = this.nr.getClosestXGrid(curZ, curX + dx).getCoordinate();
                                                                        if (gridX == curX) {
                                                                            if (!this.debuggingWavefront) continue block23;
                                                                            if (jumpExplanation.length() != 0) {
                                                                                this.setDebugString(i, "Blocked by " + jumpExplanation.toString());
                                                                                continue block23;
                                                                            }
                                                                            this.setDebugString(i, "Can only move to " + TextUtils.formatDistance(curX + dx) + " which is gridded right to " + TextUtils.formatDistance(gridX) + " (no movement)");
                                                                            continue block23;
                                                                        }
                                                                        dx = gridX - curX;
                                                                        break;
                                                                    }
                                                                    case 1: {
                                                                        double intermediate;
                                                                        if (SeaOfGatesEngine.this.sogp.isForceHorVer() && curZ % 2 == 0 == SeaOfGatesEngine.this.sogp.isHorizontalEven()) {
                                                                            if (!this.debuggingWavefront) continue block23;
                                                                            this.setDebugString(i, "Cannot move in +X axis");
                                                                            continue block23;
                                                                        }
                                                                        dx = DBMath.areEquals(curY, this.toY) && this.toRectGridded.getMinX() < this.toRectGridded.getMaxX() && curX >= this.toRectGridded.getMinX() && curX <= this.toRectGridded.getMaxX() ? this.toX - curX : (SeaOfGatesEngine.inDestGrid(this.toRectGridded, curX + 1.0, curY) ? 1.0 : this.nr.getUpperXGrid(curZ, curX + 1.0).getCoordinate() - curX);
                                                                        if (!(this.nr.gridLocationsX[curZ] != null && this.nr.forceGridArcs[curZ] || (intermediate = this.nr.downToGrainAlways(curX + dx)) == curX + dx)) {
                                                                            dx = intermediate - curX;
                                                                        }
                                                                        if (this.toX > curX && (dx = this.getJumpSize(svCurrent, curX, curY, curZ, dx, dy, jumpExplanation)) <= 0.0) {
                                                                            dx = 1.0;
                                                                        }
                                                                        if (this.nr.gridLocationsX[curZ] == null || !this.nr.forceGridArcs[curZ] || curX + dx == this.toX && curY == this.toY && curZ == this.toZ) break;
                                                                        double gridX = this.nr.getClosestXGrid(curZ, curX + dx).getCoordinate();
                                                                        if (gridX == curX) {
                                                                            if (!this.debuggingWavefront) continue block23;
                                                                            if (jumpExplanation.length() != 0) {
                                                                                this.setDebugString(i, "Blocked by " + jumpExplanation.toString());
                                                                                continue block23;
                                                                            }
                                                                            this.setDebugString(i, "Can only move to " + TextUtils.formatDistance(curX + dx) + " which is gridded left to " + TextUtils.formatDistance(gridX) + " (no movement)");
                                                                            continue block23;
                                                                        }
                                                                        dx = gridX - curX;
                                                                        break;
                                                                    }
                                                                    case 2: {
                                                                        double intermediate;
                                                                        if (SeaOfGatesEngine.this.sogp.isForceHorVer() && curZ % 2 != 0 == SeaOfGatesEngine.this.sogp.isHorizontalEven()) {
                                                                            if (!this.debuggingWavefront) continue block23;
                                                                            this.setDebugString(i, "Cannot move in -Y axis");
                                                                            continue block23;
                                                                        }
                                                                        dy = DBMath.areEquals(curX, this.toX) && this.toRectGridded.getMinY() < this.toRectGridded.getMaxY() && curY >= this.toRectGridded.getMinY() && curY <= this.toRectGridded.getMaxY() ? this.toY - curY : (SeaOfGatesEngine.inDestGrid(this.toRectGridded, curX, curY - 1.0) ? -1.0 : this.nr.getLowerYGrid(curZ, curY - 1.0).getCoordinate() - curY);
                                                                        if (!(this.nr.gridLocationsY[curZ] != null && this.nr.forceGridArcs[curZ] || (intermediate = this.nr.upToGrainAlways(curY + dy)) == curY + dy)) {
                                                                            dy = intermediate - curY;
                                                                        }
                                                                        if (this.toY < curY && (dy = this.getJumpSize(svCurrent, curX, curY, curZ, dx, dy, jumpExplanation)) >= 0.0) {
                                                                            dy = -1.0;
                                                                        }
                                                                        if (this.nr.gridLocationsY[curZ] == null || !this.nr.forceGridArcs[curZ] || curX == this.toX && curY + dy == this.toY && curZ == this.toZ) break;
                                                                        double gridY = this.nr.getClosestYGrid(curZ, curY + dy).getCoordinate();
                                                                        if (gridY == curY) {
                                                                            if (!this.debuggingWavefront) continue block23;
                                                                            if (jumpExplanation.length() != 0) {
                                                                                this.setDebugString(i, "Blocked by " + jumpExplanation.toString());
                                                                                continue block23;
                                                                            }
                                                                            this.setDebugString(i, "Can only move to " + TextUtils.formatDistance(curY + dy) + " which is gridded up to " + TextUtils.formatDistance(gridY) + " (no movement)");
                                                                            continue block23;
                                                                        }
                                                                        dy = gridY - curY;
                                                                        break;
                                                                    }
                                                                    case 3: {
                                                                        double intermediate;
                                                                        if (SeaOfGatesEngine.this.sogp.isForceHorVer() && curZ % 2 != 0 == SeaOfGatesEngine.this.sogp.isHorizontalEven()) {
                                                                            if (!this.debuggingWavefront) continue block23;
                                                                            this.setDebugString(i, "Cannot move in +Y axis");
                                                                            continue block23;
                                                                        }
                                                                        dy = DBMath.areEquals(curX, this.toX) && this.toRectGridded.getMinY() < this.toRectGridded.getMaxY() && curY >= this.toRectGridded.getMinY() && curY <= this.toRectGridded.getMaxY() ? this.toY - curY : (SeaOfGatesEngine.inDestGrid(this.toRectGridded, curX, curY + 1.0) ? 1.0 : this.nr.getUpperYGrid(curZ, curY + 1.0).getCoordinate() - curY);
                                                                        if (!(this.nr.gridLocationsY[curZ] != null && this.nr.forceGridArcs[curZ] || (intermediate = this.nr.downToGrainAlways(curY + dy)) == curY + dy)) {
                                                                            dy = intermediate - curY;
                                                                        }
                                                                        if (this.toY > curY && (dy = this.getJumpSize(svCurrent, curX, curY, curZ, dx, dy, jumpExplanation)) <= 0.0) {
                                                                            dy = 1.0;
                                                                        }
                                                                        if (this.nr.gridLocationsY[curZ] == null || !this.nr.forceGridArcs[curZ] || curX == this.toX && curY + dy == this.toY && curZ == this.toZ) break;
                                                                        double gridY = this.nr.getClosestYGrid(curZ, curY + dy).getCoordinate();
                                                                        if (gridY == curY) {
                                                                            if (!this.debuggingWavefront) continue block23;
                                                                            if (jumpExplanation.length() != 0) {
                                                                                this.setDebugString(i, "Blocked by " + jumpExplanation.toString());
                                                                                continue block23;
                                                                            }
                                                                            this.setDebugString(i, "Can only move to " + TextUtils.formatDistance(curY + dy) + " which is gridded down to " + TextUtils.formatDistance(gridY) + " (no movement)");
                                                                            continue block23;
                                                                        }
                                                                        dy = gridY - curY;
                                                                        break;
                                                                    }
                                                                    case 4: {
                                                                        dz = -1;
                                                                        break;
                                                                    }
                                                                    case 5: {
                                                                        dz = 1;
                                                                    }
                                                                }
                                                                if (this.debuggingWavefront) {
                                                                    switch (i) {
                                                                        case 0: 
                                                                        case 1: {
                                                                            this.setDebugString(i, "Move " + (dx < 0.0 ? "" : "+") + TextUtils.formatDistance(dx));
                                                                            break;
                                                                        }
                                                                        case 2: 
                                                                        case 3: {
                                                                            this.setDebugString(i, "Move " + (dy < 0.0 ? "" : "+") + TextUtils.formatDistance(dy));
                                                                            break;
                                                                        }
                                                                        case 4: {
                                                                            this.setDebugString(i, "Move -1");
                                                                            break;
                                                                        }
                                                                        case 5: {
                                                                            this.setDebugString(i, "Move +1");
                                                                            break;
                                                                        }
                                                                    }
                                                                }
                                                                nX = curX + dx;
                                                                nY = curY + dy;
                                                                nZ = curZ + dz;
                                                                nC = curC;
                                                                if (dz != 0) break block210;
                                                                if (this.fromTaperLen >= 0.0 && !svCurrent.isOffInitialSegment() && (dist = Math.sqrt((distX = nX - this.fromX) * distX + (distY = nY - this.fromY) * distY)) > this.fromTaperLen) {
                                                                    if (!this.debuggingWavefront) continue;
                                                                    this.completeDebugString(i, ": initial taper is " + TextUtils.formatDistance(dist) + " from start but maximum taper is " + TextUtils.formatDistance(this.fromTaperLen));
                                                                    continue;
                                                                }
                                                                if (jumpExplanation != null && jumpExplanation.length() != 0) {
                                                                    this.completeDebugString(i, " [Stopped by " + jumpExplanation.toString() + "]");
                                                                }
                                                                break block209;
                                                            }
                                                            if (nZ < 0 || nZ >= numMetalLayers) {
                                                                if (!this.debuggingWavefront) continue;
                                                                this.completeDebugString(i, ": Out Of Bounds");
                                                                continue;
                                                            }
                                                            if (this.nr.preventArc(nZ)) {
                                                                if (!this.debuggingWavefront) continue;
                                                                this.completeDebugString(i, ": Disallowed Arc");
                                                                continue;
                                                            }
                                                            if (nZ == this.toZ && this.toTaperLen >= 0.0 && (DBMath.areEquals(nX, this.toX) || DBMath.areEquals(nY, this.toY))) {
                                                                double closest = Math.max(Math.abs(nX - this.toX), Math.abs(nY - this.toY));
                                                                if (closest > this.toTaperLen) {
                                                                    if (SeaOfGatesEngine.this.taperOnlyArcs[nZ]) {
                                                                        if (!this.debuggingWavefront) continue;
                                                                        this.completeDebugString(i, ": Taper-only layer too far from destination");
                                                                        continue;
                                                                    }
                                                                    tooFarFromEnd = true;
                                                                } else {
                                                                    closeToEnd = true;
                                                                }
                                                            }
                                                            if (SeaOfGatesEngine.this.metalLayers[nZ].length != 1) break block211;
                                                            nC = 0;
                                                            break block209;
                                                        }
                                                        if (!SeaOfGatesEngine.this.sogp.isForceHorVer()) break block212;
                                                        if (nZ % 2 == 0 != SeaOfGatesEngine.this.sogp.isHorizontalEven()) break block213;
                                                        if (this.nr.gridLocationsX[nZ] != null) break block214;
                                                        System.out.println("WARNING: No X grid information for Metal " + (nZ + 1));
                                                        break block212;
                                                    }
                                                    SeaOfGates.SeaOfGatesTrack sogt = this.nr.getClosestXGrid(nZ, nX);
                                                    nC = sogt.getMaskNum();
                                                    if (nC != 0) {
                                                        if (this.nr.is2X(nZ, curX, curY, nX, nY)) {
                                                            nC = SeaOfGatesEngine.this.metalLayers[nZ].length + 1 - nC;
                                                        }
                                                        break block212;
                                                    } else {
                                                        System.out.println("WARNING: No mask color for Metal " + (nZ + 1) + " at X=" + TextUtils.formatDistance(nX));
                                                    }
                                                    break block212;
                                                }
                                                if (this.nr.gridLocationsY[nZ] == null) {
                                                    System.out.println("WARNING: No Y grid information for Metal " + (nZ + 1));
                                                } else {
                                                    SeaOfGates.SeaOfGatesTrack sogt = this.nr.getClosestYGrid(nZ, nY);
                                                    nC = sogt.getMaskNum();
                                                    if (nC != 0) {
                                                        if (this.nr.is2X(nZ, curX, curY, nX, nY)) {
                                                            nC = SeaOfGatesEngine.this.metalLayers[nZ].length + 1 - nC;
                                                        }
                                                    } else {
                                                        System.out.println("WARNING: No mask color for Metal " + (nZ + 1) + " at Y=" + TextUtils.formatDistance(nY));
                                                    }
                                                }
                                            }
                                            if (nC == 0) {
                                                nC = curC;
                                                if (nZ == this.toZ) {
                                                    nC = this.toC;
                                                }
                                                if (SeaOfGatesEngine.this.tech.hasColoredMetalLayer(SeaOfGatesEngine.this.primaryMetalLayer[nZ])) {
                                                    BlockageTree bTree = SeaOfGatesEngine.this.rTrees.getMetalTree(SeaOfGatesEngine.this.primaryMetalLayer[nZ]);
                                                    bTree.lock();
                                                    try {
                                                        if (!bTree.isEmpty()) {
                                                            Rectangle2D.Double searchArea = new Rectangle2D.Double(nX, nY, 0.0, 0.0);
                                                            Iterator sea = bTree.search(searchArea);
                                                            while (sea.hasNext()) {
                                                                SOGBound sBound = (SOGBound)sea.next();
                                                                if (!sBound.isSameBasicNet(this.nr.netID)) continue;
                                                                nC = sBound.maskLayer;
                                                            }
                                                        }
                                                    }
                                                    finally {
                                                        bTree.unlock();
                                                    }
                                                }
                                            }
                                        }
                                        if (this.globalRoutingDelta != 0) {
                                            Rectangle2D limit = this.orderedBuckets[svCurrent.globalRoutingBucket];
                                            if (nX < limit.getMinX()) {
                                                nX = limit.getMinX();
                                                if (!SeaOfGatesEngine.inDestGrid(this.toRectGridded, nX, curY)) {
                                                    nX = this.nr.getUpperXGrid(curZ, nX).getCoordinate();
                                                }
                                                if ((dx = nX - curX) == 0.0) {
                                                    if (!this.debuggingWavefront) continue;
                                                    this.completeDebugString(i, ": Out Of Global Routing X Bounds");
                                                    continue;
                                                }
                                            }
                                            if (nX > limit.getMaxX()) {
                                                nX = limit.getMaxX();
                                                if (!SeaOfGatesEngine.inDestGrid(this.toRectGridded, nX, curY)) {
                                                    nX = this.nr.getLowerXGrid(curZ, nX).getCoordinate();
                                                }
                                                if ((dx = nX - curX) == 0.0) {
                                                    if (!this.debuggingWavefront) continue;
                                                    this.completeDebugString(i, ": Out Of Global Routing X Bounds");
                                                    continue;
                                                }
                                            }
                                            if (nY < limit.getMinY()) {
                                                nY = limit.getMinY();
                                                if (!SeaOfGatesEngine.inDestGrid(this.toRectGridded, curX, nY)) {
                                                    nY = this.nr.getUpperYGrid(curZ, nY).getCoordinate();
                                                }
                                                if ((dy = nY - curY) == 0.0) {
                                                    if (!this.debuggingWavefront) continue;
                                                    this.completeDebugString(i, ": Out Of Global Routing Y Bounds");
                                                    continue;
                                                }
                                            }
                                            if (nY > limit.getMaxY()) {
                                                nY = limit.getMaxY();
                                                if (!SeaOfGatesEngine.inDestGrid(this.toRectGridded, curX, nY)) {
                                                    nY = this.nr.getLowerYGrid(curZ, nY).getCoordinate();
                                                }
                                                if ((dy = nY - curY) == 0.0) {
                                                    if (!this.debuggingWavefront) continue;
                                                    this.completeDebugString(i, ": Out Of Global Routing Y Bounds");
                                                    continue;
                                                }
                                            }
                                        }
                                        if (nX < this.nr.routeBounds.getMinX()) {
                                            nX = this.nr.routeBounds.getMinX();
                                            if (!SeaOfGatesEngine.inDestGrid(this.toRectGridded, nX, curY)) {
                                                nX = this.nr.getUpperXGrid(curZ, nX).getCoordinate();
                                            }
                                            if ((dx = nX - curX) == 0.0) {
                                                if (!this.debuggingWavefront) continue;
                                                this.completeDebugString(i, ": Out Of X Bounds");
                                                continue;
                                            }
                                        }
                                        if (nX > this.nr.routeBounds.getMaxX()) {
                                            nX = this.nr.routeBounds.getMaxX();
                                            if (!SeaOfGatesEngine.inDestGrid(this.toRectGridded, nX, curY)) {
                                                nX = this.nr.getLowerXGrid(curZ, nX).getCoordinate();
                                            }
                                            if ((dx = nX - curX) == 0.0) {
                                                if (!this.debuggingWavefront) continue;
                                                this.completeDebugString(i, ": Out Of X Bounds");
                                                continue;
                                            }
                                        }
                                        if (nY < this.nr.routeBounds.getMinY()) {
                                            nY = this.nr.routeBounds.getMinY();
                                            if (!SeaOfGatesEngine.inDestGrid(this.toRectGridded, curX, nY)) {
                                                nY = this.nr.getUpperYGrid(curZ, nY).getCoordinate();
                                            }
                                            if ((dy = nY - curY) == 0.0) {
                                                if (!this.debuggingWavefront) continue;
                                                this.completeDebugString(i, ": Out Of Y Bounds");
                                                continue;
                                            }
                                        }
                                        if (nY > this.nr.routeBounds.getMaxY()) {
                                            nY = this.nr.routeBounds.getMaxY();
                                            if (!SeaOfGatesEngine.inDestGrid(this.toRectGridded, curX, nY)) {
                                                nY = this.nr.getLowerYGrid(curZ, nY).getCoordinate();
                                            }
                                            if ((dy = nY - curY) == 0.0) {
                                                if (!this.debuggingWavefront) continue;
                                                this.completeDebugString(i, ": Out Of Y Bounds");
                                                continue;
                                            }
                                        }
                                        if ((alreadyThere = this.getVertex(nX, nY, nZ)) != null && !this.active.inList(alreadyThere)) {
                                            if (!this.debuggingWavefront) continue;
                                            this.completeDebugString(i, ": Already Visited");
                                            continue;
                                        }
                                        whichContact = 0;
                                        cuts = null;
                                        size2 = null;
                                        extraGeometryforMinArea = null;
                                        if (dz == 0) break block215;
                                        lowMetal = Math.min(curZ, nZ);
                                        highMetal = Math.max(curZ, nZ);
                                        nps = SeaOfGatesEngine.this.metalVias[lowMetal].getVias();
                                        if ((this.nr.is2X(lowMetal, curX, curY, nX, nY) || this.nr.is2X(highMetal, curX, curY, nX, nY)) && (nps2X = SeaOfGatesEngine.this.metalVias2X[lowMetal].getVias()).size() > 0) {
                                            nps = nps2X;
                                        }
                                        whichContact = -1;
                                        failureReasons = null;
                                        if (this.debuggingWavefront) {
                                            failureReasons = new String[nps.size()];
                                        }
                                        break block216;
                                    }
                                    double width = this.nr.getArcWidth(nZ, curX, curY, nX, nY);
                                    double metalSpacing = width / 2.0;
                                    boolean allClear = false;
                                    double initNX = nX;
                                    double initNY = nY;
                                    String explanation = null;
                                    if (this.debuggingWavefront) {
                                        explanation = "";
                                    }
                                    while (true) {
                                        double newNY;
                                        double newNX;
                                        SearchVertex prevPath = svCurrent;
                                        double checkX = (curX + nX) / 2.0;
                                        double checkY = (curY + nY) / 2.0;
                                        double halfWid = metalSpacing + Math.abs(dx) / 2.0;
                                        double halfHei = metalSpacing + Math.abs(dy) / 2.0;
                                        while (prevPath != null && prevPath.last != null && prevPath.zv == nZ && prevPath.last.zv == nZ) {
                                            if (prevPath.xv == prevPath.last.xv && dx == 0.0) {
                                                checkY = (prevPath.last.yv + nY) / 2.0;
                                                halfHei = metalSpacing + Math.abs(prevPath.last.yv - nY) / 2.0;
                                                prevPath = prevPath.last;
                                                continue;
                                            }
                                            if (prevPath.yv != prevPath.last.yv || dy != 0.0) break;
                                            checkX = (prevPath.last.xv + nX) / 2.0;
                                            halfWid = metalSpacing + Math.abs(prevPath.last.xv - nX) / 2.0;
                                            prevPath = prevPath.last;
                                        }
                                        if ((sb = this.getMetalBlockageAndNotch(nZ, nC, halfWid, halfHei, checkX, checkY, prevPath, false)) == null) {
                                            allClear = true;
                                            break;
                                        }
                                        if (this.debuggingWavefront) {
                                            explanation = explanation + ": Blocked on " + SeaOfGatesEngine.describeMetal(nZ, nC) + " because proposed " + TextUtils.formatDistance(checkX - halfWid) + "<=X<=" + TextUtils.formatDistance(checkX + halfWid) + " and " + TextUtils.formatDistance(checkY - halfHei) + "<=Y<=" + TextUtils.formatDistance(checkY + halfHei) + " is less than " + TextUtils.formatDistance(metalSpacing) + " to " + TextUtils.formatDistance(sb.bound.getMinX()) + "<=X<=" + TextUtils.formatDistance(sb.bound.getMaxX()) + " and " + TextUtils.formatDistance(sb.bound.getMinY()) + "<=Y<=" + TextUtils.formatDistance(sb.bound.getMaxY());
                                        }
                                        if (i == 0) {
                                            newNX = nX + 1.0;
                                            newNX = !this.nr.forceGridArcs[nZ] && SeaOfGatesEngine.inDestGrid(this.toRectGridded, newNX, curY) ? this.nr.downToGrainAlways(newNX) : this.nr.getUpperXGrid(curZ, newNX).getCoordinate();
                                            if (newNX >= curX || DBMath.areEquals(newNX, nX) || (dx = newNX - curX) == 0.0) {
                                                break;
                                            }
                                        } else if (i == 1) {
                                            newNX = nX - 1.0;
                                            newNX = !this.nr.forceGridArcs[nZ] && SeaOfGatesEngine.inDestGrid(this.toRectGridded, newNX, curY) ? this.nr.upToGrainAlways(newNX) : this.nr.getLowerXGrid(curZ, newNX).getCoordinate();
                                            if (newNX <= curX || DBMath.areEquals(newNX, nX) || (dx = newNX - curX) == 0.0) {
                                                break;
                                            }
                                        } else if (i == 2) {
                                            newNY = nY + 1.0;
                                            newNY = !this.nr.forceGridArcs[nZ] && SeaOfGatesEngine.inDestGrid(this.toRectGridded, curX, newNY) ? this.nr.downToGrainAlways(newNY) : this.nr.getUpperYGrid(curZ, newNY).getCoordinate();
                                            if (newNY >= curY || DBMath.areEquals(newNY, nY) || (dy = newNY - curY) == 0.0) {
                                                break;
                                            }
                                        } else if (i == 3) {
                                            newNY = nY - 1.0;
                                            newNY = !this.nr.forceGridArcs[nZ] && SeaOfGatesEngine.inDestGrid(this.toRectGridded, curX, newNY) ? this.nr.upToGrainAlways(newNY) : this.nr.getLowerYGrid(curZ, newNY).getCoordinate();
                                            if (newNY <= curY || DBMath.areEquals(newNY, nY) || (dy = newNY - curY) == 0.0) break;
                                        }
                                        nX = curX + dx;
                                        nY = curY + dy;
                                    }
                                    if (!allClear) {
                                        if (!this.debuggingWavefront) continue;
                                        double checkX = (curX + nX) / 2.0;
                                        double checkY = (curY + nY) / 2.0;
                                        double halfWid = metalSpacing + Math.abs(dx) / 2.0;
                                        double halfHei = metalSpacing + Math.abs(dy) / 2.0;
                                        double[] surround = this.nr.getSpacingRule(nZ, SeaOfGatesEngine.this.maxDefArcWidth[nZ], -1.0);
                                        sb = this.nr.getMetalBlockage(this.nr.netID, nZ, halfWid, halfHei, surround, checkX, checkY);
                                        explanation = sb != null ? explanation + ": Blocked" : explanation + ": Blocked, Notch";
                                        this.completeDebugString(i, explanation);
                                        continue;
                                    }
                                    if (!this.debuggingWavefront) break block217;
                                    if (initNX != nX || initNY != nY) {
                                        explanation = explanation + " so move only ";
                                        switch (i) {
                                            case 0: {
                                                explanation = explanation + TextUtils.formatDistance(Math.abs(dx));
                                                break;
                                            }
                                            case 1: {
                                                explanation = explanation + TextUtils.formatDistance(dx);
                                                break;
                                            }
                                            case 2: {
                                                explanation = explanation + TextUtils.formatDistance(Math.abs(dy));
                                                break;
                                            }
                                            case 3: {
                                                explanation = explanation + TextUtils.formatDistance(dy);
                                                break;
                                            }
                                        }
                                    }
                                    this.addDebugString(i, explanation);
                                    break block217;
                                }
                                for (int contactNo = 0; contactNo < nps.size(); ++contactNo) {
                                    MetalVia mv = nps.get(contactNo);
                                    if (mv.horMetal == curZ) {
                                        if (mv.horMetalColor != curC || mv.verMetalColor != nC) {
                                            if (!this.debuggingWavefront) continue;
                                            failureReasons[contactNo] = "masks are " + mv.horMetalColor + " and " + mv.verMetalColor + " but want masks " + curC + " and " + nC;
                                            continue;
                                        }
                                    } else if (mv.verMetal == curZ && (mv.verMetalColor != curC || mv.horMetalColor != nC)) {
                                        if (!this.debuggingWavefront) continue;
                                        failureReasons[contactNo] = "masks are " + mv.verMetalColor + " and " + mv.horMetalColor + " but want masks " + curC + " and " + nC;
                                        continue;
                                    }
                                    MutableDouble conWid = new MutableDouble(0.0);
                                    MutableDouble conHei = new MutableDouble(0.0);
                                    double lastX = nX;
                                    double lastY = nY;
                                    SearchVertex prev = svCurrent.getLast();
                                    if (prev != null) {
                                        lastX = prev.getX();
                                        lastY = prev.getY();
                                        if (closeToEnd && (lastX != this.fromX || lastY != this.fromY)) {
                                            lastX = this.toX;
                                            lastY = this.toY;
                                        }
                                    }
                                    Orientation orient = this.nr.getMVSize(mv, nX, nY, lastX, lastY, conWid, conHei);
                                    PrimitiveNode np = mv.via;
                                    NodeInst dummyNi = NodeInst.makeDummyInstance(np, SeaOfGatesEngine.this.ep, EPoint.fromLambda(nX, nY), conWid.doubleValue(), conHei.doubleValue(), orient);
                                    Poly[] conPolys = SeaOfGatesEngine.this.tech.getShapeOfNode(dummyNi);
                                    FixpTransform trans = null;
                                    if (orient != Orientation.IDENT) {
                                        trans = dummyNi.rotateOut();
                                    }
                                    int cutCount = 0;
                                    for (int p = 0; p < conPolys.length; ++p) {
                                        if (!conPolys[p].getLayer().getFunction().isContact()) continue;
                                        ++cutCount;
                                    }
                                    Rectangle2D[] curCuts = new Rectangle2D[cutCount];
                                    cutCount = 0;
                                    String failedReason = null;
                                    boolean contactFailed = false;
                                    for (int p = 0; p < conPolys.length; ++p) {
                                        SearchVertex lastSv;
                                        FixpRectangle conRect;
                                        Layer conLayer;
                                        Layer.Function lFun;
                                        Poly conPoly = conPolys[p];
                                        if (trans != null) {
                                            conPoly.transform(trans);
                                        }
                                        if ((lFun = (conLayer = conPoly.getLayer()).getFunction()).isMetal()) {
                                            double halfHei;
                                            double halfWid;
                                            int maskNo;
                                            conRect = conPoly.getBounds2D();
                                            int metalNo = lFun.getLevel() - 1;
                                            SOGBound sb = this.getMetalBlockageAndNotch(metalNo, maskNo = lFun.getMaskColor(), halfWid = ((RectangularShape)conRect).getWidth() / 2.0, halfHei = ((RectangularShape)conRect).getHeight() / 2.0, ((RectangularShape)conRect).getCenterX(), ((RectangularShape)conRect).getCenterY(), svCurrent, false);
                                            if (sb == null) continue;
                                            contactFailed = true;
                                            if (!this.debuggingWavefront) break;
                                            failedReason = "layer " + conLayer.getName() + " at " + TextUtils.formatDistance(((RectangularShape)conRect).getMinX()) + "<=X<=" + TextUtils.formatDistance(((RectangularShape)conRect).getMaxX()) + " and " + TextUtils.formatDistance(((RectangularShape)conRect).getMinY()) + "<=Y<=" + TextUtils.formatDistance(((RectangularShape)conRect).getMaxY()) + " conflicts with " + TextUtils.formatDistance(sb.getBounds().getMinX()) + "<=X<=" + TextUtils.formatDistance(sb.getBounds().getMaxX()) + " and " + TextUtils.formatDistance(sb.getBounds().getMinY()) + "<=Y<=" + TextUtils.formatDistance(sb.getBounds().getMaxY());
                                            break;
                                        }
                                        if (!lFun.isContact()) continue;
                                        conRect = conPoly.getBounds2D();
                                        double conCX = ((RectangularShape)conRect).getCenterX();
                                        double conCY = ((RectangularShape)conRect).getCenterY();
                                        double surround = SeaOfGatesEngine.this.viaSurround[lowMetal];
                                        double vSize = SeaOfGatesEngine.this.viaSize[lowMetal];
                                        SOGVia sb = this.nr.getViaBlockage(this.nr.netID, conLayer, surround, conRect);
                                        if (sb != null) {
                                            contactFailed = true;
                                            if (!this.debuggingWavefront) break;
                                            failedReason = "cut " + conLayer.getName() + " at " + TextUtils.formatDistance(((RectangularShape)conRect).getMinX()) + "<=X<=" + TextUtils.formatDistance(((RectangularShape)conRect).getMaxX()) + " and " + TextUtils.formatDistance(((RectangularShape)conRect).getMinY()) + "<=Y<=" + TextUtils.formatDistance(((RectangularShape)conRect).getMaxY()) + " less than " + TextUtils.formatDistance(surround) + " to cut at (" + TextUtils.formatDistance(sb.getBounds().getCenterX()) + "," + TextUtils.formatDistance(sb.getBounds().getCenterY()) + ")";
                                            break;
                                        }
                                        curCuts[cutCount++] = new Rectangle2D.Double(((RectangularShape)conRect).getMinX(), ((RectangularShape)conRect).getMinY(), ((RectangularShape)conRect).getWidth(), ((RectangularShape)conRect).getHeight());
                                        SearchVertex sv = svCurrent;
                                        while (sv != null && (lastSv = sv.last) != null) {
                                            if (Math.min(sv.getZ(), lastSv.getZ()) == lowMetal && Math.max(sv.getZ(), lastSv.getZ()) == highMetal) {
                                                Rectangle2D[] svCutRects = sv.getCutLayer() == lowMetal ? sv.getCutRects() : lastSv.getCutRects();
                                                if (svCutRects != null) {
                                                    for (Rectangle2D cutRect : svCutRects) {
                                                        boolean oldSafe;
                                                        double dist = SeaOfGatesEngine.this.cutDistance(((RectangularShape)conRect).getMinX(), ((RectangularShape)conRect).getMaxX(), ((RectangularShape)conRect).getMinY(), ((RectangularShape)conRect).getMaxY(), cutRect.getMinX(), cutRect.getMaxX(), cutRect.getMinY(), cutRect.getMaxY());
                                                        boolean newSafe = DBMath.isGreaterThanOrEqualTo(dist, surround);
                                                        boolean bl = oldSafe = Math.abs(cutRect.getCenterX() - conCX) >= surround + vSize || Math.abs(cutRect.getCenterY() - conCY) >= surround + vSize;
                                                        if (newSafe) {
                                                            continue;
                                                        }
                                                        contactFailed = true;
                                                        if (!this.debuggingWavefront) break;
                                                        failedReason = conLayer.getName() + " cut at (" + TextUtils.formatDistance(conCX) + "," + TextUtils.formatDistance(conCY) + ") because it is too close (" + surround + ") to previous cut at (" + TextUtils.formatDistance(sv.getX()) + "," + TextUtils.formatDistance(sv.getY()) + ")";
                                                        break;
                                                    }
                                                }
                                                if (contactFailed) break;
                                            }
                                            sv = sv.last;
                                        }
                                        if (contactFailed) break;
                                    }
                                    if (contactFailed) {
                                        if (!this.debuggingWavefront) continue;
                                        failureReasons[contactNo] = failedReason;
                                        continue;
                                    }
                                    StringBuffer message = new StringBuffer();
                                    MutableBoolean error = new MutableBoolean(false);
                                    extraGeometryforMinArea = this.determineMinimumArea(svCurrent, curX, curY, curC, curZ, mv, conWid.doubleValue(), conHei.doubleValue(), error, message);
                                    if (error.booleanValue()) {
                                        if (message.length() <= 0) continue;
                                        contactFailed = true;
                                        if (!this.debuggingWavefront) continue;
                                        failureReasons[contactNo] = message.toString();
                                        continue;
                                    }
                                    whichContact = contactNo;
                                    cuts = curCuts;
                                    size2 = new Point2D.Double(conWid.doubleValue(), conHei.doubleValue());
                                    break;
                                }
                                if (whichContact < 0) {
                                    if (!this.debuggingWavefront) continue;
                                    String further = ": Blocked because:";
                                    for (int contactNo = 0; contactNo < failureReasons.length; ++contactNo) {
                                        MetalVia mv = nps.get(contactNo);
                                        further = further + "|In " + SeaOfGatesEngine.this.describe(mv.via);
                                        if (mv.orientation != 0) {
                                            further = further + " (rotated " + mv.orientation + ")";
                                        }
                                        further = further + " cannot place: " + failureReasons[contactNo];
                                    }
                                    this.completeDebugString(i, further);
                                    continue;
                                }
                            }
                            boolean bl = foundDest = DBMath.pointInRect(EPoint.fromLambda(nX, nY), this.toRect) && nZ == this.toZ;
                            if (svCurrent.isMustCompleteRoute() && !foundDest) {
                                if (!this.debuggingWavefront) continue;
                                this.completeDebugString(i, ": Switched to taper layer so must connect to destination");
                                continue;
                            }
                            if (svCurrent.isCantCompleteRoute() && foundDest) {
                                if (!this.debuggingWavefront) continue;
                                this.completeDebugString(i, ": Switched to taper layer too far from destination");
                                continue;
                            }
                            boolean hor = true;
                            if (SeaOfGatesEngine.this.sogp.isHorizontalEven()) {
                                if ((nZ + 1) % 2 != 0) {
                                    hor = false;
                                }
                            } else if ((nZ + 1) % 2 == 0) {
                                hor = false;
                            }
                            if (this.nr.forceGridArcs[nZ] && !foundDest) {
                                if (this.nr.gridLocationsX[nZ] != null && hor && !this.nr.isOnXGrid(nZ, nX)) {
                                    if (!this.debuggingWavefront) continue;
                                    this.completeDebugString(i, ": Not on X grid");
                                    continue;
                                }
                                if (this.nr.gridLocationsY[nZ] != null && !hor && !this.nr.isOnYGrid(nZ, nY)) {
                                    if (!this.debuggingWavefront) continue;
                                    this.completeDebugString(i, ": Not on Y grid");
                                    continue;
                                }
                            }
                            penaltyOffGridX = false;
                            boolean inGoalX = nX < this.toRect.getMinX() || nX > this.toRect.getMaxX();
                            if ((inGoalX &= nX != this.fromX) || this.nr.forceGridArcs[nZ]) {
                                if (this.nr.gridLocationsX[nZ] == null) {
                                    penaltyOffGridX = this.nr.downToGrainAlways(nX) != nX;
                                } else if (!hor) {
                                    penaltyOffGridX = !this.nr.isOnXGrid(nZ, nX);
                                }
                            }
                            penaltyOffGridY = false;
                            boolean inGoalY = nY < this.toRect.getMinY() || nY > this.toRect.getMaxY();
                            if ((inGoalY &= nY != this.fromY) || this.nr.forceGridArcs[nZ]) {
                                if (this.nr.gridLocationsY[nZ] == null) {
                                    penaltyOffGridY = this.nr.downToGrainAlways(nY) != nY;
                                } else if (hor) {
                                    penaltyOffGridY = !this.nr.isOnYGrid(nZ, nY);
                                }
                            }
                            int newFlags = svCurrent.flags;
                            if (curZ != nZ) {
                                newFlags &= 0xFFFFFFFD;
                            }
                            if (dz != 0) {
                                newFlags |= 1;
                            }
                            if (tooFarFromEnd) {
                                newFlags |= 2;
                            }
                            if (closeToEnd) {
                                newFlags |= 4;
                            }
                            svNext = new SearchVertex(nX, nY, nZ, nC, whichContact, cuts, size2, Math.min(curZ, nZ), this, newFlags);
                            if (this.debuggingWavefront) {
                                RoutingDebug.ensureDebuggingShadow(svNext, false);
                            }
                            if (extraGeometryforMinArea != null) {
                                svNext.setMoreGeometry(extraGeometryforMinArea);
                            }
                            if (dz == 0 && (Math.abs(dx) >= 2.0 || Math.abs(dy) >= 2.0)) {
                                svNext.setAutoGen(i);
                            }
                            svNext.last = svCurrent;
                            if (foundDest) {
                                if (this.debuggingWavefront) {
                                    RoutingDebug.saveSVLink(svNext, i);
                                    this.completeDebugString(i, ": Found Destination!");
                                }
                                destinationSV = svNext;
                                continue;
                            }
                            if (this.globalRoutingDelta != 0) {
                                svNext.globalRoutingBucket = this.getNextBucket(svCurrent, nX, nY);
                            }
                            newCost = svCurrent.cost;
                            costExplanation = "";
                            double distBefore = Math.sqrt((curX - this.toX) * (curX - this.toX) + (curY - this.toY) * (curY - this.toY));
                            double distAfter = Math.sqrt((nX - this.toX) * (nX - this.toX) + (nY - this.toY) * (nY - this.toY));
                            c = (int)((distAfter - distBefore) / 5.0);
                            newCost += c;
                            if (this.debuggingWavefront) {
                                costExplanation = " [COST: Progress-to-target=" + c;
                            }
                            if (dx != 0.0) {
                                if (curX >= this.toRect.getMinX() && curX <= this.toRect.getMaxX()) {
                                    c = 7;
                                    newCost += c;
                                    if (this.debuggingWavefront) {
                                        costExplanation = costExplanation + " Zero-X-progress=" + c;
                                    }
                                } else if ((this.toX - curX) * dx < 0.0) {
                                    if (curY >= this.toRect.getMinY() && curY <= this.toRect.getMaxY()) {
                                        c = 1;
                                        newCost += c;
                                        if (this.debuggingWavefront) {
                                            costExplanation = costExplanation + " Backward-X-progress-at-dest-Y=" + c;
                                        }
                                    } else {
                                        c = 15;
                                        newCost += c;
                                        if (this.debuggingWavefront) {
                                            costExplanation = costExplanation + " Backward-X-progress=" + c;
                                        }
                                    }
                                }
                                if (SeaOfGatesEngine.this.sogp.isFavorHorVer() && nZ % 2 == 0 == SeaOfGatesEngine.this.sogp.isHorizontalEven()) {
                                    c = (int)Math.round(20.0 * Math.abs(dx));
                                    newCost += c;
                                    if (this.debuggingWavefront) {
                                        costExplanation = costExplanation + " Not-alternating-metal=" + c;
                                    }
                                }
                            }
                            if (dy != 0.0) {
                                if (curY >= this.toRect.getMinY() && curY <= this.toRect.getMaxY()) {
                                    c = 7;
                                    newCost += c;
                                    if (this.debuggingWavefront) {
                                        costExplanation = costExplanation + " Zero-Y-progress=" + c;
                                    }
                                } else if ((this.toY - curY) * dy < 0.0) {
                                    if (curX >= this.toRect.getMinX() && curX <= this.toRect.getMaxX()) {
                                        c = 1;
                                        newCost += c;
                                        if (this.debuggingWavefront) {
                                            costExplanation = costExplanation + " Backward-Y-progress-at-dest-X=" + c;
                                        }
                                    } else {
                                        c = 15;
                                        newCost += c;
                                        if (this.debuggingWavefront) {
                                            costExplanation = costExplanation + " Backward-Y-progress=" + c;
                                        }
                                    }
                                }
                                if (SeaOfGatesEngine.this.sogp.isFavorHorVer() && nZ % 2 != 0 == SeaOfGatesEngine.this.sogp.isHorizontalEven()) {
                                    c = (int)Math.round(20.0 * Math.abs(dy));
                                    newCost += c;
                                    if (this.debuggingWavefront) {
                                        costExplanation = costExplanation + " Not-alternating-metal=" + c;
                                    }
                                }
                            }
                            if (dz == 0) break block218;
                            if (this.toZ != curZ) break block219;
                            c = 8;
                            newCost += c;
                            if (this.debuggingWavefront) {
                                costExplanation = costExplanation + " Layer-change=" + c;
                            }
                            break block220;
                        }
                        if ((this.toZ - curZ) * dz < 0) {
                            c = 9;
                            newCost += c;
                            if (this.debuggingWavefront) {
                                costExplanation = costExplanation + " Layer-change-wrong-direction=" + c;
                            }
                        }
                        break block220;
                    }
                    double jumpSize1 = Math.abs(this.getJumpSize(svCurrent, nX, nY, nZ, dx, dy, null));
                    double jumpSize2 = Math.abs(this.getJumpSize(svCurrent, curX, curY, curZ, -dx, -dy, null));
                    if (jumpSize1 > 1.0 && jumpSize2 > 1.0 && (c = (int)(jumpSize1 * jumpSize2 / 10.0)) > 0) {
                        newCost += c;
                        if (this.debuggingWavefront) {
                            costExplanation = costExplanation + " Fragments-track=" + c;
                        }
                    }
                    if (svCurrent.last != null) {
                        boolean xTurn = svCurrent.getX() != svCurrent.last.getX();
                        boolean yTurn = svCurrent.getY() != svCurrent.last.getY();
                        if (xTurn != (dx != 0.0) || yTurn != (dy != 0.0)) {
                            c = 1;
                            newCost += c;
                            if (this.debuggingWavefront) {
                                costExplanation = costExplanation + " Turning=" + c;
                            }
                        }
                    }
                }
                if (!SeaOfGatesEngine.this.favorArcs[nZ]) {
                    c = (int)((double)(80 * Math.abs(dz)) + 10.0 * Math.abs(dx + dy));
                    newCost += c;
                    if (this.debuggingWavefront) {
                        costExplanation = costExplanation + " Layer-unfavored=" + c;
                    }
                }
                if (penaltyOffGridX) {
                    c = 15;
                    newCost += c;
                    if (this.debuggingWavefront) {
                        costExplanation = costExplanation + " Off-X-grid=" + c;
                    }
                }
                if (penaltyOffGridY) {
                    c = 15;
                    newCost += c;
                    if (this.debuggingWavefront) {
                        costExplanation = costExplanation + " Off-Y-grid=" + c;
                    }
                }
                svNext.cost = newCost;
                if (alreadyThere != null) {
                    if (alreadyThere.getCost() < svNext.getCost()) {
                        if (!this.debuggingWavefront) continue;
                        this.completeDebugString(i, ": Already planned at lower cost (" + alreadyThere.getCost() + ")");
                        continue;
                    }
                    this.active.remove(alreadyThere);
                }
                this.setVertex(nX, nY, nZ, svNext);
                this.active.add(svNext);
                if (this.debuggingWavefront) {
                    this.completeDebugString(i, ": To (" + TextUtils.formatDistance(svNext.getX()) + "," + TextUtils.formatDistance(svNext.getY()) + "," + svNext.describeMetal() + ")" + costExplanation + "]");
                }
                if (!this.debuggingWavefront) continue;
                RoutingDebug.saveSVLink(svNext, i);
            }
            if (this.debuggingWavefront) {
                RoutingDebug.saveSVDetails(svCurrent, this.debugString, false);
            }
            if (destinationSV != null) {
                this.solution = destinationSV;
            }
            return destinationSV;
        }

        private SearchVertexAddon determineMinimumArea(SearchVertex svCurrent, double curX, double curY, int curC, int curZ, MetalVia mv, double conWid, double conHei, MutableBoolean error, StringBuffer message) {
            Rectangle2D conRect;
            if (SeaOfGatesEngine.this.minimumArea[curZ] > 0.0 && (conRect = this.getExtraGeometryForMinArea(svCurrent, mv, conWid, conHei, curX, curY, curZ)) != null) {
                double halfHei;
                if (SeaOfGatesEngine.this.routingBoundsLimit != null && (conRect.getMinX() < SeaOfGatesEngine.this.routingBoundsLimit.getMinX() || conRect.getMaxX() > SeaOfGatesEngine.this.routingBoundsLimit.getMaxX() || conRect.getMinY() < SeaOfGatesEngine.this.routingBoundsLimit.getMinY() || conRect.getMaxY() > SeaOfGatesEngine.this.routingBoundsLimit.getMaxY())) {
                    error.setValue(true);
                    if (this.debuggingWavefront) {
                        message.append("extra piece of layer " + SeaOfGatesEngine.this.primaryMetalLayer[curZ].getName() + " for minimum area" + " at " + TextUtils.formatDistance(conRect.getMinX()) + "<=X<=" + TextUtils.formatDistance(conRect.getMaxX()) + " and " + TextUtils.formatDistance(conRect.getMinY()) + "<=Y<=" + TextUtils.formatDistance(conRect.getMaxY()) + " is outside of routing bounds " + TextUtils.formatDistance(SeaOfGatesEngine.this.routingBoundsLimit.getMinX()) + "<=X<=" + TextUtils.formatDistance(SeaOfGatesEngine.this.routingBoundsLimit.getMaxX()) + " and " + TextUtils.formatDistance(SeaOfGatesEngine.this.routingBoundsLimit.getMinY()) + "<=Y<=" + TextUtils.formatDistance(SeaOfGatesEngine.this.routingBoundsLimit.getMaxY()));
                    }
                    return null;
                }
                double halfWid = conRect.getWidth() / 2.0;
                SOGBound sb = this.getMetalBlockageAndNotch(curZ, curC, halfWid, halfHei = conRect.getHeight() / 2.0, conRect.getCenterX(), conRect.getCenterY(), svCurrent, true);
                if (sb != null) {
                    error.setValue(true);
                    if (this.debuggingWavefront) {
                        message.append("extra piece of layer " + SeaOfGatesEngine.this.primaryMetalLayer[curZ].getName() + " for minimum area" + " at " + TextUtils.formatDistance(conRect.getMinX()) + "<=X<=" + TextUtils.formatDistance(conRect.getMaxX()) + " and " + TextUtils.formatDistance(conRect.getMinY()) + "<=Y<=" + TextUtils.formatDistance(conRect.getMaxY()) + " conflicts with " + TextUtils.formatDistance(sb.getBounds().getMinX()) + "<=X<=" + TextUtils.formatDistance(sb.getBounds().getMaxX()) + " and " + TextUtils.formatDistance(sb.getBounds().getMinY()) + "<=Y<=" + TextUtils.formatDistance(sb.getBounds().getMaxY()));
                    }
                    return null;
                }
                int c = curC;
                if (c > 0) {
                    --c;
                }
                PrimitiveNode pNp = SeaOfGatesEngine.this.metalPureLayerNodes[curZ][c];
                return new SearchVertexAddon(conRect, pNp);
            }
            return null;
        }

        private Rectangle2D getExtraGeometryForMinArea(SearchVertex svCurrent, MetalVia mv, double wid, double hei, double curX, double curY, int curZ) {
            Rectangle2D boundPrev;
            SeaOfGatesEngine.this.getOptimizedList(svCurrent, this.optimizedList);
            int lastInd = this.optimizedList.size() - 1;
            int prevViaMet = 0;
            for (int ind = 1; ind < this.optimizedList.size(); ++ind) {
                SearchVertex sv = this.optimizedList.get(ind);
                SearchVertex lastSv = this.optimizedList.get(ind - 1);
                if (sv.getZ() == lastSv.getZ()) continue;
                prevViaMet = Math.min(sv.getZ(), lastSv.getZ());
                lastInd = ind - 1;
                break;
            }
            SearchVertex svLast = this.optimizedList.get(lastInd);
            double width = this.nr.getArcWidth(curZ, curX, curY, svLast.getX(), svLast.getY());
            Point2D.Double head2 = new Point2D.Double(curX, curY);
            Point2D.Double tail = new Point2D.Double(svLast.getX(), svLast.getY());
            int ang = 0;
            if (((Point2D)head2).getX() != ((Point2D)tail).getX() || ((Point2D)head2).getY() != ((Point2D)tail).getY()) {
                ang = GenMath.figureAngle(tail, head2);
            }
            Poly poly = Poly.makeEndPointPoly(head2.distance(tail), width, ang, head2, width / 2.0, tail, width / 2.0, Poly.Type.FILLED);
            FixpRectangle boundArc = poly.getBounds2D();
            Rectangle2D bound = mv == null ? boundArc : this.getContactGeometry(mv, wid, hei, curX, curY, curZ);
            if (svLast.size == null) {
                boundPrev = boundArc;
            } else {
                List<MetalVia> nps2X;
                List<MetalVia> npsPrev = SeaOfGatesEngine.this.metalVias[prevViaMet].getVias();
                if ((this.nr.is2X(prevViaMet, svLast.getX(), svLast.getY(), svLast.getX(), svLast.getY()) || prevViaMet + 1 < numMetalLayers && this.nr.is2X(prevViaMet + 1, svLast.getX(), svLast.getY(), svLast.getX(), svLast.getY())) && (nps2X = SeaOfGatesEngine.this.metalVias2X[prevViaMet].getVias()).size() > 0) {
                    npsPrev = nps2X;
                }
                MetalVia mvPrev = npsPrev.get(svLast.getContactNo());
                boundPrev = this.getContactGeometry(mvPrev, svLast.size.getX(), svLast.size.getY(), svLast.getX(), svLast.getY(), curZ);
            }
            if (bound != null && bound.getWidth() * bound.getHeight() >= SeaOfGatesEngine.this.minimumArea[curZ]) {
                return null;
            }
            if (boundPrev != null && boundPrev.getWidth() * boundPrev.getHeight() >= SeaOfGatesEngine.this.minimumArea[curZ]) {
                return null;
            }
            if (boundArc != null && ((RectangularShape)boundArc).getWidth() * ((RectangularShape)boundArc).getHeight() >= SeaOfGatesEngine.this.minimumArea[curZ]) {
                return null;
            }
            Boolean hor = null;
            if (bound.equals(boundArc) && boundPrev.equals(boundArc)) {
                hor = ((RectangularShape)boundArc).getWidth() > ((RectangularShape)boundArc).getHeight() ? Boolean.TRUE : Boolean.FALSE;
            } else {
                if (bound.getMinX() == boundPrev.getMinX() && bound.getMinX() == ((RectangularShape)boundArc).getMinX() && bound.getMaxX() == boundPrev.getMaxX() && bound.getMaxX() == ((RectangularShape)boundArc).getMaxX()) {
                    hor = Boolean.FALSE;
                }
                if (bound.getMinY() == boundPrev.getMinY() && bound.getMinY() == ((RectangularShape)boundArc).getMinY() && bound.getMaxY() == boundPrev.getMaxY() && bound.getMaxY() == ((RectangularShape)boundArc).getMaxY()) {
                    hor = Boolean.TRUE;
                }
            }
            if (hor != null) {
                if (!hor.booleanValue()) {
                    double lY = Math.min(bound.getMinY(), Math.min(boundPrev.getMinY(), ((RectangularShape)boundArc).getMinY()));
                    double hY = Math.max(bound.getMaxY(), Math.max(boundPrev.getMaxY(), ((RectangularShape)boundArc).getMaxY()));
                    double area = (hY - lY) * (bound.getMaxX() - bound.getMinX());
                    if (DBMath.isLessThan(area, SeaOfGatesEngine.this.minimumArea[curZ])) {
                        double extraLength = (SeaOfGatesEngine.this.minimumArea[curZ] - area) / (bound.getMaxX() - bound.getMinX());
                        extraLength = Math.ceil(extraLength / SeaOfGatesEngine.this.minResolution) * SeaOfGatesEngine.this.minResolution;
                        if (bound.getCenterY() > boundPrev.getCenterY()) {
                            return new Rectangle2D.Double(bound.getMinX(), hY, bound.getWidth(), extraLength);
                        }
                        return new Rectangle2D.Double(bound.getMinX(), lY - extraLength, bound.getWidth(), extraLength);
                    }
                } else if (hor.booleanValue()) {
                    double lX = Math.min(bound.getMinX(), Math.min(boundPrev.getMinX(), ((RectangularShape)boundArc).getMinX()));
                    double hX = Math.max(bound.getMaxX(), Math.max(boundPrev.getMaxX(), ((RectangularShape)boundArc).getMaxX()));
                    double area = (hX - lX) * (bound.getMaxY() - bound.getMinY());
                    if (DBMath.isLessThan(area, SeaOfGatesEngine.this.minimumArea[curZ])) {
                        double extraLength = (SeaOfGatesEngine.this.minimumArea[curZ] - area) / (bound.getMaxY() - bound.getMinY());
                        extraLength = Math.ceil(extraLength / SeaOfGatesEngine.this.minResolution) * SeaOfGatesEngine.this.minResolution;
                        if (bound.getCenterX() > boundPrev.getCenterX()) {
                            return new Rectangle2D.Double(hX, bound.getMinY(), extraLength, bound.getHeight());
                        }
                        return new Rectangle2D.Double(lX - extraLength, bound.getMinY(), extraLength, bound.getHeight());
                    }
                }
            } else {
                PolyMerge pm = new PolyMerge();
                Layer layer = SeaOfGatesEngine.this.primaryMetalLayer[curZ];
                pm.addPolygon(layer, new PolyBase(bound));
                pm.addPolygon(layer, new PolyBase(boundPrev));
                pm.addPolygon(layer, new PolyBase(boundArc));
                double area = pm.getAreaOfLayer(layer);
                if (DBMath.isLessThan(area, SeaOfGatesEngine.this.minimumArea[curZ])) {
                    if (bound.getCenterX() == boundPrev.getCenterX() && bound.getCenterY() != boundPrev.getCenterY()) {
                        double lY = Math.min(bound.getMinY(), Math.min(boundPrev.getMinY(), ((RectangularShape)boundArc).getMinY()));
                        double hY = Math.max(bound.getMaxY(), Math.max(boundPrev.getMaxY(), ((RectangularShape)boundArc).getMaxY()));
                        double extraLength = (SeaOfGatesEngine.this.minimumArea[curZ] - area) / (bound.getMaxX() - bound.getMinX());
                        extraLength = Math.ceil(extraLength / SeaOfGatesEngine.this.minResolution) * SeaOfGatesEngine.this.minResolution;
                        if (bound.getCenterY() > boundPrev.getCenterY()) {
                            return new Rectangle2D.Double(bound.getMinX(), hY, bound.getWidth(), extraLength);
                        }
                        return new Rectangle2D.Double(bound.getMinX(), lY - extraLength, bound.getWidth(), extraLength);
                    }
                    if (bound.getCenterX() != boundPrev.getCenterX() && bound.getCenterY() == boundPrev.getCenterY()) {
                        double lX = Math.min(bound.getMinX(), Math.min(boundPrev.getMinX(), ((RectangularShape)boundArc).getMinX()));
                        double hX = Math.max(bound.getMaxX(), Math.max(boundPrev.getMaxX(), ((RectangularShape)boundArc).getMaxX()));
                        double extraLength = (SeaOfGatesEngine.this.minimumArea[curZ] - area) / (bound.getMaxY() - bound.getMinY());
                        extraLength = Math.ceil(extraLength / SeaOfGatesEngine.this.minResolution) * SeaOfGatesEngine.this.minResolution;
                        if (bound.getCenterX() > boundPrev.getCenterX()) {
                            return new Rectangle2D.Double(hX, bound.getMinY(), extraLength, bound.getHeight());
                        }
                        return new Rectangle2D.Double(lX - extraLength, bound.getMinY(), extraLength, bound.getHeight());
                    }
                    if (bound.getWidth() > bound.getHeight()) {
                        double extraLength = (SeaOfGatesEngine.this.minimumArea[curZ] - area) / (bound.getMaxY() - bound.getMinY());
                        extraLength = Math.ceil(extraLength / SeaOfGatesEngine.this.minResolution) * SeaOfGatesEngine.this.minResolution;
                        if (bound.getCenterX() > boundPrev.getCenterX()) {
                            return new Rectangle2D.Double(bound.getMaxX(), bound.getMinY(), extraLength, bound.getHeight());
                        }
                        return new Rectangle2D.Double(bound.getMinX() - extraLength, bound.getMinY(), extraLength, bound.getHeight());
                    }
                    double extraLength = (SeaOfGatesEngine.this.minimumArea[curZ] - area) / (bound.getMaxX() - bound.getMinX());
                    extraLength = Math.ceil(extraLength / SeaOfGatesEngine.this.minResolution) * SeaOfGatesEngine.this.minResolution;
                    if (bound.getCenterY() > boundPrev.getCenterY()) {
                        return new Rectangle2D.Double(bound.getMinX(), bound.getMaxY(), bound.getWidth(), extraLength);
                    }
                    return new Rectangle2D.Double(bound.getMinX(), bound.getMinY() - extraLength, bound.getWidth(), extraLength);
                }
            }
            return null;
        }

        private Rectangle2D getContactGeometry(MetalVia mv, double wid, double hei, double curX, double curY, int metNum) {
            PrimitiveNode np = mv.via;
            Orientation orient = Orientation.fromJava(mv.orientation * 10, false, false);
            NodeInst ni = NodeInst.makeDummyInstance(np, SeaOfGatesEngine.this.ep, EPoint.fromLambda(curX, curY), wid, hei, orient);
            FixpTransform trans = null;
            if (orient != Orientation.IDENT) {
                trans = ni.rotateOut();
            }
            Poly[] polys = np.getTechnology().getShapeOfNode(ni);
            for (int j = 0; j < polys.length; ++j) {
                Poly poly = polys[j];
                if (poly.getLayer().getFunction().getLevel() != metNum + 1) continue;
                if (trans != null) {
                    poly.transform(trans);
                }
                return poly.getBounds2D();
            }
            return null;
        }

        private int getNextBucket(SearchVertex svCurrent, double nX, double nY) {
            Rectangle2D limit;
            int start;
            int bucket;
            for (bucket = start = this.orderedBase[svCurrent.globalRoutingBucket]; bucket >= 0 && bucket < this.nr.buckets.length; bucket += this.globalRoutingDelta) {
                limit = this.nr.buckets[bucket];
                if (!DBMath.isGreaterThanOrEqualTo(nX, limit.getMinX()) || !DBMath.isLessThanOrEqualTo(nX, limit.getMaxX()) || !DBMath.isGreaterThanOrEqualTo(nY, limit.getMinY()) || !DBMath.isLessThanOrEqualTo(nY, limit.getMaxY())) continue;
                return bucket;
            }
            for (bucket = start - this.globalRoutingDelta; bucket >= 0 && bucket < this.nr.buckets.length; bucket -= this.globalRoutingDelta) {
                limit = this.nr.buckets[bucket];
                if (!DBMath.isGreaterThanOrEqualTo(nX, limit.getMinX()) || !DBMath.isLessThanOrEqualTo(nX, limit.getMaxX()) || !DBMath.isGreaterThanOrEqualTo(nY, limit.getMinY()) || !DBMath.isLessThanOrEqualTo(nY, limit.getMaxY())) continue;
                return bucket;
            }
            SeaOfGatesEngine.this.error("ERROR: Could not find next bucket going from (" + TextUtils.formatDistance(svCurrent.xv) + "," + TextUtils.formatDistance(svCurrent.yv) + ") to (" + TextUtils.formatDistance(nX) + "," + TextUtils.formatDistance(nY) + ") starting at bucket " + this.orderedBase[svCurrent.globalRoutingBucket] + " (really " + svCurrent.globalRoutingBucket + ") and going " + this.globalRoutingDelta);
            return svCurrent.globalRoutingBucket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void createRoute() {
            double width;
            Layer layer;
            ArcProto type;
            RouteNode goal;
            RouteNode newRN;
            Orientation orient;
            PrimitiveNode pNp;
            int parenPos;
            String routeName = this.nr.routeName;
            if (routeName.endsWith("...")) {
                routeName = routeName.substring(0, routeName.length() - 3);
            }
            if ((parenPos = routeName.lastIndexOf(40)) > 0) {
                routeName = routeName.substring(0, parenPos);
            }
            RouteNode fromRN = new RouteNode(this.from);
            RouteNode toRN = new RouteNode(this.to);
            RouteResolution resolution = this.nr.batch.resolution;
            if (this.nr.replaceA != null) {
                pNp = ((NeededRoute)this.nr).replaceA.via;
                orient = Orientation.fromJava(((NeededRoute)this.nr).replaceA.orientation * 10, false, false);
                newRN = new RouteNode(pNp, SeaOfGatesEngine.this, EPoint.fromLambda(this.nr.aX, this.nr.aY), pNp.getDefWidth(SeaOfGatesEngine.this.ep), pNp.getDefHeight(SeaOfGatesEngine.this.ep), orient, null, this.nr);
                resolution.addNode(newRN);
                goal = this.fromBit == 2 ? fromRN : toRN;
                for (RouteArc ra : resolution.arcsToRoute) {
                    if (ra.from == goal) {
                        ra.from = newRN;
                    }
                    if (ra.to != goal) continue;
                    ra.to = newRN;
                }
                type = SeaOfGatesEngine.this.metalArcs[this.nr.replaceAZ][this.nr.replaceAC];
                layer = SeaOfGatesEngine.this.metalLayers[this.nr.replaceAZ][this.nr.replaceAC];
                width = this.nr.getArcWidth(this.nr.replaceAZ, this.nr.aX, this.nr.aY, this.nr.aX, this.nr.aY);
                resolution.addArc(new RouteArc(type, routeName, SeaOfGatesEngine.this, layer, width, newRN, goal, this.nr));
                if (this.fromBit == 2) {
                    fromRN = newRN;
                } else {
                    toRN = newRN;
                }
                routeName = null;
            }
            if (this.nr.replaceB != null) {
                pNp = ((NeededRoute)this.nr).replaceB.via;
                orient = Orientation.fromJava(((NeededRoute)this.nr).replaceB.orientation * 10, false, false);
                newRN = new RouteNode(pNp, SeaOfGatesEngine.this, EPoint.fromLambda(this.nr.bX, this.nr.bY), pNp.getDefWidth(SeaOfGatesEngine.this.ep), pNp.getDefHeight(SeaOfGatesEngine.this.ep), orient, null, this.nr);
                resolution.addNode(newRN);
                goal = this.fromBit == 2 ? toRN : fromRN;
                for (RouteArc ra : resolution.arcsToRoute) {
                    if (ra.from == goal) {
                        ra.from = newRN;
                    }
                    if (ra.to != goal) continue;
                    ra.to = newRN;
                }
                type = SeaOfGatesEngine.this.metalArcs[this.nr.replaceBZ][this.nr.replaceBC];
                layer = SeaOfGatesEngine.this.metalLayers[this.nr.replaceBZ][this.nr.replaceBC];
                width = this.nr.getArcWidth(this.nr.replaceBZ, this.nr.bX, this.nr.bY, this.nr.bX, this.nr.bY);
                resolution.addArc(new RouteArc(type, routeName, SeaOfGatesEngine.this, layer, width, newRN, goal, this.nr));
                if (this.fromBit == 2) {
                    toRN = newRN;
                } else {
                    fromRN = newRN;
                }
                routeName = null;
            }
            RouteNode lastRN = toRN;
            Poly toPoly = this.to.getPoly();
            if (!DBMath.pointInRect(EPoint.fromLambda(this.toX, this.toY), this.toRect) && this.vertices.size() >= 2) {
                RouteArc ra;
                RouteNode rn;
                SearchVertex v1 = this.vertices.get(0);
                SearchVertex v2 = this.vertices.get(1);
                int tc = this.toC;
                if (tc > 0) {
                    --tc;
                }
                ArcProto type2 = SeaOfGatesEngine.this.metalArcs[this.toZ][tc];
                Layer layer2 = SeaOfGatesEngine.this.metalLayers[this.toZ][tc];
                double width2 = this.nr.getArcWidth(this.toZ, this.toX, this.toY, this.toX, this.toY);
                PrimitiveNode np = SeaOfGatesEngine.this.metalArcs[this.toZ][tc].findPinProto();
                if (v1.getX() == v2.getX()) {
                    rn = new RouteNode(np, SeaOfGatesEngine.this, EPoint.fromLambda(v1.getX(), toPoly.getCenterY()), np.getDefWidth(SeaOfGatesEngine.this.ep), np.getDefHeight(SeaOfGatesEngine.this.ep), Orientation.IDENT, null, this.nr);
                    resolution.addNode(rn);
                    ra = new RouteArc(type2, routeName, SeaOfGatesEngine.this, layer2, width2, rn, toRN, this.nr);
                    routeName = null;
                    resolution.addArc(ra);
                    lastRN = rn;
                } else if (v1.getY() == v2.getY()) {
                    rn = new RouteNode(np, SeaOfGatesEngine.this, EPoint.fromLambda(toPoly.getCenterX(), v1.getY()), np.getDefWidth(SeaOfGatesEngine.this.ep), np.getDefHeight(SeaOfGatesEngine.this.ep), Orientation.IDENT, null, this.nr);
                    resolution.addNode(rn);
                    ra = new RouteArc(type2, routeName, SeaOfGatesEngine.this, layer2, width2, rn, toRN, this.nr);
                    routeName = null;
                    resolution.addArc(ra);
                    lastRN = rn;
                }
            }
            for (int i = 0; i < this.vertices.size(); ++i) {
                RouteNode piRN;
                SearchVertex sv = this.vertices.get(i);
                SearchVertexAddon sva = sv.getMoreGeometry();
                if (sva != null) {
                    Rectangle2D addedGeometry = sva.getGeometry();
                    PrimitiveNode pNp2 = sva.getPureLayerNode();
                    RouteNode rn = new RouteNode(pNp2, SeaOfGatesEngine.this, EPoint.fromLambda(addedGeometry.getCenterX(), addedGeometry.getCenterY()), addedGeometry.getWidth(), addedGeometry.getHeight(), Orientation.IDENT, null, this.nr);
                    resolution.addNode(rn);
                }
                boolean madeContacts = false;
                while (i < this.vertices.size() - 1) {
                    double arcWid;
                    List<MetalVia> nps2X;
                    SearchVertex svNext = this.vertices.get(i + 1);
                    if (sv.getX() != svNext.getX() || sv.getY() != svNext.getY() || sv.getZ() == svNext.getZ()) break;
                    int metNum = Math.min(sv.getZ(), svNext.getZ());
                    List<MetalVia> nps = SeaOfGatesEngine.this.metalVias[metNum].getVias();
                    if ((this.nr.is2X(metNum, sv.getX(), sv.getY(), sv.getX(), sv.getY()) || metNum + 1 < numMetalLayers && this.nr.is2X(metNum + 1, sv.getX(), sv.getY(), sv.getX(), sv.getY())) && (nps2X = SeaOfGatesEngine.this.metalVias2X[metNum].getVias()).size() > 0) {
                        nps = nps2X;
                    }
                    int whichContact = sv.getContactNo();
                    MetalVia mv = nps.get(whichContact);
                    PrimitiveNode np = mv.via;
                    Orientation orient2 = Orientation.fromJava(mv.orientation * 10, false, false);
                    Point2D size2 = sv.getSize();
                    double conWid = size2.getX();
                    double conHei = size2.getY();
                    double otherX = sv.getX();
                    double otherY = sv.getY();
                    if (i > 0) {
                        otherX = this.vertices.get(i - 1).getX();
                        otherY = this.vertices.get(i - 1).getY();
                    }
                    double width3 = this.nr.getArcWidth(sv.getZ(), sv.getX(), sv.getY(), otherX, otherY);
                    double fartherX = sv.getX();
                    double fartherY = sv.getY();
                    for (int j = i + 1; j < this.vertices.size(); ++j) {
                        SearchVertex svFarther = this.vertices.get(j);
                        fartherX = svFarther.getX();
                        fartherY = svFarther.getY();
                        if (svFarther.getZ() != svNext.getZ()) break;
                    }
                    double widthNext = this.nr.getArcWidth(svNext.getZ(), sv.getX(), sv.getY(), fartherX, fartherY);
                    if (mv.horMetal == sv.getZ()) {
                        double arcWid2 = width3 + mv.horMetalInset;
                        if (arcWid2 < conHei) {
                            conHei = arcWid2;
                        }
                    } else if (mv.horMetal == svNext.getZ() && (arcWid = widthNext + mv.horMetalInset) < conHei) {
                        conHei = arcWid;
                    }
                    if (mv.verMetal == sv.getZ()) {
                        arcWid2 = width3 + mv.verMetalInset;
                        if (arcWid2 < conWid) {
                            conWid = arcWid2;
                        }
                    } else if (mv.verMetal == svNext.getZ() && (arcWid2 = widthNext + mv.verMetalInset) < conWid) {
                        conWid = arcWid2;
                    }
                    int sCol = sv.getC();
                    if (sCol > 0) {
                        --sCol;
                    }
                    ArcProto type3 = SeaOfGatesEngine.this.metalArcs[sv.getZ()][sCol];
                    Layer layer3 = SeaOfGatesEngine.this.metalLayers[sv.getZ()][sCol];
                    RouteNode rn = new RouteNode(np, SeaOfGatesEngine.this, EPoint.fromLambda(sv.getX(), sv.getY()), conWid, conHei, orient2, null, this.nr);
                    resolution.addNode(rn);
                    RouteArc ra = new RouteArc(type3, routeName, SeaOfGatesEngine.this, layer3, width3, lastRN, rn, this.nr);
                    routeName = null;
                    resolution.addArc(ra);
                    lastRN = rn;
                    madeContacts = true;
                    sv = svNext;
                    ++i;
                }
                if (madeContacts && i != this.vertices.size() - 1) continue;
                int sCol = sv.getC();
                if (sCol > 0) {
                    --sCol;
                }
                PrimitiveNode np = SeaOfGatesEngine.this.metalArcs[sv.getZ()][sCol].findPinProto();
                if (i == this.vertices.size() - 1) {
                    piRN = fromRN;
                    if (!DBMath.pointInRect(EPoint.fromLambda(sv.getX(), sv.getY()), this.fromRect) && this.vertices.size() >= 2) {
                        RouteArc ra;
                        int fc = this.fromC;
                        if (fc > 0) {
                            --fc;
                        }
                        SearchVertex v1 = this.vertices.get(this.vertices.size() - 2);
                        SearchVertex v2 = this.vertices.get(this.vertices.size() - 1);
                        ArcProto type4 = SeaOfGatesEngine.this.metalArcs[this.fromZ][fc];
                        Layer layer4 = SeaOfGatesEngine.this.metalLayers[this.fromZ][fc];
                        double width4 = this.nr.getArcWidth(this.fromZ, this.fromX, this.fromY, this.fromX, this.fromY);
                        if (v1.getX() == v2.getX()) {
                            PrimitiveNode pNp3 = SeaOfGatesEngine.this.metalArcs[this.fromZ][fc].findPinProto();
                            piRN = new RouteNode(pNp3, SeaOfGatesEngine.this, EPoint.fromLambda(v1.getX(), this.fromY), np.getDefWidth(SeaOfGatesEngine.this.ep), np.getDefHeight(SeaOfGatesEngine.this.ep), Orientation.IDENT, null, this.nr);
                            resolution.addNode(piRN);
                            ra = new RouteArc(type4, routeName, SeaOfGatesEngine.this, layer4, width4, piRN, fromRN, this.nr);
                            routeName = null;
                            resolution.addArc(ra);
                        } else if (v1.getY() == v2.getY()) {
                            PrimitiveNode pNp4 = SeaOfGatesEngine.this.metalArcs[this.fromZ][fc].findPinProto();
                            piRN = new RouteNode(pNp4, SeaOfGatesEngine.this, EPoint.fromLambda(this.fromX, v1.getY()), np.getDefWidth(SeaOfGatesEngine.this.ep), np.getDefHeight(SeaOfGatesEngine.this.ep), Orientation.IDENT, null, this.nr);
                            resolution.addNode(piRN);
                            ra = new RouteArc(type4, routeName, SeaOfGatesEngine.this, layer4, width4, piRN, fromRN, this.nr);
                            routeName = null;
                            resolution.addArc(ra);
                        }
                    }
                } else {
                    PortInst pi = null;
                    if (this.nr.spineTapMap != null) {
                        pi = (PortInst)this.nr.spineTapMap.get(sv);
                    }
                    piRN = new RouteNode(np, SeaOfGatesEngine.this, EPoint.fromLambda(sv.getX(), sv.getY()), np.getDefWidth(SeaOfGatesEngine.this.ep), np.getDefHeight(SeaOfGatesEngine.this.ep), Orientation.IDENT, pi, this.nr);
                    resolution.addNode(piRN);
                }
                if (lastRN != null) {
                    ArcProto type5 = SeaOfGatesEngine.this.metalArcs[sv.getZ()][sCol];
                    Layer layer5 = SeaOfGatesEngine.this.metalLayers[sv.getZ()][sCol];
                    Layer primaryLayer = SeaOfGatesEngine.this.primaryMetalLayer[sv.getZ()];
                    double width5 = this.nr.getArcWidth(sv.getZ(), sv.getX(), sv.getY(), sv.getX(), sv.getY());
                    if (i == 0 && !DBMath.rectsIntersect(lastRN.rect, piRN.rect)) {
                        boolean covered;
                        double hY;
                        double lY;
                        double hX;
                        double lX;
                        double tY;
                        double tX;
                        double fY;
                        double fX;
                        block64: {
                            fX = lastRN.getLoc().getX();
                            fY = lastRN.getLoc().getY();
                            tX = piRN.getLoc().getX();
                            tY = piRN.getLoc().getY();
                            lX = Math.min(fX, tX) - width5 / 2.0;
                            hX = Math.max(fX, tX) + width5 / 2.0;
                            lY = Math.min(fY, tY) - width5 / 2.0;
                            hY = Math.max(fY, tY) + width5 / 2.0;
                            Rectangle2D.Double searchArea = new Rectangle2D.Double(lX, lY, hX - lX, hY - lY);
                            BlockageTree bTree = SeaOfGatesEngine.this.rTrees.getMetalTree(primaryLayer);
                            covered = false;
                            bTree.lock();
                            try {
                                if (bTree.isEmpty()) break block64;
                                Iterator sea = bTree.search(searchArea);
                                while (sea.hasNext()) {
                                    SOGBound sBound = (SOGBound)sea.next();
                                    ERectangle bound = sBound.getBounds();
                                    if (!(((RectangularShape)bound).getMinX() <= lX) || !(((RectangularShape)bound).getMaxX() >= hX) || !(((RectangularShape)bound).getMinY() <= lY) || !(((RectangularShape)bound).getMaxY() >= hY)) continue;
                                    covered = true;
                                    break;
                                }
                            }
                            finally {
                                bTree.unlock();
                            }
                        }
                        if (!covered) {
                            boolean geomOK = false;
                            if (fX == tX || fY == tY) {
                                SOGBound errSV = this.getMetalBlockageAndNotch(sv.getZ(), sv.getC(), (hX - lX) / 2.0, (hY - lY) / 2.0, (hX + lX) / 2.0, (hY + lY) / 2.0, null, false);
                                if (errSV == null) {
                                    geomOK = true;
                                }
                            } else {
                                RouteArc ra;
                                double bend1X = fX;
                                double bend1Y = tY;
                                double bend2X = tX;
                                double bend2Y = fY;
                                double bend1aLX = lX;
                                double bend1aHX = lX + width5;
                                double bend1aLY = lY;
                                double bend1aHY = hY;
                                double bend1bLX = lX;
                                double bend1bHX = hX;
                                double bend1bLY = hY - width5;
                                double bend1bHY = hY;
                                double bend2aLX = lX;
                                double bend2aHX = hX;
                                double bend2aLY = lY;
                                double bend2aHY = lY + width5;
                                double bend2bLX = hX - width5;
                                double bend2bHX = hX;
                                double bend2bLY = lY;
                                double bend2bHY = hY;
                                SOGBound errSVa = this.getMetalBlockageAndNotch(sv.getZ(), sv.getC(), (bend1aHX - bend1aLX) / 2.0, (bend1aHY - bend1aLY) / 2.0, (bend1aHX + bend1aLX) / 2.0, (bend1aHY + bend1aLY) / 2.0, null, false);
                                SOGBound errSVb = this.getMetalBlockageAndNotch(sv.getZ(), sv.getC(), (bend1bHX - bend1bLX) / 2.0, (bend1bHY - bend1bLY) / 2.0, (bend1bHX + bend1bLX) / 2.0, (bend1bHY + bend1bLY) / 2.0, null, false);
                                if (errSVa == null && errSVb == null) {
                                    RouteNode bend1RN = new RouteNode(np, SeaOfGatesEngine.this, EPoint.fromLambda(bend1X, bend1Y), np.getDefWidth(SeaOfGatesEngine.this.ep), np.getDefHeight(SeaOfGatesEngine.this.ep), Orientation.IDENT, null, this.nr);
                                    resolution.addNode(bend1RN);
                                    ra = new RouteArc(type5, routeName, SeaOfGatesEngine.this, layer5, width5, piRN, bend1RN, this.nr);
                                    routeName = null;
                                    resolution.addArc(ra);
                                    piRN = bend1RN;
                                    geomOK = true;
                                    System.out.println("AVOIDED UNIVERSAL ARC BECAUSE BEND 1 WORKS");
                                } else {
                                    errSVa = this.getMetalBlockageAndNotch(sv.getZ(), sv.getC(), (bend2aHX - bend2aLX) / 2.0, (bend2aHY - bend2aLY) / 2.0, (bend2aHX + bend2aLX) / 2.0, (bend2aHY + bend2aLY) / 2.0, null, false);
                                    errSVb = this.getMetalBlockageAndNotch(sv.getZ(), sv.getC(), (bend2bHX - bend2bLX) / 2.0, (bend2bHY - bend2bLY) / 2.0, (bend2bHX + bend2bLX) / 2.0, (bend2bHY + bend2bLY) / 2.0, null, false);
                                    if (errSVa == null && errSVb == null) {
                                        RouteNode bend2RN = new RouteNode(np, SeaOfGatesEngine.this, EPoint.fromLambda(bend2X, bend2Y), np.getDefWidth(SeaOfGatesEngine.this.ep), np.getDefHeight(SeaOfGatesEngine.this.ep), Orientation.IDENT, null, this.nr);
                                        resolution.addNode(bend2RN);
                                        ra = new RouteArc(type5, routeName, SeaOfGatesEngine.this, layer5, width5, piRN, bend2RN, this.nr);
                                        routeName = null;
                                        resolution.addArc(ra);
                                        piRN = bend2RN;
                                        geomOK = true;
                                        System.out.println("AVOIDED UNIVERSAL ARC BECAUSE BEND 2 WORKS");
                                    }
                                }
                            }
                            if (!geomOK) {
                                System.out.println("WARNING: Placing Universal arc on route from port " + this.from.getPortProto().getName() + " of node " + SeaOfGatesEngine.this.describe(this.from.getNodeInst()) + " AT (" + TextUtils.formatDistance(this.fromX) + "," + TextUtils.formatDistance(this.fromY) + "," + SeaOfGatesEngine.describeMetal(this.fromZ, this.fromC) + ") to port " + this.to.getPortProto().getName() + " of node " + SeaOfGatesEngine.this.describe(this.to.getNodeInst()) + " AT (" + TextUtils.formatDistance(this.toX) + "," + TextUtils.formatDistance(this.toY) + "," + SeaOfGatesEngine.describeMetal(this.toZ, this.toC) + ")");
                                type5 = Generic.tech().universal_arc;
                                layer5 = null;
                                width5 = 0.0;
                            } else {
                                System.out.println("AVOIDED UNIVERSAL ARC BECAUSE EXISTING LAYER IS DRC CLEAN");
                            }
                        } else {
                            System.out.println("AVOIDED UNIVERSAL ARC BECAUSE EXISTING LAYER SURROUNDS OK");
                        }
                    }
                    RouteArc ra = new RouteArc(type5, routeName, SeaOfGatesEngine.this, layer5, width5, lastRN, piRN, this.nr);
                    routeName = null;
                    resolution.addArc(ra);
                }
                lastRN = piRN;
            }
            if (this.nr.endBlockages != null) {
                ArrayList<Layer> allLayers = new ArrayList<Layer>();
                for (Layer lay : this.nr.endBlockages.keySet()) {
                    allLayers.add(lay);
                }
                for (Layer lay : allLayers) {
                    BlockageTree bTree = SeaOfGatesEngine.this.rTrees.getMetalTree(lay);
                    bTree.lock();
                    try {
                        List endBlocks = (List)this.nr.endBlockages.get(lay);
                        for (SOGBound endBlock : endBlocks) {
                            RTNode origRoot = bTree.getRoot();
                            RTNode<SOGBound> newRoot = RTNode.unLinkGeom(null, origRoot, endBlock, false);
                            if (newRoot == origRoot) continue;
                            bTree.setRoot(newRoot);
                        }
                        this.nr.endBlockages.remove(lay);
                    }
                    finally {
                        bTree.unlock();
                    }
                }
            }
        }

        private Double getHorizontalBlockage(double xPos, double yPos, double drDist, double xBlock, double yBlock) {
            double dY = yBlock - yPos;
            if (dY >= drDist) {
                return null;
            }
            double dX = Math.sqrt(drDist * drDist - dY * dY);
            if (xPos > xBlock) {
                return new Double(xBlock + dX);
            }
            return new Double(xBlock - dX);
        }

        private Double getVerticalBlockage(double xPos, double yPos, double drDist, double xBlock, double yBlock) {
            double dX = xBlock - xPos;
            if (dX >= drDist) {
                return null;
            }
            double dY = Math.sqrt(drDist * drDist - dX * dX);
            if (yPos > yBlock) {
                return new Double(yBlock + dY);
            }
            return new Double(yBlock - dY);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private double getJumpSize(SearchVertex sv, double curX, double curY, int curZ, double dx, double dy, StringBuffer explanation) {
            Rectangle2D jumpBound = this.nr.jumpBound;
            double width = this.nr.getArcWidth(curZ, curX, curY, curX + dx, curY + dy);
            double halfWidth = width / 2.0;
            double[] fromSurround = this.nr.getSpacingRule(curZ, width, 50.0);
            double lX = curX - halfWidth;
            double hX = curX + halfWidth;
            double lY = curY - halfWidth;
            double hY = curY + halfWidth;
            if (dx > 0.0) {
                hX = jumpBound.getMaxX() + halfWidth;
            } else if (dx < 0.0) {
                lX = jumpBound.getMinX() - halfWidth;
            } else if (dy > 0.0) {
                hY = jumpBound.getMaxY() + halfWidth;
            } else if (dy < 0.0) {
                lY = jumpBound.getMinY() - halfWidth;
            }
            BlockageTree bTree = SeaOfGatesEngine.this.rTrees.getMetalTree(SeaOfGatesEngine.this.primaryMetalLayer[curZ]);
            RectangularShape topX = null;
            RectangularShape botX = null;
            RectangularShape topY = null;
            RectangularShape botY = null;
            bTree.lock();
            try {
                if (!bTree.isEmpty()) {
                    double lXSearch = lX - fromSurround[0];
                    double hXSearch = hX + fromSurround[0];
                    double lYSearch = lY - fromSurround[1];
                    double hYSearch = hY + fromSurround[1];
                    Rectangle2D.Double searchArea = new Rectangle2D.Double(lXSearch, lYSearch, hXSearch - lXSearch, hYSearch - lYSearch);
                    Iterator sea = bTree.search(searchArea);
                    while (sea.hasNext()) {
                        double yBlock;
                        double xBlock;
                        double drDist;
                        double diff2;
                        SOGBound sBound = (SOGBound)sea.next();
                        ERectangle bound = sBound.getBounds();
                        if (sBound.isSameBasicNet(this.nr.netID)) continue;
                        if (lX <= ((RectangularShape)bound).getMaxX() && hX >= ((RectangularShape)bound).getMinX()) {
                            if (lY <= ((RectangularShape)bound).getMaxY() && hY >= ((RectangularShape)bound).getMinY()) {
                                if (dx > 0.0 && ((RectangularShape)bound).getMinX() - fromSurround[0] < hX) {
                                    hX = ((RectangularShape)bound).getMinX() - fromSurround[0];
                                    topX = bound;
                                }
                                if (dx < 0.0 && ((RectangularShape)bound).getMaxX() + fromSurround[0] > lX) {
                                    lX = ((RectangularShape)bound).getMaxX() + fromSurround[0];
                                    botX = bound;
                                }
                                if (dy > 0.0 && ((RectangularShape)bound).getMinY() - fromSurround[1] < hY) {
                                    hY = ((RectangularShape)bound).getMinY() - fromSurround[1];
                                    topY = bound;
                                }
                                if (!(dy < 0.0) || !(((RectangularShape)bound).getMaxY() + fromSurround[1] > lY)) continue;
                                lY = ((RectangularShape)bound).getMaxY() + fromSurround[1];
                                botY = bound;
                                continue;
                            }
                            diff2 = (lY + hY) / 2.0 > (((RectangularShape)bound).getMinY() + ((RectangularShape)bound).getMaxY()) / 2.0 ? lY - ((RectangularShape)bound).getMaxY() : ((RectangularShape)bound).getMinY() - hY;
                            if (DBMath.isGreaterThanOrEqualTo(diff2, fromSurround[1])) {
                                continue;
                            }
                        } else if (lY <= ((RectangularShape)bound).getMaxY() && hY >= ((RectangularShape)bound).getMinY()) {
                            diff2 = (lX + hX) / 2.0 > (((RectangularShape)bound).getMinX() + ((RectangularShape)bound).getMaxX()) / 2.0 ? lX - ((RectangularShape)bound).getMaxX() : ((RectangularShape)bound).getMinX() - hX;
                            if (DBMath.isGreaterThanOrEqualTo(diff2, fromSurround[0])) {
                                continue;
                            }
                        } else {
                            double diff3;
                            double cut1CornerY;
                            double cut2CornerY;
                            double cut1CornerX;
                            double cut2CornerX;
                            if ((((RectangularShape)bound).getMinX() + ((RectangularShape)bound).getMaxX()) / 2.0 < (lX + hX) / 2.0) {
                                cut2CornerX = ((RectangularShape)bound).getMaxX();
                                cut1CornerX = lX;
                            } else {
                                cut2CornerX = ((RectangularShape)bound).getMinX();
                                cut1CornerX = hX;
                            }
                            if ((((RectangularShape)bound).getMinY() + ((RectangularShape)bound).getMaxY()) / 2.0 < (lY + hY) / 2.0) {
                                cut2CornerY = ((RectangularShape)bound).getMaxY();
                                cut1CornerY = lY;
                            } else {
                                cut2CornerY = ((RectangularShape)bound).getMinY();
                                cut1CornerY = hY;
                            }
                            double dX = Math.abs(cut2CornerX - cut1CornerX);
                            double dY = Math.abs(cut2CornerY - cut1CornerY);
                            if (DBMath.isGreaterThanOrEqualTo(dX, fromSurround[0]) || DBMath.isGreaterThanOrEqualTo(dY, fromSurround[1]) || DBMath.isGreaterThanOrEqualTo(diff3 = Math.sqrt(dX * dX + dY * dY), Math.max(fromSurround[0], fromSurround[1]))) continue;
                        }
                        if (dx != 0.0) {
                            drDist = Math.max(fromSurround[0], fromSurround[1]);
                            xBlock = ((RectangularShape)bound).getCenterX() < curX ? ((RectangularShape)bound).getMaxX() : ((RectangularShape)bound).getMinX();
                            yBlock = ((RectangularShape)bound).getCenterY() < curY ? ((RectangularShape)bound).getMaxY() : ((RectangularShape)bound).getMinY();
                            Double lYintX = this.getHorizontalBlockage(curX, lY, drDist, xBlock, yBlock);
                            Double hYintX = this.getHorizontalBlockage(curX, hY, drDist, xBlock, yBlock);
                            if (dx < 0.0) {
                                if (lYintX != null && lYintX > lX && lYintX <= curX) {
                                    lX = lYintX;
                                    botX = bound;
                                }
                                if (hYintX == null || !(hYintX > lX) || !(hYintX <= curX)) continue;
                                lX = hYintX;
                                botX = bound;
                                continue;
                            }
                            if (lYintX != null && lYintX < hX && lYintX >= curX) {
                                hX = lYintX;
                                topX = bound;
                            }
                            if (hYintX == null || !(hYintX < hX) || !(hYintX >= curX)) continue;
                            hX = hYintX;
                            topX = bound;
                            continue;
                        }
                        drDist = Math.max(fromSurround[0], fromSurround[1]);
                        xBlock = ((RectangularShape)bound).getCenterX() < curX ? ((RectangularShape)bound).getMaxX() : ((RectangularShape)bound).getMinX();
                        yBlock = ((RectangularShape)bound).getCenterY() < curY ? ((RectangularShape)bound).getMaxY() : ((RectangularShape)bound).getMinY();
                        Double lXintY = this.getVerticalBlockage(lX, curY, drDist, xBlock, yBlock);
                        Double hXintY = this.getVerticalBlockage(hX, curY, drDist, xBlock, yBlock);
                        if (dy < 0.0) {
                            if (lXintY != null && lXintY > lY && lXintY <= curY) {
                                lY = lXintY;
                                botY = bound;
                            }
                            if (hXintY == null || !(hXintY > lY) || !(hXintY <= curY)) continue;
                            lY = hXintY;
                            botY = bound;
                            continue;
                        }
                        if (lXintY != null && lXintY < hY && lXintY >= curY) {
                            hY = lXintY;
                            topY = bound;
                        }
                        if (hXintY == null || !(hXintY < hY) || !(hXintY >= curY)) continue;
                        hY = hXintY;
                        topY = bound;
                    }
                }
            }
            finally {
                bTree.unlock();
            }
            if (dx > 0.0) {
                dx = this.nr.downToGrain(hX - halfWidth) - curX;
                if (this.fromTaperLen >= 0.0 && !sv.isOffInitialSegment() && dx > this.fromTaperLen) {
                    dx = this.fromTaperLen;
                }
                if (curZ == this.toZ && curY == this.toY && curX < this.toX && curX + dx > this.toX) {
                    dx = this.toX - curX;
                }
                if (curX + dx > this.toX && curY >= this.toRect.getMinY() && curY <= this.toRect.getMaxY() && curZ == this.toZ) {
                    dx = this.toX - curX;
                } else {
                    Rectangle2D limit;
                    if (!SeaOfGatesEngine.inDestGrid(this.toRectGridded, curX + dx, curY)) {
                        dx = this.nr.getLowerXGrid(curZ, curX + dx).getCoordinate() - curX;
                    }
                    if (this.globalRoutingDelta != 0 && curX + dx > (limit = this.orderedBuckets[sv.globalRoutingBucket]).getMaxX()) {
                        Rectangle2D originalBucket = this.nr.buckets[sv.globalRoutingBucket];
                        dx = limit.getMaxX() - curX;
                        if (curX >= originalBucket.getMinX() && curX >= originalBucket.getMaxX() && curX + dx > originalBucket.getMaxX()) {
                            dx -= originalBucket.getWidth() / 2.0;
                        }
                        dx = this.nr.getClosestXGrid(curZ, curX + dx).getCoordinate() - curX;
                    }
                    if (curX + dx > this.toRect.getMaxX() || curX + dx < this.toRect.getMinX()) {
                        dx = this.nr.downToGrainAlways(curX + dx) - curX;
                    }
                }
                if (explanation != null && topX != null) {
                    explanation.append("rect at " + TextUtils.formatDistance(topX.getMinX()) + "<=X<=" + TextUtils.formatDistance(topX.getMaxX()) + " and " + TextUtils.formatDistance(topX.getMinY()) + "<=Y<=" + TextUtils.formatDistance(topX.getMaxY()) + " which is " + TextUtils.formatDistance(fromSurround[0]));
                    if (fromSurround[0] != fromSurround[1]) {
                        explanation.append("/" + TextUtils.formatDistance(fromSurround[1]));
                    }
                    explanation.append(" from rect " + TextUtils.formatDistance(lX) + "<=X<=" + TextUtils.formatDistance(hX) + " and " + TextUtils.formatDistance(lY) + "<=Y<=" + TextUtils.formatDistance(hY));
                }
                return dx;
            }
            if (dx < 0.0) {
                dx = this.nr.upToGrain(lX + halfWidth) - curX;
                if (this.fromTaperLen >= 0.0 && !sv.isOffInitialSegment() && -dx > this.fromTaperLen) {
                    dx = -this.fromTaperLen;
                }
                if (curZ == this.toZ && curY == this.toY && curX > this.toX && curX + dx < this.toX) {
                    dx = this.toX - curX;
                }
                if (curX + dx < this.toX && curY >= this.toRect.getMinY() && curY <= this.toRect.getMaxY() && curZ == this.toZ) {
                    dx = this.toX - curX;
                } else {
                    Rectangle2D limit;
                    if (!SeaOfGatesEngine.inDestGrid(this.toRectGridded, curX + dx, curY)) {
                        dx = this.nr.getUpperXGrid(curZ, curX + dx).getCoordinate() - curX;
                    }
                    if (this.globalRoutingDelta != 0 && curX + dx < (limit = this.orderedBuckets[sv.globalRoutingBucket]).getMinX()) {
                        Rectangle2D originalBucket = this.nr.buckets[sv.globalRoutingBucket];
                        dx = limit.getMinX() - curX;
                        if (curX >= originalBucket.getMinX() && curX >= originalBucket.getMaxX() && curX + dx < originalBucket.getMinX()) {
                            dx += originalBucket.getWidth() / 2.0;
                        }
                        dx = this.nr.getClosestXGrid(curZ, curX + dx).getCoordinate() - curX;
                    }
                    if (curX + dx > this.toRect.getMaxX() || curX + dx < this.toRect.getMinX()) {
                        dx = this.nr.upToGrainAlways(curX + dx) - curX;
                    }
                }
                if (explanation != null && botX != null) {
                    explanation.append("rect at " + TextUtils.formatDistance(botX.getMinX()) + "<=X<=" + TextUtils.formatDistance(botX.getMaxX()) + " and " + TextUtils.formatDistance(botX.getMinY()) + "<=Y<=" + TextUtils.formatDistance(botX.getMaxY()) + " which is " + TextUtils.formatDistance(fromSurround[0]));
                    if (fromSurround[0] != fromSurround[1]) {
                        explanation.append("/" + TextUtils.formatDistance(fromSurround[1]));
                    }
                    explanation.append(" from rect " + TextUtils.formatDistance(lX) + "<=X<=" + TextUtils.formatDistance(hX) + " and " + TextUtils.formatDistance(lY) + "<=Y<=" + TextUtils.formatDistance(hY));
                }
                return dx;
            }
            if (dy > 0.0) {
                dy = this.nr.downToGrain(hY - halfWidth) - curY;
                if (this.fromTaperLen >= 0.0 && !sv.isOffInitialSegment() && dy > this.fromTaperLen) {
                    dy = this.fromTaperLen;
                }
                if (curZ == this.toZ && curX == this.toX && curY < this.toY && curY + dy > this.toY) {
                    dy = this.toY - curY;
                }
                if (curX >= this.toRect.getMinX() && curX <= this.toRect.getMaxX() && curY + dy > this.toY && curZ == this.toZ) {
                    dy = this.toY - curY;
                } else {
                    Rectangle2D limit;
                    if (!SeaOfGatesEngine.inDestGrid(this.toRectGridded, curX, curY + dy)) {
                        dy = this.nr.getLowerYGrid(curZ, curY + dy).getCoordinate() - curY;
                    }
                    if (this.globalRoutingDelta != 0 && curY + dy > (limit = this.orderedBuckets[sv.globalRoutingBucket]).getMaxY()) {
                        Rectangle2D originalBucket = this.nr.buckets[sv.globalRoutingBucket];
                        dy = limit.getMaxY() - curY;
                        if (curY >= originalBucket.getMinY() && curY >= originalBucket.getMaxY() && curY + dy > originalBucket.getMaxY()) {
                            dy -= originalBucket.getHeight() / 2.0;
                        }
                        dy = this.nr.getClosestYGrid(curZ, curY + dy).getCoordinate() - curY;
                    }
                    if (curY + dy > this.toRect.getMaxY() || curY + dy < this.toRect.getMinY()) {
                        dy = this.nr.downToGrainAlways(curY + dy) - curY;
                    }
                }
                if (explanation != null && topY != null) {
                    explanation.append("rect at " + TextUtils.formatDistance(topY.getMinX()) + "<=X<=" + TextUtils.formatDistance(topY.getMaxX()) + " and " + TextUtils.formatDistance(topY.getMinY()) + "<=Y<=" + TextUtils.formatDistance(topY.getMaxY()) + " which is " + TextUtils.formatDistance(fromSurround[0]));
                    if (fromSurround[0] != fromSurround[1]) {
                        explanation.append("/" + TextUtils.formatDistance(fromSurround[1]));
                    }
                    explanation.append(" from rect " + TextUtils.formatDistance(lX) + "<=X<=" + TextUtils.formatDistance(hX) + " and " + TextUtils.formatDistance(lY) + "<=Y<=" + TextUtils.formatDistance(hY));
                }
                return dy;
            }
            if (dy < 0.0) {
                dy = this.nr.upToGrain(lY + halfWidth) - curY;
                if (this.fromTaperLen >= 0.0 && !sv.isOffInitialSegment() && -dy > this.fromTaperLen) {
                    dy = -this.fromTaperLen;
                }
                if (curZ == this.toZ && curX == this.toX && curY > this.toY && curY + dy < this.toY) {
                    dy = this.toY - curY;
                }
                if (curX >= this.toRect.getMinX() && curX <= this.toRect.getMaxX() && curY + dy < this.toY && curZ == this.toZ) {
                    dy = this.toY - curY;
                } else {
                    Rectangle2D limit;
                    if (!SeaOfGatesEngine.inDestGrid(this.toRectGridded, curX, curY + dy)) {
                        dy = this.nr.getUpperYGrid(curZ, curY + dy).getCoordinate() - curY;
                    }
                    if (this.globalRoutingDelta != 0 && curY + dy < (limit = this.orderedBuckets[sv.globalRoutingBucket]).getMinY()) {
                        Rectangle2D originalBucket = this.nr.buckets[sv.globalRoutingBucket];
                        dy = limit.getMinY() - curY;
                        if (curY >= originalBucket.getMinY() && curY >= originalBucket.getMaxY() && curY + dy < originalBucket.getMinY()) {
                            dy += originalBucket.getHeight() / 2.0;
                        }
                        dy = this.nr.getClosestYGrid(curZ, curY + dy).getCoordinate() - curY;
                    }
                    if (curY + dy > this.toRect.getMaxY() || curY + dy < this.toRect.getMinY()) {
                        dy = this.nr.upToGrainAlways(curY + dy) - curY;
                    }
                }
                if (explanation != null && botY != null) {
                    explanation.append("rect at " + TextUtils.formatDistance(botY.getMinX()) + "<=X<=" + TextUtils.formatDistance(botY.getMaxX()) + " and " + TextUtils.formatDistance(botY.getMinY()) + "<=Y<=" + TextUtils.formatDistance(botY.getMaxY()) + " which is " + TextUtils.formatDistance(fromSurround[0]));
                    if (fromSurround[0] != fromSurround[1]) {
                        explanation.append("/" + TextUtils.formatDistance(fromSurround[1]));
                    }
                    explanation.append(" from rect " + TextUtils.formatDistance(lX) + "<=X<=" + TextUtils.formatDistance(hX) + " and " + TextUtils.formatDistance(lY) + "<=Y<=" + TextUtils.formatDistance(hY));
                }
                return dy;
            }
            return 0.0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SOGBound getMetalBlockageAndNotch(int metNo, int maskNo, double halfWidth, double halfHeight, double x, double y, SearchVertex svCurrent, boolean minArea) {
            if (maskNo > 0) {
                --maskNo;
            }
            Layer layer = SeaOfGatesEngine.this.metalLayers[metNo][maskNo];
            Layer primaryLayer = SeaOfGatesEngine.this.primaryMetalLayer[metNo];
            BlockageTree bTree = SeaOfGatesEngine.this.rTrees.getMetalTree(primaryLayer);
            bTree.lock();
            try {
                if (bTree.isEmpty()) {
                    SOGBound sOGBound = null;
                    return sOGBound;
                }
                double metLX = x - halfWidth;
                double metHX = x + halfWidth;
                double metLY = y - halfHeight;
                double metHY = y + halfHeight;
                Rectangle2D.Double metBound = new Rectangle2D.Double(metLX, metLY, metHX - metLX, metHY - metLY);
                double metWid = Math.min(halfWidth, halfHeight) * 2.0;
                double metLen = Math.max(halfWidth, halfHeight) * 2.0;
                double surroundX = SeaOfGatesEngine.this.metalSurroundX[metNo];
                double surroundY = SeaOfGatesEngine.this.metalSurroundY[metNo];
                double lX = metLX - surroundX;
                double hX = metHX + surroundX;
                double lY = metLY - surroundY;
                double hY = metHY + surroundY;
                Rectangle2D.Double searchArea = new Rectangle2D.Double(lX, lY, hX - lX, hY - lY);
                ArrayList<FixpRectangle> nodeRecsOnPath = new ArrayList<FixpRectangle>();
                ArrayList<Rectangle2D> recsOnPath = new ArrayList<Rectangle2D>();
                if (svCurrent != null) {
                    SeaOfGatesEngine.this.getOptimizedList(svCurrent, this.optimizedList);
                    for (int ind = 1; ind < this.optimizedList.size(); ++ind) {
                        Poly poly;
                        FixpRectangle bound;
                        SearchVertex sv = this.optimizedList.get(ind);
                        SearchVertex searchVertex = this.optimizedList.get(ind - 1);
                        if (sv.getZ() != metNo && searchVertex.getZ() != metNo) continue;
                        if (sv.getZ() != searchVertex.getZ()) {
                            List<MetalVia> nps2X;
                            int metNum = Math.min(sv.getZ(), searchVertex.getZ());
                            List<MetalVia> nps = SeaOfGatesEngine.this.metalVias[metNum].getVias();
                            if ((this.nr.is2X(metNum, sv.getX(), sv.getY(), sv.getX(), sv.getY()) || metNum + 1 < numMetalLayers && this.nr.is2X(metNum + 1, sv.getX(), sv.getY(), sv.getX(), sv.getY())) && (nps2X = SeaOfGatesEngine.this.metalVias2X[metNum].getVias()).size() > 0) {
                                nps = nps2X;
                            }
                            int whichContact = searchVertex.getContactNo();
                            MetalVia mv = nps.get(whichContact);
                            PrimitiveNode np = mv.via;
                            Orientation orient = Orientation.fromJava(mv.orientation * 10, false, false);
                            SizeOffset so = np.getProtoSizeOffset();
                            double xOffset = so.getLowXOffset() + so.getHighXOffset();
                            double yOffset = so.getLowYOffset() + so.getHighYOffset();
                            double wid = Math.max(np.getDefWidth(SeaOfGatesEngine.this.ep) - xOffset, this.nr.minWidth) + xOffset;
                            double hei = Math.max(np.getDefHeight(SeaOfGatesEngine.this.ep) - yOffset, this.nr.minWidth) + yOffset;
                            NodeInst ni = NodeInst.makeDummyInstance(np, SeaOfGatesEngine.this.ep, EPoint.fromLambda(sv.getX(), sv.getY()), wid, hei, orient);
                            FixpTransform trans = null;
                            if (orient != Orientation.IDENT) {
                                trans = ni.rotateOut();
                            }
                            Poly[] polys = np.getTechnology().getShapeOfNode(ni);
                            for (int i = 0; i < polys.length; ++i) {
                                FixpRectangle bound2;
                                Poly poly2 = polys[i];
                                if (poly2.getLayer() != layer) continue;
                                if (trans != null) {
                                    poly2.transform(trans);
                                }
                                if (((RectangularShape)(bound2 = poly2.getBounds2D())).getMaxX() <= lX || ((RectangularShape)bound2).getMinX() >= hX || ((RectangularShape)bound2).getMaxY() <= lY || ((RectangularShape)bound2).getMinY() >= hY) continue;
                                recsOnPath.add(bound2);
                                nodeRecsOnPath.add(bound2);
                            }
                            continue;
                        }
                        double width = this.nr.getArcWidth(metNo, searchVertex.getX(), searchVertex.getY(), sv.getX(), sv.getY());
                        Point2D.Double head2 = new Point2D.Double(sv.getX(), sv.getY());
                        Point2D.Double tail = new Point2D.Double(searchVertex.getX(), searchVertex.getY());
                        int ang = 0;
                        if (((Point2D)head2).getX() != ((Point2D)tail).getX() || ((Point2D)head2).getY() != ((Point2D)tail).getY()) {
                            ang = GenMath.figureAngle(tail, head2);
                        }
                        if (((RectangularShape)(bound = (poly = Poly.makeEndPointPoly(head2.distance(tail), width, ang, head2, width / 2.0, tail, width / 2.0, Poly.Type.FILLED)).getBounds2D())).getMaxX() <= lX || ((RectangularShape)bound).getMinX() >= hX || ((RectangularShape)bound).getMaxY() <= lY || ((RectangularShape)bound).getMinY() >= hY) continue;
                        recsOnPath.add(bound);
                        if (minArea) continue;
                        nodeRecsOnPath.add(bound);
                    }
                }
                Iterator sea = bTree.search(searchArea);
                while (sea.hasNext()) {
                    Rectangle2D.Double drcArea;
                    PolyBase poly;
                    SOGBound sBound = (SOGBound)sea.next();
                    ERectangle eRectangle = sBound.getBounds();
                    if (((RectangularShape)eRectangle).getMaxX() <= lX || ((RectangularShape)eRectangle).getMinX() >= hX || ((RectangularShape)eRectangle).getMaxY() <= lY || ((RectangularShape)eRectangle).getMinY() >= hY) continue;
                    double drWid = 0.0;
                    double drLen = 0.0;
                    drWid = Math.max(Math.min(((RectangularShape)eRectangle).getWidth(), ((RectangularShape)eRectangle).getHeight()), Math.min(metWid, metLen));
                    drLen = Math.max(Math.max(((RectangularShape)eRectangle).getWidth(), ((RectangularShape)eRectangle).getHeight()), Math.max(metWid, metLen));
                    double[] spacing = this.nr.getSpacingRule(metNo, drWid, drLen);
                    double lXAllow = metLX - spacing[0];
                    double hXAllow = metHX + spacing[0];
                    double lYAllow = metLY - spacing[1];
                    double hYAllow = metHY + spacing[1];
                    if (DBMath.isLessThanOrEqualTo(((RectangularShape)eRectangle).getMaxX(), lXAllow) || DBMath.isGreaterThanOrEqualTo(((RectangularShape)eRectangle).getMinX(), hXAllow) || DBMath.isLessThanOrEqualTo(((RectangularShape)eRectangle).getMaxY(), lYAllow) || DBMath.isGreaterThanOrEqualTo(((RectangularShape)eRectangle).getMinY(), hYAllow)) continue;
                    if (sBound.isSameBasicNet(this.nr.netID)) {
                        boolean notBlockage = false;
                        if (!sBound.isPseudoBlockage()) {
                            notBlockage = true;
                        }
                        if (!notBlockage) continue;
                        boolean notch = this.foundANotch(bTree, metBound, eRectangle, this.nr.netID, recsOnPath, spacing);
                        if (!notch) continue;
                        SOGBound sOGBound = sBound;
                        return sOGBound;
                    }
                    if (sBound instanceof SOGPoly && !(poly = ((SOGPoly)sBound).getPoly()).contains(drcArea = new Rectangle2D.Double(lXAllow, lYAllow, hXAllow - lXAllow, hYAllow - lYAllow))) continue;
                    SOGBound sOGBound = sBound;
                    return sOGBound;
                }
                double[] spacing = this.nr.getSpacingRule(metNo, Math.min(metWid, metLen), Math.max(metWid, metLen));
                for (Rectangle2D rectangle2D : nodeRecsOnPath) {
                    if (!this.foundANotch(bTree, metBound, rectangle2D, this.nr.netID, recsOnPath, spacing)) continue;
                    SOGBound sOGBound = new SOGBound(ERectangle.fromLambda(rectangle2D), this.nr.netID, maskNo);
                    return sOGBound;
                }
                SOGBound sOGBound = null;
                return sOGBound;
            }
            finally {
                bTree.unlock();
            }
        }

        private boolean foundANotch(BlockageTree bTree, Rectangle2D metBound, Rectangle2D bound, MutableInteger netID, List<Rectangle2D> recsOnPath, double[] dist) {
            boolean vOverlap;
            boolean hOverlap = metBound.getMinX() <= bound.getMaxX() && metBound.getMaxX() >= bound.getMinX();
            boolean bl = vOverlap = metBound.getMinY() <= bound.getMaxY() && metBound.getMaxY() >= bound.getMinY();
            if (hOverlap && vOverlap) {
                return false;
            }
            if (hOverlap) {
                double ptY;
                if (metBound.getCenterY() > bound.getCenterY()) {
                    if (metBound.getMinY() - bound.getMaxY() > dist[1]) {
                        return false;
                    }
                    ptY = (metBound.getMinY() + bound.getMaxY()) / 2.0;
                } else {
                    if (bound.getMinY() - metBound.getMaxY() > dist[1]) {
                        return false;
                    }
                    ptY = (metBound.getMaxY() + bound.getMinY()) / 2.0;
                }
                double pt1X = Math.max(metBound.getMinX(), bound.getMinX());
                double pt2X = Math.min(metBound.getMaxX(), bound.getMaxX());
                double pt3X = (pt1X + pt2X) / 2.0;
                if (!this.pointInRTree(bTree, pt1X, ptY, netID, recsOnPath)) {
                    return true;
                }
                if (!this.pointInRTree(bTree, pt2X, ptY, netID, recsOnPath)) {
                    return true;
                }
                return !this.pointInRTree(bTree, pt3X, ptY, netID, recsOnPath);
            }
            if (vOverlap) {
                double ptX;
                if (metBound.getCenterX() > bound.getCenterX()) {
                    if (metBound.getMinX() - bound.getMaxX() > dist[0]) {
                        return false;
                    }
                    ptX = (metBound.getMinX() + bound.getMaxX()) / 2.0;
                } else {
                    if (bound.getMinX() - metBound.getMaxX() > dist[0]) {
                        return false;
                    }
                    ptX = (metBound.getMaxX() + bound.getMinX()) / 2.0;
                }
                double pt1Y = Math.max(metBound.getMinY(), bound.getMinY());
                double pt2Y = Math.min(metBound.getMaxY(), bound.getMaxY());
                double pt3Y = (pt1Y + pt2Y) / 2.0;
                if (!this.pointInRTree(bTree, ptX, pt1Y, netID, recsOnPath)) {
                    return true;
                }
                if (!this.pointInRTree(bTree, ptX, pt2Y, netID, recsOnPath)) {
                    return true;
                }
                return !this.pointInRTree(bTree, ptX, pt3Y, netID, recsOnPath);
            }
            if (metBound.getMinX() > bound.getMaxX() && metBound.getMinY() > bound.getMaxY()) {
                double pt2Y;
                double pt1X = metBound.getMinX();
                double pt1Y = bound.getMaxY();
                double pt2X = bound.getMaxX();
                if (Math.sqrt((pt1X - pt2X) * (pt1X - pt2X) + (pt1Y - (pt2Y = metBound.getMinY())) * (pt1Y - pt2Y)) > Math.max(dist[0], dist[1])) {
                    return false;
                }
                if (this.pointInRTree(bTree, pt1X, pt1Y, netID, recsOnPath)) {
                    return false;
                }
                return !this.pointInRTree(bTree, pt2X, pt2Y, netID, recsOnPath);
            }
            if (metBound.getMaxX() < bound.getMinX() && metBound.getMinY() > bound.getMaxY()) {
                double pt2Y;
                double pt1X = metBound.getMaxX();
                double pt1Y = bound.getMaxY();
                double pt2X = bound.getMinX();
                if (Math.sqrt((pt1X - pt2X) * (pt1X - pt2X) + (pt1Y - (pt2Y = metBound.getMinY())) * (pt1Y - pt2Y)) > Math.max(dist[0], dist[1])) {
                    return false;
                }
                if (this.pointInRTree(bTree, pt1X, pt1Y, netID, recsOnPath)) {
                    return false;
                }
                return !this.pointInRTree(bTree, pt2X, pt2Y, netID, recsOnPath);
            }
            if (metBound.getMaxX() < bound.getMinX() && metBound.getMaxY() < bound.getMinY()) {
                double pt2Y;
                double pt1X = metBound.getMaxX();
                double pt1Y = bound.getMinY();
                double pt2X = bound.getMinX();
                if (Math.sqrt((pt1X - pt2X) * (pt1X - pt2X) + (pt1Y - (pt2Y = metBound.getMaxY())) * (pt1Y - pt2Y)) > Math.max(dist[0], dist[1])) {
                    return false;
                }
                if (this.pointInRTree(bTree, pt1X, pt1Y, netID, recsOnPath)) {
                    return false;
                }
                return !this.pointInRTree(bTree, pt2X, pt2Y, netID, recsOnPath);
            }
            if (metBound.getMinX() > bound.getMaxX() && metBound.getMaxY() < bound.getMinY()) {
                double pt2Y;
                double pt1X = metBound.getMinX();
                double pt1Y = bound.getMinY();
                double pt2X = bound.getMaxX();
                if (Math.sqrt((pt1X - pt2X) * (pt1X - pt2X) + (pt1Y - (pt2Y = metBound.getMaxY())) * (pt1Y - pt2Y)) > Math.max(dist[0], dist[1])) {
                    return false;
                }
                if (this.pointInRTree(bTree, pt1X, pt1Y, netID, recsOnPath)) {
                    return false;
                }
                return !this.pointInRTree(bTree, pt2X, pt2Y, netID, recsOnPath);
            }
            return false;
        }

        private boolean pointInRTree(BlockageTree bTree, double x, double y, MutableInteger netID, List<Rectangle2D> recsOnPath) {
            Rectangle2D.Double searchArea = new Rectangle2D.Double(x - 0.5, y - 0.5, 1.0, 1.0);
            Iterator sea = bTree.search(searchArea);
            while (sea.hasNext()) {
                SOGBound sBound = (SOGBound)sea.next();
                if (!sBound.isSameBasicNet(netID) || DBMath.isGreaterThan(sBound.getBounds().getMinX(), x) || DBMath.isLessThan(sBound.getBounds().getMaxX(), x) || DBMath.isGreaterThan(sBound.getBounds().getMinY(), y) || DBMath.isLessThan(sBound.getBounds().getMaxY(), y)) continue;
                return true;
            }
            for (Rectangle2D bound : recsOnPath) {
                if (DBMath.isGreaterThan(bound.getMinX(), x) || DBMath.isLessThan(bound.getMaxX(), x) || DBMath.isGreaterThan(bound.getMinY(), y) || DBMath.isLessThan(bound.getMaxY(), y)) continue;
                return true;
            }
            return false;
        }
    }

    public class RouteArc
    implements Serializable {
        private ArcProto type;
        private double wid;
        private RouteNode from;
        private RouteNode to;
        private String netName;

        public RouteArc(ArcProto type, String netName, SeaOfGatesEngine soge, Layer layer, double wid, RouteNode from2, RouteNode to2, NeededRoute nr) {
            this.type = type;
            this.netName = netName;
            this.wid = wid;
            this.from = from2;
            this.to = to2;
            EPoint fromLoc = from2.loc;
            EPoint toLoc = to2.loc;
            Poly poly = null;
            if (fromLoc.getX() == toLoc.getX()) {
                poly = new Poly(fromLoc.getX(), (fromLoc.getY() + toLoc.getY()) / 2.0, wid, Math.abs(fromLoc.getY() - toLoc.getY()) + wid);
            } else if (fromLoc.getY() == toLoc.getY()) {
                poly = new Poly((fromLoc.getX() + toLoc.getX()) / 2.0, fromLoc.getY(), Math.abs(fromLoc.getX() - toLoc.getX()) + wid, wid);
            } else if (from2.rect.getMaxX() >= to2.rect.getMinX() && from2.rect.getMinX() <= to2.rect.getMaxX()) {
                double x = (Math.max(from2.rect.getMinX(), to2.rect.getMinX()) + Math.min(from2.rect.getMaxX(), to2.rect.getMaxX())) / 2.0;
                if (fromLoc.getX() != x) {
                    from2.loc = EPoint.fromLambda(x, from2.loc.getY());
                }
                if (toLoc.getX() != x) {
                    to2.loc = EPoint.fromLambda(x, to2.loc.getY());
                }
                poly = new Poly(x, (fromLoc.getY() + toLoc.getY()) / 2.0, wid, Math.abs(fromLoc.getY() - toLoc.getY()) + wid);
            } else if (from2.rect.getMaxY() >= to2.rect.getMinY() && from2.rect.getMinY() <= to2.rect.getMaxY()) {
                double y = (Math.max(from2.rect.getMinY(), to2.rect.getMinY()) + Math.min(from2.rect.getMaxY(), to2.rect.getMaxY())) / 2.0;
                if (fromLoc.getY() != y) {
                    from2.loc = EPoint.fromLambda(from2.loc.getX(), y);
                }
                if (toLoc.getY() != y) {
                    to2.loc = EPoint.fromLambda(to2.loc.getX(), y);
                }
                poly = new Poly((fromLoc.getX() + toLoc.getX()) / 2.0, y, Math.abs(fromLoc.getX() - toLoc.getX()) + wid, wid);
            } else {
                String layerName = "";
                if (layer != null) {
                    layerName = " " + layer.getName();
                }
                System.out.println("WARNING: angled" + layerName + " wire from (" + TextUtils.formatDistance(fromLoc.getX()) + "," + TextUtils.formatDistance(fromLoc.getY()) + ") to (" + TextUtils.formatDistance(toLoc.getX()) + "," + TextUtils.formatDistance(toLoc.getY()) + ")");
            }
            if (poly != null && layer != null) {
                poly.setLayer(layer);
                poly.setStyle(Poly.Type.FILLED);
                soge.addLayer(poly, GenMath.MATID, nr.getNetID(), true, null, false);
            }
        }

        ArcProtoId getProtoId() {
            return this.type.getId();
        }

        RouteNode getTail() {
            return this.to;
        }

        RouteNode getHead() {
            return this.from;
        }

        String getName() {
            return this.netName;
        }

        long getGridExtendOverMin() {
            return DBMath.lambdaToGrid(0.5 * this.wid) - this.type.getBaseExtend().getGrid();
        }

        int getFlags(EditingPreferences ep) {
            return this.type.getDefaultInst((EditingPreferences)ep).flags;
        }
    }

    public static class RouteNode
    implements Serializable {
        private boolean exists;
        private NodeProto np;
        private EPoint loc;
        private FixpRectangle rect;
        private double wid;
        private double hei;
        private Orientation orient;
        private int terminalNodeID;
        private PortProtoId terminalNodePort;
        private PortInst tapConnection;
        private NeededRoute nr;

        public RouteNode(NodeProto np, SeaOfGatesEngine soge, EPoint loc, double wid, double hei, Orientation orient, PortInst tapConnection, NeededRoute nr) {
            this.exists = false;
            this.np = np;
            this.loc = loc;
            long x = FixpCoord.lambdaToFixp(loc.getX());
            long y = FixpCoord.lambdaToFixp(loc.getY());
            this.rect = FixpRectangle.fromFixpDiagonal(x, y, x, y);
            this.wid = wid;
            this.hei = hei;
            this.orient = orient;
            this.tapConnection = tapConnection;
            this.nr = nr;
            if (np.getFunction() == PrimitiveNode.Function.PIN) {
                return;
            }
            NodeInst ni = NodeInst.makeDummyInstance(np, soge.ep, loc, wid, hei, orient);
            FixpTransform trans = ni.rotateOut();
            Poly[] nodeInstPolyList = np.getTechnology().getShapeOfNode(ni, true, false, null);
            for (int i = 0; i < nodeInstPolyList.length; ++i) {
                Poly poly = nodeInstPolyList[i];
                if (poly.getPort() == null) continue;
                ((PolyBase)poly).transform(trans);
                poly.setStyle(Poly.Type.FILLED);
                soge.addLayer(poly, GenMath.MATID, nr.getNetID(), true, null, false);
            }
        }

        public RouteNode(PortInst pi) {
            this.exists = true;
            this.terminalNodeID = pi.getNodeInst().getNodeId();
            this.terminalNodePort = pi.getPortProto().getId();
            this.loc = pi.getCenter();
            this.rect = pi.getPoly().getBounds2D();
        }

        boolean exists() {
            return this.exists;
        }

        NodeProtoId getProtoId() {
            return this.np.getId();
        }

        PortInst getTapConnection() {
            return this.tapConnection;
        }

        void setTapConnection(ImmutableNodeInst ini) {
            if (this.tapConnection != null) {
                this.nr.spineTapNIMap.put(this.tapConnection, ini);
            }
        }

        Name getBaseName() {
            assert (!this.exists);
            PrimitiveNode pn = (PrimitiveNode)this.np;
            return pn.getPrimitiveFunction(this.getTechBits()).getBasename();
        }

        Orientation getOrient() {
            return this.orient;
        }

        EPoint getLoc() {
            return this.loc;
        }

        EPoint getSize() {
            if (this.np instanceof Cell) {
                return EPoint.ORIGIN;
            }
            PrimitiveNode pn = (PrimitiveNode)this.np;
            ERectangle fullRectangle = pn.getFullRectangle();
            long sizeX = DBMath.lambdaToSizeGrid(this.wid) - fullRectangle.getGridWidth();
            long sizeY = DBMath.lambdaToSizeGrid(this.hei) - fullRectangle.getGridHeight();
            return EPoint.fromGrid(sizeX, sizeY);
        }

        int getTechBits() {
            return 0;
        }

        int getNodeId() {
            assert (this.exists);
            return this.terminalNodeID;
        }

        PortProtoId getPortProtoId() {
            if (this.exists) {
                return this.terminalNodePort;
            }
            PrimitiveNode pn = (PrimitiveNode)this.np;
            assert (pn.getNumPorts() == 1);
            return pn.getPort(0).getId();
        }
    }

    public static class RouteAddUnrouted
    implements Serializable {
        private int nodeIDA;
        private int nodeIDB;
        private PortProtoId portIdA;
        private PortProtoId portIdB;
        private EPoint locA;
        private EPoint locB;

        public RouteAddUnrouted(PortInst piA, PortInst piB) {
            this.nodeIDA = piA.getNodeInst().getNodeId();
            this.portIdA = piA.getPortProto().getId();
            this.locA = piA.getCenter();
            this.nodeIDB = piB.getNodeInst().getNodeId();
            this.portIdB = piB.getPortProto().getId();
            this.locB = piB.getCenter();
        }

        int getTailId() {
            return this.nodeIDA;
        }

        PortProtoId getTailPortProtoId() {
            return this.portIdA;
        }

        EPoint getTailLocation() {
            return this.locA;
        }

        int getHeadId() {
            return this.nodeIDB;
        }

        PortProtoId getHeadPortProtoId() {
            return this.portIdB;
        }

        EPoint getHeadLocation() {
            return this.locB;
        }
    }

    public static class RouteResolution
    implements Serializable {
        final CellId cellId;
        final List<RouteNode> nodesToRoute = new ArrayList<RouteNode>();
        final List<RouteArc> arcsToRoute = new ArrayList<RouteArc>();
        final List<Integer> nodesIDsToKill = new ArrayList<Integer>();
        final List<Integer> arcsIDsToKill = new ArrayList<Integer>();
        final Map<RouteAddUnrouted, String> unroutedToAdd = new HashMap<RouteAddUnrouted, String>();

        public RouteResolution(CellId cellId) {
            this.cellId = cellId;
        }

        public void addNode(RouteNode rn) {
            this.nodesToRoute.add(rn);
        }

        public void addArc(RouteArc ra) {
            this.arcsToRoute.add(ra);
        }

        public void killNode(NodeInst ni) {
            this.nodesIDsToKill.add(ni.getNodeId());
        }

        public void killArc(ArcInst ai) {
            this.arcsIDsToKill.add(ai.getArcId());
        }

        public void addUnrouted(PortInst piA, PortInst piB, String name) {
            this.unroutedToAdd.put(new RouteAddUnrouted(piA, piB), name);
        }

        public void clearRoutes() {
            this.nodesToRoute.clear();
            this.arcsToRoute.clear();
            this.nodesIDsToKill.clear();
            this.arcsIDsToKill.clear();
            this.unroutedToAdd.clear();
        }
    }

    public class NeededRoute {
        private String routeName;
        private RouteBatch batch;
        private int routeInBatch;
        private final Rectangle2D routeBounds;
        private MutableInteger netID;
        private final double minWidth;
        private Rectangle2D jumpBound;
        private int complexityLimit;
        private int maxDistance;
        private double aX;
        private double aY;
        private double bX;
        private double bY;
        private double aTaperWid;
        private double bTaperWid;
        private double aTaperLen;
        private double bTaperLen;
        private FixpRectangle aRect;
        private FixpRectangle bRect;
        private FixpRectangle aRectGridded;
        private FixpRectangle bRectGridded;
        private final PortInst aPi;
        private final PortInst bPi;
        private int aZ;
        private int bZ;
        private int aC;
        private int bC;
        private boolean alreadyRouted;
        private Boolean debuggingRouteFromA;
        private MetalVia replaceA;
        private MetalVia replaceB;
        private int replaceAZ;
        private int replaceBZ;
        private int replaceAC;
        private int replaceBC;
        private final List<PortInst> spineTaps;
        private final Map<SearchVertex, PortInst> spineTapMap;
        private final Map<PortInst, ImmutableNodeInst> spineTapNIMap;
        private final Poly aPoly;
        private final Poly bPoly;
        private Rectangle2D[] buckets;
        private Map<Layer, List<SOGBound>> endBlockages;
        private volatile boolean routedSuccess;
        private String errorMessage;
        private boolean reroute;
        private SeaOfGates.SeaOfGatesTrack[][] gridLocationsX;
        private SeaOfGates.SeaOfGatesTrack[][] gridLocationsY;
        private Map<SOGBound, Integer> extractList;
        private boolean[] overridePreventArcs;
        private boolean[] forceGridArcs;
        private double[] overrideMetalWidth;
        private double[] overrideMetalSpacingX;
        private double[] overrideMetalSpacingY;
        private double[][] overrideMetalSpacings;
        private Wavefront winningWF = null;
        private Wavefront dirAtoB;
        private Wavefront dirBtoA;
        private ErrorLogger.MessageLog loggedMessage;

        public NeededRoute(String routeName, PortInst aPi, PortInst bPi, ArcProto aArc, ArcProto bArc, List<PortInst> spineTaps, double minWidth) {
            this.routeName = routeName;
            this.minWidth = minWidth;
            this.spineTaps = spineTaps;
            this.complexityLimit = ((SeaOfGatesEngine)SeaOfGatesEngine.this).prefs.complexityLimit;
            this.maxDistance = ((SeaOfGatesEngine)SeaOfGatesEngine.this).prefs.maxDistance;
            this.alreadyRouted = false;
            this.replaceB = null;
            this.replaceA = null;
            this.replaceBZ = 0;
            this.replaceAZ = 0;
            this.replaceBC = 0;
            this.replaceAC = 0;
            if (spineTaps == null) {
                this.spineTapMap = null;
                this.spineTapNIMap = null;
            } else {
                this.spineTapMap = new HashMap<SearchVertex, PortInst>();
                this.spineTapNIMap = new HashMap<PortInst, ImmutableNodeInst>();
            }
            this.overrideMetalWidth = null;
            this.overrideMetalSpacingY = null;
            this.overrideMetalSpacingX = null;
            this.overrideMetalSpacings = new double[numMetalLayers][];
            for (int z = 0; z < numMetalLayers; ++z) {
                this.overrideMetalSpacings[z] = null;
                Double overrideWidth = null;
                boolean hadXOverride = false;
                boolean hadYOverride = false;
                for (int c = 0; c < SeaOfGatesEngine.this.metalArcs[z].length; ++c) {
                    DRCTemplate rule;
                    int cc;
                    int i;
                    SeaOfGates.SeaOfGatesArcProperties sogap;
                    Double o = SeaOfGatesEngine.this.sogp.getDefaultWidthOverride(SeaOfGatesEngine.this.metalArcs[z][c]);
                    if (o == null) continue;
                    if (overrideWidth == null || o > overrideWidth) {
                        overrideWidth = o;
                    }
                    if ((sogap = SeaOfGatesEngine.this.sogp.getOverridesForArcsOnNet(routeName, SeaOfGatesEngine.this.metalArcs[z][c])) != null && sogap.getWidthOverride() != null) {
                        overrideWidth = sogap.getWidthOverride();
                    }
                    if (overrideWidth != null) {
                        if (this.overrideMetalWidth == null) {
                            this.overrideMetalWidth = new double[numMetalLayers];
                            for (int i2 = 0; i2 < numMetalLayers; ++i2) {
                                if (SeaOfGatesEngine.this.metalArcs[i2] == null) continue;
                                for (int cc2 = 0; cc2 < SeaOfGatesEngine.this.metalArcs[i2].length; ++cc2) {
                                    this.overrideMetalWidth[i2] = Math.max(SeaOfGatesEngine.this.metalArcs[i2][cc2].getDefaultLambdaBaseWidth(SeaOfGatesEngine.this.ep), minWidth);
                                }
                            }
                        }
                        this.overrideMetalWidth[z] = overrideWidth;
                    }
                    Double overrideSpacingX = SeaOfGatesEngine.this.sogp.getDefaultSpacingOverride(SeaOfGatesEngine.this.metalArcs[z][c], 0);
                    Double overrideSpacingY = SeaOfGatesEngine.this.sogp.getDefaultSpacingOverride(SeaOfGatesEngine.this.metalArcs[z][c], 1);
                    if (sogap != null && sogap.getSpacingOverride(0) != null) {
                        overrideSpacingX = sogap.getSpacingOverride(0);
                    }
                    if (sogap != null && sogap.getSpacingOverride(1) != null) {
                        overrideSpacingY = sogap.getSpacingOverride(1);
                    }
                    if (overrideSpacingX != null) {
                        hadXOverride = true;
                        if (this.overrideMetalSpacingX == null) {
                            this.overrideMetalSpacingX = new double[numMetalLayers];
                            for (i = 0; i < numMetalLayers; ++i) {
                                this.overrideMetalSpacingX[i] = 0.0;
                                if (SeaOfGatesEngine.this.metalLayers[i] == null || SeaOfGatesEngine.this.metalArcs[i] == null) continue;
                                for (cc = 0; cc < SeaOfGatesEngine.this.metalArcs[i].length; ++cc) {
                                    rule = DRC.getSpacingRule(SeaOfGatesEngine.this.metalLayers[i][cc], null, SeaOfGatesEngine.this.metalLayers[i][cc], null, false, -1, SeaOfGatesEngine.this.metalArcs[i][cc].getDefaultLambdaBaseWidth(SeaOfGatesEngine.this.ep), 50.0);
                                    if (rule == null) continue;
                                    this.overrideMetalSpacingX[i] = rule.getValue(0);
                                }
                            }
                        }
                        this.overrideMetalSpacingX[z] = overrideSpacingX;
                    }
                    if (overrideSpacingY == null) continue;
                    hadYOverride = true;
                    if (this.overrideMetalSpacingY == null) {
                        this.overrideMetalSpacingY = new double[numMetalLayers];
                        for (i = 0; i < numMetalLayers; ++i) {
                            this.overrideMetalSpacingY[i] = 0.0;
                            if (SeaOfGatesEngine.this.metalLayers[i] == null || SeaOfGatesEngine.this.metalArcs[i] == null) continue;
                            for (cc = 0; cc < SeaOfGatesEngine.this.metalArcs[i].length; ++cc) {
                                rule = DRC.getSpacingRule(SeaOfGatesEngine.this.metalLayers[i][cc], null, SeaOfGatesEngine.this.metalLayers[i][cc], null, false, -1, SeaOfGatesEngine.this.metalArcs[i][cc].getDefaultLambdaBaseWidth(SeaOfGatesEngine.this.ep), 50.0);
                                if (rule == null) continue;
                                this.overrideMetalSpacingY[i] = rule.getNumValues() <= 1 ? rule.getValue(0) : rule.getValue(1);
                            }
                        }
                    }
                    this.overrideMetalSpacingY[z] = overrideSpacingY;
                }
                if (!hadXOverride || !hadYOverride) continue;
                this.overrideMetalSpacings[z] = new double[]{this.overrideMetalSpacingX[z], this.overrideMetalSpacingY[z]};
            }
            this.aPi = aPi;
            this.bPi = bPi;
            this.aPoly = aPi.getPoly();
            this.bPoly = bPi.getPoly();
            this.aRect = this.aPoly.getBounds2D();
            this.bRect = this.bPoly.getBounds2D();
            if (this.bRect.getMaxX() < this.aRect.getMinX()) {
                this.bX = this.upToGrain(this.bRect.getCenterX());
                this.aX = this.downToGrain(this.aRect.getCenterX());
            } else if (this.bRect.getMinX() > this.aRect.getMaxX()) {
                this.bX = this.downToGrain(this.bRect.getCenterX());
                this.aX = this.upToGrain(this.aRect.getCenterX());
            } else {
                double xVal = (Math.max(this.bRect.getMinX(), this.aRect.getMinX()) + Math.min(this.bRect.getMaxX(), this.aRect.getMaxX())) / 2.0;
                this.bX = this.aX = this.upToGrain(xVal);
            }
            if (this.bRect.getMaxY() < this.aRect.getMinY()) {
                this.bY = this.upToGrain(this.bRect.getCenterY());
                this.aY = this.downToGrain(this.aRect.getCenterY());
            } else if (this.bRect.getMinY() > this.aRect.getMaxY()) {
                this.bY = this.downToGrain(this.bRect.getCenterY());
                this.aY = this.upToGrain(this.aRect.getCenterY());
            } else {
                double yVal = (Math.max(this.bRect.getMinY(), this.aRect.getMinY()) + Math.min(this.bRect.getMaxY(), this.aRect.getMaxY())) / 2.0;
                this.bY = this.aY = this.upToGrain(yVal);
            }
            this.aZ = aArc.getFunction().getLevel() - 1;
            this.bZ = bArc.getFunction().getLevel() - 1;
            this.aC = aArc.getMaskLayer();
            this.bC = bArc.getMaskLayer();
            double lowX = Math.min(this.aRect.getMinX(), this.bRect.getMinX());
            double highX = Math.max(this.aRect.getMaxX(), this.bRect.getMaxX());
            double lowY = Math.min(this.aRect.getMinY(), this.bRect.getMinY());
            double highY = Math.max(this.aRect.getMaxY(), this.bRect.getMaxY());
            double gap = DRC.getWorstSpacingDistance(SeaOfGatesEngine.this.tech, -1) * (double)this.maxDistance;
            Rectangle2D.Double testBounds = new Rectangle2D.Double(lowX - gap, lowY - gap, highX - lowX + gap * 2.0, highY - lowY + gap * 2.0);
            this.buildGrids(testBounds);
            double aLX = this.getLowerXGrid(this.aZ, this.aRect.getMinX()).getCoordinate();
            double aHX = this.getUpperXGrid(this.aZ, this.aRect.getMaxX()).getCoordinate();
            double aLY = this.getLowerYGrid(this.aZ, this.aRect.getMinY()).getCoordinate();
            double aHY = this.getUpperYGrid(this.aZ, this.aRect.getMaxY()).getCoordinate();
            this.aRectGridded = FixpRectangle.from(new Rectangle2D.Double(aLX, aLY, aHX - aLX, aHY - aLY));
            double bLX = this.getLowerXGrid(this.bZ, this.bRect.getMinX()).getCoordinate();
            double bHX = this.getUpperXGrid(this.bZ, this.bRect.getMaxX()).getCoordinate();
            double bLY = this.getLowerYGrid(this.bZ, this.bRect.getMinY()).getCoordinate();
            double bHY = this.getUpperYGrid(this.bZ, this.bRect.getMaxY()).getCoordinate();
            this.bRectGridded = FixpRectangle.from(new Rectangle2D.Double(bLX, bLY, bHX - bLX, bHY - bLY));
            double maxStrayFromRouteBoundsX = gap;
            double maxStrayFromRouteBoundsY = gap;
            double griddedLowX = Math.min(this.getLowerXGrid(this.aZ, lowX - maxStrayFromRouteBoundsX).getCoordinate(), this.getLowerXGrid(this.bZ, lowX - maxStrayFromRouteBoundsX).getCoordinate());
            double griddedHighX = Math.max(this.getUpperXGrid(this.aZ, highX + maxStrayFromRouteBoundsX).getCoordinate(), this.getUpperXGrid(this.bZ, highX + maxStrayFromRouteBoundsX).getCoordinate());
            double griddedLowY = Math.min(this.getLowerYGrid(this.aZ, lowY - maxStrayFromRouteBoundsY).getCoordinate(), this.getLowerYGrid(this.bZ, lowY - maxStrayFromRouteBoundsY).getCoordinate());
            double griddedHighY = Math.max(this.getUpperYGrid(this.aZ, highY + maxStrayFromRouteBoundsY).getCoordinate(), this.getUpperYGrid(this.bZ, highY + maxStrayFromRouteBoundsY).getCoordinate());
            if (SeaOfGatesEngine.this.routingBoundsLimit != null) {
                if (griddedLowX < SeaOfGatesEngine.this.routingBoundsLimit.getMinX()) {
                    griddedLowX = SeaOfGatesEngine.this.routingBoundsLimit.getMinX();
                }
                if (griddedHighX > SeaOfGatesEngine.this.routingBoundsLimit.getMaxX()) {
                    griddedHighX = SeaOfGatesEngine.this.routingBoundsLimit.getMaxX();
                }
                if (griddedLowY < SeaOfGatesEngine.this.routingBoundsLimit.getMinY()) {
                    griddedLowY = SeaOfGatesEngine.this.routingBoundsLimit.getMinY();
                }
                if (griddedHighY > SeaOfGatesEngine.this.routingBoundsLimit.getMaxY()) {
                    griddedHighY = SeaOfGatesEngine.this.routingBoundsLimit.getMaxY();
                }
            }
            this.routeBounds = new Rectangle2D.Double(griddedLowX, griddedLowY, griddedHighX - griddedLowX, griddedHighY - griddedLowY);
            this.jumpBound = new Rectangle2D.Double(Math.min(this.aX, this.bX), Math.min(this.aY, this.bY), Math.abs(this.aX - this.bX), Math.abs(this.aY - this.bY));
            this.overridePreventArcs = null;
            List<ArcProto> arcs = SeaOfGatesEngine.this.sogp.getArcsOnNet(routeName);
            if (arcs != null && arcs.size() > 0) {
                this.overridePreventArcs = new boolean[numMetalLayers];
                for (int i = 0; i < numMetalLayers; ++i) {
                    this.overridePreventArcs[i] = true;
                }
                for (ArcProto ap : arcs) {
                    int metNum = ap.getFunction().getLevel() - 1;
                    this.overridePreventArcs[metNum] = false;
                }
            }
            this.forceGridArcs = new boolean[numMetalLayers];
            for (int i = 0; i < numMetalLayers; ++i) {
                this.forceGridArcs[i] = false;
                for (int c = 0; c < SeaOfGatesEngine.this.metalArcs[i].length; ++c) {
                    if (!SeaOfGatesEngine.this.sogp.isGridForced(SeaOfGatesEngine.this.metalArcs[i][c])) continue;
                    this.forceGridArcs[i] = true;
                }
            }
            this.aTaperWid = this.getTaperWidth(aPi, this.aZ);
            this.bTaperWid = this.getTaperWidth(bPi, this.bZ);
            this.aTaperLen = SeaOfGatesEngine.this.taperLength[this.aZ];
            this.bTaperLen = SeaOfGatesEngine.this.taperLength[this.bZ];
            if (this.aTaperWid == this.getUntaperedArcWidth(this.aZ)) {
                this.aTaperLen = -1.0;
            }
            if (this.bTaperWid == this.getUntaperedArcWidth(this.bZ)) {
                this.bTaperLen = -1.0;
            }
        }

        public boolean getRoutedSucess() {
            return this.routedSuccess;
        }

        public Wavefront getWavefront() {
            return this.winningWF;
        }

        public Wavefront getWavefrontAtoB() {
            return this.dirAtoB;
        }

        public Wavefront getWavefrontBtoA() {
            return this.dirBtoA;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setDebugging(Boolean fromA) {
            this.debuggingRouteFromA = fromA;
        }

        public void checkGridValidity() {
            ArrayList<EPoint> offGrid;
            boolean hor;
            if (this.forceGridArcs[this.aZ]) {
                hor = true;
                if (SeaOfGatesEngine.this.sogp.isHorizontalEven()) {
                    if (this.aZ % 2 == 0) {
                        hor = false;
                    }
                } else if (this.aZ % 2 != 0) {
                    hor = false;
                }
                if (!hor && !this.isOnXGrid(this.aZ, this.getAX())) {
                    offGrid = new ArrayList<EPoint>();
                    offGrid.add(EPoint.fromLambda(this.aX, this.aY));
                    offGrid.add(EPoint.fromLambda(this.aX, this.aY));
                    SeaOfGatesEngine.this.warn("Route " + this.routeName + ", end (" + TextUtils.formatDistance(this.aX) + "," + TextUtils.formatDistance(this.aY) + "," + SeaOfGatesEngine.describeMetal(this.aZ, this.aC) + ") is not on X grid (nearest X grids are at " + TextUtils.formatDistance(this.getLowerXGrid(this.aZ, this.aX).getCoordinate()) + " and " + TextUtils.formatDistance(this.getUpperXGrid(this.aZ, this.aX).getCoordinate()) + "). Route may fail.", SeaOfGatesEngine.this.cell, offGrid, null);
                }
                if (hor && !this.isOnYGrid(this.aZ, this.aY)) {
                    offGrid = new ArrayList();
                    offGrid.add(EPoint.fromLambda(this.aX, this.aY));
                    offGrid.add(EPoint.fromLambda(this.aX, this.aY));
                    SeaOfGatesEngine.this.warn("Route " + this.routeName + ", end (" + TextUtils.formatDistance(this.aX) + "," + TextUtils.formatDistance(this.aY) + "," + SeaOfGatesEngine.describeMetal(this.aZ, this.aC) + ") is not on Y grid (nearest Y grids are at " + TextUtils.formatDistance(this.getLowerYGrid(this.aZ, this.aY).getCoordinate()) + " and " + TextUtils.formatDistance(this.getUpperYGrid(this.aZ, this.aY).getCoordinate()) + "). Route may fail.", SeaOfGatesEngine.this.cell, offGrid, null);
                }
            }
            if (this.forceGridArcs[this.bZ]) {
                hor = true;
                if (SeaOfGatesEngine.this.sogp.isHorizontalEven()) {
                    if (this.bZ % 2 == 0) {
                        hor = false;
                    }
                } else if (this.bZ % 2 != 0) {
                    hor = false;
                }
                if (!hor && !this.isOnXGrid(this.bZ, this.bX)) {
                    offGrid = new ArrayList();
                    offGrid.add(EPoint.fromLambda(this.bX, this.bY));
                    offGrid.add(EPoint.fromLambda(this.bX, this.bY));
                    SeaOfGatesEngine.this.warn("Route " + this.routeName + ", end (" + TextUtils.formatDistance(this.bX) + "," + TextUtils.formatDistance(this.bY) + "," + SeaOfGatesEngine.describeMetal(this.bZ, this.bC) + ") is not on X grid (nearest X grids are at " + TextUtils.formatDistance(this.getLowerXGrid(this.bZ, this.bX).getCoordinate()) + " and " + TextUtils.formatDistance(this.getUpperXGrid(this.bZ, this.bX).getCoordinate()) + "). Route may fail.", SeaOfGatesEngine.this.cell, offGrid, null);
                }
                if (hor && !this.isOnYGrid(this.bZ, this.bY)) {
                    offGrid = new ArrayList();
                    offGrid.add(EPoint.fromLambda(this.bX, this.bY));
                    offGrid.add(EPoint.fromLambda(this.bX, this.bY));
                    SeaOfGatesEngine.this.warn("Route " + this.routeName + ", end (" + TextUtils.formatDistance(this.bX) + "," + TextUtils.formatDistance(this.bY) + "," + SeaOfGatesEngine.describeMetal(this.bZ, this.bC) + ") is not on Y grid (nearest Y grids are at " + TextUtils.formatDistance(this.getLowerYGrid(this.bZ, this.bY).getCoordinate()) + " and " + TextUtils.formatDistance(this.getUpperYGrid(this.bZ, this.bY).getCoordinate()) + "). Route may fail.", SeaOfGatesEngine.this.cell, offGrid, null);
                }
            }
        }

        public FixpRectangle getAGriddedRect() {
            return this.aRectGridded;
        }

        public FixpRectangle getBGriddedRect() {
            return this.bRectGridded;
        }

        public SeaOfGates.SeaOfGatesTrack[][] getXRoutingGrid() {
            return this.gridLocationsX;
        }

        public SeaOfGates.SeaOfGatesTrack[][] getYRoutingGrid() {
            return this.gridLocationsY;
        }

        public void buildGrids(Rectangle2D bounds) {
            int metIndex;
            int metNum;
            this.gridLocationsX = new SeaOfGates.SeaOfGatesTrack[numMetalLayers][];
            this.gridLocationsY = new SeaOfGates.SeaOfGatesTrack[numMetalLayers][];
            for (metNum = 1; metNum <= numMetalLayers; ++metNum) {
                double high;
                double low;
                metIndex = metNum - 1;
                SeaOfGates.SeaOfGatesTrack[] thisGrid = SeaOfGatesEngine.this.metalGrid[metIndex];
                if (thisGrid == null || !SeaOfGatesEngine.this.sogp.isForceHorVer() && !SeaOfGatesEngine.this.sogp.isFavorHorVer()) continue;
                boolean hor = true;
                if (SeaOfGatesEngine.this.sogp.isHorizontalEven()) {
                    if (metNum % 2 != 0) {
                        hor = false;
                    }
                } else if (metNum % 2 == 0) {
                    hor = false;
                }
                double offset = thisGrid[0].getCoordinate();
                double range2 = thisGrid[thisGrid.length - 1].getCoordinate() - offset;
                if (!((range2 += thisGrid[1].getCoordinate() - thisGrid[0].getCoordinate()) > 0.0)) continue;
                ArrayList<SeaOfGates.SeaOfGatesTrack> values = new ArrayList<SeaOfGates.SeaOfGatesTrack>();
                if (hor) {
                    low = bounds.getMinY();
                    high = bounds.getMaxY();
                } else {
                    low = bounds.getMinX();
                    high = bounds.getMaxX();
                }
                double lowGroup = Math.floor((low - offset) / range2) * range2;
                double highGroup = Math.ceil((high - offset) / range2) * range2;
                for (double v = lowGroup; v <= highGroup; v += range2) {
                    for (int i = 0; i < thisGrid.length; ++i) {
                        double val = v + thisGrid[i].getCoordinate();
                        int maskNum = thisGrid[i].getMaskNum();
                        if (!(val >= low) || !(val <= high)) continue;
                        values.add(new SeaOfGates.SeaOfGatesTrack(val, maskNum));
                    }
                }
                if (values.size() < 2) continue;
                if (hor) {
                    this.gridLocationsY[metIndex] = this.makeArrayOfUniqueTracks(values);
                    continue;
                }
                this.gridLocationsX[metIndex] = this.makeArrayOfUniqueTracks(values);
            }
            for (metNum = 1; metNum <= numMetalLayers; ++metNum) {
                SeaOfGates.SeaOfGatesTrack t2;
                SeaOfGates.SeaOfGatesTrack t1;
                SeaOfGates.SeaOfGatesTrack[][] gridLocations;
                metIndex = metNum - 1;
                boolean hor = true;
                if (SeaOfGatesEngine.this.sogp.isHorizontalEven()) {
                    if (metNum % 2 != 0) {
                        hor = false;
                    }
                } else if (metNum % 2 == 0) {
                    hor = false;
                }
                if (hor) {
                    gridLocations = this.gridLocationsX;
                    t1 = this.getClosestXGrid(this.aZ, this.aX);
                    t2 = this.getClosestXGrid(this.bZ, this.bX);
                } else {
                    gridLocations = this.gridLocationsY;
                    t1 = this.getClosestXGrid(this.aZ, this.aY);
                    t2 = this.getClosestXGrid(this.bZ, this.bY);
                }
                ArrayList<SeaOfGates.SeaOfGatesTrack> values = new ArrayList<SeaOfGates.SeaOfGatesTrack>();
                boolean realGrid = false;
                if (metIndex > 0) {
                    realGrid |= this.gridAlternateLayer(metIndex, -1, values, t1, t2, gridLocations);
                }
                if (metIndex < numMetalLayers - 1) {
                    realGrid |= this.gridAlternateLayer(metIndex, 1, values, t1, t2, gridLocations);
                }
                if (!realGrid) continue;
                gridLocations[metIndex] = this.makeArrayOfUniqueTracks(values);
            }
        }

        private SeaOfGates.SeaOfGatesTrack[] makeArrayOfUniqueTracks(List<SeaOfGates.SeaOfGatesTrack> values) {
            Collections.sort(values);
            for (int i = 1; i < values.size(); ++i) {
                if (!DBMath.areEquals(values.get(i - 1).getCoordinate(), values.get(i).getCoordinate())) continue;
                values.remove(i);
                --i;
            }
            SeaOfGates.SeaOfGatesTrack[] gridLocations = new SeaOfGates.SeaOfGatesTrack[values.size()];
            int i = 0;
            for (SeaOfGates.SeaOfGatesTrack v : values) {
                gridLocations[i++] = v;
            }
            return gridLocations;
        }

        private boolean gridAlternateLayer(int curLayer, int diff2, List<SeaOfGates.SeaOfGatesTrack> values, SeaOfGates.SeaOfGatesTrack t1, SeaOfGates.SeaOfGatesTrack t2, SeaOfGates.SeaOfGatesTrack[][] gridLocations) {
            if (SeaOfGatesEngine.this.sogp.isPrevented(SeaOfGatesEngine.this.primaryMetalArc[curLayer])) {
                return false;
            }
            int altLayer = curLayer + diff2;
            if (gridLocations[altLayer] == null) {
                values.add(t1);
                values.add(t2);
                return false;
            }
            for (int i = 0; i < gridLocations[altLayer].length; ++i) {
                values.add(new SeaOfGates.SeaOfGatesTrack(gridLocations[altLayer][i].getCoordinate(), gridLocations[altLayer][i].getMaskNum()));
            }
            return true;
        }

        public SeaOfGates.SeaOfGatesTrack getLowerXGrid(int metNum, double value) {
            return this.findLowerValue(this.gridLocationsX[metNum], value);
        }

        public SeaOfGates.SeaOfGatesTrack getUpperXGrid(int metNum, double value) {
            return this.findUpperValue(this.gridLocationsX[metNum], value);
        }

        public SeaOfGates.SeaOfGatesTrack getClosestXGrid(int metNum, double value) {
            return this.findClosestValue(this.gridLocationsX[metNum], value);
        }

        public SeaOfGates.SeaOfGatesTrack getLowerYGrid(int metNum, double value) {
            return this.findLowerValue(this.gridLocationsY[metNum], value);
        }

        public SeaOfGates.SeaOfGatesTrack getUpperYGrid(int metNum, double value) {
            return this.findUpperValue(this.gridLocationsY[metNum], value);
        }

        public SeaOfGates.SeaOfGatesTrack getClosestYGrid(int metNum, double value) {
            return this.findClosestValue(this.gridLocationsY[metNum], value);
        }

        public boolean isOnXGrid(int metNum, double value) {
            return this.isOnGrid(this.gridLocationsX[metNum], value);
        }

        public boolean isOnYGrid(int metNum, double value) {
            return this.isOnGrid(this.gridLocationsY[metNum], value);
        }

        private SeaOfGates.SeaOfGatesTrack findLowerValue(SeaOfGates.SeaOfGatesTrack[] thisGrid, double value) {
            if (thisGrid == null) {
                return new SeaOfGates.SeaOfGatesTrack(value, 0);
            }
            int lo = 0;
            int hi = thisGrid.length - 1;
            if (DBMath.isLessThanOrEqualTo(value, thisGrid[lo].getCoordinate())) {
                return thisGrid[lo];
            }
            if (DBMath.isGreaterThanOrEqualTo(value, thisGrid[hi].getCoordinate())) {
                return thisGrid[hi];
            }
            for (int i = 0; i < 1000; ++i) {
                int med = (hi + lo) / 2;
                if (DBMath.isGreaterThanOrEqualTo(value, thisGrid[med].getCoordinate()) && DBMath.isLessThan(value, thisGrid[med + 1].getCoordinate())) {
                    return thisGrid[med];
                }
                if (DBMath.isLessThan(value, thisGrid[med].getCoordinate())) {
                    hi = med;
                    continue;
                }
                lo = med;
            }
            return new SeaOfGates.SeaOfGatesTrack(value, 0);
        }

        private SeaOfGates.SeaOfGatesTrack findUpperValue(SeaOfGates.SeaOfGatesTrack[] thisGrid, double value) {
            if (thisGrid == null) {
                return new SeaOfGates.SeaOfGatesTrack(value, 0);
            }
            int lo = 0;
            int hi = thisGrid.length - 1;
            if (DBMath.isLessThanOrEqualTo(value, thisGrid[lo].getCoordinate())) {
                return thisGrid[lo];
            }
            if (DBMath.isGreaterThanOrEqualTo(value, thisGrid[hi].getCoordinate())) {
                return thisGrid[hi];
            }
            for (int i = 0; i < 1000; ++i) {
                int med = (hi + lo) / 2;
                if (DBMath.isGreaterThan(value, thisGrid[med].getCoordinate()) && DBMath.isLessThanOrEqualTo(value, thisGrid[med + 1].getCoordinate())) {
                    return thisGrid[med + 1];
                }
                if (DBMath.isLessThanOrEqualTo(value, thisGrid[med].getCoordinate())) {
                    hi = med;
                    continue;
                }
                lo = med;
            }
            return new SeaOfGates.SeaOfGatesTrack(value, 0);
        }

        private SeaOfGates.SeaOfGatesTrack findClosestValue(SeaOfGates.SeaOfGatesTrack[] thisGrid, double value) {
            if (thisGrid == null) {
                return new SeaOfGates.SeaOfGatesTrack(value, 0);
            }
            int lo = 0;
            int hi = thisGrid.length - 1;
            if (DBMath.isLessThanOrEqualTo(value, thisGrid[lo].getCoordinate())) {
                return thisGrid[lo];
            }
            if (DBMath.isGreaterThanOrEqualTo(value, thisGrid[hi].getCoordinate())) {
                return thisGrid[hi];
            }
            for (int i = 0; i < 1000; ++i) {
                int med = (hi + lo) / 2;
                if (DBMath.isGreaterThanOrEqualTo(value, thisGrid[med].getCoordinate()) && DBMath.isLessThan(value, thisGrid[med + 1].getCoordinate())) {
                    if (DBMath.isLessThan(value - thisGrid[med].getCoordinate(), thisGrid[med + 1].getCoordinate() - value)) {
                        return thisGrid[med];
                    }
                    return thisGrid[med + 1];
                }
                if (DBMath.isLessThanOrEqualTo(value, thisGrid[med].getCoordinate())) {
                    hi = med;
                    continue;
                }
                lo = med;
            }
            return new SeaOfGates.SeaOfGatesTrack(value, 0);
        }

        private boolean isOnGrid(SeaOfGates.SeaOfGatesTrack[] thisGrid, double value) {
            if (thisGrid != null) {
                int lo = 0;
                int hi = thisGrid.length - 1;
                if (DBMath.isLessThan(value, thisGrid[lo].getCoordinate())) {
                    return false;
                }
                if (DBMath.isGreaterThan(value, thisGrid[hi].getCoordinate())) {
                    return false;
                }
                for (int i = 0; i < 1000; ++i) {
                    int med = (hi + lo) / 2;
                    if (DBMath.isGreaterThanOrEqualTo(value, thisGrid[med].getCoordinate()) && DBMath.isLessThanOrEqualTo(value, thisGrid[med + 1].getCoordinate())) {
                        return DBMath.areEquals(value, thisGrid[med].getCoordinate()) || DBMath.areEquals(thisGrid[med + 1].getCoordinate(), value);
                    }
                    if (DBMath.isLessThanOrEqualTo(value, thisGrid[med].getCoordinate())) {
                        hi = med;
                        continue;
                    }
                    lo = med;
                }
                return false;
            }
            return true;
        }

        private double upToGrain(double v) {
            return v;
        }

        private double upToGrainAlways(double v) {
            return Math.ceil(v);
        }

        private double downToGrain(double v) {
            return v;
        }

        private double downToGrainAlways(double v) {
            return Math.floor(v);
        }

        private boolean canPlaceContact(PrimitiveNode np, int newMetal, int offendingMetal, int offendingMetalColor, double conX, double conY, double conWid, double conHei, Orientation orient, boolean endA) {
            NodeInst dummyNi = NodeInst.makeDummyInstance(np, SeaOfGatesEngine.this.ep, EPoint.fromLambda(conX, conY), conWid, conHei, orient);
            Poly[] conPolys = SeaOfGatesEngine.this.tech.getShapeOfNode(dummyNi);
            FixpTransform trans = null;
            MutableInteger mi = new MutableInteger(this.netID.intValue() + (endA ? 2 : 4));
            if (orient != Orientation.IDENT) {
                trans = dummyNi.rotateOut();
            }
            for (int p = 0; p < conPolys.length; ++p) {
                double halfHeight;
                int c;
                Poly conPoly = conPolys[p];
                Layer conLayer = conPoly.getLayer();
                if (!conLayer.getFunction().isMetal()) continue;
                if (trans != null) {
                    conPoly.transform(trans);
                }
                FixpRectangle conRect = conPoly.getBounds2D();
                boolean found = false;
                for (c = 0; c < SeaOfGatesEngine.this.metalLayers[offendingMetal].length; ++c) {
                    if (conLayer != SeaOfGatesEngine.this.metalLayers[offendingMetal][c] || conLayer.getFunction().getMaskColor() != offendingMetalColor) continue;
                    found = true;
                }
                if (!(!found || this.isPointInMetal(((RectangularShape)conRect).getMinX(), ((RectangularShape)conRect).getMinY(), offendingMetal, mi) && this.isPointInMetal(((RectangularShape)conRect).getMinX(), ((RectangularShape)conRect).getMaxY(), offendingMetal, mi) && this.isPointInMetal(((RectangularShape)conRect).getMaxX(), ((RectangularShape)conRect).getMaxY(), offendingMetal, mi) && this.isPointInMetal(((RectangularShape)conRect).getMaxX(), ((RectangularShape)conRect).getMinY(), offendingMetal, mi) && this.isPointInMetal(((RectangularShape)conRect).getCenterX(), ((RectangularShape)conRect).getCenterY(), offendingMetal, mi))) {
                    return false;
                }
                found = false;
                for (c = 0; c < SeaOfGatesEngine.this.metalLayers[newMetal].length; ++c) {
                    if (conLayer != SeaOfGatesEngine.this.metalLayers[newMetal][c]) continue;
                    found = true;
                }
                if (!found) continue;
                double[] fromSurround = this.getSpacingRule(newMetal, SeaOfGatesEngine.this.maxDefArcWidth[newMetal], -1.0);
                double halfWidth = ((RectangularShape)conRect).getWidth() / 2.0;
                SOGBound block = this.getMetalBlockage(this.netID, newMetal, halfWidth, halfHeight = ((RectangularShape)conRect).getHeight() / 2.0, fromSurround, ((RectangularShape)conRect).getCenterX(), ((RectangularShape)conRect).getCenterY());
                if (block == null) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isPointInMetal(double x, double y, int metalNo, MutableInteger netID) {
            BlockageTree bTree = SeaOfGatesEngine.this.rTrees.getMetalTree(SeaOfGatesEngine.this.primaryMetalLayer[metalNo]);
            bTree.lock();
            try {
                if (bTree.isEmpty()) {
                    boolean bl = false;
                    return bl;
                }
                Rectangle2D.Double searchArea = new Rectangle2D.Double(x, y, 0.0, 0.0);
                Iterator sea = bTree.search(searchArea);
                while (sea.hasNext()) {
                    SOGBound sBound = (SOGBound)sea.next();
                    if (!sBound.containsPoint(x, y)) continue;
                    if (netID != null) {
                        if (!sBound.isSameBasicNet(netID)) continue;
                        int endBits = 6;
                        if ((sBound.getNetID().intValue() & endBits) != (netID.intValue() & endBits)) continue;
                    }
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                bTree.unlock();
            }
            return false;
        }

        private Orientation getMVSize(MetalVia mv, double x, double y, double lastX, double lastY, MutableDouble wid, MutableDouble hei) {
            double arcWid;
            PrimitiveNode np = mv.via;
            Orientation orient = Orientation.fromJava(mv.orientation * 10, false, false);
            SizeOffset so = np.getProtoSizeOffset();
            double minWid = this.minWidth;
            double minHei = this.minWidth;
            double xOffset = so.getLowXOffset() + so.getHighXOffset();
            double yOffset = so.getLowYOffset() + so.getHighYOffset();
            double conWid = Math.max(np.getDefWidth(SeaOfGatesEngine.this.ep) - xOffset, minWid) + xOffset;
            double conHei = Math.max(np.getDefHeight(SeaOfGatesEngine.this.ep) - yOffset, minHei) + yOffset;
            if (mv.horMetal >= 0 && (arcWid = this.getArcWidth(mv.horMetal, x, y, lastX, lastY) + mv.horMetalInset) > conHei) {
                conHei = arcWid;
            }
            if (mv.verMetal >= 0 && (arcWid = this.getArcWidth(mv.verMetal, x, y, lastX, lastY) + mv.verMetalInset) > conWid) {
                conWid = arcWid;
            }
            wid.setValue(conWid);
            hei.setValue(conHei);
            return orient;
        }

        private boolean invalidPort(boolean endA, PortInst pi) {
            ArcProto[] conns = SeaOfGatesEngine.this.getPossibleConnections(pi.getPortProto());
            for (int j = 0; j < conns.length; ++j) {
                ArcProto ap = conns[j];
                if (ap.getTechnology() != SeaOfGatesEngine.this.tech || !ap.getFunction().isMetal() || this.preventArc(conns[j].getFunction().getLevel() - 1)) continue;
                return false;
            }
            double x = endA ? this.aX : this.bX;
            double y = endA ? this.aY : this.bY;
            HashMap whatWasChecked = new HashMap();
            HashMap<Integer, Point> contactInvalidColors = new HashMap<Integer, Point>();
            int realOffendingMetal = 0;
            EPoint pt = pi.getCenter();
            double conX = pt.getX();
            double conY = pt.getY();
            double endCoord = 0.0;
            if (SeaOfGatesEngine.this.sogp.isContactAllowedDownToAvoidedLayer() || SeaOfGatesEngine.this.sogp.isContactAllowedUpToAvoidedLayer()) {
                for (int j = 0; j < conns.length; ++j) {
                    PolyBase.Point[] pts;
                    double dY;
                    double dX;
                    ArcProto ap = conns[j];
                    if (ap.getTechnology() != SeaOfGatesEngine.this.tech || !ap.getFunction().isMetal()) continue;
                    int offendingMetal = conns[j].getFunction().getLevel() - 1;
                    int offendingMetalColor = conns[j].getMaskLayer();
                    int newMetal = 0;
                    int newMetalColor = 0;
                    int lowerMetal = offendingMetal - 1;
                    int upperMetal = offendingMetal + 1;
                    List<MetalVia> mvs = null;
                    if (SeaOfGatesEngine.this.sogp.isContactAllowedUpToAvoidedLayer() && lowerMetal >= 0 && !this.preventArc(lowerMetal)) {
                        mvs = SeaOfGatesEngine.this.metalVias[lowerMetal].getVias();
                        newMetal = lowerMetal;
                    }
                    if (SeaOfGatesEngine.this.sogp.isContactAllowedDownToAvoidedLayer() && upperMetal < numMetalLayers && !this.preventArc(upperMetal)) {
                        mvs = SeaOfGatesEngine.this.metalVias[upperMetal - 1].getVias();
                        newMetal = upperMetal;
                    }
                    if (mvs == null) continue;
                    ArrayList<PrimitiveNode> checkedThese = (ArrayList<PrimitiveNode>)whatWasChecked.get(newMetal);
                    if (checkedThese == null) {
                        checkedThese = new ArrayList<PrimitiveNode>();
                        whatWasChecked.put(newMetal, checkedThese);
                    }
                    boolean hasContacts = false;
                    for (MetalVia mv : mvs) {
                        if (mv.horMetal == offendingMetal && mv.verMetal == newMetal ? mv.horMetalColor != offendingMetalColor || mv.verMetalColor != newMetalColor : mv.verMetal == offendingMetal && mv.horMetal == newMetal && (mv.verMetalColor != offendingMetalColor || mv.horMetalColor != newMetalColor)) continue;
                        hasContacts = true;
                        checkedThese.add(mv.via);
                    }
                    if (!hasContacts) {
                        realOffendingMetal = offendingMetal;
                        contactInvalidColors.put(newMetal, new Point(offendingMetalColor, newMetalColor));
                    }
                    MetalVia viaToPlace = null;
                    double viaToPlaceX = 0.0;
                    double viaToPlaceY = 0.0;
                    double viaSizeX = 0.0;
                    double viaSizeY = 0.0;
                    Orientation viaOrient = Orientation.IDENT;
                    boolean hor = true;
                    if (SeaOfGatesEngine.this.sogp.isHorizontalEven()) {
                        if (newMetal % 2 == 0) {
                            hor = false;
                        }
                    } else if (newMetal % 2 != 0) {
                        hor = false;
                    }
                    if (this.forceGridArcs[newMetal]) {
                        int index = 0;
                        int dir = 0;
                        if (hor) {
                            if (this.gridLocationsY[newMetal] != null) {
                                double otherY;
                                double d = otherY = endA ? this.bY : this.aY;
                                if (otherY < conY) {
                                    conY = this.getLowerYGrid(newMetal, conY).getCoordinate();
                                    dir = -1;
                                } else {
                                    conY = this.getUpperYGrid(newMetal, conY).getCoordinate();
                                    dir = 1;
                                }
                                for (index = 0; index < this.gridLocationsY[newMetal].length && this.gridLocationsY[newMetal][index].getCoordinate() != conY; ++index) {
                                }
                            }
                        } else if (this.gridLocationsX[newMetal] != null) {
                            double otherX;
                            double d = otherX = endA ? this.bX : this.aX;
                            if (otherX < conX) {
                                conX = this.getLowerXGrid(newMetal, conX).getCoordinate();
                                dir = -1;
                            } else {
                                conX = this.getUpperXGrid(newMetal, conX).getCoordinate();
                                dir = 1;
                            }
                            for (index = 0; index < this.gridLocationsX[newMetal].length && this.gridLocationsX[newMetal][index].getCoordinate() != conX; ++index) {
                            }
                        }
                        int startIndex = index;
                        endCoord = hor ? (endA ? this.bY : this.aY) : (endA ? this.bX : this.aX);
                        while (true) {
                            boolean tooFar = false;
                            if (hor) {
                                if (dir < 0) {
                                    if (conY < endCoord) {
                                        tooFar = true;
                                    }
                                } else if (conY > endCoord) {
                                    tooFar = true;
                                }
                            } else if (dir < 0) {
                                if (conX < endCoord) {
                                    tooFar = true;
                                }
                            } else if (conX > endCoord) {
                                tooFar = true;
                            }
                            if (tooFar && viaToPlace != null) break;
                            newMetalColor = hor ? this.gridLocationsY[newMetal][index].getMaskNum() : this.gridLocationsX[newMetal][index].getMaskNum();
                            for (MetalVia mv : mvs) {
                                if (mv.horMetal == offendingMetal && mv.verMetal == newMetal ? mv.horMetalColor != offendingMetalColor || mv.verMetalColor != newMetalColor : mv.verMetal == offendingMetal && mv.horMetal == newMetal && (mv.verMetalColor != offendingMetalColor || mv.horMetalColor != newMetalColor)) continue;
                                PrimitiveNode np = mv.via;
                                MutableDouble conWid = new MutableDouble(0.0);
                                MutableDouble conHei = new MutableDouble(0.0);
                                Orientation orient = this.getMVSize(mv, x, y, x, y, conWid, conHei);
                                if (!this.canPlaceContact(np, newMetal, offendingMetal, offendingMetalColor, conX, conY, conWid.doubleValue(), conHei.doubleValue(), orient, endA)) continue;
                                viaToPlace = mv;
                                viaToPlaceX = conX;
                                viaToPlaceY = conY;
                                viaSizeX = conWid.doubleValue();
                                viaSizeY = conHei.doubleValue();
                                viaOrient = orient;
                                break;
                            }
                            index += dir;
                            if (hor) {
                                if (index < 0 || index >= this.gridLocationsY[newMetal].length) break;
                                conY = this.gridLocationsY[newMetal][index].getCoordinate();
                                continue;
                            }
                            if (index < 0 || index >= this.gridLocationsX[newMetal].length) break;
                            conX = this.gridLocationsX[newMetal][index].getCoordinate();
                        }
                        if (viaToPlace == null) {
                            dir = -dir;
                            index = startIndex + dir;
                            while (true) {
                                newMetalColor = hor ? this.gridLocationsY[newMetal][index].getMaskNum() : this.gridLocationsX[newMetal][index].getMaskNum();
                                for (MetalVia mv : mvs) {
                                    if (mv.horMetal == offendingMetal && mv.verMetal == newMetal ? mv.horMetalColor != offendingMetalColor || mv.verMetalColor != newMetalColor : mv.verMetal == offendingMetal && mv.horMetal == newMetal && (mv.verMetalColor != offendingMetalColor || mv.horMetalColor != newMetalColor)) continue;
                                    PrimitiveNode np = mv.via;
                                    MutableDouble conWid = new MutableDouble(0.0);
                                    MutableDouble conHei = new MutableDouble(0.0);
                                    Orientation orient = this.getMVSize(mv, x, y, x, y, conWid, conHei);
                                    if (!this.canPlaceContact(np, newMetal, offendingMetal, offendingMetalColor, conX, conY, conWid.doubleValue(), conHei.doubleValue(), orient, endA)) continue;
                                    viaToPlace = mv;
                                    viaToPlaceX = conX;
                                    viaToPlaceY = conY;
                                    viaSizeX = conWid.doubleValue();
                                    viaSizeY = conHei.doubleValue();
                                    viaOrient = orient;
                                    break;
                                }
                                if (viaToPlace != null) break;
                                index += dir;
                                if (hor) {
                                    if (index >= 0 && index < this.gridLocationsY[newMetal].length) {
                                        conY = this.gridLocationsY[newMetal][index].getCoordinate();
                                        continue;
                                    }
                                } else if (index >= 0 && index < this.gridLocationsX[newMetal].length) {
                                    conX = this.gridLocationsX[newMetal][index].getCoordinate();
                                    continue;
                                }
                                break;
                            }
                        }
                    } else {
                        SeaOfGates.SeaOfGatesTrack sogt = hor ? this.getClosestYGrid(newMetal, conY) : this.getClosestXGrid(newMetal, conX);
                        newMetalColor = sogt.getMaskNum();
                        for (MetalVia mv : mvs) {
                            if (mv.horMetal == offendingMetal && mv.verMetal == newMetal ? mv.horMetalColor != offendingMetalColor || mv.verMetalColor != newMetalColor : mv.verMetal == offendingMetal && mv.horMetal == newMetal && (mv.verMetalColor != offendingMetalColor || mv.horMetalColor != newMetalColor)) continue;
                            PrimitiveNode np = mv.via;
                            MutableDouble conWid = new MutableDouble(0.0);
                            MutableDouble conHei = new MutableDouble(0.0);
                            Orientation orient = this.getMVSize(mv, x, y, x, y, conWid, conHei);
                            if (!this.canPlaceContact(np, newMetal, offendingMetal, offendingMetalColor, conX, conY, conWid.doubleValue(), conHei.doubleValue(), orient, endA)) continue;
                            viaToPlace = mv;
                            viaToPlaceX = conX;
                            viaToPlaceY = conY;
                            viaSizeX = conWid.doubleValue();
                            viaSizeY = conHei.doubleValue();
                            viaOrient = orient;
                            break;
                        }
                    }
                    if (viaToPlace == null) continue;
                    String msg = "Route '" + this.routeName + "' at (" + TextUtils.formatDistance(pt.getX()) + "," + TextUtils.formatDistance(pt.getY()) + ") from port " + pi.getPortProto().getName() + " on node " + SeaOfGatesEngine.this.describe(pi.getNodeInst()) + " is disallowed on Metal " + (offendingMetal + 1) + " so inserting " + viaToPlace.via.describe(false);
                    if (!DBMath.areEquals(pt.getX(), viaToPlaceX) || !DBMath.areEquals(pt.getY(), viaToPlaceY)) {
                        msg = msg + " at (" + TextUtils.formatDistance(viaToPlaceX) + "," + TextUtils.formatDistance(viaToPlaceY) + ")";
                    }
                    msg = msg + " and routing from Metal " + (newMetal + 1);
                    SeaOfGatesEngine.this.warn(msg);
                    if (endA) {
                        dX = viaToPlaceX - this.aX;
                        dY = viaToPlaceY - this.aY;
                        this.aX = viaToPlaceX;
                        this.aY = viaToPlaceY;
                        pts = this.aPoly.getPoints();
                        for (int i = 0; i < pts.length; ++i) {
                            pts[i].setLocation(pts[i].getX() + dX, pts[i].getY() + dY);
                        }
                        this.aRect.setRect(this.aX, this.aY, 0.0, 0.0);
                        double aLX = this.getLowerXGrid(this.aZ, this.aRect.getMinX()).getCoordinate();
                        double aHX = this.getUpperXGrid(this.aZ, this.aRect.getMaxX()).getCoordinate();
                        double aLY = this.getLowerYGrid(this.aZ, this.aRect.getMinY()).getCoordinate();
                        double aHY = this.getUpperYGrid(this.aZ, this.aRect.getMaxY()).getCoordinate();
                        this.aRectGridded = FixpRectangle.from(new Rectangle2D.Double(aLX, aLY, aHX - aLX, aHY - aLY));
                        this.aZ = newMetal;
                        this.aC = newMetalColor;
                        this.jumpBound = new Rectangle2D.Double(Math.min(this.aX, this.bX), Math.min(this.aY, this.bY), Math.abs(this.aX - this.bX), Math.abs(this.aY - this.bY));
                        this.replaceA = viaToPlace;
                        this.replaceAZ = offendingMetal;
                        if (offendingMetalColor > 0) {
                            this.replaceAC = offendingMetalColor - 1;
                        }
                        this.aTaperWid = this.getUntaperedArcWidth(newMetal);
                        this.aTaperLen = -1.0;
                    } else {
                        dX = viaToPlaceX - this.bX;
                        dY = viaToPlaceY - this.bY;
                        this.bX = viaToPlaceX;
                        this.bY = viaToPlaceY;
                        pts = this.bPoly.getPoints();
                        for (int i = 0; i < pts.length; ++i) {
                            pts[i].setLocation(pts[i].getX() + dX, pts[i].getY() + dY);
                        }
                        this.bRect.setRect(this.bX, this.bY, 0.0, 0.0);
                        double bLX = this.getLowerXGrid(this.bZ, this.bRect.getMinX()).getCoordinate();
                        double bHX = this.getUpperXGrid(this.bZ, this.bRect.getMaxX()).getCoordinate();
                        double bLY = this.getLowerYGrid(this.bZ, this.bRect.getMinY()).getCoordinate();
                        double bHY = this.getUpperYGrid(this.bZ, this.bRect.getMaxY()).getCoordinate();
                        this.bRectGridded = FixpRectangle.from(new Rectangle2D.Double(bLX, bLY, bHX - bLX, bHY - bLY));
                        this.bZ = newMetal;
                        this.bC = newMetalColor;
                        this.jumpBound = new Rectangle2D.Double(Math.min(this.aX, this.bX), Math.min(this.aY, this.bY), Math.abs(this.aX - this.bX), Math.abs(this.aY - this.bY));
                        this.replaceB = viaToPlace;
                        this.replaceBZ = offendingMetal;
                        if (offendingMetalColor > 0) {
                            this.replaceBC = offendingMetalColor - 1;
                        }
                        this.bTaperWid = this.getUntaperedArcWidth(newMetal);
                        this.bTaperLen = -1.0;
                    }
                    NodeInst dummyNi = NodeInst.makeDummyInstance(viaToPlace.via, SeaOfGatesEngine.this.ep, EPoint.fromLambda(viaToPlaceX, viaToPlaceY), viaSizeX, viaSizeY, viaOrient);
                    Poly[] conPolys = SeaOfGatesEngine.this.tech.getShapeOfNode(dummyNi);
                    FixpTransform trans = null;
                    if (viaOrient != Orientation.IDENT) {
                        trans = dummyNi.rotateOut();
                    }
                    for (int p = 0; p < conPolys.length; ++p) {
                        Poly conPoly = conPolys[p];
                        Layer conLayer = conPoly.getLayer();
                        if (trans != null) {
                            conPoly.transform(trans);
                        }
                        FixpRectangle conRect = conPoly.getBounds2D();
                        Layer.Function fun = conLayer.getFunction();
                        if (fun.isMetal()) {
                            SeaOfGatesEngine.this.addRectangle(conRect, conLayer, this.netID, false, false);
                            continue;
                        }
                        if (!fun.isContact()) continue;
                        SeaOfGatesEngine.this.addVia(ERectangle.fromLambda(conRect), conLayer, this.netID, false);
                    }
                    return false;
                }
            }
            String msg = "Route '" + this.routeName + "' at (" + TextUtils.formatDistance(pt.getX()) + "," + TextUtils.formatDistance(pt.getY()) + ") from port " + pi.getPortProto().getName() + " on node " + SeaOfGatesEngine.this.describe(pi.getNodeInst()) + " cannot connect";
            if (SeaOfGatesEngine.this.sogp.isContactAllowedDownToAvoidedLayer() || SeaOfGatesEngine.this.sogp.isContactAllowedUpToAvoidedLayer()) {
                msg = msg + " (allowed to go";
                if (SeaOfGatesEngine.this.sogp.isContactAllowedDownToAvoidedLayer()) {
                    msg = SeaOfGatesEngine.this.sogp.isContactAllowedUpToAvoidedLayer() ? msg + " up/down" : msg + " down";
                } else if (SeaOfGatesEngine.this.sogp.isContactAllowedUpToAvoidedLayer()) {
                    msg = msg + " up";
                }
                msg = msg + " one layer)";
            }
            if (whatWasChecked.size() > 0) {
                boolean first = true;
                for (Integer m : whatWasChecked.keySet()) {
                    msg = first ? msg + " because" : msg + " and";
                    first = false;
                    Point invalidColors = (Point)contactInvalidColors.get(m);
                    if (invalidColors != null) {
                        msg = msg + " no contact exists from metal-" + (realOffendingMetal + 1) + " mask color " + invalidColors.x + " to metal-" + (m + 1) + " mask color " + invalidColors.y;
                        continue;
                    }
                    msg = msg + " contact(s) cannot be placed:";
                    List contacts = (List)whatWasChecked.get(m);
                    for (PrimitiveNode pNp : contacts) {
                        msg = msg + " " + pNp.describe(false);
                    }
                }
            } else {
                msg = msg + " because all connecting layers have been prevented by Routing Preferences";
            }
            SeaOfGatesEngine.this.error(msg);
            ArrayList<PolyBase> polyList = new ArrayList<PolyBase>();
            polyList.add(new PolyBase(pt.getX(), pt.getY(), 0.0, 0.0));
            SeaOfGatesEngine.this.errorLogger.logMessageWithLines(msg, polyList, null, SeaOfGatesEngine.this.cell, 0, true);
            return true;
        }

        private double getTaperWidth(PortInst pi, int metalNo) {
            PortProto pp = pi.getPortProto();
            NodeInst ni = pi.getNodeInst();
            FixpTransform trans = ni.rotateOut();
            while (ni.isCellInstance()) {
                Export e = (Export)pp;
                ni = e.getOriginalPort().getNodeInst();
                pp = e.getOriginalPort().getPortProto();
                trans.concatenate(ni.rotateOut());
            }
            Poly[] polys = ni.getProto().getTechnology().getShapeOfNode(ni);
            for (int i = 0; i < polys.length; ++i) {
                Poly poly = polys[i];
                boolean found = false;
                for (int j = 0; j < SeaOfGatesEngine.this.metalLayers[metalNo].length; ++j) {
                    if (SeaOfGatesEngine.this.metalLayers[metalNo][j] != poly.getLayer()) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
                poly.transform(trans);
                FixpRectangle rect = poly.getBounds2D();
                boolean hor = true;
                if (SeaOfGatesEngine.this.sogp.isForceHorVer()) {
                    if (SeaOfGatesEngine.this.sogp.isHorizontalEven()) {
                        if (metalNo % 2 == 0) {
                            hor = false;
                        }
                    } else if (metalNo % 2 != 0) {
                        hor = false;
                    }
                    if (hor) {
                        return rect.getHeight();
                    }
                    return rect.getWidth();
                }
                return Math.min(rect.getWidth(), rect.getHeight());
            }
            return this.getUntaperedArcWidth(metalNo);
        }

        public void makeWavefronts() {
            this.dirAtoB = new Wavefront(this, this.aPi, this.aRect, this.aX, this.aY, this.aZ, this.aC, this.aTaperLen, 2, this.bPi, this.bRect, this.bRectGridded, this.bX, this.bY, this.bZ, this.bC, this.bTaperLen, 1, "a->b", this.debuggingRouteFromA != null && this.debuggingRouteFromA != false);
            this.dirBtoA = new Wavefront(this, this.bPi, this.bRect, this.bX, this.bY, this.bZ, this.bC, this.bTaperLen, 4, this.aPi, this.aRect, this.aRectGridded, this.aX, this.aY, this.aZ, this.aC, this.aTaperLen, -1, "b->a", this.debuggingRouteFromA != null && this.debuggingRouteFromA == false);
        }

        public void setBatchInfo(RouteBatch batch, int routeInBatch) {
            this.batch = batch;
            this.routeInBatch = routeInBatch;
        }

        public int getNumInBatch() {
            return this.batch.routesInBatch.size();
        }

        public int getRouteInBatch() {
            return this.routeInBatch;
        }

        public MutableInteger getNetID() {
            return this.netID;
        }

        public void setNetID(MutableInteger id) {
            this.netID = id;
        }

        private void setNetID(Network net) {
            Integer netIDI = (Integer)SeaOfGatesEngine.this.netIDs.get(net);
            assert (netIDI != null);
            this.netID = new MutableInteger(netIDI);
            List<MutableInteger> theseNetIDs = SeaOfGatesEngine.this.netIDsByValue.get(netIDI);
            if (theseNetIDs == null) {
                theseNetIDs = new ArrayList<MutableInteger>();
                SeaOfGatesEngine.this.netIDsByValue.put(netIDI, theseNetIDs);
            }
            theseNetIDs.add(this.netID);
        }

        public boolean is2X(int metNum, double fX, double fY, double tX, double tY) {
            double wid;
            return SeaOfGatesEngine.this.size2X[metNum] != 0.0 && (wid = this.getArcWidth(metNum, fX, fY, tX, tY)) >= SeaOfGatesEngine.this.size2X[metNum];
        }

        public double getArcWidth(int metNum, double fX, double fY, double tX, double tY) {
            Boolean hor = null;
            if (SeaOfGatesEngine.this.sogp.isForceHorVer()) {
                hor = Boolean.TRUE;
                if (SeaOfGatesEngine.this.sogp.isHorizontalEven()) {
                    if (metNum % 2 == 0) {
                        hor = Boolean.FALSE;
                    }
                } else if (metNum % 2 != 0) {
                    hor = Boolean.FALSE;
                }
            }
            if (this.aTaperLen >= 0.0 && this.aZ == metNum) {
                if (hor == null || hor.booleanValue()) {
                    if (fY == this.aY && Math.abs(fX - this.aX) < this.aTaperLen) {
                        return this.aTaperWid;
                    }
                    if (tY == this.aY && Math.abs(tX - this.aX) < this.aTaperLen) {
                        return this.aTaperWid;
                    }
                }
                if (hor == null || !hor.booleanValue()) {
                    if (fX == this.aX && Math.abs(fY - this.aY) < this.aTaperLen) {
                        return this.aTaperWid;
                    }
                    if (tX == this.aX && Math.abs(tY - this.aY) < this.aTaperLen) {
                        return this.aTaperWid;
                    }
                }
            }
            if (this.bTaperLen >= 0.0 && this.bZ == metNum) {
                if (hor == null || hor.booleanValue()) {
                    if (fY == this.bY && Math.abs(fX - this.bX) < this.bTaperLen) {
                        return this.bTaperWid;
                    }
                    if (tY == this.bY && Math.abs(tX - this.bX) < this.bTaperLen) {
                        return this.bTaperWid;
                    }
                }
                if (hor == null || !hor.booleanValue()) {
                    if (fX == this.bX && Math.abs(fY - this.bY) < this.bTaperLen) {
                        return this.bTaperWid;
                    }
                    if (tX == this.bX && Math.abs(tY - this.bY) < this.bTaperLen) {
                        return this.bTaperWid;
                    }
                }
            }
            return this.getUntaperedArcWidth(metNum);
        }

        public double getUntaperedArcWidth(int metNum) {
            if (this.overrideMetalWidth != null) {
                return this.overrideMetalWidth[metNum];
            }
            double width = Math.max(SeaOfGatesEngine.this.maxDefArcWidth[metNum], this.minWidth);
            return width;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double[] getSpacingRule(int layer, double width, double length) {
            if (this.overrideMetalSpacings[layer] != null) {
                return this.overrideMetalSpacings[layer];
            }
            if (width < 0.0) {
                width = SeaOfGatesEngine.this.maxDefArcWidth[layer];
            }
            if (length < 0.0) {
                length = 50.0;
            }
            Double wid = width;
            HashMap<Double, double[]> widMap = (HashMap<Double, double[]>)SeaOfGatesEngine.this.layerSurround[layer].get(wid);
            if (widMap == null) {
                Map[] mapArray = SeaOfGatesEngine.this.layerSurround;
                synchronized (mapArray) {
                    widMap = (Map)SeaOfGatesEngine.this.layerSurround[layer].get(wid);
                    if (widMap == null) {
                        widMap = new HashMap<Double, double[]>();
                        SeaOfGatesEngine.this.layerSurround[layer].put(wid, widMap);
                    }
                }
            }
            Double len = length;
            double[] value = new double[2];
            double[] cachedValue = (double[])widMap.get(len);
            if (cachedValue != null) {
                value[0] = cachedValue[0];
                value[1] = cachedValue[1];
            } else {
                value[0] = 0.0;
                value[1] = -1.0;
                for (int c = 0; c < SeaOfGatesEngine.this.metalLayers[layer].length; ++c) {
                    Layer lay = SeaOfGatesEngine.this.metalLayers[layer][c];
                    DRCTemplate rule = DRC.getSpacingRule(lay, null, lay, null, false, -1, width, length);
                    if (rule == null) continue;
                    value[0] = Math.max(value[0], rule.getValue(0));
                    if (rule.getNumValues() <= 1) continue;
                    value[1] = Math.max(value[1], rule.getValue(1));
                }
                if (value[1] < 0.0) {
                    value[1] = value[0];
                }
                widMap.put(len, value);
            }
            if (this.overrideMetalSpacingX != null) {
                value[0] = this.overrideMetalSpacingX[layer];
            }
            if (this.overrideMetalSpacingY != null) {
                value[1] = this.overrideMetalSpacingY[layer];
            }
            return value;
        }

        public boolean preventArc(int metNum) {
            if (this.overridePreventArcs != null) {
                return this.overridePreventArcs[metNum];
            }
            return SeaOfGatesEngine.this.preventArcs[metNum];
        }

        public String getName() {
            return this.routeName;
        }

        public Rectangle2D getBounds() {
            return this.routeBounds;
        }

        public PortInst getAPort() {
            return this.aPi;
        }

        public PortInst getBPort() {
            return this.bPi;
        }

        public double getAX() {
            return this.aX;
        }

        public double getAY() {
            return this.aY;
        }

        public double getBX() {
            return this.bX;
        }

        public double getBY() {
            return this.bY;
        }

        public RTNode<SOGBound> getViaTree(Layer lay) {
            return SeaOfGatesEngine.this.rTrees.getViaTree(lay).getRoot();
        }

        public Iterator<SOGBound> searchViaTree(Layer lay, Rectangle2D bound) {
            return SeaOfGatesEngine.this.rTrees.getViaTree(lay).search(bound);
        }

        public Rectangle2D[] getGRBuckets() {
            return this.buckets;
        }

        public boolean checkEndSurround() {
            double[] toSurround;
            double toMetalSpacing;
            double[] fromSurround;
            double fromMetalSpacing = this.getArcWidth(this.aZ, this.aX, this.aY, this.aX, this.aY) / 2.0;
            SOGBound block = this.getMetalBlockage(this.netID, this.aZ, fromMetalSpacing, fromMetalSpacing, fromSurround = this.getSpacingRule(this.aZ, SeaOfGatesEngine.this.maxDefArcWidth[this.aZ], -1.0), this.aX, this.aY);
            if (block != null && !SeaOfGatesEngine.this.sogp.isGridForced(SeaOfGatesEngine.this.primaryMetalArc[this.aZ])) {
                FixpRectangle fromRect = this.aPoly.getBounds2D();
                double stepSize = fromMetalSpacing + Math.max(fromSurround[0], fromSurround[1]);
                if (stepSize > 0.0 && (((RectangularShape)fromRect).getWidth() > 0.0 || ((RectangularShape)fromRect).getHeight() > 0.0)) {
                    for (double x = ((RectangularShape)fromRect).getMinX(); x <= ((RectangularShape)fromRect).getMaxX(); x += stepSize) {
                        for (double y = ((RectangularShape)fromRect).getMinY(); y <= ((RectangularShape)fromRect).getMaxY(); y += stepSize) {
                            SOGBound stepBlock = this.getMetalBlockage(this.netID, this.aZ, fromMetalSpacing, fromMetalSpacing, fromSurround, x, y);
                            if (stepBlock != null) continue;
                            this.aX = x;
                            this.aY = y;
                            block = null;
                            break;
                        }
                        if (block == null) break;
                    }
                }
                if (block != null) {
                    String errorMsg = "Cannot route from port " + this.aPi.getPortProto().getName() + " of node " + SeaOfGatesEngine.this.describe(this.aPi.getNodeInst()) + " at (" + TextUtils.formatDistance(this.aX) + "," + TextUtils.formatDistance(this.aY) + ") because it is blocked on layer " + SeaOfGatesEngine.describeMetal(this.aZ, this.aC) + " [needs " + TextUtils.formatDistance(fromMetalSpacing + Math.max(fromSurround[0], fromSurround[1])) + " all around, blockage is " + TextUtils.formatDistance(block.getBounds().getMinX()) + "<=X<=" + TextUtils.formatDistance(block.getBounds().getMaxX()) + " and " + TextUtils.formatDistance(block.getBounds().getMinY()) + "<=Y<=" + TextUtils.formatDistance(block.getBounds().getMaxY()) + "]";
                    if (this.reroute) {
                        errorMsg = "(Retry) " + errorMsg;
                    }
                    SeaOfGatesEngine.this.error(errorMsg);
                    ArrayList<PolyBase> polyList = new ArrayList<PolyBase>();
                    polyList.add(new PolyBase(this.aX, this.aY, (fromMetalSpacing + fromSurround[0]) * 2.0, (fromMetalSpacing + fromSurround[1]) * 2.0));
                    polyList.add(new PolyBase(block.getBounds()));
                    ArrayList<EPoint> lineList = new ArrayList<EPoint>();
                    lineList.add(EPoint.fromLambda(block.getBounds().getMinX(), block.getBounds().getMinY()));
                    lineList.add(EPoint.fromLambda(block.getBounds().getMaxX(), block.getBounds().getMaxY()));
                    lineList.add(EPoint.fromLambda(block.getBounds().getMinX(), block.getBounds().getMaxY()));
                    lineList.add(EPoint.fromLambda(block.getBounds().getMaxX(), block.getBounds().getMinY()));
                    SeaOfGatesEngine.this.errorLogger.logMessageWithLines(errorMsg, polyList, lineList, SeaOfGatesEngine.this.cell, 0, true);
                    return true;
                }
            }
            if ((block = this.getMetalBlockage(this.netID, this.bZ, toMetalSpacing = this.getArcWidth(this.bZ, this.bX, this.bY, this.bX, this.bY) / 2.0, toMetalSpacing, toSurround = this.getSpacingRule(this.bZ, SeaOfGatesEngine.this.maxDefArcWidth[this.bZ], -1.0), this.bX, this.bY)) != null && !SeaOfGatesEngine.this.sogp.isGridForced(SeaOfGatesEngine.this.primaryMetalArc[this.bZ])) {
                FixpRectangle toRect = this.bPoly.getBounds2D();
                double stepSize = toMetalSpacing + Math.max(toSurround[0], toSurround[1]);
                if (stepSize > 0.0 && (((RectangularShape)toRect).getWidth() > 0.0 || ((RectangularShape)toRect).getHeight() > 0.0)) {
                    for (double x = ((RectangularShape)toRect).getMinX(); x <= ((RectangularShape)toRect).getMaxX(); x += stepSize) {
                        for (double y = ((RectangularShape)toRect).getMinY(); y <= ((RectangularShape)toRect).getMaxY(); y += stepSize) {
                            SOGBound stepBlock = this.getMetalBlockage(this.netID, this.bZ, toMetalSpacing, toMetalSpacing, toSurround, x, y);
                            if (stepBlock != null) continue;
                            this.bX = x;
                            this.bY = y;
                            block = null;
                            break;
                        }
                        if (block == null) break;
                    }
                }
                if (block != null) {
                    String errorMsg = "Cannot route to port " + this.bPi.getPortProto().getName() + " of node " + SeaOfGatesEngine.this.describe(this.bPi.getNodeInst()) + " at (" + TextUtils.formatDistance(this.bX) + "," + TextUtils.formatDistance(this.bY) + ") because it is blocked on layer " + SeaOfGatesEngine.describeMetal(this.bZ, this.bC) + " [needs " + TextUtils.formatDistance(toMetalSpacing + Math.max(toSurround[0], toSurround[1])) + " all around, blockage is " + TextUtils.formatDistance(block.getBounds().getMinX()) + "<=X<=" + TextUtils.formatDistance(block.getBounds().getMaxX()) + " and " + TextUtils.formatDistance(block.getBounds().getMinY()) + "<=Y<=" + TextUtils.formatDistance(block.getBounds().getMaxY()) + "]";
                    if (this.reroute) {
                        errorMsg = "(Retry) " + errorMsg;
                    }
                    SeaOfGatesEngine.this.error(errorMsg);
                    ArrayList<PolyBase> polyList = new ArrayList<PolyBase>();
                    polyList.add(new PolyBase(this.bX, this.bY, (toMetalSpacing + toSurround[0]) * 2.0, (toMetalSpacing + toSurround[1]) * 2.0));
                    polyList.add(new PolyBase(block.getBounds()));
                    ArrayList<EPoint> lineList = new ArrayList<EPoint>();
                    lineList.add(EPoint.fromLambda(block.getBounds().getMinX(), block.getBounds().getMinY()));
                    lineList.add(EPoint.fromLambda(block.getBounds().getMaxX(), block.getBounds().getMaxY()));
                    lineList.add(EPoint.fromLambda(block.getBounds().getMinX(), block.getBounds().getMaxY()));
                    lineList.add(EPoint.fromLambda(block.getBounds().getMaxX(), block.getBounds().getMinY()));
                    SeaOfGatesEngine.this.errorLogger.logMessageWithLines(errorMsg, polyList, lineList, SeaOfGatesEngine.this.cell, 0, true);
                    return true;
                }
            }
            return false;
        }

        private void growNetwork() {
            Iterator<SOGBound> it;
            Iterator<SOGBound> it2;
            this.extractList = new HashMap<SOGBound, Integer>();
            MutableInteger miA = new MutableInteger(this.netID.intValue() | 2);
            MutableInteger miB = new MutableInteger(this.netID.intValue() | 4);
            this.growPoint(this.aX, this.aY, this.aZ, miA);
            while ((it2 = this.extractList.keySet().iterator()).hasNext()) {
                SOGBound sBound = it2.next();
                Integer layerNumInt = this.extractList.get(sBound);
                this.extractList.remove(sBound);
                this.growArea(sBound, layerNumInt, sBound.getNetID());
            }
            boolean alreadyDone = this.growPoint(this.bX, this.bY, this.bZ, miB);
            if (alreadyDone) {
                this.alreadyRouted = true;
            }
            if (this.spineTaps != null) {
                for (PortInst pi : this.spineTaps) {
                    ArcProto ap = SeaOfGatesEngine.this.getMetalArcOnPort(pi);
                    if (ap == null) continue;
                    int z = ap.getFunction().getLevel() - 1;
                    EPoint pt = pi.getCenter();
                    this.growPoint(pt.getX(), pt.getY(), z, this.netID);
                }
            }
            while ((it = this.extractList.keySet().iterator()).hasNext()) {
                SOGBound sBound = it.next();
                Integer layerNumInt = this.extractList.get(sBound);
                this.extractList.remove(sBound);
                this.growArea(sBound, layerNumInt, sBound.getNetID());
            }
            this.extractList = null;
        }

        private boolean growPoint(double x, double y, int layerNum, MutableInteger idNumber) {
            Rectangle2D.Double search = new Rectangle2D.Double(x, y, 0.0, 0.0);
            BlockageTree bTree = SeaOfGatesEngine.this.rTrees.getMetalTree(SeaOfGatesEngine.this.primaryMetalLayer[layerNum]);
            if (bTree.isEmpty()) {
                return false;
            }
            boolean foundNet = false;
            Iterator sea = bTree.search(search);
            while (sea.hasNext()) {
                SOGBound sBound = (SOGBound)sea.next();
                if (sBound.isUserSuppliedBlockage() || !sBound.containsPoint(x, y)) continue;
                if (sBound.getNetID() == null) {
                    sBound.setNetID(idNumber);
                    if (this.extractList.get(sBound) != null) continue;
                    this.extractList.put(sBound, layerNum);
                    SeaOfGatesEngine.this.blockagesFound++;
                    if (SeaOfGatesEngine.this.blockagesFound % 100 != 0) continue;
                    SeaOfGatesEngine.this.setProgressValue(SeaOfGatesEngine.this.blockagesFound, SeaOfGatesEngine.this.totalBlockages);
                    continue;
                }
                if (sBound.isSameBasicNet(idNumber)) {
                    foundNet = true;
                }
                sBound.updateNetID(idNumber, SeaOfGatesEngine.this.netIDsByValue);
            }
            return foundNet;
        }

        private void growArea(SOGBound sBound, int layerNum, MutableInteger idNumber) {
            SOGVia subBound;
            Iterator sea;
            BlockageTree viaTree;
            BlockageTree metalTree = SeaOfGatesEngine.this.rTrees.getMetalTree(SeaOfGatesEngine.this.primaryMetalLayer[layerNum]);
            ERectangle bound = sBound.bound;
            Iterator sea2 = metalTree.search(bound);
            while (sea2.hasNext()) {
                SOGBound subBound2 = (SOGBound)sea2.next();
                if (subBound2.isUserSuppliedBlockage() || (sBound instanceof SOGPoly || subBound2 instanceof SOGPoly) && !this.doesIntersect(sBound, subBound2)) continue;
                if (subBound2.getNetID() == null) {
                    subBound2.setNetID(idNumber);
                    if (this.extractList.get(subBound2) != null) continue;
                    this.extractList.put(subBound2, layerNum);
                    SeaOfGatesEngine.this.blockagesFound++;
                    if (SeaOfGatesEngine.this.blockagesFound % 100 != 0) continue;
                    SeaOfGatesEngine.this.setProgressValue(SeaOfGatesEngine.this.blockagesFound, SeaOfGatesEngine.this.totalBlockages);
                    continue;
                }
                subBound2.updateNetID(idNumber, SeaOfGatesEngine.this.netIDsByValue);
            }
            if (layerNum > 0 && !(viaTree = SeaOfGatesEngine.this.rTrees.getViaTree(SeaOfGatesEngine.this.viaLayers[layerNum - 1])).isEmpty()) {
                sea = viaTree.search(bound);
                while (sea.hasNext()) {
                    subBound = (SOGVia)sea.next();
                    if (sBound instanceof SOGPoly && !this.doesIntersect(sBound, subBound)) continue;
                    if (subBound.getNetID() == null) {
                        subBound.setNetID(idNumber);
                        this.growPoint(subBound.getBounds().getCenterX(), subBound.getBounds().getCenterY(), layerNum - 1, idNumber);
                        continue;
                    }
                    subBound.updateNetID(idNumber, SeaOfGatesEngine.this.netIDsByValue);
                }
            }
            if (layerNum < numMetalLayers - 1) {
                BlockageTree bTree = SeaOfGatesEngine.this.rTrees.getViaTree(SeaOfGatesEngine.this.viaLayers[layerNum]);
                sea = bTree.search(bound);
                while (sea.hasNext()) {
                    subBound = (SOGVia)sea.next();
                    if (sBound instanceof SOGPoly && !this.doesIntersect(sBound, subBound)) continue;
                    if (subBound.getNetID() == null) {
                        subBound.setNetID(idNumber);
                        this.growPoint(subBound.getBounds().getCenterX(), subBound.getBounds().getCenterY(), layerNum + 1, idNumber);
                        continue;
                    }
                    subBound.updateNetID(idNumber, SeaOfGatesEngine.this.netIDsByValue);
                }
            }
        }

        private boolean doesIntersect(SOGBound bound1, SOGBound bound2) {
            EPoint[] points2;
            EPoint[] points1;
            if (!bound1.isManhattan() || !bound2.isManhattan()) {
                return true;
            }
            if (bound1 instanceof SOGPoly) {
                SOGPoly p = (SOGPoly)bound1;
                PolyBase.Point[] po = p.poly.getPoints();
                points1 = new EPoint[po.length];
                for (int i = 0; i < po.length; ++i) {
                    points1[i] = EPoint.fromLambda(po[i].getX(), po[i].getY());
                }
            } else {
                points1 = new EPoint[]{EPoint.fromLambda(bound1.bound.getMinX(), bound1.bound.getMinY()), EPoint.fromLambda(bound1.bound.getMinX(), bound1.bound.getMaxY()), EPoint.fromLambda(bound1.bound.getMaxX(), bound1.bound.getMaxY()), EPoint.fromLambda(bound1.bound.getMaxX(), bound1.bound.getMinY()), EPoint.fromLambda(bound1.bound.getMinX(), bound1.bound.getMinY())};
            }
            if (bound2 instanceof SOGPoly) {
                SOGPoly p = (SOGPoly)bound2;
                PolyBase.Point[] po = p.poly.getPoints();
                points2 = new EPoint[po.length];
                for (int i = 0; i < po.length; ++i) {
                    points2[i] = EPoint.fromLambda(po[i].getX(), po[i].getY());
                }
            } else {
                points2 = new EPoint[]{EPoint.fromLambda(bound2.bound.getMinX(), bound2.bound.getMinY()), EPoint.fromLambda(bound2.bound.getMinX(), bound2.bound.getMaxY()), EPoint.fromLambda(bound2.bound.getMaxX(), bound2.bound.getMaxY()), EPoint.fromLambda(bound2.bound.getMaxX(), bound2.bound.getMinY()), EPoint.fromLambda(bound2.bound.getMinX(), bound2.bound.getMinY())};
            }
            for (int i = 1; i < points1.length; ++i) {
                EPoint p1a = points1[i - 1];
                EPoint p1b = points1[i];
                if (p1a.getX() == p1b.getX() && p1a.getY() == p1b.getY()) continue;
                double l1X = Math.min(p1a.getX(), p1b.getX());
                double h1X = Math.max(p1a.getX(), p1b.getX());
                double l1Y = Math.min(p1a.getY(), p1b.getY());
                double h1Y = Math.max(p1a.getY(), p1b.getY());
                for (int j = 1; j < points2.length; ++j) {
                    EPoint p2a = points2[j - 1];
                    EPoint p2b = points2[j];
                    if (p2a.getX() == p2b.getX() && p2a.getY() == p2b.getY()) continue;
                    double l2X = Math.min(p2a.getX(), p2b.getX());
                    double h2X = Math.max(p2a.getX(), p2b.getX());
                    double l2Y = Math.min(p2a.getY(), p2b.getY());
                    double h2Y = Math.max(p2a.getY(), p2b.getY());
                    if (!(l1X == h1X ? (l2X == h2X ? l1X == l2X && h1Y > l2Y && h2Y > l1Y : l1X > l2X && l1X < h2X && l2Y > l1Y && l2Y < h1Y) : (l2Y == h2Y ? l1Y == l2Y && h1X > l2X && h2X > l1X : l1Y > l2Y && l1Y < h2Y && l2X > l1X && l2X < h1X))) continue;
                    return true;
                }
            }
            Poly p1 = new Poly(points1);
            if (p1.contains(points2[0])) {
                return true;
            }
            Poly p2 = new Poly(points2);
            return p2.contains(points1[0]);
        }

        private void addBlockagesAtPorts(PortInst pi) {
            MutableInteger netIDUse = new MutableInteger(this.netID.intValue() + 1);
            Poly poly = pi.getPoly();
            FixpRectangle portBounds = poly.getBounds2D();
            ArcProto[] poss = SeaOfGatesEngine.this.getPossibleConnections(pi.getPortProto());
            int lowMetal = -1;
            int highMetal = -1;
            for (int i = 0; i < poss.length; ++i) {
                if (poss[i].getTechnology() != SeaOfGatesEngine.this.tech || !poss[i].getFunction().isMetal()) continue;
                int level = poss[i].getFunction().getLevel();
                if (lowMetal < 0) {
                    lowMetal = highMetal = level;
                    continue;
                }
                lowMetal = Math.min(lowMetal, level);
                highMetal = Math.max(highMetal, level);
            }
            if (lowMetal < 0) {
                return;
            }
            double x = pi.getCenter().getX();
            double y = pi.getCenter().getY();
            HashMap<Layer, ArrayList<Rectangle2D.Double>> blockageRects = new HashMap<Layer, ArrayList<Rectangle2D.Double>>();
            for (int via = lowMetal - 2; via < highMetal; ++via) {
                List<MetalVia> mvs2X;
                if (via < 0 || via >= numMetalLayers - 1) continue;
                List<MetalVia> mvs = SeaOfGatesEngine.this.metalVias[via].getVias();
                if ((this.is2X(via, x, y, x, y) || via + 1 < numMetalLayers && this.is2X(via + 1, x, y, x, y)) && (mvs2X = SeaOfGatesEngine.this.metalVias2X[via].getVias()).size() > 0) {
                    mvs = mvs2X;
                }
                int upper = mvs.size();
                for (int j = 0; j < upper; ++j) {
                    MetalVia mv = mvs.get(j);
                    PrimitiveNode np = mv.via;
                    SizeOffset so = np.getProtoSizeOffset();
                    double xOffset = so.getLowXOffset() + so.getHighXOffset();
                    double yOffset = so.getLowYOffset() + so.getHighYOffset();
                    double wid = Math.max(np.getDefWidth(SeaOfGatesEngine.this.ep) - xOffset, this.minWidth) + xOffset;
                    double hei = Math.max(np.getDefHeight(SeaOfGatesEngine.this.ep) - yOffset, this.minWidth) + yOffset;
                    NodeInst dummy = NodeInst.makeDummyInstance(np, SeaOfGatesEngine.this.ep, EPoint.ORIGIN, wid, hei, Orientation.IDENT);
                    Poly[] polys = SeaOfGatesEngine.this.tech.getShapeOfNode(dummy);
                    for (int i = 0; i < polys.length; ++i) {
                        Poly metalPoly = polys[i];
                        Layer layer = metalPoly.getLayer();
                        if (!layer.getFunction().isMetal()) continue;
                        FixpRectangle metalBounds = metalPoly.getBounds2D();
                        Rectangle2D.Double bounds = new Rectangle2D.Double(((RectangularShape)metalBounds).getMinX() + ((RectangularShape)portBounds).getCenterX(), ((RectangularShape)metalBounds).getMinY() + ((RectangularShape)portBounds).getCenterY(), ((RectangularShape)metalBounds).getWidth(), ((RectangularShape)metalBounds).getHeight());
                        int layNum = layer.getFunction().getLevel() - 1;
                        boolean hor = true;
                        if (SeaOfGatesEngine.this.sogp.isHorizontalEven()) {
                            if (layNum % 2 == 0) {
                                hor = false;
                            }
                        } else if (layNum % 2 != 0) {
                            hor = false;
                        }
                        if (this.forceGridArcs[layNum] && (hor ? !this.isOnYGrid(layNum, bounds.getCenterY()) : !this.isOnXGrid(layNum, bounds.getCenterX()))) continue;
                        boolean free = true;
                        BlockageTree bTree = SeaOfGatesEngine.this.rTrees.getMetalTree(layer);
                        if (!bTree.isEmpty()) {
                            Iterator sea = bTree.search(bounds);
                            while (sea.hasNext()) {
                                SOGBound sBound = (SOGBound)sea.next();
                                int netValue = 0;
                                if (sBound.getNetID() != null) {
                                    netValue = sBound.getNetID().intValue();
                                }
                                if (netValue != this.netID.intValue() || sBound.getBounds().getMinX() > bounds.getMinX() || sBound.getBounds().getMaxX() < bounds.getMaxX() || sBound.getBounds().getMinY() > bounds.getMinY() || sBound.getBounds().getMaxY() < bounds.getMaxY()) continue;
                                free = false;
                                break;
                            }
                        }
                        if (!free) continue;
                        ArrayList<Rectangle2D.Double> rects = (ArrayList<Rectangle2D.Double>)blockageRects.get(layer);
                        if (rects == null) {
                            rects = new ArrayList<Rectangle2D.Double>();
                            blockageRects.put(layer, rects);
                        }
                        rects.add(bounds);
                    }
                }
            }
            for (Layer layer : blockageRects.keySet()) {
                List rects = (List)blockageRects.get(layer);
                for (int i = 0; i < rects.size(); ++i) {
                    Rectangle2D bound1 = (Rectangle2D)rects.get(i);
                    for (int j = 0; j < rects.size(); ++j) {
                        if (j == i) continue;
                        Rectangle2D bound2 = (Rectangle2D)rects.get(j);
                        if (!(bound1.getMinX() <= bound2.getMinX()) || !(bound1.getMaxX() >= bound2.getMaxX()) || !(bound1.getMinY() <= bound2.getMinY()) || !(bound1.getMaxY() >= bound2.getMaxY())) continue;
                        rects.remove(j);
                        if (i > j) {
                            --i;
                        }
                        --j;
                    }
                }
                for (Rectangle2D bounds : rects) {
                    List<SOGBound> blocksOnLayer;
                    SOGBound rtn = SeaOfGatesEngine.this.addRectangle(bounds, layer, netIDUse, false, false);
                    if (this.endBlockages == null) {
                        this.endBlockages = new HashMap<Layer, List<SOGBound>>();
                    }
                    if ((blocksOnLayer = this.endBlockages.get(layer)) == null) {
                        blocksOnLayer = new ArrayList<SOGBound>();
                        this.endBlockages.put(layer, blocksOnLayer);
                    }
                    blocksOnLayer.add(rtn);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SOGBound getMetalBlockage(MutableInteger netID, int metNo, double halfWidth, double halfHeight, double[] surround, double x, double y) {
            BlockageTree bTree = SeaOfGatesEngine.this.rTrees.getMetalTree(SeaOfGatesEngine.this.primaryMetalLayer[metNo]);
            bTree.lock();
            try {
                double lX = x - halfWidth - surround[0];
                double hX = x + halfWidth + surround[0];
                double lY = y - halfHeight - surround[1];
                double hY = y + halfHeight + surround[1];
                Rectangle2D.Double searchArea = new Rectangle2D.Double(lX, lY, hX - lX, hY - lY);
                Iterator sea = bTree.search(searchArea);
                while (sea.hasNext()) {
                    PolyBase poly;
                    SOGBound sBound = (SOGBound)sea.next();
                    ERectangle bound = sBound.getBounds();
                    if (DBMath.isLessThanOrEqualTo(bound.getMaxX(), lX) || DBMath.isGreaterThanOrEqualTo(bound.getMinX(), hX) || DBMath.isLessThanOrEqualTo(bound.getMaxY(), lY) || DBMath.isGreaterThanOrEqualTo(bound.getMinY(), hY) || netID != null && sBound.isSameBasicNet(netID) || sBound instanceof SOGPoly && !(poly = ((SOGPoly)sBound).getPoly()).contains(searchArea)) continue;
                    SOGBound sOGBound = sBound;
                    return sOGBound;
                }
                SOGBound sOGBound = null;
                return sOGBound;
            }
            finally {
                bTree.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SOGVia getViaBlockage(MutableInteger netID, Layer layer, double surround, Rectangle2D rect) {
            BlockageTree bTree = SeaOfGatesEngine.this.rTrees.getViaTree(layer);
            double rectLX = rect.getMinX();
            double rectHX = rect.getMaxX();
            double rectLY = rect.getMinY();
            double rectHY = rect.getMaxY();
            bTree.lock();
            try {
                if (bTree.isEmpty()) {
                    SOGVia sOGVia = null;
                    return sOGVia;
                }
                Rectangle2D.Double searchArea = new Rectangle2D.Double(rect.getMinX() - surround - 1.0, rect.getMinY() - surround - 1.0, rect.getWidth() + surround * 2.0 + 2.0, rect.getHeight() + surround * 2.0 + 2.0);
                Iterator sea = bTree.search(searchArea);
                while (sea.hasNext()) {
                    double testHY;
                    double testLY;
                    double testHX;
                    SOGVia sLoc = (SOGVia)sea.next();
                    double testLX = sLoc.getBounds().getMinX();
                    double dist = SeaOfGatesEngine.this.cutDistance(rectLX, rectHX, rectLY, rectHY, testLX, testHX = sLoc.getBounds().getMaxX(), testLY = sLoc.getBounds().getMinY(), testHY = sLoc.getBounds().getMaxY());
                    if (DBMath.isGreaterThanOrEqualTo(dist, surround) || sLoc.isSameBasicNet(netID) && DBMath.areEquals(sLoc.getBounds().getCenterX(), rect.getCenterX()) && DBMath.areEquals(sLoc.getBounds().getCenterY(), rect.getCenterY())) continue;
                    SOGVia sOGVia = sLoc;
                    return sOGVia;
                }
                SOGVia sOGVia = null;
                return sOGVia;
            }
            finally {
                bTree.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SOGVia getViaBlockageOLD(MutableInteger netID, Layer layer, double halfWidth, double halfHeight, double x, double y) {
            BlockageTree bTree = SeaOfGatesEngine.this.rTrees.getViaTree(layer);
            bTree.lock();
            try {
                if (bTree.isEmpty()) {
                    SOGVia sOGVia = null;
                    return sOGVia;
                }
                Rectangle2D.Double searchArea = new Rectangle2D.Double(x - halfWidth, y - halfHeight, halfWidth * 2.0, halfHeight * 2.0);
                Iterator sea = bTree.search(searchArea);
                while (sea.hasNext()) {
                    SOGVia sLoc = (SOGVia)sea.next();
                    double distX = Math.abs(x - sLoc.getBounds().getCenterX());
                    double distY = Math.abs(y - sLoc.getBounds().getCenterY());
                    if (DBMath.isGreaterThanOrEqualTo(distX, halfWidth) || DBMath.isGreaterThanOrEqualTo(distY, halfHeight) || sLoc.isSameBasicNet(netID) && DBMath.areEquals(sLoc.getBounds().getCenterX(), x) && DBMath.areEquals(sLoc.getBounds().getCenterY(), y)) continue;
                    SOGVia sOGVia = sLoc;
                    return sOGVia;
                }
                SOGVia sOGVia = null;
                return sOGVia;
            }
            finally {
                bTree.unlock();
            }
        }

        public void completeRoute(SearchVertex result2) {
            if (result2.wf != null) {
                ((SearchVertex)result2).wf.vertices = new ArrayList<SearchVertex>();
                SeaOfGatesEngine.this.getOptimizedList(result2, ((SearchVertex)result2).wf.vertices);
                assert (!((SearchVertex)result2).wf.vertices.isEmpty());
                if (this.spineTaps != null) {
                    for (PortInst pi : this.spineTaps) {
                        EPoint pt = pi.getCenter();
                        SearchVertex lastSV = ((SearchVertex)result2).wf.vertices.get(0);
                        double bestDist = Double.MAX_VALUE;
                        Point2D bestLoc = null;
                        int bestInsertPos = 0;
                        for (int i = 1; i < ((SearchVertex)result2).wf.vertices.size(); ++i) {
                            Point2D loc;
                            double dist;
                            SearchVertex sv = ((SearchVertex)result2).wf.vertices.get(i);
                            if (lastSV.getZ() == sv.getZ() && (dist = Math.abs((loc = GenMath.closestPointToSegment(new Point2D.Double(lastSV.getX(), lastSV.getY()), new Point2D.Double(sv.getX(), sv.getY()), (Point2D)pt)).getX() - pt.getX()) + Math.abs(loc.getY() - pt.getY())) < bestDist) {
                                bestDist = dist;
                                bestLoc = loc;
                                bestInsertPos = i;
                            }
                            lastSV = sv;
                        }
                        if (bestLoc == null) continue;
                        SearchVertex last2 = ((SearchVertex)result2).wf.vertices.get(bestInsertPos);
                        SearchVertex svTap = new SearchVertex(bestLoc.getX(), bestLoc.getY(), last2.getZ(), last2.getC(), 0, null, null, 0, null, 0);
                        ((SearchVertex)result2).wf.vertices.add(bestInsertPos, svTap);
                        this.spineTapMap.put(svTap, pi);
                    }
                }
                this.routedSuccess = true;
            } else if (result2 != svAbandoned) {
                if (result2 == svLimited) {
                    this.errorMessage = "Search for '" + this.routeName + "' too complex (took more than " + this.complexityLimit + " steps)";
                } else if (result2 == svExhausted) {
                    this.errorMessage = "Search for '" + this.routeName + "' examined all possibilities without success";
                } else {
                    assert (result2 == svAborted);
                    this.errorMessage = "Search for '" + this.routeName + "' aborted by user";
                }
                if (this.reroute) {
                    this.errorMessage = "(Retry) " + this.errorMessage;
                }
                boolean isAnError = true;
                if (this.alreadyRouted) {
                    this.errorMessage = this.errorMessage + ", but route already exists in the circuit";
                    SeaOfGatesEngine.this.warn(this.errorMessage);
                    isAnError = false;
                } else {
                    SeaOfGatesEngine.this.error(this.errorMessage);
                }
                if (result2 == svLimited || result2 == svExhausted) {
                    ArrayList<EPoint> lineList = new ArrayList<EPoint>();
                    lineList.add(EPoint.fromLambda(this.aX, this.aY));
                    lineList.add(EPoint.fromLambda(this.bX, this.bY));
                    this.loggedMessage = SeaOfGatesEngine.this.errorLogger.logMessageWithLines(this.errorMessage, null, lineList, SeaOfGatesEngine.this.cell, 0, isAnError);
                }
            }
            this.batch.completedRoute(this, result2.wf, result2);
        }

        static /* synthetic */ Rectangle2D[] access$002(NeededRoute x0, Rectangle2D[] x1) {
            x0.buckets = x1;
            return x1;
        }
    }

    class RouteBatch
    implements Comparable<RouteBatch> {
        Set<ArcInst> unroutedArcs;
        Set<NodeInst> unroutedNodes;
        List<NeededRoute> routesInBatch;
        boolean isPwrGnd;
        double length;
        String netName;
        private RouteResolution resolution;
        private final ReentrantLock completedRouteLock = new ReentrantLock();

        public RouteBatch(String nn) {
            this.unroutedArcs = new HashSet<ArcInst>();
            this.unroutedNodes = new HashSet<NodeInst>();
            this.routesInBatch = new ArrayList<NeededRoute>();
            CellId destCellId = SeaOfGatesEngine.this.cell.getId();
            this.resolution = new RouteResolution(destCellId);
            this.isPwrGnd = false;
            this.length = 0.0;
            this.netName = nn;
        }

        public void addRoute(NeededRoute nr) {
            this.routesInBatch.add(nr);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void completedRoute(NeededRoute nr, Wavefront winningWF, SearchVertex result2) {
            this.completedRouteLock.lock();
            nr.winningWF = winningWF;
            try {
                if (winningWF != null && winningWF.vertices != null) {
                    winningWF.createRoute();
                }
                for (ArcInst aiKill : this.unroutedArcs) {
                    this.resolution.killArc(aiKill);
                }
                for (NodeInst niKill : this.unroutedNodes) {
                    this.resolution.killNode(niKill);
                }
                this.unroutedArcs.clear();
                this.unroutedNodes.clear();
                SeaOfGatesEngine.this.handler.instantiate(this.resolution);
                if (nr.spineTaps != null) {
                    SeaOfGatesEngine.this.handler.flush(true);
                    int tapNumber = 1;
                    for (SearchVertex sv : nr.spineTapMap.keySet()) {
                        NeededRoute nrTap;
                        NodeInst ni;
                        PortInst aPi = (PortInst)nr.spineTapMap.get(sv);
                        ArcProto aArc = SeaOfGatesEngine.this.getMetalArcOnPort(aPi);
                        ImmutableNodeInst ini = (ImmutableNodeInst)nr.spineTapNIMap.get(aPi);
                        if (ini == null || (ni = SeaOfGatesEngine.this.cell.getNodeById(ini.nodeId)) == null) continue;
                        PortInst bPi = ni.getOnlyPortInst();
                        ArcProto bArc = SeaOfGatesEngine.this.getMetalArcOnPort(bPi);
                        if (aArc == null || bArc == null) continue;
                        String routeName = nr.routeName;
                        if (routeName.endsWith("(spine)")) {
                            routeName = routeName.substring(0, routeName.length() - 1) + " tap " + tapNumber + ")";
                        }
                        if ((nrTap = new NeededRoute(routeName, aPi, bPi, aArc, bArc, null, nr.minWidth)).invalidPort(true, aPi) || nrTap.invalidPort(false, bPi)) continue;
                        nrTap.setNetID(nr.netID);
                        nrTap.growNetwork();
                        SeaOfGatesEngine.this.tapRoutes.add(nrTap);
                        nrTap.setBatchInfo(nr.batch, tapNumber++);
                    }
                }
            }
            finally {
                this.completedRouteLock.unlock();
            }
        }

        @Override
        public int compareTo(RouteBatch other) {
            if (this.isPwrGnd != other.isPwrGnd) {
                if (this.isPwrGnd) {
                    return -1;
                }
                return 1;
            }
            if (this.length < other.length) {
                return -1;
            }
            if (this.length > other.length) {
                return 1;
            }
            return 0;
        }
    }

    public static interface Handler {
        public EditingPreferences getEditingPreferences();

        public boolean checkAbort();

        public void trace(String var1);

        public void debug(String var1);

        public void info(String var1);

        public void warn(String var1);

        public void error(String var1);

        public void termLogging(ErrorLogger var1);

        public void startProgressDialog(String var1);

        public void stopProgressDialog();

        public void setProgressNote(String var1);

        public void setProgressValue(long var1, long var3);

        public void instantiate(RouteResolution var1);

        public void flush(boolean var1);
    }
}

