/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.IdMapper;
import com.sun.electric.database.ImmutableElectricObject;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.IdReader;
import com.sun.electric.database.id.IdWriter;
import com.sun.electric.database.id.LibId;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.variable.Variable;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ImmutableLibrary
extends ImmutableElectricObject {
    public final LibId libId;
    public final URL libFile;
    public final Version version;
    public final Set<CellId> delibCells;

    private ImmutableLibrary(LibId libId, URL libFile, Version version, int flags, Variable[] vars, Set<CellId> delibCells) {
        super(vars, flags);
        this.libId = libId;
        this.libFile = libFile;
        this.version = version;
        this.delibCells = delibCells;
    }

    public static ImmutableLibrary newInstance(LibId libId, URL libFile, Version version) {
        if (libId == null) {
            throw new NullPointerException("libId");
        }
        return new ImmutableLibrary(libId, libFile, version, 0, Variable.NULL_ARRAY, Collections.<CellId>emptySet());
    }

    public ImmutableLibrary withLibFile(URL libFile) {
        if (this.libFile == libFile) {
            return this;
        }
        if (this.libFile != null && this.libFile.equals(libFile)) {
            return this;
        }
        return new ImmutableLibrary(this.libId, libFile, this.version, this.flags, this.getVars(), this.delibCells);
    }

    public ImmutableLibrary withVersion(Version version) {
        if (this.version == version) {
            return this;
        }
        if (this.version != null && version != null && this.version.equals(version)) {
            return this;
        }
        return new ImmutableLibrary(this.libId, this.libFile, version, this.flags, this.getVars(), this.delibCells);
    }

    public ImmutableLibrary withVariable(Variable var) {
        Variable[] vars = this.arrayWithVariable(var.withParam(false).withInherit(false));
        if (this.getVars() == vars) {
            return this;
        }
        return new ImmutableLibrary(this.libId, this.libFile, this.version, this.flags, vars, this.delibCells);
    }

    public ImmutableLibrary withoutVariable(Variable.Key key) {
        Variable[] vars = this.arrayWithoutVariable(key);
        if (this.getVars() == vars) {
            return this;
        }
        return new ImmutableLibrary(this.libId, this.libFile, this.version, this.flags, vars, this.delibCells);
    }

    ImmutableLibrary withRenamedIds(IdMapper idMapper) {
        Variable[] vars = this.arrayWithRenamedIds(idMapper);
        LibId libId = idMapper.get(this.libId);
        if (this.getVars() == vars && this.libId == libId) {
            return this;
        }
        return new ImmutableLibrary(libId, this.libFile, this.version, this.flags, vars, this.delibCells);
    }

    public ImmutableLibrary withFlags(int flags) {
        if (this.flags == flags) {
            return this;
        }
        return new ImmutableLibrary(this.libId, this.libFile, this.version, flags, this.getVars(), this.delibCells);
    }

    public ImmutableLibrary withDelibCells(Set<CellId> delibCells) {
        if (((Object)delibCells).equals(this.delibCells)) {
            return this;
        }
        delibCells = delibCells.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<CellId>(delibCells));
        return new ImmutableLibrary(this.libId, this.libFile, this.version, this.flags, this.getVars(), delibCells);
    }

    @Override
    void write(IdWriter writer) throws IOException {
        writer.writeLibId(this.libId);
        writer.writeString(this.libFile != null ? this.libFile.toString() : "");
        writer.writeString(this.version != null ? this.version.toString() : "");
        writer.writeInt(this.flags);
        writer.writeInt(this.delibCells.size());
        for (CellId delibCell : this.delibCells) {
            writer.writeNodeProtoId(delibCell);
        }
        super.write(writer);
    }

    static ImmutableLibrary read(IdReader reader) throws IOException {
        boolean hasVars;
        LibId libId = reader.readLibId();
        String libFileString = reader.readString();
        URL libFile = libFileString.length() > 0 ? new URL(libFileString) : null;
        String versionString = reader.readString();
        Version version = versionString.length() > 0 ? Version.parseVersion(versionString) : null;
        int flags = reader.readInt();
        Set<CellId> delibCells = Collections.emptySet();
        int numDelibCells = reader.readInt();
        if (numDelibCells > 0) {
            HashSet<CellId> rawCells = new HashSet<CellId>();
            for (int i = 0; i < numDelibCells; ++i) {
                rawCells.add((CellId)reader.readNodeProtoId());
            }
            delibCells = Collections.unmodifiableSet(rawCells);
        }
        Variable[] vars = (hasVars = reader.readBoolean()) ? ImmutableLibrary.readVars(reader) : Variable.NULL_ARRAY;
        return new ImmutableLibrary(libId, libFile, version, flags, vars, delibCells);
    }

    @Override
    public int hashCodeExceptVariables() {
        return this.libId.hashCode();
    }

    @Override
    public boolean equalsExceptVariables(ImmutableElectricObject o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImmutableLibrary)) {
            return false;
        }
        ImmutableLibrary that = (ImmutableLibrary)o;
        return this.libId == that.libId && this.libFile == that.libFile && this.version == that.version && this.flags == that.flags && ((Object)this.delibCells).equals(that.delibCells);
    }

    public String toString() {
        return this.libId.toString();
    }

    public void check() {
        super.check(false);
        assert (this.libId != null);
        if (this.delibCells.isEmpty()) assert (this.delibCells == Collections.emptySet());
    }
}

