/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.tool.io.output.CellModelPrefs;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class CellModelTab
extends PreferencePanel {
    private CellModelPrefs modelPrefs;
    private static String lastLib = "";
    private static String lastCell = "";
    private static final String recentlySetCellsName = "RecentlySetCells";
    private Map<Cell, ModelPref> initialBehaveFiles;
    private JList cellList;
    private DefaultListModel cellListModel;
    private JButton browse;
    private JScrollPane cellsList;
    private JPanel chooserPanel;
    private JRadioButton deriveModel;
    private JTextField fileNameField;
    private JLabel jLabel54;
    private JComboBox libraryChoice;
    private JRadioButton netlistFromLayout;
    private JCheckBox showRecentCells;
    private JRadioButton useModelFile;
    private ButtonGroup verilogModel;

    public CellModelTab(Frame parent, boolean modal, CellModelPrefs modelPrefs) {
        super(parent, modal);
        this.modelPrefs = modelPrefs;
        this.initComponents();
        if (!modelPrefs.isCanLayoutFromNetlist()) {
            this.netlistFromLayout.setEnabled(false);
        }
    }

    public JPanel getPanel() {
        return this.chooserPanel;
    }

    public String getName() {
        return this.modelPrefs.getType() + " Model Files";
    }

    public void init() {
        this.initialBehaveFiles = new HashMap<Cell, ModelPref>();
        Iterator<Library> lIt = Library.getLibraries();
        while (lIt.hasNext()) {
            Library lib = lIt.next();
            if (lib.isHidden()) continue;
            Iterator<Cell> cIt = lib.getCells();
            while (cIt.hasNext()) {
                Cell cell = cIt.next();
                ModelPref pref = new ModelPref();
                pref.fileName = this.modelPrefs.getModelFile(cell);
                if (this.modelPrefs.isUseModelFromFile(cell)) {
                    pref.choice = Choice.USEMODELFILE;
                }
                if (this.modelPrefs.isUseLayoutView(cell)) {
                    pref.choice = Choice.USELAYOUTNETLIST;
                }
                this.initialBehaveFiles.put(cell, pref);
            }
        }
        for (Library lib : Library.getVisibleLibraries()) {
            this.libraryChoice.addItem(lib.getName());
        }
        this.libraryChoice.addItem(recentlySetCellsName);
        boolean useLastLib = false;
        if (!lastLib.equals("")) {
            for (int i = 0; i < this.libraryChoice.getItemCount(); ++i) {
                String str = (String)this.libraryChoice.getItemAt(i);
                if (!str.equals(lastLib)) continue;
                useLastLib = true;
                this.libraryChoice.setSelectedIndex(i);
            }
        }
        if (!useLastLib) {
            this.libraryChoice.setSelectedItem(this.curLib.getName());
        }
        this.libraryChoice.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CellModelTab.this.verilogLoadCellList();
            }
        });
        this.cellListModel = new DefaultListModel();
        this.cellList = new JList(this.cellListModel);
        this.cellList.setSelectionMode(0);
        this.cellsList.setViewportView(this.cellList);
        this.cellList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                CellModelTab.this.verilogCellListClick();
            }
        });
        this.browse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CellModelTab.this.verModelFileBrowseActionPerformed();
            }
        });
        this.deriveModel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CellModelTab.this.verilogModelClick();
            }
        });
        this.useModelFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CellModelTab.this.verilogModelClick();
            }
        });
        this.netlistFromLayout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CellModelTab.this.verilogModelClick();
            }
        });
        this.fileNameField.getDocument().addDocumentListener(new VerilogDocumentListener(this));
        this.showRecentCells.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CellModelTab.this.showRecentCellsOnlyClick();
            }
        });
        this.verilogLoadCellList();
    }

    private void verModelFileBrowseActionPerformed() {
        String fileName = OpenFile.chooseInputFile(this.modelPrefs.getFileType(), null);
        if (fileName == null) {
            return;
        }
        this.useModelFile.setSelected(true);
        this.fileNameField.setEditable(true);
        this.fileNameField.setText(fileName);
    }

    private void verilogLoadCellList() {
        String libName = (String)this.libraryChoice.getSelectedItem();
        boolean notEmpty = false;
        if (libName.equals(recentlySetCellsName)) {
            this.cellListModel.clear();
            for (Map.Entry<Cell, ModelPref> entry : this.initialBehaveFiles.entrySet()) {
                ModelPref pref = entry.getValue();
                if (pref.fileName.length() <= 0 && pref.choice != Choice.USELAYOUTNETLIST && pref.choice != Choice.USEMODELFILE) continue;
                Cell cell = entry.getKey();
                this.cellListModel.addElement(cell.describe(false));
                notEmpty = true;
            }
        } else {
            Library lib = Library.findLibrary(libName);
            if (lib == null) {
                return;
            }
            this.cellListModel.clear();
            Iterator<Cell> it = lib.getCells();
            while (it.hasNext()) {
                Cell cell = it.next();
                this.cellListModel.addElement(cell.noLibDescribe());
                notEmpty = true;
            }
        }
        if (notEmpty) {
            this.cellList.setSelectedIndex(0);
            for (int i = 0; i < this.cellList.getModel().getSize(); ++i) {
                String str = (String)this.cellList.getModel().getElementAt(i);
                if (!str.equals(lastCell)) continue;
                this.cellList.setSelectedIndex(i);
            }
            this.verilogCellListClick();
        }
    }

    private void verilogCellListClick() {
        Cell cell = this.getSelectedCell();
        if (cell == null) {
            return;
        }
        ModelPref pref = this.initialBehaveFiles.get(cell);
        if (pref == null) {
            this.deriveModel.setSelected(true);
            this.fileNameField.setEditable(false);
            this.fileNameField.setText("");
            return;
        }
        String behaveFile = pref.fileName;
        this.deriveModel.setSelected(pref.choice == Choice.NONE);
        this.netlistFromLayout.setSelected(pref.choice == Choice.USELAYOUTNETLIST);
        this.useModelFile.setSelected(pref.choice == Choice.USEMODELFILE);
        if (pref.choice == Choice.USEMODELFILE) {
            this.fileNameField.setEditable(true);
        } else {
            this.fileNameField.setEditable(false);
        }
        this.fileNameField.setText(behaveFile);
        lastLib = (String)this.libraryChoice.getSelectedItem();
        lastCell = (String)this.cellList.getSelectedValue();
    }

    private void verilogModelClick() {
        if (this.deriveModel.isSelected() || this.netlistFromLayout.isSelected()) {
            this.fileNameField.setEditable(false);
        } else {
            this.fileNameField.setEditable(true);
        }
        Cell cell = this.getSelectedCell();
        if (cell == null) {
            return;
        }
        ModelPref pref = this.initialBehaveFiles.get(cell);
        if (this.deriveModel.isSelected()) {
            pref.choice = Choice.NONE;
        }
        if (this.netlistFromLayout.isSelected()) {
            pref.choice = Choice.USELAYOUTNETLIST;
        }
        if (this.useModelFile.isSelected()) {
            pref.choice = Choice.USEMODELFILE;
        }
    }

    private void showRecentCellsOnlyClick() {
        if (this.showRecentCells.isSelected()) {
            this.libraryChoice.setSelectedItem(recentlySetCellsName);
        } else {
            this.libraryChoice.setSelectedItem(this.curLib.getName());
        }
        this.verilogLoadCellList();
    }

    private Cell getSelectedCell() {
        String libName = (String)this.libraryChoice.getSelectedItem();
        String cellName = (String)this.cellList.getSelectedValue();
        Cell cell = null;
        if (libName.equals(recentlySetCellsName)) {
            cell = (Cell)Cell.findNodeProto(cellName);
            Library lib = cell.getLibrary();
        } else {
            Library lib = Library.findLibrary(libName);
            cell = lib.findNodeProto(cellName);
        }
        return cell;
    }

    public void term() {
        Iterator<Library> lIt = Library.getLibraries();
        while (lIt.hasNext()) {
            Library lib = lIt.next();
            if (lib.isHidden()) continue;
            Iterator<Cell> cIt = lib.getCells();
            while (cIt.hasNext()) {
                boolean useModelFile;
                Cell cell = cIt.next();
                ModelPref pref = this.initialBehaveFiles.get(cell);
                if (pref == null) continue;
                boolean useLayoutView = pref.choice == Choice.USELAYOUTNETLIST;
                boolean bl = useModelFile = pref.choice == Choice.USEMODELFILE;
                if (pref.fileName.equals(this.modelPrefs.getModelFile(cell)) && useLayoutView == this.modelPrefs.isUseLayoutView(cell) && useModelFile == this.modelPrefs.isUseModelFromFile(cell)) continue;
                String fileName = pref.fileName.trim();
                this.modelPrefs.setModelFile(cell, fileName, useModelFile, useLayoutView);
            }
        }
    }

    public void reset() {
        Iterator<Library> lIt = Library.getLibraries();
        while (lIt.hasNext()) {
            Library lib = lIt.next();
            if (lib.isHidden()) continue;
            Iterator<Cell> cIt = lib.getCells();
            while (cIt.hasNext()) {
                Cell cell = cIt.next();
                this.modelPrefs.factoryResetModelFile(cell);
            }
        }
    }

    private void initComponents() {
        this.verilogModel = new ButtonGroup();
        this.chooserPanel = new JPanel();
        this.jLabel54 = new JLabel();
        this.libraryChoice = new JComboBox();
        this.cellsList = new JScrollPane();
        this.deriveModel = new JRadioButton();
        this.useModelFile = new JRadioButton();
        this.browse = new JButton();
        this.fileNameField = new JTextField();
        this.showRecentCells = new JCheckBox();
        this.netlistFromLayout = new JRadioButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Tool Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                CellModelTab.this.closeDialog(evt);
            }
        });
        this.chooserPanel.setLayout(new GridBagLayout());
        this.jLabel54.setText("Library:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.chooserPanel.add((Component)this.jLabel54, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.chooserPanel.add((Component)this.libraryChoice, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.chooserPanel.add((Component)this.cellsList, gridBagConstraints);
        this.verilogModel.add(this.deriveModel);
        this.deriveModel.setText("Derive Model from Circuitry");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(20, 4, 4, 4);
        this.chooserPanel.add((Component)this.deriveModel, gridBagConstraints);
        this.verilogModel.add(this.useModelFile);
        this.useModelFile.setText("Use Model from File:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.chooserPanel.add((Component)this.useModelFile, gridBagConstraints);
        this.browse.setText("Browse");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.chooserPanel.add((Component)this.browse, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.chooserPanel.add((Component)this.fileNameField, gridBagConstraints);
        this.showRecentCells.setText("Show Recently Used Cells Only");
        this.showRecentCells.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.showRecentCells.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 7, 4, 4);
        this.chooserPanel.add((Component)this.showRecentCells, gridBagConstraints);
        this.verilogModel.add(this.netlistFromLayout);
        this.netlistFromLayout.setText("Netlist from Layout");
        this.netlistFromLayout.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.netlistFromLayout.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 8, 4, 4);
        this.chooserPanel.add((Component)this.netlistFromLayout, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.chooserPanel, gridBagConstraints);
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private static class VerilogDocumentListener
    implements DocumentListener {
        CellModelTab dialog;

        VerilogDocumentListener(CellModelTab dialog) {
            this.dialog = dialog;
        }

        private void change(DocumentEvent e) {
            String text;
            Cell cell = this.dialog.getSelectedCell();
            if (cell == null) {
                return;
            }
            ModelPref pref = (ModelPref)this.dialog.initialBehaveFiles.get(cell);
            if (pref == null) {
                return;
            }
            Document doc = e.getDocument();
            int len = doc.getLength();
            try {
                text = doc.getText(0, len);
            }
            catch (BadLocationException ex) {
                return;
            }
            pref.fileName = text;
        }

        public void changedUpdate(DocumentEvent e) {
            this.change(e);
        }

        public void insertUpdate(DocumentEvent e) {
            this.change(e);
        }

        public void removeUpdate(DocumentEvent e) {
            this.change(e);
        }
    }

    private static class ModelPref {
        private String fileName = "";
        private Choice choice = Choice.NONE;

        private ModelPref() {
        }

        public boolean equals(ModelPref other) {
            return other.fileName.equals(this.fileName) && other.choice == this.choice;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Choice {
        NONE,
        USEMODELFILE,
        USELAYOUTNETLIST;

    }
}

