/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.ExportChanges;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.menus.MenuCommands;
import com.sun.electric.tool.user.ui.ClickZoomWireListener;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;

public class Clipboard {
    private static Clipboard theClipboard = new Clipboard();
    private static Library clipLib = null;
    private static Cell clipCell;
    private static NodeInst lastDup;
    private static double lastDupX;
    private static double lastDupY;
    static /* synthetic */ Class class$com$sun$electric$database$topology$NodeInst;
    static /* synthetic */ Class class$com$sun$electric$database$topology$ArcInst;

    private Clipboard() {
    }

    private static void init() {
        if (clipLib == null) {
            clipLib = Library.newInstance("Clipboard!!", null);
            clipLib.setHidden();
        }
        if (clipCell == null) {
            clipCell = Cell.newInstance(clipLib, "Clipboard!!");
        }
    }

    public static void editClipboard() {
        EditWindow wnd = EditWindow.getCurrent();
        wnd.setCell(clipCell, VarContext.globalContext);
    }

    public static void clear() {
        NodeInst ni;
        Export pp;
        ArcInst ai;
        Clipboard.init();
        ArrayList<ArcInst> arcsToDelete = new ArrayList<ArcInst>();
        Iterator it = clipCell.getArcs();
        while (it.hasNext()) {
            ai = (ArcInst)it.next();
            arcsToDelete.add(ai);
        }
        it = arcsToDelete.iterator();
        while (it.hasNext()) {
            ai = (ArcInst)it.next();
            ai.kill();
        }
        ArrayList<Export> exportsToDelete = new ArrayList<Export>();
        Iterator it2 = clipCell.getPorts();
        while (it2.hasNext()) {
            pp = (Export)it2.next();
            exportsToDelete.add(pp);
        }
        it2 = exportsToDelete.iterator();
        while (it2.hasNext()) {
            pp = (Export)it2.next();
            pp.kill();
        }
        ArrayList<NodeInst> nodesToDelete = new ArrayList<NodeInst>();
        Iterator it3 = clipCell.getNodes();
        while (it3.hasNext()) {
            ni = (NodeInst)it3.next();
            nodesToDelete.add(ni);
        }
        it3 = nodesToDelete.iterator();
        while (it3.hasNext()) {
            ni = (NodeInst)it3.next();
            ni.kill();
        }
        ArrayList varsToDelete = new ArrayList();
        Iterator it4 = clipCell.getVariables();
        while (it4.hasNext()) {
            Variable var = (Variable)it4.next();
            clipCell.delVar(var.getKey());
        }
    }

    public static void copy() {
        Clipboard.copySelectedText();
        CopyObjects job = new CopyObjects(MenuCommands.getHighlighted());
    }

    private static void copySelectedText() {
        Highlight h;
        List highlights = MenuCommands.getHighlighted();
        if (highlights.size() == 1 && (h = (Highlight)highlights.get(0)).getType() == Highlight.Type.TEXT) {
            String selected = null;
            Variable var = h.getVar();
            ElectricObject eObj = h.getElectricObject();
            if (var != null) {
                selected = var.describe(-1);
            } else if (h.getName() != null) {
                selected = h.getName().toString();
            } else if (eObj instanceof Export) {
                selected = ((Export)eObj).getName();
            } else if (eObj instanceof NodeInst) {
                selected = ((NodeInst)eObj).getProto().describe(false);
            }
            if (selected != null) {
                java.awt.datatransfer.Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection transferable = new StringSelection(selected);
                cb.setContents(transferable, null);
            }
        }
    }

    public static void cut() {
        Clipboard.copySelectedText();
        CutObjects job = new CutObjects(MenuCommands.getHighlighted());
    }

    public static void duplicate() {
        DuplicateObjects job = new DuplicateObjects(MenuCommands.getHighlighted());
    }

    public static void nodeMoved(NodeInst ni, double lastX, double lastY) {
        if (ni != lastDup) {
            return;
        }
        lastDupX += ni.getAnchorCenterX() - lastX;
        lastDupY += ni.getAnchorCenterY() - lastY;
    }

    public static void paste(boolean duplicate) {
        Clipboard.init();
        int nTotal = clipCell.getNumNodes();
        int aTotal = clipCell.getNumArcs();
        int vTotal = clipCell.getNumVariables();
        int total = nTotal + aTotal + vTotal;
        if (total == 0) {
            System.out.println("Nothing in the clipboard to paste");
            return;
        }
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        List geoms = highlighter.getHighlightedEObjs(true, true);
        if (geoms.size() > 0) {
            if (nTotal == 2 && aTotal == 1) {
                ArcInst ai = (ArcInst)clipCell.getArcs().next();
                NodeInst niHead = ai.getHeadPortInst().getNodeInst();
                NodeInst niTail = ai.getTailPortInst().getNodeInst();
                Iterator nIt = clipCell.getNodes();
                NodeInst ni1 = (NodeInst)nIt.next();
                NodeInst ni2 = (NodeInst)nIt.next();
                if (ni1 == niHead && ni2 == niTail || ni1 == niTail && ni2 == niHead) {
                    nTotal = 0;
                }
                total = nTotal + aTotal;
            }
            if (total > 1) {
                System.out.println("Can only paste a single object on top of selected objects");
                return;
            }
            Iterator it = geoms.iterator();
            while (it.hasNext()) {
                Job job;
                Geometric geom = (Geometric)it.next();
                if (geom instanceof NodeInst && nTotal == 1) {
                    NodeInst ni = (NodeInst)geom;
                    job = new PasteNodeToNode(ni, (NodeInst)clipCell.getNodes().next(), highlighter);
                    continue;
                }
                if (!(geom instanceof ArcInst) || aTotal != 1) continue;
                ArcInst ai = (ArcInst)geom;
                job = new PasteArcToArc(ai, (ArcInst)clipCell.getArcs().next(), highlighter);
            }
            return;
        }
        ArrayList<Object> pasteList = new ArrayList<Object>();
        Iterator it = clipCell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            pasteList.add(ni);
        }
        it = clipCell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            pasteList.add(ai);
        }
        it = clipCell.getVariables();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            pasteList.add(var);
        }
        if (pasteList.size() == 0) {
            return;
        }
        if (!duplicate || User.isMoveAfterDuplicate()) {
            EventListener currentListener = WindowFrame.getListener();
            WindowFrame.setListener(new PasteListener(wnd, pasteList, currentListener));
        } else {
            Point2D.Double refPastePoint = new Point2D.Double(lastDupX, lastDupY);
            PasteObjects job = new PasteObjects(pasteList, ((Point2D)refPastePoint).getX(), ((Point2D)refPastePoint).getY());
        }
    }

    public String toString() {
        return "Clipboard";
    }

    public static void copyListToCell(EditWindow wnd, List list, Cell fromCell, Cell toCell, Point2D delta, boolean copyExports, boolean uniqueArcs) {
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Geometric geom;
            Object obj = it.next();
            if (obj instanceof Highlight) {
                obj = ((Highlight)obj).getGeometric();
            }
            if (!(obj instanceof Geometric) || fromCell == (geom = (Geometric)obj).getParent()) continue;
            System.out.println("All duplicated objects must be in the same cell");
            return;
        }
        ArrayList<Geometric> theNodes = new ArrayList<Geometric>();
        ArrayList<ArcInst> theArcs = new ArrayList<ArcInst>();
        ArrayList<Variable> theTextVariables = new ArrayList<Variable>();
        Iterator it2 = list.iterator();
        while (it2.hasNext()) {
            Variable var;
            Object obj = it2.next();
            Highlight h = null;
            if (obj instanceof Highlight) {
                h = (Highlight)obj;
                obj = h.getGeometric();
            }
            if (obj instanceof Geometric) {
                Geometric geom = (Geometric)obj;
                if (geom instanceof NodeInst && !theNodes.contains(geom)) {
                    theNodes.add(geom);
                }
                if (geom instanceof ArcInst) {
                    ArcInst ai = (ArcInst)geom;
                    theArcs.add(ai);
                    NodeInst head = ai.getHeadPortInst().getNodeInst();
                    NodeInst tail = ai.getTailPortInst().getNodeInst();
                    if (!theNodes.contains(head)) {
                        theNodes.add(head);
                    }
                    if (!theNodes.contains(tail)) {
                        theNodes.add(tail);
                    }
                }
            }
            if (h == null || h.getType() != Highlight.Type.TEXT || (var = h.getVar()) == null || !(h.getElectricObject() instanceof Cell)) continue;
            theTextVariables.add(var);
        }
        if (theNodes.size() == 0 && theTextVariables.size() == 0) {
            return;
        }
        it2 = theNodes.iterator();
        while (it2.hasNext()) {
            Cell niCell;
            NodeInst ni = (NodeInst)it2.next();
            if (ni.getProto() instanceof PrimitiveNode || !Cell.isInstantiationRecursive(niCell = (Cell)ni.getProto(), toCell)) continue;
            System.out.println("Cannot: that would be recursive (" + toCell + " is beneath " + ni.getProto() + ")");
            return;
        }
        EditWindow.gridAlign(delta);
        double dX = delta.getX();
        double dY = delta.getY();
        Collections.sort(theNodes);
        HashMap<NodeInst, NodeInst> newNodes = new HashMap<NodeInst, NodeInst>();
        ArrayList<PortInst> portInstsToExport = new ArrayList<PortInst>();
        HashMap<PortInst, Export> originalExports = new HashMap<PortInst, Export>();
        Iterator it3 = theNodes.iterator();
        while (it3.hasNext()) {
            NodeInst newNi;
            NodeInst ni = (NodeInst)it3.next();
            if (ni.getProto() == Generic.tech.cellCenterNode && toCell.alreadyCellCenter()) continue;
            double width = ni.getXSize();
            double height = ni.getYSize();
            String name = null;
            if (ni.isUsernamed()) {
                name = ElectricObject.uniqueObjectName(ni.getName(), toCell, class$com$sun$electric$database$topology$NodeInst == null ? Clipboard.class$("com.sun.electric.database.topology.NodeInst") : class$com$sun$electric$database$topology$NodeInst);
            }
            if ((newNi = NodeInst.newInstance(ni.getProto(), new Point2D.Double(ni.getAnchorCenterX() + dX, ni.getAnchorCenterY() + dY), width, height, toCell, ni.getOrient(), name, ni.getTechSpecific())) == null) {
                System.out.println("Cannot create node");
                return;
            }
            newNi.copyStateBits(ni);
            newNi.copyTextDescriptorFrom(ni, NodeInst.NODE_PROTO_TD);
            newNi.copyTextDescriptorFrom(ni, NodeInst.NODE_NAME_TD);
            newNi.copyVarsFrom(ni);
            newNodes.put(ni, newNi);
            lastDup = newNi;
            if (!copyExports) continue;
            Iterator eit = ni.getExports();
            while (eit.hasNext()) {
                Export pp = (Export)eit.next();
                PortInst pi = ExportChanges.getNewPortFromReferenceExport(newNi, pp);
                portInstsToExport.add(pi);
                originalExports.put(pi, pp);
            }
        }
        if (copyExports) {
            ExportChanges.reExportPorts(portInstsToExport, true, true, false, originalExports);
        }
        HashMap<ArcInst, ArcInst> newArcs = new HashMap<ArcInst, ArcInst>();
        if (theArcs.size() > 0) {
            Collections.sort(theArcs);
            HashMap<String, String> newArcNames = new HashMap<String, String>();
            Iterator it4 = theArcs.iterator();
            while (it4.hasNext()) {
                ArcInst newAr;
                ArcInst ai = (ArcInst)it4.next();
                PortInst oldHeadPi = ai.getHeadPortInst();
                NodeInst headNi = (NodeInst)newNodes.get(oldHeadPi.getNodeInst());
                PortInst headPi = headNi.findPortInstFromProto(oldHeadPi.getPortProto());
                PortInst oldTailPi = ai.getTailPortInst();
                NodeInst tailNi = (NodeInst)newNodes.get(oldTailPi.getNodeInst());
                PortInst tailPi = tailNi.findPortInstFromProto(oldTailPi.getPortProto());
                String name = null;
                if (ai.isUsernamed()) {
                    name = ai.getName();
                    if (uniqueArcs) {
                        String newName = (String)newArcNames.get(name);
                        if (newName == null) {
                            newName = ElectricObject.uniqueObjectName(name, toCell, class$com$sun$electric$database$topology$ArcInst == null ? Clipboard.class$("com.sun.electric.database.topology.ArcInst") : class$com$sun$electric$database$topology$ArcInst);
                            newArcNames.put(name, newName);
                        }
                        name = newName;
                    }
                }
                if ((newAr = ArcInst.newInstance(ai.getProto(), ai.getWidth(), headPi, tailPi, new Point2D.Double(ai.getHeadLocation().getX() + dX, ai.getHeadLocation().getY() + dY), new Point2D.Double(ai.getTailLocation().getX() + dX, ai.getTailLocation().getY() + dY), name, ai.getAngle())) == null) {
                    System.out.println("Cannot create arc");
                    return;
                }
                newAr.copyPropertiesFrom(ai);
                newArcs.put(ai, newAr);
            }
        }
        Iterator it5 = theTextVariables.iterator();
        while (it5.hasNext()) {
            Variable var = (Variable)it5.next();
            Variable cellVar = toCell.newVar(var.getKey(), var.getObject(), var.getTextDescriptor());
        }
        if (wnd != null) {
            Highlighter highlighter = wnd.getHighlighter();
            highlighter.clear();
            Iterator it6 = theNodes.iterator();
            while (it6.hasNext()) {
                NodeInst ni = (NodeInst)it6.next();
                if ((ni = (NodeInst)newNodes.get(ni)) == null) continue;
                if (ni.isInvisiblePinWithText()) {
                    Poly[] polys = ni.getAllText(false, wnd);
                    if (polys == null) continue;
                    for (int i = 0; i < polys.length; ++i) {
                        Poly poly = polys[i];
                        if (poly == null) continue;
                        Highlight h = highlighter.addText(ni, toCell, poly.getVariable(), poly.getName());
                    }
                    continue;
                }
                Highlight h = highlighter.addElectricObject(ni, toCell);
            }
            it6 = list.iterator();
            while (it6.hasNext()) {
                Geometric geom;
                Object obj = it6.next();
                if (!(obj instanceof Geometric) || (geom = (Geometric)obj) instanceof NodeInst) continue;
                ArcInst ai = (ArcInst)geom;
                ai = (ArcInst)newArcs.get(ai);
                Highlight h = highlighter.addElectricObject(ai, toCell);
            }
            highlighter.finished();
        }
    }

    private static Rectangle2D getPasteBounds(List pasteList, EditWindow wnd) {
        Point2D llcorner = null;
        Point2D urcorner = null;
        Iterator it = pasteList.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof Variable) {
                Variable var = (Variable)obj;
                Poly poly = clipCell.computeTextPoly(wnd, var, null);
                Rectangle2D bounds = poly.getBounds2D();
                if (llcorner == null) {
                    llcorner = new Point2D.Double(bounds.getMinX(), bounds.getMinY());
                    urcorner = new Point2D.Double(bounds.getMaxX(), bounds.getMaxY());
                    continue;
                }
                if (bounds.getMinX() < llcorner.getX()) {
                    llcorner.setLocation(bounds.getMinX(), llcorner.getY());
                }
                if (bounds.getMinY() < llcorner.getY()) {
                    llcorner.setLocation(llcorner.getX(), bounds.getMinY());
                }
                if (bounds.getMaxX() > urcorner.getX()) {
                    urcorner.setLocation(bounds.getMaxX(), urcorner.getY());
                }
                if (!(bounds.getMaxY() > urcorner.getY())) continue;
                urcorner.setLocation(urcorner.getX(), bounds.getMaxY());
                continue;
            }
            Geometric geom = (Geometric)obj;
            if (geom instanceof NodeInst) {
                NodeInst ni = (NodeInst)geom;
                EPoint pt = ni.getAnchorCenter();
                if (llcorner == null) {
                    llcorner = new Point2D.Double(((Point2D)pt).getX(), ((Point2D)pt).getY());
                    urcorner = new Point2D.Double(((Point2D)pt).getX(), ((Point2D)pt).getY());
                    continue;
                }
                if (((Point2D)pt).getX() < llcorner.getX()) {
                    llcorner.setLocation(((Point2D)pt).getX(), llcorner.getY());
                }
                if (((Point2D)pt).getY() < llcorner.getY()) {
                    llcorner.setLocation(llcorner.getX(), ((Point2D)pt).getY());
                }
                if (((Point2D)pt).getX() > urcorner.getX()) {
                    urcorner.setLocation(((Point2D)pt).getX(), urcorner.getY());
                }
                if (((Point2D)pt).getY() > urcorner.getY()) {
                    urcorner.setLocation(urcorner.getX(), ((Point2D)pt).getY());
                }
            }
            if (!(geom instanceof ArcInst)) continue;
            ArcInst ai = (ArcInst)geom;
            double wid = ai.getWidth() - ai.getProto().getWidthOffset();
            Poly poly = ai.makePoly(wid, Poly.Type.FILLED);
            Rectangle2D bounds = poly.getBounds2D();
            if (llcorner == null) {
                llcorner = new Point2D.Double(bounds.getMinX(), bounds.getMinY());
                urcorner = new Point2D.Double(bounds.getMaxX(), bounds.getMaxY());
                continue;
            }
            if (bounds.getMinX() < llcorner.getX()) {
                llcorner.setLocation(bounds.getMinX(), llcorner.getY());
            }
            if (bounds.getMinY() < llcorner.getY()) {
                llcorner.setLocation(llcorner.getX(), bounds.getMinY());
            }
            if (bounds.getMaxX() > urcorner.getX()) {
                urcorner.setLocation(bounds.getMaxX(), urcorner.getY());
            }
            if (!(bounds.getMaxY() > urcorner.getY())) continue;
            urcorner.setLocation(urcorner.getX(), bounds.getMaxY());
        }
        double width = urcorner.getX() - llcorner.getX();
        double height = urcorner.getY() - llcorner.getY();
        Rectangle2D.Double bounds = new Rectangle2D.Double(llcorner.getX(), llcorner.getY(), width, height);
        return bounds;
    }

    private static NodeInst pasteNodeToNode(NodeInst destNode, NodeInst srcNode) {
        if ((destNode = CircuitChanges.replaceNodeInst(destNode, srcNode.getProto(), true, false)) == null) {
            return null;
        }
        destNode.clearExpanded();
        if (srcNode.isExpanded()) {
            destNode.setExpanded();
        }
        if (destNode.getProto() instanceof PrimitiveNode && srcNode.getProto() instanceof PrimitiveNode && srcNode.getProto().getTechnology() == destNode.getProto().getTechnology()) {
            Technology tech = srcNode.getProto().getTechnology();
            tech.setPrimitiveFunction(destNode, srcNode.getFunction());
        }
        if (destNode.getProto() instanceof PrimitiveNode) {
            double dX = srcNode.getXSize() - destNode.getXSize();
            double dY = srcNode.getYSize() - destNode.getYSize();
            if (dX != 0.0 || dY != 0.0) {
                destNode.resize(dX, dY);
            }
        }
        boolean checkAgain = true;
        block0: while (checkAgain) {
            checkAgain = false;
            Iterator it = destNode.getVariables();
            while (it.hasNext()) {
                Variable destVar = (Variable)it.next();
                Variable.Key key = destVar.getKey();
                Variable srcVar = srcNode.getVar(key.getName());
                if (srcVar != null) continue;
                destNode.delVar(key);
                checkAgain = true;
                continue block0;
            }
        }
        destNode.copyVarsFrom(srcNode);
        destNode.copyStateBits(srcNode);
        destNode.clearExpanded();
        if (srcNode.isExpanded()) {
            destNode.setExpanded();
        }
        destNode.clearLocked();
        return destNode;
    }

    private static ArcInst pasteArcToArc(ArcInst destArc, ArcInst srcArc) {
        Variable.Key key;
        Iterator it;
        if (destArc.getProto() != srcArc.getProto() && (destArc = destArc.replace(srcArc.getProto())) == null) {
            return null;
        }
        double dw = srcArc.getWidth() - destArc.getWidth();
        if (dw != 0.0) {
            destArc.modify(dw, 0.0, 0.0, 0.0, 0.0);
        }
        boolean checkAgain = true;
        block0: while (checkAgain) {
            checkAgain = false;
            it = destArc.getVariables();
            while (it.hasNext()) {
                Variable destVar = (Variable)it.next();
                key = destVar.getKey();
                Variable srcVar = srcArc.getVar(key.getName());
                if (srcVar != null) continue;
                destArc.delVar(key);
                checkAgain = true;
                continue block0;
            }
        }
        it = srcArc.getVariables();
        while (it.hasNext()) {
            Variable srcVar = (Variable)it.next();
            key = srcVar.getKey();
            Variable destVar = destArc.newVar(key, srcVar.getObject(), srcVar.getTextDescriptor());
        }
        destArc.copyPropertiesFrom(srcArc);
        return destArc;
    }

    static {
        lastDup = null;
        lastDupX = 10.0;
        lastDupY = 10.0;
    }

    private static class PasteListener
    implements MouseMotionListener,
    MouseListener,
    MouseWheelListener,
    KeyListener {
        private EditWindow wnd;
        private List pasteList;
        private EventListener currentListener;
        private Rectangle2D pasteBounds;
        private double translateX;
        private double translateY;
        private Point2D lastMouseDB;
        private JPopupMenu popup;

        private PasteListener(EditWindow wnd, List pasteList, EventListener currentListener) {
            this.wnd = wnd;
            this.pasteList = pasteList;
            this.currentListener = currentListener;
            this.pasteBounds = Clipboard.getPasteBounds(pasteList, wnd);
            this.translateY = 0.0;
            this.translateX = 0.0;
            this.initPopup();
            Point2D mouse = ClickZoomWireListener.theOne.getLastMouse();
            Point2D mouseDB = wnd.screenToDatabase((int)mouse.getX(), (int)mouse.getY());
            Point2D delta = this.getDelta(mouseDB, false);
            wnd.getHighlighter().pushHighlight();
            this.showList(delta);
        }

        private Point2D getDelta(Point2D mouseDB, boolean orthogonal) {
            if (mouseDB == null) {
                return null;
            }
            EditWindow.gridAlign(mouseDB);
            Point2D.Double refPastePoint = new Point2D.Double(this.pasteBounds.getCenterX() + this.translateX, this.pasteBounds.getCenterY() + this.translateY);
            double deltaX = mouseDB.getX() - ((Point2D)refPastePoint).getX();
            double deltaY = mouseDB.getY() - ((Point2D)refPastePoint).getY();
            if (orthogonal) {
                if (Math.abs(deltaX) > Math.abs(deltaY)) {
                    deltaY = 0.0;
                } else {
                    deltaX = 0.0;
                }
            }
            ((Point2D)refPastePoint).setLocation(deltaX, deltaY);
            EditWindow.gridAlign(refPastePoint);
            return refPastePoint;
        }

        private void showList(Point2D delta) {
            if (delta == null) {
                return;
            }
            double oX = delta.getX();
            double oY = delta.getY();
            Cell cell = this.wnd.getCell();
            Highlighter highlighter = this.wnd.getHighlighter();
            highlighter.clear();
            Iterator it = this.pasteList.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                Point2D[] points = null;
                if (obj instanceof Variable) {
                    Variable var = (Variable)obj;
                    Poly poly = clipCell.computeTextPoly(EditWindow.needCurrent(), var, null);
                    points = poly.getPoints();
                } else {
                    if (!(obj instanceof Geometric)) continue;
                    Geometric geom = (Geometric)obj;
                    if (geom instanceof ArcInst) {
                        ArcInst ai = (ArcInst)geom;
                        Poly poly = ai.makePoly(ai.getWidth() - ai.getProto().getWidthOffset(), Poly.Type.CLOSED);
                        points = poly.getPoints();
                    } else {
                        NodeInst ni = (NodeInst)geom;
                        if (ni.isInvisiblePinWithText()) {
                            Iterator vIt = ni.getVariables();
                            while (vIt.hasNext()) {
                                Variable var = (Variable)vIt.next();
                                if (!var.isDisplay()) continue;
                                points = Highlighter.describeHighlightText(this.wnd, geom, var, null);
                                break;
                            }
                        }
                        if (points != null) {
                            for (int i = 0; i < points.length; i += 2) {
                                double fX = points[i].getX();
                                double fY = points[i].getY();
                                double tX = points[i + 1].getX();
                                double tY = points[i + 1].getY();
                                highlighter.addLine(new Point2D.Double(fX + oX, fY + oY), new Point2D.Double(tX + oX, tY + oY), cell);
                            }
                            continue;
                        }
                        SizeOffset so = ni.getSizeOffset();
                        AffineTransform trans = ni.rotateOutAboutTrueCenter();
                        double nodeLowX = ni.getTrueCenterX() - ni.getXSize() / 2.0 + so.getLowXOffset();
                        double nodeHighX = ni.getTrueCenterX() + ni.getXSize() / 2.0 - so.getHighXOffset();
                        double nodeLowY = ni.getTrueCenterY() - ni.getYSize() / 2.0 + so.getLowYOffset();
                        double nodeHighY = ni.getTrueCenterY() + ni.getYSize() / 2.0 - so.getHighYOffset();
                        double nodeX = (nodeLowX + nodeHighX) / 2.0;
                        double nodeY = (nodeLowY + nodeHighY) / 2.0;
                        Poly poly = new Poly(nodeX, nodeY, nodeHighX - nodeLowX, nodeHighY - nodeLowY);
                        poly.transform(trans);
                        points = poly.getPoints();
                    }
                }
                if (points == null) continue;
                for (int i = 0; i < points.length; ++i) {
                    int lastI = i - 1;
                    if (lastI < 0) {
                        lastI = points.length - 1;
                    }
                    double fX = points[lastI].getX();
                    double fY = points[lastI].getY();
                    double tX = points[i].getX();
                    double tY = points[i].getY();
                    highlighter.addLine(new Point2D.Double(fX + oX, fY + oY), new Point2D.Double(tX + oX, tY + oY), cell);
                }
            }
            Rectangle2D bounds = this.wnd.getDisplayedBounds();
            highlighter.addMessage(cell, "(" + (int)oX + "," + (int)oY + ")", new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()));
            double halfWidth = 0.5 * this.pasteBounds.getWidth();
            double halfHeight = 0.5 * this.pasteBounds.getHeight();
            if (Math.abs(this.translateX) > halfWidth || Math.abs(this.translateY) > halfHeight) {
                Rectangle2D.Double transBounds = new Rectangle2D.Double(this.pasteBounds.getX() + oX, this.pasteBounds.getY() + oY, this.pasteBounds.getWidth(), this.pasteBounds.getHeight());
                Poly p = new Poly(transBounds);
                Point2D endPoint = p.closestPoint(this.lastMouseDB);
                highlighter.addLine(this.lastMouseDB, endPoint, cell);
                int angle = GenMath.figureAngle(this.lastMouseDB, endPoint);
                int angleOfArrow = 300;
                int backAngle1 = (angle += 1800) - angleOfArrow;
                int backAngle2 = angle + angleOfArrow;
                Point2D.Double p1 = new Point2D.Double(endPoint.getX() + DBMath.cos(backAngle1), endPoint.getY() + DBMath.sin(backAngle1));
                Point2D.Double p2 = new Point2D.Double(endPoint.getX() + DBMath.cos(backAngle2), endPoint.getY() + DBMath.sin(backAngle2));
                highlighter.addLine(endPoint, p1, cell);
                highlighter.addLine(endPoint, p2, cell);
            }
            highlighter.finished();
        }

        public void mousePressed(MouseEvent e) {
            if (e.isMetaDown()) {
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        public void mouseDragged(MouseEvent evt) {
            this.mouseMoved(evt);
        }

        public void mouseReleased(MouseEvent evt) {
            if (evt.isMetaDown()) {
                return;
            }
            boolean ctrl = (evt.getModifiersEx() & 0x80) != 0;
            Point2D mouseDB = this.wnd.screenToDatabase(evt.getX(), evt.getY());
            Point2D delta = this.getDelta(mouseDB, ctrl);
            this.showList(delta);
            WindowFrame.setListener(this.currentListener);
            this.wnd.getHighlighter().popHighlight();
            PasteObjects job = new PasteObjects(this.pasteList, delta.getX(), delta.getY());
        }

        public void mouseMoved(MouseEvent evt) {
            boolean ctrl = (evt.getModifiersEx() & 0x80) != 0;
            Point2D mouseDB = this.wnd.screenToDatabase(evt.getX(), evt.getY());
            Point2D delta = this.getDelta(mouseDB, ctrl);
            this.lastMouseDB = mouseDB;
            this.showList(delta);
            this.wnd.repaint();
        }

        public void mouseClicked(MouseEvent evt) {
        }

        public void mouseEntered(MouseEvent evt) {
        }

        public void mouseExited(MouseEvent evt) {
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
        }

        public void keyPressed(KeyEvent evt) {
            boolean ctrl = (evt.getModifiersEx() & 0x80) != 0;
            int chr = evt.getKeyCode();
            if (chr == 27) {
                this.abort();
            } else if (chr == 38) {
                this.moveObjectsUp();
            } else if (chr == 40) {
                this.moveObjectsDown();
            } else if (chr == 37) {
                this.moveObjectsLeft();
            } else if (chr == 39) {
                this.moveObjectsRight();
            }
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }

        private void abort() {
            this.wnd.getHighlighter().clear();
            this.wnd.getHighlighter().finished();
            WindowFrame.setListener(this.currentListener);
            this.wnd.repaint();
        }

        private void initPopup() {
            this.popup = new JPopupMenu();
            JMenuItem m = new JMenuItem("Move objects left");
            m.setAccelerator(KeyStroke.getKeyStroke(37, 0));
            m.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PasteListener.this.moveObjectsLeft();
                }
            });
            this.popup.add(m);
            m = new JMenuItem("Move objects right");
            m.setAccelerator(KeyStroke.getKeyStroke(39, 0));
            m.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PasteListener.this.moveObjectsRight();
                }
            });
            this.popup.add(m);
            m = new JMenuItem("Move objects up");
            m.setAccelerator(KeyStroke.getKeyStroke(38, 0));
            m.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PasteListener.this.moveObjectsUp();
                }
            });
            this.popup.add(m);
            m = new JMenuItem("Move objects down");
            m.setAccelerator(KeyStroke.getKeyStroke(40, 0));
            m.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PasteListener.this.moveObjectsDown();
                }
            });
            this.popup.add(m);
            m = new JMenuItem("Abort");
            m.setAccelerator(KeyStroke.getKeyStroke(27, 0));
            m.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PasteListener.this.abort();
                }
            });
            this.popup.add(m);
        }

        private void moveObjectsLeft() {
            this.translateX += 0.5 * this.pasteBounds.getWidth();
            Point2D delta = this.getDelta(this.lastMouseDB, false);
            this.showList(delta);
        }

        private void moveObjectsRight() {
            this.translateX -= 0.5 * this.pasteBounds.getWidth();
            Point2D delta = this.getDelta(this.lastMouseDB, false);
            this.showList(delta);
        }

        private void moveObjectsUp() {
            this.translateY -= 0.5 * this.pasteBounds.getHeight();
            Point2D delta = this.getDelta(this.lastMouseDB, false);
            this.showList(delta);
        }

        private void moveObjectsDown() {
            this.translateY += 0.5 * this.pasteBounds.getHeight();
            Point2D delta = this.getDelta(this.lastMouseDB, false);
            this.showList(delta);
        }
    }

    private static class PasteObjects
    extends Job {
        List pasteList;
        double dX;
        double dY;

        protected PasteObjects(List pasteList, double dX, double dY) {
            super("Paste", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.pasteList = pasteList;
            this.dX = dX;
            this.dY = dY;
            this.startJob();
        }

        public boolean doIt() {
            EditWindow wnd = EditWindow.needCurrent();
            if (wnd == null) {
                return false;
            }
            Cell parent = wnd.getCell();
            if (CircuitChanges.cantEdit(parent, null, true) != 0) {
                return false;
            }
            Clipboard.copyListToCell(wnd, this.pasteList, clipCell, parent, new Point2D.Double(this.dX, this.dY), User.isDupCopiesExports(), User.isArcsAutoIncremented());
            Iterator it = clipCell.getVariables();
            while (it.hasNext()) {
                Variable cellVar;
                Variable var = (Variable)it.next();
                if (!var.isDisplay() || (cellVar = parent.newVar(var.getKey(), var.getObject())) == null) continue;
                cellVar.setTextDescriptor(var.getTextDescriptor());
                cellVar.setOff(cellVar.getXOff() + this.dX, cellVar.getYOff() + this.dY);
            }
            return true;
        }
    }

    private static class PasteNodeToNode
    extends Job {
        NodeInst src;
        NodeInst dst;
        Highlighter highlighter;

        protected PasteNodeToNode(NodeInst dst, NodeInst src, Highlighter highlighter) {
            super("Paste Node to Node", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.src = src;
            this.dst = dst;
            this.highlighter = highlighter;
            this.startJob();
        }

        public boolean doIt() {
            if (CircuitChanges.cantEdit(this.dst.getParent(), null, true) != 0) {
                return false;
            }
            NodeInst ni = Clipboard.pasteNodeToNode(this.dst, this.src);
            if (ni == null) {
                System.out.println("Nothing was pasted");
            }
            if (ni != null) {
                this.highlighter.clear();
                this.highlighter.addElectricObject(ni, ni.getParent());
                this.highlighter.finished();
            }
            return true;
        }
    }

    private static class PasteArcToArc
    extends Job {
        ArcInst src;
        ArcInst dst;
        Highlighter highlighter;

        protected PasteArcToArc(ArcInst dst, ArcInst src, Highlighter highlighter) {
            super("Paste Arc to Arc", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.src = src;
            this.dst = dst;
            this.highlighter = highlighter;
            this.startJob();
        }

        public boolean doIt() {
            if (CircuitChanges.cantEdit(this.dst.getParent(), null, true) != 0) {
                return false;
            }
            ArcInst ai = Clipboard.pasteArcToArc(this.dst, this.src);
            if (ai == null) {
                System.out.println("Nothing was pasted");
            }
            if (ai != null) {
                this.highlighter.clear();
                this.highlighter.addElectricObject(ai, ai.getParent());
                this.highlighter.finished();
            }
            return true;
        }
    }

    private static class DuplicateObjects
    extends Job {
        private List highlights;

        protected DuplicateObjects(List highlights) {
            super("Duplicate", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.highlights = highlights;
            this.startJob();
        }

        public boolean doIt() {
            if (this.highlights.size() == 0) {
                System.out.println("First select objects to copy");
                return false;
            }
            EditWindow wnd = EditWindow.needCurrent();
            if (wnd == null) {
                return false;
            }
            Cell parent = wnd.getCell();
            Clipboard.clear();
            Clipboard.copyListToCell(null, this.highlights, parent, clipCell, new Point2D.Double(0.0, 0.0), User.isDupCopiesExports(), User.isArcsAutoIncremented());
            Highlighter highlighter = wnd.getHighlighter();
            if (highlighter != null) {
                highlighter.clear();
            }
            Clipboard.paste(true);
            return true;
        }
    }

    private static class CutObjects
    extends Job {
        private List highlights;

        protected CutObjects(List highlights) {
            super("Cut", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.highlights = highlights;
            this.startJob();
        }

        public boolean doIt() {
            if (this.highlights.size() == 0) {
                System.out.println("First select objects to cut");
                return false;
            }
            EditWindow wnd = EditWindow.needCurrent();
            if (wnd == null) {
                return false;
            }
            Cell parent = wnd.getCell();
            Clipboard.clear();
            if (CircuitChanges.cantEdit(parent, null, true) != 0) {
                return false;
            }
            ArrayList<Highlight> deleteList = new ArrayList<Highlight>();
            Iterator it = this.highlights.iterator();
            while (it.hasNext()) {
                Highlight h = (Highlight)it.next();
                if (h.getType() == Highlight.Type.EOBJ) {
                    ElectricObject eObj = h.getElectricObject();
                    if (eObj instanceof PortInst) {
                        eObj = ((PortInst)eObj).getNodeInst();
                    }
                    if (eObj instanceof NodeInst) {
                        int errorCode = CircuitChanges.cantEdit(parent, (NodeInst)eObj, true);
                        if (errorCode < 0) {
                            return false;
                        }
                        if (errorCode > 0) continue;
                    }
                }
                deleteList.add(h);
            }
            this.highlights = deleteList;
            Clipboard.copyListToCell(null, this.highlights, parent, clipCell, new Point2D.Double(0.0, 0.0), User.isDupCopiesExports(), User.isArcsAutoIncremented());
            CircuitChanges.eraseObjectsInList(parent, this.highlights);
            return true;
        }
    }

    private static class CopyObjects
    extends Job {
        private List highlights;

        protected CopyObjects(List highlights) {
            super("Copy", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.highlights = highlights;
            this.startJob();
        }

        public boolean doIt() {
            if (this.highlights.size() == 0) {
                System.out.println("First select objects to copy");
                return false;
            }
            EditWindow wnd = EditWindow.needCurrent();
            if (wnd == null) {
                return false;
            }
            Cell parent = wnd.getCell();
            Clipboard.clear();
            Clipboard.copyListToCell(null, this.highlights, parent, clipCell, new Point2D.Double(0.0, 0.0), User.isDupCopiesExports(), User.isArcsAutoIncremented());
            return true;
        }
    }
}

