/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.constraint.Layout;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.ImmutableTextDescriptor;
import com.sun.electric.database.variable.MutableTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.input.LibraryFiles;
import com.sun.electric.tool.project.Project;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.ChangeCurrentLib;
import com.sun.electric.tool.user.menus.MenuCommands;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.OutlineListener;
import com.sun.electric.tool.user.ui.PixelDrawing;
import com.sun.electric.tool.user.ui.StatusBar;
import com.sun.electric.tool.user.ui.ToolBar;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WaveformWindow;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;

public class CircuitChanges {
    private static double lastRotationAmount = 90.0;
    private static HashSet expandFlagBit;
    static /* synthetic */ Class class$com$sun$electric$database$topology$NodeInst;
    static /* synthetic */ Class class$com$sun$electric$database$topology$ArcInst;
    static /* synthetic */ Class class$com$sun$electric$database$prototype$PortProto;
    static /* synthetic */ Class class$java$lang$String;

    CircuitChanges() {
    }

    public static void rotateObjects(int amount) {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        if (amount == 0) {
            String val = JOptionPane.showInputDialog("Amount to rotate", (Object)new Double(lastRotationAmount));
            if (val == null) {
                return;
            }
            double fAmount = TextUtils.atof(val);
            if (fAmount == 0.0) {
                System.out.println("Null rotation amount");
                return;
            }
            lastRotationAmount = fAmount;
            amount = (int)(fAmount * 10.0);
        }
        RotateSelected job = new RotateSelected(cell, MenuCommands.getSelectedObjects(true, true), amount, false, false);
    }

    public static void mirrorObjects(boolean horizontally) {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        Cell cell = wf.getContent().getCell();
        if (cell == null) {
            return;
        }
        RotateSelected job = new RotateSelected(cell, MenuCommands.getSelectedObjects(true, true), 0, true, horizontally);
    }

    private static void spreadRotateConnection(NodeInst theNi, HashSet markObj) {
        if (markObj.contains(theNi)) {
            return;
        }
        markObj.add(theNi);
        Iterator it = theNi.getConnections();
        while (it.hasNext()) {
            int otherEnd;
            NodeInst ni;
            Connection con = (Connection)it.next();
            ArcInst ai = con.getArc();
            if (!markObj.contains(ai) || markObj.contains(ni = ai.getPortInst(otherEnd = 1 - con.getEndIndex()).getNodeInst())) continue;
            markObj.add(ni);
            CircuitChanges.spreadRotateConnection(ni, markObj);
        }
    }

    public static void alignToGrid() {
        List selected = MenuCommands.getSelectedObjects(true, true);
        HashSet<Geometric> selectedNodes = new HashSet<Geometric>();
        Iterator it = selected.iterator();
        while (it.hasNext()) {
            Geometric geom = (Geometric)it.next();
            if (!(geom instanceof NodeInst)) continue;
            selectedNodes.add(geom);
        }
        ArrayList<NodeInst> addedNodes = new ArrayList<NodeInst>();
        Iterator it2 = selected.iterator();
        while (it2.hasNext()) {
            NodeInst tail;
            Geometric geom = (Geometric)it2.next();
            if (!(geom instanceof ArcInst)) continue;
            ArcInst ai = (ArcInst)geom;
            NodeInst head = ai.getHead().getPortInst().getNodeInst();
            if (!selectedNodes.contains(head)) {
                addedNodes.add(head);
                selectedNodes.add(head);
            }
            if (selectedNodes.contains(tail = ai.getTail().getPortInst().getNodeInst())) continue;
            addedNodes.add(tail);
            selectedNodes.add(tail);
        }
        it2 = addedNodes.iterator();
        while (it2.hasNext()) {
            selected.add(it2.next());
        }
        AlignObjects job = new AlignObjects(selected);
    }

    public static void alignNodes(boolean horizontal, int direction) {
        Rectangle2D bounds;
        NodeInst ni;
        int i;
        Cell np = WindowFrame.needCurCell();
        if (np == null) {
            return;
        }
        List list = MenuCommands.getSelectedObjects(true, true);
        if (list.size() == 0) {
            System.out.println("First select objects to move");
            return;
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Geometric geom = (Geometric)it.next();
            if (geom.getParent() == np) continue;
            System.out.println("All moved objects must be in the same cell");
            return;
        }
        ArrayList<Geometric> nodes = new ArrayList<Geometric>();
        Iterator it2 = list.iterator();
        while (it2.hasNext()) {
            Geometric geom = (Geometric)it2.next();
            if (!(geom instanceof NodeInst)) continue;
            nodes.add(geom);
        }
        int total = nodes.size();
        if (total == 0) {
            return;
        }
        NodeInst[] nis = new NodeInst[total];
        double[] dCX = new double[total];
        double[] dCY = new double[total];
        for (int i2 = 0; i2 < total; ++i2) {
            nis[i2] = (NodeInst)nodes.get(i2);
        }
        double lX = 0.0;
        double hX = 0.0;
        double lY = 0.0;
        double hY = 0.0;
        for (i = 0; i < total; ++i) {
            ni = nis[i];
            bounds = ni.getBounds();
            if (i == 0) {
                lX = bounds.getMinX();
                hX = bounds.getMaxX();
                lY = bounds.getMinY();
                hY = bounds.getMaxY();
                continue;
            }
            if (bounds.getMinX() < lX) {
                lX = bounds.getMinX();
            }
            if (bounds.getMaxX() > hX) {
                hX = bounds.getMaxX();
            }
            if (bounds.getMinY() < lY) {
                lY = bounds.getMinY();
            }
            if (!(bounds.getMaxY() > hY)) continue;
            hY = bounds.getMaxY();
        }
        block14: for (i = 0; i < total; ++i) {
            ni = nis[i];
            bounds = ni.getBounds();
            dCY[i] = 0.0;
            dCX[i] = 0.0;
            if (horizontal) {
                switch (direction) {
                    case 0: {
                        dCX[i] = lX - bounds.getMinX();
                        break;
                    }
                    case 1: {
                        dCX[i] = hX - bounds.getMaxX();
                        break;
                    }
                    case 2: {
                        dCX[i] = (lX + hX) / 2.0 - bounds.getCenterX();
                    }
                }
                continue;
            }
            switch (direction) {
                case 0: {
                    dCY[i] = hY - bounds.getMaxY();
                    continue block14;
                }
                case 1: {
                    dCY[i] = lY - bounds.getMinY();
                    continue block14;
                }
                case 2: {
                    dCY[i] = (lY + hY) / 2.0 - bounds.getCenterY();
                }
            }
        }
        AlignNodes job = new AlignNodes(nis, dCX, dCY);
    }

    public static void arcRigidCommand() {
        ChangeArcProperties job = new ChangeArcProperties(1, MenuCommands.getHighlighted());
    }

    public static void arcNotRigidCommand() {
        ChangeArcProperties job = new ChangeArcProperties(2, MenuCommands.getHighlighted());
    }

    public static void arcFixedAngleCommand() {
        ChangeArcProperties job = new ChangeArcProperties(3, MenuCommands.getHighlighted());
    }

    public static void arcNotFixedAngleCommand() {
        ChangeArcProperties job = new ChangeArcProperties(4, MenuCommands.getHighlighted());
    }

    public static void arcDirectionalCommand() {
        ChangeArcProperties job = new ChangeArcProperties(5, MenuCommands.getHighlighted());
    }

    public static void arcHeadExtendCommand() {
        ChangeArcProperties job = new ChangeArcProperties(6, MenuCommands.getHighlighted());
    }

    public static void arcTailExtendCommand() {
        ChangeArcProperties job = new ChangeArcProperties(7, MenuCommands.getHighlighted());
    }

    public static void toggleNegatedCommand() {
        ToggleNegationJob job = new ToggleNegationJob(MenuCommands.getHighlighted());
    }

    public static void ripBus() {
        List list = MenuCommands.getSelectedObjects(false, true);
        if (list.size() == 0) {
            System.out.println("Must select bus arcs to rip into individual signals");
            return;
        }
        RipTheBus job = new RipTheBus(list);
    }

    public static void deleteSelected() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        Highlighter highlighter = wf.getContent().getHighlighter();
        if (highlighter == null) {
            return;
        }
        if (wf.getContent() instanceof WaveformWindow) {
            WaveformWindow ww = (WaveformWindow)wf.getContent();
            ww.deleteSelectedSignals();
            return;
        }
        if (WindowFrame.getListener() == OutlineListener.theOne) {
            return;
        }
        if (ToolBar.getSelectMode() == ToolBar.SelectMode.AREA) {
            EditWindow wnd = EditWindow.getCurrent();
            Rectangle2D bounds = highlighter.getHighlightedArea(wnd);
            DeleteSelectedGeometry job = new DeleteSelectedGeometry(wnd.getCell(), bounds);
        } else {
            List highlightedText = highlighter.getHighlightedText(true);
            List highlighted = highlighter.getHighlights();
            if (highlighted.size() == 0) {
                return;
            }
            DeleteSelected job = new DeleteSelected(highlightedText, highlighted);
        }
    }

    public static void eraseObjectsInList(Cell cell, List list) {
        NodeInst ni;
        NodeInst ni2;
        int otherEnd;
        ArcInst ai;
        Connection con;
        NodeInst ni3;
        ArcInst ai2;
        HashSet<ArcInst> arcsToDelete = new HashSet<ArcInst>();
        HashSet<NodeInst> nodesToDelete = new HashSet<NodeInst>();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj instanceof Highlight) {
                obj = ((Highlight)obj).getGeometric();
            }
            if (obj instanceof ArcInst) {
                ai2 = (ArcInst)obj;
                arcsToDelete.add(ai2);
                continue;
            }
            if (!(obj instanceof NodeInst)) continue;
            ni3 = (NodeInst)obj;
            nodesToDelete.add(ni3);
        }
        HashSet<NodeInst> alsoDeleteTheseNodes = new HashSet<NodeInst>();
        Iterator it2 = arcsToDelete.iterator();
        while (it2.hasNext()) {
            ai2 = (ArcInst)it2.next();
            alsoDeleteTheseNodes.add(ai2.getHeadPortInst().getNodeInst());
            alsoDeleteTheseNodes.add(ai2.getTailPortInst().getNodeInst());
        }
        it2 = nodesToDelete.iterator();
        while (it2.hasNext()) {
            ni3 = (NodeInst)it2.next();
            Iterator sit = ni3.getConnections();
            while (sit.hasNext()) {
                con = (Connection)sit.next();
                ai = con.getArc();
                otherEnd = 1 - con.getEndIndex();
                NodeInst oNi = ai.getPortInst(otherEnd).getNodeInst();
                alsoDeleteTheseNodes.add(oNi);
            }
        }
        if (User.isReconstructArcsToDeletedCells()) {
            it2 = nodesToDelete.iterator();
            while (it2.hasNext()) {
                ni3 = (NodeInst)it2.next();
                if (!(ni3.getProto() instanceof Cell)) continue;
                Iterator cIt = ni3.getConnections();
                while (cIt.hasNext()) {
                    PortInst otherPi;
                    NodeInst otherNi;
                    con = (Connection)cIt.next();
                    ai = con.getArc();
                    if (arcsToDelete.contains(ai) || (otherNi = (otherPi = ai.getPortInst(otherEnd = 1 - con.getEndIndex())).getNodeInst()) == ni3 || nodesToDelete.contains(otherNi)) continue;
                    PrimitiveNode pinNp = ai.getProto().findPinProto();
                    NodeInst pin = NodeInst.makeInstance(pinNp, con.getLocation(), pinNp.getDefWidth(), pinNp.getDefHeight(), cell);
                    ArcInst recon = ArcInst.makeInstance(ai.getProto(), ai.getWidth(), otherPi, pin.getOnlyPortInst());
                }
            }
        }
        it2 = arcsToDelete.iterator();
        while (it2.hasNext()) {
            ai2 = (ArcInst)it2.next();
            ai2.kill();
        }
        it2 = nodesToDelete.iterator();
        while (it2.hasNext()) {
            ni3 = (NodeInst)it2.next();
            Reconnect re = Reconnect.erasePassThru(ni3, false);
            if (re != null) {
                re.reconnectArcs();
            }
            CircuitChanges.eraseNodeInst(ni3);
        }
        ArrayList<NodeInst> deleteTheseNodes = new ArrayList<NodeInst>();
        Iterator it3 = alsoDeleteTheseNodes.iterator();
        while (it3.hasNext()) {
            ni2 = (NodeInst)it3.next();
            if (!(ni2.getProto() instanceof PrimitiveNode) || ni2.getProto().getFunction() != PrimitiveNode.Function.PIN || ni2.getNumConnections() != 0 || ni2.getNumExports() != 0) continue;
            deleteTheseNodes.add(ni2);
        }
        it3 = deleteTheseNodes.iterator();
        while (it3.hasNext()) {
            ni2 = (NodeInst)it3.next();
            if (!ni2.isLinked()) continue;
            CircuitChanges.eraseNodeInst(ni2);
        }
        ArrayList<NodeInst> nodesToPassThru = new ArrayList<NodeInst>();
        Iterator it4 = alsoDeleteTheseNodes.iterator();
        while (it4.hasNext()) {
            ni = (NodeInst)it4.next();
            if (!(ni.getProto() instanceof PrimitiveNode) || ni.getProto().getFunction() != PrimitiveNode.Function.PIN || ni.getNumExports() != 0 || !ni.isInlinePin()) continue;
            nodesToPassThru.add(ni);
        }
        it4 = nodesToPassThru.iterator();
        while (it4.hasNext()) {
            ni = (NodeInst)it4.next();
            Reconnect re = Reconnect.erasePassThru(ni, false);
            if (re == null) continue;
            re.reconnectArcs();
            CircuitChanges.eraseNodeInst(ni);
        }
        it4 = list.iterator();
        while (it4.hasNext()) {
            ElectricObject owner;
            Variable var;
            Highlight h;
            Object obj = it4.next();
            if (!(obj instanceof Highlight) || (h = (Highlight)obj).getType() != Highlight.Type.TEXT || (var = h.getVar()) == null || !((owner = h.getElectricObject()) instanceof Cell)) continue;
            owner.delVar(var.getKey());
        }
    }

    private static void eraseNodeInst(NodeInst ni) {
        if (ni.getNumConnections() > 0) {
            HashSet<ArcInst> arcsToDelete = new HashSet<ArcInst>();
            Iterator it = ni.getConnections();
            while (it.hasNext()) {
                Connection con = (Connection)it.next();
                arcsToDelete.add(con.getArc());
            }
            it = arcsToDelete.iterator();
            while (it.hasNext()) {
                ArcInst ai = (ArcInst)it.next();
                ai.kill();
            }
        }
        CircuitChanges.undoExport(ni, null);
        ni.kill();
    }

    private static void undoExport(NodeInst ni, Export spt) {
        Export pp;
        int numExports = ni.getNumExports();
        if (numExports == 0) {
            return;
        }
        Export[] exportsToDelete = new Export[numExports];
        int i = 0;
        Iterator it = ni.getExports();
        while (it.hasNext()) {
            pp = (Export)it.next();
            exportsToDelete[i++] = pp;
        }
        for (int j = 0; j < numExports; ++j) {
            pp = exportsToDelete[j];
            if (spt != null && spt != pp) continue;
            pp.kill();
        }
    }

    public static boolean deleteCell(Cell cell, boolean confirm, boolean quiet) {
        int response;
        if (cell.isInUse("delete", quiet)) {
            return false;
        }
        if (confirm && (response = JOptionPane.showConfirmDialog(TopLevel.getCurrentJFrame(), "Are you sure you want to delete " + cell + "?", "Delete Cell Dialog", 0)) != 0) {
            return false;
        }
        DeleteCell job = new DeleteCell(cell);
        return true;
    }

    private static void doKillCell(Cell cell) {
        Library lib = cell.getLibrary();
        if (cell == lib.getCurCell()) {
            lib.setCurCell(null);
        }
        Iterator it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = (WindowFrame)it.next();
            WindowContent content = wf.getContent();
            if (content == null || content.getCell() != cell) continue;
            if (!(content instanceof EditWindow)) {
                wf.setCellWindow(null);
                continue;
            }
            content.setCell(null, null);
            content.fullRepaint();
        }
        cell.kill();
    }

    public static void renameCellInJob(Cell cell, String newName) {
        Cell.CellGroup newGroup = null;
        Iterator it = cell.getLibrary().getCells();
        while (it.hasNext()) {
            Cell oCell = (Cell)it.next();
            if (!oCell.getName().equalsIgnoreCase(newName) || oCell.getCellGroup() == cell.getCellGroup()) continue;
            int response = JOptionPane.showConfirmDialog(TopLevel.getCurrentJFrame(), "Also place the cell into the " + oCell.getCellGroup().getName() + " group?");
            if (response != 0) break;
            newGroup = oCell.getCellGroup();
            break;
        }
        RenameCell job = new RenameCell(cell, newName, newGroup);
    }

    public static void renameCellGroupInJob(Cell.CellGroup cellGroup, String newName) {
        RenameCellGroup job = new RenameCellGroup(cellGroup, newName);
    }

    public static void deleteUnusedOldVersions() {
        DeleteUnusedOldCells job = new DeleteUnusedOldCells();
    }

    public static void graphCellsFromCell() {
        Cell top = WindowFrame.needCurCell();
        if (top == null) {
            return;
        }
        GraphCells job = new GraphCells(top);
    }

    public static void graphCellsInLibrary() {
        GraphCells job = new GraphCells(null);
    }

    private static Cell graphMainView(Cell cell) {
        Cell cellInGroup;
        Cell mainSchem = cell.getCellGroup().getMainSchematics();
        if (mainSchem != null) {
            return mainSchem;
        }
        Iterator it = cell.getCellGroup().getCells();
        while (it.hasNext()) {
            cellInGroup = (Cell)it.next();
            if (cellInGroup.getView() != View.LAYOUT) continue;
            return cellInGroup;
        }
        it = cell.getCellGroup().getCells();
        while (it.hasNext()) {
            cellInGroup = (Cell)it.next();
            if (cellInGroup.getView() != View.UNKNOWN) continue;
            return cellInGroup;
        }
        return null;
    }

    public static void packageIntoCell() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        Highlighter highlighter = wf.getContent().getHighlighter();
        if (highlighter == null) {
            return;
        }
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Cell curCell = wnd.getCell();
        if (curCell == null) {
            System.out.println("No cell in this window");
            return;
        }
        Rectangle2D bounds = highlighter.getHighlightedArea(wnd);
        if (bounds == null) {
            System.out.println("Must first select circuitry to package");
            return;
        }
        String newCellName = JOptionPane.showInputDialog("New cell name:", (Object)curCell.getName());
        if (newCellName == null) {
            return;
        }
        newCellName = newCellName + "{" + curCell.getView().getAbbreviation() + "}";
        PackageCell job = new PackageCell(curCell, bounds, newCellName);
    }

    public static void extractCells() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        ExtractCellInstances job = new ExtractCellInstances(MenuCommands.getSelectedObjects(true, false));
    }

    private static void extractOneNode(NodeInst topno) {
        Export pp;
        NodeInst newNi;
        Cell cell = topno.getParent();
        Cell subCell = (Cell)topno.getProto();
        AffineTransform localTrans = topno.translateOut();
        AffineTransform localRot = topno.rotateOut();
        localTrans.preConcatenate(localRot);
        ArrayList nodes = new ArrayList();
        Iterator it = subCell.getNodes();
        while (it.hasNext()) {
            nodes.add(it.next());
        }
        HashMap<NodeInst, NodeInst> newNodes = new HashMap<NodeInst, NodeInst>();
        Iterator it2 = nodes.iterator();
        while (it2.hasNext()) {
            NodeInst ni = (NodeInst)it2.next();
            NodeProto np = ni.getProto();
            if (np == Generic.tech.cellCenterNode || np == Generic.tech.essentialBoundsNode) continue;
            Point2D.Double pt = new Point2D.Double(ni.getAnchorCenterX(), ni.getAnchorCenterY());
            localTrans.transform(pt, pt);
            String name = null;
            if (ni.isUsernamed()) {
                name = ElectricObject.uniqueObjectName(ni.getName(), cell, class$com$sun$electric$database$topology$NodeInst == null ? CircuitChanges.class$("com.sun.electric.database.topology.NodeInst") : class$com$sun$electric$database$topology$NodeInst);
            }
            Orientation orient = topno.getOrient().concatenate(ni.getOrient());
            newNi = NodeInst.makeInstance(np, pt, ni.getXSize(), ni.getYSize(), cell, orient, name, 0);
            if (newNi == null) {
                return;
            }
            newNodes.put(ni, newNi);
            newNi.copyTextDescriptorFrom(ni, NodeInst.NODE_NAME_TD);
            newNi.copyStateBits(ni);
            newNi.copyVarsFrom(ni);
        }
        ArrayList arcs = new ArrayList();
        Iterator it3 = subCell.getArcs();
        while (it3.hasNext()) {
            arcs.add(it3.next());
        }
        it3 = arcs.iterator();
        while (it3.hasNext()) {
            ArcInst newAi;
            Poly polyTail;
            ArcInst ai = (ArcInst)it3.next();
            NodeInst niTail = (NodeInst)newNodes.get(ai.getTailPortInst().getNodeInst());
            NodeInst niHead = (NodeInst)newNodes.get(ai.getHeadPortInst().getNodeInst());
            if (niTail == null || niHead == null) continue;
            PortInst piTail = niTail.findPortInstFromProto(ai.getTailPortInst().getPortProto());
            PortInst piHead = niHead.findPortInstFromProto(ai.getHeadPortInst().getPortProto());
            Point2D.Double ptTail = new Point2D.Double();
            localTrans.transform(ai.getTailLocation(), ptTail);
            Point2D.Double ptHead = new Point2D.Double();
            localTrans.transform(ai.getHeadLocation(), ptHead);
            Poly polyHead = piHead.getPoly();
            if (!polyHead.isInside(ptHead)) {
                ((Point2D)ptHead).setLocation(polyHead.getCenterX(), polyHead.getCenterY());
            }
            if (!(polyTail = piTail.getPoly()).isInside(ptTail)) {
                ((Point2D)ptTail).setLocation(polyTail.getCenterX(), polyTail.getCenterY());
            }
            String name = null;
            if (ai.isUsernamed()) {
                name = ElectricObject.uniqueObjectName(ai.getName(), cell, class$com$sun$electric$database$topology$ArcInst == null ? CircuitChanges.class$("com.sun.electric.database.topology.ArcInst") : class$com$sun$electric$database$topology$ArcInst);
            }
            if ((newAi = ArcInst.makeInstance(ai.getProto(), ai.getWidth(), piHead, piTail, ptHead, ptTail, name)) == null) {
                return;
            }
            newAi.copyPropertiesFrom(ai);
        }
        ArrayList<ArcInst> replaceTheseArcs = new ArrayList<ArcInst>();
        Iterator it4 = topno.getConnections();
        while (it4.hasNext()) {
            Connection con = (Connection)it4.next();
            replaceTheseArcs.add(con.getArc());
        }
        it4 = replaceTheseArcs.iterator();
        while (it4.hasNext()) {
            ArcInst ai = (ArcInst)it4.next();
            ArcProto ap = ai.getProto();
            double wid = ai.getWidth();
            String name = null;
            if (ai.isUsernamed()) {
                name = ElectricObject.uniqueObjectName(ai.getName(), cell, class$com$sun$electric$database$topology$ArcInst == null ? CircuitChanges.class$("com.sun.electric.database.topology.ArcInst") : class$com$sun$electric$database$topology$ArcInst);
            }
            PortInst[] pis = new PortInst[2];
            Point2D[] pts = new Point2D[2];
            for (int i = 0; i < 2; ++i) {
                Export pp2;
                NodeInst subNi;
                NodeInst newNi2;
                pis[i] = ai.getPortInst(i);
                pts[i] = ai.getLocation(i);
                if (pis[i].getNodeInst() != topno || (newNi2 = (NodeInst)newNodes.get(subNi = (pp2 = (Export)pis[i].getPortProto()).getOriginalPort().getNodeInst())) == null) continue;
                pis[i] = newNi2.findPortInstFromProto(pp2.getOriginalPort().getPortProto());
            }
            if (pis[0] == null || pis[1] == null) continue;
            ai.kill();
            ArcInst newAi = ArcInst.makeInstance(ap, wid, pis[0], pis[1], pts[0], pts[1], name);
            if (newAi == null) {
                return;
            }
            newAi.copyPropertiesFrom(ai);
        }
        ArrayList existingExports = new ArrayList();
        Iterator it5 = topno.getExports();
        while (it5.hasNext()) {
            existingExports.add(it5.next());
        }
        it5 = existingExports.iterator();
        while (it5.hasNext()) {
            pp = (Export)it5.next();
            Export subPp = (Export)pp.getOriginalPort().getPortProto();
            NodeInst subNi = subPp.getOriginalPort().getNodeInst();
            NodeInst newNi3 = (NodeInst)newNodes.get(subNi);
            if (newNi3 == null) continue;
            PortInst pi = newNi3.findPortInstFromProto(subPp.getOriginalPort().getPortProto());
            pp.move(pi);
        }
        if (User.isExtractCopiesExports()) {
            it5 = subCell.getPorts();
            while (it5.hasNext()) {
                String portName;
                Export newPp;
                pp = (Export)it5.next();
                NodeInst subNi = pp.getOriginalPort().getNodeInst();
                newNi = (NodeInst)newNodes.get(subNi);
                if (newNi == null) continue;
                PortInst pi = newNi.findPortInstFromProto(pp.getOriginalPort().getPortProto());
                boolean alreadyDone = false;
                Iterator eIt = newNi.getExports();
                while (eIt.hasNext()) {
                    Export oPp = (Export)eIt.next();
                    if (oPp.getOriginalPort() != pi) continue;
                    alreadyDone = true;
                    break;
                }
                if (alreadyDone || (newPp = Export.newInstance(cell, pi, portName = ElectricObject.uniqueObjectName(pp.getName(), cell, class$com$sun$electric$database$prototype$PortProto == null ? CircuitChanges.class$("com.sun.electric.database.prototype.PortProto") : class$com$sun$electric$database$prototype$PortProto))) == null) continue;
                newPp.setCharacteristic(pp.getCharacteristic());
                newPp.copyTextDescriptorFrom(pp, Export.EXPORT_NAME_TD);
                newPp.copyVarsFrom(pp);
            }
        }
        CircuitChanges.eraseNodeInst(topno);
    }

    public static void cleanupPinsCommand(boolean everywhere) {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        Highlighter highlighter = wf.getContent().getHighlighter();
        if (highlighter == null) {
            return;
        }
        if (everywhere) {
            boolean cleaned = false;
            Iterator it = Library.getCurrent().getCells();
            while (it.hasNext()) {
                Cell cell = (Cell)it.next();
                if (!CircuitChanges.cleanupCell(cell, false, highlighter)) continue;
                cleaned = true;
            }
            if (!cleaned) {
                System.out.println("Nothing to clean");
            }
        } else {
            Cell cell = WindowFrame.needCurCell();
            if (cell == null) {
                return;
            }
            CircuitChanges.cleanupCell(cell, true, highlighter);
        }
    }

    private static boolean cleanupCell(Cell cell, boolean justThis, Highlighter highlighter) {
        ArrayList<NodeInst> pinsToRemove = new ArrayList<NodeInst>();
        List pinsToPassThrough = CircuitChanges.getPinsToPassThrough(cell);
        Iterator it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = (NodeInst)it.next();
            if (ni.getFunction() != PrimitiveNode.Function.PIN || ni.getNumExports() > 0 || ni.getNumConnections() != 0) continue;
            boolean hasDisplayable = false;
            Iterator vIt = ni.getVariables();
            while (vIt.hasNext()) {
                Variable var = (Variable)vIt.next();
                if (!var.isDisplay()) continue;
                hasDisplayable = true;
                break;
            }
            if (hasDisplayable) continue;
            pinsToRemove.add(ni);
        }
        HashMap<NodeInst, Point2D.Double> pinsToScale = new HashMap<NodeInst, Point2D.Double>();
        Iterator it2 = cell.getNodes();
        while (it2.hasNext()) {
            double overSizeY;
            NodeInst ni = (NodeInst)it2.next();
            if (ni.getFunction() != PrimitiveNode.Function.PIN) continue;
            double overSizeX = ni.getXSize() - ni.getProto().getDefWidth();
            if (overSizeX < 0.0) {
                overSizeX = 0.0;
            }
            if ((overSizeY = ni.getYSize() - ni.getProto().getDefHeight()) < 0.0) {
                overSizeY = 0.0;
            }
            if (overSizeX == 0.0 && overSizeY == 0.0) continue;
            boolean arcsInCenter = true;
            Iterator cIt = ni.getConnections();
            while (cIt.hasNext()) {
                Connection con = (Connection)cIt.next();
                ArcInst ai = con.getArc();
                if (ai.getHeadPortInst().getNodeInst() == ni) {
                    if (ai.getHeadLocation().getX() != ni.getAnchorCenterX()) {
                        arcsInCenter = false;
                        break;
                    }
                    if (ai.getHeadLocation().getY() != ni.getAnchorCenterY()) {
                        arcsInCenter = false;
                        break;
                    }
                }
                if (ai.getTailPortInst().getNodeInst() != ni) continue;
                if (ai.getTailLocation().getX() != ni.getAnchorCenterX()) {
                    arcsInCenter = false;
                    break;
                }
                if (ai.getTailLocation().getY() == ni.getAnchorCenterY()) continue;
                arcsInCenter = false;
                break;
            }
            if (!arcsInCenter) continue;
            double overSizeArc = 0.0;
            Iterator cIt2 = ni.getConnections();
            while (cIt2.hasNext()) {
                Connection con = (Connection)cIt2.next();
                ArcInst ai = con.getArc();
                double overSize = ai.getWidth() - ai.getProto().getDefaultWidth();
                if (overSize < 0.0) {
                    overSize = 0.0;
                }
                if (!(overSize > overSizeArc)) continue;
                overSizeArc = overSize;
            }
            if (overSizeArc >= overSizeX && overSizeArc >= overSizeY) continue;
            double dSX = 0.0;
            double dSY = 0.0;
            if (overSizeArc < overSizeX) {
                dSX = overSizeX - overSizeArc;
            }
            if (overSizeArc < overSizeY) {
                dSY = overSizeY - overSizeArc;
            }
            pinsToScale.put(ni, new Point2D.Double(-dSX, -dSY));
        }
        ArrayList<NodeInst> textToMove = new ArrayList<NodeInst>();
        Iterator it3 = cell.getNodes();
        while (it3.hasNext()) {
            NodeInst ni = (NodeInst)it3.next();
            Point2D pt = ni.invisiblePinWithOffsetText(false);
            if (pt == null) continue;
            textToMove.add(ni);
        }
        int overSizePins = 0;
        Iterator it4 = cell.getNodes();
        while (it4.hasNext()) {
            NodeInst ni = (NodeInst)it4.next();
            if (ni.getFunction() != PrimitiveNode.Function.PIN) continue;
            boolean nodeIsBad = false;
            Iterator cIt = ni.getConnections();
            while (cIt.hasNext()) {
                Connection con = (Connection)cIt.next();
                ArcInst ai = con.getArc();
                double i = ai.getWidth() - ai.getProto().getWidthOffset();
                Poly poly = ai.makePoly(i, Poly.Type.FILLED);
                Iterator oCIt = ni.getConnections();
                while (oCIt.hasNext()) {
                    double oI;
                    Poly oPoly;
                    double dist;
                    Connection oCon = (Connection)oCIt.next();
                    ArcInst oAi = oCon.getArc();
                    if (ai.getArcIndex() <= oAi.getArcIndex() || (dist = poly.separation(oPoly = oAi.makePoly(oI = oAi.getWidth() - oAi.getProto().getWidthOffset(), Poly.Type.FILLED))) <= 0.0) continue;
                    nodeIsBad = true;
                    break;
                }
                if (!nodeIsBad) continue;
                break;
            }
            if (!nodeIsBad) continue;
            if (justThis) {
                highlighter.addElectricObject(ni, cell);
            }
            ++overSizePins;
        }
        HashSet<ArcInst> arcsToKill = new HashSet<ArcInst>();
        for (int i = cell.getNumArcs() - 1; i >= 0; --i) {
            ArcInst ai = cell.getArc(i);
            if (arcsToKill.contains(ai)) continue;
            PortInst pi = ai.getHeadPortInst();
            Iterator it5 = pi.getConnections();
            while (it5.hasNext()) {
                int otherEnd;
                PortInst oPi;
                Connection con = (Connection)it5.next();
                ArcInst oAi = con.getArc();
                if (oAi.getArcIndex() >= i || ai.getProto() != oAi.getProto() || (oPi = oAi.getPortInst(otherEnd = 1 - con.getEndIndex())) != ai.getTailPortInst()) continue;
                arcsToKill.add(oAi);
            }
        }
        int zeroSize = 0;
        int negSize = 0;
        Iterator it6 = cell.getNodes();
        while (it6.hasNext()) {
            NodeInst ni = (NodeInst)it6.next();
            if (ni.getProto() == Generic.tech.cellCenterNode || ni.getProto() == Generic.tech.invisiblePinNode || ni.getProto() == Generic.tech.universalPinNode || ni.getProto() == Generic.tech.essentialBoundsNode) continue;
            SizeOffset so = ni.getSizeOffset();
            double sX = ni.getXSize() - so.getLowXOffset() - so.getHighXOffset();
            double sY = ni.getYSize() - so.getLowYOffset() - so.getHighYOffset();
            if (sX > 0.0 && sY > 0.0) continue;
            if (justThis) {
                highlighter.addElectricObject(ni, cell);
            }
            if (sX < 0.0 || sY < 0.0) {
                ++negSize;
                continue;
            }
            ++zeroSize;
        }
        if (pinsToRemove.size() == 0 && pinsToPassThrough.size() == 0 && pinsToScale.size() == 0 && zeroSize == 0 && negSize == 0 && textToMove.size() == 0 && overSizePins == 0 && arcsToKill.size() == 0) {
            if (justThis) {
                System.out.println("Nothing to clean");
            }
            return false;
        }
        CleanupChanges job = new CleanupChanges(cell, justThis, pinsToRemove, pinsToPassThrough, pinsToScale, textToMove, arcsToKill, zeroSize, negSize, overSizePins);
        job.startJob();
        return true;
    }

    private static List getPinsToPassThrough(Cell cell) {
        ArrayList<Reconnect> pinsToPassThrough = new ArrayList<Reconnect>();
        Iterator it = cell.getNodes();
        while (it.hasNext()) {
            Reconnect re;
            NodeInst ni = (NodeInst)it.next();
            if (ni.getFunction() != PrimitiveNode.Function.PIN || ni.getNumExports() > 0 || !ni.isInlinePin() || (re = Reconnect.erasePassThru(ni, false)) == null) continue;
            pinsToPassThrough.add(re);
        }
        return pinsToPassThrough;
    }

    public static void showNonmanhattanCommand() {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        Highlighter highlighter = wf.getContent().getHighlighter();
        if (highlighter == null) {
            return;
        }
        HashSet<Cell> cellsSeen = new HashSet<Cell>();
        Iterator lIt = Library.getLibraries();
        while (lIt.hasNext()) {
            Library lib = (Library)lIt.next();
            Iterator cIt = lib.getCells();
            while (cIt.hasNext()) {
                Cell cell = (Cell)cIt.next();
                Iterator aIt = cell.getArcs();
                while (aIt.hasNext()) {
                    ArcInst ai = (ArcInst)aIt.next();
                    ArcProto ap = ai.getProto();
                    if (ap.getTechnology() == Generic.tech || ap.getTechnology() == Artwork.tech || ap.getTechnology() == Schematics.tech) continue;
                    Variable var = ai.getVar(ArcInst.ARC_RADIUS);
                    if (var != null) {
                        cellsSeen.add(cell);
                    }
                    if (ai.getHeadLocation().getX() == ai.getTailLocation().getX() || ai.getHeadLocation().getY() == ai.getTailLocation().getY()) continue;
                    cellsSeen.add(cell);
                }
                Iterator nIt = cell.getNodes();
                while (nIt.hasNext()) {
                    NodeInst ni = (NodeInst)nIt.next();
                    if (ni.getAngle() % 900 == 0) continue;
                    cellsSeen.add(cell);
                }
            }
        }
        int i = 0;
        Iterator aIt = curCell.getArcs();
        while (aIt.hasNext()) {
            ArcInst ai = (ArcInst)aIt.next();
            ArcProto ap = ai.getProto();
            if (ap.getTechnology() == Generic.tech || ap.getTechnology() == Artwork.tech || ap.getTechnology() == Schematics.tech) continue;
            boolean nonMan = false;
            Variable var = ai.getVar(ArcInst.ARC_RADIUS);
            if (var != null) {
                nonMan = true;
            }
            if (ai.getHeadLocation().getX() != ai.getTailLocation().getX() && ai.getHeadLocation().getY() != ai.getTailLocation().getY()) {
                nonMan = true;
            }
            if (!nonMan) continue;
            if (i == 0) {
                highlighter.clear();
            }
            highlighter.addElectricObject(ai, curCell);
            ++i;
        }
        Iterator nIt = curCell.getNodes();
        while (nIt.hasNext()) {
            NodeInst ni = (NodeInst)nIt.next();
            if (ni.getAngle() % 900 == 0) continue;
            if (i == 0) {
                highlighter.clear();
            }
            highlighter.addElectricObject(ni, curCell);
            ++i;
        }
        if (i == 0) {
            System.out.println("No nonmanhattan objects in this cell");
        } else {
            highlighter.finished();
            System.out.println(i + " objects are not manhattan in this cell");
        }
        Iterator lIt2 = Library.getLibraries();
        while (lIt2.hasNext()) {
            Library lib = (Library)lIt2.next();
            if (lib.isHidden()) continue;
            int numBad = 0;
            Iterator cIt = lib.getCells();
            while (cIt.hasNext()) {
                Cell cell = (Cell)cIt.next();
                if (!cellsSeen.contains(cell) || cell == curCell) continue;
                ++numBad;
            }
            if (numBad == 0) continue;
            if (lib == Library.getCurrent()) {
                int cellsFound = 0;
                String infstr = "";
                Iterator cIt2 = lib.getCells();
                while (cIt2.hasNext()) {
                    Cell cell = (Cell)cIt2.next();
                    if (cell == curCell || !cellsSeen.contains(cell)) continue;
                    if (cellsFound > 0) {
                        infstr = infstr + " ";
                    }
                    infstr = infstr + cell.describe(true);
                    ++cellsFound;
                }
                if (cellsFound == 1) {
                    System.out.println("Found nonmanhattan geometry in cell " + infstr);
                    continue;
                }
                System.out.println("Found nonmanhattan geometry in these cells: " + infstr);
                continue;
            }
            System.out.println("Found nonmanhattan geometry in " + lib);
        }
    }

    public static void showPureLayerCommand() {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        Highlighter highlighter = wf.getContent().getHighlighter();
        if (highlighter == null) {
            return;
        }
        int i = 0;
        Iterator nIt = curCell.getNodes();
        while (nIt.hasNext()) {
            NodeInst ni = (NodeInst)nIt.next();
            if (ni.getFunction() != PrimitiveNode.Function.NODE) continue;
            if (i == 0) {
                highlighter.clear();
            }
            highlighter.addElectricObject(ni, curCell);
            ++i;
        }
        if (i == 0) {
            System.out.println("No pure layer nodes in this cell");
        } else {
            highlighter.finished();
            System.out.println(i + " pure layer nodes in this cell");
        }
    }

    public static void shortenArcsCommand() {
        ShortenArcs job = new ShortenArcs(MenuCommands.getSelectedObjects(false, true));
    }

    public static void newVersionOfCell(Cell cell) {
        int status = Project.getCellStatus(cell);
        if (status != 0) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "This cell is part of a project.  To get a new version of it, check it out.", "Cannot Make New Version", 0);
            return;
        }
        NewCellVersion job = new NewCellVersion(cell);
    }

    public static void duplicateCell(Cell cell, String newName) {
        DuplicateCell job = new DuplicateCell(cell, newName);
    }

    public static void manyMove(double dX, double dY) {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        Highlighter highlighter = wf.getContent().getHighlighter();
        if (highlighter == null) {
            return;
        }
        List highlighted = highlighter.getHighlights();
        int nonCellCenterCount = 0;
        Highlight cellCenterHighlight = null;
        Iterator it = highlighted.iterator();
        while (it.hasNext()) {
            Highlight h = (Highlight)it.next();
            if (h.getType() != Highlight.Type.EOBJ) continue;
            ElectricObject eObj = h.getElectricObject();
            if (eObj instanceof NodeInst) {
                NodeInst ni = (NodeInst)eObj;
                if (ni.getProto() == Generic.tech.cellCenterNode) {
                    cellCenterHighlight = h;
                    continue;
                }
                ++nonCellCenterCount;
                continue;
            }
            ++nonCellCenterCount;
        }
        if (cellCenterHighlight != null && nonCellCenterCount != 0) {
            System.out.println("Cannot move the Cell-center along with other objects.  Cell-center will not be moved.");
            highlighted.remove(cellCenterHighlight);
        }
        List highlightedText = highlighter.getHighlightedText(true);
        ManyMove job = new ManyMove(highlighted, highlightedText, dX, dY);
    }

    public static void spreadCircuitry(Cell cell, NodeInst ni, char direction, double amount, double lX, double hX, double lY, double hY) {
        double yC1;
        double xC1;
        if (CircuitChanges.cantEdit(cell, null, true) != 0) {
            return;
        }
        HashSet<Geometric> geomSeen = new HashSet<Geometric>();
        boolean mustBeHor = true;
        if (direction == 'l' || direction == 'r') {
            mustBeHor = false;
        }
        if (ni != null) {
            CircuitChanges.manhattanTravel(ni, mustBeHor, geomSeen);
        }
        Iterator it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst oNi = (NodeInst)it.next();
            SizeOffset oSo = oNi.getSizeOffset();
            if (direction == 'l' || direction == 'r') {
                if (oNi.getTrueCenterX() - oNi.getXSize() / 2.0 + oSo.getLowXOffset() < lX && oNi.getTrueCenterX() + oNi.getXSize() / 2.0 - oSo.getHighXOffset() > hX) {
                    geomSeen.add(oNi);
                }
                if (oNi.getTrueCenterX() != (lX + hX) / 2.0) continue;
                geomSeen.add(oNi);
                continue;
            }
            if (oNi.getTrueCenterY() - oNi.getYSize() / 2.0 + oSo.getLowYOffset() < lY && oNi.getTrueCenterY() + oNi.getYSize() / 2.0 - oSo.getHighYOffset() > hY) {
                geomSeen.add(oNi);
            }
            if (oNi.getTrueCenterY() != (lY + hY) / 2.0) continue;
            geomSeen.add(oNi);
        }
        it = cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            NodeInst no1 = ai.getTailPortInst().getNodeInst();
            NodeInst no2 = ai.getHeadPortInst().getNodeInst();
            xC1 = no1.getTrueCenterX();
            yC1 = no1.getTrueCenterY();
            double xC2 = no2.getTrueCenterX();
            double yC2 = no2.getTrueCenterY();
            if (geomSeen.contains(no2)) {
                NodeInst swapNi = no1;
                no1 = no2;
                no2 = swapNi;
                double swap = xC1;
                xC1 = xC2;
                xC2 = swap;
                swap = yC1;
                yC1 = yC2;
                yC2 = swap;
            }
            if (geomSeen.contains(no2)) continue;
            boolean i = true;
            if (geomSeen.contains(no1)) {
                switch (direction) {
                    case 'l': {
                        if (!(xC2 <= lX)) break;
                        i = false;
                        break;
                    }
                    case 'r': {
                        if (!(xC2 >= hX)) break;
                        i = false;
                        break;
                    }
                    case 'u': {
                        if (!(yC2 >= hY)) break;
                        i = false;
                        break;
                    }
                    case 'd': {
                        if (!(yC2 <= lY)) break;
                        i = false;
                    }
                }
            } else {
                switch (direction) {
                    case 'l': {
                        if (xC1 > lX && xC2 <= lX) {
                            i = false;
                            break;
                        }
                        if (!(xC2 > lX) || !(xC1 <= lX)) break;
                        i = false;
                        break;
                    }
                    case 'r': {
                        if (xC1 < hX && xC2 >= hX) {
                            i = false;
                            break;
                        }
                        if (!(xC2 < hX) || !(xC1 >= hX)) break;
                        i = false;
                        break;
                    }
                    case 'u': {
                        if (yC1 > hY && yC2 <= hY) {
                            i = false;
                            break;
                        }
                        if (!(yC2 > hY) || !(yC1 <= hY)) break;
                        i = false;
                        break;
                    }
                    case 'd': {
                        if (yC1 < lY && yC2 >= lY) {
                            i = false;
                            break;
                        }
                        if (!(yC2 < lY) || !(yC1 >= lY)) break;
                        i = false;
                    }
                }
            }
            if (i) continue;
            geomSeen.add(ai);
        }
        boolean moved = false;
        boolean again = true;
        block26: while (again) {
            again = false;
            Iterator it2 = cell.getNodes();
            while (it2.hasNext()) {
                NodeInst oNi = (NodeInst)it2.next();
                if (geomSeen.contains(oNi)) continue;
                xC1 = oNi.getTrueCenterX();
                yC1 = oNi.getTrueCenterY();
                boolean doIt = false;
                switch (direction) {
                    case 'l': {
                        if (!(xC1 < lX)) break;
                        doIt = true;
                        break;
                    }
                    case 'r': {
                        if (!(xC1 > hX)) break;
                        doIt = true;
                        break;
                    }
                    case 'u': {
                        if (!(yC1 > hY)) break;
                        doIt = true;
                        break;
                    }
                    case 'd': {
                        if (!(yC1 < lY)) break;
                        doIt = true;
                    }
                }
                if (!doIt) continue;
                Iterator aIt = cell.getArcs();
                while (aIt.hasNext()) {
                    ArcInst ai = (ArcInst)aIt.next();
                    if (geomSeen.contains(ai)) {
                        Layout.setTempRigid(ai, false);
                        continue;
                    }
                    Layout.setTempRigid(ai, true);
                }
                CircuitChanges.netTravel(oNi, geomSeen);
                switch (direction) {
                    case 'l': {
                        oNi.move(-amount, 0.0);
                        break;
                    }
                    case 'r': {
                        oNi.move(amount, 0.0);
                        break;
                    }
                    case 'u': {
                        oNi.move(0.0, amount);
                        break;
                    }
                    case 'd': {
                        oNi.move(0.0, -amount);
                    }
                }
                moved = true;
                again = true;
                continue block26;
            }
        }
        if (!moved) {
            System.out.println("Nothing changed");
        }
    }

    private static void netTravel(NodeInst ni, HashSet geomSeen) {
        if (geomSeen.contains(ni)) {
            return;
        }
        geomSeen.add(ni);
        Iterator it = ni.getConnections();
        while (it.hasNext()) {
            Connection con = (Connection)it.next();
            ArcInst ai = con.getArc();
            if (geomSeen.contains(ai)) continue;
            CircuitChanges.netTravel(ai.getHeadPortInst().getNodeInst(), geomSeen);
            CircuitChanges.netTravel(ai.getTailPortInst().getNodeInst(), geomSeen);
        }
    }

    private static void manhattanTravel(NodeInst ni, boolean hor, HashSet geomSeen) {
        geomSeen.add(ni);
        Iterator it = ni.getConnections();
        while (it.hasNext()) {
            Connection con = (Connection)it.next();
            ArcInst ai = con.getArc();
            int angle = ai.getAngle();
            if (!hor ? angle != 900 && angle != 2700 : angle != 0 && angle != 1800) continue;
            int otherEnd = 1 - con.getEndIndex();
            NodeInst other = ai.getPortInst(otherEnd).getNodeInst();
            if (geomSeen.contains(other)) continue;
            CircuitChanges.manhattanTravel(other, hor, geomSeen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cell copyRecursively(Cell fromCell, Library toLib, boolean verbose, boolean move, boolean allRelatedViews, boolean copySubCells, boolean useExisting) {
        Cell.setAllowCircularLibraryDependences(true);
        try {
            Cell cell = CircuitChanges.copyRecursively(fromCell, fromCell.getName(), toLib, fromCell.getView(), verbose, move, "", true, allRelatedViews, allRelatedViews, copySubCells, useExisting, new HashSet());
            return cell;
        }
        finally {
            Cell.setAllowCircularLibraryDependences(false);
        }
    }

    private static Cell copyRecursively(Cell fromCell, String toName, Library toLib, View toView, boolean verbose, boolean move, String subDescript, boolean schematicRelatedView, boolean allRelatedViews, boolean allRelatedViewsThisLevel, boolean copySubCells, boolean useExisting, HashSet existing) {
        Cell newFromCell;
        Iterator it;
        NodeProto np;
        Iterator it2;
        Cell copiedCell;
        if (copySubCells && !useExisting) {
            System.out.println("Cross-library copy warning: It makes no sense to copy subcells but not use them");
        }
        Iterator it3 = existing.iterator();
        while (it3.hasNext()) {
            copiedCell = (Cell)it3.next();
            if (!copiedCell.getName().equalsIgnoreCase(toName) || copiedCell.getView() != toView) continue;
            return copiedCell;
        }
        if (copySubCells || fromCell.isSchematic()) {
            boolean found = true;
            block1: while (found) {
                found = false;
                it2 = fromCell.getNodes();
                while (it2.hasNext()) {
                    Cell oNp;
                    Cell cell;
                    NodeInst ni = (NodeInst)it2.next();
                    if (!copySubCells && !ni.isIconOfParent() || !((np = ni.getProto()) instanceof Cell) || (cell = (Cell)np).getLibrary() == toLib || CircuitChanges.inDestLib(cell, existing) || useExisting && toLib.findNodeProto(cell.noLibDescribe()) != null) continue;
                    boolean doCopySchematicView = true;
                    if (ni.isIconOfParent()) {
                        doCopySchematicView = false;
                    }
                    if ((oNp = CircuitChanges.copyRecursively(cell, cell.getName(), toLib, cell.getView(), verbose, move, "subcell ", doCopySchematicView, allRelatedViews, allRelatedViewsThisLevel, copySubCells, useExisting, existing)) == null) {
                        if (move) {
                            System.out.println("Move of sub" + cell + " failed");
                        } else {
                            System.out.println("Copy of sub" + cell + " failed");
                        }
                        return null;
                    }
                    found = true;
                    continue block1;
                }
            }
        }
        if (!allRelatedViewsThisLevel) {
            if (toView == View.ICON && schematicRelatedView && move) {
                boolean found = true;
                block3: while (found) {
                    found = false;
                    it2 = fromCell.getCellGroup().getCells();
                    while (it2.hasNext()) {
                        Cell np2 = (Cell)it2.next();
                        if (np2.getView() != View.SCHEMATIC || CircuitChanges.inDestLib(np2, existing)) continue;
                        Cell oNp = CircuitChanges.copyRecursively(np2, np2.getName(), toLib, np2.getView(), verbose, move, "schematic view ", true, allRelatedViews, false, copySubCells, useExisting, existing);
                        if (oNp == null) {
                            if (move) {
                                System.out.println("Move of schematic view " + np2 + " failed");
                            } else {
                                System.out.println("Copy of schematic view " + np2 + " failed");
                            }
                            return null;
                        }
                        found = true;
                        continue block3;
                    }
                }
            }
        } else {
            Cell oNp;
            boolean found = true;
            Cell fromCellWalk = fromCell;
            block5: while (found) {
                found = false;
                it = fromCellWalk.getCellGroup().getCells();
                while (it.hasNext()) {
                    np = (Cell)it.next();
                    if (!((Cell)np).isIcon() || CircuitChanges.inDestLib((Cell)np, existing)) continue;
                    oNp = CircuitChanges.copyRecursively((Cell)np, ((Cell)np).getName(), toLib, ((Cell)np).getView(), verbose, move, "alternate view ", true, allRelatedViews, false, copySubCells, useExisting, existing);
                    if (oNp == null) {
                        if (move) {
                            System.out.println("Move of alternate view " + np + " failed");
                        } else {
                            System.out.println("Copy of alternate view " + np + " failed");
                        }
                        return null;
                    }
                    found = true;
                    continue block5;
                }
            }
            found = true;
            block7: while (found) {
                found = false;
                it = fromCellWalk.getCellGroup().getCells();
                while (it.hasNext()) {
                    np = (Cell)it.next();
                    if (((Cell)np).isIcon() || CircuitChanges.inDestLib((Cell)np, existing)) continue;
                    oNp = CircuitChanges.copyRecursively((Cell)np, ((Cell)np).getName(), toLib, ((Cell)np).getView(), verbose, move, "alternate view ", true, allRelatedViews, false, copySubCells, useExisting, existing);
                    if (oNp == null) {
                        if (move) {
                            System.out.println("Move of alternate view " + np + " failed");
                        } else {
                            System.out.println("Copy of alternate view " + np + " failed");
                        }
                        return null;
                    }
                    found = true;
                    continue block7;
                }
            }
        }
        it3 = existing.iterator();
        while (it3.hasNext()) {
            copiedCell = (Cell)it3.next();
            if (!copiedCell.getName().equalsIgnoreCase(toName) || copiedCell.getView() != toView) continue;
            return copiedCell;
        }
        String newName = toName;
        if (toView.getAbbreviation().length() > 0) {
            newName = toName + "{" + toView.getAbbreviation() + "}";
        }
        if ((newFromCell = Cell.copyNodeProto(fromCell, toLib, newName, useExisting)) == null) {
            if (move) {
                System.out.println("Move of " + subDescript + fromCell + " failed");
            } else {
                System.out.println("Copy of " + subDescript + fromCell + " failed");
            }
            return null;
        }
        existing.add(newFromCell);
        if (verbose) {
            if (fromCell.getLibrary() != toLib) {
                String msg = "";
                msg = move ? msg + "Moved " : msg + "Copied ";
                msg = msg + subDescript + fromCell.libDescribe() + " to " + toLib;
                System.out.println(msg);
            } else {
                System.out.println("Copied " + subDescript + newFromCell);
            }
        }
        if (move) {
            it = Library.getLibraries();
            while (it.hasNext()) {
                Library lib = (Library)it.next();
                Iterator cIt = lib.getCells();
                while (cIt.hasNext()) {
                    Cell np3 = (Cell)cIt.next();
                    boolean found = true;
                    block12: while (found) {
                        found = false;
                        Iterator nIt = np3.getNodes();
                        while (nIt.hasNext()) {
                            NodeInst ni = (NodeInst)nIt.next();
                            if (ni.getProto() != fromCell) continue;
                            NodeInst replacedNi = ni.replace(newFromCell, false, false);
                            if (replacedNi == null) {
                                System.out.println("Error moving " + ni + " in " + np3);
                                found = false;
                                continue block12;
                            }
                            found = true;
                            continue block12;
                        }
                    }
                }
            }
            CircuitChanges.doKillCell(fromCell);
            fromCell = null;
        }
        return newFromCell;
    }

    private static boolean inDestLib(Cell cell, HashSet existing) {
        Iterator it = existing.iterator();
        while (it.hasNext()) {
            Cell copiedCell = (Cell)it.next();
            if (!copiedCell.getName().equalsIgnoreCase(cell.getName()) || copiedCell.getView() != cell.getView()) continue;
            return true;
        }
        return false;
    }

    public static void expandOneLevelDownCommand() {
        CircuitChanges.DoExpandCommands(false, 1);
    }

    public static void expandFullCommand() {
        CircuitChanges.DoExpandCommands(false, Integer.MAX_VALUE);
    }

    public static void expandSpecificCommand() {
        String obj = JOptionPane.showInputDialog("Number of levels to expand", (Object)"1");
        int levels = TextUtils.atoi(obj);
        CircuitChanges.DoExpandCommands(false, levels);
    }

    public static void unexpandOneLevelUpCommand() {
        CircuitChanges.DoExpandCommands(true, 1);
    }

    public static void unexpandFullCommand() {
        CircuitChanges.DoExpandCommands(true, Integer.MAX_VALUE);
    }

    public static void unexpandSpecificCommand() {
        String obj = JOptionPane.showInputDialog("Number of levels to unexpand", (Object)"1");
        int levels = TextUtils.atoi(obj);
        CircuitChanges.DoExpandCommands(true, levels);
    }

    public static void peekCommand() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        if (highlighter == null) {
            return;
        }
        Rectangle2D bounds = highlighter.getHighlightedArea(wnd);
        if (bounds == null) {
            System.out.println("Must define an area in which to display");
            return;
        }
        wnd.repaintContents(bounds, true);
    }

    private static void DoExpandCommands(boolean unExpand, int amount) {
        List list = MenuCommands.getSelectedObjects(true, false);
        ExpandUnExpand job = new ExpandUnExpand(list, unExpand, amount);
    }

    private static void doExpand(NodeInst ni, int amount, int sofar) {
        NodeProto np;
        if (!ni.isExpanded()) {
            ni.setExpanded();
            if (++sofar >= amount) {
                return;
            }
        }
        if (!((np = ni.getProto()) instanceof Cell)) {
            return;
        }
        Cell cell = (Cell)np;
        Iterator it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst subNi = (NodeInst)it.next();
            NodeProto subNp = subNi.getProto();
            if (!(subNp instanceof Cell)) continue;
            Cell subCell = (Cell)subNp;
            if (subNi.isIconOfParent()) continue;
            CircuitChanges.doExpand(subNi, amount, sofar);
        }
    }

    private static void doUnExpand(NodeInst ni) {
        if (!ni.isExpanded()) {
            return;
        }
        NodeProto np = ni.getProto();
        if (!(np instanceof Cell)) {
            return;
        }
        Cell cell = (Cell)np;
        Iterator it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst subNi = (NodeInst)it.next();
            NodeProto subNp = subNi.getProto();
            if (!(subNp instanceof Cell) || subNi.isIconOfParent() || !subNi.isExpanded()) continue;
            CircuitChanges.doUnExpand(subNi);
        }
        if (expandFlagBit.contains(ni)) {
            ni.clearExpanded();
        }
    }

    private static int setUnExpand(NodeInst ni, int amount) {
        expandFlagBit.remove(ni);
        if (!ni.isExpanded()) {
            return 0;
        }
        NodeProto np = ni.getProto();
        int depth = 0;
        if (np instanceof Cell) {
            Cell cell = (Cell)np;
            Iterator it = cell.getNodes();
            while (it.hasNext()) {
                NodeInst subNi = (NodeInst)it.next();
                NodeProto subNp = subNi.getProto();
                if (!(subNp instanceof Cell) || subNi.isIconOfParent() || !subNi.isExpanded()) continue;
                depth = Math.max(depth, CircuitChanges.setUnExpand(subNi, amount));
            }
            if (depth < amount) {
                expandFlagBit.add(ni);
            }
        }
        return depth + 1;
    }

    public static NodeInst replaceNodeInst(NodeInst oldNi, NodeProto newNp, boolean ignorePortNames, boolean allowMissingPorts) {
        NodeInst newNi = oldNi.replace(newNp, ignorePortNames, allowMissingPorts);
        if (newNi != null) {
            if (newNp instanceof PrimitiveNode) {
                Iterator it = newNi.getVariables();
                while (it.hasNext()) {
                    Variable var = (Variable)it.next();
                    Variable.Key key = var.getKey();
                    if (key == NodeInst.TRACE || PossibleVariables.validKey(key, (PrimitiveNode)newNp)) continue;
                    newNi.delVar(var.getKey());
                }
            }
            CircuitChanges.inheritAttributes(newNi, true);
        }
        return newNi;
    }

    public static void inheritAttributes(NodeInst ni, boolean cleanUp) {
        Variable var;
        Iterator it;
        NodeProto np = ni.getProto();
        if (np instanceof PrimitiveNode) {
            return;
        }
        Cell cell = (Cell)np;
        Iterator it2 = cell.getVariables();
        while (it2.hasNext()) {
            Variable var2 = (Variable)it2.next();
            if (!var2.getTextDescriptor().isInherit()) continue;
            CircuitChanges.inheritCellAttribute(var2, ni, cell, null);
        }
        it2 = cell.getPorts();
        while (it2.hasNext()) {
            Export pp = (Export)it2.next();
            CircuitChanges.inheritExportAttributes(pp, ni, cell);
        }
        Cell cNp = cell.contentsView();
        if (cNp != null) {
            NodeInst icon = null;
            it = cNp.getNodes();
            while (it.hasNext() && (icon = (NodeInst)it.next()).getProto() != cell) {
                icon = null;
            }
            if (icon == ni) {
                icon = null;
            }
            it = cNp.getVariables();
            while (it.hasNext()) {
                var = (Variable)it.next();
                if (!var.getTextDescriptor().isInherit()) continue;
                CircuitChanges.inheritCellAttribute(var, ni, cNp, icon);
            }
            it = cNp.getPorts();
            while (it.hasNext()) {
                Export cpp = (Export)it.next();
                CircuitChanges.inheritExportAttributes(cpp, ni, cNp);
            }
        }
        if (cleanUp) {
            if (cNp == null) {
                cNp = cell;
            }
            boolean found = true;
            block5: while (found) {
                found = false;
                it = ni.getVariables();
                while (it.hasNext()) {
                    var = (Variable)it.next();
                    if (!var.isParam()) continue;
                    Variable oVar = null;
                    Iterator oIt = cNp.getVariables();
                    boolean delete = true;
                    while (oIt.hasNext()) {
                        oVar = (Variable)oIt.next();
                        if (!oVar.isParam() || !oVar.getKey().equals(var.getKey())) continue;
                        delete = false;
                        break;
                    }
                    if (!delete) continue;
                    ni.delVar(var.getKey());
                    found = true;
                    continue block5;
                }
            }
        }
    }

    private static void inheritExportAttributes(Export pp, NodeInst ni, Cell np) {
        Iterator it = pp.getVariables();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            if (!var.getTextDescriptor().isInherit()) continue;
            Variable.Key attrKey = var.getKey();
            PortInst pi = ni.findPortInstFromProto(pp);
            Variable newVar = pi.getVar(attrKey);
            if (newVar != null || (newVar = pi.newVar(attrKey, CircuitChanges.inheritAddress(pp, var))) == null) continue;
            double lambda = 1.0;
            MutableTextDescriptor descript = new MutableTextDescriptor();
            descript.setDisplay(false);
            var.setTextDescriptor(descript);
            double dX = descript.getXOff();
            double dY = descript.getYOff();
        }
    }

    private static void inheritCellAttribute(Variable var, NodeInst ni, Cell np, NodeInst icon) {
        Variable.Key key = var.getKey();
        Variable newVar = ni.getVar(key.getName());
        if (newVar != null) {
            if (!var.getTextDescriptor().isInterior()) {
                if (!newVar.isDisplay()) {
                    newVar.setDisplay(true);
                }
            } else if (newVar.isDisplay() && var.describe(-1).equals(newVar.describe(-1))) {
                newVar.setDisplay(false);
            }
        } else {
            newVar = ni.updateVar(var.getKey(), CircuitChanges.inheritAddress(np, var));
            CircuitChanges.updateInheritedVar(newVar, ni, np, icon);
        }
    }

    public static void updateInheritedVar(Variable nivar, NodeInst ni, Cell np, NodeInst icon) {
        Variable posVar;
        if (nivar == null) {
            return;
        }
        Variable var = posVar = np.getVar(nivar.getKey().getName());
        if (icon != null) {
            Iterator it = icon.getVariables();
            while (it.hasNext()) {
                Variable ivar = (Variable)it.next();
                if (!ivar.getKey().equals(nivar.getKey())) continue;
                posVar = ivar;
                break;
            }
        }
        double xc = posVar.getXOff();
        if (posVar == var) {
            xc -= np.getBounds().getCenterX();
        }
        double yc = posVar.getYOff();
        if (posVar == var) {
            yc -= np.getBounds().getCenterY();
        }
        nivar.setDisplay(posVar.isDisplay());
        nivar.setInherit(false);
        nivar.setOff(xc, yc);
        nivar.setParam(posVar.isParam());
        if (posVar.isParam()) {
            nivar.setInterior(false);
            nivar.setDispPart(posVar.getDispPart());
            nivar.setPos(posVar.getPos());
            nivar.setRotation(posVar.getRotation());
            nivar.setBold(posVar.isBold());
            nivar.setItalic(posVar.isItalic());
            nivar.setUnderline(posVar.isUnderline());
            nivar.setFace(posVar.getFace());
            TextDescriptor.Size s = posVar.getSize();
            if (s.isAbsolute()) {
                nivar.setAbsSize((int)s.getSize());
            } else {
                nivar.setRelSize(s.getSize());
            }
        }
        nivar.setCode(posVar.getCode());
    }

    private static Object inheritAddress(ElectricObject addr, Variable var) {
        int i;
        Object obj = var.getObject();
        if (!(obj instanceof String)) {
            return obj;
        }
        if (var.isCode()) {
            return obj;
        }
        String str = (String)obj;
        int plusPlusPos = str.indexOf("++");
        int minusMinusPos = str.indexOf("--");
        if (plusPlusPos < 0 && minusMinusPos < 0) {
            return obj;
        }
        int incrPoint = Math.max(plusPlusPos, minusMinusPos);
        String retVal = str.substring(0, incrPoint) + str.substring(incrPoint + 2);
        for (i = incrPoint - 1; i > 0 && TextUtils.isDigit(str.charAt(i)); --i) {
        }
        int curVal = TextUtils.atoi(str.substring(++i));
        curVal = str.charAt(incrPoint) == '+' ? ++curVal : --curVal;
        String newIncrString = str.substring(0, i) + curVal + str.substring(incrPoint + 2);
        addr.newVar(var.getKey(), (Object)newIncrString);
        return retVal;
    }

    public static void changeCurrentLibraryCommand() {
        ChangeCurrentLib.showDialog();
    }

    public static void listLibrariesCommand() {
        System.out.println("----- Libraries: -----");
        int k = 0;
        Iterator it = Library.getVisibleLibraries().iterator();
        while (it.hasNext()) {
            Cell subCell;
            NodeInst ni;
            Iterator nIt;
            Cell cell;
            Iterator cIt;
            Library lib = (Library)it.next();
            if (lib.isHidden()) continue;
            StringBuffer infstr = new StringBuffer();
            infstr.append(lib.getName());
            if (lib.isChanged()) {
                infstr.append("*");
                ++k;
            }
            if (lib.getLibFile() != null) {
                infstr.append(" (disk file: " + lib.getLibFile() + ")");
            }
            System.out.println(infstr.toString());
            HashSet<String> dummyLibs = new HashSet<String>();
            HashSet<Library> markedLibs = new HashSet<Library>();
            Iterator cIt2 = lib.getCells();
            while (cIt2.hasNext()) {
                Cell cell2 = (Cell)cIt2.next();
                Iterator nIt2 = cell2.getNodes();
                while (nIt2.hasNext()) {
                    NodeInst ni2 = (NodeInst)nIt2.next();
                    if (!(ni2.getProto() instanceof Cell)) continue;
                    Cell subCell2 = (Cell)ni2.getProto();
                    Variable var = subCell2.getVar(LibraryFiles.IO_TRUE_LIBRARY, class$java$lang$String == null ? CircuitChanges.class$("java.lang.String") : class$java$lang$String);
                    if (var != null) {
                        String pt = (String)var.getObject();
                        dummyLibs.add(pt);
                    }
                    markedLibs.add(subCell2.getLibrary());
                }
            }
            Iterator lIt = Library.getLibraries();
            while (lIt.hasNext()) {
                Library oLib = (Library)lIt.next();
                if (oLib == lib || !markedLibs.contains(oLib)) continue;
                System.out.println("   Makes use of cells in " + oLib);
                infstr = new StringBuffer();
                infstr.append("      These cells make reference to that library:");
                cIt = lib.getCells();
                while (cIt.hasNext()) {
                    cell = (Cell)cIt.next();
                    boolean found = false;
                    nIt = cell.getNodes();
                    while (nIt.hasNext()) {
                        ni = (NodeInst)nIt.next();
                        if (!(ni.getProto() instanceof Cell) || (subCell = (Cell)ni.getProto()).getLibrary() != oLib) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    infstr.append(" " + cell.noLibDescribe());
                }
                System.out.println(infstr.toString());
            }
            Iterator dIt = dummyLibs.iterator();
            while (dIt.hasNext()) {
                String dummyLibName = (String)dIt.next();
                System.out.println("   Has dummy cells that should be in library " + dummyLibName);
                infstr = new StringBuffer();
                infstr.append("      Instances of these dummy cells are in:");
                cIt = lib.getCells();
                while (cIt.hasNext()) {
                    cell = (Cell)cIt.next();
                    boolean found = false;
                    nIt = cell.getNodes();
                    while (nIt.hasNext()) {
                        ni = (NodeInst)nIt.next();
                        if (!(ni.getProto() instanceof Cell)) continue;
                        subCell = (Cell)ni.getProto();
                        Variable var = subCell.getVar(LibraryFiles.IO_TRUE_LIBRARY, class$java$lang$String == null ? CircuitChanges.class$("java.lang.String") : class$java$lang$String);
                        if (var == null || !((String)var.getObject()).equals(dummyLibName)) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    infstr.append(" " + cell.noLibDescribe());
                }
                System.out.println(infstr.toString());
            }
        }
        if (k != 0) {
            System.out.println("   (* means library has changed)");
        }
    }

    public static void renameCurrentTechnology() {
        Technology tech = Technology.getCurrent();
        String techName = tech.getTechName();
        String val = JOptionPane.showInputDialog("New Name of Technology " + techName + ":", (Object)techName);
        if (val == null) {
            return;
        }
        if (val.equals(techName)) {
            return;
        }
        RenameTechnology job = new RenameTechnology(tech, val);
    }

    public static void renameLibrary(Library lib) {
        String val = JOptionPane.showInputDialog("New Name of Library:", (Object)lib.getName());
        if (val == null) {
            return;
        }
        RenameLibrary job = new RenameLibrary(lib, val);
    }

    public static void markAllLibrariesForSavingCommand() {
        Iterator it = Library.getLibraries();
        while (it.hasNext()) {
            String ext;
            Library lib = (Library)it.next();
            if (lib.isHidden() || (ext = TextUtils.getExtension(lib.getLibFile())).equals("txt")) continue;
            lib.setChanged();
        }
        System.out.println("All libraries now need to be saved");
    }

    public static void checkAndRepairCommand(boolean repair) {
        new CheckAndRepairJob(repair);
    }

    public static void removeUnusedLayers(Library lib) {
    }

    public static int cantEdit(Cell cell, NodeInst item, boolean giveError) {
        int ret;
        Object[] options = new String[]{"Yes", "No", "Always", "Cancel"};
        if (item != null) {
            if (item.isLocked()) {
                if (!giveError) {
                    return 1;
                }
                ret = JOptionPane.showOptionDialog(TopLevel.getCurrentJFrame(), "Changes to locked " + item + " are disallowed.  Change anyway?", "Allow changes", -1, 2, null, options, options[1]);
                if (ret == 1) {
                    return 1;
                }
                if (ret == 2) {
                    item.clearLocked();
                }
                if (ret == 3 || ret == -1) {
                    return -1;
                }
            }
            boolean complexNode = false;
            if (item.getProto() instanceof PrimitiveNode) {
                PrimitiveNode.Function fun;
                if (((PrimitiveNode)item.getProto()).isLockedPrim() && User.isDisallowModificationLockedPrims()) {
                    if (!giveError) {
                        return 1;
                    }
                    int ret2 = JOptionPane.showOptionDialog(TopLevel.getCurrentJFrame(), "Changes to locked primitives (such as " + item + ") are disallowed.  Change anyway?", "Allow changes", -1, 2, null, options, options[1]);
                    if (ret2 == 1) {
                        return 1;
                    }
                    if (ret2 == 2) {
                        User.setDisallowModificationLockedPrims(false);
                    }
                    if (ret2 == 3) {
                        return -1;
                    }
                }
                if ((fun = item.getFunction()) != PrimitiveNode.Function.PIN && fun != PrimitiveNode.Function.CONTACT && fun != PrimitiveNode.Function.NODE && fun != PrimitiveNode.Function.CONNECT) {
                    complexNode = true;
                }
            } else {
                complexNode = true;
                if (cell.isInstancesLocked()) {
                    if (!giveError) {
                        return 1;
                    }
                    int ret3 = JOptionPane.showOptionDialog(TopLevel.getCurrentJFrame(), "Modification of instances in " + cell + " is disallowed.  You cannot move " + item + ".  Change anyway?", "Allow changes", -1, 2, null, options, options[1]);
                    if (ret3 == 1) {
                        return 1;
                    }
                    if (ret3 == 2) {
                        cell.clearInstancesLocked();
                    }
                    if (ret3 == 3) {
                        return -1;
                    }
                }
            }
            if (complexNode && User.isDisallowModificationComplexNodes()) {
                if (!giveError) {
                    return 1;
                }
                int ret4 = JOptionPane.showOptionDialog(TopLevel.getCurrentJFrame(), "Changes to complex nodes (such as " + item + ") are disallowed.  Change anyway?", "Allow changes", -1, 2, null, options, options[1]);
                if (ret4 == 1) {
                    return 1;
                }
                if (ret4 == 2) {
                    User.setDisallowModificationComplexNodes(false);
                }
                if (ret4 == 3) {
                    return -1;
                }
            }
        }
        if (cell.isAllLocked()) {
            if (!giveError) {
                return 1;
            }
            ret = JOptionPane.showOptionDialog(TopLevel.getCurrentJFrame(), "Modification of " + cell + " is disallowed.  Change " + (item == null ? "" : item.toString()) + " anyway?", "Allow changes", -1, 2, null, options, options[1]);
            if (ret == 1) {
                return 1;
            }
            if (ret == 2) {
                cell.clearAllLocked();
            }
            if (ret == 3) {
                return -1;
            }
        }
        return 0;
    }

    public static class RemoveUnusedLayers
    extends Job {
        private Library library;

        public RemoveUnusedLayers(Library lib) {
            super("Remove unused metal layers", null, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.library = lib;
            this.startJob();
        }

        public boolean doIt() {
            if (this.library != null) {
                this.cleanUnusedNodesInLibrary(this.library);
                return true;
            }
            Iterator libIter = Library.getLibraries();
            while (libIter.hasNext()) {
                Library lib = (Library)libIter.next();
                this.cleanUnusedNodesInLibrary(lib);
            }
            return true;
        }

        private void cleanUnusedNodesInLibrary(Library lib) {
            int action = -1;
            ArrayList<ArcInst> list = new ArrayList<ArcInst>();
            Iterator cellsIter = lib.getCells();
            while (cellsIter.hasNext()) {
                int i;
                Cell cell = (Cell)cellsIter.next();
                if (cell.getView() != View.LAYOUT) continue;
                list.clear();
                Technology tech = cell.getTechnology();
                for (i = 0; i < cell.getNumArcs(); ++i) {
                    ArcInst ai = cell.getArc(i);
                    ArcProto ap = ai.getProto();
                    if (!ap.isNotUsed()) continue;
                    list.add(ai);
                }
                for (i = 0; i < cell.getNumNodes(); ++i) {
                    NodeInst ni = cell.getNode(i);
                    tech.cleanUnusedNodesInLibrary(ni, list);
                }
                if (action != 3 && list.size() > 0) {
                    Object[] options = new String[]{"Yes", "No", "Cancel", "Yes to All"};
                    action = JOptionPane.showOptionDialog(TopLevel.getCurrentJFrame(), "Remove unused nodes in " + cell.libDescribe(), "Warning", -1, 2, null, options, options[0]);
                    if (action == 2) {
                        return;
                    }
                }
                if (action == 1) continue;
                System.out.println("Removing " + list.size() + " unused nodes in " + cell.libDescribe());
                CircuitChanges.eraseObjectsInList(cell, list);
            }
        }
    }

    private static class CheckAndRepairJob
    extends Job {
        boolean repair;

        protected CheckAndRepairJob(boolean repair) {
            super(repair ? "Repair Libraries" : "Check Libraries", User.getUserTool(), repair ? Job.Type.CHANGE : Job.Type.EXAMINE, null, null, Job.Priority.USER);
            this.repair = repair;
            this.startJob();
        }

        public boolean doIt() {
            if (Library.checkInvariants()) {
                ErrorLogger errorLogger = ErrorLogger.newInstance(this.repair ? "Repair Libraries" : "Check Libraries");
                int errorCount = 0;
                Iterator it = Library.getLibraries();
                while (it.hasNext()) {
                    Library lib = (Library)it.next();
                    errorCount += lib.checkAndRepair(this.repair, errorLogger);
                }
                if (errorCount > 0) {
                    System.out.println("Found " + errorCount + " errors");
                } else {
                    System.out.println("No errors found");
                }
                errorLogger.termLogging(true);
            }
            return true;
        }
    }

    private static class RenameLibrary
    extends Job {
        Library lib;
        String newName;

        protected RenameLibrary(Library lib, String newName) {
            super("Renaming " + lib, User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.lib = lib;
            this.newName = newName;
            this.startJob();
        }

        public boolean doIt() {
            String oldName = this.lib.getName();
            if (this.lib.setName(this.newName)) {
                return false;
            }
            System.out.println("Library '" + oldName + "' renamed to '" + this.newName + "'");
            this.lib.setChanged();
            Iterator it = Library.getLibraries();
            while (it.hasNext()) {
                Library oLib = (Library)it.next();
                if (oLib.isHidden() || oLib == this.lib || oLib.isChanged() || !oLib.referencesLib(this.lib)) continue;
                oLib.setChanged();
            }
            return true;
        }
    }

    private static class RenameTechnology
    extends Job {
        Technology tech;
        String newName;

        protected RenameTechnology(Technology tech, String newName) {
            super("Renaming " + tech, User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.tech = tech;
            this.newName = newName;
            this.startJob();
        }

        public boolean doIt() {
            String oldName = this.tech.getTechName();
            this.tech.setTechName(this.newName);
            System.out.println("Technology '" + oldName + "' renamed to '" + this.newName + "'");
            Iterator it = Library.getLibraries();
            while (it.hasNext()) {
                Library oLib = (Library)it.next();
                if (oLib.isHidden()) continue;
                oLib.setChanged();
            }
            return true;
        }
    }

    private static class PossibleVariables {
        private static HashMap posVarsMap = new HashMap();

        private PossibleVariables() {
        }

        private static void add(String varName, PrimitiveNode pn) {
            Variable.Key key;
            ArrayList<Variable.Key> varKeys = (ArrayList<Variable.Key>)posVarsMap.get(pn);
            if (varKeys == null) {
                varKeys = new ArrayList<Variable.Key>();
                posVarsMap.put(pn, varKeys);
            }
            if (!varKeys.contains(key = Variable.newKey(varName))) {
                varKeys.add(key);
            }
        }

        public Iterator getPossibleVarKeys(PrimitiveNode pn) {
            ArrayList varKeys = (ArrayList)posVarsMap.get(pn);
            if (varKeys == null) {
                varKeys = new ArrayList();
            }
            return varKeys.iterator();
        }

        public static boolean validKey(Variable.Key key, PrimitiveNode pn) {
            List varKeys = (List)posVarsMap.get(pn);
            if (varKeys == null) {
                return false;
            }
            return varKeys.contains(key);
        }

        static {
            PossibleVariables.add("ATTR_length", Schematics.tech.transistorNode);
            PossibleVariables.add("ATTR_length", Schematics.tech.transistor4Node);
            PossibleVariables.add("ATTR_width", Schematics.tech.transistorNode);
            PossibleVariables.add("ATTR_width", Schematics.tech.transistor4Node);
            PossibleVariables.add("ATTR_area", Schematics.tech.transistorNode);
            PossibleVariables.add("ATTR_area", Schematics.tech.transistor4Node);
            PossibleVariables.add("SIM_spice_model", Schematics.tech.sourceNode);
            PossibleVariables.add("SIM_spice_model", Schematics.tech.transistorNode);
            PossibleVariables.add("SIM_spice_model", Schematics.tech.transistor4Node);
            PossibleVariables.add("SCHEM_meter_type", Schematics.tech.meterNode);
            PossibleVariables.add("SCHEM_diode", Schematics.tech.diodeNode);
            PossibleVariables.add("SCHEM_capacitance", Schematics.tech.capacitorNode);
            PossibleVariables.add("SCHEM_resistance", Schematics.tech.resistorNode);
            PossibleVariables.add("SCHEM_inductance", Schematics.tech.inductorNode);
            PossibleVariables.add("SCHEM_function", Schematics.tech.bboxNode);
        }
    }

    private static class ExpandUnExpand
    extends Job {
        List list;
        boolean unExpand;
        int amount;

        protected ExpandUnExpand(List list, boolean unExpand, int amount) {
            super("Change Cell Expansion", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.list = list;
            this.unExpand = unExpand;
            this.amount = amount;
            this.startJob();
        }

        public boolean doIt() {
            NodeInst ni;
            Iterator it;
            expandFlagBit = new HashSet();
            if (this.unExpand) {
                it = this.list.iterator();
                while (it.hasNext()) {
                    ni = (NodeInst)it.next();
                    NodeProto np = ni.getProto();
                    if (!(np instanceof Cell) || !ni.isExpanded()) continue;
                    CircuitChanges.setUnExpand(ni, this.amount);
                }
            }
            it = this.list.iterator();
            while (it.hasNext()) {
                ni = (NodeInst)it.next();
                if (this.unExpand) {
                    CircuitChanges.doUnExpand(ni);
                    continue;
                }
                CircuitChanges.doExpand(ni, this.amount, 0);
            }
            expandFlagBit = null;
            PixelDrawing.clearSubCellCache();
            EditWindow.repaintAllContents();
            return true;
        }
    }

    public static class Reconnect {
        private NodeInst ni;
        private ArrayList reconnectedArcs;

        public static Reconnect erasePassThru(NodeInst ni, boolean allowdiffs) {
            Cell cell = ni.getParent();
            if (CircuitChanges.cantEdit(cell, ni, true) != 0) {
                return null;
            }
            Reconnect recon = new Reconnect();
            recon.ni = ni;
            recon.reconnectedArcs = new ArrayList();
            Iterator it = ni.getPortInsts();
            while (it.hasNext()) {
                PortInst pi = (PortInst)it.next();
                ArrayList<ArcInst> arcs = new ArrayList<ArcInst>();
                Iterator it2 = pi.getConnections();
                while (it2.hasNext()) {
                    Connection conn = (Connection)it2.next();
                    ArcInst ai = conn.getArc();
                    if (ai.getHeadPortInst().getNodeInst() == ai.getTailPortInst().getNodeInst()) continue;
                    arcs.add(ai);
                }
                while (arcs.size() > 1) {
                    ArcInst ai1 = (ArcInst)arcs.remove(0);
                    Iterator it22 = arcs.iterator();
                    while (it22.hasNext()) {
                        ArcInst ai2 = (ArcInst)it22.next();
                        ReconnectedArc ra = Reconnect.reconnectArcs(pi, ai1, ai2, allowdiffs);
                        if (ra == null) continue;
                        recon.reconnectedArcs.add(ra);
                    }
                }
            }
            if (recon.reconnectedArcs.size() == 0) {
                return null;
            }
            return recon;
        }

        private static ReconnectedArc reconnectArcs(PortInst pi, ArcInst ai1, ArcInst ai2, boolean allowdiffs) {
            if (ai1.getProto() != ai2.getProto()) {
                return null;
            }
            ReconnectedArc ra = new ReconnectedArc();
            ra.ap = ai1.getProto();
            ReconnectedArc.access$1102(ra, new PortInst[2]);
            ReconnectedArc.access$1202(ra, new Point2D[2]);
            ReconnectedArc.access$1302(ra, new ArcInst[2]);
            ((ReconnectedArc)ra).reconAr[0] = ai1;
            ((ReconnectedArc)ra).reconAr[1] = ai2;
            Point2D[] orig = new Point2D[2];
            Point2D[] delta = new Point2D[2];
            for (int i = 0; i < 2; ++i) {
                if (ai1.getPortInst(i) != pi) {
                    ((ReconnectedArc)ra).reconPi[0] = ai1.getPortInst(i);
                    ((ReconnectedArc)ra).recon[0] = ai1.getLocation(i);
                } else {
                    orig[0] = ai1.getLocation(i);
                }
                if (ai2.getPortInst(i) != pi) {
                    ((ReconnectedArc)ra).reconPi[1] = ai2.getPortInst(i);
                    ((ReconnectedArc)ra).recon[1] = ai2.getLocation(i);
                    continue;
                }
                orig[1] = ai2.getLocation(i);
            }
            delta[0] = new Point2D.Double(ra.recon[0].getX() - orig[0].getX(), ra.recon[0].getY() - orig[0].getY());
            delta[1] = new Point2D.Double(ra.recon[1].getX() - orig[1].getX(), ra.recon[1].getY() - orig[1].getY());
            if (!allowdiffs) {
                if (ai1.getWidth() != ai2.getWidth()) {
                    return null;
                }
                if (delta[1].getX() * delta[0].getY() != delta[0].getX() * delta[1].getY()) {
                    return null;
                }
                if (delta[0].getX() * delta[1].getX() + delta[0].getY() * delta[1].getY() >= 0.0) {
                    return null;
                }
                if (orig[0].getX() != orig[1].getX() || orig[0].getY() != orig[1].getY()) {
                    if (delta[0].getX() != 0.0 || delta[0].getY() != 0.0) {
                        if ((orig[0].getX() - orig[1].getX()) * delta[0].getY() != delta[0].getX() * (orig[0].getY() - orig[1].getY())) {
                            return null;
                        }
                    } else if (delta[1].getX() != 0.0 || delta[1].getY() != 0.0) {
                        if ((orig[0].getX() - orig[1].getX()) * delta[1].getY() != delta[1].getX() * (orig[0].getY() - orig[1].getY())) {
                            return null;
                        }
                    } else {
                        return null;
                    }
                }
            }
            ra.wid = ai1.getWidth();
            ra.directionalHead = ai1.isHeadArrowed();
            ra.directionalTail = ai1.isTailArrowed();
            ra.directionalBody = ai1.isBodyArrowed();
            ra.extendHead = ai1.isHeadExtended();
            ra.extendTail = ai2.isTailExtended();
            ra.negateHead = ai1.isHeadNegated();
            ra.negateTail = ai2.isTailNegated();
            if (ai1.getName() != null && !ai1.getNameKey().isTempname()) {
                ra.arcName = ai1.getName();
                ra.arcNameTD = ai1.getTextDescriptor(ArcInst.ARC_NAME_TD);
            }
            if (ai2.getName() != null && !ai2.getNameKey().isTempname()) {
                ra.arcName = ai2.getName();
                ra.arcNameTD = ai2.getTextDescriptor(ArcInst.ARC_NAME_TD);
            }
            return ra;
        }

        public List reconnectArcs() {
            ArrayList<ArcInst> newArcs = new ArrayList<ArcInst>();
            Iterator it = this.reconnectedArcs.iterator();
            while (it.hasNext()) {
                ArcInst newAi;
                ReconnectedArc ra = (ReconnectedArc)it.next();
                if (!ra.reconPi[0].getNodeInst().isLinked() || !ra.reconPi[1].getNodeInst().isLinked() || (newAi = ArcInst.makeInstance(ra.ap, ra.wid, ra.reconPi[0], ra.reconPi[1], ra.recon[0], ra.recon[1], null)) == null) continue;
                newAi.setHeadArrowed(ra.directionalHead);
                newAi.setTailArrowed(ra.directionalTail);
                newAi.setBodyArrowed(ra.directionalBody);
                newAi.setHeadExtended(ra.extendHead);
                newAi.setTailExtended(ra.extendTail);
                newAi.setHeadNegated(ra.negateHead);
                newAi.setTailNegated(ra.negateTail);
                if (ra.arcName != null) {
                    newAi.setName(ra.arcName);
                    newAi.setTextDescriptor(ArcInst.ARC_NAME_TD, ra.arcNameTD);
                }
                newAi.copyVarsFrom(ra.reconAr[0]);
                newAi.copyVarsFrom(ra.reconAr[1]);
                newArcs.add(newAi);
            }
            return newArcs;
        }
    }

    private static class ReconnectedArc {
        private PortInst[] reconPi;
        private Point2D[] recon;
        private ArcInst[] reconAr;
        private ArcProto ap;
        private double wid;
        private boolean directionalHead;
        private boolean directionalTail;
        private boolean directionalBody;
        private boolean extendHead;
        private boolean extendTail;
        private boolean negateHead;
        private boolean negateTail;
        private String arcName;
        private TextDescriptor arcNameTD;

        private ReconnectedArc() {
        }

        static /* synthetic */ PortInst[] access$1102(ReconnectedArc x0, PortInst[] x1) {
            x0.reconPi = x1;
            return x1;
        }

        static /* synthetic */ Point2D[] access$1202(ReconnectedArc x0, Point2D[] x1) {
            x0.recon = x1;
            return x1;
        }

        static /* synthetic */ ArcInst[] access$1302(ReconnectedArc x0, ArcInst[] x1) {
            x0.reconAr = x1;
            return x1;
        }
    }

    private static class ManyMove
    extends Job {
        double dX;
        double dY;
        static final boolean verbose = false;
        private List highlighted;
        private List highlightedText;

        protected ManyMove(List highlighted, List highlightedText, double dX, double dY) {
            super("Move", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.dX = dX;
            this.dY = dY;
            this.highlighted = highlighted;
            this.highlightedText = highlightedText;
            this.startJob();
        }

        public boolean doIt() {
            ArcInst ai;
            Highlight h;
            NodeInst ni;
            ArcInst ai2;
            ElectricObject eobj;
            Highlight h2;
            int total = this.highlighted.size();
            if (total <= 0) {
                return false;
            }
            Iterator oit = this.highlighted.iterator();
            Highlight firstH = (Highlight)oit.next();
            ElectricObject firstEObj = firstH.getElectricObject();
            Cell cell = firstH.getCell();
            if (CircuitChanges.cantEdit(cell, null, true) != 0) {
                return false;
            }
            if (total == 1 && firstH.getType() == Highlight.Type.EOBJ && (firstEObj instanceof NodeInst || firstEObj instanceof PortInst)) {
                NodeInst ni2 = firstEObj instanceof PortInst ? ((PortInst)firstEObj).getNodeInst() : (NodeInst)firstEObj;
                if (CircuitChanges.cantEdit(cell, ni2, true) != 0) {
                    return false;
                }
                ni2.move(this.dX, this.dY);
                StatusBar.updateStatusBar();
                return true;
            }
            boolean found = false;
            Iterator it = this.highlighted.iterator();
            while (it.hasNext()) {
                int j;
                h2 = (Highlight)it.next();
                if (h2.getType() != Highlight.Type.EOBJ || !((eobj = h2.getElectricObject()) instanceof ArcInst) || (ai2 = (ArcInst)eobj).getHeadLocation().getX() == ai2.getTailLocation().getX() || ai2.getHeadLocation().getY() == ai2.getTailLocation().getY() || !ai2.isFixedAngle() || ai2.isRigid()) continue;
                for (j = 0; j < 2; ++j) {
                    ni = ai2.getPortInst(j).getNodeInst();
                    ArcInst oai = null;
                    Iterator pIt = ni.getConnections();
                    while (pIt.hasNext()) {
                        Connection con = (Connection)pIt.next();
                        if (con.getArc() == ai2) continue;
                        if (oai == null) {
                            oai = con.getArc();
                            continue;
                        }
                        oai = null;
                        break;
                    }
                    if (oai == null || oai.getHeadLocation().getX() != oai.getTailLocation().getX() && oai.getHeadLocation().getY() != oai.getTailLocation().getY()) break;
                }
                if (j < 2) continue;
                found = true;
                break;
            }
            if (found) {
                it = this.highlighted.iterator();
                while (it.hasNext()) {
                    int j;
                    h2 = (Highlight)it.next();
                    if (h2.getType() != Highlight.Type.EOBJ || !((eobj = h2.getElectricObject()) instanceof ArcInst)) continue;
                    ai2 = (ArcInst)eobj;
                    double[] deltaXs = new double[2];
                    double[] deltaYs = new double[2];
                    NodeInst[] niList = new NodeInst[2];
                    deltaYs[1] = 0.0;
                    deltaXs[1] = 0.0;
                    deltaYs[0] = 0.0;
                    deltaXs[0] = 0.0;
                    int arcangle = ai2.getAngle();
                    for (j = 0; j < 2; ++j) {
                        Point2D iPt;
                        NodeInst ni3;
                        niList[j] = ni3 = ai2.getPortInst(j).getNodeInst();
                        ArcInst oai = null;
                        Iterator pIt = ni3.getConnections();
                        while (pIt.hasNext()) {
                            Connection con = (Connection)pIt.next();
                            if (con.getArc() == ai2) continue;
                            oai = con.getArc();
                            break;
                        }
                        if (oai == null) break;
                        if (DBMath.doublesEqual(oai.getHeadLocation().getX(), oai.getTailLocation().getX())) {
                            iPt = DBMath.intersect(oai.getHeadLocation(), 900, new Point2D.Double(ai2.getHeadLocation().getX() + this.dX, ai2.getHeadLocation().getY() + this.dY), arcangle);
                            if (iPt == null) continue;
                            deltaXs[j] = iPt.getX() - ai2.getLocation(j).getX();
                            deltaYs[j] = iPt.getY() - ai2.getLocation(j).getY();
                            continue;
                        }
                        if (!DBMath.doublesEqual(oai.getHeadLocation().getY(), oai.getTailLocation().getY()) || (iPt = DBMath.intersect(oai.getHeadLocation(), 0, new Point2D.Double(ai2.getHeadLocation().getX() + this.dX, ai2.getHeadLocation().getY() + this.dY), arcangle)) == null) continue;
                        deltaXs[j] = iPt.getX() - ai2.getLocation(j).getX();
                        deltaYs[j] = iPt.getY() - ai2.getLocation(j).getY();
                    }
                    if (j < 2) continue;
                    NodeInst.modifyInstances(niList, deltaXs, deltaYs, null, null);
                }
                StatusBar.updateStatusBar();
                return true;
            }
            boolean onlySlidable = true;
            boolean foundArc = false;
            Iterator it2 = this.highlighted.iterator();
            while (it2.hasNext()) {
                h = (Highlight)it2.next();
                if (h.getType() != Highlight.Type.EOBJ) continue;
                ElectricObject eobj2 = h.getElectricObject();
                if (eobj2 instanceof ArcInst) {
                    ai = (ArcInst)eobj2;
                    foundArc = true;
                    if (ai.isSlidable()) {
                        Point2D.Double newHead = new Point2D.Double(ai.getHeadLocation().getX() + this.dX, ai.getHeadLocation().getY() + this.dY);
                        Point2D.Double newTail = new Point2D.Double(ai.getTailLocation().getX() + this.dX, ai.getTailLocation().getY() + this.dY);
                        if (ai.headStillInPort(newHead, true) && ai.tailStillInPort(newTail, true)) continue;
                    }
                }
                onlySlidable = false;
            }
            if (foundArc && onlySlidable) {
                it2 = this.highlighted.iterator();
                while (it2.hasNext()) {
                    ElectricObject eobj3;
                    h = (Highlight)it2.next();
                    if (h.getType() != Highlight.Type.EOBJ || !((eobj3 = h.getElectricObject()) instanceof ArcInst)) continue;
                    ai = (ArcInst)eobj3;
                    ai.modify(0.0, this.dX, this.dY, this.dX, this.dY);
                }
                StatusBar.updateStatusBar();
                return true;
            }
            HashSet<NodeInst> flag = new HashSet<NodeInst>();
            HashMap<NodeInst, Point2D.Double> nodeLocation = new HashMap<NodeInst, Point2D.Double>();
            Iterator it3 = cell.getNodes();
            while (it3.hasNext()) {
                ni = (NodeInst)it3.next();
                nodeLocation.put(ni, new Point2D.Double(ni.getAnchorCenterX(), ni.getAnchorCenterY()));
            }
            HashMap<ArcInst, Point2D.Double> arcLocation = new HashMap<ArcInst, Point2D.Double>();
            Iterator it4 = cell.getArcs();
            while (it4.hasNext()) {
                ArcInst ai3 = (ArcInst)it4.next();
                arcLocation.put(ai3, new Point2D.Double(ai3.getTrueCenterX(), ai3.getTrueCenterY()));
            }
            it4 = this.highlighted.iterator();
            while (it4.hasNext()) {
                Highlight h3 = (Highlight)it4.next();
                if (h3.getType() != Highlight.Type.EOBJ) continue;
                ElectricObject eobj4 = h3.getElectricObject();
                if (eobj4 instanceof PortInst) {
                    eobj4 = ((PortInst)eobj4).getNodeInst();
                }
                if (eobj4 instanceof NodeInst) {
                    NodeInst ni4 = (NodeInst)eobj4;
                    flag.add(ni4);
                    continue;
                }
                if (!(eobj4 instanceof ArcInst)) continue;
                ArcInst ai4 = (ArcInst)eobj4;
                NodeInst ni1 = ai4.getHeadPortInst().getNodeInst();
                NodeInst ni2 = ai4.getTailPortInst().getNodeInst();
                flag.add(ni1);
                flag.add(ni2);
                Layout.setTempRigid(ai4, true);
            }
            int numNodes = 0;
            Iterator it5 = cell.getNodes();
            while (it5.hasNext()) {
                NodeInst ni5 = (NodeInst)it5.next();
                if (!flag.contains(ni5)) continue;
                int errorCode = CircuitChanges.cantEdit(cell, ni5, true);
                if (errorCode < 0) {
                    return false;
                }
                if (errorCode > 0) {
                    flag.remove(ni5);
                    continue;
                }
                ++numNodes;
            }
            if (numNodes > 0) {
                NodeInst[] nis = new NodeInst[numNodes];
                double[] dXs = new double[numNodes];
                double[] dYs = new double[numNodes];
                numNodes = 0;
                Iterator it6 = cell.getNodes();
                while (it6.hasNext()) {
                    NodeInst ni6 = (NodeInst)it6.next();
                    if (!flag.contains(ni6)) continue;
                    nis[numNodes] = ni6;
                    dXs[numNodes] = this.dX;
                    dYs[numNodes] = this.dY;
                    ++numNodes;
                }
                NodeInst.modifyInstances(nis, dXs, dYs, null, null);
            }
            flag = null;
            it5 = this.highlighted.iterator();
            while (it5.hasNext()) {
                ArcInst ai5;
                Point2D pt;
                ElectricObject eobj5;
                Highlight h4 = (Highlight)it5.next();
                if (h4.getType() != Highlight.Type.EOBJ || !((eobj5 = h4.getElectricObject()) instanceof ArcInst) || (pt = (Point2D)arcLocation.get(ai5 = (ArcInst)eobj5)).getX() != ai5.getTrueCenterX() || pt.getY() != ai5.getTrueCenterY()) continue;
                boolean headInPort = false;
                boolean tailInPort = false;
                if (!ai5.isRigid() && ai5.isSlidable()) {
                    headInPort = ai5.headStillInPort(new Point2D.Double(ai5.getHeadLocation().getX() + this.dX, ai5.getHeadLocation().getY() + this.dY), true);
                    tailInPort = ai5.tailStillInPort(new Point2D.Double(ai5.getTailLocation().getX() + this.dX, ai5.getTailLocation().getY() + this.dY), true);
                }
                if (headInPort && tailInPort) {
                    ai5.modify(0.0, this.dX, this.dY, this.dX, this.dY);
                    continue;
                }
                if (headInPort || tailInPort) continue;
                for (int k = 0; k < 2; ++k) {
                    NodeInst ni7 = k == 0 ? ai5.getHeadPortInst().getNodeInst() : ai5.getTailPortInst().getNodeInst();
                    Point2D nPt = (Point2D)nodeLocation.get(ni7);
                    if (ni7.getAnchorCenterX() != nPt.getX() || ni7.getAnchorCenterY() != nPt.getY()) continue;
                    Iterator oIt = this.highlighted.iterator();
                    while (oIt.hasNext()) {
                        ArcInst oai;
                        Point2D aPt;
                        ElectricObject oEObj;
                        Highlight oH = (Highlight)oIt.next();
                        if (oH.getType() != Highlight.Type.EOBJ || !((oEObj = oH.getElectricObject()) instanceof ArcInst) || (aPt = (Point2D)arcLocation.get(oai = (ArcInst)oEObj)).getX() != oai.getTrueCenterX() || aPt.getY() != oai.getTrueCenterY() || oai.headStillInPort(new Point2D.Double(ai5.getHeadLocation().getX() + this.dX, ai5.getHeadLocation().getY() + this.dY), true) || oai.tailStillInPort(new Point2D.Double(ai5.getTailLocation().getX() + this.dX, ai5.getTailLocation().getY() + this.dY), true)) continue;
                        Layout.setTempRigid(oai, true);
                    }
                    ni7.move(this.dX - (ni7.getAnchorCenterX() - nPt.getX()), this.dY - (ni7.getAnchorCenterY() - nPt.getY()));
                }
            }
            this.moveSelectedText(this.highlightedText);
            StatusBar.updateStatusBar();
            return true;
        }

        private void moveSelectedText(List highlightedText) {
            Iterator it = highlightedText.iterator();
            while (it.hasNext()) {
                ImmutableTextDescriptor td;
                Highlight high = (Highlight)it.next();
                Cell np = high.getCell();
                if (np != null) {
                    int errorCode = CircuitChanges.cantEdit(np, null, true);
                    if (errorCode < 0) {
                        return;
                    }
                    if (errorCode > 0) continue;
                }
                ElectricObject eobj = high.getElectricObject();
                if (high.nodeMovesWithText()) {
                    NodeInst ni = null;
                    if (eobj instanceof NodeInst) {
                        ni = (NodeInst)eobj;
                    }
                    if (eobj instanceof Export) {
                        ni = ((Export)eobj).getOriginalPort().getNodeInst();
                    }
                    if (ni != null) {
                        ni.move(this.dX, this.dY);
                        continue;
                    }
                }
                Variable var = high.getVar();
                NodeInst ni = null;
                String varName = null;
                if (var != null) {
                    varName = var.getKey().getName();
                    if (eobj instanceof NodeInst) {
                        ni = (NodeInst)eobj;
                    } else if (eobj instanceof PortInst) {
                        ni = ((PortInst)eobj).getNodeInst();
                    } else if (eobj instanceof Export) {
                        ni = ((Export)eobj).getOriginalPort().getNodeInst();
                    }
                } else if (high.getName() != null) {
                    if (eobj instanceof NodeInst) {
                        ni = (NodeInst)eobj;
                        varName = NodeInst.NODE_NAME_TD;
                    } else {
                        varName = ArcInst.ARC_NAME_TD;
                    }
                } else if (eobj instanceof Export) {
                    Export pp = (Export)eobj;
                    ni = pp.getOriginalPort().getNodeInst();
                    varName = Export.EXPORT_NAME_TD;
                }
                if ((td = eobj.getTextDescriptor(varName)) == null) continue;
                if (ni != null) {
                    Point2D.Double curLoc = new Point2D.Double(ni.getAnchorCenterX() + td.getXOff(), ni.getAnchorCenterY() + td.getYOff());
                    AffineTransform rotateOut = ni.rotateOut();
                    rotateOut.transform(curLoc, curLoc);
                    ((Point2D)curLoc).setLocation(((Point2D)curLoc).getX() + this.dX, ((Point2D)curLoc).getY() + this.dY);
                    AffineTransform rotateIn = ni.rotateIn();
                    rotateIn.transform(curLoc, curLoc);
                    eobj.setOff(varName, ((Point2D)curLoc).getX() - ni.getAnchorCenterX(), ((Point2D)curLoc).getY() - ni.getAnchorCenterY());
                    continue;
                }
                eobj.setOff(varName, td.getXOff() + this.dX, td.getYOff() + this.dY);
            }
        }
    }

    private static class DuplicateCell
    extends Job {
        Cell cell;
        String newName;

        protected DuplicateCell(Cell cell, String newName) {
            super("Duplicate " + cell, User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.newName = newName;
            this.startJob();
        }

        public boolean doIt() {
            WindowContent content;
            WindowFrame curWf;
            int response;
            String newCellName = this.newName + "{" + this.cell.getView().getAbbreviation() + "}";
            if (this.cell.getLibrary().findNodeProto(newCellName) != null && (response = JOptionPane.showOptionDialog(TopLevel.getCurrentJFrame(), "Cell " + newCellName + " already exists.  Make this a new version?", "Confirm duplication", -1, 2, null, new String[]{"Yes", "Cancel"}, "Yes")) != 0) {
                return false;
            }
            Cell dupCell = Cell.copyNodeProto(this.cell, this.cell.getLibrary(), newCellName, false);
            if (dupCell == null) {
                System.out.println("Could not duplicate " + this.cell);
                return false;
            }
            System.out.println("Duplicated cell " + this.cell + ". New cell is " + dupCell + ".");
            Iterator it = this.cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = (NodeInst)it.next();
                if (ni.getProtoEquivalent() != this.cell) continue;
                Cell icon = (Cell)ni.getProto();
                Cell dupIcon = Cell.copyNodeProto(icon, icon.getLibrary(), this.newName + "{" + icon.getView().getAbbreviation() + "}", false);
                if (dupIcon == null) {
                    System.out.println("Could not duplicate icon " + icon);
                    break;
                }
                System.out.println("  Also duplicated icon view, cell " + icon + ". New cell is " + dupIcon + ".");
                Iterator it2 = dupCell.getNodes();
                while (it2.hasNext()) {
                    NodeInst ni2 = (NodeInst)it2.next();
                    if (ni2.getProto() != icon) continue;
                    NodeInst newNi2 = ni2.replace(dupIcon, true, true);
                    newNi2.setName(null);
                }
                break block0;
            }
            if ((curWf = WindowFrame.getCurrentWindowFrame()) != null && (content = curWf.getContent()) != null && content.getCell() == this.cell) {
                content.setCell(dupCell, VarContext.globalContext);
                content.repaint();
                return true;
            }
            Iterator it2 = WindowFrame.getWindows();
            while (it2.hasNext()) {
                WindowFrame wf = (WindowFrame)it2.next();
                WindowContent content2 = wf.getContent();
                if (content2 == null || content2.getCell() != this.cell) continue;
                content2.setCell(dupCell, VarContext.globalContext);
                content2.repaint();
                return true;
            }
            return true;
        }
    }

    private static class NewCellVersion
    extends Job {
        Cell cell;

        protected NewCellVersion(Cell cell) {
            super("Create new Version of " + cell, User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.startJob();
        }

        public boolean doIt() {
            Cell newVersion = this.cell.makeNewVersion();
            if (newVersion == null) {
                return false;
            }
            Iterator it = WindowFrame.getWindows();
            while (it.hasNext()) {
                WindowFrame wf = (WindowFrame)it.next();
                WindowContent content = wf.getContent();
                if (content == null || content.getCell() != this.cell) continue;
                content.setCell(newVersion, VarContext.globalContext);
            }
            EditWindow.repaintAll();
            System.out.println("Created new version: " + newVersion + ", old version renamed to " + this.cell);
            return true;
        }
    }

    private static class ShortenArcs
    extends Job {
        private List selected;

        private ShortenArcs(List selected) {
            super("Shorten selected arcs", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.selected = selected;
            this.startJob();
        }

        public boolean doIt() {
            Cell cell = WindowFrame.needCurCell();
            if (cell == null) {
                return false;
            }
            if (CircuitChanges.cantEdit(cell, null, true) != 0) {
                return false;
            }
            int l = 0;
            double[] dX = new double[2];
            double[] dY = new double[2];
            Iterator it = this.selected.iterator();
            while (it.hasNext()) {
                ArcInst ai = (ArcInst)it.next();
                for (int j = 0; j < 2; ++j) {
                    Poly portPoly = ai.getPortInst(j).getPoly();
                    double wid = ai.getWidth() - ai.getProto().getWidthOffset();
                    portPoly.reducePortPoly(ai.getPortInst(j), wid, ai.getAngle());
                    Point2D closest = portPoly.closestPoint(ai.getLocation(1 - j));
                    dX[j] = closest.getX() - ai.getLocation(j).getX();
                    dY[j] = closest.getY() - ai.getLocation(j).getY();
                }
                if (dX[0] == 0.0 && dY[0] == 0.0 && dX[1] == 0.0 && dY[1] == 0.0) continue;
                ai.modify(0.0, dX[1], dY[1], dX[0], dY[0]);
                ++l;
            }
            System.out.println("Shortened " + l + " arcs");
            return true;
        }
    }

    public static class CleanupChanges
    extends Job {
        private Cell cell;
        private boolean justThis;
        private List pinsToRemove;
        private List pinsToPassThrough;
        private HashMap pinsToScale;
        private List textToMove;
        private HashSet arcsToKill;
        private int zeroSize;
        private int negSize;
        private int overSizePins;

        public CleanupChanges(Cell cell, boolean justThis, List pinsToRemove, List pinsToPassThrough, HashMap pinsToScale, List textToMove, HashSet arcsToKill, int zeroSize, int negSize, int overSizePins) {
            super("Cleanup " + cell, User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.justThis = justThis;
            this.pinsToRemove = pinsToRemove;
            this.pinsToPassThrough = pinsToPassThrough;
            this.pinsToScale = pinsToScale;
            this.textToMove = textToMove;
            this.arcsToKill = arcsToKill;
            this.zeroSize = zeroSize;
            this.negSize = negSize;
            this.overSizePins = overSizePins;
        }

        public boolean doIt() {
            NodeInst ni;
            if (CircuitChanges.cantEdit(this.cell, null, true) != 0) {
                return false;
            }
            Iterator it = this.pinsToRemove.iterator();
            while (it.hasNext()) {
                NodeInst ni2 = (NodeInst)it.next();
                ni2.kill();
            }
            int pinsPassedThrough = 0;
            while (true) {
                boolean found = false;
                Iterator it2 = this.pinsToPassThrough.iterator();
                while (it2.hasNext()) {
                    List created;
                    Reconnect re = (Reconnect)it2.next();
                    if (!re.ni.isLinked() || (created = re.reconnectArcs()).size() <= 0) continue;
                    re.ni.kill();
                    ++pinsPassedThrough;
                    found = true;
                }
                if (!found) break;
                this.pinsToPassThrough = CircuitChanges.getPinsToPassThrough(this.cell);
            }
            Iterator<Object> it3 = this.pinsToScale.keySet().iterator();
            while (it3.hasNext()) {
                ni = (NodeInst)it3.next();
                Point2D scale = (Point2D)this.pinsToScale.get(ni);
                ni.resize(scale.getX(), scale.getY());
            }
            it3 = this.textToMove.iterator();
            while (it3.hasNext()) {
                ni = (NodeInst)it3.next();
                ni.invisiblePinWithOffsetText(true);
            }
            it3 = this.arcsToKill.iterator();
            while (it3.hasNext()) {
                ArcInst ai = (ArcInst)it3.next();
                if (!ai.isLinked()) continue;
                ai.kill();
            }
            StringBuffer infstr = new StringBuffer();
            if (!this.justThis) {
                infstr.append("Cell " + this.cell.describe(true) + ":");
            }
            boolean spoke = false;
            if (this.pinsToRemove.size() + pinsPassedThrough != 0) {
                int removed = this.pinsToRemove.size() + pinsPassedThrough;
                infstr.append("Removed " + removed + " pins");
                spoke = true;
            }
            if (this.arcsToKill.size() != 0) {
                if (spoke) {
                    infstr.append("; ");
                }
                infstr.append("Removed " + this.arcsToKill.size() + " duplicate arcs");
                spoke = true;
            }
            if (this.pinsToScale.size() != 0) {
                if (spoke) {
                    infstr.append("; ");
                }
                infstr.append("Shrunk " + this.pinsToScale.size() + " pins");
                spoke = true;
            }
            if (this.zeroSize != 0) {
                if (spoke) {
                    infstr.append("; ");
                }
                if (this.justThis) {
                    infstr.append("Highlighted " + this.zeroSize + " zero-size pins");
                } else {
                    infstr.append("Found " + this.zeroSize + " zero-size pins");
                }
                spoke = true;
            }
            if (this.negSize != 0) {
                if (spoke) {
                    infstr.append("; ");
                }
                if (this.justThis) {
                    infstr.append("Highlighted " + this.negSize + " negative-size pins");
                } else {
                    infstr.append("Found " + this.negSize + " negative-size pins");
                }
                spoke = true;
            }
            if (this.overSizePins != 0) {
                if (spoke) {
                    infstr.append("; ");
                }
                if (this.justThis) {
                    infstr.append("Highlighted " + this.overSizePins + " oversize pins with arcs that don't touch");
                } else {
                    infstr.append("Found " + this.overSizePins + " oversize pins with arcs that don't touch");
                }
                spoke = true;
            }
            if (this.textToMove.size() != 0) {
                if (spoke) {
                    infstr.append("; ");
                }
                infstr.append("Moved text on " + this.textToMove.size() + " pins with offset text");
            }
            System.out.println(infstr.toString());
            return true;
        }
    }

    private static class ExtractCellInstances
    extends Job {
        private List nodes;

        protected ExtractCellInstances(List highlighted) {
            super("Extract Cell Instances", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.nodes = highlighted;
            this.startJob();
        }

        public boolean doIt() {
            boolean foundInstance = false;
            Iterator it = this.nodes.iterator();
            while (it.hasNext()) {
                NodeInst ni = (NodeInst)it.next();
                NodeProto np = ni.getProto();
                if (!(np instanceof Cell)) continue;
                foundInstance = true;
                CircuitChanges.extractOneNode(ni);
            }
            if (!foundInstance) {
                System.out.println("Must select cell instances to extract");
                return false;
            }
            return true;
        }
    }

    private static class PackageCell
    extends Job {
        Cell curCell;
        Rectangle2D bounds;
        String newCellName;

        protected PackageCell(Cell curCell, Rectangle2D bounds, String newCellName) {
            super("Package Cell", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.curCell = curCell;
            this.bounds = bounds;
            this.newCellName = newCellName;
            this.startJob();
        }

        public boolean doIt() {
            Geometric look;
            Cell cell = Cell.makeInstance(Library.getCurrent(), this.newCellName);
            if (cell == null) {
                return false;
            }
            HashMap<NodeInst, NodeInst> newNodes = new HashMap<NodeInst, NodeInst>();
            Iterator sIt = this.curCell.searchIterator(this.bounds);
            while (sIt.hasNext()) {
                NodeInst newNi;
                look = (Geometric)sIt.next();
                if (!(look instanceof NodeInst)) continue;
                NodeInst ni = (NodeInst)look;
                String name = null;
                Name oldName = ni.getNameKey();
                if (!oldName.isTempname()) {
                    name = oldName.toString();
                }
                if ((newNi = NodeInst.makeInstance(ni.getProto(), new Point2D.Double(ni.getAnchorCenterX(), ni.getAnchorCenterY()), ni.getXSize(), ni.getYSize(), cell, ni.getOrient(), name, 0)) == null) {
                    return false;
                }
                newNodes.put(ni, newNi);
                newNi.copyStateBits(ni);
                newNi.copyVarsFrom(ni);
                newNi.copyTextDescriptorFrom(ni, NodeInst.NODE_NAME_TD);
                Iterator it = ni.getExports();
                while (it.hasNext()) {
                    Export pp = (Export)it.next();
                    PortInst pi = newNi.findPortInstFromProto(pp.getOriginalPort().getPortProto());
                    Export newPp = Export.newInstance(cell, pi, pp.getName());
                    if (newPp == null) continue;
                    newPp.setCharacteristic(pp.getCharacteristic());
                    newPp.copyTextDescriptorFrom(pp, Export.EXPORT_NAME_TD);
                    newPp.copyVarsFrom(pp);
                }
            }
            sIt = this.curCell.searchIterator(this.bounds);
            while (sIt.hasNext()) {
                ArcInst newAi;
                look = (Geometric)sIt.next();
                if (!(look instanceof ArcInst)) continue;
                ArcInst ai = (ArcInst)look;
                NodeInst niTail = (NodeInst)newNodes.get(ai.getTailPortInst().getNodeInst());
                NodeInst niHead = (NodeInst)newNodes.get(ai.getHeadPortInst().getNodeInst());
                if (niTail == null || niHead == null) continue;
                PortInst piTail = niTail.findPortInstFromProto(ai.getTailPortInst().getPortProto());
                PortInst piHead = niHead.findPortInstFromProto(ai.getHeadPortInst().getPortProto());
                String name = null;
                Name oldName = ai.getNameKey();
                if (!oldName.isTempname()) {
                    name = oldName.toString();
                }
                if ((newAi = ArcInst.makeInstance(ai.getProto(), ai.getWidth(), piHead, piTail, ai.getHeadLocation(), ai.getTailLocation(), name)) == null) {
                    return false;
                }
                newAi.copyPropertiesFrom(ai);
            }
            System.out.println("Cell " + cell.describe(true) + " created");
            return true;
        }
    }

    private static class GraphCells
    extends Job {
        private Cell top;

        protected GraphCells(Cell top) {
            super("Graph Cells", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.top = top;
            this.startJob();
        }

        public boolean doIt() {
            CellGraphNode cgn;
            Cell cell;
            Library lib;
            double xsc;
            NodeInst titleNi;
            CellGraphNode cgn2;
            Cell cell2;
            Iterator cIt;
            Library lib2;
            CellGraphNode cgn3;
            Cell cell3;
            Iterator cIt2;
            Library lib3;
            Cell trueCell;
            CellGraphNode cgn4;
            Cell cell4;
            Iterator cIt3;
            Cell graphCell = Cell.newInstance(Library.getCurrent(), "CellStructure");
            if (graphCell == null) {
                return false;
            }
            if (graphCell.getNumVersions() > 1) {
                System.out.println("Creating new version of cell: CellStructure");
            } else {
                System.out.println("Creating cell: CellStructure");
            }
            HashMap<Cell, CellGraphNode> cellGraphNodes = new HashMap<Cell, CellGraphNode>();
            Iterator it = Library.getLibraries();
            while (it.hasNext()) {
                Library lib4 = (Library)it.next();
                if (lib4.isHidden()) continue;
                cIt3 = lib4.getCells();
                while (cIt3.hasNext()) {
                    cell4 = (Cell)cIt3.next();
                    cgn4 = new CellGraphNode();
                    cgn4.depth = -1;
                    cellGraphNodes.put(cell4, cgn4);
                }
            }
            if (this.top != null) {
                CellGraphNode cgn5 = (CellGraphNode)cellGraphNodes.get(this.top);
                cgn5.depth = 0;
            } else {
                Iterator cIt4 = Library.getCurrent().getCells();
                while (cIt4.hasNext()) {
                    Cell cell5 = (Cell)cIt4.next();
                    if (cell5.getNumUsagesIn() != 0) continue;
                    CellGraphNode cgn6 = (CellGraphNode)cellGraphNodes.get(cell5);
                    cgn6.depth = 0;
                }
            }
            int maxDepth = 0;
            boolean more = true;
            while (more) {
                more = false;
                Iterator it2 = Library.getLibraries();
                while (it2.hasNext()) {
                    Library lib5 = (Library)it2.next();
                    if (lib5.isHidden()) continue;
                    Iterator cIt5 = lib5.getCells();
                    while (cIt5.hasNext()) {
                        Cell cell6 = (Cell)cIt5.next();
                        CellGraphNode cgn7 = (CellGraphNode)cellGraphNodes.get(cell6);
                        if (cgn7.depth == -1) continue;
                        Iterator nIt = cell6.getNodes();
                        while (nIt.hasNext()) {
                            NodeInst ni = (NodeInst)nIt.next();
                            if (!(ni.getProto() instanceof Cell)) continue;
                            Cell sub = (Cell)ni.getProto();
                            if (ni.isIconOfParent()) continue;
                            CellGraphNode subCgn = (CellGraphNode)cellGraphNodes.get(sub);
                            if (subCgn.depth <= cgn7.depth) {
                                subCgn.depth = cgn7.depth + 1;
                                if (subCgn.depth > maxDepth) {
                                    maxDepth = subCgn.depth;
                                }
                                more = true;
                            }
                            if ((trueCell = sub.contentsView()) == null) continue;
                            CellGraphNode trueCgn = (CellGraphNode)cellGraphNodes.get(trueCell);
                            if (trueCgn.depth > cgn7.depth) continue;
                            trueCgn.depth = cgn7.depth + 1;
                            if (trueCgn.depth > maxDepth) {
                                maxDepth = trueCgn.depth;
                            }
                            more = true;
                        }
                    }
                }
                if (more || this.top != null) continue;
                cIt3 = Library.getCurrent().getCells();
                while (cIt3.hasNext()) {
                    cell4 = (Cell)cIt3.next();
                    cgn4 = (CellGraphNode)cellGraphNodes.get(cell4);
                    if (cgn4.depth >= 0) continue;
                    cgn4.depth = 0;
                    more = true;
                }
            }
            double maxWidth = 0.0;
            double[] xval = new double[++maxDepth];
            double[] yoff = new double[maxDepth];
            for (int i = 0; i < maxDepth; ++i) {
                yoff[i] = 0.0;
                xval[i] = 0.0;
            }
            Iterator it3 = Library.getLibraries();
            while (it3.hasNext()) {
                lib3 = (Library)it3.next();
                if (lib3.isHidden()) continue;
                cIt2 = lib3.getCells();
                while (cIt2.hasNext()) {
                    cell3 = (Cell)cIt2.next();
                    cgn3 = (CellGraphNode)cellGraphNodes.get(cell3);
                    if (cgn3.depth == -1) continue;
                    trueCell = CircuitChanges.graphMainView(cell3);
                    if (trueCell != null && (cell3.getNumUsagesIn() == 0 || cell3.isIcon() || cell3.getView() == View.LAYOUTSKEL)) {
                        cgn3.depth = -1;
                        continue;
                    }
                    cgn3.x = xval[cgn3.depth];
                    int n = cgn3.depth;
                    xval[n] = xval[n] + (double)cell3.describe(false).length();
                    if (xval[cgn3.depth] > maxWidth) {
                        maxWidth = xval[cgn3.depth];
                    }
                    cgn3.y = cgn3.depth;
                    cgn3.yoff = 0.0;
                }
            }
            it3 = Library.getLibraries();
            while (it3.hasNext()) {
                lib3 = (Library)it3.next();
                if (lib3.isHidden()) continue;
                cIt2 = lib3.getCells();
                while (cIt2.hasNext()) {
                    cell3 = (Cell)cIt2.next();
                    cgn3 = (CellGraphNode)cellGraphNodes.get(cell3);
                    if (cgn3.depth == -1 || !(xval[(int)cgn3.y] < maxWidth)) continue;
                    double spread = maxWidth / xval[(int)cgn3.y];
                    cgn3.x *= spread;
                }
            }
            double xScale = 0.6666666666666666;
            double yScale = 20.0;
            double yOffset = 0.5;
            Iterator it4 = Library.getLibraries();
            while (it4.hasNext()) {
                lib2 = (Library)it4.next();
                if (lib2.isHidden()) continue;
                cIt = lib2.getCells();
                while (cIt.hasNext()) {
                    cell2 = (Cell)cIt.next();
                    cgn2 = (CellGraphNode)cellGraphNodes.get(cell2);
                    if (cgn2.depth == -1) continue;
                    double x = cgn2.x;
                    double y = cgn2.y;
                    int n = (int)cgn2.y;
                    double d = yoff[n];
                    yoff[n] = d + 1.0;
                    y = -y * yScale + d % 2.0 * yOffset;
                    cgn2.x = x *= xScale;
                    cgn2.y = y;
                }
            }
            if (this.top == null) {
                it4 = Library.getLibraries();
                while (it4.hasNext()) {
                    lib2 = (Library)it4.next();
                    if (lib2.isHidden()) continue;
                    cIt = lib2.getCells();
                    while (cIt.hasNext()) {
                        Cell trueCell2;
                        cell2 = (Cell)cIt.next();
                        cgn2 = (CellGraphNode)cellGraphNodes.get(cell2);
                        if (cgn2.depth != -1 || cell2.getNumUsagesIn() != 0 && !cell2.isIcon() && cell2.getView() != View.LAYOUTSKEL || (trueCell2 = CircuitChanges.graphMainView(cell2)) == null) continue;
                        CellGraphNode trueCgn = (CellGraphNode)cellGraphNodes.get(trueCell2);
                        if (trueCgn.depth == -1) continue;
                        cgn2.pin = null;
                        cgn2.main = trueCgn;
                        cgn2.yoff += yOffset * 2.0;
                        cgn2.x = trueCgn.x;
                        cgn2.y = trueCgn.y + trueCgn.yoff;
                    }
                }
            }
            if ((titleNi = NodeInst.newInstance(Generic.tech.invisiblePinNode, new Point2D.Double(xsc = maxWidth * xScale / 2.0, yScale), 0.0, 0.0, graphCell)) == null) {
                return false;
            }
            StringBuffer infstr = new StringBuffer();
            if (this.top != null) {
                infstr.append("Structure below " + this.top);
            } else {
                infstr.append("Structure of library " + Library.getCurrent().getName());
            }
            Variable var = titleNi.newDisplayVar(Artwork.ART_MESSAGE, infstr.toString());
            if (var != null) {
                var.setRelSize(6.0);
            }
            Iterator it5 = Library.getLibraries();
            while (it5.hasNext()) {
                lib = (Library)it5.next();
                if (lib.isHidden()) continue;
                Iterator cIt6 = lib.getCells();
                while (cIt6.hasNext()) {
                    cell = (Cell)cIt6.next();
                    if (cell == graphCell) continue;
                    cgn = (CellGraphNode)cellGraphNodes.get(cell);
                    if (cgn.depth == -1) continue;
                    double x = cgn.x;
                    double y = cgn.y;
                    NodeInst ni = NodeInst.newInstance(Generic.tech.invisiblePinNode, new Point2D.Double(x, y), 0.0, 0.0, graphCell);
                    if (ni == null) {
                        return false;
                    }
                    cgn.pin = ni;
                    var = ni.newDisplayVar(Artwork.ART_MESSAGE, cell.describe(false));
                    if (var == null) continue;
                    var.setRelSize(1.0);
                }
            }
            it5 = Library.getLibraries();
            while (it5.hasNext()) {
                lib = (Library)it5.next();
                if (lib.isHidden()) continue;
                Iterator cIt7 = lib.getCells();
                while (cIt7.hasNext()) {
                    cell = (Cell)cIt7.next();
                    if (cell == graphCell) continue;
                    cgn = (CellGraphNode)cellGraphNodes.get(cell);
                    if (cgn.depth == -1 || cgn.main == null) continue;
                    PortInst firstPi = cgn.pin.getOnlyPortInst();
                    PortInst secondPi = cgn.main.pin.getOnlyPortInst();
                    ArcInst ai = ArcInst.makeInstance(Artwork.tech.solidArc, 0.0, firstPi, firstPi);
                    if (ai == null) {
                        return false;
                    }
                    ai.setRigid(true);
                    ai.newVar(Artwork.ART_COLOR, (Object)new Integer(0));
                }
            }
            int clock = 0;
            Iterator it6 = Library.getLibraries();
            while (it6.hasNext()) {
                Library lib6 = (Library)it6.next();
                if (lib6.isHidden()) continue;
                Iterator cIt8 = lib6.getCells();
                while (cIt8.hasNext()) {
                    Cell cell7 = (Cell)cIt8.next();
                    if (cell7 == graphCell) continue;
                    Cell trueCell3 = cell7.contentsView();
                    if (trueCell3 == null) {
                        trueCell3 = cell7;
                    }
                    CellGraphNode trueCgn = (CellGraphNode)cellGraphNodes.get(trueCell3);
                    if (trueCgn.depth == -1) continue;
                    ++clock;
                    Iterator nIt = trueCell3.getNodes();
                    while (nIt.hasNext()) {
                        NodeInst ni = (NodeInst)nIt.next();
                        if (!(ni.getProto() instanceof Cell) || ni.isIconOfParent()) continue;
                        Cell sub = (Cell)ni.getProto();
                        Cell truesubnp = sub.contentsView();
                        if (truesubnp == null) {
                            truesubnp = sub;
                        }
                        CellGraphNode trueSubCgn = (CellGraphNode)cellGraphNodes.get(truesubnp);
                        if (trueSubCgn.clock == clock) continue;
                        trueSubCgn.clock = clock;
                        if (trueSubCgn.depth == -1) continue;
                        PortInst toppinPi = trueCgn.pin.getOnlyPortInst();
                        PortInst niBotPi = trueSubCgn.pin.getOnlyPortInst();
                        ArcInst ai = ArcInst.makeInstance(Artwork.tech.solidArc, Artwork.tech.solidArc.getDefaultWidth(), toppinPi, niBotPi);
                        if (ai == null) {
                            return false;
                        }
                        ai.setRigid(false);
                        ai.setFixedAngle(false);
                        int color = 14;
                        if (trueCgn.y - trueSubCgn.y > yScale + yOffset + yOffset) {
                            color = 10;
                        }
                        ai.newVar(Artwork.ART_COLOR, (Object)new Integer(color));
                    }
                }
            }
            WindowFrame.createEditWindow(graphCell);
            return true;
        }

        private static class CellGraphNode {
            int depth;
            int clock;
            double x;
            double y;
            double yoff;
            NodeInst pin;
            CellGraphNode main;

            private CellGraphNode() {
            }
        }
    }

    private static class DeleteUnusedOldCells
    extends Job {
        protected DeleteUnusedOldCells() {
            super("Delete Unused Old Cells", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.startJob();
        }

        public boolean doIt() {
            boolean found = true;
            int totalDeleted = 0;
            block0: while (found) {
                found = false;
                Iterator it = Library.getCurrent().getCells();
                while (it.hasNext()) {
                    Cell cell = (Cell)it.next();
                    if (cell.getNewestVersion() == cell || cell.getInstancesOf().hasNext()) continue;
                    System.out.println("Deleting " + cell);
                    CircuitChanges.doKillCell(cell);
                    found = true;
                    ++totalDeleted;
                    continue block0;
                }
            }
            if (totalDeleted == 0) {
                System.out.println("No unused old cell versions to delete");
            } else {
                System.out.println("Deleted " + totalDeleted + " cells");
                EditWindow.repaintAll();
            }
            return true;
        }
    }

    private static class RenameCellGroup
    extends Job {
        Cell.CellGroup cellGroup;
        String newName;

        protected RenameCellGroup(Cell.CellGroup cellGroup, String newName) {
            super("Rename Cell Group", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cellGroup = cellGroup;
            this.newName = newName;
            this.startJob();
        }

        public boolean doIt() {
            ArrayList cells = new ArrayList();
            Iterator it = this.cellGroup.getCells();
            while (it.hasNext()) {
                cells.add(it.next());
            }
            it = cells.iterator();
            while (it.hasNext()) {
                Cell cell = (Cell)it.next();
                cell.rename(this.newName);
            }
            return true;
        }
    }

    private static class RenameCell
    extends Job {
        private Cell cell;
        private String newName;
        private Cell.CellGroup newGroup;

        protected RenameCell(Cell cell, String newName, Cell.CellGroup newGroup) {
            super("Rename " + cell, User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.newName = newName;
            this.newGroup = newGroup;
            this.startJob();
        }

        public boolean doIt() {
            this.cell.rename(this.newName);
            if (this.newGroup != null) {
                this.cell.setCellGroup(this.newGroup);
            }
            return true;
        }
    }

    private static class DeleteCell
    extends Job {
        Cell cell;

        protected DeleteCell(Cell cell) {
            super("Delete " + cell, User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.startJob();
        }

        public boolean doIt() {
            if (this.cell.isInUse("delete", false)) {
                return false;
            }
            CircuitChanges.doKillCell(this.cell);
            return true;
        }
    }

    private static class DeleteSelectedGeometry
    extends Job {
        private Cell cell;
        private Rectangle2D bounds;

        protected DeleteSelectedGeometry(Cell cell, Rectangle2D bounds) {
            super("Delete selected geometry", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.bounds = bounds;
            this.startJob();
        }

        public boolean doIt() {
            NodeInst ni;
            if (this.cell == null) {
                System.out.println("No current cell");
                return false;
            }
            if (this.bounds == null) {
                System.out.println("Nothing selected");
                return false;
            }
            if (CircuitChanges.cantEdit(this.cell, null, true) != 0) {
                return false;
            }
            if (this.bounds == null) {
                System.out.println("Outline an area first");
                return false;
            }
            double lX = Math.floor(this.bounds.getMinX());
            double hX = Math.ceil(this.bounds.getMaxX());
            double lY = Math.floor(this.bounds.getMinY());
            double hY = Math.ceil(this.bounds.getMaxY());
            ArrayList arcsInCell = new ArrayList();
            Iterator aIt = this.cell.getArcs();
            while (aIt.hasNext()) {
                arcsInCell.add(aIt.next());
            }
            aIt = arcsInCell.iterator();
            while (aIt.hasNext()) {
                ArcInst ai1;
                NodeInst ni2;
                PrimitiveNode pin;
                Point2D.Double headPtAdj;
                ArcInst ai = (ArcInst)aIt.next();
                EPoint headPt = ai.getHeadLocation();
                EPoint tailPt = ai.getTailLocation();
                if (((Point2D)tailPt).getX() == ((Point2D)headPt).getX() && ((Point2D)tailPt).getY() == ((Point2D)headPt).getY()) continue;
                double halfWidth = (ai.getWidth() - ai.getProto().getWidthOffset()) / 2.0;
                double lXExt = lX - halfWidth;
                double hXExt = hX + halfWidth;
                double lYExt = lY - halfWidth;
                double hYExt = hY + halfWidth;
                Point2D.Double tailPtAdj = new Point2D.Double(((Point2D)tailPt).getX(), ((Point2D)tailPt).getY());
                if (DBMath.clipLine(tailPtAdj, headPtAdj = new Point2D.Double(((Point2D)headPt).getX(), ((Point2D)headPt).getY()), lXExt, hXExt, lYExt, hYExt)) continue;
                if (tailPtAdj.distance(headPt) + headPtAdj.distance(tailPt) < headPtAdj.distance(headPt) + tailPtAdj.distance(tailPt)) {
                    Point2D.Double swap = headPtAdj;
                    headPtAdj = tailPtAdj;
                    tailPtAdj = swap;
                }
                Name name = ai.getNameKey();
                String newName = null;
                if (!name.isTempname()) {
                    newName = name.toString();
                }
                if (!tailPt.equals(tailPtAdj)) {
                    pin = ai.getProto().findPinProto();
                    ni2 = NodeInst.makeInstance(pin, tailPtAdj, pin.getDefWidth(), pin.getDefHeight(), this.cell);
                    if (ni2 == null) {
                        System.out.println("Error creating pin for shortening of " + ai);
                        continue;
                    }
                    ai1 = ArcInst.makeInstance(ai.getProto(), ai.getWidth(), ai.getTailPortInst(), ni2.getOnlyPortInst(), ai.getTailLocation(), tailPtAdj, newName);
                    if (ai1 == null) {
                        System.out.println("Error shortening " + ai);
                        continue;
                    }
                    newName = null;
                    ai1.copyPropertiesFrom(ai);
                }
                if (!headPt.equals(headPtAdj)) {
                    pin = ai.getProto().findPinProto();
                    ni2 = NodeInst.makeInstance(pin, headPtAdj, pin.getDefWidth(), pin.getDefHeight(), this.cell);
                    if (ni2 == null) {
                        System.out.println("Error creating pin for shortening of " + ai);
                        continue;
                    }
                    ai1 = ArcInst.makeInstance(ai.getProto(), ai.getWidth(), ni2.getOnlyPortInst(), ai.getHeadPortInst(), headPtAdj, ai.getHeadLocation(), newName);
                    if (ai1 == null) {
                        System.out.println("Error shortening " + ai);
                        continue;
                    }
                    ai1.copyPropertiesFrom(ai);
                }
                ai.kill();
            }
            ArrayList<NodeInst> nodesToDelete = new ArrayList<NodeInst>();
            Iterator nIt = this.cell.getNodes();
            while (nIt.hasNext()) {
                ni = (NodeInst)nIt.next();
                double cX = ni.getTrueCenterX();
                double cY = ni.getTrueCenterY();
                if (cX >= hX || cX <= lX || cY >= hY || cY <= lY) continue;
                int errorCode = CircuitChanges.cantEdit(this.cell, ni, true);
                if (errorCode < 0) {
                    return false;
                }
                if (errorCode > 0) continue;
                nodesToDelete.add(ni);
            }
            nIt = nodesToDelete.iterator();
            while (nIt.hasNext()) {
                ni = (NodeInst)nIt.next();
                CircuitChanges.eraseNodeInst(ni);
            }
            return true;
        }
    }

    private static class DeleteSelected
    extends Job {
        private List highlightedText;
        private List highlighted;

        protected DeleteSelected(List highlightedText, List highlighted) {
            super("Delete selected objects", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.highlightedText = highlightedText;
            this.highlighted = highlighted;
            this.startJob();
        }

        public boolean doIt() {
            WindowFrame wf;
            ElectricObject eobj;
            Cell cell = WindowFrame.needCurCell();
            if (cell != null && CircuitChanges.cantEdit(cell, null, true) != 0) {
                return false;
            }
            ArrayList<Geometric> deleteList = new ArrayList<Geometric>();
            Iterator it = this.highlighted.iterator();
            while (it.hasNext()) {
                Highlight h = (Highlight)it.next();
                Geometric geom = h.getGeometric();
                if (geom == null || h.getType() == Highlight.Type.TEXT && (eobj = h.getElectricObject()) instanceof Export) continue;
                if (cell != h.getCell()) {
                    JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "All objects to be deleted must be in the same cell", "Delete failed", 0);
                    return false;
                }
                if (geom instanceof NodeInst) {
                    int errCode = CircuitChanges.cantEdit(cell, (NodeInst)geom, true);
                    if (errCode < 0) {
                        return false;
                    }
                    if (errCode > 0) continue;
                }
                deleteList.add(geom);
            }
            it = this.highlightedText.iterator();
            while (it.hasNext()) {
                Highlight high = (Highlight)it.next();
                Variable var = high.getVar();
                eobj = high.getElectricObject();
                if (var != null) {
                    eobj.delVar(var.getKey());
                    continue;
                }
                if (high.getName() != null) {
                    if (!(eobj instanceof Geometric)) continue;
                    Geometric geom = (Geometric)eobj;
                    if (geom instanceof NodeInst) {
                        NodeInst ni = (NodeInst)geom;
                        ni.setName(null);
                        ni.move(0.0, 0.0);
                        continue;
                    }
                    ArcInst ai = (ArcInst)geom;
                    ai.setName(null);
                    ai.modify(0.0, 0.0, 0.0, 0.0, 0.0);
                    continue;
                }
                if (!(eobj instanceof Export)) continue;
                Export pp = (Export)eobj;
                int errCode = CircuitChanges.cantEdit(cell, pp.getOriginalPort().getNodeInst(), true);
                if (errCode < 0) {
                    return false;
                }
                if (errCode > 0) continue;
                pp.kill();
            }
            if (cell != null) {
                CircuitChanges.eraseObjectsInList(cell, deleteList);
            }
            if ((wf = WindowFrame.getCurrentWindowFrame()) != null) {
                Highlighter highlighter = wf.getContent().getHighlighter();
                highlighter.clear();
                highlighter.finished();
            }
            return true;
        }
    }

    private static class RipTheBus
    extends Job {
        List list;

        protected RipTheBus(List list) {
            super("Rip Bus", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.list = list;
            this.startJob();
        }

        public boolean doIt() {
            Cell cell = WindowFrame.needCurCell();
            if (cell == null) {
                return false;
            }
            if (CircuitChanges.cantEdit(cell, null, true) != 0) {
                return false;
            }
            Iterator it = this.list.iterator();
            while (it.hasNext()) {
                NodeInst nib;
                NodeInst niw;
                ArcInst ai = (ArcInst)it.next();
                if (ai.getProto() != Schematics.tech.bus_arc) continue;
                Netlist netList = ai.getParent().acquireUserNetlist();
                if (netList == null) {
                    System.out.println("Sorry, a deadlock aborted bus ripping (network information unavailable).  Please try again");
                    break;
                }
                int busWidth = netList.getBusWidth(ai);
                String netName = netList.getNetworkName(ai);
                if (netName.length() == 0) {
                    System.out.println("Bus " + ai.describe(true) + " has no name");
                    continue;
                }
                double stublen = (int)(ai.getLength() / 3.0 + 0.5);
                double lowXBus = 0.0;
                double lowYBus = 0.0;
                int lowEnd = 1;
                double sepX = 0.0;
                double sepY = 0.0;
                double lowX = 0.0;
                double lowY = 0.0;
                if (ai.getHeadLocation().getX() == ai.getTailLocation().getX()) {
                    lowX = ai.getHeadLocation().getX();
                    lowX = lowX < ai.getParent().getBounds().getCenterX() ? (lowX += stublen) : (lowX -= stublen);
                    if (ai.getLocation(0).getY() < ai.getLocation(1).getY()) {
                        lowEnd = 0;
                    }
                    lowY = (int)ai.getLocation(lowEnd).getY();
                    double highy = (int)ai.getLocation(1 - lowEnd).getY();
                    if (highy - lowY >= (double)(busWidth - 1)) {
                        sepY = (int)((highy - lowY) / (double)(busWidth - 1));
                        lowY = (int)((highy - lowY - sepY * (double)(busWidth - 1)) / 2.0 + lowY);
                    } else {
                        lowY = ai.getLocation(lowEnd).getY();
                        highy = ai.getLocation(1 - lowEnd).getY();
                        sepY = (highy - lowY) / (double)(busWidth - 1);
                    }
                    lowXBus = ai.getTailLocation().getX();
                    lowYBus = lowY;
                } else if (ai.getTailLocation().getY() == ai.getHeadLocation().getY()) {
                    lowY = ai.getTailLocation().getY();
                    lowY = lowY < ai.getParent().getBounds().getCenterY() ? (lowY += stublen) : (lowY -= stublen);
                    if (ai.getLocation(0).getX() < ai.getLocation(1).getX()) {
                        lowEnd = 0;
                    }
                    lowX = (int)ai.getLocation(lowEnd).getX();
                    double highx = (int)ai.getLocation(1 - lowEnd).getX();
                    if (highx - lowX >= (double)(busWidth - 1)) {
                        sepX = (int)((highx - lowX) / (double)(busWidth - 1));
                        lowX = (int)((highx - lowX - sepX * (double)(busWidth - 1)) / 2.0 + lowX);
                    } else {
                        lowX = ai.getLocation(lowEnd).getX();
                        highx = ai.getLocation(1 - lowEnd).getX();
                        sepX = (highx - lowX) / (double)(busWidth - 1);
                    }
                    lowXBus = lowX;
                    lowYBus = ai.getTailLocation().getY();
                } else {
                    System.out.println("Bus " + ai.describe(true) + " must be horizontal or vertical to be ripped out");
                    continue;
                }
                String[] localStrings = new String[busWidth];
                for (int i = 0; i < busWidth; ++i) {
                    Network subNet = netList.getNetwork(ai, i);
                    localStrings[i] = subNet.getName();
                }
                double sxw = Schematics.tech.wirePinNode.getDefWidth();
                double syw = Schematics.tech.wirePinNode.getDefHeight();
                double sxb = Schematics.tech.busPinNode.getDefWidth();
                double syb = Schematics.tech.busPinNode.getDefHeight();
                ArcProto apW = Schematics.tech.wire_arc;
                ArcProto apB = Schematics.tech.bus_arc;
                NodeInst niBLast = null;
                for (int i = 0; i < busWidth && (niw = NodeInst.makeInstance(Schematics.tech.wirePinNode, new Point2D.Double(lowX, lowY), sxw, syw, ai.getParent())) != null && (nib = NodeInst.makeInstance(Schematics.tech.busPinNode, new Point2D.Double(lowXBus, lowYBus), sxb, syb, ai.getParent())) != null; ++i) {
                    PortInst first;
                    PortInst head = niw.getOnlyPortInst();
                    PortInst tail = nib.getOnlyPortInst();
                    ArcInst aiw = ArcInst.makeInstance(apW, apW.getDefaultWidth(), head, tail);
                    if (aiw == null) break;
                    aiw.setName(localStrings[i]);
                    if (i == 0) {
                        first = ai.getPortInst(lowEnd);
                        aiw = ArcInst.makeInstance(apB, apB.getDefaultWidth(), first, tail);
                    } else {
                        first = niBLast.getOnlyPortInst();
                        aiw = ArcInst.makeInstance(apB, apB.getDefaultWidth(), first, tail);
                    }
                    if (aiw == null) break;
                    niBLast = nib;
                    lowX += sepX;
                    lowY += sepY;
                    lowXBus += sepX;
                    lowYBus += sepY;
                }
                PortInst head = niBLast.getOnlyPortInst();
                PortInst tail = ai.getPortInst(1 - lowEnd);
                ArcInst aiw = ArcInst.makeInstance(apB, apB.getDefaultWidth(), head, tail);
                if (aiw == null) {
                    return false;
                }
                aiw.setName(netName);
                ai.kill();
            }
            return true;
        }
    }

    private static class ToggleNegationJob
    extends Job {
        private List highlighted;

        protected ToggleNegationJob(List highlighted) {
            super("Toggle negation", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.highlighted = highlighted;
            this.startJob();
        }

        public boolean doIt() {
            Cell cell = WindowFrame.needCurCell();
            if (cell == null) {
                return false;
            }
            if (CircuitChanges.cantEdit(cell, null, true) != 0) {
                return false;
            }
            int numSet = 0;
            Iterator it = this.highlighted.iterator();
            while (it.hasNext()) {
                Highlight h = (Highlight)it.next();
                if (h.getType() != Highlight.Type.EOBJ) continue;
                ElectricObject eobj = h.getElectricObject();
                if (eobj instanceof PortInst) {
                    PortInst pi = (PortInst)eobj;
                    NodeInst ni = pi.getNodeInst();
                    Iterator cIt = ni.getConnections();
                    while (cIt.hasNext()) {
                        PrimitivePort pp;
                        Connection con = (Connection)cIt.next();
                        if (con.getPortInst() != pi || !(pi.getNodeInst().getProto() instanceof PrimitiveNode) || !(pp = (PrimitivePort)pi.getPortProto()).isNegatable()) continue;
                        boolean newNegated = !con.isNegated();
                        con.setNegated(newNegated);
                        ++numSet;
                    }
                }
                if (!(eobj instanceof ArcInst)) continue;
                ArcInst ai = (ArcInst)eobj;
                for (int i = 0; i < 2; ++i) {
                    PrimitivePort pp;
                    PortInst pi = ai.getPortInst(i);
                    if (!(pi.getNodeInst().getProto() instanceof PrimitiveNode) || !(pp = (PrimitivePort)pi.getPortProto()).isNegatable()) continue;
                    boolean newNegated = !ai.isNegated(i);
                    ai.setNegated(i, newNegated);
                    ++numSet;
                }
            }
            if (numSet == 0) {
                System.out.println("No ports negated");
            } else {
                System.out.println("Negated " + numSet + " ports");
                EditWindow.repaintAllContents();
            }
            return true;
        }
    }

    private static class ChangeArcProperties
    extends Job {
        private int how;
        private List highlighted;

        protected ChangeArcProperties(int how, List highlighted) {
            super("Align objects", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.how = how;
            this.highlighted = highlighted;
            this.startJob();
        }

        public boolean doIt() {
            Cell cell = WindowFrame.needCurCell();
            if (cell == null) {
                return false;
            }
            if (CircuitChanges.cantEdit(cell, null, true) != 0) {
                return false;
            }
            int numSet = 0;
            int numUnset = 0;
            Iterator it = this.highlighted.iterator();
            while (it.hasNext()) {
                ElectricObject eobj;
                Highlight h = (Highlight)it.next();
                if (h.getType() != Highlight.Type.EOBJ || !((eobj = h.getElectricObject()) instanceof ArcInst)) continue;
                ArcInst ai = (ArcInst)eobj;
                switch (this.how) {
                    case 1: {
                        if (ai.isRigid()) break;
                        ai.setRigid(true);
                        ++numSet;
                        break;
                    }
                    case 2: {
                        if (!ai.isRigid()) break;
                        ai.setRigid(false);
                        ++numSet;
                        break;
                    }
                    case 3: {
                        if (ai.isFixedAngle()) break;
                        ai.setFixedAngle(true);
                        ++numSet;
                        break;
                    }
                    case 4: {
                        if (!ai.isFixedAngle()) break;
                        ai.setFixedAngle(false);
                        ++numSet;
                        break;
                    }
                    case 5: {
                        if (ai.isHeadArrowed()) {
                            ai.setHeadArrowed(false);
                            ai.setBodyArrowed(false);
                            ++numUnset;
                            break;
                        }
                        ai.setHeadArrowed(true);
                        ai.setBodyArrowed(true);
                        ++numSet;
                        break;
                    }
                    case 6: {
                        if (ai.isHeadExtended()) {
                            ai.setHeadExtended(false);
                            ++numUnset;
                            break;
                        }
                        ai.setHeadExtended(true);
                        ++numSet;
                        break;
                    }
                    case 7: {
                        if (ai.isTailExtended()) {
                            ai.setTailExtended(false);
                            ++numUnset;
                            break;
                        }
                        ai.setTailExtended(true);
                        ++numSet;
                    }
                }
            }
            if (numSet == 0 && numUnset == 0) {
                System.out.println("No changes were made");
            } else {
                String action = "";
                boolean repaintContents = false;
                switch (this.how) {
                    case 1: {
                        action = "Rigid";
                        break;
                    }
                    case 2: {
                        action = "Non-Rigid";
                        break;
                    }
                    case 3: {
                        action = "Fixed-Angle";
                        break;
                    }
                    case 4: {
                        action = "Not-Fixed-Angle";
                        break;
                    }
                    case 5: {
                        action = "Directional";
                        repaintContents = true;
                        break;
                    }
                    case 6: {
                        action = "extend the head end";
                        repaintContents = true;
                        break;
                    }
                    case 7: {
                        action = "extend the head end";
                        repaintContents = true;
                    }
                }
                if (numUnset == 0) {
                    System.out.println("Made " + numSet + " arcs " + action);
                } else if (numSet == 0) {
                    System.out.println("Made " + numUnset + " arcs not " + action);
                } else {
                    System.out.println("Made " + numSet + " arcs " + action + "; and " + numUnset + " arcs not " + action);
                }
                if (repaintContents) {
                    EditWindow.repaintAllContents();
                } else {
                    EditWindow.repaintAll();
                }
            }
            return true;
        }
    }

    private static class AlignNodes
    extends Job {
        NodeInst[] nis;
        double[] dCX;
        double[] dCY;

        protected AlignNodes(NodeInst[] nis, double[] dCX, double[] dCY) {
            super("Align objects", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.nis = nis;
            this.dCX = dCX;
            this.dCY = dCY;
            this.startJob();
        }

        public boolean doIt() {
            int numRemoved = 0;
            for (int i = 0; i < this.nis.length; ++i) {
                NodeInst ni = this.nis[i];
                int res = CircuitChanges.cantEdit(ni.getParent(), ni, true);
                if (res < 0) {
                    return false;
                }
                if (res <= 0) continue;
                ++numRemoved;
                this.nis[i] = null;
            }
            if (numRemoved > 0) {
                int newSize = this.nis.length - numRemoved;
                if (newSize == 0) {
                    return true;
                }
                NodeInst[] nnis = new NodeInst[newSize];
                double[] nCX = new double[newSize];
                double[] nCY = new double[newSize];
                int fill = 0;
                for (int i = 0; i < this.nis.length; ++i) {
                    if (this.nis[i] == null) continue;
                    nnis[fill] = this.nis[i];
                    nCX[fill] = this.dCX[i];
                    nCY[fill] = this.dCY[i];
                    ++fill;
                }
                this.nis = nnis;
                this.dCX = nCX;
                this.dCY = nCY;
            }
            NodeInst.modifyInstances(this.nis, this.dCX, this.dCY, null, null);
            return true;
        }
    }

    private static class AlignObjects
    extends Job {
        private List list;

        protected AlignObjects(List highs) {
            super("Align Objects", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.list = highs;
            this.startJob();
        }

        public boolean doIt() {
            if (this.list.size() == 0) {
                System.out.println("Must select something before aligning it to the grid");
                return false;
            }
            if (User.getAlignmentToGrid() <= 0.0) {
                System.out.println("No alignment given: set Alignment Options first");
                return false;
            }
            int adjustedNodes = 0;
            Iterator it = this.list.iterator();
            while (it.hasNext()) {
                Connection con;
                Geometric geom = (Geometric)it.next();
                if (!(geom instanceof NodeInst)) continue;
                NodeInst ni = (NodeInst)geom;
                Point2D.Double center = new Point2D.Double(ni.getAnchorCenterX(), ni.getAnchorCenterY());
                EditWindow.gridAlign(center);
                double bodyXOffset = ((Point2D)center).getX() - ni.getAnchorCenterX();
                double bodyYOffset = ((Point2D)center).getY() - ni.getAnchorCenterY();
                double portXOffset = bodyXOffset;
                double portYOffset = bodyYOffset;
                boolean mixedportpos = false;
                boolean firstPort = true;
                Iterator pIt = ni.getPortInsts();
                while (pIt.hasNext()) {
                    PortInst pi = (PortInst)pIt.next();
                    Poly poly = pi.getPoly();
                    Point2D.Double portCenter = new Point2D.Double(poly.getCenterX(), poly.getCenterY());
                    EditWindow.gridAlign(portCenter);
                    double pXO = ((Point2D)portCenter).getX() - poly.getCenterX();
                    double pYO = ((Point2D)portCenter).getY() - poly.getCenterY();
                    if (firstPort) {
                        firstPort = false;
                        portXOffset = pXO;
                        portYOffset = pYO;
                        continue;
                    }
                    if (portXOffset == pXO && portYOffset == pYO) continue;
                    mixedportpos = true;
                }
                if (!mixedportpos) {
                    bodyXOffset = portXOffset;
                    bodyYOffset = portYOffset;
                }
                if ((bodyXOffset != 0.0 || bodyYOffset != 0.0) && ni.getProto() instanceof PrimitiveNode) {
                    AffineTransform transr = ni.rotateOut();
                    Technology tech = ni.getProto().getTechnology();
                    Poly[] polyList = tech.getShapeOfNode(ni);
                    for (int j = 0; j < polyList.length; ++j) {
                        Poly poly = polyList[j];
                        poly.transform(transr);
                        Rectangle2D bounds = poly.getBox();
                        if (bounds == null) continue;
                        Point2D.Double polyPoint1 = new Point2D.Double(bounds.getMinX(), bounds.getMinY());
                        Point2D.Double polyPoint2 = new Point2D.Double(bounds.getMaxX(), bounds.getMaxY());
                        EditWindow.gridAlign(polyPoint1);
                        EditWindow.gridAlign(polyPoint2);
                        if (((Point2D)polyPoint1).getX() == bounds.getMinX() && ((Point2D)polyPoint2).getX() == bounds.getMaxX()) {
                            bodyXOffset = 0.0;
                        }
                        if (((Point2D)polyPoint1).getY() == bounds.getMinY() && ((Point2D)polyPoint2).getY() == bounds.getMaxY()) {
                            bodyYOffset = 0.0;
                        }
                        if (bodyXOffset == 0.0 && bodyYOffset == 0.0) break;
                    }
                }
                if (bodyXOffset == 0.0 && bodyYOffset == 0.0) continue;
                HashMap<ArcInst, Integer> constraints = new HashMap<ArcInst, Integer>();
                Iterator aIt = ni.getConnections();
                while (aIt.hasNext()) {
                    con = (Connection)aIt.next();
                    ArcInst ai = con.getArc();
                    int constr = 0;
                    if (ai.isRigid()) {
                        constr |= 1;
                    }
                    if (ai.isFixedAngle()) {
                        constr |= 2;
                    }
                    constraints.put(ai, new Integer(constr));
                }
                ni.move(bodyXOffset, bodyYOffset);
                ++adjustedNodes;
                aIt = ni.getConnections();
                while (aIt.hasNext()) {
                    con = (Connection)aIt.next();
                    ArcInst ai = con.getArc();
                    Integer constr = (Integer)constraints.get(ai);
                    if (constr == null) continue;
                    if ((constr & 1) != 0) {
                        ai.setRigid(true);
                    }
                    if ((constr & 2) == 0) continue;
                    ai.setFixedAngle(true);
                }
            }
            int adjustedArcs = 0;
            Iterator it2 = this.list.iterator();
            while (it2.hasNext()) {
                int ang;
                ArcInst ai;
                Geometric geom = (Geometric)it2.next();
                if (!(geom instanceof ArcInst) || !(ai = (ArcInst)geom).isLinked()) continue;
                EPoint origHead = ai.getHeadLocation();
                EPoint origTail = ai.getTailLocation();
                Point2D.Double arcHead = new Point2D.Double(((Point2D)origHead).getX(), ((Point2D)origHead).getY());
                Point2D.Double arcTail = new Point2D.Double(((Point2D)origTail).getX(), ((Point2D)origTail).getY());
                EditWindow.gridAlign(arcHead);
                EditWindow.gridAlign(arcTail);
                double headXOff = ((Point2D)arcHead).getX() - ((Point2D)origHead).getX();
                double headYOff = ((Point2D)arcHead).getY() - ((Point2D)origHead).getY();
                double tailXOff = ((Point2D)arcTail).getX() - ((Point2D)origTail).getX();
                double tailYOff = ((Point2D)arcTail).getY() - ((Point2D)origTail).getY();
                if (headXOff == 0.0 && tailXOff == 0.0 && headYOff == 0.0 && tailYOff == 0.0) continue;
                if (!ai.headStillInPort(arcHead, false)) {
                    if (!ai.headStillInPort(origHead, false)) continue;
                    headYOff = 0.0;
                    headXOff = 0.0;
                }
                if (!ai.tailStillInPort(arcTail, false)) {
                    if (!ai.tailStillInPort(origTail, false)) continue;
                    tailYOff = 0.0;
                    tailXOff = 0.0;
                }
                if ((ang = ai.getAngle()) == 0 || ang == 1800) {
                    if (headYOff != tailYOff) {
                        tailYOff = 0.0;
                        headYOff = 0.0;
                    }
                } else if ((ang == 900 || ang == 2700) && headXOff != tailXOff) {
                    tailXOff = 0.0;
                    headXOff = 0.0;
                }
                if (headXOff == 0.0 && tailXOff == 0.0 && headYOff == 0.0 && tailYOff == 0.0) continue;
                int constr = 0;
                if (ai.isRigid()) {
                    constr |= 1;
                }
                if (ai.isFixedAngle()) {
                    constr |= 2;
                }
                ai.setRigid(false);
                ai.setFixedAngle(false);
                ai.modify(0.0, headXOff, headYOff, tailXOff, tailYOff);
                ++adjustedArcs;
                if ((constr & 1) != 0) {
                    ai.setRigid(true);
                }
                if ((constr & 2) == 0) continue;
                ai.setFixedAngle(true);
            }
            if (adjustedNodes == 0 && adjustedArcs == 0) {
                System.out.println("No adjustments necessary");
            } else {
                System.out.println("Adjusted " + adjustedNodes + " nodes and " + adjustedArcs + " arcs");
            }
            return true;
        }
    }

    private static class RotateSelected
    extends Job {
        private Cell cell;
        private int amount;
        private boolean mirror;
        private boolean mirrorH;
        private List highs;

        protected RotateSelected(Cell cell, List highs, int amount, boolean mirror, boolean mirrorH) {
            super("Rotate selected objects", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.amount = amount;
            this.mirror = mirror;
            this.mirrorH = mirrorH;
            this.highs = highs;
            this.startJob();
        }

        public boolean doIt() {
            NodeInst ni;
            if (CircuitChanges.cantEdit(this.cell, null, true) != 0) {
                return false;
            }
            HashSet<Geometric> markObj = new HashSet<Geometric>();
            int nicount = 0;
            NodeInst theNi = null;
            Rectangle2D.Double selectedBounds = new Rectangle2D.Double();
            Iterator it = this.highs.iterator();
            while (it.hasNext()) {
                Geometric geom = (Geometric)it.next();
                if (!(geom instanceof NodeInst)) continue;
                ni = (NodeInst)geom;
                if (CircuitChanges.cantEdit(this.cell, ni, true) != 0) {
                    return false;
                }
                markObj.add(ni);
                if (nicount == 0) {
                    ((Rectangle2D)selectedBounds).setRect(ni.getBounds());
                } else {
                    Rectangle2D.union(selectedBounds, ni.getBounds(), selectedBounds);
                }
                theNi = ni;
                ++nicount;
            }
            if (nicount <= 0) {
                System.out.println("Must select at least 1 node for rotation");
                return false;
            }
            if (nicount > 1) {
                Point2D.Double center = new Point2D.Double(selectedBounds.getCenterX(), selectedBounds.getCenterY());
                theNi = null;
                double bestdist = 2.147483647E9;
                Iterator it2 = this.cell.getNodes();
                while (it2.hasNext()) {
                    NodeInst ni2 = (NodeInst)it2.next();
                    if (!markObj.contains(ni2)) continue;
                    double dist = center.distance(ni2.getTrueCenter());
                    if (theNi != null && !(dist < bestdist)) continue;
                    theNi = ni2;
                    bestdist = dist;
                }
            }
            markObj.clear();
            it = this.highs.iterator();
            while (it.hasNext()) {
                Geometric geom = (Geometric)it.next();
                if (!(geom instanceof ArcInst)) continue;
                ArcInst ai = (ArcInst)geom;
                markObj.add(ai);
            }
            CircuitChanges.spreadRotateConnection(theNi, markObj);
            it = this.highs.iterator();
            while (it.hasNext()) {
                Geometric geom = (Geometric)it.next();
                if (!(geom instanceof NodeInst)) continue;
                ni = (NodeInst)geom;
                CircuitChanges.spreadRotateConnection(ni, markObj);
            }
            Orientation dOrient = this.mirror ? (this.mirrorH ? Orientation.Y : Orientation.X) : Orientation.fromAngle(this.amount);
            AffineTransform trans = dOrient.rotateAbout(theNi.getAnchorCenter());
            Point2D.Double tmpPt1 = new Point2D.Double();
            Point2D.Double tmpPt2 = new Point2D.Double();
            Iterator it3 = markObj.iterator();
            while (it3.hasNext()) {
                Geometric geom = (Geometric)it3.next();
                if (!(geom instanceof NodeInst)) continue;
                NodeInst ni3 = (NodeInst)geom;
                trans.transform(ni3.getAnchorCenter(), tmpPt1);
                ni3.rotate(dOrient);
                ni3.move(tmpPt1.getX() - ni3.getAnchorCenterX(), tmpPt1.getY() - ni3.getAnchorCenterY());
            }
            it3 = markObj.iterator();
            while (it3.hasNext()) {
                Geometric geom = (Geometric)it3.next();
                if (!(geom instanceof ArcInst)) continue;
                ArcInst ai = (ArcInst)geom;
                if (markObj.contains(ai.getHeadPortInst().getNodeInst())) {
                    trans.transform(ai.getHeadLocation(), tmpPt1);
                } else {
                    tmpPt1.setLocation(ai.getHeadLocation());
                }
                if (markObj.contains(ai.getTailPortInst().getNodeInst())) {
                    trans.transform(ai.getTailLocation(), tmpPt2);
                } else {
                    tmpPt2.setLocation(ai.getTailLocation());
                }
                ai.modify(0.0, tmpPt1.getX() - ai.getHeadLocation().getX(), tmpPt1.getY() - ai.getHeadLocation().getY(), tmpPt2.getX() - ai.getTailLocation().getX(), tmpPt2.getY() - ai.getTailLocation().getY());
            }
            return true;
        }
    }
}

