/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellId;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.prototype.NodeProtoId;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.prototype.PortProtoId;

public final class ExportId
implements PortProtoId {
    public final CellId parentId;
    public final int chronIndex;

    ExportId(CellId parentId, int chronIndex) {
        this.parentId = parentId;
        this.chronIndex = chronIndex;
    }

    public NodeProtoId getParentId() {
        return this.parentId;
    }

    public int getChronIndex() {
        return this.chronIndex;
    }

    public PortProto inCurrentThread() {
        Cell cell = Cell.inCurrentThread(this.parentId);
        if (cell == null) {
            return null;
        }
        return cell.getExportChron(this.chronIndex);
    }

    public String toString() {
        Export e;
        String s = "ExportId#" + this.parentId.cellIndex + "." + this.chronIndex;
        Cell cell = Cell.inCurrentThread(this.parentId);
        if (cell != null && (e = cell.getExportChron(this.chronIndex)) != null) {
            s = s + "(" + cell.libDescribe() + ":" + e.getName() + ")";
        }
        return s;
    }
}

