/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.simulation.Simulation;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FastHenryTab
extends PreferencePanel {
    private boolean initialUseSingleFrequency;
    private double initialFreqStart;
    private double initialFreqEnd;
    private int initialRunsPerDecade;
    private boolean initialMultiPole;
    private int initialNumPoles;
    private double initialDefThickness;
    private int initialWidthSubdivisions;
    private int initialHeightSubdivisions;
    private double initialMaxSegLength;
    private JPanel fastHenry;
    private JTextField fhDefaultHeightSubs;
    private JTextField fhDefaultThickness;
    private JTextField fhDefaultWidthSubs;
    private JLabel fhFreqEndLabel;
    private JTextField fhFrequencyEnd;
    private JTextField fhFrequencyStart;
    private JCheckBox fhMakeMultipole;
    private JTextField fhMaxSegmentLength;
    private JLabel fhNumPolesLabel;
    private JTextField fhNumberOfPoles;
    private JTextField fhRunsPerDecade;
    private JLabel fhRunsPerDecadeLabel;
    private JCheckBox fhUseSingleFrequency;
    private JLabel jLabel55;
    private JLabel jLabel59;
    private JLabel jLabel60;
    private JLabel jLabel61;
    private JLabel jLabel62;

    public FastHenryTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.fastHenry;
    }

    public String getName() {
        return "Fast Henry";
    }

    public void init() {
        this.initialUseSingleFrequency = Simulation.isFastHenryUseSingleFrequency();
        this.fhUseSingleFrequency.setSelected(this.initialUseSingleFrequency);
        this.fhUseSingleFrequency.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FastHenryTab.this.updateWhatIsEnabled();
            }
        });
        this.initialFreqStart = Simulation.getFastHenryStartFrequency();
        this.fhFrequencyStart.setText(TextUtils.formatDouble(this.initialFreqStart));
        this.initialFreqEnd = Simulation.getFastHenryEndFrequency();
        this.fhFrequencyEnd.setText(TextUtils.formatDouble(this.initialFreqEnd));
        this.initialRunsPerDecade = Simulation.getFastHenryRunsPerDecade();
        this.fhRunsPerDecade.setText(Integer.toString(this.initialRunsPerDecade));
        this.initialMultiPole = Simulation.isFastHenryMultiPole();
        this.fhMakeMultipole.setSelected(this.initialMultiPole);
        this.fhMakeMultipole.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FastHenryTab.this.updateWhatIsEnabled();
            }
        });
        this.initialNumPoles = Simulation.getFastHenryNumPoles();
        this.fhNumberOfPoles.setText(Integer.toString(this.initialNumPoles));
        this.initialDefThickness = Simulation.getFastHenryDefThickness();
        this.fhDefaultThickness.setText(TextUtils.formatDouble(this.initialDefThickness));
        this.initialWidthSubdivisions = Simulation.getFastHenryWidthSubdivisions();
        this.fhDefaultWidthSubs.setText(Integer.toString(this.initialWidthSubdivisions));
        this.initialHeightSubdivisions = Simulation.getFastHenryHeightSubdivisions();
        this.fhDefaultHeightSubs.setText(Integer.toString(this.initialHeightSubdivisions));
        this.initialMaxSegLength = Simulation.getFastHenryMaxSegLength();
        this.fhMaxSegmentLength.setText(TextUtils.formatDouble(this.initialMaxSegLength));
        this.updateWhatIsEnabled();
    }

    private void updateWhatIsEnabled() {
        this.fhFrequencyEnd.setEnabled(!this.fhUseSingleFrequency.isSelected());
        this.fhFreqEndLabel.setEnabled(!this.fhUseSingleFrequency.isSelected());
        this.fhRunsPerDecade.setEnabled(!this.fhUseSingleFrequency.isSelected());
        this.fhRunsPerDecadeLabel.setEnabled(!this.fhUseSingleFrequency.isSelected());
        this.fhNumberOfPoles.setEnabled(this.fhMakeMultipole.isSelected());
        this.fhNumPolesLabel.setEnabled(this.fhMakeMultipole.isSelected());
    }

    public void term() {
        double currentMaxSegLength;
        int currentHeightSubdivisions;
        int currentWidthSubdivisions;
        double currentDefThickness;
        int currentNumPoles;
        boolean currentMultiPole;
        int currentRunsPerDecade;
        double currentFreqEnd;
        double currentFreqStart;
        boolean currentUseSingleFrequency = this.fhUseSingleFrequency.isSelected();
        if (currentUseSingleFrequency != this.initialUseSingleFrequency) {
            Simulation.setFastHenryUseSingleFrequency(currentUseSingleFrequency);
        }
        if ((currentFreqStart = TextUtils.atof(this.fhFrequencyStart.getText())) != this.initialFreqStart) {
            Simulation.setFastHenryStartFrequency(currentFreqStart);
        }
        if ((currentFreqEnd = TextUtils.atof(this.fhFrequencyEnd.getText())) != this.initialFreqEnd) {
            Simulation.setFastHenryEndFrequency(currentFreqEnd);
        }
        if ((currentRunsPerDecade = TextUtils.atoi(this.fhRunsPerDecade.getText())) != this.initialRunsPerDecade) {
            Simulation.setFastHenryRunsPerDecade(currentRunsPerDecade);
        }
        if ((currentMultiPole = this.fhMakeMultipole.isSelected()) != this.initialMultiPole) {
            Simulation.setFastHenryMultiPole(currentMultiPole);
        }
        if ((currentNumPoles = TextUtils.atoi(this.fhNumberOfPoles.getText())) != this.initialNumPoles) {
            Simulation.setFastHenryNumPoles(currentNumPoles);
        }
        if ((currentDefThickness = TextUtils.atof(this.fhDefaultThickness.getText())) != this.initialDefThickness) {
            Simulation.setFastHenryDefThickness(currentDefThickness);
        }
        if ((currentWidthSubdivisions = TextUtils.atoi(this.fhDefaultWidthSubs.getText())) != this.initialWidthSubdivisions) {
            Simulation.setFastHenryWidthSubdivisions(currentWidthSubdivisions);
        }
        if ((currentHeightSubdivisions = TextUtils.atoi(this.fhDefaultHeightSubs.getText())) != this.initialHeightSubdivisions) {
            Simulation.setFastHenryHeightSubdivisions(currentHeightSubdivisions);
        }
        if ((currentMaxSegLength = TextUtils.atof(this.fhMaxSegmentLength.getText())) != this.initialMaxSegLength) {
            Simulation.setFastHenryMaxSegLength(currentMaxSegLength);
        }
    }

    private void initComponents() {
        this.fastHenry = new JPanel();
        this.fhUseSingleFrequency = new JCheckBox();
        this.jLabel55 = new JLabel();
        this.fhFreqEndLabel = new JLabel();
        this.fhRunsPerDecadeLabel = new JLabel();
        this.fhMakeMultipole = new JCheckBox();
        this.fhNumPolesLabel = new JLabel();
        this.fhFrequencyStart = new JTextField();
        this.fhFrequencyEnd = new JTextField();
        this.fhRunsPerDecade = new JTextField();
        this.fhNumberOfPoles = new JTextField();
        this.jLabel59 = new JLabel();
        this.jLabel60 = new JLabel();
        this.jLabel61 = new JLabel();
        this.jLabel62 = new JLabel();
        this.fhDefaultThickness = new JTextField();
        this.fhDefaultWidthSubs = new JTextField();
        this.fhDefaultHeightSubs = new JTextField();
        this.fhMaxSegmentLength = new JTextField();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Tool Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                FastHenryTab.this.closeDialog(evt);
            }
        });
        this.fastHenry.setLayout(new GridBagLayout());
        this.fhUseSingleFrequency.setText("Use single frequency");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.fastHenry.add((Component)this.fhUseSingleFrequency, gridBagConstraints);
        this.jLabel55.setText("Frequency start:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 20, 4, 4);
        this.fastHenry.add((Component)this.jLabel55, gridBagConstraints);
        this.fhFreqEndLabel.setText("Frequency end:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 20, 4, 4);
        this.fastHenry.add((Component)this.fhFreqEndLabel, gridBagConstraints);
        this.fhRunsPerDecadeLabel.setText("Runs per decade:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 20, 4, 4);
        this.fastHenry.add((Component)this.fhRunsPerDecadeLabel, gridBagConstraints);
        this.fhMakeMultipole.setText("Make multipole subcircuit");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.fastHenry.add((Component)this.fhMakeMultipole, gridBagConstraints);
        this.fhNumPolesLabel.setText("Number of poles:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 20, 4, 4);
        this.fastHenry.add((Component)this.fhNumPolesLabel, gridBagConstraints);
        this.fhFrequencyStart.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.fastHenry.add((Component)this.fhFrequencyStart, gridBagConstraints);
        this.fhFrequencyEnd.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.fastHenry.add((Component)this.fhFrequencyEnd, gridBagConstraints);
        this.fhRunsPerDecade.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.fastHenry.add((Component)this.fhRunsPerDecade, gridBagConstraints);
        this.fhNumberOfPoles.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.fastHenry.add((Component)this.fhNumberOfPoles, gridBagConstraints);
        this.jLabel59.setText("Default thickness:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.fastHenry.add((Component)this.jLabel59, gridBagConstraints);
        this.jLabel60.setText("Default width subdivisions:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.fastHenry.add((Component)this.jLabel60, gridBagConstraints);
        this.jLabel61.setText("Default height subdivisions:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.fastHenry.add((Component)this.jLabel61, gridBagConstraints);
        this.jLabel62.setText("Maximum segment length:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.fastHenry.add((Component)this.jLabel62, gridBagConstraints);
        this.fhDefaultThickness.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.fastHenry.add((Component)this.fhDefaultThickness, gridBagConstraints);
        this.fhDefaultWidthSubs.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.fastHenry.add((Component)this.fhDefaultWidthSubs, gridBagConstraints);
        this.fhDefaultHeightSubs.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.fastHenry.add((Component)this.fhDefaultHeightSubs, gridBagConstraints);
        this.fhMaxSegmentLength.setColumns(8);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.fastHenry.add((Component)this.fhMaxSegmentLength, gridBagConstraints);
        this.getContentPane().add((Component)this.fastHenry, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

