/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.gates;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.tool.generator.layout.FoldedMos;
import com.sun.electric.tool.generator.layout.FoldedNmos;
import com.sun.electric.tool.generator.layout.FoldedPmos;
import com.sun.electric.tool.generator.layout.FoldsAndWidth;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.Tech;
import com.sun.electric.tool.generator.layout.TrackRouter;
import com.sun.electric.tool.generator.layout.TrackRouterH;

public class Nand3_star_sy3 {
    private static final double nmosTop = -9.0;
    private static final double pmosBot = 9.0;
    private static final double wellOverhangDiff = 6.0;
    private static final double incY = -4.0;
    private static final double inaY = 4.0;
    private static final double outHiY = 11.0;
    private static final double outLoY = -11.0;

    private static void error(boolean pred, String msg) {
        LayoutLib.error(pred, msg);
    }

    public static Cell makePart(double sz, String threshold, StdCellParams stdCell) {
        int i;
        int i2;
        sz = stdCell.roundSize(sz);
        Nand3_star_sy3.error(!threshold.equals("") && !threshold.equals("LT"), "Nand3_sy3: threshold not \"\" or \"LT\": " + threshold);
        String nm = "nand3" + threshold + "_sy3";
        sz = stdCell.checkMinStrength(sz, threshold.equals("LT") ? 1.5 : 1.0, nm);
        double spaceAvail = stdCell.getCellTop() - 8.5 - 9.0;
        double lamPerSz = threshold.equals("LT") ? 2.0 : 6.0;
        double totWid = sz * lamPerSz * 3.0;
        FoldsAndWidth fwP = stdCell.calcFoldsAndWidth(spaceAvail, totWid, 3);
        Nand3_star_sy3.error(fwP == null, "can't make " + nm + " this small: " + sz);
        int nbStackedN = 3;
        spaceAvail = -9.0 - (stdCell.getCellBot() + 2.0 + 3.0 + 5.0 + 1.5);
        totWid = sz * 3.0 * (double)nbStackedN;
        FoldsAndWidth fwN = stdCell.calcFoldsAndWidth(spaceAvail, totWid, 3);
        Nand3_star_sy3.error(fwN == null, "can't make " + nm + " this small: " + sz);
        Cell nand = stdCell.findPart(nm, sz);
        if (nand != null) {
            return nand;
        }
        nand = stdCell.newPart(nm, sz);
        double inaX = 3.5;
        double inbX = inaX + 2.0 + 3.0 + 2.0;
        double jogaX = inbX + 2.0 + 3.0 + 2.0;
        double nmosX = jogaX + 2.0 + 3.0 + 2.0;
        FoldedNmos nmos = new FoldedNmos(nmosX, -9.0 - fwN.physWid / 2.0, fwN.nbFolds, nbStackedN, fwN.gateWid, nand, stdCell);
        double pmosY = 9.0 + fwP.physWid / 2.0;
        FoldedMos[] pmoss = new FoldedMos[(int)Math.ceil((double)fwP.nbFolds / 12.0)];
        for (int i3 = 0; i3 < pmoss.length; ++i3) {
            double pmosPitch = 108.0;
            double pmosX = nmosX + 6.0 + (double)i3 * pmosPitch;
            int nbFolds = Math.min(12, fwP.nbFolds - i3 * 12);
            pmoss[i3] = new FoldedPmos(pmosX, pmosY, nbFolds, 1, fwP.gateWid, nand, stdCell);
        }
        stdCell.wireVddGnd(nmos, StdCellParams.EVEN, nand);
        stdCell.wireVddGnd(pmoss, StdCellParams.EVEN, nand);
        double inaHiY = 11.0;
        LayoutLib.newExport(nand, "ina", PortCharacteristic.IN, Tech.m1, 4.0, inaX, inaHiY);
        TrackRouterH inaHi = new TrackRouterH(Tech.m2, 3.0, inaHiY, nand);
        inaHi.connect(nand.findExport("ina"));
        PortInst joga = LayoutLib.newNodeInst(Tech.m1pin, jogaX, inaHiY, 3.0, 3.0, 0.0, nand).getOnlyPortInst();
        inaHi.connect(joga);
        TrackRouterH inaLo = new TrackRouterH(Tech.m1, 3.0, 4.0, nand);
        inaLo.connect(joga);
        block43: for (i2 = 0; i2 < fwN.nbFolds; ++i2) {
            switch (i2 % 6) {
                case 0: {
                    ((TrackRouter)inaLo).connect(nmos.getGate(i2 * 3 + 0, 'T'), -4.0, -3.5);
                    continue block43;
                }
                case 1: {
                    inaLo.connect(nmos.getGate(i2 * 3 + 1, 'T'), -1.0);
                    continue block43;
                }
                case 2: {
                    inaLo.connect(nmos.getGate(i2 * 3 + 2, 'T'));
                    continue block43;
                }
                case 3: {
                    inaLo.connect(nmos.getGate(i2 * 3 + 0, 'T'));
                    continue block43;
                }
                case 4: {
                    inaLo.connect(nmos.getGate(i2 * 3 + 1, 'T'), 1.0);
                    continue block43;
                }
                case 5: {
                    ((TrackRouter)inaLo).connect(nmos.getGate(i2 * 3 + 2, 'T'), 4.0, -3.5);
                }
            }
        }
        for (i2 = 0; i2 < pmoss.length; ++i2) {
            block45: for (int j = 0; j < pmoss[i2].nbGates(); ++j) {
                switch (j % 12) {
                    case 2: {
                        inaLo.connect(pmoss[i2].getGate(j, 'B'));
                        continue block45;
                    }
                    case 5: {
                        inaLo.connect(pmoss[i2].getGate(j, 'B'));
                        continue block45;
                    }
                    case 6: {
                        inaLo.connect(pmoss[i2].getGate(j, 'B'));
                        continue block45;
                    }
                    case 9: {
                        inaLo.connect(pmoss[i2].getGate(j, 'B'));
                    }
                }
            }
        }
        double gndBot = stdCell.getGndY() - stdCell.getGndWidth() / 2.0;
        double inbLoY = gndBot - 3.0 - 2.0;
        double nmosBot = -9.0 - fwN.physWid;
        inbLoY = Math.min(inbLoY, nmosBot - 2.0 - 3.0 - 2.5);
        double spFromVdd = stdCell.getVddY() + stdCell.getVddWidth() / 2.0 + 3.0 + 2.0;
        double spFromPmos = 9.0 + fwP.physWid + 2.0 + 2.5;
        double inbHiY = Math.max(spFromVdd, spFromPmos);
        LayoutLib.newExport(nand, "inb", PortCharacteristic.IN, Tech.m1, 4.0, inbX, inbHiY);
        TrackRouterH inbHi = new TrackRouterH(Tech.m1, 3.0, inbHiY, nand);
        inbHi.connect(nand.findExport("inb"));
        for (int i4 = 0; i4 < pmoss.length; ++i4) {
            block47: for (int j = 0; j < pmoss[i4].nbGates(); ++j) {
                switch (j % 12) {
                    case 0: {
                        inbHi.connect(pmoss[i4].getGate(j, 'T'));
                        continue block47;
                    }
                    case 4: {
                        inbHi.connect(pmoss[i4].getGate(j, 'T'));
                        continue block47;
                    }
                    case 7: {
                        inbHi.connect(pmoss[i4].getGate(j, 'T'));
                        continue block47;
                    }
                    case 11: {
                        inbHi.connect(pmoss[i4].getGate(j, 'T'));
                    }
                }
            }
        }
        TrackRouterH inbLo = new TrackRouterH(Tech.m1, 3.0, inbLoY, nand);
        inbLo.connect(nand.findExport("inb"));
        block48: for (int i5 = 0; i5 < fwN.nbFolds; ++i5) {
            switch (i5 % 6) {
                case 0: {
                    inbLo.connect(nmos.getGate(i5 * 3 + 1, 'B'));
                    continue block48;
                }
                case 1: {
                    inbLo.connect(nmos.getGate(i5 * 3 + 0, 'B'));
                    continue block48;
                }
                case 2: {
                    inbLo.connect(nmos.getGate(i5 * 3 + 0, 'B'));
                    continue block48;
                }
                case 3: {
                    inbLo.connect(nmos.getGate(i5 * 3 + 2, 'B'));
                    continue block48;
                }
                case 4: {
                    inbLo.connect(nmos.getGate(i5 * 3 + 2, 'B'));
                    continue block48;
                }
                case 5: {
                    inbLo.connect(nmos.getGate(i5 * 3 + 1, 'B'));
                }
            }
        }
        TrackRouterH inc = new TrackRouterH(Tech.m1, 3.0, -4.0, nand);
        block49: for (i = 0; i < fwN.nbFolds; ++i) {
            switch (i % 6) {
                case 0: {
                    inc.connect(nmos.getGate(i * 3 + 2, 'T'), 1.5);
                    continue block49;
                }
                case 1: {
                    inc.connect(nmos.getGate(i * 3 + 2, 'T'), 1.5);
                    continue block49;
                }
                case 2: {
                    ((TrackRouter)inc).connect(nmos.getGate(i * 3 + 1, 'T'), -11.5, 1.0);
                    continue block49;
                }
                case 3: {
                    ((TrackRouter)inc).connect(nmos.getGate(i * 3 + 1, 'T'), 11.5, 1.0);
                    continue block49;
                }
                case 4: {
                    inc.connect(nmos.getGate(i * 3 + 0, 'T'), -1.5);
                    continue block49;
                }
                case 5: {
                    inc.connect(nmos.getGate(i * 3 + 0, 'T'), -1.5);
                }
            }
        }
        for (i = 0; i < pmoss.length; ++i) {
            block51: for (int j = 0; j < pmoss[i].nbGates(); ++j) {
                switch (j % 12) {
                    case 1: {
                        ((TrackRouter)inc).connect(pmoss[i].getGate(j, 'B'), -2.5, 3.5);
                        continue block51;
                    }
                    case 3: {
                        ((TrackRouter)inc).connect(pmoss[i].getGate(j, 'B'), -0.5, 0.0);
                        continue block51;
                    }
                    case 8: {
                        ((TrackRouter)inc).connect(pmoss[i].getGate(j, 'B'), 0.5, 0.0);
                        continue block51;
                    }
                    case 10: {
                        ((TrackRouter)inc).connect(pmoss[i].getGate(j, 'B'), 2.5, 3.5);
                    }
                }
            }
        }
        double incX = StdCellParams.getRightDiffX(nmos) + 2.0 + 3.0 + 2.0;
        LayoutLib.newExport(nand, "inc", PortCharacteristic.IN, Tech.m1, 4.0, incX, -4.0);
        inc.connect(nand.findExport("inc"));
        double outX = incX + 2.0 + 3.0 + 2.0;
        LayoutLib.newExport(nand, "out", PortCharacteristic.OUT, Tech.m1, 4.0, outX, 11.0);
        TrackRouterH outHi = new TrackRouterH(Tech.m2, 4.0, 11.0, nand);
        outHi.connect(nand.findExport("out"));
        for (int i6 = 0; i6 < pmoss.length; ++i6) {
            for (int j = 1; j < pmoss[i6].nbSrcDrns(); j += 2) {
                outHi.connect(pmoss[i6].getSrcDrn(j));
            }
        }
        TrackRouterH outLo = new TrackRouterH(Tech.m2, 4.0, -11.0, nand);
        outLo.connect(nand.findExport("out"));
        for (int i7 = 1; i7 < nmos.nbSrcDrns(); i7 += 2) {
            outLo.connect(nmos.getSrcDrn(i7));
        }
        double wellMinX = 0.0;
        double wellMaxX = outX + 2.0 + 1.5;
        stdCell.addNmosWell(wellMinX, wellMaxX, nand);
        stdCell.addPmosWell(wellMinX, wellMaxX, nand);
        stdCell.addEssentialBounds(wellMinX, wellMaxX, nand);
        stdCell.doNCC(nand, nm + "{sch}");
        return nand;
    }
}

