/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.generator.layout.CapCell;
import com.sun.electric.tool.generator.layout.CapFloorplan;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.Tech;
import com.sun.electric.tool.generator.layout.VddGndStraps;

class CapLayer
implements VddGndStraps {
    private CapCell capCell;
    private NodeInst capCellInst;
    private CapFloorplan plan;
    private String vddName;
    private String gndName;

    public CapLayer(Library lib, CapFloorplan plan, CapCell capCell, Cell cell, StdCellParams stdCell) {
        this.plan = plan;
        this.capCell = capCell;
        this.vddName = stdCell.getVddExportName();
        this.gndName = stdCell.getGndExportName();
        double angle = plan.horizontal ? 0.0 : 90.0;
        this.capCellInst = LayoutLib.newNodeInst(capCell.getCell(), 0.0, 0.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, angle, cell);
    }

    public boolean isHorizontal() {
        return this.plan.horizontal;
    }

    public int numVdd() {
        return this.capCell.numVdd();
    }

    public PortInst getVdd(int n) {
        return this.capCellInst.findPortInst(this.vddName + "_" + n);
    }

    public double getVddCenter(int n) {
        PortInst pi = this.getVdd(n);
        return this.plan.horizontal ? LayoutLib.roundCenterY(pi) : LayoutLib.roundCenterX(pi);
    }

    public double getVddWidth(int n) {
        return this.capCell.getVddWidth();
    }

    public int numGnd() {
        return this.capCell.numGnd();
    }

    public PortInst getGnd(int n) {
        return this.capCellInst.findPortInst(this.gndName + "_" + n);
    }

    public double getGndCenter(int n) {
        PortInst pi = this.getGnd(n);
        return this.plan.horizontal ? LayoutLib.roundCenterY(pi) : LayoutLib.roundCenterX(pi);
    }

    public double getGndWidth(int n) {
        return this.capCell.getGndWidth();
    }

    public PrimitiveNode getPinType() {
        return Tech.m1pin;
    }

    public PrimitiveArc getMetalType() {
        return Tech.m1;
    }

    public double getCellWidth() {
        return this.plan.cellWidth;
    }

    public double getCellHeight() {
        return this.plan.cellHeight;
    }

    public int getLayerNumber() {
        return 1;
    }
}

