/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.erc;

import com.sun.electric.Main;
import com.sun.electric.database.geometry.GeometryHandler;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.geometry.PolyMerge;
import com.sun.electric.database.geometry.PolyQTree;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.DRCRules;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.erc.ERC;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.ui.EditWindow;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ERCWellCheck {
    Cell cell;
    boolean newAlgorithm;
    ErrorLogger errorLogger;
    Highlighter highlighter;
    List wellCons = new ArrayList();
    List wellAreas = new ArrayList();
    HashMap cellMerges = new HashMap();
    HashMap doneCells = new HashMap();
    WellCheckJob job;
    private static final int ERCPWell = 1;
    private static final int ERCNWell = 2;
    private static final int ERCPSelect = 3;
    private static final int ERCNSelect = 4;
    private static final int ERCPSEUDO = 0;
    private static final List ercLayers = new ArrayList(7);

    public ERCWellCheck(Cell cell, WellCheckJob job, boolean newAlgorithm, Highlighter highlighter) {
        this.job = job;
        this.newAlgorithm = newAlgorithm;
        this.cell = cell;
        this.highlighter = highlighter;
    }

    public static void analyzeCurCell(boolean newAlgorithm) {
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        Cell curCell = wnd.getCell();
        if (curCell == null) {
            return;
        }
        WellCheckJob job = new WellCheckJob(curCell, newAlgorithm, highlighter);
    }

    public static int checkERCWell(Cell cell, WellCheckJob job, boolean newAlgorithm, Highlighter highlighter) {
        ERCWellCheck check = new ERCWellCheck(cell, job, newAlgorithm, highlighter);
        return check.doIt();
    }

    public int doIt() {
        ErrorLogger.MessageLog err;
        Iterator it;
        long startTime = System.currentTimeMillis();
        this.errorLogger = ErrorLogger.newInstance("ERC Well Check ");
        System.out.println("Checking Wells and Substrates in '" + this.cell.libDescribe() + "' ...");
        if (Main.getDebug()) {
            System.out.println("Free v/s Total Memory " + Runtime.getRuntime().freeMemory() + " / " + Runtime.getRuntime().totalMemory());
        }
        Visitor wcVisitor = new Visitor(this);
        HierarchyEnumerator.enumerateCell(this.cell, VarContext.globalContext, null, wcVisitor);
        if (this.job != null && this.job.checkForAbort()) {
            return 0;
        }
        int wellIndex = 0;
        GeometryHandler topMerge = (GeometryHandler)this.cellMerges.get(this.cell);
        Iterator it2 = topMerge.getKeyIterator();
        while (it2.hasNext()) {
            Layer layer = (Layer)it2.next();
            Collection set = topMerge.getObjects(layer, false, true);
            Iterator pIt = set.iterator();
            while (pIt.hasNext()) {
                WellArea wa = new WellArea();
                PolyBase poly = null;
                if (this.newAlgorithm) {
                    PolyQTree.PolyNode pn = (PolyQTree.PolyNode)pIt.next();
                    poly = new PolyBase(pn.getPoints());
                } else {
                    poly = (PolyBase)pIt.next();
                }
                wa.poly = poly;
                wa.poly.setLayer(layer);
                wa.poly.setStyle(Poly.Type.FILLED);
                wa.index = wellIndex++;
                this.wellAreas.add(wa);
            }
        }
        if (Main.getDebug()) {
            System.out.println("Found " + this.wellAreas.size() + " well/select areas and " + this.wellCons.size() + " contact regions (took " + TextUtils.getElapsedTime(System.currentTimeMillis() - startTime) + ")");
            System.out.println("Free v/s Total Memory Intermediate step: " + Runtime.getRuntime().freeMemory() + " / " + Runtime.getRuntime().totalMemory());
        }
        boolean foundPWell = false;
        boolean foundNWell = false;
        Iterator it3 = this.wellAreas.iterator();
        while (it3.hasNext()) {
            WellArea wa = (WellArea)it3.next();
            int wellType = ERCWellCheck.getWellLayerType(wa.poly.getLayer());
            if (wellType != 1 && wellType != 2) continue;
            PrimitiveNode.Function desiredContact = PrimitiveNode.Function.SUBSTRATE;
            String noContactError = "No N-Well contact found in this area";
            int contactAction = ERC.getNWellCheck();
            if (wellType == 1) {
                desiredContact = PrimitiveNode.Function.WELL;
                contactAction = ERC.getPWellCheck();
                noContactError = "No P-Well contact found in this area";
                foundPWell = true;
            } else {
                foundNWell = true;
            }
            boolean found = false;
            Iterator cIt = this.wellCons.iterator();
            while (cIt.hasNext()) {
                WellCon wc = (WellCon)cIt.next();
                if (wc.fun != desiredContact || !wa.poly.getBounds2D().contains(wc.ctr) || !wa.poly.contains(wc.ctr)) continue;
                wa.netNum = wc.netNum;
                found = true;
                break;
            }
            if (found || contactAction != 0) continue;
            ErrorLogger.MessageLog err2 = this.errorLogger.logError(noContactError, this.cell, 0);
            err2.addPoly(wa.poly, true, this.cell);
        }
        it3 = this.wellCons.iterator();
        while (it3.hasNext()) {
            ErrorLogger.MessageLog err3;
            WellCon wc = (WellCon)it3.next();
            if (wc.netNum == -1) {
                String errorMsg = "N-Well contact is floating";
                if (wc.fun == PrimitiveNode.Function.WELL) {
                    errorMsg = "P-Well contact is floating";
                }
                ErrorLogger.MessageLog err4 = this.errorLogger.logError(errorMsg, this.cell, 0);
                err4.addPoint(wc.ctr.getX(), wc.ctr.getY(), this.cell);
                continue;
            }
            if (wc.onProperRail) continue;
            if (wc.fun == PrimitiveNode.Function.WELL) {
                if (!ERC.isMustConnectPWellToGround()) continue;
                err3 = this.errorLogger.logError("P-Well contact not connected to ground", this.cell, 0);
                err3.addPoint(wc.ctr.getX(), wc.ctr.getY(), this.cell);
                continue;
            }
            if (!ERC.isMustConnectNWellToPower()) continue;
            err3 = this.errorLogger.logError("N-Well contact not connected to power", this.cell, 0);
            err3.addPoint(wc.ctr.getX(), wc.ctr.getY(), this.cell);
        }
        if (ERC.getNWellCheck() == 1 && foundNWell) {
            boolean found = false;
            it = this.wellCons.iterator();
            while (it.hasNext()) {
                WellCon wc = (WellCon)it.next();
                if (wc.fun != PrimitiveNode.Function.SUBSTRATE) continue;
                found = true;
                break;
            }
            if (!found) {
                err = this.errorLogger.logError("No N-Well contact found in this cell", this.cell, 0);
            }
        }
        if (ERC.getPWellCheck() == 1 && foundPWell) {
            boolean found = false;
            it = this.wellCons.iterator();
            while (it.hasNext()) {
                WellCon wc = (WellCon)it.next();
                if (wc.fun != PrimitiveNode.Function.WELL) continue;
                found = true;
                break;
            }
            if (!found) {
                err = this.errorLogger.logError("No P-Well contact found in this cell", this.cell, 0);
            }
        }
        if (ERC.isDRCCheck()) {
            HashMap<Layer, DRCRules.DRCRule> rulesCon = new HashMap<Layer, DRCRules.DRCRule>();
            HashMap<Layer, DRCRules.DRCRule> rulesNonCon = new HashMap<Layer, DRCRules.DRCRule>();
            Iterator it4 = this.wellAreas.iterator();
            while (it4.hasNext()) {
                WellArea wa = (WellArea)it4.next();
                Iterator oIt = this.wellAreas.iterator();
                while (oIt.hasNext()) {
                    int layertype;
                    double dist;
                    DRCRules.DRCRule rule;
                    Layer waLayer;
                    if (this.job != null && this.job.checkForAbort()) {
                        return 0;
                    }
                    WellArea oWa = (WellArea)oIt.next();
                    if (wa.index <= oWa.index || (waLayer = wa.poly.getLayer()) != oWa.poly.getLayer()) continue;
                    boolean con = false;
                    if (wa.netNum == oWa.netNum && wa.netNum >= 0) {
                        con = true;
                    }
                    DRCRules.DRCRule dRCRule = rule = con ? (DRCRules.DRCRule)rulesCon.get(waLayer) : (DRCRules.DRCRule)rulesNonCon.get(waLayer);
                    if (rule == null) {
                        rule = DRC.getSpacingRule(waLayer, waLayer, con, false, 0.0);
                        if (rule == null) {
                            System.out.println("Replace this");
                        }
                        if (con) {
                            rulesCon.put(waLayer, rule);
                        } else {
                            rulesNonCon.put(waLayer, rule);
                        }
                    }
                    if (rule == null || rule.value < 0.0 || wa.poly.getBounds2D().getMinX() > oWa.poly.getBounds2D().getMaxX() + rule.value || oWa.poly.getBounds2D().getMinX() > wa.poly.getBounds2D().getMaxX() + rule.value || wa.poly.getBounds2D().getMinY() > oWa.poly.getBounds2D().getMaxY() + rule.value || oWa.poly.getBounds2D().getMinY() > wa.poly.getBounds2D().getMaxY() + rule.value || !((dist = wa.poly.separation(oWa.poly)) > 0.0) || !(dist < rule.value) || (layertype = ERCWellCheck.getWellLayerType(waLayer)) == 0) continue;
                    ErrorLogger.MessageLog err5 = this.errorLogger.logError(waLayer.getName() + " areas too close (are " + TextUtils.formatDouble(dist, 1) + ", should be " + TextUtils.formatDouble(rule.value, 1) + ")", this.cell, 0);
                    err5.addPoly(wa.poly, true, this.cell);
                    err5.addPoly(oWa.poly, true, this.cell);
                }
            }
        }
        if (Main.getDebug()) {
            System.out.println("Free v/s Total Memory Intermediate step 2: " + Runtime.getRuntime().freeMemory() + " / " + Runtime.getRuntime().totalMemory());
        }
        if (ERC.isFindWorstCaseWell()) {
            double worstPWellDist = 0.0;
            Point2D worstPWellCon = null;
            Point2D worstPWellEdge = null;
            double worstNWellDist = 0.0;
            Point2D worstNWellCon = null;
            Point2D worstNWellEdge = null;
            Iterator it5 = this.wellAreas.iterator();
            while (it5.hasNext()) {
                WellArea wa = (WellArea)it5.next();
                int wellType = ERCWellCheck.getWellLayerType(wa.poly.getLayer());
                if (!ERCWellCheck.isERCLayerRelated(wa.poly.getLayer())) continue;
                PrimitiveNode.Function desiredContact = PrimitiveNode.Function.SUBSTRATE;
                if (wellType == 1) {
                    desiredContact = PrimitiveNode.Function.WELL;
                }
                Point2D[] points = wa.poly.getPoints();
                int count = points.length;
                for (int i = 0; i < count * 2; ++i) {
                    Point2D testPoint = null;
                    if (i < count) {
                        int prev = i - 1;
                        if (i == 0) {
                            prev = count - 1;
                        }
                        testPoint = new Point2D.Double((points[prev].getX() + points[i].getX()) / 2.0, (points[prev].getY() + points[i].getY()) / 2.0);
                    } else {
                        testPoint = points[i - count];
                    }
                    boolean first = true;
                    double bestDist = 0.0;
                    WellCon bestWc = null;
                    Iterator cIt = this.wellCons.iterator();
                    while (cIt.hasNext()) {
                        WellCon wc = (WellCon)cIt.next();
                        if (wc.fun != desiredContact || !wa.poly.getBounds2D().contains(wc.ctr) || !wa.poly.contains(wc.ctr)) continue;
                        double dist = testPoint.distance(wc.ctr);
                        if (first || dist < bestDist) {
                            bestDist = dist;
                            bestWc = wc;
                        }
                        first = false;
                    }
                    if (first) continue;
                    if (wellType == 1) {
                        if (!(bestDist > worstPWellDist)) continue;
                        worstPWellDist = bestDist;
                        worstPWellCon = bestWc.ctr;
                        worstPWellEdge = testPoint;
                        continue;
                    }
                    if (!(bestDist > worstNWellDist)) continue;
                    worstNWellDist = bestDist;
                    worstNWellCon = bestWc.ctr;
                    worstNWellEdge = testPoint;
                }
            }
            if (this.highlighter != null && (worstPWellDist > 0.0 || worstNWellDist > 0.0)) {
                this.highlighter.clear();
                if (worstPWellDist > 0.0) {
                    this.highlighter.addLine(worstPWellCon, worstPWellEdge, this.cell);
                    System.out.println("Farthest distance from a P-Well contact is " + worstPWellDist);
                }
                if (worstNWellDist > 0.0) {
                    this.highlighter.addLine(worstNWellCon, worstNWellEdge, this.cell);
                    System.out.println("Farthest distance from an N-Well contact is " + worstNWellDist);
                }
                this.highlighter.finished();
            }
        }
        long endTime = System.currentTimeMillis();
        int errorCount = this.errorLogger.getNumErrors();
        if (errorCount == 0) {
            System.out.println("No Well errors found (took " + TextUtils.getElapsedTime(endTime - startTime) + ")");
        } else {
            System.out.println("FOUND " + errorCount + " WELL ERRORS (took " + TextUtils.getElapsedTime(endTime - startTime) + ")");
        }
        if (Main.getDebug()) {
            System.out.println("Free v/s Total Memory Final Step: " + Runtime.getRuntime().freeMemory() + " / " + Runtime.getRuntime().totalMemory());
        }
        this.wellAreas.clear();
        this.wellCons.clear();
        this.doneCells.clear();
        this.cellMerges.clear();
        this.errorLogger.termLogging(true);
        return errorCount;
    }

    private static boolean isERCLayerRelated(Layer layer) {
        int type = ERCWellCheck.getWellLayerType(layer);
        return type == 1 || type == 2 || type == 3 || type == 4;
    }

    private static int getWellLayerType(Layer layer) {
        Layer.Function fun = layer.getFunction();
        int extra = layer.getFunctionExtras();
        if ((extra & 0x1000) != 0) {
            return 0;
        }
        if (fun == Layer.Function.WELLP) {
            return 1;
        }
        if (fun == Layer.Function.WELL || fun == Layer.Function.WELLN) {
            return 2;
        }
        if (fun == Layer.Function.IMPLANTP) {
            return 3;
        }
        if (fun == Layer.Function.IMPLANT || fun == Layer.Function.IMPLANTN) {
            return 4;
        }
        if (fun == Layer.Function.SUBSTRATE) {
            if ((extra & 0x40) != 0) {
                return 3;
            }
            return 4;
        }
        return 0;
    }

    static {
        ercLayers.add(Layer.Function.WELLP);
        ercLayers.add(Layer.Function.WELL);
        ercLayers.add(Layer.Function.WELLN);
        ercLayers.add(Layer.Function.SUBSTRATE);
        ercLayers.add(Layer.Function.IMPLANTP);
        ercLayers.add(Layer.Function.IMPLANT);
        ercLayers.add(Layer.Function.IMPLANTN);
    }

    private static class Visitor
    extends HierarchyEnumerator.Visitor {
        ERCWellCheck check;

        public Visitor(ERCWellCheck check) {
            this.check = check;
        }

        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            if (this.check.job != null && this.check.job.checkForAbort()) {
                return false;
            }
            Cell cell = info.getCell();
            GeometryHandler thisMerge = (GeometryHandler)this.check.cellMerges.get(cell);
            if (thisMerge == null) {
                thisMerge = this.check.newAlgorithm ? new PolyQTree(cell.getBounds()) : new PolyMerge();
                this.check.cellMerges.put(cell, thisMerge);
            }
            return true;
        }

        public void exitCell(HierarchyEnumerator.CellInfo info) {
            Iterator it;
            if (this.check.job != null && this.check.job.checkForAbort()) {
                return;
            }
            Cell cell = info.getCell();
            GeometryHandler thisMerge = (GeometryHandler)this.check.cellMerges.get(info.getCell());
            if (thisMerge == null) {
                throw new Error("wrong condition in ERCWellCheck.enterCell()");
            }
            if (this.check.doneCells.get(cell) == null) {
                it = cell.getArcs();
                while (it.hasNext()) {
                    ArcInst ai = (ArcInst)it.next();
                    Technology tech = ai.getProto().getTechnology();
                    Poly[] arcInstPolyList = tech.getShapeOfArc(ai, null, null, ercLayers);
                    int tot = arcInstPolyList.length;
                    for (int i = 0; i < tot; ++i) {
                        Poly poly = arcInstPolyList[i];
                        Layer layer = poly.getLayer();
                        Shape newElem = poly;
                        if (this.check.newAlgorithm) {
                            newElem = new PolyQTree.PolyNode(poly);
                        }
                        thisMerge.add(layer, newElem, this.check.newAlgorithm);
                    }
                }
            }
            this.check.doneCells.put(cell, cell);
            it = cell.getNodes();
            while (it.hasNext()) {
                GeometryHandler subMerge;
                NodeInst ni = (NodeInst)it.next();
                NodeProto subNp = ni.getProto();
                if (subNp instanceof PrimitiveNode || (subMerge = (GeometryHandler)this.check.cellMerges.get(subNp)) == null) continue;
                AffineTransform trans = ni.rotateOut();
                AffineTransform tTrans = ni.translateOut(trans);
                thisMerge.addAll(subMerge, tTrans);
            }
        }

        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            NodeProto subNp;
            boolean wellSubsContact;
            Cell cell = info.getCell();
            GeometryHandler thisMerge = (GeometryHandler)this.check.cellMerges.get(cell);
            NodeInst ni = no.getNodeInst();
            AffineTransform trans = ni.rotateOut();
            PrimitiveNode.Function fun = ni.getFunction();
            boolean bl = wellSubsContact = fun == PrimitiveNode.Function.WELL || fun == PrimitiveNode.Function.SUBSTRATE;
            if (NodeInst.isSpecialNode(ni)) {
                return false;
            }
            if (this.check.doneCells.get(cell) == null && (subNp = ni.getProto()) instanceof PrimitiveNode) {
                PrimitiveNode pNp = (PrimitiveNode)subNp;
                Technology tech = pNp.getTechnology();
                Poly[] nodeInstPolyList = tech.getShapeOfNode(ni, null, true, true, ercLayers);
                int tot = nodeInstPolyList.length;
                for (int i = 0; i < tot; ++i) {
                    Poly poly = nodeInstPolyList[i];
                    Layer layer = poly.getLayer();
                    poly.transform(trans);
                    Shape newElem = poly;
                    if (this.check.newAlgorithm) {
                        newElem = new PolyQTree.PolyNode(poly);
                    }
                    thisMerge.add(layer, newElem, this.check.newAlgorithm);
                }
            }
            if (wellSubsContact) {
                WellCon wc = new WellCon();
                wc.ctr = ni.getTrueCenter();
                trans.transform(wc.ctr, wc.ctr);
                info.getTransformToRoot().transform(wc.ctr, wc.ctr);
                wc.fun = fun;
                PortInst pi = ni.getOnlyPortInst();
                Netlist netList = info.getNetlist();
                Network net = netList.getNetwork(pi);
                wc.netNum = info.getNetID(net);
                wc.onProperRail = false;
                if (net != null) {
                    boolean searchWell = fun == PrimitiveNode.Function.WELL;
                    Network parentNet = net;
                    HierarchyEnumerator.CellInfo cinfo = info;
                    while (cinfo.getParentInst() != null) {
                        parentNet = cinfo.getNetworkInParent(parentNet);
                        cinfo = cinfo.getParentInfo();
                        if (parentNet != null || !Main.LOCALDEBUGFLAG) continue;
                        System.out.println("parentNet null in ERC. Stop loop?");
                    }
                    if (parentNet != null) {
                        Iterator it = parentNet.getExports();
                        while (!wc.onProperRail && it.hasNext()) {
                            Export exp = (Export)it.next();
                            if ((!searchWell || !exp.isGround()) && (searchWell || !exp.isPower())) continue;
                            wc.onProperRail = true;
                        }
                    }
                }
                this.check.wellCons.add(wc);
            }
            return true;
        }
    }

    private static class WellCheckJob
    extends Job {
        Cell cell;
        boolean newAlgorithm;
        Highlighter highlighter;

        protected WellCheckJob(Cell cell, boolean newAlgorithm, Highlighter highlighter) {
            super("ERC Well Check", ERC.tool, Job.Type.EXAMINE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.newAlgorithm = newAlgorithm;
            this.highlighter = highlighter;
            this.startJob();
        }

        public boolean doIt() {
            return ERCWellCheck.checkERCWell(this.cell, this, this.newAlgorithm, this.highlighter) == 0;
        }

        protected boolean checkForAbort() {
            if (this.getAborted()) {
                return true;
            }
            boolean abort = this.getScheduledToAbort();
            if (abort) {
                this.setAborted();
                this.setReportExecutionFlag(true);
                System.out.println("WellCheck aborted");
            }
            return abort;
        }
    }

    static class WellCon {
        Point2D ctr;
        int netNum;
        boolean onProperRail;
        PrimitiveNode.Function fun;

        WellCon() {
        }
    }

    static class WellArea {
        PolyBase poly;
        int netNum;
        int index;

        WellArea() {
        }
    }
}

