/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.prototype;

import com.sun.electric.database.text.Pref;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.user.User;
import java.util.HashMap;

public abstract class ArcProto {
    private static HashMap defaultWidthPrefs = new HashMap();
    private static HashMap defaultAnglePrefs = new HashMap();
    private static HashMap defaultRigidPrefs = new HashMap();
    private static HashMap defaultFixedAnglePrefs = new HashMap();
    private static HashMap defaultSlidablePrefs = new HashMap();
    private static HashMap defaultExtendedPrefs = new HashMap();
    private static HashMap defaultNegatedPrefs = new HashMap();
    private static HashMap defaultDirectionalPrefs = new HashMap();
    protected String protoName;
    protected Technology tech;
    protected double widthOffset;
    private int userBits = 0;
    private Function function = Function.UNKNOWN;
    private int tempInt;
    private int flagBits;
    private static final int CANWIPE = 64;
    private static final int CANCURVE = 128;
    private static final int AFUNCTION = 7936;
    private static final int AFUNCTIONSH = 8;
    private static final int AEDGESELECT = 0x400000;
    private static final int AINVISIBLE = 0x800000;
    private static final int ANOTUSED = Integer.MIN_VALUE;

    protected ArcProto() {
    }

    public String getName() {
        return this.protoName;
    }

    public Technology getTechnology() {
        return this.tech;
    }

    private Pref getArcProtoWidthPref(double factory) {
        Pref pref = (Pref)defaultWidthPrefs.get(this);
        if (pref == null) {
            pref = Pref.makeDoublePref("DefaultWidthFor" + this.protoName + "IN" + this.tech.getTechName(), Technology.getTechnologyPreferences(), factory);
            defaultWidthPrefs.put(this, pref);
        }
        return pref;
    }

    protected void setFactoryDefaultWidth(double defaultWidth) {
        this.getArcProtoWidthPref(defaultWidth);
    }

    public boolean setDefaultWidth(double defaultWidth) {
        return this.getArcProtoWidthPref(0.0).setDouble(defaultWidth);
    }

    public double getDefaultWidth() {
        return this.getArcProtoWidthPref(0.0).getDouble();
    }

    public void setWidthOffset(double widthOffset) {
        if (widthOffset < 0.0) {
            System.out.println("ArcProto " + this.tech.getTechName() + ":" + this.protoName + " has negative width offset");
            return;
        }
        this.widthOffset = widthOffset;
    }

    public double getWidthOffset() {
        return this.widthOffset;
    }

    public double getWidth() {
        return this.getDefaultWidth() - this.widthOffset;
    }

    private Pref getArcProtoBitPref(String what, HashMap map, boolean factory) {
        Pref pref = (Pref)map.get(this);
        if (pref == null) {
            pref = Pref.makeBooleanPref("Default" + what + "For" + this.protoName + "IN" + this.tech.getTechName(), User.tool.prefs, factory);
            map.put(this, pref);
        }
        return pref;
    }

    public void setFactoryRigid(boolean rigid) {
        this.getArcProtoBitPref("Rigid", defaultRigidPrefs, rigid);
    }

    public void setRigid(boolean rigid) {
        this.getArcProtoBitPref("Rigid", defaultRigidPrefs, false).setBoolean(rigid);
    }

    public boolean isRigid() {
        return this.getArcProtoBitPref("Rigid", defaultRigidPrefs, false).getBoolean();
    }

    public void setFactoryFixedAngle(boolean fixed) {
        this.getArcProtoBitPref("FixedAngle", defaultFixedAnglePrefs, fixed);
    }

    public void setFixedAngle(boolean fixed) {
        this.getArcProtoBitPref("FixedAngle", defaultFixedAnglePrefs, true).setBoolean(fixed);
    }

    public boolean isFixedAngle() {
        return this.getArcProtoBitPref("FixedAngle", defaultFixedAnglePrefs, true).getBoolean();
    }

    public void setFactorySlidable(boolean slidable) {
        this.getArcProtoBitPref("Slidable", defaultSlidablePrefs, slidable);
    }

    public void setSlidable(boolean slidable) {
        this.getArcProtoBitPref("Slidable", defaultSlidablePrefs, true).setBoolean(slidable);
    }

    public boolean isSlidable() {
        return this.getArcProtoBitPref("Slidable", defaultSlidablePrefs, true).getBoolean();
    }

    public void setFactoryExtended(boolean extended) {
        this.getArcProtoBitPref("Extended", defaultExtendedPrefs, extended);
    }

    public void setExtended(boolean extended) {
        this.getArcProtoBitPref("Extended", defaultExtendedPrefs, true).setBoolean(extended);
    }

    public boolean isExtended() {
        return this.getArcProtoBitPref("Extended", defaultExtendedPrefs, true).getBoolean();
    }

    public void setDirectional(boolean directional) {
        this.getArcProtoBitPref("Directional", defaultDirectionalPrefs, false).setBoolean(directional);
    }

    public boolean isDirectional() {
        return this.getArcProtoBitPref("Directional", defaultDirectionalPrefs, false).getBoolean();
    }

    public void setNotUsed() {
        this.userBits |= Integer.MIN_VALUE;
    }

    public void clearNotUsed() {
        this.userBits &= Integer.MAX_VALUE;
    }

    public boolean isNotUsed() {
        return (this.userBits & Integer.MIN_VALUE) != 0;
    }

    public void setArcInvisible(boolean invisible) {
        this.userBits = invisible ? (this.userBits |= 0x800000) : (this.userBits &= 0xFF7FFFFF);
    }

    public boolean isArcInvisible() {
        return (this.userBits & 0x800000) != 0;
    }

    public void setWipable() {
        this.userBits |= 0x40;
    }

    public void clearWipable() {
        this.userBits &= 0xFFFFFFBF;
    }

    public boolean isWipable() {
        return (this.userBits & 0x40) != 0;
    }

    public void setCurvable() {
        this.userBits |= 0x80;
    }

    public void clearCurvable() {
        this.userBits &= 0xFFFFFF7F;
    }

    public boolean isCurvable() {
        return (this.userBits & 0x80) != 0;
    }

    public void setEdgeSelect() {
        this.userBits |= 0x400000;
    }

    public void clearEdgeSelect() {
        this.userBits &= 0xFFBFFFFF;
    }

    public boolean isEdgeSelect() {
        return (this.userBits & 0x400000) != 0;
    }

    public void setFunction(Function function) {
        this.function = function;
    }

    public Function getFunction() {
        return this.function;
    }

    public void setFactoryAngleIncrement(int angle) {
        Pref pref = Pref.makeIntPref("DefaultAngleFor" + this.protoName + "IN" + this.tech.getTechName(), User.tool.prefs, angle);
        defaultAnglePrefs.put(this, pref);
    }

    public void setAngleIncrement(int angle) {
        Pref pref = (Pref)defaultAnglePrefs.get(this);
        if (pref == null) {
            return;
        }
        pref.setInt(angle);
    }

    public int getAngleIncrement() {
        Pref pref = (Pref)defaultAnglePrefs.get(this);
        if (pref == null) {
            return 90;
        }
        return pref.getInt();
    }

    public void setTempInt(int tempInt) {
        this.tempInt = tempInt;
    }

    public int getTempInt() {
        return this.tempInt;
    }

    public static ArcProto findArcProto(String line) {
        String withoutPrefix;
        Technology tech = Technology.getCurrent();
        int colon = line.indexOf(58);
        if (colon == -1) {
            withoutPrefix = line;
        } else {
            String prefix = line.substring(0, colon);
            Technology t = Technology.findTechnology(prefix);
            if (t != null) {
                tech = t;
            }
            withoutPrefix = line.substring(colon + 1);
        }
        PrimitiveArc ap = tech.findArcProto(withoutPrefix);
        if (ap != null) {
            return ap;
        }
        return null;
    }

    public String describe() {
        String description = "";
        if (this instanceof PrimitiveArc) {
            Technology tech = ((PrimitiveArc)this).getTechnology();
            if (Technology.getCurrent() != tech) {
                description = description + tech.getTechName() + ":";
            }
        }
        description = description + this.protoName;
        return description;
    }

    public String toString() {
        return "ArcProto " + this.describe();
    }

    public static class Function {
        private final String name;
        private int level;
        private static HashMap metalLayers = new HashMap();
        private static HashMap polyLayers = new HashMap();
        public static final Function UNKNOWN = new Function("unknown", 0, 0);
        public static final Function METAL1 = new Function("metal-1", 1, 0);
        public static final Function METAL2 = new Function("metal-2", 2, 0);
        public static final Function METAL3 = new Function("metal-3", 3, 0);
        public static final Function METAL4 = new Function("metal-4", 4, 0);
        public static final Function METAL5 = new Function("metal-5", 5, 0);
        public static final Function METAL6 = new Function("metal-6", 6, 0);
        public static final Function METAL7 = new Function("metal-7", 7, 0);
        public static final Function METAL8 = new Function("metal-8", 8, 0);
        public static final Function METAL9 = new Function("metal-9", 9, 0);
        public static final Function METAL10 = new Function("metal-10", 10, 0);
        public static final Function METAL11 = new Function("metal-11", 11, 0);
        public static final Function METAL12 = new Function("metal-12", 12, 0);
        public static final Function POLY1 = new Function("polysilicon-1", 0, 1);
        public static final Function POLY2 = new Function("polysilicon-2", 0, 2);
        public static final Function POLY3 = new Function("polysilicon-3", 0, 3);
        public static final Function DIFF = new Function("diffusion", 0, 0);
        public static final Function DIFFP = new Function("p-diffusion", 0, 0);
        public static final Function DIFFN = new Function("n-diffusion", 0, 0);
        public static final Function DIFFS = new Function("substrate-diffusion", 0, 0);
        public static final Function DIFFW = new Function("well-diffusion", 0, 0);
        public static final Function BUS = new Function("bus", 0, 0);
        public static final Function UNROUTED = new Function("unrouted", 0, 0);
        public static final Function NONELEC = new Function("nonelectrical", 0, 0);

        private Function(String name, int metalLevel, int polyLevel) {
            this.name = name;
            this.level = 0;
            if (metalLevel != 0) {
                this.level = metalLevel;
                metalLayers.put(new Integer(this.level), this);
            }
            if (polyLevel != 0) {
                this.level = polyLevel;
                polyLayers.put(new Integer(this.level), this);
            }
        }

        public String toString() {
            return this.name;
        }

        public int getLevel() {
            return this.level;
        }

        public static Function getMetal(int level) {
            Function func = (Function)metalLayers.get(new Integer(level));
            return func;
        }

        public static Function getPoly(int level) {
            Function func = (Function)polyLayers.get(new Integer(level));
            return func;
        }

        public boolean isMetal() {
            return this == METAL1 || this == METAL2 || this == METAL3 || this == METAL4 || this == METAL5 || this == METAL6 || this == METAL7 || this == METAL8 || this == METAL9 || this == METAL10 || this == METAL11 || this == METAL12;
        }

        public boolean isPoly() {
            return this == POLY1 || this == POLY2 || this == POLY3;
        }

        public boolean isDiffusion() {
            return this == DIFF || this == DIFFP || this == DIFFN || this == DIFFS || this == DIFFW;
        }
    }
}

